-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Data source:  Raytheon Phase X Data Package
-- Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--               Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------

generic

   type Voltage_Type is digits <>;
   Package_Name : in String;

package Auxiliary_Battery_Mount_G is

   type Instance is private;

   procedure Update
     (An_Instance                  : in out Instance;
      Volts_28_In                  : in     Voltage_Type;
      Volts_5_In                   : in     Boolean;
      Auxiliary_Battery_Voltage_In : in     Voltage_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Lights_Out
     (An_Instance : in Instance)
      return Boolean;
   function Voltage_Out
     (An_Instance : in Instance)
      return Voltage_Type;
   function Voltage_In
     (An_Instance : in Instance)
      return Voltage_Type;
   function Is_Powered
     (An_Instance : in Instance)
      return Boolean;

private

   type Instance is
      record
         Voltage_In   : Voltage_Type;
         Voltage_Out  : Voltage_Type;
         Is_Powered   : Boolean;
         Converter_In : Boolean;
         Lights_Out   : Boolean;
      end record;

end Auxiliary_Battery_Mount_G;

