-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Auxiliary_Battery_Mount_G is

   procedure Update
     (An_Instance                  : in out Instance;
      Volts_28_In                  : in     Voltage_Type;
      Volts_5_In                   : in     Boolean;
      Auxiliary_Battery_Voltage_In : in     Voltage_Type)
   is

      Voltage_In   : Voltage_Type renames An_Instance.Voltage_In;
      Voltage_Out  : Voltage_Type renames An_Instance.Voltage_Out;
      Is_Powered   : Boolean      renames An_Instance.Is_Powered;
      Converter_In : Boolean      renames An_Instance.Converter_In;
      Lights_Out   : Boolean      renames An_Instance.Lights_Out;

   begin

      Voltage_In   := Volts_28_In;

      if Volts_28_In > Auxiliary_Battery_Voltage_In then
         Voltage_Out := Volts_28_In;
      else
         Voltage_Out := Auxiliary_Battery_Voltage_In;
      end if;

      Is_Powered   := Voltage_Out > 5.0;
      Converter_In := Volts_5_In;
      Lights_Out   := Converter_In;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Voltage_In   := 0.0;
      An_Instance.Voltage_Out  := 0.0;
      An_Instance.Is_Powered   := False;
      An_Instance.Converter_In := False;
      An_Instance.Lights_Out   := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Lights_Out
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Lights_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Lights_Out()");
         raise;
   end Lights_Out;

   function Voltage_Out
     (An_Instance : in Instance)
     return Voltage_Type
   is
   begin
      return An_Instance.Voltage_Out;
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage_Out()");
         raise;
   end Voltage_Out;

   function Voltage_In
     (An_Instance : in Instance)
     return Voltage_Type
   is
   begin
      return An_Instance.Voltage_In;
   exception
      when others =>
         Log.Report(Package_Name & ".Voltage_In()");
         raise;
   end Voltage_In;

   function Is_Powered
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Powered;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Powered()");
         raise;
   end Is_Powered;

end Auxiliary_Battery_Mount_G;

