-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
 with Coordinate_Types;
--generic
--  White_Noise_Array_Size : Integer;
--  Sine_Array_Size        : Integer;

--  White_Noise_Array_Type is array ( 1 .. White_Noise_Array_Size) of Float;
--  Sine_Array_Type is array ( 1 .. Sine_Array_Size) of Float;


package Vibrations is

    type Instance is private;

    --| Assign_Sine_Wave and Assign_White_Noise, method to be only for
    --| The_Aircraft_Vibration instance, to assign the sum of the vibration.
    procedure Set_Sine_Wave
        (A_Vibration_Magnitude   :in     Float;
         A_Sine_Wave_Multipliers :in     Coordinate_Types.Array_Type;
         An_Instance             :in out Instance);

--    procedure Assign_Sine_Wave(Init_Sine_Vibration :in     Coordinate_Types.Array_Type;
--                               An_Instance                 :in out Instance);

    function Get_Sine_Wave(An_Instance :in Instance) return Coordinate_Types.Array_Type;

    procedure Set_White_Noise
        (A_Vibration_Magnitude     :in     Float;
         A_White_Noise_Multipliers :in     Coordinate_Types.Array_Type;
         An_Instance             :in out Instance);

--    procedure Assign_White_Noise(Init_White_Noise_Vibration :in     Coordinate_Types.Array_Type;
--                                 An_Instance                        :in out Instance);

    function Get_White_Noise(An_Instance :in Instance) return Coordinate_Types.Array_Type;

private
    type Instance is
        record
            The_Sine_Vibration        : Coordinate_Types.Array_Type(1..20);
            The_White_Noise_Vibration : Coordinate_Types.Array_Type(1..05);
        end record;
end Vibrations;
