-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
package body Vibrations is

    --| Assign_Sine_Wave and Assign_White_Noise, method to be only for
    --| The_Aircraft_Vibration instance, to assign the sum of the vibration.
    procedure Set_Sine_Wave
        (A_Vibration_Magnitude   :in     Float;
         A_Sine_Wave_Multipliers :in     Coordinate_Types.Array_Type;
         An_Instance             :in out Instance) is
    begin
        for i in An_Instance.The_Sine_Vibration'range loop
            An_Instance.The_Sine_Vibration(i) := A_Vibration_Magnitude * A_Sine_Wave_Multipliers(i);
        end loop;
   end Set_Sine_Wave;

--    procedure Assign_Sine_Wave(Init_Sine_Vibration :in     Coordinate_Types.Array_Type;
--                               An_Instance                 :in out Instance) is
--    begin
--        An_Instance.The_Sine_Vibration := Init_Sine_Vibration;
--    end Assign_Sine_Wave;

    function Get_Sine_Wave(An_Instance :in Instance) return Coordinate_Types.Array_Type is
    begin
        return An_Instance.The_Sine_Vibration;
    end Get_Sine_Wave;

    procedure Set_White_Noise
        (A_Vibration_Magnitude     :in     Float;
         A_White_Noise_Multipliers :in     Coordinate_Types.Array_Type;
         An_Instance             :in out Instance) is
    begin
        for i in An_Instance.The_White_Noise_Vibration'range loop
            An_Instance.The_White_Noise_Vibration(i) := A_Vibration_Magnitude * A_White_Noise_Multipliers(i);
        end loop;
   end Set_White_Noise;

--    procedure Assign_White_Noise(Init_White_Noise_Vibration :in     Coordinate_Types.Array_Type;
--                               An_Instance                 :in out Instance) is
--    begin
--        An_Instance.The_White_Noise_Vibration := Init_White_Noise_Vibration;
--    end Assign_White_Noise;

    function Get_White_Noise(An_Instance :in Instance) return Coordinate_Types.Array_Type is
    begin
        return An_Instance.The_White_Noise_Vibration;
    end Get_White_Noise;

    procedure Initialize
      (An_Instance : in out Instance) is
      Sine_Vibration        : Coordinate_Types.Array_Type(1..20) := (others => 0.0);
      White_Vibration       : Coordinate_Types.Array_Type(1..5) := (others => 0.0);
    begin
      An_Instance.The_White_Noise_Vibration := White_Vibration;
      An_Instance.The_Sine_Vibration := Sine_Vibration;
    end Initialize;

end Vibrations;
