-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;

package body Pedals is

    procedure Set_Position
        (Position            :in     Angle_Types.Degrees;
         DRDPED_INV_Table    :in out Interpolation_Table.Singly_Indexed.Instance;
         An_Instance         :in out Instance) is
    begin
        An_Instance.The_Position := Interpolation_Table.Singly_Indexed.Interpolate
                                   (Position,DRDPED_INV_Table'access);
    end Set_Position;

    procedure Assign_Position (Position       :in     Angle_Types.Degrees;
                               An_Instance    :in out Instance) is
    begin
        An_Instance.The_Position := Position;
    end Assign_Position;

    function Get_Position(An_Instance :in Instance) return Angle_Types.Degrees is
    begin
        return An_Instance.The_Position;
    end Get_Position;

    procedure Assign_force(force       :in     Force_Types.lbf;
                           An_Instance :in out Instance) is
    begin
        An_Instance.The_force := force;
    end Assign_force;

    function Get_force(An_Instance :in Instance) return Force_Types.Lbf is
    begin
        return An_Instance.The_force;
    end Get_force;
end Pedals;
