-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Simulation_Dictionary;

package JPATS_DCLS_Types is

   File_Path  : String := Simulation_Dictionary.Lookup ("Controls_Dir");
   Column_Arm_Length   : Length_Types.Feet   := 1.508_333; --| | 18.1 inches.

   Runway_Rumble_Sine_Multiplier             : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.050,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Runway_Rumble_White_Noise_Multiplier      : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.020);

   Speedbrake_Sine_Multiplier                : Coordinate_Types.Array_Type :=
     (0.000,  0.0000,  0.000,  0.000,  0.000,
      0.000,  0.0000,  0.000,  0.000,  0.000,
      0.000,  0.0000,  0.000,  0.000,  10.000,
      0.000,  0.0000,  0.000,  0.000,  0.000);
   Speedbrake_White_Noise_Multiplier         : Coordinate_Types.Array_Type :=
     (0.0000,  0.000,  0.000,  0.000,  4.000);

   Wheel_Scuffing_Sine_Multiplier            : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Wheel_Scuffing_White_Noise_Multiplier     : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000);

   Landing_Gear_Sine_Multiplier              : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.020,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.048,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Landing_Gear_White_Noise_Multiplier       : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.006,  0.000);

   Stall_Sine_Multiplier                     : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.022,  0.000,  0.000,  0.022,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Stall_White_Noise_Multiplier              : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.022);

   Engine_Sine_Multiplier                    : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Engine_White_Noise_Multiplier             : Coordinate_Types.Array_Type :=
     (0.00000,  0.00000,  0.00000,  0.0000,  0.0000);

   Flap_Sine_Multiplier                      : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.250,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Flap_White_Noise_Multiplier               : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.100);

   Turbulence_Sine_Multiplier                : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Turbulence_White_Noise_Multiplier         : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.001,  0.003);

   Structural_Damage_Sine_Multiplier         : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000,
      0.000,  0.000,  0.000,  0.133,  0.000,
      0.000,  0.000,  0.000,  0.000,  0.000);
   Structural_Damage_White_Noise_Multiplier  : Coordinate_Types.Array_Type :=
     (0.000,  0.000,  0.000,  0.000,  0.030);

end JPATS_DCLS_Types;
