-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:   Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Coordinate_Types;
with Force_Types;
with Torque_Types;
with Angle_Types;

package JPATS_DCLS is

    function Lat_stick_Pos return Angle_Types.degrees;
    function Lat_Stick_actual_Pos return Angle_Types.Degrees;
    function Get_Spring_Hm return Torque_Types.Ft_Lbf;
    function Lat_stick_Force return Force_Types.Lbf;
    function Long_stick_Pos return Angle_Types.degrees;
    function Long_Stick_actual_Pos return Angle_Types.Degrees;
    function Get_Bob_Weight_Force return Torque_Types.Ft_Lbf;
    function Long_stick_Force return Force_Types.Lbf;
    function Get_Left_Aileron_Position return Angle_Types.degrees;
    function Get_Right_Aileron_Position return Angle_Types.degrees;
    function Get_Elev_Pos return Angle_Types.degrees;
    function Get_Rudder_Position return Angle_Types.degrees;
    function Get_Left_Aileron_Gearing return Float;
    function Get_Right_Aileron_Gearing return Float;
    function Get_Elevator_Gearing return Float;
    function Get_Rudder_Gearing return Float;
    function Get_Pedal_Position return Angle_Types.degrees;
    function Get_Actual_Pedal_Position return Angle_Types.Degrees;
    function Get_Pedal_Force return Force_Types.Lbf;
    function Get_Flap_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Flap_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Get_Engine_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Engine_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Get_Speedbrake_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Speedbrake_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Get_Runway_Rumble_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Runway_Rumble_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Get_Wheel_Scuffing_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Wheel_Scuffing_Vibration_White_Noise return Coordinate_Types.Array_type;
    function Get_Landing_Gear_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Landing_Gear_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Get_Stall_Vibration_Sine_Wave return Coordinate_Types.Array_Type;
    function Get_Stall_Vibration_White_Noise return Coordinate_Types.Array_Type;
    function Left_Brake_Pos return Float;
    function Actual_Left_Brake_pos return Float;
    function Right_Brake_Pos return Float;
    function Actual_right_Brake_pos return Float;
    function Left_Brake_force return Float;
    function Right_Brake_force return Float;
    function avg_ail return Float;
    function Seat_position return Float;
    function Seat_accelerometer return Float;
    function Phase_lag return Float;
    function Signal_Loss  return Float;
    function debug1 return Float;
    function debug2 return Float;
    function debug3 return Float;
    function debug4 return Float;
    function debug5 return Float;
    function debug6 return Float;
    function debug7 return Float;
    function debug8 return Float;
    function debug9 return Float;
    function debug10 return Float;
    procedure Set_Filter;
end JPATS_DCLS;







