-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:   Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Column_Movement;
with Control_Surface;
with Gearing;
with Pedals;
with JPATS_DCLS.Container;
with Vibrations;
with Log;

with Limit_G;

package body JPATS_DCLS is

   function Lat_stick_Pos return Angle_Types.degrees is
   begin
      return Column_Movement.Get_Position
        (Container.This_Subsystem.The_Lateral_Column_Movement);
   end lat_stick_Pos;

   function Lat_Stick_actual_Pos return Angle_Types.degrees is
   begin
      return Container.This_Io_Interface.DCI_LATL_SERVO ;
   end Lat_Stick_Actual_Pos;

   function Get_Spring_Hm return Torque_Types.Ft_Lbf is
   begin
      return Column_Movement.Get_Spring_Hm
        (Container.This_Subsystem.The_Lateral_Column_Movement);
   end Get_Spring_Hm;

   function Lat_stick_Force return Force_Types.Lbf is
   begin
      return Column_Movement.Get_Pilot_Force
        (Container.This_Subsystem.The_Lateral_Column_Movement);
   end Lat_stick_Force;

   function Long_stick_Pos return Angle_Types.degrees is
   begin
      return Column_Movement.Get_Position
        (Container.This_Subsystem.The_Longitudinal_Column_Movement);
   end Long_stick_Pos;

   function Long_Stick_actual_Pos return Angle_Types.degrees is
   begin
      return Container.This_Io_Interface.DCI_LONG_SERVO ;
   end Long_Stick_Actual_Pos;

   function Get_Bob_Weight_Force return Torque_Types.Ft_Lbf is
   begin
      return Column_Movement.Get_Bob_Weight_Force
        (Container.This_Subsystem.The_Longitudinal_Column_Movement);
   end Get_Bob_Weight_Force;

   function Long_stick_Force return Force_Types.Lbf is
   begin
      return Column_Movement.Get_Pilot_Force
        (Container.This_Subsystem.The_Longitudinal_Column_Movement);
   end Long_stick_Force;

   function Get_Left_Aileron_Position return Angle_Types.degrees is
   begin
      return Control_Surface.Get_Position
        (Container.This_Subsystem.The_Left_Aileron_Position);
   end Get_Left_Aileron_Position;

   function Get_Right_Aileron_Position return Angle_Types.degrees is
   begin
      return Control_Surface.Get_Position
        (Container.This_Subsystem.The_Right_Aileron_Position);
   end Get_Right_Aileron_Position;

   function Get_Elev_Pos return Angle_Types.degrees is
   begin
      return -Control_Surface.Get_Position
        (Container.This_Subsystem.The_Elevator_Position);
   end Get_Elev_Pos;

   function Get_Rudder_Position return Angle_Types.degrees is
   begin
      return -Control_Surface.Get_Position
        (Container.This_Subsystem.The_Rudder_Position);
   end Get_Rudder_Position;

   function Get_Left_Aileron_Gearing return Float is
   begin
      return Gearing.Get_Gearing
        (Container.This_Subsystem.The_Left_Aileron_Gearing);
   end Get_Left_Aileron_Gearing;

   function Get_Right_Aileron_Gearing return Float is
   begin
      return Gearing.Get_Gearing
        (Container.This_Subsystem.The_Right_Aileron_Gearing);
   end Get_Right_Aileron_Gearing;

    function Get_Elevator_Gearing return Float is
    begin
       return Gearing.Get_Gearing
         (Container.This_Subsystem.The_Elevator_Gearing);
    end Get_Elevator_Gearing;

    function Get_Rudder_Gearing return Float is
    begin
       return Gearing.Get_Gearing
         (Container.This_Subsystem.The_Rudder_Gearing);
    end Get_Rudder_Gearing;

    function Get_Pedal_Position return Angle_Types.degrees is
    begin
       return Pedals.Get_Position
         (Container.This_Subsystem.The_Pedals);
    end Get_Pedal_Position;

    function Get_Actual_Pedal_Position return Angle_Types.degrees is
    begin
       return Container.This_Io_Interface.DCI_DIRC_SERVO;
    end Get_Actual_Pedal_Position;

    function Get_pedal_Force return Force_Types.Lbf is
    begin
       return Pedals.Get_Force
         (Container.This_Subsystem.The_Pedals);
    end Get_Pedal_Force;

    function Get_Flap_Vibration_Sine_Wave return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Flap_Vibration);
    end Get_Flap_Vibration_Sine_Wave;

    function Get_Flap_Vibration_White_Noise return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Flap_Vibration);
    end Get_Flap_Vibration_White_Noise;

    function Get_Engine_Vibration_Sine_Wave return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Engine_Vibration);
    end Get_Engine_Vibration_Sine_Wave;

    function Get_Engine_Vibration_White_Noise return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Engine_Vibration);
    end Get_Engine_Vibration_White_Noise;

    function Get_Speedbrake_Vibration_Sine_Wave return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Speedbrake_Vibration);
    end Get_Speedbrake_Vibration_Sine_Wave;

    function Get_Speedbrake_Vibration_White_Noise return
      Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Speedbrake_Vibration);
    end Get_Speedbrake_Vibration_White_Noise;

    function Get_Runway_Rumble_Vibration_Sine_Wave return
      Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Runway_Rumble_Vibration);
    end Get_Runway_Rumble_Vibration_Sine_Wave;

    function Get_Runway_Rumble_Vibration_White_Noise
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Runway_Rumble_Vibration);
    end Get_Runway_Rumble_Vibration_White_Noise;

    function Get_Wheel_Scuffing_Vibration_Sine_Wave
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Wheel_Scuffing_Vibration);
    end Get_Wheel_Scuffing_Vibration_Sine_Wave;

    function Get_Wheel_Scuffing_Vibration_White_Noise
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Wheel_Scuffing_Vibration);
    end Get_Wheel_Scuffing_Vibration_White_Noise;

    function Get_Landing_Gear_Vibration_Sine_Wave
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Landing_Gear_Vibration);
    end Get_Landing_Gear_Vibration_Sine_Wave;

    function Get_Landing_Gear_Vibration_White_Noise
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Landing_Gear_Vibration);
    end Get_Landing_Gear_Vibration_White_Noise;

    function Get_Stall_Vibration_Sine_Wave
      return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_Sine_Wave
         (Container.This_Subsystem.The_Stall_Vibration);
    end Get_Stall_Vibration_Sine_Wave;

    function Get_Stall_Vibration_White_Noise return Coordinate_Types.Array_Type is
    begin
       return Vibrations.Get_White_Noise
         (Container.This_Subsystem.The_Stall_Vibration);
    end Get_Stall_Vibration_White_Noise;

    function Left_Brake_pos return Float is
    begin
       return Container.This_Io_interface.Dci_Tbkl_position;
    end Left_Brake_pos;

    function Actual_Left_Brake_pos return Float is
    begin
       return Container.This_Io_interface.Dci_Tbkl_servo;
    end Actual_Left_Brake_pos;

     function right_Brake_pos return Float is
     begin
        return Container.This_Io_interface.Dci_Tbkr_position;
     end right_Brake_pos;

     function Actual_right_Brake_pos return Float is
     begin
        return Container.This_Io_interface.Dci_Tbkr_servo;
     end Actual_right_Brake_pos;

     function Left_Brake_force return Float is
     begin
        return Container.This_Io_interface.Dci_Tbkl_force;
     end Left_Brake_force;

     function right_Brake_force return Float is
     begin
        return Container.This_Io_interface.Dci_Tbkr_force;
     end right_Brake_force;

     function avg_ail return Float is
     begin
        return Container.This_Io_Interface.Dci_Latl_Surf_Position;
     end avg_ail;


     function Seat_position return Float is
     begin
        return Container.This_Io_Interface.Dci_Seat_Cyl_Pos;
     end Seat_position;

     function Seat_accelerometer return Float is
     begin
        return Container.This_Io_Interface.Dci_Seat_accelerometer;
     end Seat_accelerometer;

     function Phase_lag return Float is
     begin
        return Container.This_Io_Interface.Dci_Test_Phase_lag;
     end Phase_Lag;

     function Signal_Loss  return Float is
     begin
        return Container.This_Io_Interface.Dci_Test_MAG_LOSS;
     end Signal_Loss;

    function Debug1 return Float is
    begin
       return Container.This_Subsystem.debug1;
    end debug1;

    function Debug2 return Float is
    begin
       return Container.This_Subsystem.debug2;
    end debug2;

    function Debug3 return Float is
    begin
       return Container.This_Subsystem.debug3;
    end debug3;

    function Debug4 return Float is
    begin
       return Container.This_Subsystem.debug4;
    end debug4;

    function Debug5 return Float is
    begin
       return Container.This_Subsystem.debug5;
    end debug5;

    function Debug6 return Float is
    begin
       return Container.This_Subsystem.debug6;
    end debug6;

    function Debug7 return Float is
    begin
       return Container.This_Subsystem.debug7;
    end debug7;

    function Debug8 return Float is
    begin
       return Container.This_Subsystem.debug8;
    end debug8;

    function Debug9 return Float is
    begin
       return Container.This_Subsystem.debug9;
    end debug9;

    function Debug10 return Float is
    begin
       return Container.This_Subsystem.debug10;
    end debug10;

    procedure Set_Filter is
       --| set 10 seconds dcls filtering
       --| with first order filter of constant time : 0.4*dt
       --| steady state will be attained at +- 7.5 seconds.
    begin
       Container.Misc_Timer := 0.02;
    exception
       when others =>
          Log.Report("Jpats_dcls.Set_Dcls_Filtering()");
          raise;
    end Set_Filter;

end JPATS_DCLS;







