-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ethan Brown
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_dcls.Container,
  JPATS_IOS_Interface,
  Log;

package body JPATS_dcls.Ios_If is

   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   Temp_Int : Integer;

   procedure Set_dcls_float_01 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.dcls_Float_01 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_01;

   procedure Set_dcls_float_02 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_02 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_02;

   procedure Set_dcls_float_03 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_03 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_03;

   procedure Set_dcls_float_04 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_04 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_04;

   procedure Set_dcls_float_05 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_05 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_05;

   procedure Set_dcls_float_06 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_06 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_06;

   procedure Set_dcls_float_07 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_07 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_07;

   procedure Set_dcls_float_08 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_08 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_08;

   procedure Set_dcls_float_09 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_09 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_09;

   procedure Set_dcls_float_10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_10 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_10;

   procedure Set_dcls_float_11 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_11 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_11;

   procedure Set_dcls_float_12 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_12 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_12;

   procedure Set_dcls_float_13 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_13 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_13;

   procedure Set_dcls_float_14 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_14 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_14;

   procedure Set_dcls_float_15 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_15 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_15;

   procedure Set_dcls_float_16 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_16 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_16;

   procedure Set_dcls_float_17 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_17 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_17;

   procedure Set_dcls_float_18 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_18 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_18;

   procedure Set_dcls_float_19 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_19 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_19;

   procedure Set_dcls_float_20 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_20 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_20;

   procedure Set_dcls_float_21 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_21 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_21;

   procedure Set_dcls_float_22 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_22 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_22;

   procedure Set_dcls_float_23 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_23 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_23;

   procedure Set_dcls_float_24 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_24 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_24;

   procedure Set_dcls_float_25 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_25 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_25;

   procedure Set_dcls_float_26 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_26 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_26;

   procedure Set_dcls_float_27 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_27 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_27;

   procedure Set_dcls_float_28 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_28 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_28;

   procedure Set_dcls_float_29 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_29 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_29;

   procedure Set_dcls_float_30 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Float_30 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_dcls_float_30;

   procedure Set_dcls_int_01 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_01 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_01;

   procedure Set_dcls_int_02 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_02 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_02;

   procedure Set_dcls_int_03 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_03 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_03;

   procedure Set_dcls_int_04 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_04 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_04;

   procedure Set_dcls_int_05 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_05 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_05;

   procedure Set_dcls_int_06 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_06 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_06;

   procedure Set_dcls_int_07 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_07 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_07;

   procedure Set_dcls_int_08 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_08 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_08;

   procedure Set_dcls_int_09 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_09 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_09;

   procedure Set_dcls_int_10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Int_10 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_dcls_int_10;

   procedure Set_dcls_bool_01 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_01 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_01;

   procedure Set_dcls_bool_02 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_02 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_02;

   procedure Set_dcls_bool_03 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_03 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_03;

   procedure Set_dcls_bool_04 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_04 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_04;

   procedure Set_dcls_bool_05 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_05 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_05;

   procedure Set_dcls_bool_06 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_06 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_06;

   procedure Set_dcls_bool_07 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_07 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_07;

   procedure Set_dcls_bool_08 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_08 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_08;

   procedure Set_dcls_bool_09 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_09 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_09;

   procedure Set_dcls_bool_10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Dcls_Bool_10 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_dcls_bool_10;

   procedure Register_Ios_Variables  is
   begin

      JPATS_IOS_Interface.Register
        (Name => "dcls_float_01",
         Variable => IOS.Dcls_Float_01'Address,
         Set_Routine => Set_Dcls_Float_01'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_02",
         Variable => IOS.Dcls_Float_02'Address,
         Set_Routine => Set_Dcls_Float_02'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_03",
         Variable => IOS.Dcls_Float_03'Address,
         Set_Routine => Set_Dcls_Float_03'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_04",
         Variable => IOS.Dcls_Float_04'Address,
         Set_Routine => Set_Dcls_Float_04'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_05",
         Variable => IOS.Dcls_Float_05'Address,
         Set_Routine => Set_Dcls_Float_05'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_06",
         Variable => IOS.Dcls_Float_06'Address,
         Set_Routine => Set_Dcls_Float_06'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_07",
         Variable => IOS.Dcls_Float_07'Address,
         Set_Routine => Set_Dcls_Float_07'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_08",
         Variable => IOS.Dcls_Float_08'Address,
         Set_Routine => Set_Dcls_Float_08'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_09",
         Variable => IOS.Dcls_Float_09'Address,
         Set_Routine => Set_Dcls_Float_09'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_10",
         Variable => IOS.Dcls_Float_10'Address,
         Set_Routine => Set_Dcls_Float_10'access );

      JPATS_IOS_Interface.Register
        (Name => "dcls_float_11",
         Variable => IOS.Dcls_Float_11'Address,
         Set_Routine => Set_Dcls_Float_11'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_12",
         Variable => IOS.Dcls_Float_12'Address,
         Set_Routine => Set_Dcls_Float_12'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_13",
         Variable => IOS.Dcls_Float_13'Address,
         Set_Routine => Set_Dcls_Float_13'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_14",
         Variable => IOS.Dcls_Float_14'Address,
         Set_Routine => Set_Dcls_Float_14'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_15",
         Variable => IOS.Dcls_Float_15'Address,
         Set_Routine => Set_Dcls_Float_15'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_16",
         Variable => IOS.Dcls_Float_16'Address,
         Set_Routine => Set_Dcls_Float_16'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_17",
         Variable => IOS.Dcls_Float_17'Address,
         Set_Routine => Set_Dcls_Float_17'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_18",
         Variable => IOS.Dcls_Float_18'Address,
         Set_Routine => Set_Dcls_Float_18'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_19",
         Variable => IOS.Dcls_Float_19'Address,
         Set_Routine => Set_Dcls_Float_19'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_20",
         Variable => IOS.Dcls_Float_20'Address,
         Set_Routine => Set_Dcls_Float_20'access );

      JPATS_IOS_Interface.Register
        (Name => "dcls_float_21",
         Variable => IOS.Dcls_Float_21'Address,
         Set_Routine => Set_Dcls_Float_21'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_22",
         Variable => IOS.Dcls_Float_22'Address,
         Set_Routine => Set_Dcls_Float_22'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_23",
         Variable => IOS.Dcls_Float_23'Address,
         Set_Routine => Set_Dcls_Float_23'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_24",
         Variable => IOS.Dcls_Float_24'Address,
         Set_Routine => Set_Dcls_Float_24'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_25",
         Variable => IOS.Dcls_Float_25'Address,
         Set_Routine => Set_Dcls_Float_25'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_26",
         Variable => IOS.Dcls_Float_26'Address,
         Set_Routine => Set_Dcls_Float_26'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_27",
         Variable => IOS.Dcls_Float_27'Address,
         Set_Routine => Set_Dcls_Float_27'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_28",
         Variable => IOS.Dcls_Float_28'Address,
         Set_Routine => Set_Dcls_Float_28'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_29",
         Variable => IOS.Dcls_Float_29'Address,
         Set_Routine => Set_Dcls_Float_29'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_float_30",
         Variable => IOS.Dcls_Float_30'Address,
         Set_Routine => Set_Dcls_Float_30'access );

      JPATS_IOS_Interface.Register
        (Name => "dcls_int_01",
         Variable => IOS.Dcls_Int_01'Address,
         Set_Routine => Set_Dcls_Int_01'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_02",
         Variable => IOS.Dcls_Int_02'Address,
         Set_Routine => Set_Dcls_Int_02'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_03",
         Variable => IOS.Dcls_Int_03'Address,
         Set_Routine => Set_Dcls_Int_03'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_04",
         Variable => IOS.Dcls_Int_04'Address,
         Set_Routine => Set_Dcls_Int_04'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_05",
         Variable => IOS.Dcls_Int_05'Address,
         Set_Routine => Set_Dcls_Int_05'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_06",
         Variable => IOS.Dcls_Int_06'Address,
         Set_Routine => Set_Dcls_Int_06'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_07",
         Variable => IOS.Dcls_Int_07'Address,
         Set_Routine => Set_Dcls_Int_07'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_08",
         Variable => IOS.Dcls_Int_08'Address,
         Set_Routine => Set_Dcls_Int_08'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_09",
         Variable => IOS.Dcls_Int_09'Address,
         Set_Routine => Set_Dcls_Int_09'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_int_10",
         Variable => IOS.Dcls_Int_10'Address,
         Set_Routine => Set_Dcls_Int_10'access );

      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_01",
         Variable => IOS.Dcls_Bool_01'Address,
         Set_Routine => Set_Dcls_Bool_01'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_02",
         Variable => IOS.Dcls_Bool_02'Address,
         Set_Routine => Set_Dcls_Bool_02'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_03",
         Variable => IOS.Dcls_Bool_03'Address,
         Set_Routine => Set_Dcls_Bool_03'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_04",
         Variable => IOS.Dcls_Bool_04'Address,
         Set_Routine => Set_Dcls_Bool_04'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_05",
         Variable => IOS.Dcls_Bool_05'Address,
         Set_Routine => Set_Dcls_Bool_05'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_06",
         Variable => IOS.Dcls_Bool_06'Address,
         Set_Routine => Set_Dcls_Bool_06'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_07",
         Variable => IOS.Dcls_Bool_07'Address,
         Set_Routine => Set_Dcls_Bool_07'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_08",
         Variable => IOS.Dcls_Bool_08'Address,
         Set_Routine => Set_Dcls_Bool_08'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_09",
         Variable => IOS.Dcls_Bool_09'Address,
         Set_Routine => Set_Dcls_Bool_09'access );
      JPATS_IOS_Interface.Register
        (Name => "dcls_bool_10",
         Variable => IOS.Dcls_Bool_10'Address,
         Set_Routine => Set_Dcls_Bool_10'access );

   end Register_Ios_Variables;


end JPATS_dcls.Ios_If;
