-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division;
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--| Reference: Kimball, D., "Flight Simulation Mathematical Model of
--|            the Beech MkII Joint Primary Aircraft Training System
--|            (JPATS)", Document 133E794 Rev. B, 11 November, 1998.
--|            Flight Manual Dated April 30,1998.
--|                          AIR FORCE TO 1T-6A-1,
--|                          NAVY (NAVAIR) A1-T6AAA-NFM-100
--|            Standards from Flight Dynamics Group
--|            Flight Safety International, Inc., System Simulation Division
--|            Broken Arrow, OK 74012
-------------------------------------------------------------------------------
--|
with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Jpats_Dcls.Container;
with Jpats_Dcls_Types;
with Column_Movement;
with Control_Surface;
with Gearing;
with Pedals;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Torque_Types;
with JPATS_Aircraft_Body;
with JPATS_Auto_Test;
with JPATS_Secondary_Flight_Controls;
with JPATS_Secondary_Flight_Controls_Types;
with JPATS_Simulated_Aircraft;
with JPATS_Flight_Instruments;
with JPATS_Reposition;
with JPATS_Reposition_Types;
with Interpolation_Table.Singly_Indexed;
with JPATS_Landing_Gear;
with save_restore;
with JPATS_IOS_Pilot;

with JPATS_DCLS.IOS_If;
with Ada.Unchecked_Conversion;
with Ada.Text_IO;
with Simulation_Dictionary;

with JPATS_IO.SimIO_Container;

package body JPATS_DCLS.Controller is
  use Container;
  --| package Cnt renames Container;
  package It  renames Interpolation_Table;
  package Jat renames JPATS_Auto_test;
  package Jab renames JPATS_aircraft_body;
  package Jsa renames JPATS_Simulated_Aircraft;
  package Jfi renames JPATS_Flight_Instruments;
  package Jip renames JPATS_IOS_Pilot;
  package SimIO renames JPATS_IO.SimIO_Container;
  Subs  : Instance renames Container.This_Subsystem;
  IO    : IO_Interface_Instance renames Container.This_Io_Interface;

  IOS   : Container.IOS_Interface_Instance renames Container.This_Ios_Interface;

  --| Pointer to directory containing data tables
  File_Path     : String := JPATS_DCLS_Types.File_Path;

  -- -------------------------------------------------------------------------------------
  --| Declaration of DCLS data tables
  -- -------------------------------------------------------------------------------------
  --| Column Movement
  DADLAT_INV_T  : aliased IT.Singly_Indexed.Instance;
  FBWDLONG_T    : aliased IT.Singly_Indexed.Instance;
  DEDLONG_INV_T : aliased IT.Singly_Indexed.Instance;
  FLATSPRING_T  : aliased IT.Singly_Indexed.Instance;
  DRDPED_INV_T  : aliased IT.Singly_Indexed.Instance;
  --| Control Surface
  DEDLONG_T     : aliased IT.Singly_Indexed.Instance;
  DADLAT_T      : aliased IT.Singly_Indexed.Instance;
  DRDPED_T      : aliased IT.Singly_Indexed.Instance;
  --| Gearing
  GEDLONG_T     : aliased IT.Singly_Indexed.Instance;
  GADLAT_T      : aliased IT.Singly_Indexed.Instance;
  GRDPED_T      : aliased IT.Singly_Indexed.Instance;
  Gada_T        : aliased IT.Singly_Indexed.Instance;

  -- -------------------------------------------------------------------------------------
  --| Tables for DCLS
  -- -------------------------------------------------------------------------------------
  Cable_Stiff_Dir_T     : aliased IT.Singly_Indexed.Instance;
  Cable_Stiff_Lat_T     : aliased IT.Singly_Indexed.Instance;
  Cable_Stiff_Long_T    : aliased IT.Singly_Indexed.Instance;

  Damping_Dir_T         : aliased IT.Singly_Indexed.Instance;
  Damping_Lat_T         : aliased IT.Singly_Indexed.Instance;
  Damping_Long_T        : aliased IT.Singly_Indexed.Instance;

  Friction_Dir_T        : aliased IT.Singly_Indexed.Instance;
  Friction_Lat_T        : aliased IT.Singly_Indexed.Instance;
  Friction_Long_T       : aliased IT.Singly_Indexed.Instance;
  other_ail_T           : aliased IT.Singly_Indexed.Instance;
  left_ail_T            : aliased IT.Singly_Indexed.Instance;
  right_ail_T           : aliased IT.Singly_Indexed.Instance;

  ----------------------------------------------------------------------------------------
  -- Rename global variables
  -- The following variables are related to the filtering data sent to ECLS
  ----------------------------------------------------------------------------------------
  Bob_Weight            : Float                       renames Container.Bob_Weight;

  -- for roll,pitch,yaw axis
  Neutral_Position      : Coordinate_Types.Attitude   renames Container.Neutral_Position;
  Aero_Grad             : Coordinate_Types.Attitude   renames Container.Aero_Grad;
  Filtered_damper       : Coordinate_Types.Attitude   renames Container.Filtered_damper;
  Filtered_Yaw_friction : Float                       renames Container.Filtered_Yaw_friction;
  Load_Factor           : Coordinate_Types.Cartesian  renames Container.Load_Factor;
  old_cas               : Float                       renames Container.Old_Cas;
  Tab_Pos               : Angle_Types.Degrees         renames Container.Tab_Pos;

  Repo_Previous         : Boolean                     renames Container.Repo_Previous;
  Crash_Previous        : Boolean                     renames Container.Crash_Previous;
  IOS_Pilot_Previous    : Boolean                     renames Container.IOS_Pilot_Previous;

  Repo_Timer            : Float                       renames Container.Repo_Timer;
  Lagfac_Timer          : Coordinate_Types.Attitude   renames Container.Lagfac_Timer;
  Load_Lagfac           : Float                       renames Container.Load_Lagfac;
  IOS_Pilot_Timer       : Float                       renames Container.IOS_Pilot_Timer;

  Misc_Timer            : Float                       renames Container.Misc_Timer;

  Pitch_Mode_Previous   : Integer renames Container.This_Subsystem.Pitch_Mode_Previous;
  Roll_Mode_Previous    : Integer renames Container.This_Subsystem.Roll_Mode_Previous ;
  Yaw_Mode_Previous     : Integer renames Container.This_Subsystem.Yaw_Mode_Previous;

  PlayBack_Previous     : Boolean := False;

  Misc_Force            : Coordinate_Types.Attitude:=(0.0,0.0,0.0);


  ----------------------------------------------------------------------------------------
  -- Counter for CLM ICD global variables
  -- The following variables are related to CLM Control Block
  ----------------------------------------------------------------------------------------

   Control_Block_Counter      : Integer := 0;


   procedure Update_ICD_Control_Block ( Tick     : in Integer;
                                        In_Buff  : in Integer;
                                        Out_Buff : in out Integer ) is

      Count  : Jpats_Dcls.Container.ICD_Control_Block;
      State  : Jpats_Dcls.Container.ICD_Control_Block;
      Temp   : Jpats_Dcls.Container.ICD_Control_Block;

      Integer_Form : Integer;

      function Integer_to_Control_Block is 
         new Ada.Unchecked_Conversion (Integer, Jpats_Dcls.Container.ICD_Control_Block);

      function Control_Block_Byte_to_Integer is 
         new Ada.Unchecked_Conversion (Jpats_Dcls.Container.ICD_Control_Block, Integer);

   begin

      Count := Integer_to_Control_Block ( Tick );
      State := Integer_to_Control_Block ( In_Buff );

      Temp.Counter := Count.Counter;
      Temp.State   := State.Counter;

      Out_Buff := Control_Block_Byte_to_Integer ( Temp );

   end Update_ICD_Control_Block;


   procedure Decode_ICD_Control_Block ( To_Decode : in     Integer;
                                        Word_1    : in out Integer; 
                                        Word_2    : in out Integer; 
                                        Word_3    : in out Integer; 
                                        Word_4    : in out Integer ) is 

      Integer_Form : Integer;
      Temp         : Jpats_Dcls.Container.ICD_Control_Block;

      function Control_Block_Byte_to_Integer is 
         new Ada.Unchecked_Conversion (Jpats_Dcls.Container.Control_Block_Byte, Integer);

      function Integer_to_Control_Block is 
         new Ada.Unchecked_Conversion (Integer, Jpats_Dcls.Container.ICD_Control_Block);

   begin

      Temp   := Integer_to_Control_Block ( To_Decode );

      Word_1 := Control_Block_Byte_to_Integer ( Temp.Counter );
      Word_2 := Control_Block_Byte_to_Integer ( Temp.State );
      Word_3 := Control_Block_Byte_to_Integer ( Temp.Acknowledge );
      Word_4 := Control_Block_Byte_to_Integer ( Temp.Reserved );

  end Decode_ICD_Control_Block;

  procedure Initialize is

  begin
     -- ----------------------------------------------------------------------------------
     --  Register_Dcls_Io_Variables
     -- ----------------------------------------------------------------------------------

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "CLM_HOST_OUTPUT_BUFFER",
        A_Direction     => Io_Types.output,
        An_Address      => Io.CLM_HOST_OUTPUT_BUFFER'Address,
        A_Size          => Io.CLM_HOST_OUTPUT_BUFFER'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "CLM_HOST_TIMESTAMP",
        A_Direction     => Io_Types.output,
        An_Address      => Io.CLM_HOST_TIMESTAMP'Address,
        A_Size          => Io.CLM_HOST_TIMESTAMP'Size );

     -- Jpats_Io.Map_To_Icd_Mnemonic
     --   (An_Interface    => Jpats_Io_Types.Control_Loading,
     --    An_Icd_Mnemonic => "DCI_SYS_lru_group1",
     --    A_Direction     => Io_Types.Input,
     --    An_Address      => Io.DCI_SYS_lru_group1'Address,
     --    A_Size          => Io.DCI_SYS_lru_group1'Size );

     -- Jpats_Io.Map_To_Icd_Mnemonic
     --   (An_Interface    => Jpats_Io_Types.Control_Loading,
     --    An_Icd_Mnemonic => "DCI_SYS_lru_group2",
     --    A_Direction     => Io_Types.Input,
     --    An_Address      => Io.DCI_SYS_lru_group2'Address,
     --    A_Size          => Io.DCI_SYS_lru_group2'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Surf_Aero_HMD",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Surf_Aero_HMD'Address,
        A_Size          => Io.DCO_Long_Surf_Aero_HMD'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Surf_aero_Damping",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Surf_aero_Damping'Address,
        A_Size          => Io.DCO_Long_Surf_aero_Damping'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_surf_Neutral",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_surf_Neutral'Address,
        A_Size          => Io.DCO_Long_surf_Neutral'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Stk_Misc_Force",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Stk_Misc_Force'Address,
        A_Size          => Io.DCO_Long_Stk_Misc_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Surf_Drvr_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Surf_Drvr_Flag'Address,
        A_Size          => Io.DCO_Long_Surf_Drvr_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Surf_Drvr_Cmnd",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Surf_Drvr_Cmnd'Address,
        A_Size          => Io.DCO_Long_Surf_Drvr_Cmnd'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Surf_Jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Surf_Jam'Address,
        A_Size          => Io.DCO_Long_Surf_Jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Stk_Drvr_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Stk_Drvr_Flag'Address,
        A_Size          => Io.DCO_Long_Stk_Drvr_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Control_Loading,
       An_Icd_Mnemonic => "DCO_Long_Stk_Drvr_Cmnd",
       A_Direction     => Io_Types.output,
       An_Address      => Io.DCO_Long_Stk_Drvr_Cmnd'Address,
       A_Size          => Io.DCO_Long_Stk_Drvr_Cmnd'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Stk_jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Stk_jam'Address,
        A_Size          => Io.DCO_Long_Stk_jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Cable_Stiff",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Cable_Stiff'Address,
        A_Size          => Io.DCO_Long_Cable_Stiff'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_Frict_Gain",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Frict_Gain'Address,
        A_Size          => Io.DCO_Long_Frict_Gain'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Long_BOB_WEIGHT",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Long_Bob_weight'Address,
        A_Size          => Io.DCO_Long_Bob_weight'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Surf_Aero_HMD",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Surf_Aero_HMD'Address,
        A_Size          => Io.DCO_Latl_Surf_Aero_HMD'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Surf_aero_Damping",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Surf_aero_Damping'Address,
        A_Size          => Io.DCO_Latl_Surf_aero_Damping'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_surf_Neutral",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_surf_Neutral'Address,
        A_Size          => Io.DCO_Latl_surf_Neutral'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Stk_Misc_Force",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Stk_Misc_Force'Address,
        A_Size          => Io.DCO_Latl_Stk_Misc_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Surf_Drvr_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Surf_Drvr_Flag'Address,
        A_Size          => Io.DCO_Latl_Surf_Drvr_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Surf_Drvr_Cmnd",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Surf_Drvr_Cmnd'Address,
        A_Size          => Io.DCO_Latl_Surf_Drvr_Cmnd'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_stk_Drvr_Cmnd_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_stk_Drvr_Cmnd_Flag'Address,
        A_Size          => Io.DCO_Latl_stk_Drvr_Cmnd_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Stk_Drvr_Cmnd",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Stk_Drvr_Cmnd'Address,
        A_Size          => Io.DCO_Latl_Stk_Drvr_Cmnd'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Surf_Jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Surf_Jam'Address,
        A_Size          => Io.DCO_Latl_Surf_Jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Stk_Jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Stk_Jam'Address,
        A_Size          => Io.DCO_Latl_Stk_Jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_Frict_Gain",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Frict_Gain'Address,
        A_Size          => Io.DCO_Latl_Frict_Gain'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Latl_cable_stiff",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_cable_stiff'Address,
        A_Size          => Io.DCO_Latl_cable_stiff'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_LATL_TAB_POS",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Latl_Tab_Pos'Address,
        A_Size          => Io.DCO_Latl_Tab_Pos'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Surf_Aero_HMD",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Surf_Aero_HMD'Address,
        A_Size          => Io.DCO_Dirc_Surf_Aero_HMD'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Surf_aero_Damping",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Surf_aero_Damping'Address,
        A_Size          => Io.DCO_Dirc_Surf_aero_Damping'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_surf_Neutral",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_surf_Neutral'Address,
        A_Size          => Io.DCO_Dirc_surf_Neutral'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_ped_Misc_Force",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_ped_Misc_Force'Address,
        A_Size          => Io.DCO_Dirc_ped_Misc_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Surf_Drvr_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Surf_Drvr_Flag'Address,
        A_Size          => Io.DCO_Dirc_Surf_Drvr_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Surf_Drvr_Cmnd",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Surf_Drvr_Cmnd'Address,
        A_Size          => Io.DCO_Dirc_Surf_Drvr_Cmnd'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_ped_Drvr_Cmnd_Flag",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_ped_Drvr_Cmnd_Flag'Address,
        A_Size          => Io.DCO_Dirc_ped_Drvr_Cmnd_Flag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_ped_Drvr_Cmnd",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_ped_Drvr_Cmnd'Address,
        A_Size          => Io.DCO_Dirc_ped_Drvr_Cmnd'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Surf_Jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Surf_Jam'Address,
        A_Size          => Io.DCO_Dirc_Surf_Jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_ped_Jam",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_ped_Jam'Address,
        A_Size          => Io.DCO_Dirc_ped_Jam'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Frict_Gain",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Frict_Gain'Address,
        A_Size          => Io.DCO_Dirc_Frict_Gain'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_Dirc_Cable_Stiff",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Dirc_Cable_Stiff'Address,
        A_Size          => Io.DCO_Dirc_Cable_Stiff'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TBKL_K_PUMP",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Tbkl_K_pump'Address,
        A_Size          => Io.DCO_Tbkl_K_pump'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TBKL_MALF_FLAG",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Tbkl_Malf_flag'Address,
        A_Size          => Io.DCO_Tbkl_Malf_flag'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TBKR_K_PUMP",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Tbkr_K_pump'Address,
        A_Size          => Io.DCO_Tbkr_K_pump'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TBKR_MALF_FLAG",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Tbkr_Malf_flag'Address,
        A_Size          => Io.DCO_Tbkr_Malf_flag'Size );

-- DCO_SEAT_PRIM_FLTAZA
-- DCO_SEAT_Z_AXIS_SPEF		
-- ^^^^^^^^^^^^^^^^^^^^^^^		
     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SYS_unused",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_SYS_unused'Address,
        A_Size          => Io.DCI_SYS_unused'Size );

--     Jpats_Io.Map_To_Icd_Mnemonic
--       (An_Interface    => Jpats_Io_Types.Control_Loading,
--        An_Icd_Mnemonic => "DCI_SYS_mem_test_hst",
--        A_Direction     => Io_Types.Input,
--        An_Address      => Io.DCI_SYS_mem_test_hst'Address,
--        A_Size          => Io.DCI_SYS_mem_test_hst'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SYS_mem_test_drv",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_SYS_mem_test_drv'Address,
        A_Size          => Io.DCI_SYS_mem_test_drv'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SYS_cycle_counter",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_SYS_cycle_counter'Address,
        A_Size          => Io.DCI_SYS_cycle_counter'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_Long_Stk_Position",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Long_Stk_Position'Address,
        A_Size          => Io.DCI_Long_Stk_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LONG_STK_FORCE",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.Dci_Long_Stk_Force'Address,
        A_Size          => Io.Dci_Long_Stk_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LONG_SURF_POSITION",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Long_Surf_Position'Address,
        A_Size          => Io.DCI_Long_Surf_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LONG_SERVO",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Long_Servo'Address,
        A_Size          => Io.DCI_Long_Servo'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_Latl_Stk_Position",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Latl_Stk_Position'Address,
        A_Size          => Io.DCI_Latl_Stk_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LATL_STK_FORCE",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.Dci_Latl_Stk_Force'Address,
        A_Size          => Io.Dci_Latl_Stk_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LATL_SURF_POSITION",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Latl_Surf_Position'Address,
        A_Size          => Io.DCI_Latl_Surf_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_LATL_SERVO",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Latl_Servo'Address,
        A_Size          => Io.DCI_Latl_Servo'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_Dirc_Ped_Position",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Dirc_Ped_Position'Address,
        A_Size          => Io.DCI_Dirc_Ped_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCi_DIRC_PED_FORCE",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.Dci_Dirc_Ped_Force'Address,
        A_Size          => Io.Dci_Dirc_Ped_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_DIRC_SURF_POSITION",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Dirc_Surf_Position'Address,
        A_Size          => Io.DCI_Dirc_Surf_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_DIRC_SERVO",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Dirc_Servo'Address,
        A_Size          => Io.DCI_Dirc_Servo'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TBKL_FORCE",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.Dci_Tbkl_Force'Address,
        A_Size          => Io.Dci_Tbkl_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TBKL_POSITION",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Tbkl_Position'Address,
        A_Size          => Io.DCI_Tbkl_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TBKL_SERVO",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Tbkl_Servo'Address,
        A_Size          => Io.DCI_Tbkl_Servo'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCi_TBKR_FORCE",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.Dci_Tbkr_Force'Address,
        A_Size          => Io.Dci_Tbkr_Force'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TBKR_POSITION",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Tbkr_Position'Address,
        A_Size          => Io.DCI_Tbkr_Position'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TBKR_SERVO",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Tbkr_Servo'Address,
        A_Size          => Io.DCI_Tbkr_Servo'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TEST_PHASE_LAG",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Test_Phase_lag'Address,
        A_Size          => Io.DCI_Test_Phase_lag'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_TEST_MAG_LOSS",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Test_Mag_loss'Address,
        A_Size          => Io.DCI_Test_Mag_loss'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SPARE1",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Spare1'Address,
        A_Size          => Io.DCI_Spare1'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SPARE2",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Spare2'Address,
        A_Size          => Io.DCI_Spare2'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SPARE3",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Spare3'Address,
        A_Size          => Io.DCI_Spare3'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SPARE4",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Spare4'Address,
        A_Size          => Io.DCI_Spare4'Size );


     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCI_SPARE5",
        A_Direction     => Io_Types.Input,
        An_Address      => Io.DCI_Spare5'Address,
        A_Size          => Io.DCI_Spare5'Size );



     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_AUTOTEST_NUMBER",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Autotest_number'Address,
        A_Size          => Io.DCO_Autotest_number'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_AUTOTEST_PHASE",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Autotest_phase'Address,
        A_Size          => Io.DCO_Autotest_phase'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_AUTOTEST_TIME",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Autotest_time'Address,
        A_Size          => Io.DCO_Autotest_time'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TEST_PHASE",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Test_phase'Address,
        A_Size          => Io.DCO_Test_phase'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TEST_AXIS",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Test_axis'Address,
        A_Size          => Io.DCO_Test_axis'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TEST_TYPE",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Test_TYPE'Address,
        A_Size          => Io.DCO_Test_TYPE'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TEST_FREQ",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Test_Freq'Address,
        A_Size          => Io.DCO_Test_Freq'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_TEST_MAG",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_Test_Mag'Address,
        A_Size          => Io.DCO_Test_Mag'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_SPARE1",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_SPARE1'Address,
        A_Size          => Io.DCO_SPARE1'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_SPARE2",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_SPARE2'Address,
        A_Size          => Io.DCO_SPARE2'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_SPARE3",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_SPARE3'Address,
        A_Size          => Io.DCO_SPARE3'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_SPARE4",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_SPARE4'Address,
        A_Size          => Io.DCO_SPARE4'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "DCO_SPARE5",
        A_Direction     => Io_Types.output,
        An_Address      => Io.DCO_SPARE5'Address,
        A_Size          => Io.DCO_SPARE5'Size );

     -- The following  section of variables must be present (per CLMnt_IDD.docx)
         
     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "CLM_HOST_INPUT_BUFFER",
        A_Direction     => Io_Types.input,
        An_Address      => Io.CLM_HOST_INPUT_BUFFER'Address,
        A_Size          => Io.CLM_HOST_INPUT_BUFFER'Size );

     Jpats_Io.Map_To_Icd_Mnemonic
       (An_Interface    => Jpats_Io_Types.Control_Loading,
        An_Icd_Mnemonic => "CLM_SUBSYSTEM_TIMESTAMP",
        A_Direction     => Io_Types.input,
        An_Address      => Io.CLM_SUBSYSTEM_TIMESTAMP'Address,
        A_Size          => Io.CLM_SUBSYSTEM_TIMESTAMP'Size );

         

     -------------------------------------------------------------------------------------
     -- Load Data Tables
     -------------------------------------------------------------------------------------
     it.read(file_path & "cslat.ito",cable_stiff_lat_t);
     it.read(file_path & "cslng.ito",cable_stiff_long_t);
     it.read(file_path & "csd.ito",cable_stiff_dir_t);
     it.read(file_path & "dd.ito",damping_dir_t);
     it.read(file_path & "dlat.ito",damping_lat_t);
     it.read(file_path & "dlng.ito",damping_long_t);

     it.read(file_path & "fd.ito",friction_dir_t);
     it.read(file_path & "flat.ito",friction_lat_t);
     it.read(file_path & "flng.ito",friction_long_t);
     it.read(file_path & "fltsprng.ito",flatspring_t);
     it.read(file_path & "fbwdlong.ito",fbwdlong_t);

     --| control surface------------------------------------------------------------------
     it.read(file_path & "dedlong.ito",dedlong_t);
     it.read(file_path & "dadlat.ito",dadlat_t);
     it.read(file_path & "drdped.ito",drdped_t);
     --| gearing--------------------------------------------------------------------------
     it.read(file_path & "gedlong.ito",gedlong_t);
     it.read(file_path & "gadlat.ito",gadlat_t);
     it.read(file_path & "grdped.ito",grdped_t);
     it.read(file_path & "gada.ito",gada_t);
     --| column movement------------------------------------------------------------------
     it.read(file_path & "dadlat_i.ito",dadlat_inv_t);
     it.read(file_path & "dedlng_i.ito",dedlong_inv_t);
     --| pedals---------------------------------------------------------------------------
     it.read(file_path & "drdped_i.ito",drdped_inv_t);

     it.read(file_path & "lvsrail.ito",other_ail_t);
     it.read(file_path & "total.ito",left_ail_t);
     it.read(file_path & "totar.ito",right_ail_t);


  end Initialize;

  function Flimit(VALUE : Float;
                  MIN   : Float;
                  MAX   : Float) return Float is
     Answer : Float;
  begin
     if VALUE < MIN then         Answer := MIN;
     elsif VALUE > MAX then      Answer := MAX;
     else                        Answer := VALUE;
     end if;

     return Answer;
  end Flimit;

  function Bool_to_Float ( logical : boolean) return float is
     answer : float;
  begin
     if logical then
	    answer := 1.0;
	 else
	    answer := 0.0;
	 end if;
	 return answer;
  end Bool_to_Float;
    
  procedure Update (An_Integration_Constant:in     Float) is

    Left_ail                : Angle_Types.Degrees;
    Right_Ail               : Angle_Types.Degrees;
    Left_Ail_Gearing        : Float := 0.0;
    Right_Ail_Gearing       : Float := 0.0;
    Surf_Pos                : Angle_Types.Degrees;
    Gear                    : Float;
    Hinge_Moment            : Torque_Types.Ft_Lbf;
    Sine_Vibration          : array(1..20) of float := (others => 0.0);
    White_Vibration         : array(1..5)  of float := (others => 0.0);
    Temp                    : Float;
    f_Mass                  : Float;
    Hm                      : Float;
    Lateral_Gradient        : Float;
    Stk_Force               : Float;
    avg_Ail                 : Float;
    hm_Spring               : Float;
    Lat_Force               : Float;
    lat_Stick               : Float;
    long_Force              : Float;
    long_Stick              : Float;
    Pedal                   : Float := 0.0;
    Pedal_Force             : Float := 0.0;
    Ped_Mom                 : Float := 0.0;
    L_Ped                   : Float := 0.0;
    Right_Gear_Sq           : Float := 0.0;
    Left_Gear_Sq            : Float := 0.0;
    Avg_Ail_Gear            : Float := 0.0;
    Left_Hm                 : Float := 0.0;
    Right_Hm                : Float := 0.0;
    Ail_Neutral             : Float := 0.0;
    Cas                     : Float := 0.0;
    delt_cas                : Float := 0.0;
    temp_cas                : Float := 0.0;
    hag                     : Float := 0.0;
    Dcls_Temp_Var           : Float := 0.0;
    Damping_Multiplicator   : Coordinate_Types.Attitude := (1.0, 1.0, 1.0);
    Lagfac                  : Coordinate_Types.Attitude := (1.0, 1.0, 1.0);

  begin

    -- Update the Header of the Host to CLM ICD Buffer
    Control_Block_Counter := Control_Block_Counter + 1; 
    if Control_Block_Counter > 255 then
       Control_Block_Counter := 0;
    end if;

    Update_ICD_Control_Block ( Tick     => Control_Block_Counter,
                               In_Buff  => IO.CLM_HOST_INPUT_BUFFER , 
                               Out_Buff => IO.CLM_HOST_OUTPUT_BUFFER );

    -- Debug : copy the current CLM control block data into IOS buffer

    Decode_ICD_Control_Block ( To_Decode => IO.CLM_HOST_OUTPUT_BUFFER,
                               Word_1    => SimIO.CLM_Host_Counter,    -- clm_host_counter
                               Word_2    => SimIO.CLM_Host_State,      -- clm_host_state
                               Word_3    => SimIO.CLM_Host_Command,    -- clm_host_command
                               Word_4    => SimIO.CLM_Host_Reserved ); -- clm_host_reserved

    --IOS.DCLS_Int_02 := SimIO.CLM_Read_Count;
    --IOS.DCLS_Int_03 := SimIO.CLM_Read_Errors;
    --IOS.DCLS_Int_04 := SimIO.CLM_Write_Count;
    --IOS.DCLS_Int_05 := SimIO.CLM_Write_Errors;
	-- 
    --IOS.DCLS_Int_10 := IO.CLM_HOST_TIMESTAMP;

    
         -- CLM Interface Debug 
--  if Jsa.Float1 > 0.0 and Jsa.Float1 < 0.5 then
--
--         IO.DCO_LONG_SURF_AERO_HMD            := 1.0;
--         IO.DCO_LONG_SURF_AERO_DAMPING        := 2.0;
--         IO.DCO_LONG_SURF_NEUTRAL             := 3.0;
--         IO.DCO_LONG_STK_MISC_FORCE           := 4.0;
--         IO.DCO_LONG_SURF_DRVR_FLAG           := TRUE;
--         IO.DCO_LONG_SURF_DRVR_CMND           := 5.0;
--         IO.DCO_LONG_SURF_JAM                 := TRUE;
--         IO.DCO_LONG_STK_DRVR_FLAG            := TRUE;
--         IO.DCO_LONG_STK_DRVR_CMND            := 6.0;
--         IO.DCO_LONG_STK_JAM                  := TRUE;
--         IO.DCO_LONG_CABLE_STIFF              := 7.0;
--         IO.DCO_LONG_FRICT_GAIN               := 8.0;
--         IO.DCO_LONG_BOB_WEIGHT               := 9.0;
--         IO.DCO_LATL_SURF_AERO_HMD            := 10.0;
--         IO.DCO_LATL_SURF_AERO_DAMPING        := 11.0;
--         IO.DCO_LATL_SURF_NEUTRAL             := 12.0;
--         IO.DCO_LATL_STK_MISC_FORCE           := 13.0;
--         IO.DCO_LATL_SURF_DRVR_FLAG           := TRUE;
--         IO.DCO_LATL_SURF_DRVR_CMND           := 14.0;
--         IO.DCO_LATL_SURF_JAM                 := TRUE;
--         IO.DCO_LATL_STK_DRVR_CMND_FLAG       := TRUE;
--         IO.DCO_LATL_STK_DRVR_CMND            := 15.0;
--         IO.DCO_LATL_STK_JAM                  := TRUE;
--         IO.DCO_LATL_FRICT_GAIN               := 16.0;
--         IO.DCO_LATL_CABLE_STIFF              := 17.0;
--         IO.DCO_LATL_TAB_POS                  := 18.0;
--         IO.DCO_DIRC_SURF_AERO_HMD            := 19.0;
--         IO.DCO_DIRC_SURF_AERO_DAMPING        := 20.0;
--         IO.DCO_DIRC_SURF_NEUTRAL             := 21.0;
--         IO.DCO_DIRC_PED_MISC_FORCE           := 22.0;
--         IO.DCO_DIRC_SURF_DRVR_FLAG           := TRUE;
--         IO.DCO_DIRC_SURF_DRVR_CMND           := 23.0;
--         IO.DCO_DIRC_SURF_JAM                 := TRUE;
--         IO.DCO_DIRC_PED_DRVR_CMND_FLAG       := TRUE;
--         IO.DCO_DIRC_PED_DRVR_CMND            := 24.0;
--         IO.DCO_DIRC_PED_JAM                  := TRUE;
--         IO.DCO_DIRC_FRICT_GAIN               := 25.0;
--         IO.DCO_DIRC_CABLE_STIFF              := 26.0;
--         IO.DCO_TBKL_K_PUMP                   := 27.0;
--         IO.DCO_TBKL_MALF_FLAG                := TRUE;
--         IO.DCO_TBKR_K_PUMP                   := 28.0;
--         IO.DCO_TBKR_MALF_FLAG                := TRUE;
--         IO.DCO_SEAT_PRIM_FLTAZA              := 29.0;
--         IO.DCO_SEAT_Z_AXIS_SPEF              := 30.0;
--         IO.DCO_SEAT_CYL_DISCR_INPUT          := 31.0;
--         IO.DCO_SEAT_FREEZE_FLAG              := TRUE;
--         IO.DCO_SEAT_SINE_1_AMPL              := 32.0;
--         IO.DCO_SEAT_SINE_2_AMPL              := 33.0;
--         IO.DCO_SEAT_SINE_3_AMPL              := 34.0;
--         IO.DCO_SEAT_SINE_4_AMPL              := 35.0;
--         IO.DCO_SEAT_SINE_5_AMPL              := 36.0;
--         IO.DCO_SEAT_SINE_6_AMPL              := 37.0;
--         IO.DCO_SEAT_SINE_7_AMPL              := 38.0;
--         IO.DCO_SEAT_SINE_8_AMPL              := 39.0;
--         IO.DCO_SEAT_SINE_9_AMPL              := 40.0;
--         IO.DCO_SEAT_SINE_10_AMPL             := 41.0;
--         IO.DCO_SEAT_SINE_11_AMPL             := 42.0;
--         IO.DCO_SEAT_SINE_12_AMPL             := 43.0;
--         IO.DCO_SEAT_SINE_13_AMPL             := 44.0;
--         IO.DCO_SEAT_SINE_14_AMPL             := 45.0;
--         IO.DCO_SEAT_SINE_15_AMPL             := 46.0;
--         IO.DCO_SEAT_SINE_16_AMPL             := 47.0;
--         IO.DCO_SEAT_SINE_17_AMPL             := 48.0;
--         IO.DCO_SEAT_SINE_18_AMPL             := 49.0;
--         IO.DCO_SEAT_SINE_19_AMPL             := 50.0;
--         IO.DCO_SEAT_SINE_20_AMPL             := 51.0;
--         IO.DCO_SEAT_WHITE_1_VAR              := 52.0;
--         IO.DCO_SEAT_WHITE_2_VAR              := 53.0;
--         IO.DCO_SEAT_WHITE_3_VAR              := 54.0;
--         IO.DCO_SEAT_WHITE_4_VAR              := 55.0;
--         IO.DCO_SEAT_WHITE_5_VAR              := 56.0;
--         IO.DCO_AUTOTEST_NUMBER               := 0072;
--         IO.DCO_AUTOTEST_PHASE                := 0073;
--         IO.DCO_AUTOTEST_TIME                 := 57.0;
--         IO.DCO_TEST_PHASE                    := 0075;
--         IO.DCO_TEST_AXIS                     := 0076;
--         IO.DCO_TEST_TYPE                     := 0077;
--         IO.DCO_TEST_FREQ                     := 58.0;
--         IO.DCO_TEST_MAG                      := 59.0;
--         IO.DCO_SPARE1                        := 60.0;
--         IO.DCO_SPARE2                        := 61.0;
--         IO.DCO_SPARE3                        := 62.0;
--         IO.DCO_SPARE4                        := 63.0;
--         IO.DCO_SPARE5                        := 64.0;
--
--         -- ----------------------------------------------------------------------------
--         --| From DCLS to the HOST   HOST <-- DCLS
--         -- ----------------------------------------------------------------------------
--
--         IOS.DCLS_float_01 := IO.DCI_LONG_STK_POSITION;
--         IOS.DCLS_float_02 := IO.DCI_LONG_STK_FORCE;
--         IOS.DCLS_float_03 := IO.DCI_LONG_SURF_POSITION;
--         IOS.DCLS_float_04 := IO.DCI_LONG_SERVO;
--         IOS.DCLS_float_05 := IO.DCI_LATL_STK_POSITION;
--         IOS.DCLS_float_06 := IO.DCI_LATL_STK_FORCE;
--         IOS.DCLS_float_07 := IO.DCI_LATL_SURF_POSITION;
--         IOS.DCLS_float_08 := IO.DCI_LATL_SERVO;
--         IOS.DCLS_float_09 := IO.DCI_DIRC_PED_POSITION;
--         IOS.DCLS_float_10 := IO.DCI_DIRC_PED_FORCE;
--         IOS.DCLS_float_11 := IO.DCI_DIRC_SURF_POSITION ;
--         IOS.DCLS_float_12 := IO.DCI_DIRC_SERVO         ;
--         IOS.DCLS_float_13 := IO.DCI_TBKL_POSITION      ;
--         IOS.DCLS_float_14 := IO.DCI_TBKL_FORCE         ;
--         IOS.DCLS_float_15 := IO.DCI_TBKL_SERVO         ;
--         IOS.DCLS_float_16 := IO.DCI_TBKR_POSITION      ;
--         IOS.DCLS_float_17 := IO.DCI_TBKR_FORCE         ;
--         IOS.DCLS_float_18 := IO.DCI_TBKR_SERVO        ;
--         IOS.DCLS_float_19 := IO.DCI_SEAT_CYL_POS       ;
--         IOS.DCLS_float_20 := IO.DCI_SEAT_ACCELEROMETER ;
--         IOS.DCLS_float_21 := IO.DCI_TEST_PHASE_LAG     ;
--         IOS.DCLS_float_22 := IO.DCI_TEST_MAG_LOSS      ;
--         IOS.DCLS_float_23 := IO.DCI_SPARE1             ;
--         IOS.DCLS_float_24 := IO.DCI_SPARE2             ;
--         IOS.DCLS_float_25 := IO.DCI_SPARE3             ;
--         IOS.DCLS_float_26 := IO.DCI_SPARE4             ;
--         IOS.DCLS_float_27 := IO.DCI_SPARE5            ;
--
--         IOS.DCLS_Int_01 := IO.DCI_ERROR_CYCLE        ;
--         IOS.DCLS_Int_02 := IO.DCI_ERROR_CODE         ;
--         IOS.DCLS_Int_03 := IO.DCI_ERROR_DETAILS      ;
--
--
--  elsif Jsa.Float1 > 4.5 and Jsa.Float1 < 5.5 then
--
--       Subs.Debug2 := IO.DCO_Long_Surf_Aero_HMD;
--       Subs.Debug3 := IO.DCO_Long_Surf_Neutral;
--       Subs.Debug4 := IO.Dco_Long_Bob_weight;
--       Subs.Debug5 := IO.Dco_Long_Surf_Aero_Damping;
--
--       Subs.Debug6 := IO.Dci_tbkl_force;
--       Subs.Debug7 := IO.Dci_tbkr_force;
--
--       Subs.Debug8 := IO.Dci_long_surf_position;
--       Subs.Debug9 := IO.Dci_Long_Stk_Position;
--       if Lagfac.Pitch  < 1.0 then
--          Subs.Debug10 := Lagfac.Pitch*60.0;
--       else
--          Subs.Debug10 := Lagfac.Pitch*10.0;
--       end if;
--
--  
--
--  elsif Jsa.Float1 > 12.5 and Jsa.Float1 < 13.5 then
--       Io.DCO_TEST_PHASE := Integer(Jsa.Float2);
--       IO.DCO_TEST_AXIS  := Integer(JSA.Float3);
--       IO.DCO_TEST_TYPE  := Integer(JSA.Float4);
--       IO.DCO_TEST_FREQ  := (JSA.Float5);
--       IO.DCO_TEST_MAG   := (JSA.Float6);
--
--
--       Subs.Debug7 := IO.DCI_TEST_MAG_LOSS;
--       Subs.Debug8 := IO.DCI_TEST_PHASE_LAG;
--       if IO.DCO_TEST_AXIS = 1 then
--          Subs.Debug9 := IO.DCI_LONG_SERVO;
--       elsif IO.DCO_TEST_AXIS = 2 then
--          Subs.Debug9 := IO.DCI_LATL_SERVO;
--       elsif IO.DCO_TEST_AXIS = 3 then
--          Subs.Debug9 := IO.DCI_DIRC_SERVO;
--       end if;
--
--  elsif Integer(Jsa.Float1) = 151 then
--       Subs.Debug8  := Misc_Force.pitch;
--       Subs.Debug9  := Misc_Force.Roll;
--       Subs.Debug10 := Misc_Force.Yaw;
--  elsif Integer(Jsa.Float1) = 114 then
--       Subs.Debug7  := Column_Movement.Get_Position
--        (Container.This_Subsystem.The_Longitudinal_Column_Movement);
--       Subs.Debug8  := Misc_Force.pitch;
--       Subs.Debug9  := -JIP.Pitch_Backdrive_Force;
--       -- Subs.Debug10 := long_Force;
--
--Integer(Jsa.Float1) = 114 then

     -- ===================================================================================
     -- The following blocks concern about DCLS Safety measures.
     -- The idea is to avoid the  "jumps" of variables sent to DCLS,
     -- which often could result in stick kicks, vibration even instability,
     -- Conditions of interest, are:
     --
     --   * Crash
     --   * Reposition in air and on ground
     --   * Altitude slewing
     --   * Restore playback
     --   * restore snapshot
     --   * Change mode during autotest.
     --   * IOS Pilot
     --
     --
     -- Following those conditions, we put some 1st order filters.
     -- The time constant parameters of those filters are specific to each conditions.
     -- Several timers are used to account to different durations of
     -- those filters. By default, there are NO FILTERS.
     -- ===================================================================================
     -- -----------------------------------------------------------------------------------
     -- prevent stick kicks during CRASH
     -- -----------------------------------------------------------------------------------
    Hag := JSA.Get_Aircraft_Geometric_Altitude;
    -- Initialize timer
    if JSA.Crashed and not Crash_Previous  then
       Load_Lagfac := 0.0;
       Crash_Previous := True;
    elsif not JSA.Crashed and  Crash_Previous  then
       Load_Lagfac := 0.0;
       Repo_Timer := 0.0;
       Crash_Previous := false;
    end if;
    -- timer update
    if Load_Lagfac < 1.0 then
       Load_Lagfac := Load_Lagfac + An_Integration_Constant*0.5;--  2 s timer
       if Load_Lagfac >= 1.0 then
          Load_Lagfac := 1.0;
       end if;
    end if;
    -- this is to prevent erratic movement during crash
    -- fader the load factor to its real value
    Load_Factor.x := Load_Factor.x + Load_lagfac * (JSA.Load_Factor.x - Load_Factor.x);
    Load_Factor.y := Load_Factor.y + Load_lagfac * (JSA.Load_Factor.y - Load_Factor.y);
    Load_Factor.z := Load_Factor.z + Load_lagfac * (JSA.Load_Factor.z - Load_Factor.z);

    if Hag < 7.5 then
       if JSA.Load_Factor.Z < -3.0 then
         Load_Factor.Z := -3.0;
      end if;
    end if;

    -- limit the load factor during crash
    if JSA.Crashed then
       Load_Factor.x := Flimit(Load_Factor.X, -0.75, 0.75);
       Load_Factor.y := Flimit(Load_Factor.Y, -0.75, 0.75);
       Load_Factor.z := Flimit(Load_Factor.Z, -2.0 , 0.0);
    end if;

    -- -----------------------------------------------------------------------------------
    -- Slewing
    -- 12 s is given for dcls to adjust its value smoothly.
    -- -----------------------------------------------------------------------------------
    -- Initialize timer
    if (Jsa.Slew_In_Progress)  and   (Misc_Timer >0.95) then
       Misc_Timer := 0.0;
    end if;

    -- -----------------------------------------------------------------------------------
    -- Restore Playback
    -- Put the filter during the process
    -- -----------------------------------------------------------------------------------
    -- Initialize timer
    if (Save_Restore.Replay_In_Progress or Save_Restore.Replay_Trimming) and
      not Playback_Previous then
       Misc_Timer := 0.0;
       Playback_Previous := True;

    elsif (Save_Restore.Replay_In_Progress or Save_Restore.Replay_Trimming) and
      Playback_Previous then
       Repo_Timer := 0.0;

    elsif not Save_Restore.Replay_In_Progress and not Save_Restore.Replay_Trimming and
      Playback_Previous then
       Misc_Timer := 1.0;
       Lagfac_Timer := (0.0,0.0,0.0);
       Playback_Previous := false;
    end if;

    -- timer update
    if Misc_Timer < 1.0 then
       Misc_Timer := Misc_Timer + An_Integration_Constant*0.1; -- 10 s timer.
       if Misc_Timer >= 1.0 then
          Misc_Timer := 1.0;
       end if;
    end if;


    -- -----------------------------------------------------------------------------------
    -- IOS Pilot
    -- Put the filter during the process and after
    -- -----------------------------------------------------------------------------------
    -- Initialize timer
    if (JIP.Is_On and (not JSA.Get_Flight_Freeze)) and
      (not IOS_Pilot_Previous) then
       IOS_Pilot_Timer := 0.0;
       IOS_Pilot_Previous := True;

     elsif (JIP.Is_On and (not JSA.Get_Flight_Freeze)) and
       (IOS_Pilot_Previous) then
        -- the output to hardware will be filtered
        -- during ios pilot mode is on

        Repo_Timer      := 0.0;


    elsif not (JIP.Is_On and (not JSA.Get_Flight_Freeze)) and
      (IOS_Pilot_Previous) then
       IOS_Pilot_Timer := 1.0;
       IOS_Pilot_Previous := false;
    end if;

    -- timer update
    if IOS_Pilot_Timer < 1.0 then
       IOS_Pilot_Timer := IOS_Pilot_Timer + An_Integration_Constant*0.1; -- 10 s timer.
       if IOS_Pilot_Timer >= 1.0 then
          IOS_Pilot_Timer := 1.0;
       end if;
    end if;

    -- -----------------------------------------------------------------------------------
    -- Reposition
    -- put 7.5 s more filter validity after the reposition finish
    -- -----------------------------------------------------------------------------------
    -- Initialize timer
    if (JSA.Trim_Request or (Jat.At_Phase = 9))
      and not Repo_Previous  then
       Repo_Previous := True;
    elsif not (JSA.Trim_Request or (Jat.At_Phase=9))
      and Repo_Previous then
       Repo_Timer := 0.0;
       Repo_Previous := false;
    end if;

    -- timer update
    if Repo_Timer < 1.0 then
       Repo_Timer := Repo_Timer + An_Integration_Constant*0.133; -- 7.5 s timer.
       if Repo_Timer >= 1.0 then
          Repo_Timer := 1.0;
       end if;
    end if;

    -- -----------------------------------------------------------------------------------
    -- Change mode when autotest running
    -- -----------------------------------------------------------------------------------
    -- lateral mode-----------------------------------------------------------------------
    -- Initialize timer
    if ((Jat.Roll_Mode /= 0 and
        Jat.Roll_Mode /= 2) and                              -- actual is emulated mode
       (Roll_Mode_Previous = 0 or
        Roll_Mode_Previous = 2)) then                        -- previous is direct mode
       Lagfac_Timer.Roll := 0.0;
    end if;

    -- timer update
    if Lagfac_Timer.Roll < 1.0 then
       Lagfac_Timer.Roll := Lagfac_Timer.Roll + An_Integration_Constant*0.5; -- 2 s timer
       if Lagfac_Timer.Roll >= 1.0 then
          Lagfac_Timer.Roll := 1.0;
       end if;
    end if;

    -- longitudinal mode------------------------------------------------------------------
    -- Initialize timer
    if ((Jat.Pitch_Mode /= 0 and
        Jat.Pitch_Mode /= 2) and
       (Pitch_Mode_Previous = 0 or
        Pitch_Mode_Previous = 2)) then
       Lagfac_Timer.Pitch := 0.0;
    end if;
    -- timer update
    if Lagfac_Timer.Pitch < 1.0 then
       Lagfac_Timer.Pitch := Lagfac_Timer.Pitch + An_Integration_Constant*0.5;-- 2 s timer
       if Lagfac_Timer.Pitch >= 1.0 then
          Lagfac_Timer.Pitch := 1.0;
       end if;
    end if;

    -- Directional mode-------------------------------------------------------------------
    -- Initialize timer
    if ((Jat.Yaw_Mode /= 0 and
        Jat.Yaw_Mode /= 2) and
       (Yaw_Mode_Previous =0 or
        Yaw_Mode_Previous = 2)) then
       Lagfac_Timer.Yaw := 0.0;
    end if;
    -- timer update
    if lagfac_timer.yaw < 1.0 then  -- easy on
         lagfac_timer.yaw := lagfac_timer.yaw + An_Integration_Constant*0.5;-- 2 s timer
         if lagfac_timer.yaw >= 1.0 then
            lagfac_timer.yaw := 1.0;
         end if;
    end if;


    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during autotest roll mode
    -- -----------------------------------------------------------------------------------
    if Lagfac_Timer.Roll < 1.0 then
       -- The following happens only during autotest of the type CFD.
       if Jat.Roll_Mode = 2  then
          Lagfac.Roll  := 1.0;
          Damping_Multiplicator.Roll := 1.0;
       else
          Lagfac.Roll     := An_Integration_Constant;
          Damping_Multiplicator.Roll := 1.5;
       end if;
    end if;


    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during autotest pitch mode
    -- -----------------------------------------------------------------------------------
    if Lagfac_Timer.Pitch < 1.0 then
       -- The following happens only during autotest of the type CFD.
       if Jat.Pitch_Mode = 2  then
          Lagfac.Pitch  := 1.0;
          Damping_Multiplicator.Pitch := 1.0;
       else
          Lagfac.Pitch     := An_Integration_Constant;
          Damping_Multiplicator.Pitch := 1.5;
       end if;
    end if;

    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during autotest yaw mode
    -- -----------------------------------------------------------------------------------
    if Lagfac_Timer.Yaw < 1.0 then
       -- The following happens only during autotest of the type CFD.
       if Jat.Yaw_Mode = 2  then
          Lagfac.Yaw  := 1.0;
          Damping_Multiplicator.Yaw := 1.0;
       else
          Lagfac.Yaw     := An_Integration_Constant;
          Damping_Multiplicator.Yaw := 1.5;
       end if;
    end if;

    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during crash and reposition for roll axis
    -- -----------------------------------------------------------------------------------
    if JAT.At_Phase = 9  or        -- trim  during reposition
      JSA.Trim_Request or          -- trim request during reposition
      ((Jat.At_Phase = 1  or  Jat.At_Phase = 2) and
       (Jat.Roll_Mode /= 0 and Jat.Roll_Mode /= 2)) or  -- autotest trim
      JSA.Crashed or               -- Crash
      Misc_Timer < 1.0 or          -- timer for misc
      IOS_Pilot_Timer < 1.0 or     -- timer for ios_pilot misc force filtering
      Repo_Timer < 1.0 then        -- timer for post-crash and post-reposition

       Lagfac.Roll  := 0.4* An_Integration_Constant;

       Damping_Multiplicator.Roll  := 2.0;  -- increase damping during those period
    end if;

    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during crash and reposition for pitch axis
    -- -----------------------------------------------------------------------------------
    if JAT.At_Phase = 9  or        -- trim  during reposition
      JSA.Trim_Request or          -- trim request during reposition
      ((Jat.At_Phase = 1  or  Jat.At_Phase = 2) and
       (Jat.pitch_Mode /= 0 and Jat.pitch_Mode /= 2)) or -- autotest trim
      JSA.Crashed or               -- Crash
      Misc_Timer < 1.0 or          -- timer for misc
      IOS_Pilot_Timer < 1.0 or     -- timer for ios_pilot misc force filtering
      Repo_Timer < 1.0 then        -- timer for post-crash and post-reposition

       Lagfac.Pitch := 0.4* An_Integration_Constant;

       Damping_Multiplicator.Pitch := 2.0;
    end if;

    -- -----------------------------------------------------------------------------------
    -- setup the lag factors during crash and reposition for yaw axis
    -- -----------------------------------------------------------------------------------
    if JAT.At_Phase = 9  or     -- trim  during reposition
      JSA.Trim_Request or       -- trim request during reposition
      ((Jat.At_Phase = 1  or  Jat.At_Phase = 2) and
       (Jat.Yaw_Mode /= 0 and Jat.Yaw_Mode /= 2)) or  -- autotest trim
      JSA.Crashed or            -- Crash
      Misc_Timer < 1.0 or       -- timer for misc
      IOS_Pilot_Timer < 1.0 or     -- timer for ios_pilot misc force filtering
      Repo_Timer < 1.0 then     -- timer for post-crash and post-reposition

       Lagfac.Yaw  := 0.4* An_Integration_Constant;

       Damping_Multiplicator.Yaw  := 2.0;
    end if;

    -- -----------------------------------------------------------------------------------
    -- set filter whenever in emulated mode
    -- -----------------------------------------------------------------------------------
    if (Jat.Roll_Mode /= 0 and Jat.Roll_Mode /= 2)  then
       Lagfac.Roll  := 0.3* An_Integration_Constant;
       Damping_Multiplicator.Roll  := 2.0;
    end if;
    if (Jat.pitch_Mode /= 0 and Jat.pitch_Mode /= 2)  then
       Lagfac.Pitch  := 0.3* An_Integration_Constant;
       Damping_Multiplicator.Pitch  := 2.0;
    end if;
    if (Jat.yaw_Mode /= 0 and Jat.yaw_Mode /= 2)  then
       lagfac.yaw  := 0.3* An_Integration_Constant;
       damping_multiplicator.yaw  := 2.0;
    end if;

    -- -----------------------------------------------------------------------------------
    -- limit max change in cas (70knots/s)
    -- it should only be during the case where lagfac < 1.0
    -- -----------------------------------------------------------------------------------
    Temp_Cas := Old_Cas;
    Old_Cas := Old_Cas + Lagfac.Pitch*(JSA.Get_Calibrated_Airspeed - Old_Cas);
    if Lagfac.Pitch < 1.0  then
         Delt_cas := Old_Cas - Temp_cas;
         if abs(Delt_cas) > 1.17 then
            if  Delt_cas > 0.0 then
               Old_Cas := Temp_Cas  + 1.17;
            else
               Old_Cas := Temp_Cas  - 1.17;
            end if;
         end if;
    end if;
    Cas := Old_Cas;


    -- -----------------------------------------------------------------------------------
    -- update control loading mode
    -- -----------------------------------------------------------------------------------
    Roll_Mode_Previous  := Jat.Roll_Mode;
    Pitch_Mode_Previous := Jat.Pitch_Mode;
    Yaw_Mode_Previous   := Jat.Yaw_Mode;


    -- -----------------------------------------------------------------------------------
    -- send recorded forces back to dcls during replay in order to compute
    -- control positions in cockpit,
    -- Filtering is to avoid sudden change which can result in stick kicks
    -- -----------------------------------------------------------------------------------
    if (Save_Restore.Replay_In_Progress or Save_Restore.Replay_Trimming)
      and (not(JIP.Is_On and (not JSA.Get_Flight_Freeze))) then

       Stk_Force := Io.DCI_LATL_STK_Force;
       if Misc_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
          Misc_Force.roll := Misc_Force.roll +
            10.0* An_Integration_Constant*(Stk_Force - Misc_Force.roll);
       else
          Misc_Force.roll := Misc_Force.roll +
            Lagfac.roll*(Stk_Force - Misc_Force.roll);
       end if;
       Io.DCO_Latl_Stk_Misc_Force := Misc_Force.Roll;

       Stk_Force := - Io.DCI_LONG_STK_Force;
       if Misc_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
          Misc_Force.pitch := Misc_Force.pitch +
            10.0* An_Integration_Constant*(Stk_Force - Misc_Force.pitch);
       else
          Misc_Force.pitch := Misc_Force.pitch +
            Lagfac.pitch*(Stk_Force - Misc_Force.pitch);
       end if;
       Io.Dco_Long_Stk_Misc_Force := Misc_Force.pitch;

       Stk_Force := - Io.Dci_Dirc_Ped_Force;
       if Misc_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
          Misc_Force.yaw := Misc_Force.yaw +
            10.0* An_Integration_Constant*(Stk_Force - Misc_Force.yaw);
       else
          Misc_Force.yaw := Misc_Force.yaw +
            Lagfac.yaw*(Stk_Force - Misc_Force.yaw);
       end if;
       Io.Dco_Dirc_Ped_Misc_Force := Misc_Force.Yaw;

    elsif (JIP.Is_On and (not JSA.Get_Flight_Freeze)) then
       null;
       -- the misc force get the calculated force.
       -- The code related to it, is implemented in
       -- the appropriate place below.
    else
       Stk_Force := 0.0;
       Misc_Force.roll := Misc_Force.roll + Lagfac.Roll*(Stk_Force - Misc_Force.roll);
       Io.DCO_Latl_Stk_Misc_Force := Misc_Force.Roll;
       stk_force := 0.0;
       Misc_Force.pitch := Misc_Force.pitch + Lagfac.Pitch*(Stk_Force - Misc_Force.pitch);
       Io.Dco_Long_Stk_Misc_Force := Misc_Force.pitch;
       Stk_Force :=  0.0;
       Misc_Force.yaw := Misc_Force.yaw + Lagfac.Yaw*(Stk_Force - Misc_Force.yaw);
       Io.Dco_Dirc_Ped_Misc_Force := Misc_Force.Yaw;
    end if;


    -- ===================================================================================
    --| ailerons and lateral stick
    -- ===================================================================================
    -- -----------------------------------------------------------------------------------
    -- normal operation (force drive) or use stick force from file
    -- -----------------------------------------------------------------------------------
    if (Jat.Roll_Mode = 0 or Jat.Roll_Mode = 2) and
      (not Jip.Roll_Driver_Is_On) then

        Io.Dco_Latl_Stk_Drvr_cmnd_Flag := false;
        if Jat.Roll_Mode = 2 then
            Stk_Force := Jat.Lat_stk_Force;
            Io.DCO_Latl_Stk_Misc_Force := Stk_Force;
        else  -- real pilot force
          Stk_Force := Io.DCI_LATL_STK_Force;
        end if;
        Column_Movement.Assign_Pilot_force
          (Stk_force,
           An_Instance => Subs.The_Lateral_Column_Movement);

        Lat_Stick := Io.Dci_Latl_Stk_Position;
        Column_Movement.Assign_Position
          (Lat_Stick,
           An_Instance => Subs.The_Lateral_Column_Movement);
        -- use unloaded stick approximation to get gearing
        Lat_Stick := Io.Dci_Latl_Stk_Position - 0.11* stk_force;
        avg_ail :=  Io.DCI_Latl_Surf_Position;

        right_Ail := IT.Singly_Indexed.Interpolate(avg_ail,right_ail_T'Access);
        Control_Surface.Assign_Position
          (Right_ail,
           An_Instance => Subs.The_Right_aileron_Position);
        Left_Ail := IT.Singly_Indexed.Interpolate(avg_ail,left_ail_T'Access);
        Control_Surface.Assign_Position
          (Left_ail,
           An_Instance => Subs.The_Left_aileron_Position);
        Gearing.new_Gearing
          (-left_ail,
           gada_T,
           An_Instance => Subs.The_left_aileron_gearing);

        Gearing.new_Gearing
          (right_ail,
           gada_T,
           An_Instance => Subs.The_right_aileron_gearing);
        Left_Ail_Gearing := Gearing.Get_Gearing
          (An_Instance => Subs.The_left_aileron_gearing);
        right_Ail_Gearing := Gearing.Get_Gearing
          (An_Instance => Subs.The_Right_Aileron_Gearing);
        Right_Gear_Sq := Right_Ail_Gearing * Right_Ail_Gearing;
        Left_Gear_Sq := Left_Ail_Gearing * Left_Ail_Gearing;
        Avg_Ail_Gear :=  0.5 * (Left_ail_gearing + Right_ail_Gearing);

        Lateral_Gradient := Float'Min((Left_Gear_Sq * Jab.Left_Ail_Hm_pd +
                                Right_Gear_Sq * Jab.Right_Ail_Hm_Pd)/
                               (Avg_Ail_Gear* Avg_Ail_Gear), -0.001);

        -- Filtering ---------------------------------------------------------------------
        Aero_Grad.Roll := Aero_Grad.Roll +
          lagfac.roll*(Lateral_Gradient - Aero_Grad.Roll);
        Io.DCO_Latl_Surf_Aero_Hmd := Aero_Grad.Roll; -- output to DCLS

        Filtered_Damper.Roll := Filtered_Damper.Roll +
          Lagfac.Roll*(Damping_Multiplicator.Roll*
                       Float'Max (0.1,
                                  Float'Min((-0.3 +  0.002 * JSA.Get_Calibrated_Airspeed),
                                            0.2)) - Filtered_Damper.Roll);
        Io.DCO_Latl_Surf_aero_Damping := Filtered_Damper.Roll;


        Left_Hm := Jab.Left_Ail_Hm;
        Right_Hm := Jab.Right_Ail_Hm;

        ail_neutral:= Avg_Ail -
          (Left_Hm * Left_Ail_Gearing + Right_Hm * right_ail_gearing)/
          (Avg_Ail_Gear * Lateral_Gradient);

        -- Filtering ---------------------------------------------------------------------
        Neutral_Position.Roll := Neutral_Position.Roll
          + Lagfac.Roll*(Ail_Neutral - Neutral_Position.Roll);

        Io.DCO_Latl_surf_Neutral := Neutral_Position.Roll;  -- output to DCLS

        -- emulation force during normal operation ---------------------------------------
        Lat_Stick := Io.Dci_Latl_Stk_Position + 0.11* stk_force; -- loaded stick
        Column_Movement.Set_Spring_Hm
          (Lat_Stick     ,
           Tab_Pos       ,
           0.0           ,
           FLATSPRING_T  ,
           An_Instance => Subs.The_Lateral_Column_Movement);


        Lat_Force := - Lateral_Gradient * (Avg_Ail - ail_Neutral)* Avg_Ail_Gear -
          Column_Movement.Get_Spring_Hm
          (An_Instance => Subs.The_Lateral_Column_Movement) * 1.633;

        Tab_Pos := Tab_Pos +
          Lagfac.Roll*(JPATS_Secondary_Flight_Controls.Aileron_Trim_Position - Tab_Pos);

        Io.DCO_Latl_Tab_pos := Tab_Pos; -- output to DCLS


    else


        -- --------------------------------------------------------------------------------
        --  use recorded aileron positions (1) and closed loop driver (3) for autotest
        -- --------------------------------------------------------------------------------
       if (Jat.Roll_Mode = 1)  or  (Jat.Roll_Mode = 3) then
          Control_Surface.Assign_Position
            (JAT.R_Ail_pos,
             An_Instance => Subs.The_Right_Aileron_Position);
          if Jat.Roll_Mode = 1 then  -- recorded left aileron
             Control_Surface.Assign_Position
               (JAT.L_Ail_pos,
                An_Instance => Subs.The_Left_Aileron_Position);
          else -- compute left from right
             Left_Ail := IT.Singly_Indexed.Interpolate
               (JAT.R_Ail_pos,other_ail_t'access);
             Control_Surface.Assign_Position
               (Left_Ail,
                An_Instance => Subs.The_Left_Aileron_Position);
          end if;

          --  look up unloaded stick position  (based on right ail position)
          Column_Movement.Set_Position
            (JAT.R_Ail_pos,
             DADLAT_INV_T   ,
             An_Instance => Subs.The_Lateral_Column_Movement);
       else
          -- --------------------------------------------------------------------------------
          --  use calculated aileron positions for IOS Pilot
          -- --------------------------------------------------------------------------------
          Control_Surface.Assign_Position
            (Jip.R_Ail_pos,
             An_Instance => Subs.The_Right_Aileron_Position);
          -- compute left from right
          Left_Ail := IT.Singly_Indexed.Interpolate
            (Jip.R_Ail_pos,other_ail_t'access);
          Control_Surface.Assign_Position
            (Left_Ail,
             An_Instance => Subs.The_Left_Aileron_Position);
          --  look up unloaded stick position  (based on right ail position)
          Column_Movement.Set_Position
            (Jip.R_Ail_pos,
             DADLAT_INV_T   ,
             An_Instance => Subs.The_Lateral_Column_Movement);
       end if;

       Lat_Stick := Column_Movement.Get_Position
         (An_Instance => Subs.The_Lateral_Column_Movement);
       Hinge_moment := Jab.Left_Ail_Hm + Jab.Right_Ail_Hm;
       Tab_Pos := JPATS_Secondary_Flight_Controls.Aileron_Trim_Position;

        Column_Movement.Set_Spring_Hm
          (Lat_Stick     ,
           Tab_Pos   ,
           0.0        ,
           FLATSPRING_T  ,
           An_Instance => Subs.The_Lateral_Column_Movement);
        left_ail := control_surface.Get_Position
          ( An_Instance => Subs.The_left_aileron_position);
        right_ail := control_surface.Get_Position
          ( An_Instance => Subs.The_right_aileron_position);
        Avg_Ail := (Left_Ail + Right_Ail) /2.0;
        Gearing.new_Gearing
          (-left_ail,
           gada_T,
           An_Instance => Subs.The_left_aileron_gearing);

        Gearing.new_Gearing
          (right_ail,
           gada_T,
           An_Instance => Subs.The_right_aileron_gearing);
        Left_Ail_Gearing := Gearing.Get_Gearing
          (An_Instance => Subs.The_left_aileron_gearing);
        right_Ail_Gearing := Gearing.Get_Gearing
          (An_Instance => Subs.The_Right_Aileron_Gearing);

        Right_Gear_Sq := Right_Ail_Gearing * Right_Ail_Gearing;
        Left_Gear_Sq := Left_Ail_Gearing * Left_Ail_Gearing;
        Avg_Ail_Gear :=  0.5 * (Left_ail_gearing + Right_ail_Gearing);

        Lateral_Gradient :=  Float'Min((Left_Gear_Sq * Jab.Left_Ail_Hm_pd +
                                        Right_Gear_Sq * Jab.Right_Ail_Hm_Pd)/
                                       (Avg_Ail_Gear* Avg_Ail_Gear), -0.001);


        Left_Hm := Jab.Left_Ail_Hm;
        Right_Hm := Jab.Right_Ail_Hm;
        ail_Neutral := Avg_Ail -
          (Left_Hm * Left_Ail_Gearing + Right_Hm * right_ail_gearing)/
          (Avg_Ail_Gear * Lateral_Gradient);    -- output to DCLS
        Lat_Force := - Lateral_Gradient * (Avg_Ail - ail_Neutral)* Avg_Ail_Gear -
          Column_Movement.Get_Spring_Hm
          (An_Instance => Subs.The_Lateral_Column_Movement) * 1.633;

        column_Movement.assign_Pilot_Force
          (lat_Force,
           An_Instance => Subs.The_Lateral_Column_Movement);
        Lat_Stick := Lat_Stick + 0.11 * Lat_Force;
        Column_Movement.Assign_Position
          (Lat_Stick,
           An_Instance => Subs.The_Lateral_Column_Movement);

        Aero_Grad.Roll := Aero_Grad.Roll +
          Lagfac.Roll*(Lateral_Gradient - Aero_Grad.Roll);
        Io.DCO_Latl_Surf_Aero_Hmd := Aero_Grad.Roll; -- output to DCLS

        Neutral_Position.Roll := Neutral_Position.Roll
          + Lagfac.Roll*(Ail_Neutral - Neutral_Position.Roll);
        Io.DCO_Latl_surf_Neutral := Neutral_Position.Roll;  -- output to DCLS
        Tab_Pos := Tab_Pos +
          Lagfac.Roll*(JPATS_Secondary_Flight_Controls.Aileron_Trim_Position - Tab_Pos);
        Io.DCO_Latl_Tab_pos := Tab_Pos; -- output to DCLS


        Filtered_Damper.Roll := Filtered_Damper.Roll +
          Lagfac.Roll*(Damping_Multiplicator.Roll*
                       Float'Max (0.1,
                                  Float'Min((-0.3 +  0.002 * JSA.Get_Calibrated_Airspeed),
                                            0.2)) - Filtered_Damper.Roll);
        Io.DCO_Latl_Surf_aero_Damping := Filtered_Damper.Roll;


        if (JIP.Is_On and (not JSA.Get_Flight_Freeze)) then
              if JIP.Roll_Backdrive then
                 Stk_Force := JIP.Roll_Backdrive_Force;
              else
                 Stk_Force := 0.0;
              end if;
              if IOS_Pilot_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
                 Misc_Force.roll := Misc_Force.roll +
                   5.0* An_Integration_Constant*(Stk_Force - Misc_Force.roll);
              else
                 Misc_Force.roll := Misc_Force.roll +
                   Lagfac.roll*(Stk_Force - Misc_Force.roll);
              end if;
              Io.DCO_Latl_Stk_Misc_Force := Misc_Force.Roll;

        end if;
    end if;


    -- ===================================================================================
    --| Long Stick and elev
    -- ===================================================================================
    -- -----------------------------------------------------------------------------------
    -- normal operation (force drive: 0) and use stick force from file (2)
    -- -----------------------------------------------------------------------------------
    if (Jat.Pitch_Mode = 0 or Jat.Pitch_Mode = 2) and
      (not Jip.Pitch_Driver_Is_On)  then

       if Jat.Pitch_Mode = 2 then
            Long_Force := Jat.long_stk_Force;
            Io.DCO_Long_Stk_Misc_Force := long_Force;
       else
          long_Force := - Io.DCI_LONG_STK_Force;
       end if;

        Column_Movement.Assign_Pilot_force
          (long_force,
           An_Instance => Subs.The_Longitudinal_Column_Movement);

        Long_stick := Io.DCI_Long_Stk_Position;

        Column_Movement.Assign_Position
          (Long_Stick,
           An_Instance => Subs.The_Longitudinal_Column_Movement);

        Column_Movement.Set_Bob_Weight_Force
          (Long_stick        ,
           Load_Factor       ,
           FBWDLONG_T        ,
           An_Instance => Subs.The_Longitudinal_Column_Movement);

        Surf_Pos  := Io.DCI_Long_Surf_Position;

        Control_Surface.Assign_Position
          (Surf_pos,
           An_Instance => Subs.The_Elevator_Position);

        Aero_Grad.Pitch := Aero_Grad.Pitch +
          Lagfac.Pitch * (Jab.Elev_Aero_Hm_Pd - Aero_Grad.Pitch);
        Io.DCO_Long_Surf_Aero_HMD := Aero_Grad.Pitch;

        -- compute aero damping
        if Cas <= 110.0 then
          Temp := 0.11;
        elsif cas < 120.0 then
           Temp := 0.11 + (Cas - 110.0)* 0.006;
        elsif Cas <= 135.0 then
           Temp := 0.17;
        elsif Cas <= 190.0 then
           Temp := 0.17 - (Cas - 135.0) * 0.000_7272_73;
        else
           Temp := 0.13;
        end if;

        Filtered_Damper.Pitch := Filtered_Damper.Pitch +
          Lagfac.Pitch * (Damping_Multiplicator.Pitch*Temp - Filtered_Damper.pitch);
        Io.DCO_Long_Surf_aero_Damping := Filtered_Damper.Pitch;


        Dcls_Temp_Var := Neutral_Position.Pitch;

        Neutral_Position.Pitch := Neutral_Position.Pitch +
          Lagfac.Pitch* (Jab.Elev_Aero_Neutral_Pos - Neutral_Position.Pitch);

        if JSA.Trim_Request or JSA.Crashed  then
           -- limit the elevator deflection rate to 20 degree/s
           if abs(Neutral_Position.Pitch - Dcls_Temp_Var)> 0.33334 then
              if (Neutral_Position.Pitch - Dcls_Temp_Var)> 0.0 then
                 Neutral_Position.Pitch := Dcls_Temp_Var + 0.33334;
              else
                 Neutral_Position.Pitch := Dcls_Temp_Var - 0.33334;
              end if;
           end if;
        end if;

        Io.DCO_Long_surf_Neutral := Neutral_Position.Pitch;

        Bob_Weight:=Bob_Weight + Lagfac.Pitch*
          (1.63 * Column_Movement.Get_Bob_Weight_Force
           (An_Instance => Subs.The_Longitudinal_Column_Movement)- Bob_Weight);
        Io.DCO_Long_Bob_weight    := Bob_Weight;

        -- emulated force
        -- note bobweight force not multiplied by 1.63 to get moment
        f_Mass := Column_Movement.Get_bob_weight_force
          (An_Instance => Subs.The_Longitudinal_Column_Movement);
        hm := -Jab.Elev_Aero_Hm_Pd * (-Surf_Pos + Neutral_Position.Pitch);
        Gearing.set_Gearing
          (long_Stick,
           gedlong_T,
           An_Instance => Subs.The_elevator_gearing);
        hm_Spring := 9.0 - 0.086 * surf_pos;
        gear := Gearing.get_Gearing(An_Instance => Subs.The_elevator_gearing);
        long_Force := - gear *(hm_Spring + Hm) - f_Mass;

    else
       -- --------------------------------------------------------------------------------
       -- elevator surface drive (emulated forces)
       -- compute stick force and loaded stick position for autotest output
       -- store input autotest elevator position for use by flight
       -- --------------------------------------------------------------------------------

       -- --------------------------------------------------------------------------------
       --  use recorded aileron positions (1) and closed loop driver (3) for autotest
       --  follow CAS (4) or Follow Ground Speed (5)
       -- --------------------------------------------------------------------------------
       if   Jat.Pitch_Mode = 1  or  Jat.Pitch_Mode = 3 or Jat.Pitch_Mode = 4 or Jat.Pitch_Mode = 5 then
          Control_Surface.Assign_Position
            (JAT.Elev_pos,
             An_Instance => Subs.The_Elevator_Position);

          -- compute unloaded stick position
          Column_Movement.Set_Position
            (JAT.Elev_pos,
             DEDLONG_INV_T  ,
             An_Instance => Subs.The_Longitudinal_Column_Movement);

       elsif Jip.Pitch_Driver_Is_On then
          -- --------------------------------------------------------------------------------
          --  use calculated elevator positions from IOS Pilot
          -- --------------------------------------------------------------------------------
          Control_Surface.Assign_Position
            (Jip.Elev_pos,
             An_Instance => Subs.The_Elevator_Position);

          -- compute unloaded stick position
          Column_Movement.Set_Position
            (Jip.Elev_pos,
             DEDLONG_INV_T  ,
             An_Instance => Subs.The_Longitudinal_Column_Movement);

       else
          Control_Surface.Assign_Position
            (JAT.Elev_pos,
             An_Instance => Subs.The_Elevator_Position);

          -- compute unloaded stick position
          Column_Movement.Set_Position
            (JAT.Elev_pos,
             DEDLONG_INV_T  ,
             An_Instance => Subs.The_Longitudinal_Column_Movement);

       end if;

        -- spring hinge moment
        hm_Spring := 9.0 - 0.086 * JAT.Elev_Pos;

        -- inertia effects
        long_Stick := column_Movement.get_Position
          (An_Instance => Subs.The_Longitudinal_Column_Movement);
        Column_Movement.Set_Bob_Weight_Force -- really force at stick
          (Long_stick        ,
           Load_Factor       ,
           FBWDLONG_T        ,
           An_Instance => Subs.The_Longitudinal_Column_Movement);

        -- final stick force and loaded stick position
        Gearing.set_Gearing
          (long_Stick,
           gedlong_T,
           An_Instance => Subs.The_elevator_gearing);

        gear := Gearing.get_Gearing(An_Instance => Subs.The_elevator_gearing);

        f_Mass := Column_Movement.Get_bob_weight_force
          (An_Instance => Subs.The_Longitudinal_Column_Movement);

        hm := -Jab.Elev_Aero_Hm_Pd * (JAT.Elev_Pos + Jab.Elev_Aero_Neutral_Pos);

        long_Force := - gear *(hm_Spring + Hm) - f_Mass;

        -- loaded position
        long_stick := long_Stick - 0.04 * long_Force;

        -- store into instance for autotest output
        column_Movement.assign_Position
          ( -long_stick,  -- sign change on emulator 7/7
            An_Instance => Subs.The_Longitudinal_Column_Movement);

        column_Movement.assign_Pilot_Force
          (long_Force,
           An_Instance => Subs.The_Longitudinal_Column_Movement);



        Aero_Grad.Pitch := Aero_Grad.Pitch +
          Lagfac.Pitch * (Jab.Elev_Aero_Hm_Pd - Aero_Grad.Pitch);
        Io.DCO_Long_Surf_Aero_HMD := Aero_Grad.Pitch;

        Dcls_Temp_Var := Neutral_Position.Pitch;

        Neutral_Position.Pitch := Neutral_Position.Pitch
          + Lagfac.Pitch * (Jab.Elev_Aero_Neutral_Pos - Neutral_Position.Pitch);

        if JSA.Trim_Request then
           -- limit the elevator deflection rate to 20 degree/s
           if abs(Neutral_Position.Pitch - Dcls_Temp_Var)> 0.33334 then
              if (Neutral_Position.Pitch - Dcls_Temp_Var)> 0.0 then
                 Neutral_Position.Pitch := Dcls_Temp_Var + 0.3334;
              else Neutral_Position.Pitch := Dcls_Temp_Var - 0.3334;
              end if;
           end if;
        end if;

        Io.DCO_Long_surf_Neutral  := Neutral_Position.Pitch;

        Bob_Weight:=Bob_Weight + Lagfac.Pitch*
          (1.63 * Column_Movement.Get_Bob_Weight_Force
           (An_Instance => Subs.The_Longitudinal_Column_Movement)- Bob_Weight);
        Io.DCO_Long_Bob_weight    := Bob_Weight;

        -- compute aero damping
        if Cas <= 110.0 then
           Temp := 0.11;
        elsif cas < 120.0 then
           Temp := 0.11 + (Cas - 110.0)* 0.006;
        elsif Cas <= 135.0 then
           Temp := 0.17;
        elsif Cas <= 190.0 then
           Temp := 0.17 - (Cas - 135.0) * 0.000_7272_73;
        else
           Temp := 0.13;
        end if;
        Filtered_Damper.Pitch := Filtered_Damper.Pitch +
          Lagfac.Pitch * (Damping_Multiplicator.Pitch*Temp - Filtered_Damper.pitch);
        Io.DCO_Long_Surf_aero_Damping := Filtered_Damper.Pitch;

        if (JIP.Is_On and (not JSA.Get_Flight_Freeze)) then

           if JIP.Pitch_Backdrive then
              Stk_Force := -JIP.Pitch_Backdrive_Force;
           else
              Stk_Force := 0.0;
           end if;

           if IOS_Pilot_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
              Misc_Force.pitch := Misc_Force.pitch +
                5.0* An_Integration_Constant*(Stk_Force - Misc_Force.pitch);
           else
              Misc_Force.pitch := Misc_Force.pitch +
                Lagfac.pitch*(Stk_Force - Misc_Force.pitch);
           end if;
           Io.Dco_Long_Stk_Misc_Force := Misc_Force.pitch;


        end if;

    end if;



    -- ===================================================================================
    -- pedals and rudder
    -- ===================================================================================
    -- -----------------------------------------------------------------------------------
    -- normal operation (force drive) or  use pedal force from file
    -- -----------------------------------------------------------------------------------
    if (Jat.Yaw_Mode = 0 or Jat.Yaw_Mode = 2) and
      (not Jip.Yaw_Driver_Is_On) then

       if Jat.Yaw_Mode = 2 then
          Stk_Force :=  Jat.Pedal_Force;
          Io.Dco_Dirc_Ped_Misc_Force := stk_force;
       else  -- real pilot force
          Stk_Force :=  - Io.Dci_Dirc_Ped_Force; -- sign change 7/21
       end if;
       Pedals.Assign_force
         (Stk_force,
          An_Instance => Subs.The_pedals);
       Pedal := Io.DCI_Dirc_Ped_Position;
       Pedals.Assign_Position
         (Pedal, An_Instance => Subs.The_Pedals);
       Surf_Pos   := Io.DCI_dirc_Surf_Position;

       Control_Surface.Assign_Position
         (Surf_pos,An_Instance => Subs.The_rudder_Position);

       Aero_Grad.Yaw := Aero_Grad.Yaw +
         Lagfac.Yaw*(Jab.Rud_Aero_Hm_Pd - Aero_Grad.Yaw);
       Io.DCO_Dirc_Surf_Aero_Hmd := Aero_Grad.Yaw; -- output to DCLS

       if Cas <= 133.0 then
          Temp := 0.4;
       elsif Cas >= 192.0 then
          Temp := 0.2;
       else
          Temp := 0.4 - (Cas - 133.0) * 0.00338983;
       end if;

       Filtered_Damper.yaw := Filtered_Damper.yaw +
         Lagfac.Yaw * (Damping_Multiplicator.Yaw*Temp - Filtered_Damper.yaw);
       Io.DCO_Dirc_Surf_Aero_Damping := Filtered_Damper.yaw;


       if Cas < 96.0 then
          Temp := 1.0 - Cas * 0.004167;
       elsif Cas <= 133.0 then
          Temp := 0.6;
       elsif Cas <192.0 then
          Temp := 0.6 - (Cas - 133.0) * 0.00508475;
       else
          Temp := 0.3;
       end if;


       Filtered_Yaw_Friction := Filtered_Yaw_Friction +
         Lagfac.Yaw * (Temp - Filtered_Yaw_Friction);
       Io.Dco_Dirc_Frict_Gain := Filtered_Yaw_Friction;


       Dcls_Temp_Var := Neutral_Position.Yaw;
       Neutral_Position.Yaw := Neutral_Position.Yaw
         + Lagfac.Yaw*(Jab.Rud_Aero_Neutral_Pos - Neutral_Position.Yaw);

       if JSA.Trim_Request or JSA.Crashed  then
          -- limit the elevator deflection rate to 20 degree/s
          if abs(Neutral_Position.Yaw - Dcls_Temp_Var)> 0.33334 then
             if (Neutral_Position.Yaw - Dcls_Temp_Var)> 0.0 then
                Neutral_Position.Yaw := Dcls_Temp_Var + 0.33334;
             else
                Neutral_Position.Yaw := Dcls_Temp_Var - 0.33334;
             end if;
          end if;
       end if;
       Io.DCO_Dirc_surf_Neutral := Neutral_Position.Yaw;  -- output to DCLS

       -- emulated force

       Gearing.set_Gearing
         (pedal,
          grdped_T,
          An_Instance => Subs.The_rudder_gearing);
       gear := Gearing.get_Gearing(An_Instance => Subs.The_rudder_gearing);
       Hm := -Jab.Rud_Aero_Hm_Pd
         * (surf_pos + Jab.Rud_Aero_Neutral_Pos);
       Temp := Jab.Get_Rudder_Spring_Hinge_Moment;
       Ped_Mom := - Gear * (Hm + Temp);
       if Ped_Mom > 0.0 then
          l_Ped := 0.90 + 0.00186 * Pedal - 0.000_035 * Pedal * Pedal;
       else
          l_Ped := 0.90 - 0.00186 * Pedal - 0.000_035 * Pedal * Pedal;
       end if;
       pedal_force := Ped_Mom/L_Ped;

    else
       -- --------------------------------------------------------------------------------
       -- Jat.Yaw_Mode = 1 or   -- Open loop rudder
       -- Jat.Yaw_Mode = 3 or   -- closed loop heading
       -- Jat.Yaw_Mode = 4 then -- closed loop sideslip
       -- --------------------------------------------------------------------------------
       if (Jat.Yaw_Mode = 1) or (Jat.Yaw_Mode = 3) or (Jat.Yaw_Mode = 4) then
          Control_Surface.Assign_Position
            (JAT.Rud_pos,
             An_Instance => Subs.The_Rudder_Position);
          Pedals.Set_Position
            (JAT.Rud_pos,
             DRDPED_INV_T   ,
             An_Instance => Subs.The_Pedals);

       elsif Jip.Yaw_Driver_Is_On then
          -- --------------------------------------------------------------------------------
          --  use calculated rudder positions for IOS Pilot
          -- --------------------------------------------------------------------------------
          Control_Surface.Assign_Position
            (Jip.Rud_pos,
             An_Instance => Subs.The_Rudder_Position);
          Pedals.Set_Position
            (Jip.Rud_pos,
             DRDPED_INV_T   ,
             An_Instance => Subs.The_Pedals);
       else
          Control_Surface.Assign_Position
            (JAT.Rud_pos,
             An_Instance => Subs.The_Rudder_Position);
          Pedals.Set_Position
            (JAT.Rud_pos,
             DRDPED_INV_T   ,
             An_Instance => Subs.The_Pedals);
       end if;
       Pedal := Pedals.Get_Position
         (An_Instance => Subs.The_Pedals);
       Gearing.set_Gearing
         (pedal,
          grdped_T,
          An_Instance => Subs.The_rudder_gearing);
       gear := Gearing.Get_Gearing
         (An_Instance => Subs.The_rudder_gearing);

       Hm := -Jab.Rud_Aero_Hm_Pd * (JAT.Rud_Pos
                                    + Jab.Rud_Aero_Neutral_Pos);
       Temp := Jab.Get_Rudder_Spring_Hinge_Moment;
       Ped_Mom := - Gear * (Hm + Temp);
       Pedal := Pedal - 0.016 * Ped_Mom;
       Pedals.Assign_Position(Pedal,An_Instance => Subs.The_Pedals);
       if Ped_Mom > 0.0 then
          l_Ped := 0.90 + 0.00186 * Pedal - 0.000_035 * Pedal * Pedal;
       else
          l_Ped := 0.90 - 0.00186 * Pedal - 0.000_035 * Pedal * Pedal;
       end if;

       pedal_force := Ped_Mom/L_Ped;
       Pedals.Assign_Force(pedal_force,An_Instance => Subs.The_Pedals);

       Aero_Grad.Yaw := Aero_Grad.Yaw +
         Lagfac.Yaw*(Jab.Rud_Aero_Hm_Pd - Aero_Grad.Yaw);
       Io.DCO_Dirc_Surf_Aero_Hmd := Aero_Grad.Yaw; -- output to DCLS

       Dcls_Temp_Var := Neutral_Position.Yaw;
       Neutral_Position.Yaw := Neutral_Position.Yaw  +
         Lagfac.Yaw*(Jab.Rud_Aero_Neutral_Pos - Neutral_Position.Yaw);
       if JSA.Trim_Request or JSA.Crashed  then
          -- limit the elevator deflection rate to 20 degree/s
          if abs(Neutral_Position.Yaw - Dcls_Temp_Var)> 0.33334 then
             if (Neutral_Position.Yaw - Dcls_Temp_Var)> 0.0 then
                Neutral_Position.Yaw := Dcls_Temp_Var + 0.33334;
             else
                Neutral_Position.Yaw := Dcls_Temp_Var - 0.33334;
             end if;
          end if;
       end if;
       Io.DCO_Dirc_surf_Neutral := Neutral_Position.Yaw;  -- output to DCLS

       if Cas <= 133.0 then
          Temp := 0.4;
       elsif Cas >= 192.0 then
          Temp := 0.2;
       else
          Temp := 0.4 - (Cas - 133.0) * 0.00338983;
       end if;

       Filtered_Damper.yaw := Filtered_Damper.yaw +
         Lagfac.Yaw * (Damping_Multiplicator.Yaw*Temp - Filtered_Damper.yaw);
       Io.DCO_Dirc_Surf_Aero_Damping := Filtered_Damper.yaw;

       if Cas < 96.0 then
          Temp := 1.0 - Cas * 0.004167;
       elsif Cas <= 133.0 then
          Temp := 0.6;
       elsif Cas <192.0 then
          Temp := 0.6 - (Cas - 133.0) * 0.00508475;
       else
          Temp := 0.3;
       end if;

       Filtered_Yaw_Friction := Filtered_Yaw_Friction +
         Lagfac.Yaw * (Temp - Filtered_Yaw_Friction);
       Io.Dco_Dirc_Frict_Gain := Filtered_Yaw_Friction;



       if (JIP.Is_On and (not JSA.Get_Flight_Freeze)) then
          if JIP.Yaw_Backdrive then
             Stk_Force := -JIP.Yaw_Backdrive_Force;
          else
             Stk_Force := 0.0;
          end if;

          if IOS_Pilot_Timer > 0.9 and (not Jfi.Stick_Shaker_Is_Active) then
             Misc_Force.yaw := Misc_Force.yaw +
               5.0* An_Integration_Constant*(Stk_Force - Misc_Force.yaw);
          else
             Misc_Force.yaw := Misc_Force.yaw +
               Lagfac.yaw*(Stk_Force - Misc_Force.yaw);
          end if;
          Io.Dco_Dirc_Ped_Misc_Force := Misc_Force.Yaw;

       end if;
    end if;

    -- -----------------------------------------------------------------------------------
    -- Pump up features for pedals
    -- -----------------------------------------------------------------------------------
    Io.DCO_TBKL_K_PUMP := JPATS_Landing_Gear.Left_Brake_K_Pump;
    Io.DCO_TBKR_K_PUMP := JPATS_Landing_Gear.Right_Brake_K_Pump;


    -- -----------------------------------------------------------------------------------
    -- Toe Brake malfunctions
    -- -----------------------------------------------------------------------------------
    if JPATS_Landing_Gear.Left_Brake_Back_Px < 1.0 then
       IO.Dco_TBKL_MALF_FLAG  := True;
    else
       IO.Dco_TBKL_MALF_FLAG  := False;
    end if;

    if JPATS_Landing_Gear.Right_Brake_Back_Px < 1.0 then
       IO.Dco_TBKR_MALF_FLAG  := True;
    else
       IO.Dco_TBKR_MALF_FLAG  := False;
    end if;
    -- End  Pedals

    -- -----------------------------------------------------------------------------------
    -- Send information on autotest status
    -- -----------------------------------------------------------------------------------
    if  JAT.At_Phase > 0 and not Jat.Manual_Test  then
       IO.Dco_Autotest_number  := Jat.Test_Number;
    else
       IO.Dco_Autotest_number  :=  0;
    end if;
    IO.Dco_Autotest_phase  := JAT.At_Phase;


    
--- -----------------------------------------------------------------------------------
    -- Debug purposes
    --------------------------------------------------------------------------------------
    if IOS.DCLS_Int_01 = 1 then
       IOS.DCLS_Float_01 := IO.DCO_LONG_SURF_AERO_HMD;
       IOS.DCLS_Float_02 := IO.DCO_LONG_SURF_AERO_DAMPING;
       IOS.DCLS_Float_03 := IO.DCO_LONG_SURF_NEUTRAL;
       IOS.DCLS_Float_04 := IO.DCO_LONG_STK_MISC_FORCE;
       IOS.DCLS_Float_05 := Bool_to_Float(IO.DCO_LONG_SURF_DRVR_FLAG);
       IOS.DCLS_Float_06 := IO.DCO_LONG_SURF_DRVR_CMND;
       IOS.DCLS_Float_07 := Bool_to_Float(IO.DCO_LONG_SURF_JAM);
       IOS.DCLS_Float_08 := Bool_to_Float(IO.DCO_LONG_STK_DRVR_FLAG);
       IOS.DCLS_Float_09 := Bool_to_Float(IO.DCO_LONG_STK_JAM);
       IOS.DCLS_Float_10:= IO.DCO_LONG_CABLE_STIFF;
       IOS.DCLS_Float_11:= IO.DCO_LONG_FRICT_GAIN;
       IOS.DCLS_Float_12:= IO.DCO_LONG_BOB_WEIGHT;
       IOS.DCLS_Float_13:= IO.DCO_LATL_SURF_AERO_HMD;
       IOS.DCLS_Float_14:= IO.DCO_LATL_SURF_AERO_DAMPING;
       IOS.DCLS_Float_15:= IO.DCO_LATL_SURF_NEUTRAL;
       IOS.DCLS_Float_16:= IO.DCO_LATL_STK_MISC_FORCE;
       IOS.DCLS_Float_17:= Bool_to_Float(IO.DCO_LATL_SURF_DRVR_FLAG);
       IOS.DCLS_Float_18:= IO.DCO_LATL_SURF_DRVR_CMND;
       IOS.DCLS_Float_19:= Bool_to_Float(IO.DCO_LATL_SURF_JAM);
       IOS.DCLS_Float_20:= Bool_to_Float(IO.DCO_LATL_STK_DRVR_CMND_FLAG);
       IOS.DCLS_Float_21:= IO.DCO_LONG_SURF_NEUTRAL;
       IOS.DCLS_Float_22:= Bool_to_Float(IO.DCO_LATL_SURF_JAM);
       IOS.DCLS_Float_23:= Bool_to_Float(IO.DCO_LONG_SURF_DRVR_FLAG);
       IOS.DCLS_Float_24:= IO.DCO_LATL_STK_DRVR_CMND;
       IOS.DCLS_Float_25:= Bool_to_Float(IO.DCO_LATL_STK_JAM);
       IOS.DCLS_Float_26:= IO.DCO_LATL_FRICT_GAIN;
       IOS.DCLS_Float_27:= IO.DCO_LATL_CABLE_STIFF;
       IOS.DCLS_Float_28 := IO.DCO_LATL_TAB_POS;
       IOS.DCLS_Float_29 := IO.DCO_DIRC_SURF_AERO_HMD;
       IOS.DCLS_Float_30 := IO.DCO_DIRC_SURF_AERO_DAMPING;
	elsif IOS.DCLS_Int_01 = 2 then
       IOS.DCLS_Float_01:= IO.DCO_DIRC_SURF_NEUTRAL;
       IOS.DCLS_Float_02:= IO.DCO_DIRC_PED_MISC_FORCE;
       IOS.DCLS_Float_03:= Bool_to_Float(IO.DCO_DIRC_SURF_DRVR_FLAG);
       IOS.DCLS_Float_04:= IO.DCO_DIRC_SURF_DRVR_CMND;
       IOS.DCLS_Float_05:= Bool_to_Float(IO.DCO_DIRC_SURF_JAM);
       IOS.DCLS_Float_06:= Bool_to_Float(IO.DCO_DIRC_PED_DRVR_CMND_FLAG);
       IOS.DCLS_Float_07:= IO.DCO_DIRC_PED_DRVR_CMND;
       IOS.DCLS_Float_08:= Bool_to_Float(IO.DCO_DIRC_PED_JAM);
       IOS.DCLS_Float_09:= IO.DCO_DIRC_FRICT_GAIN;
       IOS.DCLS_Float_10:= IO.DCO_DIRC_CABLE_STIFF;
       IOS.DCLS_Float_11:= IO.DCO_TBKL_K_PUMP;
       IOS.DCLS_Float_12:= Bool_to_Float(IO.DCO_TBKL_MALF_FLAG);
       IOS.DCLS_Float_13:= IO.DCO_TBKR_K_PUMP;
       IOS.DCLS_Float_14:= Bool_to_Float(IO.DCO_TBKR_MALF_FLAG);
       IOS.DCLS_Float_15:= Bool_to_Float(IO.DCO_DIRC_PED_DRVR_CMND_FLAG);
       IOS.DCLS_Float_16:= IO.DCO_DIRC_PED_DRVR_CMND;
       IOS.DCLS_Float_17:= Bool_to_Float(IO.DCO_DIRC_PED_JAM);
       IOS.DCLS_Float_18:= IO.DCO_DIRC_FRICT_GAIN;
       IOS.DCLS_Float_19:= IO.DCO_DIRC_CABLE_STIFF;
       IOS.DCLS_Float_20:= IO.DCO_TBKL_K_PUMP;
       IOS.DCLS_Float_21:= Bool_to_Float(IO.DCO_TBKL_MALF_FLAG);
       IOS.DCLS_Float_22:= IO.DCO_TBKR_K_PUMP;
       IOS.DCLS_Float_23:= IO.DCO_SEAT_PRIM_FLTAZA;
       IOS.DCLS_Float_24:= IO.DCO_SEAT_Z_AXIS_SPEF;
       IOS.DCLS_Float_25:= IO.DCO_SEAT_CYL_DISCR_INPUT;
       IOS.DCLS_Float_26:= Bool_to_Float(IO.DCO_SEAT_FREEZE_FLAG);
	elsif IOS.DCLS_Int_01 = 3 then
       IOS.DCLS_Float_01:= IO.DCO_SEAT_SINE_1_AMPL;
       IOS.DCLS_Float_02:= IO.DCO_SEAT_SINE_2_AMPL;
       IOS.DCLS_Float_03:= IO.DCO_SEAT_SINE_3_AMPL;
       IOS.DCLS_Float_04:= IO.DCO_SEAT_SINE_4_AMPL;
       IOS.DCLS_Float_05:= IO.DCO_SEAT_SINE_5_AMPL;
       IOS.DCLS_Float_06:= IO.DCO_SEAT_SINE_6_AMPL;
       IOS.DCLS_Float_07:= IO.DCO_SEAT_SINE_7_AMPL;
       IOS.DCLS_Float_08:= IO.DCO_SEAT_SINE_8_AMPL;
       IOS.DCLS_Float_09:= IO.DCO_SEAT_SINE_9_AMPL;
       IOS.DCLS_Float_10:= IO.DCO_SEAT_SINE_10_AMPL;
       IOS.DCLS_Float_11:= IO.DCO_SEAT_SINE_11_AMPL;
       IOS.DCLS_Float_12:= IO.DCO_SEAT_SINE_12_AMPL;
       IOS.DCLS_Float_13:= IO.DCO_SEAT_SINE_13_AMPL;
       IOS.DCLS_Float_14:= IO.DCO_SEAT_SINE_14_AMPL;
       IOS.DCLS_Float_15:= IO.DCO_SEAT_SINE_15_AMPL;
       IOS.DCLS_Float_16:= IO.DCO_SEAT_SINE_16_AMPL;
       IOS.DCLS_Float_17:= IO.DCO_SEAT_SINE_17_AMPL;
       IOS.DCLS_Float_18:= IO.DCO_SEAT_SINE_18_AMPL;
       IOS.DCLS_Float_19:= IO.DCO_SEAT_SINE_19_AMPL;
       IOS.DCLS_Float_20:= IO.DCO_SEAT_SINE_20_AMPL;
       IOS.DCLS_Float_21:= IO.DCO_SEAT_WHITE_1_VAR;
       IOS.DCLS_Float_22:= IO.DCO_SEAT_WHITE_2_VAR;
       IOS.DCLS_Float_23:= IO.DCO_SEAT_WHITE_3_VAR;
       IOS.DCLS_Float_24:= IO.DCO_SEAT_WHITE_4_VAR;
       IOS.DCLS_Float_25:= IO.DCO_SEAT_WHITE_5_VAR;
       IOS.DCLS_Float_26:= float(IO.DCO_AUTOTEST_NUMBER);
       IOS.DCLS_Float_27:= float(IO.DCO_AUTOTEST_PHASE);
       IOS.DCLS_Float_28:= IO.DCO_AUTOTEST_TIME;
       IOS.DCLS_Float_29:= float(IO.DCO_TEST_PHASE);
       IOS.DCLS_Float_30:= float(IO.DCO_TEST_AXIS);
	elsif IOS.DCLS_Int_01 = 4 then	   
       IOS.DCLS_Float_01 := float(IO.DCO_TEST_TYPE);
       IOS.DCLS_Float_02 := IO.DCO_TEST_FREQ;
       IOS.DCLS_Float_03 := IO.DCO_TEST_MAG;
	elsif IOS.DCLS_Int_01 = 5 then	   
       IOS.DCLS_Float_01:= IO.DCI_LONG_STK_POSITION;
       IOS.DCLS_Float_02:= IO.DCI_LONG_STK_FORCE;
       IOS.DCLS_Float_03:= IO.DCI_LONG_SURF_POSITION;
       IOS.DCLS_Float_04:= IO.DCI_LONG_SERVO;
       IOS.DCLS_Float_05:= IO.DCI_LATL_STK_POSITION;
       IOS.DCLS_Float_06:= IO.DCI_LATL_STK_FORCE;
       IOS.DCLS_Float_07:= IO.DCI_LATL_SURF_POSITION;
       IOS.DCLS_Float_08:= IO.DCI_LATL_SERVO;
       IOS.DCLS_Float_09:= IO.DCI_DIRC_PED_POSITION;
       IOS.DCLS_Float_10:= IO.DCI_DIRC_PED_FORCE;
       IOS.DCLS_Float_11:= IO.DCI_DIRC_SURF_POSITION;
       IOS.DCLS_Float_12:= IO.DCI_DIRC_SERVO;
       IOS.DCLS_Float_13:= IO.DCI_TBKL_POSITION;
       IOS.DCLS_Float_14:= IO.DCI_TBKL_FORCE;
       IOS.DCLS_Float_15:= IO.DCI_TBKL_SERVO;
       IOS.DCLS_Float_16:= IO.DCI_TBKR_POSITION;
       IOS.DCLS_Float_17:= IO.DCI_TBKR_FORCE;
       IOS.DCLS_Float_18:= IO.DCI_TBKR_SERVO;
       IOS.DCLS_Float_19:= IO.DCI_SEAT_CYL_POS;
       IOS.DCLS_Float_20:= IO.DCI_SEAT_ACCELEROMETER;
       IOS.DCLS_Float_21:= IO.DCI_TEST_PHASE_LAG;
       IOS.DCLS_Float_22:= IO.DCI_TEST_MAG_LOSS;
    elsif Jsa.Float1 > 12.5 and Jsa.Float1 < 13.5 then
       Io.DCO_TEST_PHASE := Integer(Jsa.Float2);
       IO.DCO_TEST_AXIS  := Integer(JSA.Float3);
       IO.DCO_TEST_TYPE  := Integer(JSA.Float4);
       IO.DCO_TEST_FREQ  := (JSA.Float5);
       IO.DCO_TEST_MAG   := (JSA.Float6);
    elsif Integer(Jsa.Float1) = 151 then
       Subs.Debug8  := Misc_Force.pitch;
       Subs.Debug9  := Misc_Force.Roll;
       Subs.Debug10 := Misc_Force.Yaw;
    elsif Integer(Jsa.Float1) = 114 then
       Subs.Debug7  := Column_Movement.Get_Position
        (Container.This_Subsystem.The_Longitudinal_Column_Movement);
       Subs.Debug8  := Misc_Force.pitch;
       Subs.Debug9  := -JIP.Pitch_Backdrive_Force;
       Subs.Debug10 := long_Force;

    end if;


  end Update;

end JPATS_DCLS.Controller;
