-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Column_Movement;
with Control_Surface;
with Gearing;
with Pedals;
with Vibrations;
with Coordinate_Types;
with Angle_types;

private package JPATS_DCLS.Container is
   type Instance is
      record
         The_Lateral_Column_Movement      : Column_Movement.Instance;
         The_Longitudinal_Column_Movement : Column_Movement.Instance;

         The_Left_Aileron_Position        : Control_Surface.Instance;
         The_Right_Aileron_Position       : Control_Surface.Instance;
         The_Elevator_Position            : Control_Surface.Instance;
         The_Rudder_Position              : Control_Surface.Instance;

         The_Left_Aileron_Gearing         : Gearing.Instance;
         The_Right_Aileron_Gearing        : Gearing.Instance;
         The_Elevator_Gearing             : Gearing.Instance;
         The_Rudder_Gearing               : Gearing.Instance;

         The_Pedals                       : Pedals.Instance;

         -- variables of previous status
         Pitch_Mode_Previous              : Integer;
         Roll_Mode_Previous               : Integer;
         Yaw_Mode_Previous                : Integer;

         The_Flap_Vibration               : Vibrations.Instance;
         The_Engine_Vibration             : Vibrations.Instance;
         The_Speedbrake_Vibration         : Vibrations.Instance;
         The_Runway_Rumble_Vibration      : Vibrations.Instance;
         The_Wheel_Scuffing_Vibration     : Vibrations.Instance;
         The_Landing_Gear_Vibration       : Vibrations.Instance;
         The_Stall_Vibration              : Vibrations.Instance;
         The_Turbulence_Vibration         : Vibrations.Instance;
         The_Structural_Damage_Vibration  : Vibrations.Instance;

         Debug1                           : Float := 0.0;
         Debug2                           : Float := 0.0;
         Debug3                           : Float := 0.0;
         Debug4                           : Float := 0.0;
         Debug5                           : Float := 0.0;
         Debug6                           : Float := 0.0;
         Debug7                           : Float := 0.0;
         Debug8                           : Float := 0.0;
         Debug9                           : Float := 0.0;
         Debug10                          : Float := 0.0;
      end record;
   This_Subsystem : Instance;

   type Control_Block_Byte  is mod 2**8;

   type ICD_Control_Block is 
      record
         Counter     : Control_Block_Byte  := 0;
         State       : Control_Block_Byte  := 0;
         Acknowledge : Control_Block_Byte  := 0;
         Reserved    : Control_Block_Byte  := 0;
      end record;

   -- ----------------------------------------------------------------------------------
   --| This is for filtering variables sent to ECLS
   --| It is set out from "this_subsystem", so that, it will be independent
   --| from the record-playback procedure.
   -- ----------------------------------------------------------------------------------
   Bob_Weight                       : Float   := 0.0;
   Neutral_Position                 : Coordinate_Types.Attitude := (0.0,0.0,0.0);
   Aero_Grad                        : Coordinate_Types.Attitude := (0.0,0.0,0.0);
   Filtered_damper                  : Coordinate_Types.Attitude := (0.1,0.11,0.4);
   Filtered_Yaw_friction            : Float   := 1.0;
   Load_Factor                      : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
   old_cas                          : Float   := 0.02;
   Tab_Pos                          : Angle_Types.Degrees:= 0.0;

   -- variables of previous status
   Repo_Previous                    : Boolean := False;
   Crash_Previous                   : Boolean := False;
   Ios_Pilot_Previous               : Boolean := False;

   -- timers
   Repo_Timer                       : Float   := 0.02;
   Lagfac_Timer                     : Coordinate_Types.Attitude := (0.02,0.02,0.02);
   Load_Lagfac                      : Float   := 0.02;
   Ios_Pilot_Timer                  : Float   := 0.02;

   -- This timer is used to set the filter of all variables sent to DCLS
   -- during miscelanious tasks (such as : snapshot, playback, slewing etc.).
   -- A procedure "reset_filter" is defined in Jpats_Dcls.ads to trip on this timer.
   Misc_Timer                       : Float   := 0.02;


   -----------------------------------------------------------------------------
   --| This type structure identifies the attributes that instructor station can
   --| request to be changed.
   -----------------------------------------------------------------------------
   type IOS_Interface_Instance is
      record
         --debug labels
         Ios_Timer                      : Boolean := False;

         DCLS_float_01                  : Float := 0.0;
         DCLS_float_02                  : Float := 0.0;
         DCLS_float_03                  : Float := 0.0;
         DCLS_float_04                  : Float := 0.0;
         DCLS_float_05                  : Float := 0.0;
         DCLS_float_06                  : Float := 0.0;
         DCLS_float_07                  : Float := 0.0;
         DCLS_float_08                  : Float := 0.0;
         DCLS_float_09                  : Float := 0.0;
         DCLS_float_10                  : Float := 0.0;

         DCLS_float_11                  : Float := 0.0;
         DCLS_float_12                  : Float := 0.0;
         DCLS_float_13                  : Float := 0.0;
         DCLS_float_14                  : Float := 0.0;
         DCLS_float_15                  : Float := 0.0;
         DCLS_float_16                  : Float := 0.0;
         DCLS_float_17                  : Float := 0.0;
         DCLS_float_18                  : Float := 0.0;
         DCLS_float_19                  : Float := 0.0;
         DCLS_float_20                  : Float := 0.0;

         DCLS_float_21                  : Float := 0.0;
         DCLS_float_22                  : Float := 0.0;
         DCLS_float_23                  : Float := 0.0;
         DCLS_float_24                  : Float := 0.0;
         DCLS_float_25                  : Float := 0.0;
         DCLS_float_26                  : Float := 0.0;
         DCLS_float_27                  : Float := 0.0;
         DCLS_float_28                  : Float := 0.0;
         DCLS_float_29                  : Float := 0.0;
         DCLS_float_30                  : Float := 0.0;

         DCLS_Int_01                    : Integer := 0;
         DCLS_Int_02                    : Integer := 0;
         DCLS_Int_03                    : Integer := 0;
         DCLS_Int_04                    : Integer := 0;
         DCLS_Int_05                    : Integer := 0;
         DCLS_Int_06                    : Integer := 0;
         DCLS_Int_07                    : Integer := 0;
         DCLS_Int_08                    : Integer := 0;
         DCLS_Int_09                    : Integer := 0;
         DCLS_Int_10                    : Integer := 0;

         DCLS_Bool_01                   : Boolean := False;
         DCLS_Bool_02                   : Boolean := False;
         DCLS_Bool_03                   : Boolean := False;
         DCLS_Bool_04                   : Boolean := False;
         DCLS_Bool_05                   : Boolean := False;
         DCLS_Bool_06                   : Boolean := False;
         DCLS_Bool_07                   : Boolean := False;
         DCLS_Bool_08                   : Boolean := False;
         DCLS_Bool_09                   : Boolean := False;
         DCLS_Bool_10                   : Boolean := False;

      end record;

   This_IOS_Interface : IOS_Interface_Instance;

   -- ----------------------------------------------------------------------------------
   --| This type structure identifies the attributes that are send/got from the
   --| cockpit and the instructor station.
   -- ----------------------------------------------------------------------------------
   type IO_Interface_Instance is
      record

         -- ----------------------------------------------------------------------------
         --| From the HOST to the DCLS        HOST --> DCLS
         -- ----------------------------------------------------------------------------
         CLM_HOST_OUTPUT_BUFFER            : Integer  ;
         CLM_HOST_TIMESTAMP                : Integer  ;

         DCI_SYS_lru_group1	               : Integer  ;  -- Firewire Header
         DCI_SYS_lru_group2                : Integer  ;  -- Firewire Header

         DCO_LONG_SURF_AERO_HMD            : Float    ;  -- ECLS-O-0001
         DCO_LONG_SURF_AERO_DAMPING        : Float    ;  -- ECLS-O-0002
         DCO_LONG_SURF_NEUTRAL             : Float    ;  -- ECLS-O-0003
         DCO_LONG_STK_MISC_FORCE           : Float    ;  -- ECLS-O-0004
         DCO_LONG_SURF_DRVR_FLAG           : Boolean  ;  -- ECLS-O-0005
         DCO_LONG_SURF_DRVR_CMND           : Float    ;  -- ECLS-O-0006
         DCO_LONG_SURF_JAM                 : Boolean  ;  -- ECLS-O-0007
         DCO_LONG_STK_DRVR_FLAG            : Boolean  ;  -- ECLS-O-0008
         DCO_LONG_STK_DRVR_CMND            : Float    ;  -- ECLS-O-0009
         DCO_LONG_STK_JAM                  : Boolean  ;  -- ECLS-O-0010
         DCO_LONG_CABLE_STIFF              : Float    ;  -- ECLS-O-0011
         DCO_LONG_FRICT_GAIN               : Float    ;  -- ECLS-O-0012
         DCO_LONG_BOB_WEIGHT               : Float    ;  -- ECLS-O-0013
         DCO_LATL_SURF_AERO_HMD            : Float    ;  -- ECLS-O-0014
         DCO_LATL_SURF_AERO_DAMPING        : Float    ;  -- ECLS-O-0015
         DCO_LATL_SURF_NEUTRAL             : Float    ;  -- ECLS-O-0016
         DCO_LATL_STK_MISC_FORCE           : Float    ;  -- ECLS-O-0017
         DCO_LATL_SURF_DRVR_FLAG           : Boolean  ;  -- ECLS-O-0018
         DCO_LATL_SURF_DRVR_CMND           : Float    ;  -- ECLS-O-0019
         DCO_LATL_SURF_JAM                 : Boolean  ;  -- ECLS-O-0020
         DCO_LATL_STK_DRVR_CMND_FLAG       : Boolean  ;  -- ECLS-O-0021
         DCO_LATL_STK_DRVR_CMND            : Float    ;  -- ECLS-O-0022
         DCO_LATL_STK_JAM                  : Boolean  ;  -- ECLS-O-0023
         DCO_LATL_FRICT_GAIN               : Float    ;  -- ECLS-O-0024
         DCO_LATL_CABLE_STIFF              : Float    ;  -- ECLS-O-0025
         DCO_LATL_TAB_POS                  : Float    ;  -- ECLS-O-0026
         DCO_DIRC_SURF_AERO_HMD            : Float    ;  -- ECLS-O-0027
         DCO_DIRC_SURF_AERO_DAMPING        : Float    ;  -- ECLS-O-0028
         DCO_DIRC_SURF_NEUTRAL             : Float    ;  -- ECLS-O-0029
         DCO_DIRC_PED_MISC_FORCE           : Float    ;  -- ECLS-O-0030
         DCO_DIRC_SURF_DRVR_FLAG           : Boolean  ;  -- ECLS-O-0031
         DCO_DIRC_SURF_DRVR_CMND           : Float    ;  -- ECLS-O-0032
         DCO_DIRC_SURF_JAM                 : Boolean  ;  -- ECLS-O-0033
         DCO_DIRC_PED_DRVR_CMND_FLAG       : Boolean  ;  -- ECLS-O-0034
         DCO_DIRC_PED_DRVR_CMND            : Float    ;  -- ECLS-O-0035
         DCO_DIRC_PED_JAM                  : Boolean  ;  -- ECLS-O-0036
         DCO_DIRC_FRICT_GAIN               : Float    ;  -- ECLS-O-0037
         DCO_DIRC_CABLE_STIFF              : Float    ;  -- ECLS-O-0038
         DCO_TBKL_K_PUMP                   : Float    ;  -- ECLS-O-0039
         DCO_TBKL_MALF_FLAG                : Boolean  ;  -- ECLS-O-0040
         DCO_TBKR_K_PUMP                   : Float    ;  -- ECLS-O-0041
         DCO_TBKR_MALF_FLAG                : Boolean  ;  -- ECLS-O-0042
         DCO_SEAT_PRIM_FLTAZA              : Float    ;  -- ECLS-O-0043
         DCO_SEAT_Z_AXIS_SPEF              : Float    ;  -- ECLS-O-0044
         DCO_SEAT_CYL_DISCR_INPUT          : Float    ;  -- ECLS-O-0045
         DCO_SEAT_FREEZE_FLAG              : Boolean  ;  -- ECLS-O-0046
         DCO_SEAT_SINE_1_AMPL              : Float    ;  -- ECLS-O-0047
         DCO_SEAT_SINE_2_AMPL              : Float    ;  -- ECLS-O-0048
         DCO_SEAT_SINE_3_AMPL              : Float    ;  -- ECLS-O-0049
         DCO_SEAT_SINE_4_AMPL              : Float    ;  -- ECLS-O-0050
         DCO_SEAT_SINE_5_AMPL              : Float    ;  -- ECLS-O-0051
         DCO_SEAT_SINE_6_AMPL              : Float    ;  -- ECLS-O-0052
         DCO_SEAT_SINE_7_AMPL              : Float    ;  -- ECLS-O-0053
         DCO_SEAT_SINE_8_AMPL              : Float    ;  -- ECLS-O-0054
         DCO_SEAT_SINE_9_AMPL              : Float    ;  -- ECLS-O-0055
         DCO_SEAT_SINE_10_AMPL             : Float    ;  -- ECLS-O-0056
         DCO_SEAT_SINE_11_AMPL             : Float    ;  -- ECLS-O-0057
         DCO_SEAT_SINE_12_AMPL             : Float    ;  -- ECLS-O-0058
         DCO_SEAT_SINE_13_AMPL             : Float    ;  -- ECLS-O-0059
         DCO_SEAT_SINE_14_AMPL             : Float    ;  -- ECLS-O-0060
         DCO_SEAT_SINE_15_AMPL             : Float    ;  -- ECLS-O-0061
         DCO_SEAT_SINE_16_AMPL             : Float    ;  -- ECLS-O-0062
         DCO_SEAT_SINE_17_AMPL             : Float    ;  -- ECLS-O-0063
         DCO_SEAT_SINE_18_AMPL             : Float    ;  -- ECLS-O-0064
         DCO_SEAT_SINE_19_AMPL             : Float    ;  -- ECLS-O-0065
         DCO_SEAT_SINE_20_AMPL             : Float    ;  -- ECLS-O-0066
         DCO_SEAT_WHITE_1_VAR              : Float    ;  -- ECLS-O-0067
         DCO_SEAT_WHITE_2_VAR              : Float    ;  -- ECLS-O-0068
         DCO_SEAT_WHITE_3_VAR              : Float    ;  -- ECLS-O-0069
         DCO_SEAT_WHITE_4_VAR              : Float    ;  -- ECLS-O-0070
         DCO_SEAT_WHITE_5_VAR              : Float    ;  -- ECLS-O-0071
         DCO_AUTOTEST_NUMBER               : Integer  ;  -- ECLS-O-0072
         DCO_AUTOTEST_PHASE                : Integer  ;  -- ECLS-O-0073
         DCO_AUTOTEST_TIME                 : Float    ;  -- ECLS-O-0074
         DCO_TEST_PHASE                    : Integer  ;  -- ECLS-O-0075
         DCO_TEST_AXIS                     : Integer  ;  -- ECLS-O-0076
         DCO_TEST_TYPE                     : Integer  ;  -- ECLS-O-0077
         DCO_TEST_FREQ                     : Float    ;  -- ECLS-O-0078
         DCO_TEST_MAG                      : Float    ;  -- ECLS-O-0079
         DCO_SPARE1                        : Float    ;  -- ECLS-O-0080
         DCO_SPARE2                        : Float    ;  -- ECLS-O-0081
         DCO_SPARE3                        : Float    ;  -- ECLS-O-0082
         DCO_SPARE4                        : Float    ;  -- ECLS-O-0083
         DCO_SPARE5                        : Float    ;  -- ECLS-O-0084

         -- ----------------------------------------------------------------------------
         --| From DCLS to the HOST   HOST <-- DCLS
         -- ----------------------------------------------------------------------------

         DCI_LONG_STK_POSITION             : Float    ;  -- ECLS-I-0001
         DCI_LONG_STK_FORCE                : Float    ;  -- ECLS-I-0002
         DCI_LONG_SURF_POSITION            : Float    ;  -- ECLS-I-0003
         DCI_LONG_SERVO                    : Float    ;  -- ECLS-I-0004
         DCI_LATL_STK_POSITION             : Float    ;  -- ECLS-I-0005
         DCI_LATL_STK_FORCE                : Float    ;  -- ECLS-I-0006
         DCI_LATL_SURF_POSITION            : Float    ;  -- ECLS-I-0007
         DCI_LATL_SERVO                    : Float    ;  -- ECLS-I-0008
         DCI_DIRC_PED_POSITION             : Float    ;  -- ECLS-I-0009
         DCI_DIRC_PED_FORCE                : Float    ;  -- ECLS-I-0010
         DCI_DIRC_SURF_POSITION            : Float    ;  -- ECLS-I-0011
         DCI_DIRC_SERVO                    : Float    ;  -- ECLS-I-0012
         DCI_TBKL_POSITION                 : Float    ;  -- ECLS-I-0013
         DCI_TBKL_FORCE                    : Float    ;  -- ECLS-I-0014
         DCI_TBKL_SERVO                    : Float    ;  -- ECLS-I-0015
         DCI_TBKR_POSITION                 : Float    ;  -- ECLS-I-0016
         DCI_TBKR_FORCE                    : Float    ;  -- ECLS-I-0017
         DCI_TBKR_SERVO                    : Float    ;  -- ECLS-I-0018
         DCI_SEAT_CYL_POS                  : Float    ;  -- ECLS-I-0019
         DCI_SEAT_ACCELEROMETER            : Float    ;  -- ECLS-I-0020
         DCI_TEST_PHASE_LAG                : Float    ;  -- ECLS-I-0021
         DCI_TEST_MAG_LOSS                 : Float    ;  -- ECLS-I-0022
         DCI_SPARE1                        : Float    ;  -- ECLS-I-0023
         DCI_SPARE2                        : Float    ;  -- ECLS-I-0024
         DCI_SPARE3                        : Float    ;  -- ECLS-I-0025
         DCI_SPARE4                        : Float    ;  -- ECLS-I-0026
         DCI_SPARE5                        : Float    ;  -- ECLS-I-0027
         DCI_ERROR_CYCLE                   : Integer  ;  -- ECLS-I-0028
         DCI_ERROR_CODE                    : Integer  ;  -- ECLS-I-0029
         DCI_ERROR_DETAILS                 : Integer  ;  -- ECLS-I-0030

         DCI_SYS_unused		               : Integer  ;  -- Firewire Header
         DCI_SYS_mem_test_drv	           : Integer  ;  -- Firewire Header
         DCI_SYS_cycle_counter	           : Integer  ;  -- Firewire Header

         -- The following  section of variables must be present (per CLMnt_IDD.docx)
         CLM_HOST_INPUT_BUFFER             : Integer  ; 
         CLM_SUBSYSTEM_TIMESTAMP           : Integer  ;

      end record;

   for IO_Interface_Instance use
      record
         -- ----------------------------------------------------------------------------
         --| From the HOST to the DCLS        HOST --> DCLS
         -- ----------------------------------------------------------------------------
         CLM_HOST_OUTPUT_BUFFER            at  000      range  0 .. 31;
         CLM_HOST_TIMESTAMP                at  004      range  0 .. 31;
         DCI_SYS_lru_group1	               at  012      range  0 .. 31;
         DCI_SYS_lru_group2                at  016      range  0 .. 31;

         DCO_LONG_SURF_AERO_HMD            at  020      range  0 .. 31;
         DCO_LONG_SURF_AERO_DAMPING        at  024      range  0 .. 31;
         DCO_LONG_SURF_NEUTRAL             at  028      range  0 .. 31;
         DCO_LONG_STK_MISC_FORCE           at  032      range  0 .. 31;
         DCO_LONG_SURF_DRVR_FLAG           at  036      range  0 .. 31;

         DCO_LONG_SURF_DRVR_CMND           at  040      range  0 .. 31;
         DCO_LONG_SURF_JAM                 at  044      range  0 .. 31;
         DCO_LONG_STK_DRVR_FLAG            at  048      range  0 .. 31;
         DCO_LONG_STK_DRVR_CMND            at  052      range  0 .. 31;
         DCO_LONG_STK_JAM                  at  056      range  0 .. 31;
         DCO_LONG_CABLE_STIFF              at  060      range  0 .. 31;
         DCO_LONG_FRICT_GAIN               at  064      range  0 .. 31;
         DCO_LONG_BOB_WEIGHT               at  068      range  0 .. 31;
         DCO_LATL_SURF_AERO_HMD            at  072      range  0 .. 31;
         DCO_LATL_SURF_AERO_DAMPING        at  076      range  0 .. 31;
         DCO_LATL_SURF_NEUTRAL             at  080      range  0 .. 31;
         DCO_LATL_STK_MISC_FORCE           at  084      range  0 .. 31;
         DCO_LATL_SURF_DRVR_FLAG           at  088      range  0 .. 31;
         DCO_LATL_SURF_DRVR_CMND           at  092      range  0 .. 31;
         DCO_LATL_SURF_JAM                 at  096      range  0 .. 31;
         DCO_LATL_STK_DRVR_CMND_FLAG       at  100      range  0 .. 31;
         DCO_LATL_STK_DRVR_CMND            at  104      range  0 .. 31;
         DCO_LATL_STK_JAM                  at  108      range  0 .. 31;
         DCO_LATL_FRICT_GAIN               at  112      range  0 .. 31;
         DCO_LATL_CABLE_STIFF              at  116      range  0 .. 31;
         DCO_LATL_TAB_POS                  at  120      range  0 .. 31;
         DCO_DIRC_SURF_AERO_HMD            at  124      range  0 .. 31;
         DCO_DIRC_SURF_AERO_DAMPING        at  128      range  0 .. 31;
         DCO_DIRC_SURF_NEUTRAL             at  132      range  0 .. 31;
         DCO_DIRC_PED_MISC_FORCE           at  136      range  0 .. 31;
         DCO_DIRC_SURF_DRVR_FLAG           at  140      range  0 .. 31;
         DCO_DIRC_SURF_DRVR_CMND           at  144      range  0 .. 31;
         DCO_DIRC_SURF_JAM                 at  148      range  0 .. 31;
         DCO_DIRC_PED_DRVR_CMND_FLAG       at  152      range  0 .. 31;
         DCO_DIRC_PED_DRVR_CMND            at  156      range  0 .. 31;
         DCO_DIRC_PED_JAM                  at  160      range  0 .. 31;
         DCO_DIRC_FRICT_GAIN               at  164      range  0 .. 31;
         DCO_DIRC_CABLE_STIFF              at  168      range  0 .. 31;
         DCO_TBKL_K_PUMP                   at  172      range  0 .. 31;
         DCO_TBKL_MALF_FLAG                at  176      range  0 .. 31;
         DCO_TBKR_K_PUMP                   at  180      range  0 .. 31;
         DCO_TBKR_MALF_FLAG                at  184      range  0 .. 31;
         DCO_SEAT_PRIM_FLTAZA              at  188      range  0 .. 31;
         DCO_SEAT_Z_AXIS_SPEF              at  192      range  0 .. 31;
         DCO_SEAT_CYL_DISCR_INPUT          at  196      range  0 .. 31;
         DCO_SEAT_FREEZE_FLAG              at  200      range  0 .. 31;
         DCO_SEAT_SINE_1_AMPL              at  204      range  0 .. 31;
         DCO_SEAT_SINE_2_AMPL              at  208      range  0 .. 31;
         DCO_SEAT_SINE_3_AMPL              at  212      range  0 .. 31;
         DCO_SEAT_SINE_4_AMPL              at  216      range  0 .. 31;
         DCO_SEAT_SINE_5_AMPL              at  220      range  0 .. 31;
         DCO_SEAT_SINE_6_AMPL              at  224      range  0 .. 31;
         DCO_SEAT_SINE_7_AMPL              at  228      range  0 .. 31;
         DCO_SEAT_SINE_8_AMPL              at  232      range  0 .. 31;
         DCO_SEAT_SINE_9_AMPL              at  236      range  0 .. 31;
         DCO_SEAT_SINE_10_AMPL             at  240      range  0 .. 31;
         DCO_SEAT_SINE_11_AMPL             at  244      range  0 .. 31;
         DCO_SEAT_SINE_12_AMPL             at  248      range  0 .. 31;
         DCO_SEAT_SINE_13_AMPL             at  252      range  0 .. 31;
         DCO_SEAT_SINE_14_AMPL             at  256      range  0 .. 31;
         DCO_SEAT_SINE_15_AMPL             at  260      range  0 .. 31;
         DCO_SEAT_SINE_16_AMPL             at  264      range  0 .. 31;
         DCO_SEAT_SINE_17_AMPL             at  268      range  0 .. 31;
         DCO_SEAT_SINE_18_AMPL             at  272      range  0 .. 31;
         DCO_SEAT_SINE_19_AMPL             at  276      range  0 .. 31;
         DCO_SEAT_SINE_20_AMPL             at  280      range  0 .. 31;
         DCO_SEAT_WHITE_1_VAR              at  284      range  0 .. 31;
         DCO_SEAT_WHITE_2_VAR              at  288      range  0 .. 31;
         DCO_SEAT_WHITE_3_VAR              at  292      range  0 .. 31;
         DCO_SEAT_WHITE_4_VAR              at  296      range  0 .. 31;
         DCO_SEAT_WHITE_5_VAR              at  300      range  0 .. 31;
         DCO_AUTOTEST_NUMBER               at  304      range  0 .. 31;
         DCO_AUTOTEST_PHASE                at  308      range  0 .. 31;
         DCO_AUTOTEST_TIME                 at  312      range  0 .. 31;
         DCO_TEST_PHASE                    at  316      range  0 .. 31;
         DCO_TEST_AXIS                     at  320      range  0 .. 31;
         DCO_TEST_TYPE                     at  324      range  0 .. 31;
         DCO_TEST_FREQ                     at  328      range  0 .. 31;
         DCO_TEST_MAG                      at  332      range  0 .. 31;
         DCO_SPARE1                        at  336      range  0 .. 31;
         DCO_SPARE2                        at  340      range  0 .. 31;
         DCO_SPARE3                        at  344      range  0 .. 31;
         DCO_SPARE4                        at  348      range  0 .. 31;
         DCO_SPARE5                        at  352      range  0 .. 31;

         -- ----------------------------------------------------------------------------
         --| From DCLS to the HOST   HOST <-- DCLS
         -- ----------------------------------------------------------------------------

         DCI_LONG_STK_POSITION             at  356      range  0 .. 31;
         DCI_LONG_STK_FORCE                at  360      range  0 .. 31;
         DCI_LONG_SURF_POSITION            at  364      range  0 .. 31;
         DCI_LONG_SERVO                    at  368      range  0 .. 31;
         DCI_LATL_STK_POSITION             at  372      range  0 .. 31;
         DCI_LATL_STK_FORCE                at  376      range  0 .. 31;
         DCI_LATL_SURF_POSITION            at  380      range  0 .. 31;
         DCI_LATL_SERVO                    at  384      range  0 .. 31;
         DCI_DIRC_PED_POSITION             at  388      range  0 .. 31;
         DCI_DIRC_PED_FORCE                at  392      range  0 .. 31;
         DCI_DIRC_SURF_POSITION            at  396      range  0 .. 31;
         DCI_DIRC_SERVO                    at  400      range  0 .. 31;
         DCI_TBKL_POSITION                 at  404      range  0 .. 31;
         DCI_TBKL_FORCE                    at  408      range  0 .. 31;
         DCI_TBKL_SERVO                    at  412      range  0 .. 31;
         DCI_TBKR_POSITION                 at  416      range  0 .. 31;
         DCI_TBKR_FORCE                    at  420      range  0 .. 31;
         DCI_TBKR_SERVO                    at  424      range  0 .. 31;
         DCI_SEAT_CYL_POS                  at  428      range  0 .. 31;
         DCI_SEAT_ACCELEROMETER            at  432      range  0 .. 31;
         DCI_TEST_PHASE_LAG                at  436      range  0 .. 31;
         DCI_TEST_MAG_LOSS                 at  440      range  0 .. 31;
         DCI_SPARE1                        at  444      range  0 .. 31;
         DCI_SPARE2                        at  448      range  0 .. 31;
         DCI_SPARE3                        at  452      range  0 .. 31;
         DCI_SPARE4                        at  456      range  0 .. 31;
         DCI_SPARE5                        at  460      range  0 .. 31;

         DCI_ERROR_CYCLE                   at  464      range  0 .. 31;

         DCI_ERROR_CODE                    at  468      range  0 .. 31;
         DCI_ERROR_DETAILS                 at  472      range  0 .. 31;

         DCI_SYS_unused		               at  476      range  0 .. 31;
         DCI_SYS_mem_test_drv	           at  480      range  0 .. 31;

         -- missing 484 and 488

         DCI_SYS_cycle_counter	           at  492      range 0 .. 31;

         -- The following  section of variables must be present (per CLMnt_IDD.docx)

         CLM_HOST_INPUT_BUFFER             at  496      range  0 .. 31;
         CLM_SUBSYSTEM_TIMESTAMP           at  500      range  0 .. 31;


      end record;

   This_IO_Interface : IO_Interface_Instance;

end JPATS_DCLS.Container;
