-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

package body Gearing is

    procedure Set_Gearing(Control_Pos   :in     Angle_Types.Degrees;
                          GxDxxx_Table  :in out IT.Singly_Indexed.Instance;
                          An_Instance   :in out Instance) is
    begin
        An_Instance.The_Gearing := IT.Singly_Indexed.Interpolate
                                       (Control_Pos,GxDxxx_Table'access);
    end Set_Gearing;

     procedure new_Gearing(Control_Pos   :in     Angle_Types.Degrees;
                           Gada_Table    :in out IT.Singly_Indexed.Instance;
                           An_Instance   :in out Instance) is
    begin
        An_Instance.The_Gearing := IT.Singly_Indexed.Interpolate
                                       (Control_Pos,GaDa_Table'access);
    end new_Gearing;

    procedure Assign_Gearing(Gearing :in     Float;
                             An_Instance  :in out Instance) is
    begin
        An_Instance.The_Gearing := Gearing;
    end Assign_Gearing;

    function Get_Gearing(An_Instance :in Instance) return Float is
    begin
        return An_Instance.The_Gearing;
    end Get_Gearing;
end Gearing;
