-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

package body Control_Surface is

    procedure Set_Position(Position     :in     Angle_Types.Degrees;
                           DxDxxx_T     :in out IT.Singly_Indexed.Instance;
                           An_Instance  :in out Instance) is
    begin
        An_Instance.The_Position := IT.Singly_Indexed.Interpolate
                                                  (Position,DxDxxx_T'access);
   end Set_Position;

    procedure Assign_Position(Position    :in    Angle_Types.Degrees;
                              An_Instance :in out Instance) is
    begin
        An_Instance.The_Position := Position;
    end Assign_Position;

    function Get_Position(An_Instance :in Instance) return Angle_Types.Degrees is
    begin
        return An_Instance.The_Position;
    end Get_Position;

end Control_Surface;
