-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Interpolation_Table.Singly_Indexed;
with Torque_Types;

package Column_Movement is
package It renames Interpolation_Table;
    type Instance is private;

    procedure Set_Position
        (Surface_Pos    :in     Angle_Types.Degrees;
         DxDLxx_INV_T   :in out IT.Singly_Indexed.Instance;
         An_Instance    :in out Instance);
    procedure Assign_Position
        (Stk_pos        :in     Angle_Types.Degrees;
         An_Instance    :in out Instance);
    function Get_Position(An_Instance :in Instance) return Angle_Types.Degrees;

    procedure Set_Spring_Hm
        (stk_Pos       :in     Angle_Types.Degrees;
         Tab_Pos       :in     float;
         Ny            :in     Float;
         FLATSPRING_T  :in out Interpolation_Table.Singly_Indexed.Instance;
         An_Instance   :in out Instance);

    function Get_Spring_Hm(An_Instance :in Instance)
                              return Torque_Types.Ft_Lbf;

    procedure Set_Bob_Weight_Force
        (stk_Pos       :in     Angle_Types.Degrees;
         Load_Factor   :in     Coordinate_Types.Cartesian;
         FBWDLong_T    :in out IT.Singly_Indexed.Instance;
         An_Instance   :in out Instance);

    function Get_Bob_Weight_Force(An_Instance :in Instance)
                                return Torque_Types.Ft_Lbf;

    procedure Set_Pilot_Force
        (Gearing            :in     Float;
         Aero_Surf_Force    :in     Force_Types.Lbf;
         Spring_HM          :in     Torque_Types.Ft_Lbf;
         An_Instance        :in out Instance);

    procedure Assign_Pilot_Force(Force       :in     Force_Types.Lbf;
                                 An_Instance :in out Instance);
    function Get_Pilot_Force(An_Instance :in Instance) return Force_Types.Lbf;

private

    type Instance is
        record
            The_Position                      : Angle_Types.Degrees := 0.0;
            The_Spring_Hm                     : Torque_Types.Ft_Lbf:= 0.0;
            The_Bob_Weight_Force              : Torque_Types.Ft_Lbf := 0.0;
            The_Pilot_Force                   : Force_Types.Lbf := 0.0;
        end record;
end Column_Movement;
