-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--
package body Column_Movement is
    procedure Set_Position
        (Surface_Pos     :in     Angle_Types.Degrees;
         DxDLxx_INV_T    :in out IT.Singly_Indexed.Instance;
         An_Instance     :in out Instance) is
    begin
        An_Instance.The_Position := IT.Singly_Indexed.Interpolate
                                   (Surface_Pos,DxDLxx_INV_T'access);
    end Set_Position;

    procedure Assign_Position
        (Stk_pos          :in     Angle_Types.Degrees;
         An_Instance      :in out Instance) is
    begin
        An_Instance.The_Position := stk_Pos;
    end Assign_Position;

    function Get_Position(An_Instance :in Instance) return Angle_Types.Degrees is
    begin
        return An_Instance.The_Position;
    end Get_Position;

    procedure Set_Spring_Hm
        (stk_Pos        :in     Angle_Types.Degrees;
         Tab_Pos        :in     float;
         Ny             :in     Float;
         FLATSPRING_T   :in out IT.Singly_Indexed.Instance;
         An_Instance    :in out Instance) is
         Unloaded_Stick : Float := 0.0;
         Temp : Float := 0.0;
    begin
        Unloaded_Stick := stk_Pos - 0.11 * An_Instance.The_Pilot_Force ;
        Temp := IT.Singly_Indexed.Interpolate
          (Unloaded_stick + 4.7 * Tab_Pos,FLATSPRING_T'access);

        An_Instance.The_Spring_Hm :=
                 (Temp - 0.81 * Ny) / 1.633;
    end Set_Spring_Hm;

    function Get_Spring_Hm(An_Instance :in Instance) return Torque_Types.Ft_Lbf is
    begin
        return An_Instance.The_Spring_Hm;
    end Get_Spring_Hm;

    procedure Set_Bob_Weight_Force
        (stk_Pos        :in     Angle_Types.Degrees;
         Load_Factor    :in     Coordinate_Types.Cartesian;
         FBWDLONG_T     :in out IT.Singly_Indexed.Instance;
         An_Instance    :in out Instance) is
       Unloaded_Stick : Float := 0.0;
       Temp : Float := 0.0;
    begin
       Unloaded_Stick := Stk_Pos - 0.04 * An_Instance.The_Pilot_Force;
       Temp := IT.Singly_Indexed.Interpolate
                     (Unloaded_stick,FBWDLong_T'access);
       An_Instance.The_Bob_Weight_force :=
         (-Load_Factor.z * temp - 2.07 * Load_Factor.X)*
           -- tuning factor to reduce stick force per pilot comment 8/29/00
                         Float'Min(1.0,1.24 + 0.12 * Load_Factor.Z);
    end Set_Bob_Weight_force;

    function Get_Bob_Weight_Force(An_Instance :in Instance) return Torque_Types.Ft_Lbf is
    begin
        return An_Instance.The_Bob_Weight_Force;
    end Get_Bob_Weight_Force;

    procedure Set_Pilot_Force
        (Gearing            :in     Float;
         Aero_Surf_Force    :in     Force_Types.Lbf;
         Spring_Hm          :in     Torque_Types.Ft_Lbf;
         An_Instance        :in out Instance) is
    begin
       An_Instance.The_Pilot_Force :=
          -(Gearing * (An_Instance.The_Bob_Weight_Force + Spring_HM)
                                       + Aero_Surf_Force);
    end Set_Pilot_Force;

    procedure Assign_Pilot_Force (Force        :in     Force_Types.Lbf;
                                  An_Instance  :in out Instance) is
    begin
        An_Instance.The_Pilot_Force := Force;
    end Assign_Pilot_Force;

    function Get_Pilot_Force(An_Instance :in Instance)
                 return Force_Types.Lbf is
    begin
            return An_Instance.The_Pilot_Force;
    end Get_Pilot_Force;
end Column_Movement;

