-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Avionics_Types,
  Avionics_Types,
  Coordinate_Types;
with Lat_Long_Types;

package Threat_Control is

   package Jat renames Jpats_Avionics_Types;

   type Instance is private;

   procedure Set_Ground_Elevation
     (An_Instance      : in out Instance;
      Ground_Elevation : in     Float);

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Lat_Long_Types.Position);

   procedure Set_True_Heading
     (An_Instance  : in out Instance;
      True_Heading : in     Jat.Bearing_Type);

   procedure Set_Reposition_Active
     (An_Instance       : in out Instance;
      Reposition_Active : in     Boolean);

   procedure Set_Earth_Axis_Velocity
     (An_Instance         : in out Instance;
      Earth_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Body_Axis_Velocity
     (An_Instance        : in out Instance;
      Body_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Rate_Of_Climb
     (An_Instance   : in out Instance;
      Rate_Of_Climb : in     Float);

   procedure Set_Weight_On_Wheels
     (An_Instance      : in out Instance;
      Weight_On_Wheels : in     Boolean);

   procedure Set_Threat_Active
     (An_Instance  : in out Instance;
      Threat_Active : in     Boolean);

   procedure Set_Threat_Page_Start_Button
     (An_Instance             : in out Instance;
      Threat_Page_Start_Button : in     Jat.Ios_Boolean_Type);

   procedure Set_Threat_Page_Aircraft_Type
     (An_Instance              : in out Instance;
      Threat_Page_Aircraft_Type : in     Jat.Ios_Aircraft_Type);

   procedure Set_Threat_Page_Bearing
     (An_Instance        : in out Instance;
      Threat_Page_Bearing : in     Jat.Ios_Float_Type);

   procedure Set_Threat_Page_Distance
     (An_Instance         : in out Instance;
      Threat_Page_Distance : in     Jat.Ios_Float_Type);

   procedure Set_Threat_Page_Altitude
     (An_Instance         : in out Instance;
      Threat_Page_altitude : in     Jat.Ios_Float_Type);

   procedure Set_Threat_Page_Time
     (An_Instance     : in out Instance;
      Threat_Page_Time : in     Jat.Ios_Float_Type);

   procedure Set_Threat_Page_Vert_Pos
     (An_Instance         : in out Instance;
      Threat_Page_Vert_Pos : in     Jat.Ios_Vertical_Type);

   procedure Set_Threat_Page_Speed
     (An_Instance      : in out Instance;
      Threat_Page_Speed : in     Jat.Ios_Float_Type);

   procedure Set_Threat_Page_Closure
     (An_Instance        : in out Instance;
      Threat_Page_Closure : in     Jat.Ios_Float_Type);

   procedure Set_Flight_Freeze
     (An_Instance   : in out Instance;
      Flight_Freeze : in     Boolean);

   procedure Set_Solution_Found
     (An_Instance    : in out Instance;
      Solution_Found : in     Jat.Ios_Integer_Type);

   procedure Set_Solution_Reverse
     (An_Instance      : in out Instance;
      Solution_Reverse : in     Jat.Ios_Boolean_Type);

   procedure Set_Intruder_Drive
     (An_Instance    : in out Instance;
      Intruder_Drive : in     Jat.Intruder_Drive_Array_Type);

   function Ground_Elevation
     (An_Instance : in Instance)
      return Float;

   function Aircraft_Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position;

   function True_Heading
     (An_Instance : in Instance)
      return Jat.Bearing_Type;

   function Reposition_Active
     (An_Instance : in Instance)
      return Boolean;

   function Earth_Axis_Velocity
     (An_Instance : in Instance)
      return Coordinate_Types.Cartesian;

   function Rate_Of_Climb
     (An_Instance : in Instance)
      return Float;

   function Weight_On_Wheels
     (An_Instance : in Instance)
      return Boolean;

   function Threat_Active
     (An_Instance : in Instance)
     return Boolean;

   function Threat_Page_Start_Button
     (An_Instance : in Instance)
     return Jat.Ios_Boolean_Type;

   function Threat_Page_Aircraft_Type
     (An_Instance : in Instance)
     return Jat.Ios_Aircraft_Type;

   function Threat_Page_Bearing
     (An_Instance : in Instance)
     return Jat.Ios_Float_Type;

   function Threat_Page_Distance
     (An_Instance : in Instance)
     return Jat.Ios_Float_Type;

   function Threat_Page_Altitude
     (An_Instance : in Instance)
     return Jat.Ios_Float_Type;

   function Threat_Page_Time
     (An_Instance : in Instance)
      return Jat.Ios_Float_Type;

   function Threat_Page_Vert_Pos
     (An_Instance : in Instance)
      return Jat.Ios_Vertical_Type;

   function Threat_Page_Speed
     (An_Instance : in Instance)
      return Jat.Ios_Float_Type;

   function Threat_Page_Closure
     (An_Instance : in Instance)
      return Jat.Ios_Float_Type;

   function Solution_Found
     (An_Instance : in Instance)
      return Jat.Ios_Integer_Type;

   function Solution_Reverse
     (An_Instance : in Instance)
      return Jat.Ios_Boolean_Type;

   function Intruder_Drive
     (An_Instance : in Instance)
      return Jat.Intruder_Drive_Array_Type;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Iconst      : in     Float;
                    An_Instance : in out Instance);


private

   type Instance is record
      Ground_Elevation          : Float;
      Aircraft_Position         : Lat_Long_Types.Position;
      True_Heading              : Jat.Bearing_Type;
      Reposition_Active         : Boolean;
      Earth_Axis_Velocity       : Coordinate_Types.Cartesian;
      Body_Axis_Velocity        : Coordinate_Types.Cartesian;
      Rate_Of_Climb             : Float;
      Weight_On_Wheels          : Boolean;
      Active                    : Boolean;
      Threat_Page_Start_Button  : Jat.Ios_Boolean_Type;
      Threat_Page_Aircraft_Type : Jat.Ios_Aircraft_Type;
      Threat_Page_Bearing       : Jat.Ios_Float_Type;
      Threat_Page_Distance      : Jat.Ios_Float_Type;
      Threat_Page_Altitude      : Jat.Ios_Float_Type;
      Threat_Page_Time          : Jat.Ios_Float_Type;
      Threat_Page_Vert_Pos      : Jat.Ios_Vertical_Type;
      Threat_Page_Speed         : Jat.Ios_Float_Type;
      Threat_Page_Closure       : Jat.Ios_Float_Type;
      Flight_Freeze             : Boolean;
      Solution_Found            : Jat.Ios_Integer_Type;
      Solution_Reverse          : Jat.Ios_Boolean_Type;
      Intruder_Drive            : Jat.Intruder_Drive_Array_Type;

   end record;

end Threat_Control;
