-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Avionics_Types,
  Length_Types,
  Avionics_Types;

package Tas is

   package Jat renames Jpats_Avionics_Types;

   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Jpats_Avionics_Types.Position_Type);

   procedure Set_Ground_Elevation
     (An_Instance      : in out Instance;
      Ground_Elevation : in     Length_Types.Feet);

   procedure Set_Rate_Of_Climb
     (An_Instance   : in out Instance;
      Rate_Of_Climb : in     Length_Types.Feet_per_Min);

   procedure Set_Reposition_In_Progress
     (An_Instance            : in out Instance;
      Reposition_In_Progress : in     Boolean);

   procedure Set_Adc_Valid
     (An_Instance : in out Instance;
      Adc_Valid   : in     Boolean);

   procedure Set_Adc_Corrected_Altitude
     (An_Instance            : in out Instance;
      Adc_Corrected_Altitude : in     Length_Types.Feet);

   procedure Set_Adc_Pressure_Altitude
     (An_Instance            : in out Instance;
      Adc_Pressure_Altitude  : in     Length_Types.Feet);

   procedure Set_Adc_Vertical_Speed
     (An_Instance        : in out Instance;
      Adc_Vertical_Speed : in     Length_Types.Feet_per_Min);

   procedure Set_Weight_On_Wheels
     (An_Instance      : in out Instance;
      Weight_On_Wheels : in     Boolean);

   procedure Set_Intruder_Drive
     (An_Instance    : in out Instance;
      Intruder_Drive : in     Jat.Intruder_Drive_Array_Type);

   procedure Set_Ahrs_Valid
     (An_Instance : in out Instance;
      Ahrs_Valid  : in     Boolean);

   procedure Set_Ahrs_Attitude
     (An_Instance       : in out Instance;
      Ahrs_Attitude     : in  Jat.Attitude_Type   );

   procedure Set_Flight_Freeze
     (An_Instance   : in out Instance;
      Flight_Freeze : in     Boolean);

   procedure Set_Gear_Down
     (An_Instance   : in out Instance;
      Gear_Down     : in     Boolean);

   procedure Set_Display_Range
     (An_Instance   : in out Instance;
      Display_Range : in     Float);

   procedure Set_Altitude_Mode
     (An_Instance    : in out Instance;
      Altitude_Mode  : in     Jat.Altitude_Range_Type);

   procedure Set_Tas_Test_Sw
     (An_Instance : in out Instance;
      Tas_Test_Sw : in     Boolean);

   procedure Set_Tas_Stby_Sw
     (An_Instance : in out Instance;
      Tas_Stby_Sw : in     Boolean);

   procedure Set_Tas_Altitude_Sw
     (An_Instance     : in out Instance;
      Tas_Altitude_Sw : in     Boolean);

   procedure Set_Tas_Sw_Off
     (An_Instance  : in out Instance;
      Tas_Sw_Off   : in     Boolean);

   procedure Set_Tas_Vsi_Display_Valid
     (An_Instance             : in out Instance;
      Tas_Vsi_Display_Valid   : in     Boolean);

   procedure Set_Tas_Sw_Lt
     (An_Instance : in out Instance;
      Tas_Sw_Lt   : in     Boolean);

   procedure Set_Tas_Message
     (An_Instance : in out Instance;
      Tas_Message : in     Jat.Tas_Message_Type);

   procedure Set_Tas_Ios_Display
     (An_Instance     : in out Instance;
      Tas_Ios_Display : in     Jat.Tas_Ios_Display_Type);

   procedure Set_Tas_On
     (An_Instance     : in out Instance;
      Tas_On          : in     Boolean);

   procedure Set_Altitude_Limit_A
     (An_Instance     : in out Instance;
      Altitude_Limit  : in     Jat.Altitude_Limit_Type);

   procedure Set_Altitude_Limit_B
     (An_Instance     : in out Instance;
      Altitude_Limit  : in     Jat.Altitude_Limit_Type);

   procedure Set_Sensitivity_Level
     (An_Instance       : in out Instance;
      Sensitivity_Level : in     Jat.Sensitivity_Level_Type);

   procedure Set_System_Status
     (An_Instance       : in out Instance;
      System_Status     : in Jat.Tas_Status_Type);

   procedure Set_Tas_Sensitivity_Level
     (An_Instance       : in out Instance;
      Sensitivity_Level : in     Jat.TAS_Sensitivity_Level_Type);

   function Power
     (An_Instance : in Instance)
     return Boolean;

   function Aircraft_Position
     (An_Instance : in Instance)
     return Jpats_Avionics_Types.Position_Type;

   function Ground_Elevation
     (An_Instance : in Instance)
     return Length_Types.Feet;

   function Rate_Of_Climb
     (An_Instance : in Instance)
     return Length_Types.Feet_per_Min;

   function Reposition_In_Progress
     (An_Instance : in Instance)
     return Boolean;

   function Adc_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Adc_Corrected_Altitude
     (An_Instance : in Instance)
     return Length_Types.Feet;

   function Adc_Pressure_Altitude
     (An_Instance : in Instance)
     return Length_Types.Feet;

   function Adc_Vertical_Speed
     (An_Instance : in Instance)
     return Length_Types.Feet_per_Min;

   function Weight_On_Wheels
     (An_Instance : in Instance)
     return Boolean;

   function Intruder_Drive
     (An_Instance : in Instance)
     return Jat.Intruder_Drive_Array_Type;

   function Ahrs_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Ahrs_Attitude
     (An_Instance : in Instance)
     return Jat.Attitude_Type;

   function Flight_Freeze
     (An_Instance : in Instance)
     return Boolean;

   function Gear_Down
     (An_Instance : in Instance)
     return Boolean;

   function Display_Range
     (An_Instance : in Instance)
     return Float;

   function Altitude_Mode
     (An_Instance : in Instance)
     return Jat.Altitude_Range_Type;

   function Tas_Test_Sw
     (An_Instance : in Instance)
     return Boolean;

   function Tas_Stby_Sw
     (An_Instance : in Instance)
     return Boolean;

   function Tas_Sw_Off
     (An_Instance : in Instance)
     return Boolean;

   function Tas_Altitude_Sw
     (An_Instance : in Instance)
     return Boolean;

   function Tas_Sw_Lt
     (An_Instance : in Instance)
     return Boolean;

   function Tas_Message
     (An_Instance : in Instance)
     return Jat.Tas_Message_Type;

   function Tas_Ios_Display
     (An_Instance : in Instance)
     return Jat.Tas_Ios_Display_Type;

   function Tas_On
     (An_Instance : in Instance)
     return Boolean;

   function Altitude_Limit_A
     (An_Instance : in Instance)
     return Jat.Altitude_Limit_Type;

   function Altitude_Limit_B
     (An_Instance : in Instance)
     return Jat.Altitude_Limit_Type;

   function Sensitivity_Level
     (An_Instance : in Instance)
     return Jat.Sensitivity_Level_Type;

   function System_Status
     (An_Instance : in Instance)
     return Jat.Tas_Status_Type;

   function Tas_Sensitivity_Level
     (An_Instance : in Instance)
     return Jat.TAS_Sensitivity_Level_Type;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Iconst      : in     Float;
                    An_Instance : in out Instance);

private

   type Instance is record
      --Inputs For operational Logic
      Power                  : Boolean := False;
      Aircraft_Position      : Jpats_Avionics_Types.Position_Type;
      Ground_Elevation       : Length_Types.Feet;
      Rate_Of_Climb          : Length_Types.Feet_per_Min;
      Reposition_In_Progress : Boolean := False;
      Adc_Valid              : Boolean := False;
      Adc_Corrected_Altitude : Length_Types.Feet;
      Adc_Pressure_Altitude  : Length_Types.Feet;
      Adc_Vertical_Speed     : Length_Types.Feet_per_Min;
      Weight_On_Wheels       : Boolean := False;
      Intruder_Drive         : Jat.Intruder_Drive_Array_Type;
      Ahrs_Valid             : Boolean := False;
      Ahrs_Attitude          : Jat.Attitude_Type;
      Flight_Freeze          : Boolean := False;
      Gear_Down              : Boolean := False;
      Tas_Test_Sw            : Boolean := False;
      Tas_Stby_Sw            : Boolean := False;
      Tas_Sw_Off             : Boolean := False;
      Tas_Altitude_Sw        : Boolean := False;
      Tas_Vsi_Display_Valid  : Boolean := False;

      --Outputs for Display and Packing
      Altitude_Limit_A       : Jat.Altitude_Limit_Type := 0;
      Altitude_Limit_B       : Jat.Altitude_Limit_Type := 0;
      Display_Range          : Float := 5.0;
      Altitude_Mode          : Jat.Altitude_Range_Type := Jat.Level;
      Tas_Sw_Lt              : Boolean := False;
      Tas_Message            : Jat.Tas_Message_Type := Jat.No_Message;
      Tas_Ios_Display        : Jat.Tas_Ios_Display_Type;
      Tas_On                 : Boolean := False;
      System_Status          : Jat.Tas_Status_Type;
      Sensitivity_Level      : Jat.Sensitivity_Level_Type;
      Tas_Sensitivity_Level  : Jat.TAS_Sensitivity_Level_Type;

   end record;

end Tas;
