-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Avionics_Types;

package Radio_Adapter is


   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   -- Access RMU_Rx
   function  RMU_Rx
     (An_Instance : in Instance)
      return Avionics_Types.RMU_Rx_Type;

   procedure Set_RMU_Rx
     (An_Instance : in out Instance;
      RMU_Rx      : in     Avionics_Types.RMU_Rx_Type);

   -- Access UHF_Rx
   function  UHF_Rx
     (An_Instance : in Instance)
      return Avionics_Types.UHF_Rx_Type;

   procedure Set_UHF_Rx
     (An_Instance : in out Instance;
      UHF_Rx      : in     Avionics_Types.UHF_Rx_Type);

   -- Access XPDR_Rx
   function  XPDR_Rx
     (An_Instance : in Instance)
      return Avionics_Types.XPDR_Rx_Type;

   procedure Set_XPDR_Rx
     (An_Instance : in out Instance;
      XPDR_Rx     : in     Avionics_Types.XPDR_Rx_Type);

   -- Access DME_Rx
   function  DME_Rx
     (An_Instance : in Instance)
      return Avionics_Types.DME_Rx_Type;

   procedure Set_DME_Rx
     (An_Instance : in out Instance;
      DME_Rx      : in     Avionics_Types.DME_Rx_Type);

   -- Access NAV_Rx
   function  NAV_Rx
     (An_Instance : in Instance)
      return Avionics_Types.Nav_Rx_Type;

   procedure Set_NAV_Rx
     (An_Instance : in out Instance;
      NAV_Rx      : in     Avionics_Types.Nav_Rx_Type);

   -- Access VHF_Rx
   function  VHF_Rx
     (An_Instance : in Instance)
      return Avionics_Types.VHF_Rx_Type;

   procedure Set_VHF_Rx
     (An_Instance : in out Instance;
      VHF_Rx      : in     Avionics_Types.VHF_Rx_Type);

   -- Access PRI_Tx
   function  PRI_Tx
     (An_Instance : in Instance)
      return Avionics_Types.PRI_Tx_Type;

   procedure Set_PRI_Tx
     (An_Instance : in out Instance;
      PRI_Tx      : in     Avionics_Types.PRI_Tx_Type);

   -- Access SEC_Tx
   function  SEC_Tx
     (An_Instance : in Instance)
      return Avionics_Types.SEC_Tx_Type;

   procedure Set_SEC_Tx
     (An_Instance : in out Instance;
      SEC_Tx      : in     Avionics_Types.SEC_Tx_Type);

   -- Access RMU_Tx
   function  RMU_Tx
     (An_Instance : in Instance)
      return Avionics_Types.RMU_Tx_Type;

   procedure Set_RMU_Tx
     (An_Instance : in out Instance;
      RMU_Tx      : in     Avionics_Types.RMU_Tx_Type);

   -- Access VHF_Squelch
   function  VHF_Squelch
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_VHF_Squelch
     (An_Instance : in out Instance;
      VHF_Squelch : in     Boolean);

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method update
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);


private

  type Instance is record
    Power       : Boolean;
    RMU_Rx      : Avionics_Types.RMU_Rx_Type;
    UHF_Rx      : Avionics_Types.UHF_Rx_Type;
    XPDR_Rx     : Avionics_Types.XPDR_Rx_Type;
    DME_Rx      : Avionics_Types.DME_Rx_Type;
    NAV_Rx      : Avionics_Types.Nav_Rx_Type;
    Vhf_Rx      : Avionics_Types.Vhf_Rx_Type;
    PRI_Tx      : Avionics_Types.PRI_Tx_Type;
    SEC_Tx      : Avionics_Types.SEC_Tx_Type;
    RMU_Tx      : Avionics_Types.RMU_Tx_Type;
    VHF_Squelch : Boolean;
  end record;


end Radio_Adapter;
