-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Radio_Adapter is

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean) is
   begin
      An_Instance.Power := Power;
   end Set_Power;

-- Access RMU_Rx
   function  RMU_Rx
     (An_Instance : in Instance)
      return Avionics_Types.RMU_Rx_Type is
   begin
      return An_Instance.RMU_Rx;
   end RMU_Rx;

   procedure Set_RMU_Rx
     (An_Instance : in out Instance;
      RMU_Rx      : in     Avionics_Types.RMU_Rx_Type) is
   begin
      An_Instance.RMU_Rx := RMU_Rx;
   end Set_RMU_Rx;

   -- Access UHF_Rx
   function  UHF_Rx
     (An_Instance : in Instance)
      return Avionics_Types.UHF_Rx_Type is
   begin
      return An_Instance.UHF_Rx;
   end UHF_Rx;

   procedure Set_UHF_Rx
     (An_Instance : in out Instance;
      UHF_Rx      : in     Avionics_Types.UHF_Rx_Type) is
   begin
      An_Instance.UHF_Rx := UHF_Rx;
   end Set_UHF_Rx;

   -- Access XPDR_Rx
   function  XPDR_Rx
     (An_Instance : in Instance)
      return Avionics_Types.XPDR_Rx_Type is
   begin
      return An_Instance.XPDR_Rx;
   end XPDR_Rx;

   procedure Set_XPDR_Rx
     (An_Instance : in out Instance;
      XPDR_Rx     : in     Avionics_Types.XPDR_Rx_Type) is
   begin
      An_Instance.XPDR_Rx := XPDR_Rx;
   end Set_XPDR_Rx;

   -- Access DME_Rx
   function  DME_Rx
     (An_Instance : in Instance)
      return Avionics_Types.DME_Rx_Type is
   begin
      return An_Instance.DME_Rx;
   end DME_Rx;

   procedure Set_DME_Rx
     (An_Instance : in out Instance;
      DME_Rx      : in     Avionics_Types.DME_Rx_Type) is
   begin
      An_Instance.DME_Rx := DME_Rx;
   end Set_DME_Rx;

-- Access NAV_Rx
   function  NAV_Rx
     (An_Instance : in Instance)
      return Avionics_Types.Nav_Rx_Type is
   begin
      return An_Instance.NAV_Rx;
   end NAV_Rx;

   procedure Set_NAV_Rx
     (An_Instance : in out Instance;
      NAV_Rx      : in     Avionics_Types.Nav_Rx_Type) is
   begin
      An_Instance.NAV_Rx := NAV_Rx;
   end Set_NAV_Rx;

-- Access VHF_Rx
   function  VHF_Rx
     (An_Instance : in Instance)
      return Avionics_Types.VHF_Rx_Type is
   begin
      return An_Instance.VHF_Rx;
   end VHF_Rx;

   procedure Set_VHF_Rx
     (An_Instance : in out Instance;
      VHF_Rx      : in     Avionics_Types.VHF_Rx_Type) is
   begin
      An_Instance.VHF_Rx := VHF_Rx;
   end Set_VHF_Rx;

-- Access PRI_Tx
   function  PRI_Tx
     (An_Instance : in Instance)
      return Avionics_Types.PRI_Tx_Type is
   begin
      return An_Instance.PRI_Tx;
   end PRI_Tx;

   procedure Set_PRI_Tx
     (An_Instance : in out Instance;
      PRI_Tx      : in     Avionics_Types.PRI_Tx_Type) is
   begin
      An_Instance.PRI_Tx := PRI_Tx;
   end Set_PRI_Tx;

   -- Access SEC_Tx
   function  SEC_Tx
     (An_Instance : in Instance)
      return Avionics_Types.SEC_Tx_Type is
   begin
      return An_Instance.SEC_Tx;
   end SEC_Tx;

   procedure Set_SEC_Tx
     (An_Instance : in out Instance;
      SEC_Tx      : in     Avionics_Types.SEC_Tx_Type) is
   begin
      An_Instance.SEC_Tx :=SEC_Tx;
   end Set_SEC_Tx;

   -- Access RMU_Tx
   function  RMU_Tx
     (An_Instance : in Instance)
      return Avionics_Types.RMU_Tx_Type is
   begin
      return An_Instance.RMU_Tx;
   end RMU_Tx;

   procedure Set_RMU_Tx
     (An_Instance : in out Instance;
      RMU_Tx      : in     Avionics_Types.RMU_Tx_Type) is
   begin
      An_Instance.RMU_Tx := RMU_Tx;
   end Set_RMU_Tx;

   -- Access VHF_Squelch
   function  VHF_Squelch
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.VHF_Squelch;
   end VHF_Squelch;

   procedure Set_VHF_Squelch
     (An_Instance : in out Instance;
      VHF_Squelch : in     Boolean) is
   begin
      An_Instance.VHF_Squelch := VHF_Squelch;
   end Set_VHF_Squelch;

-- Method Init
   procedure Init
     (An_Instance : in out Instance) is

   begin

      An_Instance.Power             := False;
      An_Instance.RMU_Rx.Frequency  := 0;
      An_Instance.UHF_Rx.Frequency  := 0;
      An_Instance.XPDR_Rx.Frequency := 0;
      An_Instance.DME_Rx.Frequency  := 0;
      An_Instance.NAV_Rx.Frequency  := 0;
      An_Instance.Vhf_Rx.Frequency  := 0;
      An_Instance.PRI_Tx.Frequency  := 0;
      An_Instance.SEC_Tx.Frequency  := 0;
      An_Instance.RMU_Tx.Frequency  := 0;
      An_Instance.VHF_Squelch       := False;

   end Init;

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance) is

      Test : Boolean;

   begin

      Test := An_Instance.Power;

--      null;

   end Update;


end Radio_Adapter;
