-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package JPATS_Avionics_Types is

   type Attitude_Type is
      record
         Pitch   : Float := 0.0;
         Roll    : Float := 0.0;
         Heading : Float := 0.0;
      end record;

   type Attitude_Rate_Type is
      record
         X : Float := 0.0;
         Y : Float := 0.0;
         Z : Float := 0.0;
      end record;
   type Align_Mode_Type is (Ready,Aligning);
   for Align_Mode_Type'Size use 1;

   type Heading_Mode_Type is (Dg,Mag);
   for Heading_Mode_Type'Size use 1;

   type Ahrs_Discretes_Type is
      record
         Align_Mode     : Align_Mode_Type := Aligning;
         Normal_Mode    : Boolean := True;
         Heading_Mode   : Heading_Mode_Type := Mag;
         Attitude_Valid : Boolean := false;
         Ahru_Valid     : Boolean := false;
      end record;

   subtype Degrees_DP_Type is Long_Float;

   subtype Lat_Type is Degrees_DP_Type range -90.0 .. 90.0;

   subtype Lon_Type is Degrees_DP_Type range -180.0 .. 180.0;

   subtype Altitude_Type is Float range -1_000.0 .. 100_000.0;

   subtype Bearing_Type is Float;

   type Position_Type is
      record
         Latitude    : Lat_Type;
         Longitude   : Lon_Type;
         Altitude    : Altitude_Type;
      end record;

   type Traffic is array (1 .. 32) of Integer;

   type Intruders is array(Traffic'Range) of Integer;
   type Ios_Boolean_Type is array (Intruders'Range) of Boolean;
   type Ios_Integer_Type is array (Intruders'Range) of Integer;
   type Ios_Float_Type is array(Intruders'Range) of Float;
   type Ios_Position_Type is array(Intruders'Range) of Position_Type;
   type Aircraft_Type is (T6a_Navy,T6a_AF,Fuel_Truck,Fire_Truck,Pickup,Tow_Tug,
                          Cessna,Ch_601,King_Air,F16,T1a,T6b_Navy,Kc10,
                          Bell_407,Crop_Duster,F15,Kc135,T38,Fire_T_Red,
                          Follow,Fuel_Short,Fuel_Long,Humv,Tank_Grn,
                          Tank_Tan,Tank_Wht,Truck_Grn,Truck_Tan,Truck_Wht,
                          Su25,Su35,Tu95);
   for Aircraft_Type'Size use 32;
   type Ios_Aircraft_Type is array (Intruders'Range) of Aircraft_Type;
   type Vertical_Type is (Above,Level,Below);
   for Vertical_Type'Size use 32;
   type Ios_Vertical_Type is array (Intruders'Range) of Vertical_Type;

   type Intruder_Drive_Type is
      record
         Aircraft           : Aircraft_Type;
         Lat                : Lat_Type;
         Lon                : Lon_Type;
         Active             : Boolean;
         Altitude           : Float;
         Heading            : Float;
         Completion_Percent : Float;
         Brg_From_Sim       : Float;
         Dst_From_Sim       : Float;
         Roll               : Float;
         Pitch              : Float;
      end record;

   type Intruder_Drive_Array_Type is array (Intruders'range) of
     Intruder_Drive_Type;

   type Uhf_Tuning_Type is
      record
         Mode_On : Boolean := false;
         Frequency   : Integer := 0;
         Stby_Freq   : Integer := 0;
         Channel     : Integer := 0;
         Preset_Mode : Boolean := False;
         Squelch     : Boolean := False;
         Tone        : Boolean := False;
         Both        : Boolean := False;
      end record;

   type Vhf_Tuning_Type is
      record
         Mode_On : Boolean := false;
         Frequency : Integer := 0;
         Stby_Freq : Integer := 0;
         Squelch : Boolean := False;
      end record;

   type Nav_Tuning_Type is
      record
         Frequency              : Integer := 0;
         Stby_Freq              : Integer := 0;
         Ils_Frequency_Selected : Boolean := false;
         Squelch : Boolean := False;
      end record;

   type Xpdr_Mode_Select_Type is (Stby, On, Alt, Ta, Ta_Ra);

   type Atc_Tuning_Type is
      record
         Ident      : Boolean := False;
         Test       : Boolean := False;
         Mode       : Xpdr_Mode_Select_Type := Stby;
         Code       : Integer := 1200;
         Stby_Code  : Integer := 1200;
      end record;

   type Dme_Tuning_Type is
      record
         Frequency : Integer;
         Hold      : Boolean;
      end record;

   type Gps_Navigation_Mode_Type is (Enroute,Terminal,Approach);

   type Gps_Test_Mode_Type is
      (Normal_Operation,Idle_Receiver_Mode,All_Channels_Track_Sv_11);

   type Gps_Initialization_Data_Type is
      record
         Latitude              : Long_Float;
         Longitude             : Long_Float;
         Test_Mode             : Gps_Test_Mode_Type;
         Search_The_Sky        : Boolean;
         Year                  : Integer;
         Month                 : Integer;
         Day                   : Integer;
         Hour                  : Integer;
         Minute                : Integer;
         Seconds               : Integer;
         Estimated_Groundspeed : Integer;
         True_Airspeed         : Float;
         True_Heading          : Float;
         Track_Angle           : Integer;
      end record;

   type Gps_Altitude_Value_Type is (Not_Valid,Pressure,Barometric);

   type Gps_Altitude_Type is
      record
         Altitude_Value : Gps_Altitude_Value_Type;
         Altitude       : Float;
      end record;

   type Gps_Raim_Availability_Request_Type is
      record
         Latitude      : Long_Float;
         Longitude     : Long_Float;
         Altitude      : Integer;
         Delta_Seconds : Integer;
         Nav_Mode      : Gps_Navigation_Mode_Type;
      end record;

   type Gps_Horizontal_Position_Type is
      record
         Valid     : Boolean;
         Latitude  : Long_Float;
         Longitude : Long_Float;
         Error     : Float;
      end record;

   type Gps_Vertical_Position_Type is
      record
         Valid    : Boolean;
         Altitude : Float;
         Error    : Float;
      end record;

   type Gps_Groundspeed_Track_Angle_Type is
      record
         Valid       : Boolean;
         Groundspeed : Float;
         Track_Angle : Float;
      end record;

   type Gps_Velocity_Type is
      record
         Valid          : Boolean;
         East_Velocity  : Float;
         North_Velocity : Float;
         Up_Velocity    : Float;
      end record;

   type Gps_Date_Time_Type is
      record
         Valid  : Boolean;
         Year   : Integer;
         Month  : Integer;
         Day    : Integer;
         Hour   : Integer;
         Minute : Integer;
         Second : Integer;
      end record;

   type Gps_Frequency_Esitmate_Type is
      record
         Valid              : Boolean;
         Frequency_Estimate : Float;
      end record;

   type Gps_Health_Type is (No_Data,Bad,Weak,Good,Deselected);
   for Gps_Health_Type'Size use 32;

   type Gps_Satellite_Status_Type is
      record
         Sat_Id    : Integer;
         Health    : Gps_Health_Type;
         Elevation : Integer;
         Snr       : Integer;
         Tracking  : Boolean;
      end record;

   type Gps_Channels is array (1 .. 8) of Integer;

   type Gps_Satellite_Status_Type_Array is array (Gps_Channels'Range) of
     Gps_Satellite_Status_Type;

   type State_Type is
      (Initialization,Search_The_Sky,Acquisition,Transition,Navigation,
       Navigation_With_Data,Navigation_With_Degradation,Dead_Reckon);

   type Gps_State_Type is
      record
         State                    : State_Type;
         Integrity_State          : Boolean;
         Masked_Integrity_Warning : Boolean;
         Bad_Coverage             : Boolean;
         Altitude_Aiding_In_Use   : Boolean;
         Nav_Mode                 : Gps_Navigation_Mode_Type;
         Error_Status             : Integer;
      end record;

   type Gps_Satellite_Azimuth_Type is array (Gps_Channels'Range) of Integer;

   type Status_Type is (Normal,Ip_Op_Different,Invalid_Data,No_Data);
   for Status_Type'Size use 2;

   type Uhf_Mode_Type is (Main,Both,Adf);
   for Uhf_Mode_Type'Size use 2;

   type Backup_Uhf_Mode_Type is (Adf,Main,Guard,Both);
   for Backup_Uhf_Mode_Type'Size use 2;

   type Uhf_Frequency_Mode_Type is (Active,Guard,Manual,Preset);
   for Uhf_Frequency_Mode_Type'Size use 2;

   type Bandwidth_Type is (Narrow, Wide);

   type Uhf_Radio_State_Type is (Rx_Main,Tx_Main,Rx_Guard,Tx_Duplex);
   for Uhf_Radio_State_Type'Size use 2;

   type Vhf_Comm_Active_Data_Type is
      record
         Status        : Status_Type := Normal;
         Not_Squelched : Boolean := False;
         Push_To_Talk  : Boolean := False;
         Frequency     : Integer := 118000;
      end record;

   type Uhf_Comm_Active_Data_Type is
      record
         Status             : Status_Type := Normal;
         Not_Squelched      : Boolean := False;
         Push_To_Talk       : Boolean := False;
         Channel            : Integer := 1;
         Frequency          : Integer := 245000;
         Mode               : Uhf_Mode_Type := Both;
         Frequency_Mode     : Uhf_Frequency_Mode_Type := Manual;
         Time_Of_Day_Active : Boolean := False;
         Bandwidth_wide     : Boolean := False;
         Tone               : Boolean := False;
         Mic_Stuck          : Boolean := False;
         Radio_State        : Uhf_Radio_State_Type := Rx_Main;
      end record;

   type Nav_Active_Data_Type is
      record
         Status             : Status_Type := Normal;
         Ils_Freq_Selected  : Boolean := False;
         Frequency          : Integer := 11230;
      end record;

   type Dme_Active_Data_Type is
      record
         Status             : Status_Type := Normal;
         Mls_In_Control     : Boolean := False;
         Dme_Hold           : Boolean := False;
         Box                : Boolean := False;
         Mls_Frequency      : Boolean := False;
         Frequency          : Integer := 11230;
      end record;

   type Uhf_Channel_Active_Frequency_Type is array (1 .. 6) of Integer;
   type Vhf_Memory_Data_Type is array (1 .. 20) of Integer;
   type Uhf_Memory_Data_Type is array (1 .. 20) of Integer;
   type Nav_Memory_Data_Type is array (1 .. 10) of Integer;

   type Transponder_Active_Data_Type is
      record
         Status             : Status_Type := Normal;
         Ident_On           : Boolean := False;
         Mode               : Xpdr_Mode_Select_Type := Stby;
         Test               : Boolean := False;
         Code               : Integer := 1200;
      end record;

   type Vhf_Comm_Current_Data_Type is
      record
         Direct_Tune                   : Boolean := False;
         Memory_Mode                   : Boolean := False;
         Memory_Number_Last_In_Dipslay : Integer := 1;
         Frequency                     : Integer := 118000;
         Temp_Frequency                : Integer := 118000;
      end record;

   type Uhf_Comm_Current_Data_Type is
      record
         Direct_Tune                   : Boolean := False;
         Memory_Mode                   : Boolean := False;
         Memory_Number_Last_In_Dipslay : Integer := 1;
         Frequency                     : Integer := 245000;
         Temp_Frequency                : Integer := 245000;
      end record;

   type Nav_Current_Data_Type is
      record
         Direct_Tune                   : Boolean := False;
         Memory_Mode                   : Boolean := False;
         Memory_Number_Last_In_Dipslay : Integer := 1;
         Frequency                     : Integer := 11230;
         Temp_Frequency                : Integer := 11230;
      end record;

   type Transponder_Current_Data_Type is
      record
         Ident_Active : Boolean := False;
         Code         : Integer := 1200;
      end record;

   type Intr_Range_Type is array(Traffic'Range) of Float;

   type Vertical_Sense_Type is (Level,Climbing,Descending);

   type Intr_Vertical_Sense_Type is
     array(Traffic'Range) of Vertical_Sense_Type;

   type Intr_Relative_Altitude_Type is array(Traffic'Range) of Float;

   type Display_Matrix_Type is (NonThreat,
                                Traffic_Advisory,
                                Resolution_Advisory,
                                Proximate,
                                NotUsed1,
                                NotUsed2,
                                NotUsed3,
                                NotUsed4);

   type IOS_Display_Matrix_Type is (NonThreat_Level,
                                    Ta_Level,
                                    Ta_NoBrg_Level,
                                    Prox_Level,
                                    Reserved4,
                                    Reserved5,
                                    Reserved6,
                                    Reserved7,
                                    NonThreat_Climb,
                                    Ta_Climb,
                                    Ta_NoBrg_Climb,
                                    Prox_Climb,
                                    Reserved12,
                                    Reserved13,
                                    Reserved14,
                                    Reserved15,
                                    NonThreat_Desc,
                                    Ta_Desc,
                                    Ta_NoBrg_Desc,
                                    Prox_Desc,
                                    Reserved20,
                                    Reserved21,
                                    Reserved22,
                                    Reserved23);

   type Intr_Display_Matrix_Type is
     array(Traffic'Range) of Display_Matrix_Type;

   type Ios_Intr_Display_Matrix_Type is
     array(Traffic'Range) of Ios_Display_Matrix_Type;

   type Intr_Bearing_Type is array(Traffic'Range) of Float;

   type Intr_Active_Type is array(Traffic'Range) of Boolean;

   type Intr_Bearing_Valid_Type is array(Traffic'Range) of Boolean;

   type Tas_Status_Type is (Tas_Off, Tas_Normal, Tas_Test, Tas_Stby, Tas_Fail);

   type Ios_Tas_Status_Type is (Tas_Ios_Operate, Tas_Ios_Test,
                                Tas_Ios_Stby, Tas_Ios_Fail,
                                Tas_Oper_Vsi_Fail, Tas_Test_Vsi_Fail,
                                Tas_Stby_Vsi_Fail, Tas_Fail_Vsi_Vail);

   type Altitude_Range_Type is (Level, Above, Below);

   type Tas_Switch_Type is (Tas_Sw_Norm, Tas_Sw_Test, Tas_Sw_Standby);

   type Sensitivity_Level_Type is (SL0_NU, SL1_STBY, SL2_TA, SL3_RA,
                                   SL4_NU, SL5_NU,   SL6_NU, SL7_NU);
   type TAS_Sensitivity_Level_Type is (SL0_TAS_NU,   SL4_TAS_NU, SL2_TA_A, SL6_TAS_NU,
                                       SL1_TAS_STBY, SL5_TAS_NU, SL3_TA_B, SL7_TAS_NU);

   type Altitude_Limit_Type is mod 2**7;
   for Altitude_Limit_Type'Size use 7;

   type Tas_Ios_Display_Type is
      record
         Altitude_Range         : Altitude_Range_Type;
         Intr_Range             : Intr_Range_Type;
         Intr_Relative_Altitude : Intr_Relative_Altitude_Type;
         Intr_Ios_Display       : Ios_Intr_Display_Matrix_Type;
         Intr_Bearing           : Intr_Bearing_Type;
         Intr_Active            : Intr_Active_Type;
         Intr_Vertical_Sense    : Intr_Vertical_Sense_Type;
         Intr_Display           : Intr_Display_Matrix_Type;
         Intr_Bearing_Valid     : Intr_Bearing_Valid_Type;
         Tas_Switch_Pos         : Tas_Switch_Type;
         Tas_Status             : Ios_Tas_Status_Type;
      end record;

   type Tas_Message_Type is (No_Message,TrafficX2, TrafficX1, Test_OK, Test_Fail);

   --IOS repeater types
   type Gps_Alert_Type is (Blank,Wpt,Msg);
   type Map_Mode_Type is (Wpt,Ground,Airport,Ground_Airport);
   type Dme_Status_Type is (Valid,Not_Computed,Invalid);
   type Groundspeed_Status_Type is (Valid,Dme_Hold,Invalid);
   type To_From_Type is (Invalid,To,From);
   type Marker_Beacon_Type is (None,Om,Mm,Im,Tst);
   type Time_To_Go_Type is (Valid,Dme_Hold,Invalid);

   subtype String4 is String(1 .. 4);

   type Atis_Ceiling is (Unlimited,Broken,Overcast);

   type Atis_Visibility_Condition_Type is (Fog,Rain);

   type Station_Type is (None,Airport,Dme,Tacan,Vor,Vordme,Vortac,Waypoint);
   subtype Waypoint_Ident_Type is String(1 .. 40*6);
   type Waypoint_Station_Type_Type is array (1 .. 40) of Station_Type;
   type Waypoint_Latitude_Type is array (1 .. 40) of Long_Float;
   type Waypoint_Longitude_Type is array (1 .. 40) of Long_Float;

end JPATS_Avionics_Types;




