-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Avionics.Container,
  Jpats_Avionics_Types,
  Tas;

use Jpats_Avionics_Types;

package body JPATS_Avionics is

   package Jat renames Jpats_Avionics_Types;

   function Course_Selected
     return Float is
   begin
      return Container.This_Subsystem.The_Course_Selected;
   end;

   function Uhf_Tuning
     return Jpats_Avionics_Types.Uhf_Tuning_Type is
   begin
      return Container.This_Subsystem.The_Uhf_Tuning;
   end;

   function Vhf_Tuning
     return Jpats_Avionics_Types.Vhf_Tuning_Type is
   begin
      return Container.This_Subsystem.The_Vhf_Tuning;
   end;

   function Nav_Tuning
     return Jpats_Avionics_Types.Nav_Tuning_Type is
   begin
      return Container.This_Subsystem.The_Nav_Tuning;
   end;

   function Atc_Tuning
     return Jpats_Avionics_Types.Atc_Tuning_Type is
   begin
      return Container.This_Subsystem.The_Atc_Tuning;
   end;

   function Dme_Tuning
     return Jpats_Avionics_Types.Dme_Tuning_Type is
   begin
      return Container.This_Subsystem.The_Dme_Tuning;
   end;

   function Tas_Message
     return Jpats_Avionics_Types.Tas_Message_Type is
   begin
      return Tas.Tas_Message(Container.This_Subsystem.The_Tas);
   end Tas_Message;

   function Nav_Float1
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float1;
   end;

   function Nav_Float2
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float2;
   end;

   function Nav_Float3
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float3;
   end;

   function Nav_Float4
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float4;
   end;

   function Nav_Float5
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float5;
   end;

   function Nav_Float6
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float6;
   end;

   function Nav_Float7
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float7;
   end;

   function Nav_Float8
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float8;
   end;

   function Nav_Float9
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float9;
   end;

   function Nav_Float10
     return Float is
   begin
      return Container.This_Ios_Interface.Nav_Float10;
   end;

   function Nav_Bool1
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool1;
   end;

   function Nav_Bool2
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool2;
   end;

   function Nav_Bool3
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool3;
   end;

   function Nav_Bool4
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool4;
   end;

   function Nav_Bool5
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool5;
   end;

   function Nav_Bool6
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool6;
   end;

   function Nav_Bool7
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool7;
   end;

   function Nav_Bool8
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool8;
   end;

   function Nav_Bool9
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool9;
   end;

   function Nav_Bool10
     return Boolean is
   begin
      return Container.This_Ios_Interface.Nav_Bool10;
   end;

   function Nav_Int1
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int1;
   end;

   function Nav_Int2
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int2;
   end;

   function Nav_Int3
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int3;
   end;

   function Nav_Int4
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int4;
   end;

   function Nav_Int5
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int5;
   end;

   function Nav_Int6
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int6;
   end;

   function Nav_Int7
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int7;
   end;

   function Nav_Int8
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int8;
   end;

   function Nav_Int9
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int9;
   end;

   function Nav_Int10
     return Integer is
   begin
      return Container.This_Ios_Interface.Nav_Int10;
   end;
 
   function Atc_Flight_ID
     return String is
   begin
      return Container.This_Ios_Interface.Atc_Flight_ID;
   end;
   
   function Nav_Str1
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str1;
   end;

   function Nav_Str2
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str2;
   end;

   function Nav_Str3
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str3;
   end;

   function Nav_Str4
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str4;
   end;

   function Nav_Str5
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str5;
   end;

   function Nav_Str6
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str6;
   end;

   function Nav_Str7
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str7;
   end;

   function Nav_Str8
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str8;
   end;

   function Nav_Str9
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str9;
   end;

   function Nav_Str10
     return String is
   begin
      return Container.This_Ios_Interface.Nav_Str10;
   end;

   procedure Set_Nav_Float1 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float1 := Float1;
   end;
   procedure Set_Nav_Float2 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float2 := Float1;
   end;
   procedure Set_Nav_Float3 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float3 := Float1;
   end;
   procedure Set_Nav_Float4 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float4 := Float1;
   end;
   procedure Set_Nav_Float5 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float5 := Float1;
   end;
   procedure Set_Nav_Float6 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float6 := Float1;
   end;
   procedure Set_Nav_Float7 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float7 := Float1;
   end;
   procedure Set_Nav_Float8 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float8 := Float1;
   end;
   procedure Set_Nav_Float9 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float9 := Float1;
   end;
   procedure Set_Nav_Float10 (Float1 : in Float) is
   begin
      Container.This_Ios_Interface.Nav_Float10 := Float1;
   end;


   procedure Set_Nav_Int1 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int1 := Int1;
   end;
   procedure Set_Nav_Int2 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int2 := Int1;
   end;
   procedure Set_Nav_Int3 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int3 := Int1;
   end;
   procedure Set_Nav_Int4 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int4 := Int1;
   end;
   procedure Set_Nav_Int5 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int5 := Int1;
   end;
   procedure Set_Nav_Int6 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int6 := Int1;
   end;
   procedure Set_Nav_Int7 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int7 := Int1;
   end;
   procedure Set_Nav_Int8 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int8 := Int1;
   end;
   procedure Set_Nav_Int9 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int9 := Int1;
   end;
   procedure Set_Nav_Int10 (Int1 : in Integer) is
   begin
      Container.This_Ios_Interface.Nav_Int10 := Int1;
   end;


   procedure Set_Nav_Bool1 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool1 := Bool1;
   end;
   procedure Set_Nav_Bool2 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool2 := Bool1;
   end;
   procedure Set_Nav_Bool3 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool3 := Bool1;
   end;
   procedure Set_Nav_Bool4 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool4 := Bool1;
   end;
   procedure Set_Nav_Bool5 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool5 := Bool1;
   end;
   procedure Set_Nav_Bool6 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool6 := Bool1;
   end;
   procedure Set_Nav_Bool7 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool7 := Bool1;
   end;
   procedure Set_Nav_Bool8 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool8 := Bool1;
   end;
   procedure Set_Nav_Bool9 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool9 := Bool1;
   end;
   procedure Set_Nav_Bool10 (Bool1 : in Boolean) is
   begin
      Container.This_Ios_Interface.Nav_Bool10 := Bool1;
   end;

   procedure Set_Atc_Flight_ID (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Atc_Flight_ID(1..12) := Str1;
   end;
   procedure Set_Nav_Str1 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str1(1..4) := Str1;
   end;
   procedure Set_Nav_Str2 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str2(1..4) := Str1;
   end;
   procedure Set_Nav_Str3 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str3(1..4) := Str1;
   end;
   procedure Set_Nav_Str4 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str4(1..4) := Str1;
   end;
   procedure Set_Nav_Str5 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str5(1..4) := Str1;
   end;
   procedure Set_Nav_Str6 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str6(1..4) := Str1;
   end;
   procedure Set_Nav_Str7 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str7(1..4) := Str1;
   end;
   procedure Set_Nav_Str8 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str8(1..4) := Str1;
   end;
   procedure Set_Nav_Str9 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str9(1..4) := Str1;
   end;
   procedure Set_Nav_Str10 (Str1 : in string) is
   begin
      Container.This_Ios_Interface.Nav_Str10(1..4) := Str1;
   end;

end JPATS_Avionics;
