-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with JPATS_IOS_Interface;

package JPATS_Avionics.Ios_If is

   procedure Set_Attitude_Fail(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Heading_Fail(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Raim_Fail(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Ahrs_Fail(Pdata : JPATS_IOS_Interface.Set_Value);
   
   procedure Set_Atc_Flight_ID  (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);

   procedure Set_Threat_Page_Display_On_1 (Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Threat_Page_Display_On_2 (Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Ios_Timer (Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Waypoint_Latitude (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                    Offset1d  : in Integer;
                                    Offset2d  : in Integer;
                                    Completed : in Boolean);

   procedure Set_Waypoint_Longitude (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                     Offset1d  : in Integer;
                                     Offset2d  : in Integer;
                                     Completed : in Boolean);

   procedure Set_Waypoint_Ident (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);

   procedure Set_Waypoint_Station_Type (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                        Offset1d  : in Integer;
                                        Offset2d  : in Integer;
                                        Completed : in Boolean);

   procedure Set_Vor_Map_Station_Ident (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                        Offset1d  : in Integer;
                                        Offset2d  : in Integer;
                                        Completed : in Boolean);

   procedure Set_Nav_Float1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float2(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float3(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float4(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float5(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float6(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float7(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float8(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float9(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Float10(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Nav_Int1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int2(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int3(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int4(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int5(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int6(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int7(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int8(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int9(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Int10(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Nav_Bool1(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool2(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool3(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool4(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool5(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool6(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool7(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool8(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool9(Pdata : JPATS_IOS_Interface.Set_Value);
   procedure Set_Nav_Bool10(Pdata : JPATS_IOS_Interface.Set_Value);

   procedure Set_Nav_Str1 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str2 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str3 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str4 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str5 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str6 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str7 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str8 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str9 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);
   procedure Set_Nav_Str10 (Pdata     : in JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : in Integer;
                                 Offset2d  : in Integer;
                                 Completed : in Boolean);

   procedure Register_Ios_Variables;

end JPATS_Avionics.Ios_If;



