-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Avionics.Container,
  Jpats_Ios_Interface,
  Jpats_Avionics_Types;

package body JPATS_Avionics.Ios_If is

   package Jat renames Jpats_Avionics_Types;
   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   Temp_Int : Integer;

   procedure Set_Attitude_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Attitude_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Attitude_Fail;

   procedure Set_Heading_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Heading_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Heading_Fail;

   procedure Set_Raim_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Raim_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Raim_Fail;

   procedure Set_GPS_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.GPS_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_GPS_Fail;

   procedure Set_Xpdr_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Xpdr_Fail := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Xpdr_Fail;

   procedure Set_Ahrs_Fail( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Ahrs_Fail_Malf := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Ahrs_Fail;

   procedure Set_Atc_Flight_ID ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Atc_Flight_ID(Offset1d+1):=' ';
      else
         Ios.Atc_Flight_ID(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Atc_Flight_ID_Was_Set := Completed;
   end Set_Atc_Flight_ID;
   
   procedure Set_Threat_Page_Display_On_1 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Threat_Page_Display_On(1) :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Threat_Page_Display_On_1;

   procedure Set_Threat_Page_Display_On_2 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Threat_Page_Display_On(2) :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Threat_Page_Display_On_2;

   procedure Set_Ios_Timer (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Ios_Timer :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Ios_Timer;

   procedure Set_Waypoint_Latitude( pData     : JPATS_IOS_Interface.Set_Value;
                                    Offset1d  : Integer;
                                    Offset2d  : Integer;
                                    Completed : Boolean) is
   begin
      null;
   end Set_Waypoint_Latitude;

   procedure Set_Waypoint_Longitude( pData     : JPATS_IOS_Interface.Set_Value;
                                     Offset1d  : Integer;
                                     Offset2d  : Integer;
                                     Completed : Boolean) is
   begin
      null;
   end Set_Waypoint_Longitude;

   procedure Set_Waypoint_Ident( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      null;
   end Set_Waypoint_Ident;

   procedure Set_Waypoint_Station_Type( pData     : JPATS_IOS_Interface.Set_Value;
                                        Offset1d  : Integer;
                                        Offset2d  : Integer;
                                        Completed : Boolean) is
   begin
      null;
   end Set_Waypoint_Station_Type;

   procedure Set_Vor_Map_Station_Ident( pData     : JPATS_IOS_Interface.Set_Value;
                                        Offset1d  : Integer;
                                        Offset2d  : Integer;
                                        Completed : Boolean) is
   begin
      null;
   end Set_Vor_Map_Station_Ident;

   procedure Set_Nav_Float1 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float1 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float1;

   procedure Set_Nav_Float2 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float2 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float2;

   procedure Set_Nav_Float3 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float3 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float3;

   procedure Set_Nav_Float4 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float4 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float4;

   procedure Set_Nav_Float5 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float5 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float5;

   procedure Set_Nav_Float6 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float6 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float6;

   procedure Set_Nav_Float7 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float7 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float7;

   procedure Set_Nav_Float8 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float8 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float8;

   procedure Set_Nav_Float9 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float9 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float9;

   procedure Set_Nav_Float10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Float10 :=
        Jpats_Ios_Interface.Convert_To_Float( Pdata );
   end Set_Nav_Float10;

   procedure Set_Nav_Int1 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int1 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int1;

   procedure Set_Nav_Int2 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int2 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int2;

   procedure Set_Nav_Int3 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int3 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int3;

   procedure Set_Nav_Int4 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int4 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int4;

   procedure Set_Nav_Int5 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int5 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int5;

   procedure Set_Nav_Int6 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int6 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int6;

   procedure Set_Nav_Int7 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int7 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int7;

   procedure Set_Nav_Int8 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int8 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int8;

   procedure Set_Nav_Int9 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int9 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int9;

   procedure Set_Nav_Int10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Int10 :=
        Jpats_Ios_Interface.Convert_To_Integer( Pdata );
   end Set_Nav_Int10;

   procedure Set_Nav_Bool1 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool1 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool1;

   procedure Set_Nav_Bool2 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool2 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool2;

   procedure Set_Nav_Bool3 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool3 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool3;

   procedure Set_Nav_Bool4 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool4 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool4;

   procedure Set_Nav_Bool5 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool5 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool5;

   procedure Set_Nav_Bool6 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool6 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool6;

   procedure Set_Nav_Bool7 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool7 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool7;

   procedure Set_Nav_Bool8 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool8 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool8;

   procedure Set_Nav_Bool9 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool9 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool9;

   procedure Set_Nav_Bool10 (Pdata : JPATS_IOS_Interface.Set_Value) is
   begin
      Ios.Nav_Bool10 :=
        Jpats_Ios_Interface.Convert_To_Bool( Pdata );
   end Set_Nav_Bool10;

   procedure Set_Nav_Str1 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str1(Offset1d+1):=' ';
      else
         Ios.Nav_Str1(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str1_Was_Set := Completed;
   end Set_Nav_Str1;

   procedure Set_Nav_Str2 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str2(Offset1d+1):=' ';
      else
         Ios.Nav_Str2(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str2_Was_Set := Completed;
   end Set_Nav_Str2;

   procedure Set_Nav_Str3 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str3(Offset1d+1):=' ';
      else
         Ios.Nav_Str3(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str3_Was_Set := Completed;
   end Set_Nav_Str3;

   procedure Set_Nav_Str4 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str4(Offset1d+1):=' ';
      else
         Ios.Nav_Str4(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str4_Was_Set := Completed;
   end Set_Nav_Str4;

   procedure Set_Nav_Str5 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str5(Offset1d+1):=' ';
      else
         Ios.Nav_Str5(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str5_Was_Set := Completed;
   end Set_Nav_Str5;

   procedure Set_Nav_Str6 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str6(Offset1d+1):=' ';
      else
         Ios.Nav_Str6(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str6_Was_Set := Completed;
   end Set_Nav_Str6;

   procedure Set_Nav_Str7 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str7(Offset1d+1):=' ';
      else
         Ios.Nav_Str7(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str7_Was_Set := Completed;
   end Set_Nav_Str7;

   procedure Set_Nav_Str8 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str8(Offset1d+1):=' ';
      else
         Ios.Nav_Str8(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str8_Was_Set := Completed;
   end Set_Nav_Str8;

   procedure Set_Nav_Str9 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str9(Offset1d+1):=' ';
      else
         Ios.Nav_Str9(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str9_Was_Set := Completed;
   end Set_Nav_Str9;

   procedure Set_Nav_Str10 ( pData     : JPATS_IOS_Interface.Set_Value;
                                 Offset1d  : Integer;
                                 Offset2d  : Integer;
                                 Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Nav_Str10(Offset1d+1):=' ';
      else
         Ios.Nav_Str10(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Nav_Str10_Was_Set := Completed;
   end Set_Nav_Str10;

   procedure Set_Groundspeed( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Groundspeed := JPATS_IOS_Interface.Convert_To_Float( pData );
   end Set_Groundspeed;

   procedure Register_Ios_Variables  is
   begin

     JPATS_IOS_Interface.Register
       (Name => "EADI_Turn_Rate",
        Variable => IOS.EADI_Turn_Rate'Address
        );

     JPATS_IOS_Interface.Register
       (Name => "Selected_Heading",
        Variable => IOS.Selected_Heading'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Selected_Course",
        Variable => IOS.Selected_Course'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Selected_Course_Valid",
        Variable => IOS.Selected_Course_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Selected_Course_Dtk",
        Variable => IOS.Selected_Course_Dtk'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Test",
        Variable => IOS.Test'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Hsi_Mode",
        Variable => IOS.Hsi_Mode'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Adi_Mode",
        Variable => IOS.Adi_Mode'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Map_Mode",
        Variable => IOS.Map_Mode'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Range_Select",
        Variable => IOS.Range_Select'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Hsi_Heading",
        Variable => IOS.Hsi_Heading'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Source",
        Variable => IOS.Primary_Source'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Source_Deviation",
        Variable => IOS.Primary_Source_Deviation'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Source_Deviation_Valid",
        Variable => IOS.Primary_Source_Deviation_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Source_Deviation_RedX",
        Variable => IOS.Primary_Source_Deviation_RedX'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Source_Approach",
        Variable => IOS.Primary_Source_Approach'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Dme",
        Variable => IOS.Primary_Dme'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Dme_Status",
        Variable => IOS.Primary_Dme_Status'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Groundspeed",
        Variable => IOS.Primary_Groundspeed'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Groundspeed_Status",
        Variable => IOS.Primary_Groundspeed_Status'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Ttg",
        Variable => IOS.Primary_Ttg'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Ttg_status",
        Variable => IOS.Primary_Ttg_status'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Gps_Alert",
        Variable => IOS.Primary_Gps_Alert'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Primary_Dme_Freq",
        Variable => IOS.Primary_Dme_Freq'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing1",
        Variable => IOS.Bearing1'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing1_Valid",
        Variable => IOS.Bearing1_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing1_Source",
        Variable => IOS.Bearing1_Source'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing1_Distance",
        Variable => IOS.Bearing1_Distance'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing1_Distance_Valid",
        Variable => IOS.Bearing1_Distance_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing2",
        Variable => IOS.Bearing2'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing2_Valid",
        Variable => IOS.Bearing2_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing2_Source",
        Variable => IOS.Bearing2_Source'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing2_Distance",
        Variable => IOS.Bearing2_Distance'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Bearing2_Distance_Valid",
        Variable => IOS.Bearing2_Distance_Valid'address
        );

     JPATS_IOS_Interface.Register
       (Name => "To_From",
        Variable => IOS.To_From'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Glideslope_Scale_Status",
        Variable => IOS.Glideslope_Scale_Status'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Glideslope_Dev",
        Variable => IOS.Glideslope_Dev'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Gs_Rcvr_Fail",
        Variable => IOS.Gs_Rcvr_Fail'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Nav_Pwr_Fail",
        Variable => IOS.Nav_Pwr_Fail'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Pitch",
        Variable => IOS.Pitch'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Roll",
        Variable => IOS.Roll'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Marker_Beacon",
        Variable => IOS.Marker_Beacon'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Uhf_Frequency",
        Variable => IOS.Uhf_Frequency'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Uhf_Channel",
        Variable => IOS.Uhf_Channel'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Uhf_Channel_Active",
        Variable => IOS.Uhf_Channel_Active'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Uhf_Mode_Both",
        Variable => IOS.Uhf_Mode_Both'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Vhf_Frequency",
        Variable => IOS.Vhf_Frequency'address
        );

     JPATS_IOS_Interface.Register
       (Name => "Atc_Code",
        Variable => IOS.Atc_Code'address
        );
	
	 JPATS_IOS_Interface.Register
        (Name               => "Flight_ID",
         Var_Array          => IOS.Atc_Flight_ID'address,
         Set_Routine        => Set_Atc_Flight_ID'Access,
         Dimension_1_Length => 16
         );

     JPATS_IOS_Interface.Register
       (Name => "Nav_Frequency",
        Variable => IOS.Nav_Frequency'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Ils_Selected",
         Variable => IOS.Ils_Selected'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Dme_Frequency",
         Variable => IOS.Dme_Frequency'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Dme_Hold",
         Variable => IOS.Dme_Hold'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Backup_Frequency",
         Variable => IOS.Backup_Frequency'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Backup_Channel",
         Variable => IOS.Backup_Channel'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Repeater_Attitude_Fail",
         Variable => IOS.Repeater_Attitude_Fail'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Repeater_Heading_Fail",
         Variable => IOS.Repeater_Heading_Fail'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Attitude_Fail",
         Variable => IOS.Attitude_Fail'address,
         Set_Routine => Set_Attitude_Fail'access );

      JPATS_IOS_Interface.Register
        (Name => "Heading_Fail",
         Variable => IOS.Heading_Fail'address,
         Set_Routine => Set_Heading_Fail'access );

      JPATS_IOS_Interface.Register
        (Name => "Raim_Fail",
         Variable => IOS.Raim_Fail'address,
         Set_Routine => Set_Raim_Fail'access );
		 
      JPATS_IOS_Interface.Register
        (Name => "GPS_Fail",
         Variable => IOS.GPS_Fail'address,
         Set_Routine => Set_GPS_Fail'access );
		 
      JPATS_IOS_Interface.Register
        (Name => "Xpdr_Fail",
         Variable => IOS.Xpdr_Fail'address,
         Set_Routine => Set_Xpdr_Fail'access );

      JPATS_IOS_Interface.Register
        (Name => "Ahrs_Fail_Malf",
         Variable => IOS.Ahrs_Fail_Malf'address,
         Set_Routine => Set_Ahrs_Fail'access );

      JPATS_IOS_Interface.Register
        (Name => "Uhf_Backup_Mode",
         Variable => IOS.Uhf_Backup_Mode'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Ahrs_Slew",
         Variable => IOS.Ahrs_Slew'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Ahrs_Dg_Sw",
         Variable => IOS.Ahrs_Dg_Sw'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Sw_Off",
         Variable => IOS.Tas_Sw_Off'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Tas_Mode_Sw",
         Variable => IOS.Tas_Mode_Sw'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Display_Range",
         Variable => IOS.Tas_Display_Range'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Active_1",
         Variable => IOS.Tas_Intr_Active_1'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Active_2",
         Variable => IOS.Tas_Intr_Active_2'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Range_1",
         Variable => IOS.Tas_Intr_Range_1'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Range_2",
         Variable => IOS.Tas_Intr_Range_2'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Rel_Alt_1",
         Variable => IOS.Tas_Intr_Rel_Alt_1'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Rel_Alt_2",
         Variable => IOS.Tas_Intr_Rel_Alt_2'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Disp_Type_1",
         Variable => IOS.Tas_Intr_Disp_Type_1'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Disp_Type_2",
         Variable => IOS.Tas_Intr_Disp_Type_2'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Brg_1",
         Variable => IOS.Tas_Intr_Brg_1'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Intr_Brg_2",
         Variable => IOS.Tas_Intr_Brg_2'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Status",
         Variable => IOS.Tas_Status'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Vsi_Power",
         Variable => IOS.Vsi_Power'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Rate_Of_Climb",
         Variable => IOS.Rate_Of_Climb'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Page_Display_On_1",
         Variable => IOS.Threat_Page_Display_On(1)'address,
         Set_Routine => Set_Threat_Page_Display_On_1'access );

      JPATS_IOS_Interface.Register
        (Name => "Nacws_Page_Display_On_2",
         Variable => IOS.Threat_Page_Display_On(2)'address,
         Set_Routine => Set_Threat_Page_Display_On_2'access );

      JPATS_IOS_Interface.Register
        (Name => "Atc_Mode",
         Variable => IOS.Atc_Mode'address
         );

     JPATS_IOS_Interface.Register
       (Name => "Atc_Ident",
        Variable => IOS.Atc_Ident'address
        );

      JPATS_IOS_Interface.Register
        (Name => "Ios_Timer",
         Variable => IOS.Ios_Timer'Address,
         Set_Routine => Set_Ios_Timer'access );

      JPATS_IOS_Interface.Register
        (Name => "Waypoint_Active",
         Variable => IOS.Waypoint_Active'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Waypoint_Number",
         Variable => IOS.Waypoint_Number'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Vor_Map_Lat",
         Variable => IOS.Vor_Map_Lat'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Vor_Map_Lon",
         Variable => IOS.Vor_Map_Lon'address
         );

      JPATS_IOS_Interface.Register
        (Name => "GPS_OBS_Mode",
         Variable => IOS.GPS_OBS_Mode'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Magvar_from_GPS",
         Variable => IOS.Magvar_From_Gps'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Vor_Map_Station_Type",
         Variable => IOS.Vor_Map_Station_Type'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Ils_Backcourse",
         Variable => IOS.Ils_Backcourse'address
         );

      JPATS_IOS_Interface.Register
        (Name => "GPS_Annunciation",
         Variable => IOS.GPS_Annunciation'address
         );

      JPATS_IOS_Interface.Register
        (Name => "RMU_Power",
         Variable => IOS.RMU_Power'address
         );

      JPATS_IOS_Interface.Register
        (Name => "EADI_Power",
         Variable => IOS.EADI_Power'address
         );

      JPATS_IOS_Interface.Register
        (Name => "FHDG_Flag",
         Variable => IOS.FHDG_Flag'address
         );

      JPATS_IOS_Interface.Register
        (Name => "XTALK_Flag",
         Variable => IOS.XTALK_Flag'address
         );

      JPATS_IOS_Interface.Register
        (Name => "CP_Flag",
         Variable => IOS.CP_Flag'address
         );

      JPATS_IOS_Interface.Register
        (Name => "EHSI_Power",
         Variable => IOS.EHSI_Power'address
         );

      JPATS_IOS_Interface.Register
        (Name => "Nav_Float1",
         Variable => IOS.Nav_Float1'Address,
         Set_Routine => Set_Nav_Float1'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float2",
         Variable => IOS.Nav_Float2'Address,
         Set_Routine => Set_Nav_Float2'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float3",
         Variable => IOS.Nav_Float3'Address,
         Set_Routine => Set_Nav_Float3'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float4",
         Variable => IOS.Nav_Float4'Address,
         Set_Routine => Set_Nav_Float4'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float5",
         Variable => IOS.Nav_Float5'Address,
         Set_Routine => Set_Nav_Float5'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float6",
         Variable => IOS.Nav_Float6'Address,
         Set_Routine => Set_Nav_Float6'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float7",
         Variable => IOS.Nav_Float7'Address,
         Set_Routine => Set_Nav_Float7'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float8",
         Variable => IOS.Nav_Float8'Address,
         Set_Routine => Set_Nav_Float8'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float9",
         Variable => IOS.Nav_Float9'Address,
         Set_Routine => Set_Nav_Float9'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Float10",
         Variable => IOS.Nav_Float10'Address,
         Set_Routine => Set_Nav_Float10'access );

      JPATS_IOS_Interface.Register
        (Name => "Nav_Int1",
         Variable => IOS.Nav_Int1'Address,
         Set_Routine => Set_Nav_Int1'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int2",
         Variable => IOS.Nav_Int2'Address,
         Set_Routine => Set_Nav_Int2'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int3",
         Variable => IOS.Nav_Int3'Address,
         Set_Routine => Set_Nav_Int3'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int4",
         Variable => IOS.Nav_Int4'Address,
         Set_Routine => Set_Nav_Int4'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int5",
         Variable => IOS.Nav_Int5'Address,
         Set_Routine => Set_Nav_Int5'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int6",
         Variable => IOS.Nav_Int6'Address,
         Set_Routine => Set_Nav_Int6'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int7",
         Variable => IOS.Nav_Int7'Address,
         Set_Routine => Set_Nav_Int7'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int8",
         Variable => IOS.Nav_Int8'Address,
         Set_Routine => Set_Nav_Int8'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int9",
         Variable => IOS.Nav_Int9'Address,
         Set_Routine => Set_Nav_Int9'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Int10",
         Variable => IOS.Nav_Int10'Address,
         Set_Routine => Set_Nav_Int10'access );

      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool1",
         Variable => IOS.Nav_Bool1'Address,
         Set_Routine => Set_Nav_Bool1'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool2",
         Variable => IOS.Nav_Bool2'Address,
         Set_Routine => Set_Nav_Bool2'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool3",
         Variable => IOS.Nav_Bool3'Address,
         Set_Routine => Set_Nav_Bool3'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool4",
         Variable => IOS.Nav_Bool4'Address,
         Set_Routine => Set_Nav_Bool4'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool5",
         Variable => IOS.Nav_Bool5'Address,
         Set_Routine => Set_Nav_Bool5'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool6",
         Variable => IOS.Nav_Bool6'Address,
         Set_Routine => Set_Nav_Bool6'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool7",
         Variable => IOS.Nav_Bool7'Address,
         Set_Routine => Set_Nav_Bool7'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool8",
         Variable => IOS.Nav_Bool8'Address,
         Set_Routine => Set_Nav_Bool8'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool9",
         Variable => IOS.Nav_Bool9'Address,
         Set_Routine => Set_Nav_Bool9'access );
      JPATS_IOS_Interface.Register
        (Name => "Nav_Bool10",
         Variable => IOS.Nav_Bool10'Address,
         Set_Routine => Set_Nav_Bool10'access );

      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str1",
         Var_Array          => IOS.Nav_Str1'address,
         Set_Routine        => Set_Nav_Str1'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str2",
         Var_Array          => IOS.Nav_Str2'address,
         Set_Routine        => Set_Nav_Str2'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str3",
         Var_Array          => IOS.Nav_Str3'address,
         Set_Routine        => Set_Nav_Str3'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str4",
         Var_Array          => IOS.Nav_Str4'address,
         Set_Routine        => Set_Nav_Str4'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str5",
         Var_Array          => IOS.Nav_Str5'address,
         Set_Routine        => Set_Nav_Str5'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str6",
         Var_Array          => IOS.Nav_Str6'address,
         Set_Routine        => Set_Nav_Str6'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str7",
         Var_Array          => IOS.Nav_Str7'address,
         Set_Routine        => Set_Nav_Str7'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str8",
         Var_Array          => IOS.Nav_Str8'address,
         Set_Routine        => Set_Nav_Str8'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str9",
         Var_Array          => IOS.Nav_Str9'address,
         Set_Routine        => Set_Nav_Str9'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Nav_Str10",
         Var_Array          => IOS.Nav_Str10'address,
         Set_Routine        => Set_Nav_Str10'Access,
         Dimension_1_Length => 5
         );
      JPATS_IOS_Interface.Register
        (Name               => "Groundspeed",
         Variable           => IOS.Groundspeed'Address,
         Set_Routine        => Set_Groundspeed'Access
         );

   end Register_Ios_Variables;


end JPATS_Avionics.Ios_If;
