with stethoscope;

separate (JPATS_Avionics.Controller)


procedure Scope is

begin

   stethoscope.register_signal
     ( Name              => "avionics/Gyro_Mode",
       Units             => "Gyro_Mode",
       object_address => Gyro_Mode'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Slew_Direction",
       Units             => "Slew_Direction",
       object_address => Slew_Direction'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Body_Axis_Velocity.X",
       Units             => "fps",
       object_address => Body_Axis_Velocity.X'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Body_Axis_Velocity.Y",
       Units             => "fps",
       object_address => Body_Axis_Velocity.Y'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Body_Axis_Velocity.Z",
       Units             => "fps",
       object_address => Body_Axis_Velocity.Z'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Earth_Axis_Velocity.X",
       Units             => "fps",
       object_address => Earth_Axis_Velocity.X'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Earth_Axis_Velocity.Y",
       Units             => "fps",
       object_address => Earth_Axis_Velocity.Y'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Earth_Axis_Velocity.Z",
       Units             => "fps",
       object_address => Earth_Axis_Velocity.Z'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Position.Latitude",
       Units             => "Degrees",
       object_address => Position.Latitude'address,
       Value_Type        => "double",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Position.Longitude",
       Units             => "Degrees",
       object_address => Position.Longitude'address,
       Value_Type        => "double",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Position.Altitude",
       Units             => "Feet",
       object_address => Position.Altitude'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Magnetic_Variation",
       Units             => "Degrees",
       object_address => Magnetic_Variation'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/True_Heading",
       Units             => "Degrees",
       object_address => True_Heading'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Aircraft_Pitch",
       Units             => "Degrees",
       object_address => Aircraft_Pitch'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Aircraft_Roll",
       Units             => "Degrees",
       object_address => Aircraft_Roll'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Rate.X",
       Units             => "Angular_Rate",
       object_address => Angular_Rate.X'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Rate.Y",
       Units             => "Angular_Rate",
       object_address => Angular_Rate.Y'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Rate.Z",
       Units             => "Angular_Rate",
       object_address => Angular_Rate.Z'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Acceleration.Roll",
       Units             => "Angular_Acceleration",
       object_address => Angular_Acceleration.Roll'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Acceleration.Pitch",
       Units             => "Angular_Acceleration",
       object_address => Angular_Acceleration.Pitch'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Angular_Acceleration.Yaw",
       Units             => "Angular_Acceleration",
       object_address => Angular_Acceleration.Yaw'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Audio_Relay",
       Units             => "On-Off",
       object_address => Audio_Relay'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ios_Vhf_Selected",
       Units             => "On-Off",
       object_address => Ios_Vhf_Selected'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ios_Vhf_Key",
       Units             => "On-Off",
       object_address => Ios_Vhf_Key'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ios_Uhf_Key",
       Units             => "On-Off",
       object_address => Ios_Uhf_Key'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ios_Inph_Key",
       Units             => "On-Off",
       object_address => Ios_Inph_Key'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Hdg_Knob",
       Units             => "Clicks",
       object_address => Hdg_Knob'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Hdg_Knob_N1",
       Units             => "Clicks",
       object_address => Hdg_Knob_N1'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Hdg_Knob_Delta",
       Units             => "Clicks",
       object_address => Hdg_Knob_Delta'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Crs_Knob",
       Units             => "Clicks",
       object_address => Crs_Knob'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Crs_Knob_N1",
       Units             => "Clicks",
       object_address => Crs_Knob_N1'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Crs_Knob_Delta",
       Units             => "Clicks",
       object_address => Crs_Knob_Delta'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Unpack_Word.Label",
       Units             => "label number",
       object_address => Unpack_Word.Label'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Unpack_Word.Word_Type",
       Units             => "initial,intermediate,final,control",
       object_address => Unpack_Word.Word_Type'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Counter_N1",
       Units             => "count",
       object_address => Counter_N1'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/New_Message",
       Units             => "new",
       object_address => New_Message'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Label",
       Units             => "Label No.",
       object_address => Label'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Backup_Uhf_Freq",
       Units             => "UHF Frequency",
       object_address => Io.Backup_Uhf_Freq'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ack_Received",
       Units             => "Ack_Received",
       object_address => Ack_Received'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Waiting_For_Ack",
       Units             => "Waiting_For_Ack",
       object_address => Waiting_For_Ack'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Xmit_Radio_Models",
       Units             => "Xmit_Radio_Models",
       object_address => Xmit_Radio_Models'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Xmit_Initialization_Data",
       Units             => "Xmit_Initialization_Data",
       object_address => Xmit_Initialization_Data'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude.Pitch",
       Units             => "degrees pitch",
       object_address => Ahrs_Attitude.Pitch'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude.Roll",
       Units             => "degrees roll",
       object_address => Ahrs_Attitude.Roll'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude.Heading",
       Units             => "degrees heading",
       object_address => Ahrs_Attitude.Heading'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude_Rate.X",
       Units             => "Ahrs_Attitude_Rate--X",
       object_address => Ahrs_Attitude_Rate.X'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude_Rate.Y",
       Units             => "Ahrs_Attitude_Rate--Y",
       object_address => Ahrs_Attitude_Rate.Y'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Attitude_Rate.Z",
       Units             => "Ahrs_Attitude_Rate--Z",
       object_address => Ahrs_Attitude_Rate.Z'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Discretes.Align_Mode",
       Units             => "aligning, ready",
       object_address => Ahrs_Discretes.Align_Mode'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Discretes.Normal_Mode",
       Units             => "Normal_Mode",
       object_address => Ahrs_Discretes.Normal_Mode'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Discretes.Heading_Mode",
       Units             => "mag,dg",
       object_address => Ahrs_Discretes.Heading_Mode'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Discretes.Attitude_Valid",
       Units             => "Attitude_Valid",
       object_address => Ahrs_Discretes.Attitude_Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Discretes.Ahru_Valid",
       Units             => "Ahru_Valid",
       object_address => Ahrs_Discretes.Ahru_Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Dsc_Ssm",
       Units             => "Normal,No_Computed_Data,Functional_Test,Failure",
       object_address => Ahrs_Dsc_Ssm'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Ahrs_Bnr_Ssm",
       Units             => "Failure,No_Computed_Data,Functional_Test,Normal",
       object_address => Ahrs_Bnr_Ssm'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Horizontal_Position.Valid",
       Units             => "true",
       object_address => Gps_Horizontal_Position.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Horizontal_Position.Latitude",
       Units             => "degrees",
       object_address => Gps_Horizontal_Position.Latitude'address,
       Value_Type        => "double",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Horizontal_Position.Longitude",
       Units             => "degrees",
       object_address => Gps_Horizontal_Position.Longitude'address,
       Value_Type        => "double",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Vertical_Position.Valid",
       Units             => "true",
       object_address => Gps_Vertical_Position.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Vertical_Position.Altitude",
       Units             => "feet",
       object_address => Gps_Vertical_Position.Altitude'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Groundspeed_Track_Angle.Valid",
       Units             => "true",
       object_address => Gps_Groundspeed_Track_Angle.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Groundspeed_Track_Angle.Groundspeed",
       Units             => "knots",
       object_address => Gps_Groundspeed_Track_Angle.Groundspeed'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Groundspeed_Track_Angle.Track_Angle",
       Units             => "degrees",
       object_address => Gps_Groundspeed_Track_Angle.Track_Angle'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Velocity.Valid",
       Units             => "true",
       object_address => Gps_Velocity.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Velocity.East_Velocity",
       Units             => "fps",
       object_address => Gps_Velocity.East_Velocity'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Velocity.North_Velocity",
       Units             => "fps",
       object_address => Gps_Velocity.North_Velocity'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Velocity.Up_Velocity",
       Units             => "fps",
       object_address => Gps_Velocity.Up_Velocity'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Valid",
       Units             => "true",
       object_address => Gps_Date_Time.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Year",
       Units             => "Year",
       object_address => Gps_Date_Time.Year'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Month",
       Units             => "Month",
       object_address => Gps_Date_Time.Month'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Day",
       Units             => "Day",
       object_address => Gps_Date_Time.Day'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Hour",
       Units             => "Hour",
       object_address => Gps_Date_Time.Hour'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Minute",
       Units             => "Minute",
       object_address => Gps_Date_Time.Minute'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Date_Time.Second",
       Units             => "Second",
       object_address => Gps_Date_Time.Second'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Frequency_Estimate.Valid",
       Units             => "true",
       object_address => Gps_Frequency_Estimate.Valid'address,
       Value_Type        => "uchar",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              =>
         "avionics/Gps_Frequency_Estimate.Frequency_Estimate",
       Units             => "freq",
       object_address => Gps_Frequency_Estimate.Frequency_Estimate'address,
       Value_Type        => "float",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Satellite_Status(1).Sat_Id",
       Units             => "id",
       object_address => Gps_Satellite_Status(1).Sat_Id'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     ( Name              => "avionics/Gps_Satellite_Status(1).Health",
       Units             => "No_Data,Bad,Weak,Good,Deselected",
       object_address => Gps_Satellite_Status(1).Health'address,
       Value_Type        => "int",
       Scope_Index       => 0 );
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.State",
      Units             => "enumerated",
      object_address => Gps_State.State'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Integrity_State",
      Units             => "true-false",
      object_address => Gps_State.Integrity_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Masked_Integrity_Warning",
      Units             => "true-false",
      object_address => Gps_State.Masked_Integrity_Warning'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Bad_Coverage",
      Units             => "true_false",
      object_address => Gps_State.Bad_Coverage'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Altitude_Aiding_In_Use",
      Units             => "true_false",
      object_address => Gps_State.Altitude_Aiding_In_Use'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Nav_Mode",
      Units             => "enumerated",
      object_address => Gps_State.Nav_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_State.Error_Status",
      Units             => "true-false",
      object_address => Gps_State.Error_Status'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_Subsytem_Software_Version",
      Units             => "integer",
      object_address => Gps_Subsytem_Software_Version'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_Satellite_Azimuth(1)",
      Units             => "degrees",
      object_address => Gps_Satellite_Azimuth(1)'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_Dsc_Ssm",
      Units             => "enumerated",
      object_address => Gps_Dsc_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Gps_Bnr_Ssm",
      Units             => "enumerated",
      object_address => Gps_Bnr_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Cnt_Pnl_Ssm",
      Units             => "enumerated",
      object_address => Cnt_Pnl_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Xtalk_300.Nav_Source",
      Units             => "Vor_With,Vor_Without,Gps_With,Gps_Without",
      object_address => Discrete_Xtalk_300.Nav_Source'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Xtalk_300.Bearing_1_Source",
      Units             => "Declutter,Vor,Gps",
      object_address => Discrete_Xtalk_300.Bearing_1_Source'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Xtalk_300.Bearing_2_Source",
      Units             => "Declutter,Vor,Gps",
      object_address => Discrete_Xtalk_300.Bearing_2_Source'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Xtalk_301.Map_Mode",
      Units             => "enumerated",
      object_address => Discrete_Xtalk_301.Map_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Xtalk_301.Display_Range",
      Units             => "5,10,20,40,80,160,240,320,1000",
      object_address => Discrete_Xtalk_301.Display_Range'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Cnt_Pnl_270.Test_Key_State",
      Units             => "t-f",
      object_address => Discrete_Tx_Cnt_Pnl_270.Test_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Cnt_Pnl_270.Hsi_Key_State",
      Units             => "t-f",
      object_address => Discrete_Tx_Cnt_Pnl_270.Hsi_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Cnt_Pnl_270.Arc_Key_State",
      Units             => "t-f",
      object_address => Discrete_Tx_Cnt_Pnl_270.Arc_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Cnt_Pnl_270.Nav_Key_State",
      Units             => "t-f",
      object_address => Discrete_Tx_Cnt_Pnl_270.Nav_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Range_Incr_Key_State",
      Units             => "t-f",
      object_address =>Discrete_Tx_Cnt_Pnl_270.Range_Incr_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Range_Decr_Key_State",
      Units             => "t-f",
      object_address =>
        Discrete_Tx_Cnt_Pnl_270.Range_Decr_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Double_Rmi_Key_State",
      Units             => "t-f",
      object_address =>Discrete_Tx_Cnt_Pnl_270.Double_Rmi_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Single_Rmi_Key_State",
      Units             => "t-f",
      object_address =>Discrete_Tx_Cnt_Pnl_270.Single_Rmi_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Cnt_Pnl_270.Map_Key_State",
      Units             => "t-f",
      object_address => Discrete_Tx_Cnt_Pnl_270.Map_Key_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Crs_Pull_Switch_State",
      Units             => "t-f",
      object_address =>
        Discrete_Tx_Cnt_Pnl_270.Crs_Pull_Switch_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Tx_Cnt_Pnl_270.Hdg_Pull_Switch_State",
      Units             => "t-f",
      object_address =>
        Discrete_Tx_Cnt_Pnl_270.Hdg_Pull_Switch_State'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
    (Name              =>
       "avionics/Discrete_Tx_Cnt_Pnl_271.Heading_Knob_Counts",
      Units             => "clicks",
      object_address => Discrete_Tx_Cnt_Pnl_271.Heading_Knob_Counts'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
    (Name              =>
       "avionics/Discrete_Tx_Cnt_Pnl_271.Course_Knob_Counts",
      Units             => "clicks",
      object_address => Discrete_Tx_Cnt_Pnl_271.Course_Knob_Counts'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
    (Name              =>
       "avionics/Discrete_Tx_Cnt_Pnl_271.Course_Knob_Direction",
      Units             => "Positive,Negative",
      object_address =>
        Discrete_Tx_Cnt_Pnl_271.Course_Knob_Direction'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
    (Name              =>
       "avionics/Discrete_Tx_Cnt_Pnl_271.Heading_Knob_Direction",
      Units             => "Positive,Negative",
      object_address =>
        Discrete_Tx_Cnt_Pnl_271.Heading_Knob_Direction'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Ahrs_270.Align_Mode",
      Units             => "Aligning,Ready",
      object_address => Discrete_Tx_Ahrs_270.Align_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Ahrs_270.Normal_Mode",
      Units             => "t-f",
      object_address => Discrete_Tx_Ahrs_270.Normal_Mode'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Ahrs_270.Heading_Dg_Mode",
      Units             => "Mag,Dg",
      object_address => Discrete_Tx_Ahrs_270.Heading_Dg_Mode'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Ahrs_270.Attitude_Invalid",
      Units             => "t-f",
      object_address => Discrete_Tx_Ahrs_270.Attitude_Invalid'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/Discrete_Tx_Ahrs_270.Ahru_Fault",
      Units             => "t-f",
      object_address => Discrete_Tx_Ahrs_270.Ahru_Fault'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              =>
        "avionics/Discrete_Rx_Gps_074.Total_Number_Of_Records",
      Units             => "# of records",
      object_address => Discrete_Rx_Gps_074.Total_Number_Of_Records'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Discrete_Rx_Gps_074.Prior_Record_Change",
      Units             => "t-f",
      object_address => Discrete_Rx_Gps_074.Prior_Record_Change'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Rx_Crosstalk_100_Ssm",
      Units             => "ssm",
      object_address => Rx_Crosstalk_100_Ssm'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Threat_Output_377",
      Units             => "int",
      object_address => Threat_Output_377'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Threat_Output_013",
      Units             => "int",
      object_address => Threat_Output_013'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Threat_Output_Rts_357",
      Units             => "int",
      object_address => Threat_Output_Rts_357'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Threat_Output_Eot_357",
      Units             => "int",
      object_address => Threat_Output_Eot_357'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_Activity",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Activity_Counter'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_Word_Count",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Word_Count'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_377",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Data(1)'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_013",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Data(2)'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_RTS_357",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Data(9)'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/FDK_TAS_A429_EOT_357",
      Units             => "int",
      object_address => Io.Tas_A429_Tx.Data(10)'address,
      Value_Type        => "int",
      Scope_Index       => 0);
   stethoscope.register_Signal
     (Name              => "avionics/Force_Map",
      Units             => "on-off",
      object_address => Force_Map'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);

end;
