-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-- DATA SOURCE:  USAF TO 1T-6A-1
--               Raytheon Wiring Diagrams-Avionics and Electrical Systems
--               Flight Safety Simulation Models
--               FDP 500 Interface Control Document
--               Interface Specification for RMS 55
--
--
-------------------------------------------------------------------------------

separate (JPATS_Avionics.Controller)

procedure Register_Io_Variables is
begin
   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_SW_OFF",
      A_Direction     => Iot.Input,
      An_Address      => Io.Tas_Sw_Off'Address,
      A_Size          => Io.Tas_Sw_Off'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_SW_TEST",
      A_Direction     => Iot.Input,
      An_Address      => Io.Tas_Test_Sw'Address,
      A_Size          => Io.Tas_Test_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_SW_STBY",
      A_Direction     => Iot.Input,
      An_Address      => Io.Tas_Stby_Sw'Address,
      A_Size          => Io.Tas_Stby_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_VVI_DISPLAY_VALID",
      A_Direction     => Iot.Input,
      An_Address      => Io.Ta_Vsi_Display_Valid'Address,
      A_Size          => Io.Ta_Vsi_Display_Valid'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_LT",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tas_Lt'Address,
      A_Size          => Io.Tas_Lt'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AHRS_CCW_SW",
      A_Direction     => Iot.Input,
      An_Address      => Io.Ahrs_Ccw_Sw'Address,
      A_Size          => Io.Ahrs_Ccw_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AHRS_METER",
      A_Direction     => Iot.Output,
      An_Address      => Io.Ahrs_Meter'Address,
      A_Size          => Io.Ahrs_Meter'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AHRS_DG_SW",
      A_Direction     => Iot.Input,
      An_Address      => Io.Ahrs_Dg_Sw'Address,
      A_Size          => Io.Ahrs_Dg_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AHRS_CW_SW",
      A_Direction     => Iot.Input,
      An_Address      => Io.Ahrs_Cw_Sw'Address,
      A_Size          => Io.Ahrs_Cw_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AHRS_TEST_SW",
      A_Direction     => Iot.Input,
      An_Address      => Io.Ahrs_Test_Sw'Address,
      A_Size          => Io.Ahrs_Test_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "CLOCK_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Clock_Pwr'Address,
      A_Size          => Io.Clock_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_DN_RNG",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Dn_Rng'Address,
      A_Size          => Io.Efis_Dn_Rng'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "ADI_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Adi_28vdc_Pwr'Address,
      A_Size          => Io.Adi_28vdc_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_UP_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Up_2'Address,
      A_Size          => Io.Efis_Up_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs'Address,
      A_Size          => Io.Efis_Crs'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_TST",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Tst'Address,
      A_Size          => Io.Efis_Tst'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_UP_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Up_1'Address,
      A_Size          => Io.Efis_Up_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_ARC",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Arc'Address,
      A_Size          => Io.Efis_Arc'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg'Address,
      A_Size          => Io.Efis_Hdg'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_MAP",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Map'Address,
      A_Size          => Io.Efis_Map'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_UP_RNG",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Up_Rng'Address,
      A_Size          => Io.Efis_Up_Rng'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HSI",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hsi'Address,
      A_Size          => Io.Efis_Hsi'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_NAV_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Nav'Address,
      A_Size          => Io.Efis_Nav'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_0",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_0'Address,
      A_Size          => Io.Efis_Hdg_0'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_1'Address,
      A_Size          => Io.Efis_Hdg_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_2'Address,
      A_Size          => Io.Efis_Hdg_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_3",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_3'Address,
      A_Size          => Io.Efis_Hdg_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_4",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_4'Address,
      A_Size          => Io.Efis_Hdg_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_5",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_5'Address,
      A_Size          => Io.Efis_Hdg_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_6",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_6'Address,
      A_Size          => Io.Efis_Hdg_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_HDG_7",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Hdg_7'Address,
      A_Size          => Io.Efis_Hdg_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_0",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_0'Address,
      A_Size          => Io.Efis_Crs_0'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_1'Address,
      A_Size          => Io.Efis_Crs_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_2'Address,
      A_Size          => Io.Efis_Crs_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_3",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_3'Address,
      A_Size          => Io.Efis_Crs_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_4",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_4'Address,
      A_Size          => Io.Efis_Crs_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_5",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_5'Address,
      A_Size          => Io.Efis_Crs_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_6",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_6'Address,
      A_Size          => Io.Efis_Crs_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "EFIS_CRS_7",
      A_Direction     => Iot.Input,
      An_Address      => Io.Efis_Crs_7'Address,
      A_Size          => Io.Efis_Crs_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_ahrs_l270",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Ahrs_270'Address,
      A_Size          => Io.Tx_Ahrs_270'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_ahrs_l320",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Ahrs_320'Address,
      A_Size          => Io.Tx_Ahrs_320'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_ahrs_l324",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Ahrs_324'Address,
      A_Size          => Io.Tx_Ahrs_324'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_ahrs_l325",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Ahrs_325'Address,
      A_Size          => Io.Tx_Ahrs_325'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_ahrs_l330",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Ahrs_330'Address,
      A_Size          => Io.Tx_Ahrs_330'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "HSI_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Hsi_28vdc_Pwr'Address,
      A_Size          => Io.Hsi_28vdc_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_cnt_pnl_l270",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Cnt_Pnl_270'Address,
      A_Size          => Io.Tx_Cnt_Pnl_270'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_cnt_pnl_l271",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Cnt_Pnl_271'Address,
      A_Size          => Io.Tx_Cnt_Pnl_271'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l100",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_100'Address,
      A_Size          => Io.Rx_Crosstalk_100'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l101",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_101'Address,
      A_Size          => Io.Rx_Crosstalk_101'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l300",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_300'Address,
      A_Size          => Io.Rx_Crosstalk_300'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l301",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_301'Address,
      A_Size          => Io.Rx_Crosstalk_301'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l303",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_303'Address,
      A_Size          => Io.Rx_Crosstalk_303'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l305",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_305'Address,
      A_Size          => Io.Rx_Crosstalk_305'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_adi_xtalk_l371",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Crosstalk_371'Address,
      A_Size          => Io.Rx_Crosstalk_371'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_hsi_xtalk_l100",
      A_Direction     => Iot.Input,
      An_Address      => Io.A429_Rx_Fwd_Hsi_Xtalk_100'Address,
      A_Size          => Io.A429_Rx_Fwd_Hsi_Xtalk_100'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_hsi_xtalk_l101",
      A_Direction     => Iot.Input,
      An_Address      => Io.A429_Rx_Fwd_Hsi_Xtalk_101'Address,
      A_Size          => Io.A429_Rx_Fwd_Hsi_Xtalk_101'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_hsi_xtalk_l300",
      A_Direction     => Iot.Input,
      An_Address      => Io.A429_Rx_Fwd_Hsi_Xtalk_300'Address,
      A_Size          => Io.A429_Rx_Fwd_Hsi_Xtalk_300'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_hsi_xtalk_l301",
      A_Direction     => Iot.Input,
      An_Address      => Io.A429_Rx_Fwd_Hsi_Xtalk_301'Address,
      A_Size          => Io.A429_Rx_Fwd_Hsi_Xtalk_301'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_fwd_hsi_xtalk_l303",
      A_Direction     => Iot.Input,
      An_Address      => Io.A429_Rx_Fwd_Hsi_Xtalk_305'Address,
      A_Size          => Io.A429_Rx_Fwd_Hsi_Xtalk_305'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l100",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_100'Address,
      A_Size          => Io.Tx_Crosstalk_100'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l101",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_101'Address,
      A_Size          => Io.Tx_Crosstalk_101'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l300",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_300'Address,
      A_Size          => Io.Tx_Crosstalk_300'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l301",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_301'Address,
      A_Size          => Io.Tx_Crosstalk_301'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l303",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_303'Address,
      A_Size          => Io.Tx_Crosstalk_303'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l305",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_305'Address,
      A_Size          => Io.Tx_Crosstalk_305'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_adi_xtalk_l371",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Crosstalk_371'Address,
      A_Size          => Io.Tx_Crosstalk_371'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l100",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_100'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_100'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l101",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_101'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_101'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l300",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_300'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_300'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l301",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_301'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_301'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l303",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_303'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_303'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l305",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_305'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_305'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_aft_hsi_xtalk_l371",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Hsi_Crosstalk_371'Address,
      A_Size          => Io.Tx_Hsi_Crosstalk_371'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_074",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_074'Address,
--      A_Size          => Io.Rx_Gps_074'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l075",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_075'Address,
      A_Size          => Io.Rx_Gps_075'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l100",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_100'Address,
      A_Size          => Io.Rx_Gps_100'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_113",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_113'Address,
--      A_Size          => Io.Rx_Gps_113'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l115",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_115'Address,
      A_Size          => Io.Rx_Gps_115'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l116",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_116'Address,
      A_Size          => Io.Rx_Gps_116'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l147",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_147'Address,
      A_Size          => Io.Rx_Gps_147'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l150",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_150'Address,
      A_Size          => Io.Rx_Gps_150'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l251",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_251'Address,
      A_Size          => Io.Rx_Gps_251'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l252",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_252'Address,
      A_Size          => Io.Rx_Gps_252'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l261",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_261'Address,
      A_Size          => Io.Rx_Gps_261'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l275",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_275'Address,
      A_Size          => Io.Rx_Gps_275'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_300",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_300'Address,
--      A_Size          => Io.Rx_Gps_300'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_303",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_303'Address,
--      A_Size          => Io.Rx_Gps_303'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--    (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_304",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_304'Address,
--      A_Size          => Io.Rx_Gps_304'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_305",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_305'Address,
--      A_Size          => Io.Rx_Gps_305'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_306",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_306'Address,
--      A_Size          => Io.Rx_Gps_306'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "A429_RX_GPS_307",
--      A_Direction     => Iot.Input,
--      An_Address      => Io.Rx_Gps_307'Address,
--      A_Size          => Io.Rx_Gps_307'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l310",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_310'Address,
      A_Size          => Io.Rx_Gps_310'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l311",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_311'Address,
      A_Size          => Io.Rx_Gps_311'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l312",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_312'Address,
      A_Size          => Io.Rx_Gps_312'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l314",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_314'Address,
      A_Size          => Io.Rx_Gps_314'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_l326",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_326'Address,
      A_Size          => Io.Rx_Gps_326'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "GPS_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Gps_28vdc_Pwr'Address,
      A_Size          => Io.Gps_28vdc_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "APPROACH_MODE_SEL",
      A_Direction     => Iot.Input,
      An_Address      => Io.Approach_Mode_Sel'Address,
      A_Size          => Io.Approach_Mode_Sel'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt09_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_9_Nav_Mode'Address,
      A_Size          => Io.Rx_Gps_9_Nav_Mode'Size);

   -- Jpats_Io.Map_To_Icd_Mnemonic
   --   (An_Interface    => Jiot.Flight_Deck,
   --    An_Icd_Mnemonic => "RS422_RX_GPS_10_REQUEST_FLAG_0",
   --    A_Direction     => Iot.Input,
   --    An_Address      => Io.Rx_Gps_10_Request_Flag_0'Address,
   --    A_Size          => Io.Rx_Gps_10_Request_Flag_0'Size);

   -- Jpats_Io.Map_To_Icd_Mnemonic
   --   (An_Interface    => Jiot.Flight_Deck,
   --    An_Icd_Mnemonic => "RS422_RX_GPS_10_REQUEST_FLAG_1",
   --    A_Direction     => Iot.Input,
   --    An_Address      => Io.Rx_Gps_10_Request_Flag_1'Address,
   --    A_Size          => Io.Rx_Gps_10_Request_Flag_1'Size);

   -- Jpats_Io.Map_To_Icd_Mnemonic
   --   (An_Interface    => Jiot.Flight_Deck,
   --    An_Icd_Mnemonic => "RS422_RX_GPS_10_REQUEST_FLAG_2",
   --    A_Direction     => Iot.Input,
   --    An_Address      => Io.Rx_Gps_10_Request_Flag_2'Address,
   --    A_Size          => Io.Rx_Gps_10_Request_Flag_2'Size);

   -- Jpats_Io.Map_To_Icd_Mnemonic
   --   (An_Interface    => Jiot.Flight_Deck,
   --    An_Icd_Mnemonic => "RS422_RX_GPS_10_REQUEST_FLAG_3",
   --    A_Direction     => Iot.Input,
   --    An_Address      => Io.Rx_Gps_10_Request_Flag_3'Address,
   --    A_Size          => Io.Rx_Gps_10_Request_Flag_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Latitude'Address,
      A_Size          => Io.Rx_Gps_11_Latitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Longitude'Address,
      A_Size          => Io.Rx_Gps_11_Longitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_3_0",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Test_Mode'Address,
      A_Size          => Io.Rx_Gps_11_Test_Mode'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_3_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Search_The_Sky'Address,
      A_Size          => Io.Rx_Gps_11_Search_The_Sky'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_3_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Year'Address,
      A_Size          => Io.Rx_Gps_11_Year'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_3_3",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Month'Address,
      A_Size          => Io.Rx_Gps_11_Month'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_4_0",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Day'Address,
      A_Size          => Io.Rx_Gps_11_Day'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_4_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Hour'Address,
      A_Size          => Io.Rx_Gps_11_Hour'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_4_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Minute'Address,
      A_Size          => Io.Rx_Gps_11_Minute'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_5",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Seconds'Address,
      A_Size          => Io.Rx_Gps_11_Seconds'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_6",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Estimated_Groundspeed'Address,
      A_Size          => Io.Rx_Gps_11_Estimated_Groundspeed'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_7",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_True_Airspeed'Address,
      A_Size          => Io.Rx_Gps_11_True_Airspeed'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_8",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_True_Heading'Address,
      A_Size          => Io.Rx_Gps_11_True_Heading'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0b_9",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_11_Track_Angle'Address,
      A_Size          => Io.Rx_Gps_11_Track_Angle'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0c_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_12_Altitude_Type'Address,
      A_Size          => Io.Rx_Gps_12_Altitude_Type'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt0c_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_12_Altitude'Address,
      A_Size          => Io.Rx_Gps_12_Altitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt11_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_17_Deselect_Select'Address,
      A_Size          => Io.Rx_Gps_17_Deselect_Select'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt14_1",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_20_Latitude'Address,
      A_Size          => Io.Rx_Gps_20_Latitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt14_2",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_20_Longitude'Address,
      A_Size          => Io.Rx_Gps_20_Longitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt14_3",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_20_Altitude'Address,
      A_Size          => Io.Rx_Gps_20_Altitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt14_4",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_20_Delta_Seconds'Address,
      A_Size          => Io.Rx_Gps_20_Delta_Seconds'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_serin_gps_data_pkt14_5",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rx_Gps_20_Nav_Mode'Address,
      A_Size          => Io.Rx_Gps_20_Nav_Mode'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt15_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_21_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_21_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt15_02",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_21_Latitude'Address,
      A_Size          => Io.Tx_Gps_21_Latitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt15_03",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_21_Longitude'Address,
      A_Size          => Io.Tx_Gps_21_Longitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt15_04",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_21_Horizontal_Position_Error'Address,
      A_Size          => Io.Tx_Gps_21_Horizontal_Position_Error'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt16_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_22_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_22_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt16_02",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_22_Altitude'Address,
      A_Size          => Io.Tx_Gps_22_Altitude'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt16_03",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_22_Vertical_Position_Error'Address,
      A_Size          => Io.Tx_Gps_22_Vertical_Position_Error'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt17_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_23_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_23_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt17_02",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_23_Ground_Speed'Address,
      A_Size          => Io.Tx_Gps_23_Ground_Speed'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt17_03",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_23_Track_Angle'Address,
      A_Size          => Io.Tx_Gps_23_Track_Angle'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt18_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_24_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_24_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt18_02",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_24_East_Velocity'Address,
      A_Size          => Io.Tx_Gps_24_East_Velocity'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt18_03",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_24_North_Velocity'Address,
      A_Size          => Io.Tx_Gps_24_North_Velocity'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt18_04",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_24_Up_Velocity'Address,
      A_Size          => Io.Tx_Gps_24_Up_Velocity'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_01_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_25_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_01_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Year'Address,
      A_Size          => Io.Tx_Gps_25_Year'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_01_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Month'Address,
      A_Size          => Io.Tx_Gps_25_Month'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_01_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Day'Address,
      A_Size          => Io.Tx_Gps_25_Day'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_02_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Hour'Address,
      A_Size          => Io.Tx_Gps_25_Hour'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_02_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Minute'Address,
      A_Size          => Io.Tx_Gps_25_Minute'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt19_02_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_25_Second'Address,
      A_Size          => Io.Tx_Gps_25_Second'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1a_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_26_Valid_Flag'Address,
      A_Size          => Io.Tx_Gps_26_Valid_Flag'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1a_02",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_26_Frequency_Estimate'Address,
      A_Size          => Io.Tx_Gps_26_Frequency_Estimate'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_01_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_1'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_01_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_1'Address,
      A_Size          => Io.Tx_Gps_27_Health_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_01_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_1'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_01_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_1'Address,
      A_Size          => Io.Tx_Gps_27_Snr_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_02_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_1'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_02_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_2'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_02_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_2'Address,
      A_Size          => Io.Tx_Gps_27_Health_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_02_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_2'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_03_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_2'Address,
      A_Size          => Io.Tx_Gps_27_Snr_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_03_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_2'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_03_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_3'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_03_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_3'Address,
      A_Size          => Io.Tx_Gps_27_Health_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_04_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_3'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_04_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_3'Address,
      A_Size          => Io.Tx_Gps_27_Snr_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_04_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_3'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_04_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_4'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_05_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_4'Address,
      A_Size          => Io.Tx_Gps_27_Health_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_05_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_4'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_05_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_4'Address,
      A_Size          => Io.Tx_Gps_27_Snr_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_05_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_4'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_06_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_5'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_06_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_5'Address,
      A_Size          => Io.Tx_Gps_27_Health_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_06_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_5'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_06_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_5'Address,
      A_Size          => Io.Tx_Gps_27_Snr_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_07_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_5'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_07_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_6'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_07_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_6'Address,
      A_Size          => Io.Tx_Gps_27_Health_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_07_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_6'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_08_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_6'Address,
      A_Size          => Io.Tx_Gps_27_Snr_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_08_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_6'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_08_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_7'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_08_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_7'Address,
      A_Size          => Io.Tx_Gps_27_Health_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_09_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_7'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_09_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_7'Address,
      A_Size          => Io.Tx_Gps_27_Snr_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_09_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_7'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_09_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Sat_Id_8'Address,
      A_Size          => Io.Tx_Gps_27_Sat_Id_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_10_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Health_8'Address,
      A_Size          => Io.Tx_Gps_27_Health_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_10_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Elevation_8'Address,
      A_Size          => Io.Tx_Gps_27_Elevation_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_10_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Snr_8'Address,
      A_Size          => Io.Tx_Gps_27_Snr_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1b_10_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_27_Tracking_8'Address,
      A_Size          => Io.Tx_Gps_27_Tracking_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_01_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_State'Address,
      A_Size          => Io.Tx_Gps_28_State'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_01_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Integrity_State'Address,
      A_Size          => Io.Tx_Gps_28_Integrity_State'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_01_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Masked_Integrity_Warning'Address,
      A_Size          => Io.Tx_Gps_28_Masked_Integrity_Warning'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_01_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Bad_Coverage'Address,
      A_Size          => Io.Tx_Gps_28_Bad_Coverage'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_02_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Altitude_Aiding_In_Use'Address,
      A_Size          => Io.Tx_Gps_28_Altitude_Aiding_In_Use'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_02_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Nav_Mode'Address,
      A_Size          => Io.Tx_Gps_28_Nav_Mode'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1c_02_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_28_Error_Status'Address,
      A_Size          => Io.Tx_Gps_28_Error_Status'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1d_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_29_Sw_Version_1'Address,
      A_Size          => Io.Tx_Gps_29_Sw_Version_1'Size);

   -- Jpats_Io.Map_To_Icd_Mnemonic
   --   (An_Interface    => Jiot.Flight_Deck,
   --    An_Icd_Mnemonic => "RS422_TX_GPS_29_SW_VERSION_2",
   --    A_Direction     => Iot.Output,
   --    An_Address      => Io.Tx_Gps_29_Sw_Version_2'Address,
   --    A_Size          => Io.Tx_Gps_29_Sw_Version_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_01_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_1'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_1'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_01_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_2'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_2'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_01_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_3'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_3'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_01_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_4'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_4'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_02_0",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_5'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_5'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_02_1",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_6'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_6'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_02_2",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_7'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_7'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt1f_02_3",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_31_Azimuth_Angle_8'Address,
      A_Size          => Io.Tx_Gps_31_Azimuth_Angle_8'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_serin_gps_data_pkt20_01",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tx_Gps_32_Raim_Status'Address,
      A_Size          => Io.Tx_Gps_32_Raim_Status'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "AUDIO_PNL_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Audio_Pnl_28vdc_Pwr'Address,
      A_Size          => Io.Audio_Pnl_28vdc_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "RMU_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Rmu_28vdc_Pwr'Address,
      A_Size          => Io.Rmu_28vdc_Pwr'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_DIM_OVERRIDE",
      A_Direction     => Iot.Output,
      An_Address      => Io.Uhf_Dim_Override'Address,
      A_Size          => Io.Uhf_Dim_Override'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_28VDC_PWR",
      A_Direction     => Iot.Output,
      An_Address      => Io.Uhf_28vdc_Pwr'Address,
      A_Size          => Io.Uhf_28vdc_Pwr'Size);

--   Jpats_Io.Map_To_Icd_Mnemonic
--     (An_Interface    => Jiot.Flight_Deck,
--      An_Icd_Mnemonic => "UHF_OUT_OF_LOCK",
--      A_Direction     => Iot.Output,
--      An_Address      => Io.Uhf_Out_Of_Lock'Address,
--      A_Size          => Io.Uhf_Out_Of_Lock'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_MIC_KEY_OUT",
      A_Direction     => Iot.Output,
      An_Address      => Io.Uhf_Mic_Key_Out'Address,
      A_Size          => Io.Uhf_Mic_Key_Out'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_SQULCH_TEST",
      A_Direction     => Iot.Input,
      An_Address      => Io.Uhf_Squelch_Test'Address,
      A_Size          => Io.Uhf_Squelch_Test'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_MIC_KEY_IN",
      A_Direction     => Iot.Input,
      An_Address      => Io.Uhf_Mic_Key_In'Address,
      A_Size          => Io.Uhf_Mic_Key_In'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_SIG_PRESENT",
      A_Direction     => Iot.Output,
      An_Address      => Io.Uhf_Sig_Present'Address,
      A_Size          => Io.Uhf_Sig_Present'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_1KHZ_TONE",
      A_Direction     => Iot.Input,
      An_Address      => Io.Uhf_1khz_Tone'Address,
      A_Size          => Io.Uhf_1khz_Tone'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "UHF_ON_LINE",
      A_Direction     => Iot.Input,
      An_Address      => Io.Uhf_On_Line'Address,
      A_Size          => Io.Uhf_On_Line'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_uhf_l124",
      A_Direction     => Iot.Input,
      An_Address      => Io.Backup_Uhf_Freq'Address,
      A_Size          => Io.Backup_Uhf_Freq'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "TAS_SW",
      A_Direction     => Iot.Input,
      An_Address      => Io.Tas_Altitude_Sw'Address,
      A_Size          => Io.Tas_Altitude_Sw'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "FAIL_LT_ON",
      A_Direction     => Iot.Output,
      An_Address      => Io.Fail_Light_On'Address,
      A_Size          => Io.Fail_Light_On'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "MAINT_LT_ON",
      A_Direction     => Iot.Output,
      An_Address      => Io.Maintenance_Light_On'Address,
      A_Size          => Io.Maintenance_Light_On'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_kda_rx_lbuf",
      A_Direction     => Iot.Input,
      An_Address      => Io.Rmu_Data_Rx'Address,
      A_Size          => Io.Rmu_Data_Rx'Size,
      Replay_Passthrough => TRUE);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_kda_tx_lbuf",
      A_Direction     => Iot.Output,
      An_Address      => Io.Rmu_Data_Tx'Address,
      A_Size          => Io.Rmu_Data_Tx'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aico_a429_tas_lbuf",
      A_Direction     => Iot.Output,
      An_Address      => Io.Tas_A429_Tx'Address,
      A_Size          => Io.Tas_A429_Tx'Size);

   Jpats_Io.Map_To_Icd_Mnemonic
     (An_Interface    => Jiot.Flight_Deck,
      An_Icd_Mnemonic => "aici_a429_gps_lbuf",
      A_Direction     => Iot.Input,
      An_Address      => Io.Gps_Data_Rx'Address,
      A_Size          => Io.Gps_Data_Rx'Size);

end;

