-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Adapter,
  Gps,
  Flight_Data_Recorder,
  Ahrs,
  Threat_Control,
  Tas;

with Arinc_429_Types,
  Jpats_Avionics.Arinc;

package JPATS_Avionics.Container is

   package Jat renames Jpats_Avionics_Types;
   package Arinc renames Jpats_Avionics.Arinc;

   type Instance is
      record
         The_Radio_Adapter        : Radio_Adapter.Instance;
         The_Gps                  : Gps.Instance;
         The_Flight_Data_Recorder : Flight_Data_Recorder.Instance;
         The_Ahrs                 : Ahrs.Instance;
         The_Tas                  : Tas.Instance;
         The_Uhf_Tuning           : Jat.Uhf_Tuning_Type;
         The_Vhf_Tuning           : Jat.Vhf_Tuning_Type;
         The_Nav_Tuning           : Jat.Nav_Tuning_Type;
         The_Atc_Tuning           : Jat.Atc_Tuning_Type;
         The_Dme_Tuning           : Jat.Dme_Tuning_Type;
         The_Course_Selected      : Float := 0.0;
      end record;

   This_Subsystem : Instance;

   type Message_Type is array (Integer range <>) of Integer;

   type Arinc_Message_Type is array (Integer range <>)
     of Arinc_429_Types.Message_Type;

   type Rmu_Data_Tx_Type is
      record
         Activity_Counter : Integer := 0;
         Word_Count       : Integer := 0;
         Message          : Message_Type(1 .. 86) := (others => 0);
         Spare            : Message_Type(1 .. 168):= (others => 0);
      end record;

   for Rmu_Data_Tx_Type use
      record
         Activity_Counter at 0*4  range 0 .. 31;
         Word_Count       at 1*4  range 0 .. 31;
         Message          at 2*4  range 0 .. 86*32-1;
         Spare            at 88*4 range 0 .. 168*32-1;
      end record;

   type Rmu_Data_Rx_Type is
      record
         Activity_Counter : Integer := 0;
         Word_Count       : Integer := 0;
         Message          : Message_Type(1 .. 86);
         Spare            : Message_Type(1 .. 40);
      end record;

   for Rmu_Data_Rx_Type use
      record
         Activity_Counter at 0*4  range 0 .. 31;
         Word_Count       at 1*4  range 0 .. 31;
         Message          at 2*4  range 0 .. 86*32-1;
         Spare            at 88*4 range 0 .. 40*32-1;
      end record;

   type Gps_Data_Rx_Type is
      record
         Activity_Counter : Integer := 0;
         Word_Count       : Integer := 0;
         Message          : Message_Type(1 .. 254);
      end record;

   for Gps_Data_Rx_Type use
      record
         Activity_Counter at 0*4  range 0 .. 31;
         Word_Count       at 1*4  range 0 .. 31;
         Message          at 2*4  range 0 .. 254*32-1;
      end record;

   type Tas_A429_Tx_Type is
      record
         Activity_Counter : Integer := 0;
         Word_Count       : Integer := 0;
         Data             : Arinc_Message_Type(1 .. 92);
      end record;

   for Tas_A429_Tx_Type use
      record
         Activity_Counter at 0*4  range 0 .. 31;
         Word_Count       at 1*4  range 0 .. 31;
         Data             at 2*4  range 0 .. 92*32-1;
      end record;

   type Io_Interface_Instance is
      record
         Spare01                             : Float := 0.0;

         --EFIS System Crosstalk
         Rx_Crosstalk_100                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_101                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_300                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_301                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_303                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_305                    : Arinc_429_Types.Message_Type;
         Rx_Crosstalk_371                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_100                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_101                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_300                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_301                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_303                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_305                    : Arinc_429_Types.Message_Type;
         Tx_Crosstalk_371                    : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_100                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_101                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_300                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_301                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_303                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_305                : Arinc_429_Types.Message_Type;
         Tx_Hsi_Crosstalk_371                : Arinc_429_Types.Message_Type;

         --Flight Data Recorder Maintenance Annunciator
         Maintenance_Light_On                : Boolean := False;
         Fail_Light_On                       : Boolean := False;

         --Radio Management Unit
         Rmu_28vdc_Pwr                       : Boolean := False;

         --Backup UHF Controller
         Uhf_28vdc_Pwr                       : Boolean := False;
         Uhf_Dim_Override                    : Boolean := False;
         Uhf_Sig_Present                     : Boolean := False;
         Uhf_Out_Of_Lock                     : Boolean := False;
         Uhf_Mic_Key_Out                     : Boolean := False;
         Uhf_Mic_Key_In                      : Boolean := False;
         Uhf_1khz_Tone                       : Boolean := False;
         Uhf_On_Line                         : Boolean := False;
         Uhf_Squelch_Test                    : Boolean := False;
         Backup_Uhf_Freq                     : Arinc_429_Types.Message_Type;

         --EFIS Control Panel
         Efis_Hsi                            : Boolean := False;
         Efis_Arc                            : Boolean := False;
         Efis_Nav                            : Boolean := False;
         Efis_Up_Rng                         : Boolean := False;
         Efis_Dn_Rng                         : Boolean := False;
         Efis_Map                            : Boolean := False;
         Efis_Up_1                           : Boolean := False;
         Efis_Up_2                           : Boolean := False;
         Efis_Crs                            : Boolean := False;
         Efis_Hdg                            : Boolean := False;
         Efis_Tst                            : Boolean := False;
         Efis_Hdg_0                          : Boolean := False;
         Efis_Hdg_1                          : Boolean := False;
         Efis_Hdg_2                          : Boolean := False;
         Efis_Hdg_3                          : Boolean := False;
         Efis_Hdg_4                          : Boolean := False;
         Efis_Hdg_5                          : Boolean := False;
         Efis_Hdg_6                          : Boolean := False;
         Efis_Hdg_7                          : Boolean := False;
         Efis_Crs_0                          : Boolean := False;
         Efis_Crs_1                          : Boolean := False;
         Efis_Crs_2                          : Boolean := False;
         Efis_Crs_3                          : Boolean := False;
         Efis_Crs_4                          : Boolean := False;
         Efis_Crs_5                          : Boolean := False;
         Efis_Crs_6                          : Boolean := False;
         Efis_Crs_7                          : Boolean := False;

         --serial outputs
         Tx_Cnt_Pnl_270                      : Arinc_429_Types.Message_Type;
         Tx_Cnt_Pnl_271                      : Arinc_429_Types.Message_Type;

         --Tas Panel
         Tas_Lt                              : Boolean := False;
         Tas_Sw_Off                          : Boolean := False;
         Tas_Test_Sw                         : Boolean := False;
         Tas_Stby_Sw                         : Boolean := False;

         --AHRS Panel
         Ahrs_Cw_Sw                          : Boolean := False;
         Ahrs_Ccw_Sw                         : Boolean := False;
         Ahrs_Dg_Sw                          : Boolean := False;
         Ahrs_Test_Sw                        : Boolean := False;
         Ahrs_Meter                          : Float := 0.0;

         --Clock
         Clock_Pwr                           : Boolean := False;
         Bool_Spare1                         : Boolean := False;
         Bool_Spare2                         : Boolean := False;

         --ADI Display
         Adi_28vdc_Pwr                       : Boolean := False;

         -- The_Ahrs_Tx1
         Tx_Ahrs_270                         : Arinc_429_Types.Message_Type;
         Tx_Ahrs_320                         : Arinc_429_Types.Message_Type;
         Tx_Ahrs_324                         : Arinc_429_Types.Message_Type;
         Tx_Ahrs_325                         : Arinc_429_Types.Message_Type;
         Tx_Ahrs_330                         : Arinc_429_Types.Message_Type;

         --HSI Display
         Hsi_28vdc_Pwr                       : Boolean := False;

         --Ta/Vsi Display
         Ta_Vsi_Display_Valid                : Boolean := False;

         --GPS
         Gps_28vdc_Pwr                       : Boolean := False;
         Approach_Mode_Sel                   : Boolean := False;

         --GPS Serial Data

         --Receive 422 data:
         Rx_Gps_9_Nav_Mode                   : Integer := 0;
         Rx_Gps_10_Request_Flag_0            : Integer := 0;
         Rx_Gps_10_Request_Flag_1            : Integer := 0;
         Rx_Gps_10_Request_Flag_2            : Integer := 0;
         Rx_Gps_10_Request_Flag_3            : Integer := 0;
         Rx_Gps_11_Latitude                  : Float := 0.0;
         Rx_Gps_11_Longitude                 : Float := 0.0;
         Rx_Gps_11_Test_Mode                 : Integer := 0;
         Rx_Gps_11_Search_The_Sky            : Integer := 0;
         Rx_Gps_11_Year                      : Integer := 0;
         Rx_Gps_11_Month                     : Integer := 0;
         Rx_Gps_11_Day                       : Integer := 0;
         Rx_Gps_11_Hour                      : Integer := 0;
         Rx_Gps_11_Minute                    : Integer := 0;
         Rx_Gps_11_Seconds                   : Integer := 0;
         Rx_Gps_11_Estimated_Groundspeed     : Integer := 0;
         Rx_Gps_11_True_Airspeed             : Float := 0.0;
         Rx_Gps_11_True_Heading              : Float := 0.0;
         Rx_Gps_11_Track_Angle               : Integer := 0;
         Rx_Gps_12_Altitude_Type             : Integer := 0;
         Rx_Gps_12_Altitude                  : Float := 0.0;
         Rx_Gps_17_Deselect_Select           : Integer := 0;
         Rx_Gps_20_Latitude                  : Float := 0.0;
         Rx_Gps_20_Longitude                 : Float := 0.0;
         Rx_Gps_20_Altitude                  : Integer := 0;
         Rx_Gps_20_Delta_Seconds             : Integer := 0;
         Rx_Gps_20_Nav_Mode                  : Integer := 0;

         -- Receive 429 data:
         Rx_Gps_074                          : Arinc_429_Types.Message_Type;
         Rx_Gps_075                          : Arinc_429_Types.Message_Type;
         Rx_Gps_100                          : Arinc_429_Types.Message_Type;
         Rx_Gps_113                          : Arinc_429_Types.Message_Type;
         Rx_Gps_115                          : Arinc_429_Types.Message_Type;
         Rx_Gps_116                          : Arinc_429_Types.Message_Type;
         Rx_Gps_147                          : Arinc_429_Types.Message_Type;
         Rx_Gps_150                          : Integer;
         Rx_Gps_251                          : Arinc_429_Types.Message_Type;
         Rx_Gps_252                          : Arinc_429_Types.Message_Type;
         Rx_Gps_261                          : Arinc_429_Types.Message_Type;
         Rx_Gps_275                          : Arinc_429_Types.Message_Type;
         Rx_Gps_300                          : Arinc_429_Types.Message_Type;
         Rx_Gps_303                          : Arinc_429_Types.Message_Type;
         Rx_Gps_304                          : Arinc_429_Types.Message_Type;
         Rx_Gps_305                          : Arinc_429_Types.Message_Type;
         Rx_Gps_306                          : Arinc_429_Types.Message_Type;
         Rx_Gps_307                          : Arinc_429_Types.Message_Type;
         Rx_Gps_310                          : Arinc_429_Types.Message_Type;
         Rx_Gps_311                          : Arinc_429_Types.Message_Type;
         Rx_Gps_312                          : Arinc_429_Types.Message_Type;
         Rx_Gps_314                          : Arinc_429_Types.Message_Type;
         Rx_Gps_326                          : Arinc_429_Types.Message_Type;

         -- Transmit 422 data:
         Tx_Gps_21_Valid_Flag                : Boolean := False;
         Tx_Gps_21_Latitude                  : Float := 0.0;
         Tx_Gps_21_Longitude                 : Float := 0.0;
         Tx_Gps_21_Horizontal_Position_Error : Float := 0.0;
         Tx_Gps_22_Valid_Flag                : Boolean := False;
         Tx_Gps_22_Altitude                  : Float := 0.0;
         Tx_Gps_22_Vertical_Position_Error   : Float := 0.0;
         Tx_Gps_23_Valid_Flag                : Boolean := False;
         Tx_Gps_23_Ground_Speed              : Float := 0.0;
         Tx_Gps_23_Track_Angle               : Float := 0.0;
         Tx_Gps_24_Valid_Flag                : Boolean := False;
         Tx_Gps_24_East_Velocity             : Float := 0.0;
         Tx_Gps_24_North_Velocity            : Float := 0.0;
         Tx_Gps_24_Up_Velocity               : Float := 0.0;
         Tx_Gps_25_Valid_Flag                : Boolean := False;
         Tx_Gps_25_Year                      : Integer := 0;
         Tx_Gps_25_Month                     : Integer := 0;
         Tx_Gps_25_Day                       : Integer := 0;
         Tx_Gps_25_Hour                      : Integer := 0;
         Tx_Gps_25_Minute                    : Integer := 0;
         Tx_Gps_25_Second                    : Integer := 0;
         Tx_Gps_26_Valid_Flag                : Boolean := False;
         Tx_Gps_26_Frequency_Estimate        : Float := 0.0;
         Tx_Gps_27_Sat_Id_1                  : Integer := 0;
         Tx_Gps_27_Sat_Id_2                  : Integer := 0;
         Tx_Gps_27_Sat_Id_3                  : Integer := 0;
         Tx_Gps_27_Sat_Id_4                  : Integer := 0;
         Tx_Gps_27_Sat_Id_5                  : Integer := 0;
         Tx_Gps_27_Sat_Id_6                  : Integer := 0;
         Tx_Gps_27_Sat_Id_7                  : Integer := 0;
         Tx_Gps_27_Sat_Id_8                  : Integer := 0;
         Tx_Gps_27_Health_1                  : Integer := 0;
         Tx_Gps_27_Health_2                  : Integer := 0;
         Tx_Gps_27_Health_3                  : Integer := 0;
         Tx_Gps_27_Health_4                  : Integer := 0;
         Tx_Gps_27_Health_5                  : Integer := 0;
         Tx_Gps_27_Health_6                  : Integer := 0;
         Tx_Gps_27_Health_7                  : Integer := 0;
         Tx_Gps_27_Health_8                  : Integer := 0;
         Tx_Gps_27_Elevation_1               : Integer := 0;
         Tx_Gps_27_Elevation_2               : Integer := 0;
         Tx_Gps_27_Elevation_3               : Integer := 0;
         Tx_Gps_27_Elevation_4               : Integer := 0;
         Tx_Gps_27_Elevation_5               : Integer := 0;
         Tx_Gps_27_Elevation_6               : Integer := 0;
         Tx_Gps_27_Elevation_7               : Integer := 0;
         Tx_Gps_27_Elevation_8               : Integer := 0;
         Tx_Gps_27_Snr_1                     : Integer := 0;
         Tx_Gps_27_Snr_2                     : Integer := 0;
         Tx_Gps_27_Snr_3                     : Integer := 0;
         Tx_Gps_27_Snr_4                     : Integer := 0;
         Tx_Gps_27_Snr_5                     : Integer := 0;
         Tx_Gps_27_Snr_6                     : Integer := 0;
         Tx_Gps_27_Snr_7                     : Integer := 0;
         Tx_Gps_27_Snr_8                     : Integer := 0;
         Tx_Gps_27_Tracking_1                : Boolean := False;
         Tx_Gps_27_Tracking_2                : Boolean := False;
         Tx_Gps_27_Tracking_3                : Boolean := False;
         Tx_Gps_27_Tracking_4                : Boolean := False;
         Tx_Gps_27_Tracking_5                : Boolean := False;
         Tx_Gps_27_Tracking_6                : Boolean := False;
         Tx_Gps_27_Tracking_7                : Boolean := False;
         Tx_Gps_27_Tracking_8                : Boolean := False;
         Tx_Gps_28_State                     : Integer := 0;
         Tx_Gps_28_Integrity_State           : Integer := 0;
         Tx_Gps_28_Masked_Integrity_Warning  : Integer := 0;
         Tx_Gps_28_Bad_Coverage              : Integer := 0;
         Tx_Gps_28_Altitude_Aiding_In_Use    : Integer := 0;
         Tx_Gps_28_Nav_Mode                  : Integer := 0;
         Tx_Gps_28_Error_Status              : Integer := 0;
         Tx_Gps_29_Sw_Version_1              : Integer := 0;
         Tx_Gps_29_Sw_Version_2              : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_1           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_2           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_3           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_4           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_5           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_6           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_7           : Integer := 0;
         Tx_Gps_31_Azimuth_Angle_8           : Integer := 0;
         Tx_Gps_32_Raim_Status               : Integer := 0;

         --Audio Control Panel
         Audio_Pnl_28vdc_Pwr : Boolean;

         --Control Wheel Tas switches
         Tas_Altitude_Sw                     : Boolean := False;

         --RMU Interface
         Rmu_Data_Rx                         : Rmu_Data_Rx_Type;
         Rmu_Data_Tx                         : Rmu_Data_Tx_Type;

         --Tas Interface
         Tas_A429_Tx                         : Tas_A429_Tx_Type;

         --Gps Interface
         Gps_Data_Rx                         : Gps_Data_Rx_Type;

         --HSI Interface
         A429_Rx_Fwd_Hsi_Xtalk_100           : Arinc_429_Types.Message_Type;
         A429_Rx_Fwd_Hsi_Xtalk_101           : Arinc_429_Types.Message_Type;
         A429_Rx_Fwd_Hsi_Xtalk_300           : Arinc_429_Types.Message_Type;
         A429_Rx_Fwd_Hsi_Xtalk_301           : Arinc_429_Types.Message_Type;
         A429_Rx_Fwd_Hsi_Xtalk_303           : Arinc_429_Types.Message_Type;
         A429_Rx_Fwd_Hsi_Xtalk_305           : Arinc_429_Types.Message_Type;

         --VSI Labels
         Tas_Vsi_Display_Valid               : Boolean := False;

      end record;

   Io_Size : constant := 4;

   for Io_Interface_Instance use
      record
         Spare01                               at 000*Io_Size range 0 .. 31;
         Rx_Crosstalk_100                      at 001*Io_Size range 0 .. 31;
         Rx_Crosstalk_101                      at 002*Io_Size range 0 .. 31;
         Rx_Crosstalk_300                      at 003*Io_Size range 0 .. 31;
         Rx_Crosstalk_301                      at 004*Io_Size range 0 .. 31;
         Rx_Crosstalk_303                      at 005*Io_Size range 0 .. 31;
         Rx_Crosstalk_305                      at 006*Io_Size range 0 .. 31;
         Rx_Crosstalk_371                      at 007*Io_Size range 0 .. 31;
         Tx_Crosstalk_100                      at 008*Io_Size range 0 .. 31;
         Tx_Crosstalk_101                      at 009*Io_Size range 0 .. 31;
         Tx_Crosstalk_300                      at 010*Io_Size range 0 .. 31;
         Tx_Crosstalk_301                      at 011*Io_Size range 0 .. 31;
         Tx_Crosstalk_303                      at 012*Io_Size range 0 .. 31;
         Tx_Crosstalk_305                      at 013*Io_Size range 0 .. 31;
         Tx_Crosstalk_371                      at 014*Io_Size range 0 .. 31;
         Maintenance_Light_On                  at 015*Io_Size range 0 .. 31;
         Fail_Light_On                         at 016*Io_Size range 0 .. 31;
         Rmu_28vdc_Pwr                         at 017*Io_Size range 0 .. 31;
         Uhf_28vdc_Pwr                         at 018*Io_Size range 0 .. 31;
         Uhf_Dim_Override                      at 019*Io_Size range 0 .. 31;
         Uhf_Sig_Present                       at 020*Io_Size range 0 .. 31;
         Uhf_Out_Of_Lock                       at 021*Io_Size range 0 .. 31;
         Uhf_Mic_Key_Out                       at 022*Io_Size range 0 .. 31;
         Uhf_Mic_Key_In                        at 023*Io_Size range 0 .. 31;
         Uhf_1khz_Tone                         at 024*Io_Size range 0 .. 31;
         Uhf_On_Line                           at 025*Io_Size range 0 .. 31;
         Uhf_Squelch_Test                      at 026*Io_Size range 0 .. 31;
         Backup_Uhf_Freq                       at 027*Io_Size range 0 .. 31;
         Efis_Hsi                              at 028*Io_Size range 0 .. 31;
         Efis_Arc                              at 029*Io_Size range 0 .. 31;
         Efis_Nav                              at 030*Io_Size range 0 .. 31;
         Efis_Up_Rng                           at 031*Io_Size range 0 .. 31;
         Efis_Dn_Rng                           at 032*Io_Size range 0 .. 31;
         Efis_Map                              at 033*Io_Size range 0 .. 31;
         Efis_Up_1                             at 034*Io_Size range 0 .. 31;
         Efis_Up_2                             at 035*Io_Size range 0 .. 31;
         Efis_Crs                              at 036*Io_Size range 0 .. 31;
         Efis_Hdg                              at 037*Io_Size range 0 .. 31;
         Efis_Tst                              at 038*Io_Size range 0 .. 31;
         Efis_Hdg_0                            at 039*Io_Size range 0 .. 31;
         Efis_Hdg_1                            at 040*Io_Size range 0 .. 31;
         Efis_Hdg_2                            at 041*Io_Size range 0 .. 31;
         Efis_Hdg_3                            at 042*Io_Size range 0 .. 31;
         Efis_Hdg_4                            at 043*Io_Size range 0 .. 31;
         Efis_Hdg_5                            at 044*Io_Size range 0 .. 31;
         Efis_Hdg_6                            at 045*Io_Size range 0 .. 31;
         Efis_Hdg_7                            at 046*Io_Size range 0 .. 31;
         Efis_Crs_0                            at 047*Io_Size range 0 .. 31;
         Efis_Crs_1                            at 048*Io_Size range 0 .. 31;
         Efis_Crs_2                            at 049*Io_Size range 0 .. 31;
         Efis_Crs_3                            at 050*Io_Size range 0 .. 31;
         Efis_Crs_4                            at 051*Io_Size range 0 .. 31;
         Efis_Crs_5                            at 052*Io_Size range 0 .. 31;
         Efis_Crs_6                            at 053*Io_Size range 0 .. 31;
         Efis_Crs_7                            at 054*Io_Size range 0 .. 31;
         Tx_Cnt_Pnl_270                        at 055*Io_Size range 0 .. 31;
         Tx_Cnt_Pnl_271                        at 056*Io_Size range 0 .. 31;
         Tas_Lt                                at 057*Io_Size range 0 .. 31;
         Tas_Sw_Off                            at 058*Io_Size range 0 .. 31;
         Tas_Test_Sw                           at 059*Io_Size range 0 .. 31;
         Tas_Stby_Sw                           at 060*Io_Size range 0 .. 31;
         Ahrs_Cw_Sw                            at 061*Io_Size range 0 .. 31;
         Ahrs_Ccw_Sw                           at 062*Io_Size range 0 .. 31;
         Ahrs_Dg_Sw                            at 063*Io_Size range 0 .. 31;
         Ahrs_Test_Sw                          at 064*Io_Size range 0 .. 31;
         Ahrs_Meter                            at 065*Io_Size range 0 .. 31;
         Clock_Pwr                             at 066*Io_Size range 0 .. 31;
         Bool_Spare1                           at 067*Io_Size range 0 .. 31;
         Bool_Spare2                           at 068*Io_Size range 0 .. 31;
         Adi_28vdc_Pwr                         at 069*Io_Size range 0 .. 31;
         Tx_Ahrs_270                           at 070*Io_Size range 0 .. 31;
         Tx_Ahrs_320                           at 071*Io_Size range 0 .. 31;
         Tx_Ahrs_324                           at 072*Io_Size range 0 .. 31;
         Tx_Ahrs_325                           at 073*Io_Size range 0 .. 31;
         Tx_Ahrs_330                           at 074*Io_Size range 0 .. 31;
         Hsi_28vdc_Pwr                         at 075*Io_Size range 0 .. 31;
         Ta_Vsi_Display_Valid                  at 076*Io_Size range 0 .. 31;
         Gps_28vdc_Pwr                         at 077*Io_Size range 0 .. 31;
         Approach_Mode_Sel                     at 078*Io_Size range 0 .. 31;
         Rx_Gps_9_Nav_Mode                     at 079*Io_Size range 0 .. 31;
         Rx_Gps_10_Request_Flag_0              at 080*Io_Size range 0 .. 31;
         Rx_Gps_10_Request_Flag_1              at 081*Io_Size range 0 .. 31;
         Rx_Gps_10_Request_Flag_2              at 082*Io_Size range 0 .. 31;
         Rx_Gps_10_Request_Flag_3              at 083*Io_Size range 0 .. 31;
         Rx_Gps_11_Latitude                    at 084*Io_Size range 0 .. 31;
         Rx_Gps_11_Longitude                   at 085*Io_Size range 0 .. 31;
         Rx_Gps_11_Test_Mode                   at 086*Io_Size range 0 .. 31;
         Rx_Gps_11_Search_The_Sky              at 087*Io_Size range 0 .. 31;
         Rx_Gps_11_Year                        at 088*Io_Size range 0 .. 31;
         Rx_Gps_11_Month                       at 089*Io_Size range 0 .. 31;
         Rx_Gps_11_Day                         at 090*Io_Size range 0 .. 31;
         Rx_Gps_11_Hour                        at 091*Io_Size range 0 .. 31;
         Rx_Gps_11_Minute                      at 092*Io_Size range 0 .. 31;
         Rx_Gps_11_Seconds                     at 093*Io_Size range 0 .. 31;
         Rx_Gps_11_Estimated_Groundspeed       at 094*Io_Size range 0 .. 31;
         Rx_Gps_11_True_Airspeed               at 095*Io_Size range 0 .. 31;
         Rx_Gps_11_True_Heading                at 096*Io_Size range 0 .. 31;
         Rx_Gps_11_Track_Angle                 at 097*Io_Size range 0 .. 31;
         Rx_Gps_12_Altitude_Type               at 098*Io_Size range 0 .. 31;
         Rx_Gps_12_Altitude                    at 099*Io_Size range 0 .. 31;
         Rx_Gps_17_Deselect_Select             at 100*Io_Size range 0 .. 31;
         Rx_Gps_20_Latitude                    at 101*Io_Size range 0 .. 31;
         Rx_Gps_20_Longitude                   at 102*Io_Size range 0 .. 31;
         Rx_Gps_20_Altitude                    at 103*Io_Size range 0 .. 31;
         Rx_Gps_20_Delta_Seconds               at 104*Io_Size range 0 .. 31;
         Rx_Gps_20_Nav_Mode                    at 105*Io_Size range 0 .. 31;
         Rx_Gps_074                            at 106*Io_Size range 0 .. 31;
         Rx_Gps_075                            at 107*Io_Size range 0 .. 31;
         Rx_Gps_100                            at 108*Io_Size range 0 .. 31;
         Rx_Gps_113                            at 109*Io_Size range 0 .. 31;
         Rx_Gps_115                            at 110*Io_Size range 0 .. 31;
         Rx_Gps_116                            at 111*Io_Size range 0 .. 31;
         Rx_Gps_147                            at 112*Io_Size range 0 .. 31;
         Rx_Gps_251                            at 113*Io_Size range 0 .. 31;
         Rx_Gps_252                            at 114*Io_Size range 0 .. 31;
         Rx_Gps_261                            at 115*Io_Size range 0 .. 31;
         Rx_Gps_275                            at 116*Io_Size range 0 .. 31;
         Rx_Gps_300                            at 117*Io_Size range 0 .. 31;
         Rx_Gps_303                            at 118*Io_Size range 0 .. 31;
         Rx_Gps_304                            at 119*Io_Size range 0 .. 31;
         Rx_Gps_305                            at 120*Io_Size range 0 .. 31;
         Rx_Gps_306                            at 121*Io_Size range 0 .. 31;
         Rx_Gps_307                            at 122*Io_Size range 0 .. 31;
         Rx_Gps_310                            at 123*Io_Size range 0 .. 31;
         Rx_Gps_311                            at 124*Io_Size range 0 .. 31;
         Rx_Gps_312                            at 125*Io_Size range 0 .. 31;
         Rx_Gps_314                            at 126*Io_Size range 0 .. 31;
         Rx_Gps_326                            at 127*Io_Size range 0 .. 31;
         Tx_Gps_21_Valid_Flag                  at 128*Io_Size range 0 .. 31;
         Tx_Gps_21_Latitude                    at 129*Io_Size range 0 .. 31;
         Tx_Gps_21_Longitude                   at 130*Io_Size range 0 .. 31;
         Tx_Gps_21_Horizontal_Position_Error   at 131*Io_Size range 0 .. 31;
         Tx_Gps_22_Valid_Flag                  at 132*Io_Size range 0 .. 31;
         Tx_Gps_22_Altitude                    at 133*Io_Size range 0 .. 31;
         Tx_Gps_22_Vertical_Position_Error     at 134*Io_Size range 0 .. 31;
         Tx_Gps_23_Valid_Flag                  at 135*Io_Size range 0 .. 31;
         Tx_Gps_23_Ground_Speed                at 136*Io_Size range 0 .. 31;
         Tx_Gps_23_Track_Angle                 at 137*Io_Size range 0 .. 31;
         Tx_Gps_24_Valid_Flag                  at 138*Io_Size range 0 .. 31;
         Tx_Gps_24_East_Velocity               at 139*Io_Size range 0 .. 31;
         Tx_Gps_24_North_Velocity              at 140*Io_Size range 0 .. 31;
         Tx_Gps_24_Up_Velocity                 at 141*Io_Size range 0 .. 31;
         Tx_Gps_25_Valid_Flag                  at 142*Io_Size range 0 .. 31;
         Tx_Gps_25_Year                        at 143*Io_Size range 0 .. 31;
         Tx_Gps_25_Month                       at 144*Io_Size range 0 .. 31;
         Tx_Gps_25_Day                         at 145*Io_Size range 0 .. 31;
         Tx_Gps_25_Hour                        at 146*Io_Size range 0 .. 31;
         Tx_Gps_25_Minute                      at 147*Io_Size range 0 .. 31;
         Tx_Gps_25_Second                      at 148*Io_Size range 0 .. 31;
         Tx_Gps_26_Valid_Flag                  at 149*Io_Size range 0 .. 31;
         Tx_Gps_26_Frequency_Estimate          at 150*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_1                    at 151*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_2                    at 152*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_3                    at 153*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_4                    at 154*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_5                    at 155*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_6                    at 156*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_7                    at 157*Io_Size range 0 .. 31;
         Tx_Gps_27_Sat_Id_8                    at 158*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_1                    at 159*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_2                    at 160*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_3                    at 161*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_4                    at 162*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_5                    at 163*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_6                    at 164*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_7                    at 165*Io_Size range 0 .. 31;
         Tx_Gps_27_Health_8                    at 166*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_1                 at 167*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_2                 at 168*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_3                 at 169*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_4                 at 170*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_5                 at 171*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_6                 at 172*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_7                 at 173*Io_Size range 0 .. 31;
         Tx_Gps_27_Elevation_8                 at 174*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_1                       at 175*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_2                       at 176*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_3                       at 177*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_4                       at 178*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_5                       at 179*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_6                       at 180*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_7                       at 181*Io_Size range 0 .. 31;
         Tx_Gps_27_Snr_8                       at 182*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_1                  at 183*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_2                  at 184*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_3                  at 185*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_4                  at 186*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_5                  at 187*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_6                  at 188*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_7                  at 189*Io_Size range 0 .. 31;
         Tx_Gps_27_Tracking_8                  at 190*Io_Size range 0 .. 31;
         Tx_Gps_28_State                       at 191*Io_Size range 0 .. 31;
         Tx_Gps_28_Integrity_State             at 192*Io_Size range 0 .. 31;
         Tx_Gps_28_Masked_Integrity_Warning    at 193*Io_Size range 0 .. 31;
         Tx_Gps_28_Bad_Coverage                at 194*Io_Size range 0 .. 31;
         Tx_Gps_28_Altitude_Aiding_In_Use      at 195*Io_Size range 0 .. 31;
         Tx_Gps_28_Nav_Mode                    at 196*Io_Size range 0 .. 31;
         Tx_Gps_28_Error_Status                at 197*Io_Size range 0 .. 31;
         Tx_Gps_29_Sw_Version_1                at 198*Io_Size range 0 .. 31;
         Tx_Gps_29_Sw_Version_2                at 199*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_1             at 200*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_2             at 201*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_3             at 202*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_4             at 203*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_5             at 204*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_6             at 205*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_7             at 206*Io_Size range 0 .. 31;
         Tx_Gps_31_Azimuth_Angle_8             at 207*Io_Size range 0 .. 31;
         Tx_Gps_32_Raim_Status                 at 208*Io_Size range 0 .. 31;
         Audio_Pnl_28vdc_Pwr                   at 209*Io_Size range 0 .. 31;
         Tas_Altitude_Sw                       at 210*Io_Size range 0 .. 31;
         Rmu_Data_Rx                           at 211*Io_Size range 0 .. 128*32-1;
         Rmu_Data_Tx                           at 339*Io_Size range 0 .. 256*32-1;
         Tx_Hsi_Crosstalk_100                  at 595*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_101                  at 596*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_300                  at 597*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_301                  at 598*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_303                  at 599*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_305                  at 600*Io_Size range 0 .. 31;
         Tx_Hsi_Crosstalk_371                  at 601*Io_Size range 0 .. 31;
         Tas_A429_Tx                           at 602*Io_Size range 0 .. 94*32-1;
         Gps_Data_Rx                           at 696*Io_Size range 0 .. 256*32-1;
         A429_Rx_Fwd_Hsi_Xtalk_100             at 952*Io_Size range 0 .. 31;
         A429_Rx_Fwd_Hsi_Xtalk_101             at 953*Io_Size range 0 .. 31;
         A429_Rx_Fwd_Hsi_Xtalk_300             at 954*Io_Size range 0 .. 31;
         A429_Rx_Fwd_Hsi_Xtalk_301             at 955*Io_Size range 0 .. 31;
         A429_Rx_Fwd_Hsi_Xtalk_303             at 956*Io_Size range 0 .. 31;
         A429_Rx_Fwd_Hsi_Xtalk_305             at 957*Io_Size range 0 .. 31;
         Rx_GPS_150                            at 958*Io_Size range 0 .. 31;
         Tas_Vsi_Display_Valid                 at 959*Io_Size range 0 .. 31;

      end record;


   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Rapid_Align              : Boolean := False;
         Attitude_Fail            : Boolean := False;
         Heading_Fail             : Boolean := False;
         Raim_Fail                : Boolean := False;
         GPS_Fail                 : Boolean := False;
         Xpdr_Fail                : Boolean := False;
         Ahrs_Fail_Malf           : Boolean := False;

         Threat_Page_Display_On     : Jat.Ios_Boolean_Type;

         --variables required for the ios instrument repeater
         Rmu_Power                  : Boolean := False;
         Eadi_Power                 : Boolean := False;
         Ehsi_Power                 : Boolean := False;
         EADI_Turn_Rate             : Float   := 0.0;

         Fhdg_Flag                  : Boolean := False;
         Xtalk_Flag                 : Boolean := False;
         Cp_Flag                    : Boolean := False;

         Selected_Heading           : Integer := 0;
         Selected_Course            : Float   := 0.0;
         Selected_Course_Valid      : Integer := 0;
         Selected_Course_Dtk        : Integer := 1;
         Test                       : Boolean := false;
         Hsi_Mode                   : Integer := 0;
         Adi_Mode                   : Integer := 0;
         Map_Mode                   : Integer := 0;
         Range_Select               : Integer := 0;
         Hsi_Heading                : Float   := 0.0;
         Primary_Source             : Integer := 0;
         Primary_Source_Deviation   : Float   := 0.0;
         Primary_Source_Deviation_Valid   : Boolean := false;
         Primary_Source_Deviation_Redx    : Boolean := false;
         Primary_Source_Approach          : Boolean := false;
         Primary_Dme                      : Float   := 0.0;
         Primary_Dme_Status               : Integer := 0;--Jat.Dme_Status_Type;
         Primary_Groundspeed              : Float   := 0.0;
         Primary_Groundspeed_Status       : Integer := 0;--Jat.Grndspd_Status_Type;
         Primary_Ttg                      : Float   := 0.0;
         Primary_Ttg_status               : Integer := 0;--Jat.Grndspd_Status_Type;
         Primary_Gps_Alert                : Jat.Gps_Alert_Type := Jat.blank;
         Gps_Annunciation                 : Integer := 0;
         Repeater_Attitude_Fail           : Boolean := False;
         Repeater_Heading_Fail            : Boolean := False;
         Primary_Dme_Freq                 : Integer := 0;

         Bearing1                         : Float := 0.0;
         Bearing1_Valid                   : Integer := 0;
         Bearing1_Source                  : Integer := 0;
         Bearing1_Distance                : Float := 0.0;
         Bearing1_Distance_Valid          : Integer := 0;
         Bearing2                         : Float := 0.0;
         Bearing2_Valid                   : Integer := 0;
         Bearing2_Source                  : Integer := 0;
         Bearing2_Distance                : Float := 0.0;
         Bearing2_Distance_Valid          : Integer := 0;

         To_From                    : Jat.To_From_Type;
         Glideslope_Scale_Status    : Integer := 0;
         Glideslope_Dev             : Float := 0.0;
         Gs_Rcvr_Fail               : Boolean := False;
         Nav_Pwr_Fail               : Boolean := False;

         Pitch                      : Float := 0.0;
         Roll                       : Float := 0.0;
         Marker_Beacon              : Integer := 0;

         --RMU:
         Uhf_Frequency              : Integer := 0;
         Uhf_Channel                : Integer := 0;
         Uhf_Channel_Active         : Boolean := False;
         Uhf_Mode_Both              : Boolean := False;
         Vhf_Frequency              : Integer := 0;
         Atc_Code                   : Integer := 0;
         Atc_Mode                   : Integer := 0;
         Atc_Ident                  : Boolean := False;
         Atc_Flight_ID              : String(1 .. 12) := "            ";
         Atc_Flight_ID_Was_Set      : Boolean := False;
         Nav_Frequency              : Integer := 0;
         Ils_Selected               : Boolean := False;
         Ils_Backcourse             : Boolean := False;
         Dme_Frequency              : Integer := 0;
         Dme_Hold                   : Boolean := False;

         --Backup UHF Controller
         Backup_Frequency           : Integer := 0;
         Backup_Channel             : Integer := 0;
         Uhf_Backup_Mode            : Integer := 0;

         --AHRS switches:
         Ahrs_Slew                  : Integer := 0;
         Ahrs_Dg_Sw                 : Boolean := false;

         --TAS switches:
         Tas_Sw_Off                 : Boolean := false;
         Tas_Mode_Sw                : Integer := 0;

         --TAS Repeater
         Tas_Display_Range          : Integer := 0;
         Tas_Intr_Active_1          : Boolean := false;
         Tas_Intr_Active_2          : Boolean := false;
         Tas_Intr_Range_1           : Float   := 0.0;
         Tas_Intr_Range_2           : Float   := 0.0;
         Tas_Intr_Rel_Alt_1         : Float   := 0.0;
         Tas_Intr_Rel_Alt_2         : Float   := 0.0;
         Tas_Intr_Brg_1             : Float   := 0.0;
         Tas_Intr_Brg_2             : Float   := 0.0;
         Tas_Intr_Disp_Type_1       : Integer := 0;
         Tas_Intr_Disp_Type_2       : Integer := 0;
         Tas_Status                 : Integer := 0;
         Vsi_Power                  : Boolean := false;
         Rate_Of_Climb              : Float   := 0.0;

         --VOR map mode
         Vor_Map_Lat                : Long_Float := 0.0;
         Vor_Map_Lon                : Long_Float := 0.0;
         Vor_Map_Station_Type       : Integer := 0;

         --GPS map mode
         Waypoint_Ident             : Jat.Waypoint_Ident_Type;
         Waypoint_Latitude          : Jat.Waypoint_Latitude_Type;
         Waypoint_Longitude         : Jat.Waypoint_Longitude_Type;
         Waypoint_Station_Type      : Jat.Waypoint_Station_Type_Type;
         Waypoint_Active            : Integer := 0;
         Waypoint_Number            : Integer := 0;
         Gps_Obs_Mode               : Boolean := False;
         Magvar_From_Gps            : Float   := 0.0;

         --debug labels
         Ios_Timer                  : Boolean := False;

         Nav_Float1                  : Float := 0.0;
         Nav_Float2                  : Float := 0.0;
         Nav_Float3                  : Float := 0.0;
         Nav_Float4                  : Float := 0.0;
         Nav_Float5                  : Float := 0.0;
         Nav_Float6                  : Float := 0.0;
         Nav_Float7                  : Float := 0.0;
         Nav_Float8                  : Float := 0.0;
         Nav_Float9                  : Float := 0.0;
         Nav_Float10                 : Float := 0.0;

         Nav_Int1                    : Integer := 0;
         Nav_Int2                    : Integer := 0;
         Nav_Int3                    : Integer := 0;
         Nav_Int4                    : Integer := 0;
         Nav_Int5                    : Integer := 0;
         Nav_Int6                    : Integer := 0;
         Nav_Int7                    : Integer := 0;
         Nav_Int8                    : Integer := 0;
         Nav_Int9                    : Integer := 0;
         Nav_Int10                   : Integer := 0;

         Nav_Bool1                   : Boolean := False;
         Nav_Bool2                   : Boolean := False;
         Nav_Bool3                   : Boolean := False;
         Nav_Bool4                   : Boolean := False;
         Nav_Bool5                   : Boolean := False;
         Nav_Bool6                   : Boolean := False;
         Nav_Bool7                   : Boolean := False;
         Nav_Bool8                   : Boolean := False;
         Nav_Bool9                   : Boolean := False;
         Nav_Bool10                  : Boolean := False;

         Nav_Str1                    : String(1 .. 5) := "     ";
         Nav_Str2                    : String(1 .. 5) := "     ";
         Nav_Str3                    : String(1 .. 5) := "     ";
         Nav_Str4                    : String(1 .. 5) := "     ";
         Nav_Str5                    : String(1 .. 5) := "     ";
         Nav_Str6                    : String(1 .. 5) := "     ";
         Nav_Str7                    : String(1 .. 5) := "     ";
         Nav_Str8                    : String(1 .. 5) := "     ";
         Nav_Str9                    : String(1 .. 5) := "     ";
         Nav_Str10                   : String(1 .. 5) := "     ";

         Nav_Str1_Was_Set            : Boolean := False;
         Nav_Str2_Was_Set            : Boolean := False;
         Nav_Str3_Was_Set            : Boolean := False;
         Nav_Str4_Was_Set            : Boolean := False;
         Nav_Str5_Was_Set            : Boolean := False;
         Nav_Str6_Was_Set            : Boolean := False;
         Nav_Str7_Was_Set            : Boolean := False;
         Nav_Str8_Was_Set            : Boolean := False;
         Nav_Str9_Was_Set            : Boolean := False;
         Nav_Str10_Was_Set           : Boolean := False;

         Groundspeed                 : Float   := 0.0;

      end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Avionics.Container;
