-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Arinc_429_Bnr,
  Arinc_429_Discrete,
  Arinc_429_Types,
  Jpats_Avionics_Types;

package Jpats_Avionics.Arinc is

   package Jat renames Jpats_Avionics_Types;

   --types packages for arinc 429 pack/unpack
   type Spare_Type is new Integer range 0 .. 1;
   for Spare_Type'Size use 1;
   Spare : constant Spare_Type := 0;

   type Int_4 is Mod 16;

   type Int2_Type is new Integer range 0 .. 3;
   for Int2_Type'Size use 2;
   type Int3_Type is new Integer range 0 .. 7;
   for Int3_Type'Size use 3;
   type Int4_Type is new Integer range 0 .. 15;
   for Int4_Type'Size use 4;
   type Int5_Type is new Integer range 0 .. 31;
   for Int5_Type'Size use 5;
   type Int6_Type is new Integer range 0 .. 63;
   for Int6_Type'Size use 6;
   type Int7_Type is new Integer range 0 .. 127;
   for Int7_Type'Size use 7;
   type Int8_Type is new Integer range 0 .. 255;
   for Int8_Type'Size use 8;

   type Source_Command_Type is
     (No_Command,Two_Commands,One_Command,Control_Panel_Command);
   for Source_Command_Type'Size use 2;

   type Discrete_Xtalk_100_Type is
      record
         Spare_11               : Spare_Type := Spare;
         Crs_Knob_Command_Relay
           : Source_Command_Type := No_Command;
      end record;
   for Discrete_Xtalk_100_Type use
      record
         Spare_11               at 0 range 0 .. 0;
         Crs_Knob_Command_Relay at 0 range 1 .. 2;
      end record;
   for Discrete_Xtalk_100_Type'Size use 3;

   type Discrete_Xtalk_101_Type is
      record
         Spare_11               : Spare_Type := Spare;
         Hdg_Knob_Command_Relay
           : Source_Command_Type := No_Command;
      end record;
   for Discrete_Xtalk_101_Type use
      record
         Spare_11               at 0 range 0 .. 0;
         Hdg_Knob_Command_Relay at 0 range 1 .. 2;
      end record;
   for Discrete_Xtalk_101_Type'Size use 3;

   type Nav_Source_Type is
     (Vor_Without,Vor_With,Vor1_Without,Vor1_With,Vor2_Without,Vor2_With,
      Tacan_Without,Tacan_With,Gps_Without,Gps_With);
   for Nav_Source_Type'Size use 4;
   type Bearing_Source_Type is (Declutter,Adf,Vor,Vor1,Vor2,Tacan,Gps);
   for Bearing_Source_Type'Size use 3;

   type Discrete_Xtalk_300_Type is
      record
         Nav_Source                : Nav_Source_Type := Vor_Without;
         Spare_15                  : Spare_Type := Spare;
         Nav_Source_Command        : Source_Command_Type := No_Command;
         Bearing_1_Source          : Bearing_Source_Type := Declutter;
         Spare_21                  : Spare_Type := Spare;
         Bearing_1_Source_Command  : Source_Command_Type := No_Command;
         Bearing_2_Source          : Bearing_Source_Type := Declutter;
         Spare_27                  : Spare_Type := Spare;
         Bearing_2_Source_Command  : Source_Command_Type := No_Command;
      end record;
   for Discrete_Xtalk_300_Type use
      record
         Nav_Source                at 0 range 0 .. 3;
         Spare_15                  at 0 range 4 .. 4;
         Nav_Source_Command        at 0 range 5 .. 6;
         Bearing_1_Source          at 0 range 7 .. 9;
         Spare_21                  at 0 range 10 .. 10;
         Bearing_1_Source_Command  at 0 range 11 .. 12;
         Bearing_2_Source          at 0 range 13 .. 15;
         Spare_27                  at 0 range 16 .. 16;
         Bearing_2_Source_Command  at 0 range 17 .. 18;
      end record;
   for Discrete_Xtalk_300_Type'Size use 19;

   type Map_Mode_Type is (Waypoints,Ground_Stations,Airports,
                          Ground_Stations_And_Airports);
   for Map_Mode_Type'Size use 2;

   type Range_Type is (M5,M10,M20,M40,M80,M160,M240,M320,M1000);
   for Range_Type'Size use 4;

   type Discrete_Xtalk_301_Type is
      record
         Gps_Approach_Own           : Boolean := False;
         Gps_Approach_Onside        : Boolean := False;
         Gps_Approach_Cross_Side    : Boolean := False;
         Spare_14                   : Spare_Type := Spare;
         Map_Mode                   : Map_Mode_Type := Waypoints;
         Spare_17                   : Spare_Type := Spare;
         Spare_18                   : Spare_Type := Spare;
         Map_Mode_Command           : Source_Command_Type := No_Command;
         Display_Range              : Range_Type := M5;
         Spare_25                   : Spare_Type := Spare;
         Spare_26                   : Spare_Type := Spare;
         Range_Command              : Source_Command_Type := No_Command;
         Spare_29                   : Spare_Type := Spare;
      end record;
   for Discrete_Xtalk_301_Type use
      record
         Gps_Approach_Own           at 0 range 0 .. 0;
         Gps_Approach_Onside        at 0 range 1 .. 1;
         Gps_Approach_Cross_Side    at 0 range 2 .. 2;
         Spare_14                   at 0 range 3 .. 3;
         Map_Mode                   at 0 range 4 .. 5;
         Spare_17                   at 0 range 6 .. 6;
         Spare_18                   at 0 range 7 .. 7;
         Map_Mode_Command           at 0 range 8 .. 9;
         Display_Range              at 0 range 10 .. 13;
         Spare_25                   at 0 range 14 .. 14;
         Spare_26                   at 0 range 15 .. 15;
         Range_Command              at 0 range 16 .. 17;
         Spare_29                   at 0 range 18 .. 18;
      end record;
   for Discrete_Xtalk_301_Type'Size use 19;

   type Display_Mode_Type is (Composite,D360,D360_Map,Dg,Arc,Arc_Map,Invalid);
   for Display_Mode_Type'Size use 3;
   type Adi_Display_Mode_Type is (Composite,Adi,Invalid);
   for Adi_Display_Mode_Type'Size use 2;

   type Discrete_Xtalk_305_Type is
      record
         Hsi_Display_Mode         : Display_Mode_Type := D360;
         Spare_14                 : Spare_Type := Spare;
         Hsi_Display_Mode_Command : Source_Command_Type := No_Command;
         Adi_Display_Mode         : Adi_Display_Mode_Type := Adi;
         Spare_19                 : Spare_Type := Spare;
         Adi_Display_Mode_Command : Source_Command_Type := No_Command;
         Spare_22                 : Spare_Type := Spare;
         Strap_1                  : Boolean := False;
         Strap_2                  : Boolean := False;
         Strap_3                  : Boolean := False;
         Cross_Side_Status        : Boolean := False;
         On_Side_Fail             : Boolean := False;
         Control_Panel_Fail       : Boolean := False;
         Xtalk_Flag_Active        : Boolean := False;
      end record;
   for Discrete_Xtalk_305_Type use
      record
         Hsi_Display_Mode         at 0 range 0 .. 2;
         Spare_14                 at 0 range 3 .. 3;
         Hsi_Display_Mode_Command at 0 range 4 .. 5;
         Adi_Display_Mode         at 0 range 6 .. 7;
         Spare_19                 at 0 range 8 .. 8;
         Adi_Display_Mode_Command at 0 range 9 .. 10;
         Spare_22                 at 0 range 11 .. 11;
         Strap_1                  at 0 range 12 .. 12;
         Strap_2                  at 0 range 13 .. 13;
         Strap_3                  at 0 range 14 .. 14;
         Cross_Side_Status        at 0 range 15 .. 15;
         On_Side_Fail             at 0 range 16 .. 16;
         Control_Panel_Fail       at 0 range 17 .. 17;
         Xtalk_Flag_Active        at 0 range 18 .. 18;
      end record;
   for Discrete_Xtalk_305_Type'Size use 19;

   type Discrete_371_Type is mod 2**19;

   type Discrete_Tx_Cnt_Pnl_270_Type is
      record
         Test_Key_State        : Boolean := False;
         Hsi_Key_State         : Boolean := False;
         Arc_Key_State         : Boolean := False;
         Nav_Key_State         : Boolean := False;
         Range_Incr_Key_State  : Boolean := False;
         Range_Decr_Key_State  : Boolean := False;
         Double_Rmi_Key_State  : Boolean := False;
         Single_Rmi_Key_State  : Boolean := False;
         Map_Key_State         : Boolean := False;
         Crs_Pull_Switch_State : Boolean := False;
         Hdg_Pull_Switch_State : Boolean := False;
         Spare_22              : Spare_Type := Spare;
         Spare_23              : Spare_Type := Spare;
         Spare_24              : Spare_Type := Spare;
         Spare_25              : Spare_Type := Spare;
         Spare_26              : Spare_Type := Spare;
         Spare_27              : Spare_Type := Spare;
         Strap1_Installed      : Boolean := False;
         Strap221_installed    : Boolean := False;
      end record;
   for Discrete_Tx_Cnt_Pnl_270_Type use
      record
         Test_Key_State        at 0 range 0 .. 0;
         Hsi_Key_State         at 0 range 1 .. 1;
         Arc_Key_State         at 0 range 2 .. 2;
         Nav_Key_State         at 0 range 3 .. 3;
         Range_Incr_Key_State  at 0 range 4 .. 4;
         Range_Decr_Key_State  at 0 range 5 .. 5;
         Double_Rmi_Key_State  at 0 range 6 .. 6;
         Single_Rmi_Key_State  at 0 range 7 .. 7;
         Map_Key_State         at 0 range 8 .. 8;
         Crs_Pull_Switch_State at 0 range 9 .. 9;
         Hdg_Pull_Switch_State at 0 range 10 .. 10;
         Spare_22              at 0 range 11 .. 11;
         Spare_23              at 0 range 12 .. 12;
         Spare_24              at 0 range 13 .. 13;
         Spare_25              at 0 range 14 .. 14;
         Spare_26              at 0 range 15 .. 15;
         Spare_27              at 0 range 16 .. 16;
         Strap1_Installed      at 0 range 17 .. 17;
         Strap221_installed    at 0 range 18 .. 18;
      end record;
   for Discrete_Tx_Cnt_Pnl_270_Type'Size use 19;

   type Knob_Direction_Type is (Positive,Negative);
   for Knob_Direction_Type'Size use 1;

   type Discrete_Tx_Cnt_Pnl_271_Type is
      record
         Spare_9                : Spare_Type := Spare;
         Course_Knob_Counts     : Int4_Type := 0;
         Course_Knob_Direction  : Knob_Direction_Type := Positive;
         Heading_Knob_Counts    : Int4_Type := 0;
         Heading_Knob_Direction : Knob_Direction_Type := Positive;
         Spare_20               : Spare_Type := Spare;
         Spare_21               : Spare_Type := Spare;
         Spare_22               : Spare_Type := Spare;
         Spare_23               : Spare_Type := Spare;
         Spare_24               : Spare_Type := Spare;
         Spare_25               : Spare_Type := Spare;
         Spare_26               : Spare_Type := Spare;
         Spare_27               : Spare_Type := Spare;
         Spare_28               : Spare_Type := Spare;
         Spare_29               : Spare_Type := Spare;
      end record;
   for Discrete_Tx_Cnt_Pnl_271_Type use
      record
         Spare_9                at 0 range 0 .. 0;
         Course_Knob_Counts     at 0 range 1 .. 4;
         Course_Knob_Direction  at 0 range 5 .. 5;
         Heading_Knob_Counts    at 0 range 6 .. 9;
         Heading_Knob_Direction at 0 range 10 .. 10;
         Spare_20               at 0 range 11 .. 11;
         Spare_21               at 0 range 12 .. 12;
         Spare_22               at 0 range 13 .. 13;
         Spare_23               at 0 range 14 .. 14;
         Spare_24               at 0 range 15 .. 15;
         Spare_25               at 0 range 16 .. 16;
         Spare_26               at 0 range 17 .. 17;
         Spare_27               at 0 range 18 .. 18;
         Spare_28               at 0 range 19 .. 19;
         Spare_29               at 0 range 20 .. 20;
      end record;
   for Discrete_Tx_Cnt_Pnl_271_Type'Size use 21;

   type Discrete_Tx_Ahrs_270_Type is
      record
         Align_Mode       : Jpats_Avionics_Types.Align_Mode_Type;
         Spare_12         : Spare_Type := Spare;
         Normal_Mode      : Boolean := False;
         Heading_Dg_Mode  : Jpats_Avionics_Types.Heading_Mode_Type;
         Attitude_Invalid : Boolean := False;
         Spare_16         : Spare_Type := Spare;
         Spare_17         : Spare_Type := Spare;
         Spare_18         : Spare_Type := Spare;
         Ahru_Fault       : Boolean := False;
         Spare_20         : Spare_Type := Spare;
         Spare_21         : Spare_Type := Spare;
         Spare_22         : Spare_Type := Spare;
         Spare_23         : Spare_Type := Spare;
         Spare_24         : Spare_Type := Spare;
         Spare_25         : Spare_Type := Spare;
         Spare_26         : Spare_Type := Spare;
         Spare_27         : Spare_Type := Spare;
         Spare_28         : Spare_Type := Spare;
         Spare_29         : Spare_Type := Spare;
      end record;
   pragma Pack(Discrete_Tx_Ahrs_270_Type);
   for Discrete_Tx_Ahrs_270_Type'Size use 19;

   type Discrete_Rx_Gps_074_Type is
      record
         Total_Number_Of_Records : Int7_Type;
         Spare_16            : Spare_Type := Spare;
         Spare_17            : Spare_Type := Spare;
         Spare_18            : Spare_Type := Spare;
         Spare_19            : Spare_Type := Spare;
         Spare_20            : Spare_Type := Spare;
         Prior_Record_Change : Boolean := False;
         Spare_22            : Spare_Type := Spare;
         Spare_23            : Spare_Type := Spare;
         Spare_24            : Spare_Type := Spare;
         Spare_25            : Spare_Type := Spare;
         Spare_26            : Spare_Type := Spare;
         Spare_27            : Spare_Type := Spare;
         Spare_28            : Spare_Type := Spare;
         Spare_29            : Spare_Type := Spare;
      end record;
   pragma Pack(Discrete_Rx_Gps_074_Type);
   for Discrete_Rx_Gps_074_Type'Size use 21;

   type Rx_Gps_074_Type is
      record
         Label               : Int8_Type;
         Total_Number_Of_Records : Int7_Type;
         Spare_16            : Spare_Type := Spare;
         Spare_17            : Spare_Type := Spare;
         Spare_18            : Spare_Type := Spare;
         Spare_19            : Spare_Type := Spare;
         Spare_20            : Spare_Type := Spare;
         Prior_Record_Change : Boolean := False;
         Spare_22            : Spare_Type := Spare;
         Spare_23            : Spare_Type := Spare;
         Spare_24            : Spare_Type := Spare;
         Spare_25            : Spare_Type := Spare;
         Spare_26            : Spare_Type := Spare;
         Spare_27            : Spare_Type := Spare;
         Spare_28            : Spare_Type := Spare;
         Spare_29            : Spare_Type := Spare;
         Ssm                 : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32            : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_074_Type);
   for Rx_Gps_074_Type'Size use 32;

   type Auto_Man_Type is (Auto_Leg, Man_Obs);
   for Auto_Man_Type'Size use 1;
   type Map_Reference_Type is (Magnetic, True);
   for Map_Reference_Type'Size use 1;

   type Discrete_Rx_Gps_075_Type is
      record
         Auto_Man              : Auto_Man_Type;
         Reference             : Map_Reference_Type;
         Radar_Wpt_Displayed   : Boolean := False;
         Spare_12              : Spare_Type := Spare;
         To_Wpt_Bcd_Ms_Byte    : Int_4;
         From_Wpt_Bcd_Ms_Byte  : Int_4;
         To_Wpt_Bcd_Ls_Byte    : Int_4;
         From_Wpt_Bcd_Ls_Byte  : Int_4;
         Spare_29              : Spare_Type := Spare;
      end record;
   pragma Pack(Discrete_Rx_Gps_075_Type);
   for Discrete_Rx_Gps_075_Type'Size use 21;

   type Rx_Gps_075_Type is
      record
         Label                 : Int8_Type;
         Auto_Man              : Auto_Man_Type;
         Reference             : Map_Reference_Type;
         Radar_Wpt_Displayed   : Boolean := False;
         Spare_12              : Spare_Type := Spare;
         To_Wpt_Bcd_Ms_Byte    : Int_4;
         From_Wpt_Bcd_Ms_Byte  : Int_4;
         To_Wpt_Bcd_Ls_Byte    : Int_4;
         From_Wpt_Bcd_Ls_Byte  : Int_4;
         Spare_29              : Spare_Type := Spare;
         Ssm                   : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32              : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_075_Type);
   for Rx_Gps_075_Type'Size use 32;

   type Discrete_Rx_Gps_100_Type is
      record
         Hsi_Crs_Sel_Master_Control : Boolean := False;
      end record;
   pragma Pack(Discrete_Rx_Gps_100_Type);
   for Discrete_Rx_Gps_100_Type'Size use 1;

   type Binary_Message_Checksum_Type is mod 2**21;

   type Discrete_Rx_Gps_113_Type is
      record
         Binary_Message_Checksum : Binary_Message_Checksum_Type;
      end record;
   pragma Pack(Discrete_Rx_Gps_113_Type);
   for Discrete_Rx_Gps_113_Type'Size use 21;

   type Rx_Gps_113_Type is
      record
         Label                   : Int8_Type;
         Binary_Message_Checksum : Binary_Message_Checksum_Type;
         Ssm                     : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32                : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_113_Type);
   for Rx_Gps_113_Type'Size use 32;

   type Source_Of_Data_Type is (Pilot_Entered, Computed);
   for Source_Of_Data_Type'Size use 1;

   type Discrete_Rx_Gps_147_Type is
      record
         Source_Of_Data : Source_Of_Data_Type;
      end record;
   pragma Pack(Discrete_Rx_Gps_147_Type);
   for Discrete_Rx_Gps_147_Type'Size use 1;

   type Gps_Annunciation_Type is (Enroute, Terminal, Approach,
                                  None1, Oceanic, None2, None3, None4);
   for Gps_Annunciation_Type'Size use 3;

   type Discrete_Rx_Gps_261_Type is
      record
         Spare_11                  : Spare_Type := Spare;
         Spare_12                  : Spare_Type := Spare;
         Reserved_13               : Spare_Type := Spare;
         Reserved_14               : Spare_Type := Spare;
         Reserved_15               : Spare_Type := Spare;
         Reserved_16               : Spare_Type := Spare;
         Reserved_17               : Spare_Type := Spare;
         Reserved_18               : Spare_Type := Spare;
         Reserved_19               : Spare_Type := Spare;
         Spare_20                  : Spare_Type := Spare;
         Dev_Scaling_In_Transition : Boolean := False;
         Final_Approach            : Boolean := False;
         Appr_Integrity            : Boolean := False;
         Gps_Integrity             : Boolean := False;
         Gps_Annunciation          : Gps_Annunciation_Type;
         Spare_28                  : Spare_Type := Spare;
         Spare_29                  : Spare_Type := Spare;
      end record;
   pragma Pack(Discrete_Rx_Gps_261_Type);
   for Discrete_Rx_Gps_261_Type'Size use 19;

   type Gps_Mode_Type is (Rnav_Enr, Rnav_Appr, Nav, Ils);
   for Gps_Mode_Type'Size use 2;

   type Discrete_Rx_Gps_275_Type is
      record
         Waypoint_Alert             : Boolean := False;
         Dead_Reckon                : Boolean := False;
         Direct_To_Selected         : Boolean := False;
         Gps_Mode                   : Gps_Mode_Type;
         Appr_Computations_Selected : Boolean := False;
         Spare_17                   : Spare_Type := Spare;
         Spare_18                   : Spare_Type := Spare;
         Spare_19                   : Spare_Type := Spare;
         Spare_20                   : Spare_Type := Spare;
         Spare_21                   : Spare_Type := Spare;
         Integrity_Warn             : Boolean := False;
         To                         : Boolean := False;
         From                       : Boolean := False;
         Selected_Crosstrack_Warn   : Boolean := False;
         Airport_Display_Selected   : Boolean := False;
         Message_Alert              : Boolean := False;
         True_Mag                   : Map_Reference_Type;
         Hsi_Valid                  : Boolean := False;
      end record;
   pragma Pack (Discrete_Rx_Gps_275_Type);
   for Discrete_Rx_Gps_275_Type'Size use 19;

   type Class_Type is (Low, High, Terminal, Undefined);
   for Class_Type'Size use 2;

   type Station_Decl_Sign_Type is (West,East);
   for Station_Decl_Sign_Type'Size use 1;

   type Discrete_Rx_Gps_300_Type is
      record
         Spare_09           : Spare_Type := Spare;
         Spare_10           : Spare_Type := Spare;
         Spare_11           : Spare_Type := Spare;
         Spare_12           : Spare_Type := Spare;
         Spare_13           : Spare_Type := Spare;
         Spare_14           : Spare_Type := Spare;
         Non_Collocated_Dme : Boolean := False;
         Tuned_And_Received : Boolean := False;
         Station_Decl       : Int7_Type;
         Station_Decl_Sign  : Station_Decl_Sign_Type;
         Vor                : Boolean := False;
         Dme                : Boolean := False;
         Tacan              : Boolean := False;
         Class              : Class_Type;
      end record;
   pragma Pack (Discrete_Rx_Gps_300_Type);
   for Discrete_Rx_Gps_300_Type'Size use 21;

   type Rx_Gps_300_Type is
      record
         Label              : Int8_Type;
         Spare_09           : Spare_Type := Spare;
         Spare_10           : Spare_Type := Spare;
         Spare_11           : Spare_Type := Spare;
         Spare_12           : Spare_Type := Spare;
         Spare_13           : Spare_Type := Spare;
         Spare_14           : Spare_Type := Spare;
         Non_Collocated_Dme : Boolean := False;
         Tuned_And_Received : Boolean := False;
         Station_Decl       : Int7_Type;
         Station_Decl_Sign  : Station_Decl_Sign_Type;
         Vor                : Boolean := False;
         Dme                : Boolean := False;
         Tacan              : Boolean := False;
         Class              : Class_Type;
         Ssm                : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32           : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_300_Type);
   for Rx_Gps_300_Type'Size use 32;

   type Words_In_Message_Type is new Integer range 0 .. 15;
   for Words_In_Message_Type'Size use 4;
   type Waypoint_Station_Type is (Waypoint, Navaid, Airport);
   for Waypoint_Station_Type'Size use 3;
   type Data_Record_Type is (Off_Route, On_Route);
   for Data_Record_Type'Size use 1;

   type Discrete_Rx_Gps_303_Type is
      record
         Words_In_Message      : Words_In_Message_Type;
         Waypoint_Station      : Waypoint_Station_Type;
         Data_Record           : Data_Record_Type;
         Record_Number         : Int7_Type;
         Spare_24              : Spare_Type := Spare;
         Center_Of_Flight_Plan : Boolean := False;
         Gap_In_Flight_Plan    : Boolean := False;
         Spare_27              : Spare_Type := Spare;
         Spare_28              : Spare_Type := Spare;
         Spare_29              : Spare_Type := Spare;
      end record;
   pragma Pack(Discrete_Rx_Gps_303_Type);
   for Discrete_Rx_Gps_303_Type'Size use 21;

   type Rx_Gps_303_Type is
      record
         Label                 : Int8_Type;
         Words_In_Message      : Words_In_Message_Type;
         Waypoint_Station      : Waypoint_Station_Type;
         Data_Record           : Data_Record_Type;
         Record_Number         : Int7_Type;
         Spare_24              : Spare_Type := Spare;
         Center_Of_Flight_Plan : Boolean := False;
         Gap_In_Flight_Plan    : Boolean := False;
         Spare_27              : Spare_Type := Spare;
         Spare_28              : Spare_Type := Spare;
         Spare_29              : Spare_Type := Spare;
         Ssm                   : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32              : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_303_Type);
   for Rx_Gps_303_Type'Size use 32;

   type Map_Character is new Character range Ascii.Nul .. Ascii.Del;
   for Map_Character'Size use 7;

   type Discrete_Rx_Gps_304_Type is
      record
         Character_1 : Map_Character;
         Character_2 : Map_Character;
         Character_3 : Map_Character;
      end record;
   pragma Pack(Discrete_Rx_Gps_304_Type);
   for Discrete_Rx_Gps_304_Type'Size use 21;

   type Rx_Gps_304_Type is
      record
         Label       : Int8_Type;
         Character_1 : Map_Character;
         Character_2 : Map_Character;
         Character_3 : Map_Character;
         Ssm         : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32    : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_304_Type);
   for Rx_Gps_304_Type'Size use 32;

   type Discrete_Rx_Gps_305_Type is
      record
         Character_4 : Map_Character;
         Character_5 : Map_Character;
         Character_6 : Map_Character;
      end record;
   pragma Pack(Discrete_Rx_Gps_305_Type);
   for Discrete_Rx_Gps_305_Type'Size use 21;

   type Rx_Gps_305_Type is
      record
         Label       : Int8_Type;
         Character_4 : Map_Character;
         Character_5 : Map_Character;
         Character_6 : Map_Character;
         Ssm         : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32    : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_305_Type);
   for Rx_Gps_305_Type'Size use 32;

   type Sign_Type is (Positive,Negative);
   for Sign_Type'Size use 1;

   type Binary_Angle_20_Type is new Integer range 0 .. 1048575;
   for Binary_Angle_20_Type'Size use 20;

   type Rx_Gps_306_Type is
      record
         Label        : Int8_Type;
         Binary_Angle : Binary_Angle_20_Type;
         Sign         : Sign_Type := Positive;
         Ssm          : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32     : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_306_Type);
   for Rx_Gps_306_Type'Size use 32;

   type Rx_Gps_307_Type is
      record
         Label        : Int8_Type;
         Binary_Angle : Binary_Angle_20_Type;
         Sign         : Sign_Type := Positive;
         Ssm          : Arinc_429_Types.Bnr_Ssm_Type;
         Spare_32     : Spare_Type := Spare;
      end record;
   pragma Pack(Rx_Gps_307_Type);
   for Rx_Gps_307_Type'Size use 32;

   --   LABEL - 100N   HEX ID - 25   SELECTED COURSE   (BNR)
   --                           BIT STATUS
   --   BIT NO. FUNCTION        ONE     ZERO
   --   01-08   LABEL
   --   09-10   SDI                     Pad Zeros
   --   11      SPARE           Pad Zero
   --   12-13   CRS KNOB COMMAND RELAY
   --   13(0) 12(0) - No Command
   --   13(0) 12(1) - Two Commands From Control Panel Command
   --   13(1) 12(0) - One Command From Control Panel Command
   --   13(1) 12(1) - Control Panel Command
   --   14-28   BINARY ANGLE (180/32768)
   --   29      SIGN            180-360 Deg     0-180 Deg
   --   30-31   SSM
   --   32      PARITY (ODD)
   --   see: jpats_avionics-arinc-rx_crosstalk_100.ads

   --   LABEL - 101   HEX ID - 25   SELECTED HEADING   (BNR)
   --                           BIT STATUS
   --   BIT NO. FUNCTION        ONE     ZERO
   --   01-08   LABEL
   --   09-10   SDI                     Pad Zeros
   --   11      SPARE           Pad Zero
   --   12-13   HDG KNOB COMMAND RELAY
   --   13(0) 12(0) - No Command
   --   13(0) 12(1) - Two Commands From Control Panel Command
   --   13(1) 12(0) - One Command From Control Panel Command
   --   13(1) 12(1) - Control Panel Command
   --   14-28   BINARY ANGLE (180/32768)
   --   29      SIGN            180-360 Deg     0-180 Deg
   --   30-31   SSM
   --   32      PARITY (ODD)
   --see: jpats_avionics-arinc-rx_crosstalk_101.ads

   --   LABEL - 300N   HEX ID - 25   DISPLAY SOURCES   (DSC)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI                     Pad Zeros
   --11-14      NAV SOURCE
   --14(0) 13(0) 12(0) 11(0) - VOR without fields
   --14(0) 13(0) 12(0) 11(1) - VOR with fields
   --14(0) 13(0) 12(1) 11(0) - VOR1 without fields
   --14(0) 13(0) 12(1) 11(1) - VOR1 with fields
   --14(0) 13(1) 12(0) 11(0) - VOR2 without fields
   --14(0) 13(1) 12(0) 11(1) - VOR2 with fields
   --14(0) 13(1) 12(1) 11(0) - TACAN without fields
   --14(0) 13(1) 12(1) 11(1) - TACAN with fields
   --14(1) 13(0) 12(0) 11(0) - GPS without fields
   --14(1) 13(0) 12(0) 11(1) - GPS with fields
   --15 SPARE           Pad Zero
   --16-17      NAV SOURCE COMMAND RELAY
   --17(0) 16(0) - No Command
   --17(0) 16(1) - Two Commands From Control Panel Command
   --17(1) 16(0) - One Command From Control Panel Command
   --17(1) 16(1) - Control Panel Command
   --18-20      BEARING 1 SOURCE
   --20(0) 19(0) 18(0) - Declutter
   --20(0) 19(0) 18(1) - ADF
   --20(0) 19(1) 18(0) - VOR
   --20(0) 19(1) 18(1) - VOR1
   --20(1) 19(0) 18(0) - VOR2
   --20(1) 19(0) 18(1) - TACAN
   --20(1) 19(1) 18(0) - GPS
   --21 SPARE           Pad Zero
   --22-23      BEARING 1 SOURCE COMMAND RELAY
   --23(0) 22(0) - No Command
   --23(0) 22(1) - Two Commands From Control Panel Command
   --23(1) 22(0) - One Command From Control Panel Command
   --23(1) 22(1) - Control Panel Command
   --24-26      BEARING 2 SOURCE
   --26(0) 25(0) 24(0) - Declutter
   --26(0) 25(0) 24(1) - ADF
   --26(0) 25(1) 24(0) - VOR
   --26(0) 25(1) 24(1) - VOR1
   --26(1) 25(0) 24(0) - VOR2
   --26(1) 25(0) 24(1) - TACAN
   --26(1) 25(1) 24(0) - GPS
   --27 SPARE           Pad Zero
   --28-29      BEARING 2 SOURCE COMMAND RELAY
   --29(0) 28(0) - No Command
   --29(0) 28(1) - Two Commands From Control Panel Command
   --29(1) 28(0) - One Command From Control Panel Command
   --29(1) 28(1) - Control Panel Command
   --30-31      SSM
   --32 PARITY (ODD)
   --see: jpats_avionics-arinc-rx_crosstalk_300.ads

   --LABEL - 301N   HEX ID - 25   RANGE AND MODES   (DSC)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI                     Pad Zeros
   --11 GPS APPROACH OWN        Active  Inactive
   --12 GPS APPROACH ONSIDE     Active  Inactive
   --13 GPS APPROACH CROSS SIDE Active  Inactive
   --14 SPARE           Pad Zero
   --15-16      MAP MODE
   --16(0) 15(0) - Waypoints
   --16(0) 15(1) - Ground Stations
   --16(1) 15(0) - Airports
   --16(1) 15(1) - Ground Stations and Airports
   --17-18      SPARE           Pad Zero
   --19-20      MAP MODE COMMAND RELAY
   --20(0) 19(0) - No Command
   --20(0) 19(1) - Two Commands From Control Panel Command
   --20(1) 19(0) - One Command From Control Panel Command
   --20(1) 19(1) - Control Panel Command
   --21-24      RANGE
   --   24(0) 23(0) 22(0) 21(0) - 5
   --   24(0) 23(0) 22(0) 21(1) - 10
   --   24(0) 23(0) 22(1) 21(0) - 20
   --   24(0) 23(0) 22(1) 21(1) - 40
   --   24(0) 23(1) 22(0) 21(0) - 80
   --   24(0) 23(1) 22(0) 21(1) - 160
   --   24(0) 23(1) 22(1) 21(0) - 240
   --   24(0) 23(1) 22(1) 21(1) - 320
   --   24(1) 23(0) 22(0) 21(0) - 1000
   --25-26      SPARES          Pad Zeros
   --27-28      RANGE COMMAND RELAY
   --28(0) 27(0) - No Command
   --28(0) 27(1) - Two Commands From Control Panel Command
   --28(1) 27(0) - One Command From Control Panel Command
   --28(1) 27(1) - Control Panel Command
   --29 SPARE           Pad Zero
   --30-31      SSM
   --32 PARITY (ODD)
   --see: jpats_avionics-arinc-rx_crosstalk_301.ads

   --LABEL - 305N   HEX ID - 25  DISPLAY MODES AND STATUS   (DSC)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI
   --11-13      HSI DISPLAY MODE
   --13(0) 12(0) 11(0) - Composite
   --13(0) 12(0) 11(1) - 360
   --13(0) 12(1) 11(0) - 360-Map
   --13(0) 12(1) 11(1) - DG
   --13(1) 12(0) 11(0) - Arc
   --13(1) 12(0) 11(1) - Arc-Map
   --13(1) 12(1) 11(0) - No valid data
   --14 SPARE           Pad Zero
   --15-16      HSI DISPLAY MODE COMMAND RELAY
   --16(0) 15(0) - No Command
   --16(0) 15(1) - Two Commands From Control Panel Command
   --16(1) 15(0) - One Command From Control Panel Command
   --16(1) 15(1) - Control Panel Command
   --17-18      ADI DISPLAY MODE
   --18(0) 17(0) - Composite
   --   18(0) 17(1) - ADI
   --   18(1) 17(0) - No valid data
   --19 SPARE           Pad Zero
   --20-21      ADI DISPLAY MODE COMMAND RELAY
   --13(0) 12(0) - No Command
   --13(0) 12(1) - Two Commands From Control Panel Command
   --13(1) 12(0) - One Command From Control Panel Command
   --13(1) 12(1) - Control Panel Command
   --22 SPARE           Pad Zero
   --23 CONFIGURATION STRAP 1   Open    Ground
   --24 CONFIGURATION STRAP 2   Open    Ground
   --25 CONFIGURATION STRAP 3   Open    Ground
   --26 CROSS SIDE STATUS       Fail    Pass
   --27 ON SIDE STATUS  Fail    Pass
   --28 CONTROL PANEL (CP) STATUS       Fail    Pass
   --29 XTALK FLAG      Active  Inactive
   --30-31      SSM
   --32 PARITY (ODD)
   --see: jpats_avionics-arinc-rx_crosstalk_305.ads

   --     LABEL - 371   HEX ID - 25   EQUIP HEX ID CODE (DSC)
   --                                    BIT STATUS
   --       BIT NO.     FUNCTION        ONE     ZERO
   --       01-08       LABEL
   --       09-10       SDI
   --       11-14       LSD OF HEX ID (MSB IS 14) (5)
   --       15-18       MSD OF HEX ID (MSB IS 18) (2)
   --       19-24       BINARY COMPANY ID CODE (ASCAS=21)
   --       25-29       COMPANY PRIVATE
   --       30-31       SSM
   --         32        PARITY (ODD)

   --see: jpats_avionics-arinc-rx_crosstalk_371.ads

   --see: jpats_avionics-arinc-tx_crosstalk_100.ads
   --see: jpats_avionics-arinc-tx_crosstalk_101.ads
   --see: jpats_avionics-arinc-tx_crosstalk_300.ads
   --see: jpats_avionics-arinc-tx_crosstalk_301.ads
   --see: jpats_avionics-arinc-tx_crosstalk_303.ads
   --see: jpats_avionics-arinc-tx_crosstalk_305.ads
   --see: jpats_avionics-arinc-tx_crosstalk_371.ads

   --  LABEL - 270   HEX ID - C5   CONTROL PANEL DISCRETES (DSC)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11       TEST KEY STATE  Key Pushed      Key Not Pushed
   --  12       HSI KEY STATE   Key Pushed      Key Not Pushed
   --  13       ARC KEY STATE   Key Pushed      Key Not Pushed
   --  14       NAV KEY STATE   Key Pushed      Key Not Pushed
   --  15       RANGE INCR KEY STATE    Key Pushed      Key Not Pushed
   --  16       RANGE DECR KEY STATE    Key Pushed      Key Not Pushed
   --  17       DOUBLE RMI KEY STATE    Key Pushed      Key Not Pushed
   --  18       SINGLE RMI KEY STATE    Key Pushed      Key Not Pushed
   --  19       MAP KEY STATE   Key Pushed      Key Not Pushed
   --  20       CRS PULL SWITCH STATE   Switch Pulled   Switch Not Pulled
   --  21       HDG PULL SWITCH  STATE  Switch Pulled   Switch Not Pulled
   --  22-27    SPARE           Pad Zeros
   --  28       Strap 1         Installed       Not Installed
   --  29       Strap 221       Installed       Not Installed
   --  30-31    SSM
   --  32       PARITY (ODD)

   --see: jpats_avionics-arinc-tx_cnt_pnl_270.ads

   --  LABEL - 271   HEX ID - C5 CONTROL PANEL KNOBS (DSC)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09       SPARE
   --  10-13    COURSE KNOB COUNTS/UNIT-SAMPLE-TIME  (Bit 14 MSB)
   --  14       COURSE KNOB DIRECTION   Neg. Direction  Pos. Direction
   --  15-18    HEADING KNOB COUNTS/UNIT-SAMPLE-TIME23 (Bit 19 MSB)
   --  19       HEADING KNOB DIRECTION  Neg. Direction  Pos. Direction
   --  20-23    SPARE1 KNOB COUNTS/UNIT-SAMPLE-TIME 23(Bit 24 MSB)
   --  24       SPARE1 KNOB DIRECTION   Neg. Direction  Pos. Direction
   --  25-28    SPARE2 KNOB COUNTS/UNIT-SAMPLE-TIME 23(Bit 29 MSB)
   --  29       SPARE2 KNOB DIRECTION   Neg. Direction  Pos. Direction
   --  30-31    SSM
   --  32       PARITY (ODD)

   --see: jpats_avionics-arinc-tx_cnt_pnl_271 is new

   --   LABEL - 270   HEX ID - 05   AHRS DISCRETES (DSC)
   --                              BIT STATUS
   --     BIT NO.  FUNCTION        ONE     ZERO
   --     01-08    LABEL
   --     09-10    SDI
   --     11       ALIGN MODE/READY        Aligning        Ready
   --     12       SPARE           Pad Zeros
   --     13       NORMAL MODE     Normal
   --     14       MAG HEADING/DG MODE     Mag Heading     DG Mode
   --     15       ATTITUDE        Invalid Valid
   --     16       AUTOPILOT HEADING INTERL        Invalid Valid
   --     17-18    SPARE           Pad Zeros
   --     19       AHRU            Fault   Normal
   --     20-29    SPARE           Pad Zeros
   --     30-31    SSM
   --     32       PARITY (ODD)

   --see: jpats_avionics-arinc-tx_ahrs_270.ads

   --LABEL - 320   HEX ID - 05   MAGNETIC HEADING (BNR)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI
   --11-13      SPARES          Pad Zeros
   --14-28      BINARY ANGLE (180/32768)
   --29         SIGN            180-360 Deg     0-180 Deg
   --30-31      SSM
   --32         PARITY (ODD)

   --see: jpats_avionics-arinc-tx_ahrs_320

   --LABEL - 324   HEX ID - 05   PITCH ANGLE (BNR)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI
   --11-14      SPARES          Pad Zeros
   --15-28      BINARY ANGLE (180/16384)
   --29         SIGN            Downward        Upward
   --30-31      SSM
   --32         PARITY (ODD)

   ---see: jpats_avionics-arinc-tx_ahrs_324.ads

   --LABEL - 325   HEX ID - 05   ROLL ANGLE (BNR)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI
   --11-14      SPARES          Pad Zeros
   --15-28      BINARY ANGLE (180/16384)
   --29         SIGN            Left Wing Down  Right Wing Down
   --30-31      SSM
   --32         PARITY (ODD)

   --see: jpats_avionics-arinc-tx_ahrs_325.ads

   --LABEL - 330   HEX ID - 05 BODY YAW/TURN RATE (BNR)
   --                           BIT STATUS
   --BIT NO.    FUNCTION        ONE     ZERO
   --01-08      LABEL
   --09-10      SDI
   --11-15      SPARES          Pad Zeros
   --16-28      DEGREES PER SECOND (128/8192)
   --29         SIGN            Nose Left       Nose Right
   --30-31      SSM
   --32         PARITY (ODD)

   --see: jpats_avionics-arinc-tx_ahrs_330.ads

--  6.4.1    Labels received from the GPS

   --  LABEL - 074   HEX ID - 0B   DATA RECORD HEADER (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-15    TOTAL BNR NUMBER OF RECORDS
   --  16-20    SPARES          Pad Zeros

   --  21       PRIOR RECORD CHANGE     Changed Unchanged
   --  22-29    SPARES          Pad Zeros
   --  30-31    SSM
   --  32       PARITY (ODD)

   --see: jpats_avionics-arinc-rx_gps_074.ads

   --  LABEL - 075   HEX ID - 0B   ACTIVE WPT FROM/TO DATA (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09       AUTO LEG / MAN OBS      Man / OBS       Auto / Leg
   --  10       MAG/TRUE REFERENCE      True    Magnetic
   --  11       RADAR WPT DISPLAYED     Not Displayed   Displayed
   --  12       LAT/LON / ILS MODE (Always Zero)        ILS     Earth Oriented
   --  13-16    TO WPT BCD MS BYTE
   --  17-20    FROM WPT BCD MS BYTE
   --  21-24    TO WPT BCD LS BYTE
   --  25-28    FROM WPT BCD LS BYTE
   --  29       SPARE           Pad Zero
   --  30-31    SSM
   --  32       PARITY (ODD)

   --see: jpats_avionics-arinc-rx_gps_075.ads

   --  LABEL - 100   HEX ID - 0B   SELECTED COURSE (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11       HSI CRS SEL MASTER CONTROL      LRN Ctl Not LRN Control
   --  12-28    BINARY ANGLE (180/131072)
   --  29       SIGN            180-360        0-180
   --  30-31    SSM
   --  32       PARITY (ODD)

   --see: jpats_avionics-arinc-rx_gps_100.ads

   --  LABEL - 113   HEX ID - 0B   MESSAGE CHECKSUM (BNR)16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-29    BINARY MESSAGE CHECKSUM
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_113.ads

   --  LABEL - 115   HEX ID - 0B   WAYPOINT BEARING  (TRUE) (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11-16    SPARES          Pad Zeros
   --  17-28    BINARY ANGLE (180/4096)
   --  29       SIGN            180-360        0-180
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_115.ads

   --  LABEL - 116   HEX ID - 0B   CROSS TRACK DISTANCE (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABELS
   --  09-10    SDI
   --  11-13    SPARES          Pad Zeros
   --  14-28    BINARY NAUT MI (128/32768)
   --  29       SIGN            Fly Right       Fly Left
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_116.ads

   --  LABEL - 147   HEX ID - 0B   MAGNETIC VARIATION (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11       SOURCE OF DATA  Pilot Entered   Computed
   --  12-28    BINARY ANGLE (180/131072)
   --  29       SIGN            West    East
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_147.ads

   --  LABEL - 251   HEX ID - 0B   DISTANCE TO GO (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABELS
   --  09-10    SDI
   --  11-12    SPARES          Pad Zeros
   --  13-28    BINARY NAUT MI (4096/65536)
   --  29       SIGN                    Always Zero
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_251.ads

   --  LABEL - 252   HEX ID - 0B   TIME TO GO (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABELS
   --  09-10    SDI
   --  11-19    SPARES          Pad Zeros
   --  20-28    BINARY MINUTES (512/512)
   --  29       SIGN                    Always Zero
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_252.ads

   --  LABEL - 261   HEX ID - 0B   GPS DISCRETE WORD 1 (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11-12    SPARES          Pad zeros
   --  13-19    RESERVED
   --  20       SPARE           Pad zero
   --  21       DEV SCALING IN TRANSITION       Yes     No
   --  22       LIN/ANG (FINAL APPROACH)                Always Zero
   --  23       APPR INTEGRITY (FINAL APRCH)    Valid   Invalid
   --  24       GPS INTEGRITY   Fail    Valid
   --  25-27    GPS ANNUNCIATION
   --    27(0) & 26(0) & 25(0) - ENROUTE
   --    27(0) & 26(0) & 25(1) - TERMINAL
   --    27(0) & 26(1) & 25(0) - APPROACH
   --    27(1) & 26(0) & 25(0) - OCEANIC
   --  28-29    SPARES
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_261.ads

   --  LABEL - 275   HEX ID - 0B   LONG RANGE NAV STATUS (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11       WAYPOINT ALERT  Wpt Alert       Not Alert
   --  12       DEAD RECKON (Always Zero)       Reckon  Not Reckon
   --  13       DIRECT TO       Selected        Not Selected
   --  14-15    MODE
   --   15(0) & 14(0) - RNAV ENR
   --   15(0) & 14(1) - RNAV APPR
   --   15(1) & 14(0) - NAV
   --   15(1) & 14(1) - ILS
   --  16       APPROACH COMPUTATIONS SELECTED  Approach        Not Approach
   --  17-21    SPARES          Pad Zeros
   --  22       INTEGRITY WARN          Always Zero
   --  23       TO              To      Not To
   --  24       FROM    From    Not From
   --  25       SELECTED CROSSTRACK WARN     Selected Not Selected(Always Zero)
   --  26       AIRPORT DISPLAY SELECTED        Selected        Not Selected
   --  27       MESSAGE ALERT   Alert   Not Alert
   --  28       TRUE/MAG        True    Magnetic
   --  29       HSI VALID (NAV WARN)    Valid   Nav Warn
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_275.ads

   --  LABEL - 300   HEX ID - 0B   STN MAG VAR, TYPE, AND CLASS (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  9-14     SPARES          Pad Zeros
   --  15       NON COLLOCATED DME (Always Zero)  Non Collocated  Same Location
   --  16       TUNED AND RECEIVED (Always Zero)  Received        Not Received
   --  17-23    STATION DECL BNR 2'S COMP 0'S (128/128)
   --  24       STATION DECLINATION SIGN        West    East
   --  25       VOR             VOR     Not VOR
   --  26       DME             DME     Not DME
   --  27       TACAN (Always Zero)     TACAN   Not TACAN
   --  28-29    CLASS
   --   29(0) & 28(0) - Low
   --   29(0) & 28(1) - High
   --   29(1) & 28(0) - Terminal
   --   29(1) & 28(1) - Undefined
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_300.ads

   --  LABEL - 303   HEX ID - 0B   MESSAGE LENGTH/TYPE/NUMBER (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-12    WORDS IN MESSAGE
   --  13-15    WAYPOINT/STATION TYPE
   --   15(0) & 14(0) & 13(0) - WAYPOINT
   --   15(0) & 14(0) & 13(1) - NAVAID
   --   15(0) & 14(1) & 13(0) - AIRPORT
   --  16       DATA RECORD     Off Route       On Route
   --  17-23    RECORD NUMBER (BNR)
   --  24       SPARE           Pad Zeros
   --  25       CENTER OF FLIGHT PLAN           Always Zero
   --  26       GAP IN FLIGHT PLAN      Wpt Before Gap  No Gap
   --  27-29    SPARE           Pad Zeros
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_303.ads

   --  LABEL - 304   HEX ID - 0B   MESSAGE CHARACTERS 1-3 (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-15    CHARACTER 1
   --  16-22    CHARACTER 2
   --  23-29    CHARACTER 3
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_304.ads

   --  LABEL - 305   HEX ID - 0B   MESSAGE CHARACTERS 4-6 (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-15    CHARACTER 4
   --  16-22    CHARACTER 5
   --  23-29    CHARACTER 6
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_305.ads

   --  LABEL - 306   HEX ID - 0B   NAV/WPT/APT LATITUDE (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-28    BINARY ANGLE (180/1048576)
   --  29       SIGN            South   North
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_306.ads

   --  LABEL - 307   HEX ID - 0B   NAV/WPT/APT LONGITUDE (BNR) 16
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-28    BINARY ANGLE (180/1048576)
   --  29       SIGN            West    East
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_307.ads

   --  LABEL - 310   HEX ID - 0B   PRESENT POSITION - LATITUDE (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-28    BINARY ANGLE (180/1048576)
   --  29       SIGN            South   North
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_310.ads

   --  LABEL - 311   HEX ID - 0B   PRESENT POSITION - LONGITUDE (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-28    BINARY ANGLE (180/1048576)
   --  29       SIGN            West    East
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_311.ads

   --  LABEL - 312   HEX ID - 0B   GROUND SPEED (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11-13    SPARES          Pad Zeros
   --  14-28    BINARY KNOTS (4096/32768)
   --  29       SIGN                    Always Zero
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_312.ads

   --  LABEL - 326   HEX ID - 0B   LATERAL SCALE FACTOR (BNR)
   --                           BIT STATUS
   --  BIT NO.  FUNCTION        ONE     ZERO
   --  01-08    LABEL
   --  09-10    SDI
   --  11-13    SPARES          Pad Zeros
   --  14-28    BINARY NAUT MI (128/32768)
   --  29       SIGN                    Always Zero
   --  30-31    SSM
   --  32       PARITY (ODD)
   --see: jpats_avionics-arinc-rx_gps_326.ads

   --The followng section defines the types for sending/receiving data
   --to/from the RMU 556.

   --                           2.2.3.1 Control messages

   --                   2.2.3.1.1 Poll

   --   Bit No. Function        Status
   --    0 -  7 Label
   --    8 - 15 Spare   0
   --   16      Destination is RMU 556 #1       0 = no, 1 = yes
   --   17      Destination is RMU 556 #2       0 = no, 1 = yes
   --   18      Destination is RMU 556 #3       0 = no, 1 = yes
   --   19      Destination is RMU 556 #4       0 = no, 1 = yes
   --   20      Destination is KDA 557 #1       0 = no, 1 = yes
   --   21      Destination is KDA 557 #2       0 = no, 1 = yes
   --   22 - 23 Spare   0
   --   24 - 26 Source  26 25 24
   --                    0  0  0  from undetermined RMU 556
   --                    0  0  1  from RMU 556 #1
   --                    0  1  0  from RMU 556 #2
   --                    0  1  1  from RMU 556 #3
   --                    1  0  0  from RMU 556 #4
   --                    1  0  1  from KDA 557 #1
   --                    1  1  0  from KDA 557 #2
   --   27      Control message type    0 = Poll
   --   28      Reserved        0
   --   29 - 30 Word type       30 29
   --                    1  1  Control message
   --   31      Parity (Odd)

   type Word is (Initial,Intermediate,Final,Control);
   for Word'Size use 2;
   type Source_Type is (Undetermined,Rmu_1,Rmu_2,Rmu_3,Rmu_4,Kda_1,Kda_2);
   for Source_Type'Size use 3;
   type Control_Message is (Poll,Ack);
   for Control_Message'Size use 1;

   type Rmu_Tx_Poll_Type is
      record
         Label                : Int7_Type;
         Sp8                  : Spare_Type := Spare;
         Sp9                  : Spare_Type := Spare;
         Sp10                 : Spare_Type := Spare;
         Sp11                 : Spare_Type := Spare;
         Sp12                 : Spare_Type := Spare;
         Sp13                 : Spare_Type := Spare;
         Sp14                 : Spare_Type := Spare;
         Sp15                 : Spare_Type := Spare;
         Dest_Rmu_1           : Boolean := False;
         Dest_Rmu_2           : Boolean := False;
         Dest_Rmu_3           : Boolean := False;
         Dest_Rmu_4           : Boolean := False;
         Dest_Kda_1           : Boolean := False;
         Dest_Kda_2           : Boolean := False;
         Sp22                 : Spare_Type := Spare;
         Sp23                 : Spare_Type := Spare;
         Source               : Source_Type;
         Control_Message_Type : Control_Message;
         Rsrvd1               : Spare_Type := Spare;
         Word_Type            : Word := initial;
         Parity               : Spare_Type := Spare;
      end record;

   for Rmu_Tx_Poll_Type use
      record
         Label                at 0 range 0 .. 7;
         Sp8                  at 0 range 8 .. 8;
         Sp9                  at 0 range 9 .. 9;
         Sp10                 at 0 range 10 .. 10;
         Sp11                 at 0 range 11 .. 11;
         Sp12                 at 0 range 12 .. 12;
         Sp13                 at 0 range 13 .. 13;
         Sp14                 at 0 range 14 .. 14;
         Sp15                 at 0 range 15 .. 15;
         Dest_Rmu_1           at 0 range 16 .. 16;
         Dest_Rmu_2           at 0 range 17 .. 17;
         Dest_Rmu_3           at 0 range 18 .. 18;
         Dest_Rmu_4           at 0 range 19 .. 19;
         Dest_Kda_1           at 0 range 20 .. 20;
         Dest_Kda_2           at 0 range 21 .. 21;
         Sp22                 at 0 range 22 .. 22;
         Sp23                 at 0 range 23 .. 23;
         Source               at 0 range 24 .. 26;
         Control_Message_Type at 0 range 27 .. 27;
         Rsrvd1               at 0 range 28 .. 28;
         Word_Type            at 0 range 29 .. 30;
         Parity               at 0 range 31 .. 31;
      end record;
   for Rmu_Tx_Poll_Type'Size use 32;

   --   2.2.3.1.2 Acknowledge

   --   Bit No. Function
   --    0 -  7 Label
   --    8 - 10 Acknowledge status      10 9 8
   --                    0 0 0  Acknowledge OK
   --                    0 0 1  Acknowledge not OK - Checksum error
   --                    0 1 0  Acknowledge not OK - Message length error
   --                    0 1 1  Acknowledge not OK - Message sequence error
   --                    1 0 0  Acknowledge not OK - Timing error
   --                    1 0 1  Acknowledge not OK - Undefined label error
   --   11 - 15 Spare   0
   --   16      Destination is RMU 556 #1       0 = no, 1 = yes
   --   17      Destination is RMU 556 #2       0 = no, 1 = yes
   --   18      Destination is RMU 556 #3       0 = no, 1 = yes
   --   19      Destination is RMU 556 #4       0 = no, 1 = yes
   --   20      Destination is KDA 557 #1       0 = no, 1 = yes
   --   21      Destination is KDA 557 #2       0 = no, 1 = yes
   --   22 - 23 Spare
   --   24 - 26 Source  26 25 24
   --                    0  0  0  from undetermined RMU 556
   --                    0  0  1  from RMU 556 #1
   --                    0  1  0  from RMU 556 #2
   --                    0  1  1  from RMU 556 #3
   --                    1  0  0  from RMU 556 #4
   --                    1  0  1  from KDA 557 #1
   --                    1  1  0  from KDA 557 #2
   --   27      Control message type    1 = acknowledge
   --   28      Reserved        0
   --   29 - 30 Word type       30 29
   --                    1  1  Control message
   --   31      Parity (Odd)
   type Ack_Status_Type is (Ok,Checksum,Length,Sequence,Timing,Undefined);
   for Ack_Status_Type'Size use 3;

   type Acknowledge_Type is
      record
         Label                : Int8_Type := 0;
         Ack_Status           : Ack_Status_Type;
         Sp11                 : Spare_Type := Spare;
         Sp12                 : Spare_Type := Spare;
         Sp13                 : Spare_Type := Spare;
         Sp14                 : Spare_Type := Spare;
         Sp15                 : Spare_Type := Spare;
         Dest_Rmu_1           : Boolean := False;
         Dest_Rmu_2           : Boolean := False;
         Dest_Rmu_3           : Boolean := False;
         Dest_Rmu_4           : Boolean := False;
         Dest_Kda_1           : Boolean := False;
         Dest_Kda_2           : Boolean := False;
         Sp22                 : Spare_Type := Spare;
         Sp23                 : Spare_Type := Spare;
         Source               : Source_Type;
         Control_Message_Type : Control_Message;
         Rsrvd28              : Spare_Type := Spare;
         Word_Type            : Word := initial;
         Parity               : Spare_Type := Spare;
      end record;

   for Acknowledge_Type use
      record
         Label                at 0 range 0 .. 7;
         Ack_Status           at 0 range 8 .. 10;
         Sp11                 at 0 range 11 .. 11;
         Sp12                 at 0 range 12 .. 12;
         Sp13                 at 0 range 13 .. 13;
         Sp14                 at 0 range 14 .. 14;
         Sp15                 at 0 range 15 .. 15;
         Dest_Rmu_1           at 0 range 16 .. 16;
         Dest_Rmu_2           at 0 range 17 .. 17;
         Dest_Rmu_3           at 0 range 18 .. 18;
         Dest_Rmu_4           at 0 range 19 .. 19;
         Dest_Kda_1           at 0 range 20 .. 20;
         Dest_Kda_2           at 0 range 21 .. 21;
         Sp22                 at 0 range 22 .. 22;
         Sp23                 at 0 range 23 .. 23;
         Source               at 0 range 24 .. 26;
         Control_Message_Type at 0 range 27 .. 27;
         Rsrvd28              at 0 range 28 .. 28;
         Word_Type            at 0 range 29 .. 30;
         Parity               at 0 range 31 .. 31;
      end record;
   for Acknowledge_Type'Size use 32;
   Acknowledge : Acknowledge_Type;

   --   2.2.3.2 Data messages

   --   2.2.3.2.1 Initial word

   --   Bit No. Function        Status
   --    0 -  7 Label
   --    8 - 15 Number of words to follow=>
   --           binary count of number of intermedate words + final word
   --   16      Destination is RMU 556 #1       0 = no, 1 = yes
   --   17      Destination is RMU 556 #2       0 = no, 1 = yes
   --   18      Destination is RMU 556 #3       0 = no, 1 = yes
   --   19      Destination is RMU 556 #4       0 = no, 1 = yes
   --   20      Destination is KDA 557 #1       0 = no, 1 = yes
   --   21      Destination is KDA 557 #2       0 = no, 1 = yes
   --   22 - 23 Spare
   --   24 - 26 Source  26 25 24
   --                    0  0  0  from undetermined RMU 556
   --                    0  0  1  from RMU 556 #1
   --                    0  1  0  from RMU 556 #2
   --                    0  1  1  from RMU 556 #3
   --                    1  0  0  from RMU 556 #4
   --                    1  0  1  from KDA 557 #1
   --                    1  1  0  from KDA 557 #2
   --   27      Spare   0
   --   28      Reserved        0
   --   29 - 30 Word type       30 29
   --                    0  0  Initial word
   --   31      Parity (Odd)

   type Initial_Word_Type is
      record
         Label            : Int8_Type := 0;
         Number_Of_Words  : Int8_Type := 0;
         Dest_Rmu_1       : Boolean := False;
         Dest_Rmu_2       : Boolean := False;
         Dest_Rmu_3       : Boolean := False;
         Dest_Rmu_4       : Boolean := False;
         Dest_Kda_1       : Boolean := False;
         Dest_Kda_2       : Boolean := False;
         Sp22             : Spare_Type := Spare;
         Sp23             : Spare_Type := Spare;
         Source           : Source_Type;
         Sp27             : Spare_Type := Spare;
         Rsrvd28          : Spare_Type := Spare;
         Word_Type        : Word := initial;
         Parity           : Spare_Type := Spare;
      end record;

   for Initial_Word_Type use
      record
         Label            at 0 range 0 .. 7;
         Number_Of_Words  at 0 range 8 .. 15;
         Dest_Rmu_1       at 0 range 16 .. 16;
         Dest_Rmu_2       at 0 range 17 .. 17;
         Dest_Rmu_3       at 0 range 18 .. 18;
         Dest_Rmu_4       at 0 range 19 .. 19;
         Dest_Kda_1       at 0 range 20 .. 20;
         Dest_Kda_2       at 0 range 21 .. 21;
         Sp22             at 0 range 22 .. 22;
         Sp23             at 0 range 23 .. 23;
         Source           at 0 range 24 .. 26;
         Sp27             at 0 range 27 .. 27;
         Rsrvd28          at 0 range 28 .. 28;
         Word_Type        at 0 range 29 .. 30;
         Parity           at 0 range 31 .. 31;
      end record;
   for Initial_Word_Type'Size use 32;
   Initial_Word : Initial_Word_Type;

   --   2.2.3.2.2 Intermediate word
   --   Bit No. Function        Status
   --    0 - 28 Data    application specific
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   2.2.3.2.3 Final word
   --   Bit No. Function        Status
   --    0 -  7 Label
   --    8 - 15 Checksum
   --   16 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            1  0  Final word
   --   31      Parity (Odd)
   type Byte_Type is mod 2**8;
   type Final_Word_Type is
      record
         Label     : Int8_Type := 0;
         Checksum  : Byte_Type;
         Sp16      : Spare_Type := Spare;
         Sp17      : Spare_Type := Spare;
         Sp18      : Spare_Type := Spare;
         Sp19      : Spare_Type := Spare;
         Sp20      : Spare_Type := Spare;
         Sp21      : Spare_Type := Spare;
         Sp22      : Spare_Type := Spare;
         Sp23      : Spare_Type := Spare;
         Sp24      : Spare_Type := Spare;
         Sp25      : Spare_Type := Spare;
         Sp26      : Spare_Type := Spare;
         Sp27      : Spare_Type := Spare;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := initial;
         Parity    : Spare_Type := Spare;
      end record;

   for Final_Word_Type use
      record
         Label     at 0 range 0 .. 7;
         Checksum  at 0 range 8 .. 15;
         Sp16      at 0 range 16 .. 16;
         Sp17      at 0 range 17 .. 17;
         Sp18      at 0 range 18 .. 18;
         Sp19      at 0 range 19 .. 19;
         Sp20      at 0 range 20 .. 20;
         Sp21      at 0 range 21 .. 21;
         Sp22      at 0 range 22 .. 22;
         Sp23      at 0 range 23 .. 23;
         Sp24      at 0 range 24 .. 24;
         Sp25      at 0 range 25 .. 25;
         Sp26      at 0 range 26 .. 26;
         Sp27      at 0 range 27 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Final_Word_Type'Size use 32;
   Final_Word : Final_Word_Type;

   --   2.3.2.1 VHF COM active data

   --   This definition applies to the following label(s):
   --           Label (hex)     Function
   --           00      VHF COM #1 active data
   --           01      VHF COM #2 active data
   --           02      VHF COM #3 active data

   --   2.3.2.1.1 Intermediate word #1

   --   Bit No. Function        Status
   --    0 -  1         Status  1 0
   --                   0 0  normal operation
   --                   0 1  radio input and output different
   --                   1 0  invalid data received
   --                   1 1  no data received
   --    2      Squelch 0 = squelched, 1 = not squelched
   --    3      Push to talk (from KDA 557 only)  0 = inactive, 1 = active
   --    4 -  7 Spare   0
   --    8 - 11 0.001 MHz
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.

   type Vhf_Com_Active_Inter_1_Type is
      record
         Status        : Jat.Status_Type;
         Not_Squelched : Boolean := False;
         Push_To_Talk  : Boolean := False;
         Sp4           : Spare_Type := Spare;
         Sp5           : Spare_Type := Spare;
         Sp6           : Spare_Type := Spare;
         Sp7           : Spare_Type := Spare;
         Mhzp001       : Int4_Type := 0;
         Mhzp01        : Int4_Type := 0;
         Mhzp1         : Int4_Type := 0;
         Mhz1          : Int4_Type := 8;
         Mhz10         : Int4_Type := 1;
         Sp28          : Spare_Type := Spare;
         Word_Type     : Word := initial;
         Parity        : Spare_Type := Spare;
      end record;

   for Vhf_Com_Active_Inter_1_Type use
      record
         Status        at 0 range 0 .. 1;
         Not_Squelched at 0 range 2 .. 2;
         Push_To_Talk  at 0 range 3 .. 3;
         Sp4           at 0 range 4 .. 4;
         Sp5           at 0 range 5 .. 5;
         Sp6           at 0 range 6 .. 6;
         Sp7           at 0 range 7 .. 7;
         Mhzp001       at 0 range 8 .. 11;
         Mhzp01        at 0 range 12 .. 15;
         Mhzp1         at 0 range 16 .. 19;
         Mhz1          at 0 range 20 .. 23;
         Mhz10         at 0 range 24 .. 27;
         Sp28          at 0 range 28 .. 28;
         Word_Type     at 0 range 29 .. 30;
         Parity        at 0 range 31 .. 31;
      end record;
   for Vhf_Com_Active_Inter_1_Type'Size use 32;
   Vhf_Com_Active_Inter_1 : Vhf_Com_Active_Inter_1_Type;

   -- 2.3.2.2 UHF COM active data

   -- This definition applies to the following label(s):

   -- Label (hex)     Function
   --         03      UHF COM #1 active data
   --         04      UHF COM #2 active data

   -- 2.3.2.2.1 Intermediate word #1
   -- Bit No. Function        Status
   -- 0 -  1         Status  1 0
   --                        0 0  normal operation
   --                        0 1  radio input and output different
   --                        1 0  invalid data received
   --                        1 1  no data received
   -- 2      Squelch 0 = squelched, 1 = not squelched
   -- 3      Push to talk (from KDA 557 only)        0 = inactive, 1 = active
   -- 4 -  8 Channel Binary
   --                        Range = 1 to 20
   -- 9 - 10 0.025 MHz       10 9
   --                        0 0  0.000 MHz
   --                        0 1  0.025 MHz
   --                        1 0  0.050 MHz
   --                        1 1  0.075 MHz
   -- 11      Spare   0
   -- 12 - 15 0.1 MHz
   -- 16 - 19 1.0 MHz
   -- 20 - 23 10.0 MHz
   -- 24 - 27 100.0 MHz
   -- 28      Spare   0
   -- 29 - 30 Word type       30 29
   --                          0  1  Intermediate word
   -- 31      Parity (Odd)


   -- 2.3.2.2.2 Intermediate word #2
   --           Bit No. Function        Status
   --           0 -  1         Mode    1 0
   --                                  0 0  Main
   --                                  0 1  Both
   --                                  1 0  ADF
   --           2 -  3 Frequency mode  3 2
   --                                  0 0  Active
   --                                  0 1  Guard
   --                                  1 0  Manual
   --                                  1 1  Preset
   --      4      Time of day     0 = inactive, 1 = active
   --      5      Bandwidth       0 = narrowband, 1 = wideband
   --      6      Tone    0 = off, 1 = on
   --      7      Microphone key stuck    0 = not stuck, 1 = stuck
   --      8 - 9 Radio state     9 8
   --                            0 0  Receiving on main frequency
   --                            0 1  Transmitting on main frequency
   --                            1 0  Receiving on guard frequency
   --                            1 1  Transmitting semi-duplex
   --     10 - 28 Spare   0
   --     29 - 30 Word type       30 29
   --                              0  1  Intermediate word
   --     31      Parity (Odd)

   type Uhf_Com_Active_Inter_1_Type is
      record
         Status        : Jat.Status_Type;
         Not_Squelched : Boolean := False;
         Push_To_Talk  : Boolean := False;
         Channel       : Int5_Type := 0;
         Mhzp025       : Int2_Type := 0;
         Sp11          : Spare_Type := Spare;
         Mhzp1         : Int4_Type := 0;
         Mhz1          : Int4_Type := 5;
         Mhz10         : Int4_Type := 4;
         Mhz100        : Int4_Type := 2;
         Sp28          : Spare_Type := Spare;
         Word_Type     : Word := Initial;
         Parity        : Spare_Type := Spare;
      end record;

   for Uhf_Com_Active_Inter_1_Type use
      record
         Status        at 0 range 0 .. 1;
         Not_Squelched at 0 range 2 .. 2;
         Push_To_Talk  at 0 range 3 .. 3;
         Channel       at 0 range 4 .. 8;
         Mhzp025       at 0 range 9 .. 10;
         Sp11          at 0 range 11 .. 11;
         Mhzp1         at 0 range 12 .. 15;
         Mhz1          at 0 range 16 .. 19;
         Mhz10         at 0 range 20 .. 23;
         Mhz100        at 0 range 24 .. 27;
         Sp28          at 0 range 28 .. 28;
         Word_Type     at 0 range 29 .. 30;
         Parity        at 0 range 31 .. 31;
      end record;
   for Uhf_Com_Active_Inter_1_Type'Size use 32;
   Uhf_Com_Active_Inter_1 : Uhf_Com_Active_Inter_1_Type;

   type Uhf_Com_Active_Inter_2_Type is
      record
         Mode               : Jat.Uhf_Mode_Type;
         Frequency_Mode     : Jat.Uhf_Frequency_Mode_Type := Jat.Manual;
         Time_Of_Day_Active : Boolean := False;
         Bandwidth_Wide     : Boolean := False;
         Tone_On            : Boolean := False;
         Mic_Key_Stuck      : Boolean := False;
         Radio_State        : Jat.Uhf_Radio_State_Type;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Sp12               : Spare_Type := Spare;
         Sp13               : Spare_Type := Spare;
         Sp14               : Spare_Type := Spare;
         Sp15               : Spare_Type := Spare;
         Sp16               : Spare_Type := Spare;
         Sp17               : Spare_Type := Spare;
         Sp18               : Spare_Type := Spare;
         Sp19               : Spare_Type := Spare;
         Sp20               : Spare_Type := Spare;
         Sp21               : Spare_Type := Spare;
         Sp22               : Spare_Type := Spare;
         Sp23               : Spare_Type := Spare;
         Sp24               : Spare_Type := Spare;
         Sp25               : Spare_Type := Spare;
         Sp26               : Spare_Type := Spare;
         Sp27               : Spare_Type := Spare;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := initial;
         Parity             : Spare_Type := Spare;
      end record;
   for Uhf_Com_Active_Inter_2_Type use
      record
         Mode               at 0 range 0 .. 1;
         Frequency_Mode     at 0 range 2 .. 3;
         Time_Of_Day_Active at 0 range 4 .. 4;
         Bandwidth_Wide     at 0 range 5 .. 5;
         Tone_On            at 0 range 6 .. 6;
         Mic_Key_Stuck      at 0 range 7 .. 7;
         Radio_State        at 0 range 8 .. 9;
         Sp10               at 0 range 10 .. 10;
         Sp11               at 0 range 11 .. 11;
         Sp12               at 0 range 12 .. 12;
         Sp13               at 0 range 13 .. 13;
         Sp14               at 0 range 14 .. 14;
         Sp15               at 0 range 15 .. 15;
         Sp16               at 0 range 16 .. 16;
         Sp17               at 0 range 17 .. 17;
         Sp18               at 0 range 18 .. 18;
         Sp19               at 0 range 19 .. 19;
         Sp20               at 0 range 20 .. 20;
         Sp21               at 0 range 21 .. 21;
         Sp22               at 0 range 22 .. 22;
         Sp23               at 0 range 23 .. 23;
         Sp24               at 0 range 24 .. 24;
         Sp25               at 0 range 25 .. 25;
         Sp26               at 0 range 26 .. 26;
         Sp27               at 0 range 27 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Uhf_Com_Active_Inter_2_Type'Size use 32;
   Uhf_Com_Active_Inter_2 : Uhf_Com_Active_Inter_2_Type;

   type Uhf_Com_Freq_124_Type is
      record
         Hundreths_Uhf_Mhz  :  Int4_Type := 0;
         Tenths_Uhf_Mhz     :  Int4_Type := 0;
         Ones_Uhf_Mhz       :  Int4_Type := 0;
         Tens_Uhf_Mhz       :  Int4_Type := 0;
         Hundreds_Uhf_Mhz   :  Int2_Type := 0;
         Stupid_Mic_Key_Bit_At_The_29th_Space  : Boolean := False;
      end record;
   for Uhf_Com_Freq_124_Type use
      record
         Hundreths_Uhf_Mhz  at 0 range 0 .. 3;
         Tenths_Uhf_Mhz     at 0 range 4 .. 7;
         Ones_Uhf_Mhz       at 0 range 8 .. 11;
         Tens_Uhf_Mhz       at 0 range 12 .. 15;
         Hundreds_Uhf_Mhz   at 0 range 16 .. 17;
         Stupid_Mic_Key_Bit_At_The_29th_Space at 0 range 18 .. 18;
      end record;

   type Uhf_Com_Chan_124_Type is
      record
         Sp11                : Spare_Type := Spare;
         Sp12                : Spare_Type := Spare;
         Sp13                : Spare_Type := Spare;
         Sp14                : Spare_Type := Spare;
         Sp15                : Spare_Type := Spare;
         Sp16                : Spare_Type := Spare;
         Sp17                : Spare_Type := Spare;
         Sp18                : Spare_Type := Spare;
         Sp19                : Spare_Type := Spare;
         Sp20                : Spare_Type := Spare;
         Sp21                : Spare_Type := Spare;
         Sp22                : Spare_Type := Spare;
         Uhf_Channel_Set     : Int5_Type := 0;
         Mode                : Jat.Backup_Uhf_Mode_Type := Jat.Main;
      end record;
   for Uhf_Com_Chan_124_Type use
      record
         Sp11                at 0 range 0 .. 0;
         Sp12                at 0 range 1 .. 1;
         Sp13                at 0 range 2 .. 2;
         Sp14                at 0 range 3 .. 3;
         Sp15                at 0 range 4 .. 4;
         Sp16                at 0 range 5 .. 5;
         Sp17                at 0 range 6 .. 6;
         Sp18                at 0 range 7 .. 7;
         Sp19                at 0 range 8 .. 8;
         Sp20                at 0 range 9 .. 9;
         Sp21                at 0 range 10 .. 10;
         Sp22                at 0 range 11 .. 11;
         Uhf_Channel_Set     at 0 range 12 .. 16;
         Mode                at 0 range 17 .. 18;
      end record;

   --   2.3.2.4 NAV active data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           07      NAV #1 active data
   --           08      NAV #2 active data

   --   2.3.2.4.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 -  1         Status  1 0
   --                   0 0  normal operation
   --                   0 1  radio input and output different
   --                   1 0  invalid data received
   --                   1 1  no data received
   --    2      VOR/ILS 0 = VOR, 1 = ILS
   --    3 - 11 Spare   0
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.

   type Nav_Active_Inter_1_Type is
      record
         Status    : Jat.Status_Type;
         Ils       : Boolean := False;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Sp8       : Spare_Type := Spare;
         Sp9       : Spare_Type := Spare;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Mhzp01    : Int4_Type := 0;
         Mhzp1     : Int4_Type := 1;
         Mhz1      : Int4_Type := 5;
         Mhz10     : Int4_Type := 1;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := initial;
         Parity    : Spare_Type := Spare;
      end record;
   for Nav_Active_Inter_1_Type use
      record
         Status    at 0 range 0 .. 1;
         Ils       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Sp8       at 0 range 8 .. 8;
         Sp9       at 0 range 9 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Mhzp01    at 0 range 12 .. 15;
         Mhzp1     at 0 range 16 .. 19;
         Mhz1      at 0 range 20 .. 23;
         Mhz10     at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Nav_Active_Inter_1_Type'Size use 32;
   Nav_Active_Inter_1 : Nav_Active_Inter_1_Type;

   --   2.3.2.5 DME active data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           09      DME #1 active data
   --           0A      DME #2 active data

   --   2.3.2.5.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 -  1         Status  1 0
   --                   0 0  normal operation
   --                   0 1  radio input and output different
   --                   1 0  invalid data received
   --                   1 1  no data received
   --    2      MLS control     0 = MLS not in control, 1 = MLS in control
   --    3      DME hold        0 = DME hold inactive, 1 = DME hold active
   --    4      Box     0 = DME #1, 1 = DME #2 (from KDA 557 only)
   --    5      MLS frequency   0 = false , 1 = true (from KDA 557 only)
   --    6 - 11 Spare   0
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.

   type Dme_Active_Inter_1_Type is
      record
         Status         : Jat.Status_Type;
         Mls_In_Control : Boolean := False;
         Dme_Hold       : Boolean := False;
         Box            : Boolean := False;
         Mls_Freq       : Boolean := False;
         Sp6            : Spare_Type := Spare;
         Sp7            : Spare_Type := Spare;
         Sp8            : Spare_Type := Spare;
         Sp9            : Spare_Type := Spare;
         Sp10           : Spare_Type := Spare;
         Sp11           : Spare_Type := Spare;
         Mhzp01         : Int4_Type := 0;
         Mhzp1          : Int4_Type := 0;
         Mhz1           : Int4_Type := 0;
         Mhz10          : Int4_Type := 0;
         Sp28           : Spare_Type := Spare;
         Word_Type      : Word := initial;
         Parity         : Spare_Type := Spare;
      end record;
   for Dme_Active_Inter_1_Type use
      record
         Status         at 0 range 0 .. 1;
         Mls_In_Control at 0 range 2 .. 2;
         Dme_Hold       at 0 range 3 .. 3;
         Box            at 0 range 4 .. 4;
         Mls_Freq       at 0 range 5 .. 5;
         Sp6            at 0 range 6 .. 6;
         Sp7            at 0 range 7 .. 7;
         Sp8            at 0 range 8 .. 8;
         Sp9            at 0 range 9 .. 9;
         Sp10           at 0 range 10 .. 10;
         Sp11           at 0 range 11 .. 11;
         Mhzp01         at 0 range 12 .. 15;
         Mhzp1          at 0 range 16 .. 19;
         Mhz1           at 0 range 20 .. 23;
         Mhz10          at 0 range 24 .. 27;
         Sp28           at 0 range 28 .. 28;
         Word_Type      at 0 range 29 .. 30;
         Parity         at 0 range 31 .. 31;
      end record;
   for Dme_Active_Inter_1_Type'Size use 32;
   Dme_Active_Inter_1 : Dme_Active_Inter_1_Type;

   --   2.3.2.10 UHF COM preset channel data

   --This contains preset channel data for the UHF COM. There can be from 0 to
   --6 preset channels used. The number of words to follow field in the inital
   --word shall be used to indicate the number of channels that are used. If
   --no channels are used, an initial word, final word sequence with no
   --intermediate words shall be sent. This data shall not be transmitted to
   --the UHF COM radio by the KDA 557.

   --This definition applies to the following label(s):

   --  Label (hex)      Function
   --  13       UHF COM #1 preset channel data
   --  14       UHF COM #2 preset channel data

   --  2.3.2.10.1 Intermediate word
   --  Bit No.  Function        Status
   --  0 -  7   Spare   0
   --  8 -  9   0.025 MHz       9 8
   --           0 0      0.000 MHz
   --           0 1      0.025 MHz
   --           1 0      0.050 MHz
   --           1 1      0.075 MHz
   --  10 - 11  Spare   0
   --  12 - 15  0.1 MHz
   --  16 - 19  1.0 MHz
   --  20 - 23  10.0 MHz
   --  24 - 27  100.0 MHz
   --  28       Spare   0
   --  29 - 30  Word type       30 29
   --                            0  1  Intermediate word
   --  31       Parity (Odd)

   type Uhf_Preset_Channel_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Mhzp025   : Int2_Type  := 0;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Mhzp1     : Int4_Type := 0;
         Mhz1      : Int4_Type := 0;
         Mhz10     : Int4_Type := 0;
         Mhz100    : Int4_Type := 0;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := Initial;
         Parity    : Spare_Type := Spare;
      end record;
   for Uhf_Preset_Channel_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Mhzp025   at 0 range 8 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Mhzp1     at 0 range 12 .. 15;
         Mhz1      at 0 range 16 .. 19;
         Mhz10     at 0 range 20 .. 23;
         Mhz100    at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Uhf_Preset_Channel_Type'Size use 32;
   type Uhf_Preset_Channel_Array is array (1 .. 6) of Uhf_Preset_Channel_Type;
   Uhf_Preset_Channel : Uhf_Preset_Channel_Array;

   --   2.3.3 Current data words

   --      2.3.3.1 General current data

   --      This contains the general state of the RMU 556.

   --      This definition applies to the following label(s):

   --      Label (hex)  Function
   --      20   General current data

   --      2.3.3.1.1 Intermediate word #1
   --      Bit No.      Function        Status
   --      0 -  2       SYS     state of SYS
   --      3 -  5       Active page     The current active page
   --      6    Memory page active      0 = inactive, 1 = active
   --      7    Spare   0
   --      8 - 15       Dim value
   --      16 - 18      Active field    The active field on the active page
   --      19 - 21      Memory page number
   --      22 - 23      Spare   0
   --      24 - 28      Memory number/field last edited
   --      29 - 30      Word type       30 29
   --                                    0  1  Intermediate word
   --      31   Parity (Odd)
   --      2.3.3.2 Screen data
   type General_Current_Data_Type is
      record
         Sys                     : Int3_Type  := 0;
         Active_Page             : Int3_Type  := 1;
         Memory_Page_Active      : Boolean    := False;
         Sp7                     : Spare_Type := Spare;
         Dim_Value               : Int8_Type  := 220;
         Active_Field            : Int3_Type  := 1;
         Memory_Page_Number      : Int3_Type  := 1;
         Sp22                    : Spare_Type := Spare;
         Sp23                    : Spare_Type := Spare;
         Memory_Number           : Int5_Type  := 1;
         Word_Type               : Word       := Intermediate;
         Parity                  : Spare_Type := Spare;
      end record;
   for General_Current_Data_Type use
      record
         Sys                     at 0 range 0 .. 2;
         Active_Page             at 0 range 3 .. 5;
         Memory_Page_Active      at 0 range 6 .. 6;
         Sp7                     at 0 range 7 .. 7;
         Dim_Value               at 0 range 8 .. 15;
         Active_Field            at 0 range 16 .. 18;
         Memory_Page_Number      at 0 range 19 .. 21;
         Sp22                    at 0 range 22 .. 22;
         Sp23                    at 0 range 23 .. 23;
         Memory_Number           at 0 range 24 .. 28;
         Word_Type               at 0 range 29 .. 30;
         Parity                  at 0 range 31 .. 31;
      end record;
   for General_Current_Data_Type'Size use 32;
   General_Current_Data : General_Current_Data_Type;

   --      This definition applies to the following label(s):

   --      Label (hex)  Function
   --      21   Screen data

   --      2.3.3.2.1 Intermediate word #1
   --      Bit No.      Function        Status
   --      0 -  7       Minimum DAC value       Binary
   --                   Range = 0 to 255
   --      8 - 14       X screen offset 2's complement
   --      15           X screen offset sign    0 = positive, 1 = negative
   --      16 - 22      Y screen offset 2's complement
   --      23           Y screen offset sign    0 = positive, 1 = negative
   --      24 - 28      Spare   0
   --      29 - 30      Word type       30 29
   --                                    0  1         Intermediate word
   --     31            Parity (Odd)
   type Screen_Data_Type is
      record
         Minimum_Dac_Value      : Int8_Type  := 60;
         X_Screen_Offset        : Int7_Type  := 5;
         X_Screen_Sign_Negative : Boolean    := False;
         Y_Screen_Offset        : Int7_Type  := 3;
         Y_Screen_Sign_Negative : Boolean    := False;
         Sp24                   : Spare_Type := Spare;
         Sp25                   : Spare_Type := Spare;
         Sp26                   : Spare_Type := Spare;
         Sp27                   : Spare_Type := Spare;
         Sp28                   : Spare_Type := Spare;
         Word_Type              : Word       := Intermediate;
         Parity                 : Spare_Type := Spare;
      end record;
   for Screen_Data_Type use
      record
         Minimum_Dac_Value      at 0 range 0 .. 7;
         X_Screen_Offset        at 0 range 8 .. 14;
         X_Screen_Sign_Negative at 0 range 15 .. 15;
         Y_Screen_Offset        at 0 range 16 .. 22;
         Y_Screen_Sign_Negative at 0 range 23 .. 23;
         Sp24                   at 0 range 24 .. 24;
         Sp25                   at 0 range 25 .. 25;
         Sp26                   at 0 range 26 .. 26;
         Sp27                   at 0 range 27 .. 27;
         Sp28                   at 0 range 28 .. 28;
         Word_Type              at 0 range 29 .. 30;
         Parity                 at 0 range 31 .. 31;
      end record;
   for Screen_Data_Type'Size use 32;
   Screen_Data : Screen_Data_Type;

   --   2.3.2.7 Transponder active data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           0D      Transponder #1 active data
   --           0E      Transponder #2 active data

   --   2.3.2.7.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 -  1         Status  1 0
   --                   0 0  normal operation
   --                   0 1  radio input and output different
   --                   1 0  invalid data received
   --                   1 1  no data received
   --    2      Ident   0 = ident off, 1 = ident on
   --    3 -  5 Transponder mode        5 4 3
   --                   0 0 0  STBY
   --                   0 0 1  ON
   --                   0 1 0  ALT
   --                   0 1 1  TA
   --                   1 0 0  TA/RA
   --    6      Test    0 = inactive, 1 = active
   --    7 - 11 Spare   0
   --   12 - 15 Transponder code digit D        Range = 0 to 7
   --             (least significant digit)
   --   16 - 19 Transponder code digit C        Range = 0 to 7
   --   20 - 23 Transponder code digit B        Range = 0 to 7
   --   24 - 27 Transponder code digit A        Range = 0 to 7
   --             (most significant digit)
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)

   --   2.3.2.7.2 Intermediate word #2
   --   Bit No. Function        Status
   --    0      Flight level    0 = Relative, 1 = absolute
   --    1 -  2 Altitude select 3 2
   --                   0 0  Normal
   --                   0 1  Above
   --                   1 0  Below
   --                   1 1  Not used
   --    3 - 15 Spare   0
   --   16 - 23 TCAS range (BNR nautical miles) Full scale = 127.5
   --                   LSbit = 0.5
   --                   Always positive
   --   24 - 27 User defined TCAS display mode  0
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Xpdr_Active_Inter_1_Type is
      record
         Status         : Jat.Status_Type;
         Ident_On       : Boolean := False;
         Mode           : Jat.Xpdr_Mode_Select_Type;
         Test_Active    : Boolean := False;
         Sp7            : Spare_Type := Spare;
         Sp8            : Spare_Type := Spare;
         Sp9            : Spare_Type := Spare;
         Sp10           : Spare_Type := Spare;
         Sp11           : Spare_Type := Spare;
         Code_Digit_D   : Int4_Type := 0;
         Code_Digit_C   : Int4_Type := 0;
         Code_Digit_B   : Int4_Type := 0;
         Code_Digit_A   : Int4_Type := 0;
         Sp28           : Spare_Type := Spare;
         Word_Type      : Word := initial;
         Parity         : Spare_Type := Spare;
      end record;
   for Xpdr_Active_Inter_1_Type use
      record
         Status         at 0 range 0 .. 1;
         Ident_On       at 0 range 2 .. 2;
         Mode           at 0 range 3 .. 5;
         Test_Active    at 0 range 6 .. 6;
         Sp7            at 0 range 7 .. 7;
         Sp8            at 0 range 8 .. 8;
         Sp9            at 0 range 9 .. 9;
         Sp10           at 0 range 10 .. 10;
         Sp11           at 0 range 11 .. 11;
         Code_Digit_D   at 0 range 12 .. 15;
         Code_Digit_C   at 0 range 16 .. 19;
         Code_Digit_B   at 0 range 20 .. 23;
         Code_Digit_A   at 0 range 24 .. 27;
         Sp28           at 0 range 28 .. 28;
         Word_Type      at 0 range 29 .. 30;
         Parity         at 0 range 31 .. 31;
      end record;
   for Xpdr_Active_Inter_1_Type'Size use 32;
   Xpdr_Active_Inter_1 : Xpdr_Active_Inter_1_Type;

   type Flight_Level_Type is (Relative,Absolute);
   for Flight_Level_Type'Size use 1;
   type Altitude_Select_Type is (Normal,Above,Below,Not_Used);
   for Altitude_Select_Type'Size use 2;


   type Xpdr_Active_Inter_2_Type is
      record
         Flight_Level    : Flight_Level_Type;
         Altitude_Select : Altitude_Select_Type;
         Sp3             : Spare_Type := Spare;
         Sp4             : Spare_Type := Spare;
         Sp5             : Spare_Type := Spare;
         Sp6             : Spare_Type := Spare;
         Sp7             : Spare_Type := Spare;
         Sp8             : Spare_Type := Spare;
         Sp9             : Spare_Type := Spare;
         Sp10            : Spare_Type := Spare;
         Sp11            : Spare_Type := Spare;
         Sp12            : Spare_Type := Spare;
         Sp13            : Spare_Type := Spare;
         Sp14            : Spare_Type := Spare;
         Sp15            : Spare_Type := Spare;
         Sp16            : Spare_Type := Spare; --0.5 TCAS range => BNR,
                                                --full scale: 127.5
         Sp17            : Spare_Type := Spare; --1.0
         Sp18            : Spare_Type := Spare; --2.0
         Sp19            : Spare_Type := Spare; --4.0
         Sp20            : Spare_Type := Spare; --8.0
         Sp21            : Spare_Type := Spare; --16.0
         Sp22            : Spare_Type := Spare; --32.0
         Sp23            : Spare_Type := Spare; --64.0
         Sp24            : Spare_Type := Spare; --User defined TCAS disp mode 0
         Sp25            : Spare_Type := Spare; --
         Sp26            : Spare_Type := Spare; --
         Sp27            : Spare_Type := Spare; --
         Sp28            : Spare_Type := Spare;
         Word_Type       : Word := initial;
         Parity          : Spare_Type := Spare;
      end record;
   for Xpdr_Active_Inter_2_Type use
      record
         Flight_Level    at 0 range 0 .. 0;
         Altitude_Select at 0 range 1 .. 2;
         Sp3             at 0 range 3 .. 3;
         Sp4             at 0 range 4 .. 4;
         Sp5             at 0 range 5 .. 5;
         Sp6             at 0 range 6 .. 6;
         Sp7             at 0 range 7 .. 7;
         Sp8             at 0 range 8 .. 8;
         Sp9             at 0 range 9 .. 9;
         Sp10            at 0 range 10 .. 10;
         Sp11            at 0 range 11 .. 11;
         Sp12            at 0 range 12 .. 12;
         Sp13            at 0 range 13 .. 13;
         Sp14            at 0 range 14 .. 14;
         Sp15            at 0 range 15 .. 15;
         Sp16            at 0 range 16 .. 16;
         Sp17            at 0 range 17 .. 17;
         Sp18            at 0 range 18 .. 18;
         Sp19            at 0 range 19 .. 19;
         Sp20            at 0 range 20 .. 20;
         Sp21            at 0 range 21 .. 21;
         Sp22            at 0 range 22 .. 22;
         Sp23            at 0 range 23 .. 23;
         Sp24            at 0 range 24 .. 24;
         Sp25            at 0 range 25 .. 25;
         Sp26            at 0 range 26 .. 26;
         Sp27            at 0 range 27 .. 27;
         Sp28            at 0 range 28 .. 28;
         Word_Type       at 0 range 29 .. 30;
         Parity          at 0 range 31 .. 31;
      end record;
   for Xpdr_Active_Inter_2_Type'Size use 32;
   Xpdr_Active_Inter_2 : Xpdr_Active_Inter_2_Type;

   
   --   2.3.9 Flight ID

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     B1    Transponder Flight ID

   --     2.3.9 Intermediate word
   --     Bit No.       Function        Status
   --     0 - 7         Character 1 index
   --     8 - 15        Character 2 index
   --     16 - 23       Character 3 index
   --     20 - 28       Spare
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)

   --     The character data words are in the format of the associated ASCII code minus 32 (e.g. ASCII code for 0 is 48 with
   --     character data word 32). This can be also explained as below

   --     Character index is 8 bits composed of two 4 bit indices as follows b8b7b6b5 b4b3b2b1
   --     are used to be mapped to FLIGHT ID characters as follows:
   
   --            b4b3b2b1                           
   --     b8b7b6b5 0000	0001 0010 0011 0100 0101 0110 0111 1000 1001 1010 1011 1100 1101 1110 1111
   --     0 0 0 1    0    1    2    3    4    5    6    7    8    9
   --     0 0 1 0         A    B    C    D    E    F    G    H    I    J    K    L    M    N    O
   --     0 0 1 1    P    Q    R    S    T    U    V    W    X    Y    Z
   
   -- Which translates into the below array with indices showns here         0123456789.....16   ->   25.....33          ->            58
   Flight_ID_Map : constant array (Int8_Type range 0 .. 58) of Character := "                0123456789       ABCDEFGHIJKLMNOPQRSTUVWXYZ";
   				  
   type Xpdr_Flight_ID_Type is
      record
         Char1_Index     : Int8_Type  := 0;
         Char2_Index     : Int8_Type  := 0;
         Char3_Index     : Int8_Type  := 0;
         Sp24            : Spare_Type := Spare;
         Sp25            : Spare_Type := Spare;
         Sp26            : Spare_Type := Spare;
         Sp27            : Spare_Type := Spare;
         Sp28            : Spare_Type := Spare;
         Word_Type       : Word := Intermediate;
         Parity          : Spare_Type := Spare;
      end record;
   for Xpdr_Flight_ID_Type use
      record
         Char1_Index     at 0 range 0 .. 7;
         Char2_Index     at 0 range 8 .. 15;
         Char3_Index     at 0 range 16 .. 23;
         Sp24            at 0 range 24 .. 24;
         Sp25            at 0 range 25 .. 25;
         Sp26            at 0 range 26 .. 26;
         Sp27            at 0 range 27 .. 27;	 
         Sp28            at 0 range 28 .. 28;
         Word_Type       at 0 range 29 .. 30;
         Parity          at 0 range 31 .. 31;
      end record;
   for Xpdr_Flight_ID_Type'Size use 32;
   type Xpdr_Flight_ID_Array is array (1 .. 4) of Xpdr_Flight_ID_Type;
   Xpdr_Flight_ID : Xpdr_Flight_ID_Array;

   --   2.3.10 ADS-B Device Data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     B2            ADS-B Device Failure

   --     2.3.10.11 Intermediate word #1
   --       This contains ADS-B device failure status

   --     Bit No.	Function					Status
   --     0 	    XPDR Number					0 = ADS-B1, 1 = ADS-B2
   --     1	        Spare						0
   --     2	        Transponder Unit Failure 	0 = No failure, 1 = Failure 
   --     3 - 28	Spare						0
   --     29 - 30	Word type					30 29
   --     										0   1	Intermediate word
   --     31		Parity (Odd)
   				  
   type ADS_B_Device_Data_Type is
      record
         Xpdr_Number_2 : Boolean := False;
         Sp1           : Spare_Type := Spare;
         Xpdr_Fail     : Boolean := False;
         Sp3           : Spare_Type := Spare;
         Sp4           : Spare_Type := Spare;
         Sp5           : Spare_Type := Spare;
         Sp6           : Spare_Type := Spare;
         Sp7           : Spare_Type := Spare;
         Sp8           : Spare_Type := Spare;
         Sp9           : Spare_Type := Spare;
         Sp10          : Spare_Type := Spare;
         Sp11          : Spare_Type := Spare;
         Sp12          : Spare_Type := Spare;
         Sp13          : Spare_Type := Spare;
         Sp14          : Spare_Type := Spare;
         Sp15          : Spare_Type := Spare;
         Sp16          : Spare_Type := Spare;
         Sp17          : Spare_Type := Spare;
         Sp18          : Spare_Type := Spare;
         Sp19          : Spare_Type := Spare;
         Sp20          : Spare_Type := Spare;
         Sp21          : Spare_Type := Spare;
         Sp22          : Spare_Type := Spare;
         Sp23          : Spare_Type := Spare;
         Sp24          : Spare_Type := Spare;
         Sp25          : Spare_Type := Spare;
         Sp26          : Spare_Type := Spare;
         Sp27          : Spare_Type := Spare;
         Sp28          : Spare_Type := Spare;
         Word_Type     : Word := Intermediate;
         Parity        : Spare_Type := Spare;
      end record;
   for ADS_B_Device_Data_Type use
      record
         Xpdr_Number_2 at 0 range 0 .. 0;
         Sp1           at 0 range 1 .. 1;
         Xpdr_Fail     at 0 range 2 .. 2;
         Sp3           at 0 range 3 .. 3;
         Sp4           at 0 range 4 .. 4;
         Sp5           at 0 range 5 .. 5;
         Sp6           at 0 range 6 .. 6;
         Sp7           at 0 range 7 .. 7;
         Sp8           at 0 range 8 .. 8;
         Sp9           at 0 range 9 .. 9;
         Sp10          at 0 range 10 .. 10;
         Sp11          at 0 range 11 .. 11;
         Sp12          at 0 range 12 .. 12;
         Sp13          at 0 range 13 .. 13;
         Sp14          at 0 range 14 .. 14;
         Sp15          at 0 range 15 .. 15;
         Sp16          at 0 range 16 .. 16;
         Sp17          at 0 range 17 .. 17;
         Sp18          at 0 range 18 .. 18;
         Sp19          at 0 range 19 .. 19;
         Sp20          at 0 range 20 .. 20;
         Sp21          at 0 range 21 .. 21;
         Sp22          at 0 range 22 .. 22;
         Sp23          at 0 range 23 .. 23;
         Sp24          at 0 range 24 .. 24;
         Sp25          at 0 range 25 .. 25;
         Sp26          at 0 range 26 .. 26;
         Sp27          at 0 range 27 .. 27;
         Sp28          at 0 range 28 .. 28;
         Word_Type     at 0 range 29 .. 30;
         Parity        at 0 range 31 .. 31;
      end record;
   for ADS_B_Device_Data_Type'Size use 32;
   ADS_B_Device_Data : ADS_B_Device_Data_Type;

   --   2.3.11 ADS-B Function Data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     B2            ADS-B Function Failure

   --     2.3.10.11 Intermediate word #1
   --       This contains ADS-B function failure status

   --     Bit No.	Function					Status
   --     0 	    XPDR Number					0 = ADS-B1, 1 = ADS-B2
   --     1 - 5 	Spare						0
   --     6	        ADS-B Out Status		 	0 = No failure, 1 = Failure 
   --     7 - 28	Spare						0
   --     29 - 30	Word type					30 29
   --     										0   1	Intermediate word
   --     31		Parity (Odd)
   				  
   type ADS_B_Function_Data_Type is
      record
         Xpdr_Number_2 : Boolean := False;
         Sp1           : Spare_Type := Spare;
         Sp2           : Spare_Type := Spare;
         Sp3           : Spare_Type := Spare;
         Sp4           : Spare_Type := Spare;
         Sp5           : Spare_Type := Spare;
         ADSB_Out_Fail : Boolean := False;
         Sp7           : Spare_Type := Spare;
         Sp8           : Spare_Type := Spare;
         Sp9           : Spare_Type := Spare;
         Sp10          : Spare_Type := Spare;
         Sp11          : Spare_Type := Spare;
         Sp12          : Spare_Type := Spare;
         Sp13          : Spare_Type := Spare;
         Sp14          : Spare_Type := Spare;
         Sp15          : Spare_Type := Spare;
         Sp16          : Spare_Type := Spare;
         Sp17          : Spare_Type := Spare;
         Sp18          : Spare_Type := Spare;
         Sp19          : Spare_Type := Spare;
         Sp20          : Spare_Type := Spare;
         Sp21          : Spare_Type := Spare;
         Sp22          : Spare_Type := Spare;
         Sp23          : Spare_Type := Spare;
         Sp24          : Spare_Type := Spare;
         Sp25          : Spare_Type := Spare;
         Sp26          : Spare_Type := Spare;
         Sp27          : Spare_Type := Spare;
         Sp28          : Spare_Type := Spare;
         Word_Type     : Word := Intermediate;
         Parity        : Spare_Type := Spare;
      end record;
   for ADS_B_Function_Data_Type use
      record
         Xpdr_Number_2 at 0 range 0 .. 0;
         Sp1           at 0 range 1 .. 1;
         Sp2           at 0 range 2 .. 2;
         Sp3           at 0 range 3 .. 3;
         Sp4           at 0 range 4 .. 4;
         Sp5           at 0 range 5 .. 5;
         ADSB_Out_Fail at 0 range 6 .. 6;
         Sp7           at 0 range 7 .. 7;
         Sp8           at 0 range 8 .. 8;
         Sp9           at 0 range 9 .. 9;
         Sp10          at 0 range 10 .. 10;
         Sp11          at 0 range 11 .. 11;
         Sp12          at 0 range 12 .. 12;
         Sp13          at 0 range 13 .. 13;
         Sp14          at 0 range 14 .. 14;
         Sp15          at 0 range 15 .. 15;
         Sp16          at 0 range 16 .. 16;
         Sp17          at 0 range 17 .. 17;
         Sp18          at 0 range 18 .. 18;
         Sp19          at 0 range 19 .. 19;
         Sp20          at 0 range 20 .. 20;
         Sp21          at 0 range 21 .. 21;
         Sp22          at 0 range 22 .. 22;
         Sp23          at 0 range 23 .. 23;
         Sp24          at 0 range 24 .. 24;
         Sp25          at 0 range 25 .. 25;
         Sp26          at 0 range 26 .. 26;
         Sp27          at 0 range 27 .. 27;
         Sp28          at 0 range 28 .. 28;
         Word_Type     at 0 range 29 .. 30;
         Parity        at 0 range 31 .. 31;
      end record;
   for ADS_B_Function_Data_Type'Size use 32;
   ADS_B_Function_Data : ADS_B_Function_Data_Type;
    
   --   2.3.3.3 VHF COM current data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           22      VHF COM current data

   --   2.3.3.3.1 Intermediate word #1
   --   This contains the radio state and standby frequency.

   --   Bit No. Function        Status
   --    0      Direct tune     0 = inactive, 1 = active
   --    1      Memory mode     0 = inactive, 1 = active
   --    2 -  6 Memory number last in display
   --    7      Spare   0
   --    8 - 11 0.001 MHz
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.


   --   2.3.3.3.2 Intermediate word #2
   --   This word is temp frequency for memory mode.

   --   Bit No. Function        Status
   --    0 -  7 Spare   0
   --    8 - 11         0.001 MHz
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.

   type Vhf_Com_Current_Inter_1_Type is
      record
         Direct_Tune_Active : Boolean := False;
         Memory_Mode_Active : Boolean := False;
         Memory_Number      : Int5_Type := 1;
         Sp7                : Spare_Type := Spare;
         Mhzp001            : Int4_Type := 0;
         Mhzp01             : Int4_Type := 0;
         Mhzp1              : Int4_Type := 0;
         Mhz1               : Int4_Type := 8;
         Mhz10              : Int4_Type := 1;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := initial;
         Parity             : Spare_Type := Spare;
      end record;
   for Vhf_Com_Current_Inter_1_Type use
      record
         Direct_Tune_Active at 0 range 0 .. 0;
         Memory_Mode_Active at 0 range 1 .. 1;
         Memory_Number      at 0 range 2 .. 6;
         Sp7                at 0 range 7 .. 7;
         Mhzp001            at 0 range 8 .. 11;
         Mhzp01             at 0 range 12 .. 15;
         Mhzp1              at 0 range 16 .. 19;
         Mhz1               at 0 range 20 .. 23;
         Mhz10              at 0 range 24 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Vhf_Com_Current_Inter_1_Type'Size use 32;
   Vhf_Com_Current_Inter_1 : Vhf_Com_Current_Inter_1_Type;

   type Vhf_Com_Current_Inter_2_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Mhzp001   : Int4_Type := 0;
         Mhzp01    : Int4_Type := 0;
         Mhzp1     : Int4_Type := 0;
         Mhz1      : Int4_Type := 8;
         Mhz10     : Int4_Type := 1;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := initial;
         Parity    : Spare_Type := Spare;
      end record;
   for Vhf_Com_Current_Inter_2_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Mhzp001   at 0 range 8 .. 11;
         Mhzp01    at 0 range 12 .. 15;
         Mhzp1     at 0 range 16 .. 19;
         Mhz1      at 0 range 20 .. 23;
         Mhz10     at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Vhf_Com_Current_Inter_2_Type'Size use 32;
   Vhf_Com_Current_Inter_2 : Vhf_Com_Current_Inter_2_Type;

   --   2.3.3.4 UHF COM current data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           23      UHF COM current data

   --   2.3.3.4.1 Intermediate word #1
   --   This contains the radio state and standby frequency.

   --   Bit No. Function        Status
   --    0      Direct tune     0 = inactive, 1 = active
   --    1      Memory mode     0 = inactive, 1 = active
   --    2 -  6 Memory number last in display
   --    7      Spare   0
   --    8 -  9 0.025 MHz       9 8
   --                   0 0  0.000 MHz
   --                   0 1  0.025 MHz
   --                   1 0  0.050 MHz
   --                   1 1  0.075 MHz
   --   10 - 11 Spare   0
   --   12 - 15 0.1 MHz
   --   16 - 19 1.0 MHz
   --   20 - 23 10.0 MHz
   --   24 - 27 100.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)


   --   2.3.3.4.2 Intermediate word #2
   --   This word is temp frequency for memory mode.

   --   Bit No. Function        Status
   --    0 -  7 Spare   0
   --    8 -  9 0.025 MHz       9 8
   --                   0 0  0.000 MHz
   --                   0 1  0.025 MHz
   --                   1 0  0.050 MHz
   --                   1 1  0.075 MHz
   --   10 - 11 Spare   0
   --   12 - 15 0.1 MHz
   --   16 - 19 1.0 MHz
   --   20 - 23 10.0 MHz
   --   24 - 27 100.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)

   type Uhf_Com_Current_Inter_1_Type is
      record
         Direct_Tune_Active : Boolean := False;
         Memory_Mode_Active : Boolean := False;
         Memory_Number      : Int5_Type := 1;
         Sp7                : Spare_Type := Spare;
         Mhzp025            : Int2_Type;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Mhzp1              : Int4_Type := 0;
         Mhz1               : Int4_Type := 5;
         Mhz10              : Int4_Type := 4;
         Mhz100             : Int4_Type := 2;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := initial;
         Parity             : Spare_Type := Spare;
      end record;
   for Uhf_Com_Current_Inter_1_Type use
      record
         Direct_Tune_Active at 0 range 0 .. 0;
         Memory_Mode_Active at 0 range 1 .. 1;
         Memory_Number      at 0 range 2 .. 6;
         Sp7                at 0 range 7 .. 7;
         Mhzp025            at 0 range 8 .. 9;
         Sp10               at 0 range 10 .. 10;
         Sp11               at 0 range 11 .. 11;
         Mhzp1              at 0 range 12 .. 15;
         Mhz1               at 0 range 16 .. 19;
         Mhz10              at 0 range 20 .. 23;
         Mhz100             at 0 range 24 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Uhf_Com_Current_Inter_1_Type'Size use 32;
   Uhf_Com_Current_Inter_1 : Uhf_Com_Current_Inter_1_Type;

   type Uhf_Com_Current_Inter_2_Type is
      record
         Sp0                : Spare_Type := Spare;
         Sp1                : Spare_Type := Spare;
         Sp2                : Spare_Type := Spare;
         Sp3                : Spare_Type := Spare;
         Sp4                : Spare_Type := Spare;
         Sp5                : Spare_Type := Spare;
         Sp6                : Spare_Type := Spare;
         Sp7                : Spare_Type := Spare;
         Mhzp025            : Int2_Type;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Mhzp1              : Int4_Type := 0;
         Mhz1               : Int4_Type := 5;
         Mhz10              : Int4_Type := 4;
         Mhz100             : Int4_Type := 2;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := initial;
         Parity             : Spare_Type := Spare;
      end record;
   for Uhf_Com_Current_Inter_2_Type use
      record
         Sp0                at 0 range 0 .. 0;
         Sp1                at 0 range 1 .. 1;
         Sp2                at 0 range 2 .. 2;
         Sp3                at 0 range 3 .. 3;
         Sp4                at 0 range 4 .. 4;
         Sp5                at 0 range 5 .. 5;
         Sp6                at 0 range 6 .. 6;
         Sp7                at 0 range 7 .. 7;
         Mhzp025            at 0 range 8 .. 9;
         Sp10               at 0 range 10 .. 10;
         Sp11               at 0 range 11 .. 11;
         Mhzp1              at 0 range 12 .. 15;
         Mhz1               at 0 range 16 .. 19;
         Mhz10              at 0 range 20 .. 23;
         Mhz100             at 0 range 24 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Uhf_Com_Current_Inter_2_Type'Size use 32;
   Uhf_Com_Current_Inter_2 : Uhf_Com_Current_Inter_2_Type;

   --   2.3.3.6 NAV current data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           25      NAV current data

   --   2.3.3.6.1 Intermediate word #1
   --   This contains the radio state and standby frequency.

   --   Bit No. Function        Status
   --    0      Direct tune     0 = inactive, 1 = active
   --    1      Memory mode     0 = inactive, 1 = active
   --    2 -  6 Memory number last in display
   --    7 - 11 Spare   0
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.


   --   2.3.3.6.2 Intermediate word #2
   --   This word is temp frequency for memory mode.

   --   Bit No. Function        Status
   --    0 - 11 Spare   0
   --   12 - 15 0.01 MHz
   --   16 - 19 0.1 MHz
   --   20 - 23 1.0 MHz
   --   24 - 27 10.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   --   Note:   100 Mhz digit is not transmitted and is always 1.

   type Nav_Current_Inter_1_Type is
      record
         Direct_Tune_Active : Boolean := False;
         Memory_Mode_Active : Boolean := False;
         Memory_Number      : Int5_Type := 1;
         Sp7                : Spare_Type := Spare;
         Sp8                : Spare_Type := Spare;
         Sp9                : Spare_Type := Spare;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Mhzp01             : Int4_Type := 0;
         Mhzp1              : Int4_Type := 1;
         Mhz1               : Int4_Type := 5;
         Mhz10              : Int4_Type := 1;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := initial;
         Parity             : Spare_Type := Spare;
      end record;
   for Nav_Current_Inter_1_Type use
      record
         Direct_Tune_Active at 0 range 0 .. 0;
         Memory_Mode_Active at 0 range 1 .. 1;
         Memory_Number      at 0 range 2 .. 6;
         Sp7                at 0 range 7 .. 7;
         Sp8                at 0 range 8 .. 8;
         Sp9                at 0 range 9 .. 9;
         Sp10               at 0 range 10 .. 10;
         Sp11               at 0 range 11 .. 11;
         Mhzp01             at 0 range 12 .. 15;
         Mhzp1              at 0 range 16 .. 19;
         Mhz1               at 0 range 20 .. 23;
         Mhz10              at 0 range 24 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Nav_Current_Inter_1_Type'Size use 32;
   Nav_Current_Inter_1 : Nav_Current_Inter_1_Type;

   type Nav_Current_Inter_2_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Sp8       : Spare_Type := Spare;
         Sp9       : Spare_Type := Spare;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Mhzp01    : Int4_Type := 0;
         Mhzp1     : Int4_Type := 1;
         Mhz1      : Int4_Type := 5;
         Mhz10     : Int4_Type := 1;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := initial;
         Parity    : Spare_Type := Spare;
      end record;
   for Nav_Current_Inter_2_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Sp8       at 0 range 8 .. 8;
         Sp9       at 0 range 9 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Mhzp01    at 0 range 12 .. 15;
         Mhzp1     at 0 range 16 .. 19;
         Mhz1      at 0 range 20 .. 23;
         Mhz10     at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Nav_Current_Inter_2_Type'Size use 32;
   Nav_Current_Inter_2 : Nav_Current_Inter_2_Type;

   --   2.3.3.7 ADF current data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           26      ADF current data

   --   2.3.3.7.1 Intermediate word #1
   --   This contains the radio state and standby frequency.

   --   Bit No. Function        Status
   --    0      Direct tune     0 = inactive, 1 = active
   --    1      Memory mode     0 = inactive, 1 = active
   --    2 -  6 Memory number last in display
   --    7      0.5 KHz tuning enabled  0 = not enabled, 1 = enabled
   --    8      0.5 KHz 0 = 0.0 KHz, 1 = 0.5 KHz
   --    9 - 11 Spare   0
   --   12 - 15 1.0 KHz
   --   16 - 19 10.0 KHz
   --   20 - 23 100.0 KHz
   --   24 - 27 1.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)

   type Adf_Current_Inter_1_Type is
      record
         Direct_Tune_Active    : Boolean    := False;
         Memory_Mode_Active    : Boolean    := False;
         Memory_Number_Last    : Int5_Type  := 1;
         P5_Khz_Tuning_Enabled : Boolean    := False;
         P5_Khz_On             : Boolean    := False;
         Sp9                   : Spare_Type := Spare;
         Sp10                  : Spare_Type := Spare;
         Sp11                  : Spare_Type := Spare;
         Khz1                  : Int4_Type  := 0;
         Khz10                 : Int4_Type  := 0;
         Khz100                : Int4_Type  := 9;
         Mhz1                  : Int4_Type  := 1;
         Sp28                  : Spare_Type := Spare;
         Word_Type             : Word       := Intermediate;
         Parity                : Spare_Type := Spare;
      end record;
   for Adf_Current_Inter_1_Type use
      record
         Direct_Tune_Active    at 0 range 0 .. 0;
         Memory_Mode_Active    at 0 range 1 .. 1;
         Memory_Number_Last    at 0 range 2 .. 6;
         P5_Khz_Tuning_Enabled at 0 range 7 .. 7;
         P5_Khz_On             at 0 range 8 .. 8;
         Sp9                   at 0 range 9 .. 9;
         Sp10                  at 0 range 10 .. 10;
         Sp11                  at 0 range 11 .. 11;
         Khz1                  at 0 range 12 .. 15;
         Khz10                 at 0 range 16 .. 19;
         Khz100                at 0 range 20 .. 23;
         Mhz1                  at 0 range 24 .. 27;
         Sp28                  at 0 range 28 .. 28;
         Word_Type             at 0 range 29 .. 30;
         Parity                at 0 range 31 .. 31;
      end record;
   for Adf_Current_Inter_1_Type'Size use 32;
   Adf_Current_Inter_1 : Adf_Current_Inter_1_Type;

   --   2.3.3.7.2 Intermediate word #2
   --   This word is temp frequency for memory mode.
   --   Bit No. Function        Status
   --    0 -  7 Spare   0
   --    8      0.5 KHz 0 = 0.0 KHz, 1 = 0.5 KHz
   --    9 - 11 Spare   0
   --   12 - 15 1.0 KHz
   --   16 - 19 10.0 KHz
   --   20 - 23 100.0 KHz
   --   24 - 27 1.0 MHz
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                    0  1  Intermediate word
   --   31      Parity (Odd)
   type Adf_Current_Inter_2_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         P5_Khz_On : Boolean    := False;
         Sp9       : Spare_Type := Spare;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Khz1      : Int4_Type  := 0;
         Khz10     : Int4_Type  := 0;
         Khz100    : Int4_Type  := 9;
         Mhz1      : Int4_Type  := 1;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word       := Intermediate;
         Parity    : Spare_Type := Spare;
      end record;
   for Adf_Current_Inter_2_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         P5_Khz_On at 0 range 8 .. 8;
         Sp9       at 0 range 9 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Khz1      at 0 range 12 .. 15;
         Khz10     at 0 range 16 .. 19;
         Khz100    at 0 range 20 .. 23;
         Mhz1      at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Adf_Current_Inter_2_Type'Size use 32;
   Adf_Current_Inter_2 : Adf_Current_Inter_2_Type;

   --   2.3.3.8 Transponder current data

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           27      Transponder current data

   --   2.3.3.8.1 Intermediate word #1
   --   This contains the radio state and VFR code.

   --   Bit No. Function        Status
   --    0      Ident active    0 = inactive, 1 = active
   --    1 - 11 Spare   0
   --   12 - 15 VFR code digit D        Range = 0 to 7
   --             (least significant digit)
   --   16 - 19 VFR code digit C        Range = 0 to 7
   --   20 - 23 VFR code digit B        Range = 0 to 7
   --   24 - 27 VFR code digit A        Range = 0 to 7
   --             (most significant digit)
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)

   type Xpdr_Current_Inter_1_Type is
      record
         Ident_Active : Boolean := False;
         Sp1          : Spare_Type := Spare;
         Sp2          : Spare_Type := Spare;
         Sp3          : Spare_Type := Spare;
         Sp4          : Spare_Type := Spare;
         Sp5          : Spare_Type := Spare;
         Sp6          : Spare_Type := Spare;
         Sp7          : Spare_Type := Spare;
         Sp8          : Spare_Type := Spare;
         Sp9          : Spare_Type := Spare;
         Sp10         : Spare_Type := Spare;
         Sp11         : Spare_Type := Spare;
         Code_Digit_D : Int4_Type := 0;
         Code_Digit_C : Int4_Type := 0;
         Code_Digit_B : Int4_Type := 0;
         Code_Digit_A : Int4_Type := 0;
         Sp28         : Spare_Type := Spare;
         Word_Type    : Word := initial;
         Parity       : Spare_Type := Spare;
      end record;
   for Xpdr_Current_Inter_1_Type use
      record
         Ident_Active at 0 range 0 .. 0;
         Sp1          at 0 range 1 .. 1;
         Sp2          at 0 range 2 .. 2;
         Sp3          at 0 range 3 .. 3;
         Sp4          at 0 range 4 .. 4;
         Sp5          at 0 range 5 .. 5;
         Sp6          at 0 range 6 .. 6;
         Sp7          at 0 range 7 .. 7;
         Sp8          at 0 range 8 .. 8;
         Sp9          at 0 range 9 .. 9;
         Sp10         at 0 range 10 .. 10;
         Sp11         at 0 range 11 .. 11;
         Code_Digit_D at 0 range 12 .. 15;
         Code_Digit_C at 0 range 16 .. 19;
         Code_Digit_B at 0 range 20 .. 23;
         Code_Digit_A at 0 range 24 .. 27;
         Sp28         at 0 range 28 .. 28;
         Word_Type    at 0 range 29 .. 30;
         Parity       at 0 range 31 .. 31;
      end record;
   for Xpdr_Current_Inter_1_Type'Size use 32;
   Xpdr_Current_Inter_1 : Xpdr_Current_Inter_1_Type;

   -- 2.3.3.9 MLS current data

   -- This definition applies to the following label(s):

   --  Label (hex)     Function
   --          28      MLS current data

   --  2.3.3.9.1 Intermediate word #1
   --  This contains the radio state.

   --  Bit No. Function        Status
   --  0 -  1 Active field    1 0
   --                         0 0  Channel
   --                         0 1  AZ/BAZ
   --                         1 0  GS
   --  2      B/AZ indicated  0 = AZ, 1 = BAZ
   --  3 - 28 Spare   0
   --  29 - 30 Word type       30 29
   --                           0  1  Intermediate word
   --  31      Parity (Odd)
   type Mls_Current_Inter_1_Type is
      record
         Active_Field  : Int2_Type := 0;
         Baz_Indicated : Boolean := False;
         Sp3           : Spare_Type := Spare;
         Sp4           : Spare_Type := Spare;
         Sp5           : Spare_Type := Spare;
         Sp6           : Spare_Type := Spare;
         Sp7           : Spare_Type := Spare;
         Sp8           : Spare_Type := Spare;
         Sp9           : Spare_Type := Spare;
         Sp10          : Spare_Type := Spare;
         Sp11          : Spare_Type := Spare;
         Sp12          : Spare_Type := Spare;
         Sp13          : Spare_Type := Spare;
         Sp14          : Spare_Type := Spare;
         Sp15          : Spare_Type := Spare;
         Sp16          : Spare_Type := Spare;
         Sp17          : Spare_Type := Spare;
         Sp18          : Spare_Type := Spare;
         Sp19          : Spare_Type := Spare;
         Sp20          : Spare_Type := Spare;
         Sp21          : Spare_Type := Spare;
         Sp22          : Spare_Type := Spare;
         Sp23          : Spare_Type := Spare;
         Sp24          : Spare_Type := Spare;
         Sp25          : Spare_Type := Spare;
         Sp26          : Spare_Type := Spare;
         Sp27          : Spare_Type := Spare;
         Sp28          : Spare_Type := Spare;
         Word_Type     : Word := Intermediate;
         Parity        : Spare_Type := Spare;
      end record;
   for Mls_Current_Inter_1_Type use
      record
         Active_Field  at 0 range 0 .. 1;
         Baz_Indicated at 0 range 2 .. 2;
         Sp3           at 0 range 3 .. 3;
         Sp4           at 0 range 4 .. 4;
         Sp5           at 0 range 5 .. 5;
         Sp6           at 0 range 6 .. 6;
         Sp7           at 0 range 7 .. 7;
         Sp8           at 0 range 8 .. 8;
         Sp9           at 0 range 9 .. 9;
         Sp10          at 0 range 10 .. 10;
         Sp11          at 0 range 11 .. 11;
         Sp12          at 0 range 12 .. 12;
         Sp13          at 0 range 13 .. 13;
         Sp14          at 0 range 14 .. 14;
         Sp15          at 0 range 15 .. 15;
         Sp16          at 0 range 16 .. 16;
         Sp17          at 0 range 17 .. 17;
         Sp18          at 0 range 18 .. 18;
         Sp19          at 0 range 19 .. 19;
         Sp20          at 0 range 20 .. 20;
         Sp21          at 0 range 21 .. 21;
         Sp22          at 0 range 22 .. 22;
         Sp23          at 0 range 23 .. 23;
         Sp24          at 0 range 24 .. 24;
         Sp25          at 0 range 25 .. 25;
         Sp26          at 0 range 26 .. 26;
         Sp27          at 0 range 27 .. 27;
         Sp28          at 0 range 28 .. 28;
         Word_Type     at 0 range 29 .. 30;
         Parity        at 0 range 31 .. 31;
      end record;
   for Mls_Current_Inter_1_Type'Size use 32;
   Mls_Current_Inter_1 : Mls_Current_Inter_1_Type;

   --  2.3.3.10 TACAN current data

   --  This definition applies to the following label(s):

   --  Label (hex)     Function
   --          29      TACAN current data

   --  2.3.3.10.1 Intermediate word #1
   --  This contains the radio state and standby channel.

   --  Bit No. Function        Status
   --  0      Direct tune     0 = inactive, 1 = active
   --  1      Memory mode     0 = inactive, 1 = active
   --  2 -  6 Memory number last in display
   --  7      Spare   0
   --  8      Channel identifier      0 = X, 1 = Y
   --  9 - 11 Spare   0
   --  12 - 15 Ones channel    BCD digit
   --  16 - 19 Tens channel    BCD digit
   --  20 - 23 Hundreds channel        BCD digit
   --                                  Channel range = 0 to 129
   --  24 - 28 Spare   0
   --  29 - 30 Word type       30 29
   --                          0  1  Intermediate word
   --  31      Parity (Odd)
   type Tacan_Current_Inter_1_Type is
      record
         Direct_Tune_Active : Boolean := False;
         Memory_Mode_Active : Boolean := False;
         Last_Memory_Number : Int5_Type := 1;
         Sp7                : Spare_Type := Spare;
         Channel_Y          : Boolean := False;
         Sp9                : Spare_Type := Spare;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Ones_Channel       : Int4_Type := 0;
         Tens_Channel       : Int4_Type := 0;
         Hundreds_Channel   : Int4_Type := 0;
         Sp24               : Spare_Type := Spare;
         Sp25               : Spare_Type := Spare;
         Sp26               : Spare_Type := Spare;
         Sp27               : Spare_Type := Spare;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := Intermediate;
         Parity             : Spare_Type := Spare;
      end record;
   for Tacan_Current_Inter_1_Type use
      record
         Direct_Tune_Active at 0 range 0 .. 0;
         Memory_Mode_Active at 0 range 1 .. 1;
         Last_Memory_Number at 0 range 2 .. 6;
         Sp7                at 0 range 7 .. 7;
         Channel_Y          at 0 range 8 .. 8;
         Sp9                at 0 range 9 .. 9;
         Sp10               at 0 range 10 .. 10;
         Sp11               at 0 range 11 .. 11;
         Ones_Channel       at 0 range 12 .. 15;
         Tens_Channel       at 0 range 16 .. 19;
         Hundreds_Channel   at 0 range 20 .. 23;
         Sp24               at 0 range 24 .. 24;
         Sp25               at 0 range 25 .. 25;
         Sp26               at 0 range 26 .. 26;
         Sp27               at 0 range 27 .. 27;
         Sp28               at 0 range 28 .. 28;
         Word_Type          at 0 range 29 .. 30;
         Parity             at 0 range 31 .. 31;
      end record;
   for Tacan_Current_Inter_1_Type'Size use 32;
   Tacan_Current_Inter_1 : Tacan_Current_Inter_1_Type;
   --  2.3.3.10.2 Intermediate word #2
   --  This word is temp channel for memory mode.

   --  Bit No. Function        Status
   --  0 - 7  Spare   0
   --  8      Channel identifier      0 = X, 1 = Y
   --  9 - 11 Spare   0
   --  12 - 15 Ones channel    BCD digit
   --  16 - 19 Tens channel    BCD digit
   --  20 - 23 Hundreds channel        BCD digit
   --  Channel range = 0 to 129
   --  24 - 28 Spare   0
   --  29 - 30 Word type       30 29
   --                           0  1  Intermediate word
   --  31      Parity (Odd)
   type Tacan_Current_Inter_2_Type is
      record
         Sp0                : Spare_Type := Spare;
         Sp1                : Spare_Type := Spare;
         Sp2                : Spare_Type := Spare;
         Sp3                : Spare_Type := Spare;
         Sp4                : Spare_Type := Spare;
         Sp5                : Spare_Type := Spare;
         Sp6                : Spare_Type := Spare;
         Sp7                : Spare_Type := Spare;
         Channel_Y          : Boolean    := False;
         Sp9                : Spare_Type := Spare;
         Sp10               : Spare_Type := Spare;
         Sp11               : Spare_Type := Spare;
         Ones_Channel       : Int4_Type := 0;
         Tens_Channel       : Int4_Type := 0;
         Hundreds_Channel   : Int4_Type := 0;
         Sp24               : Spare_Type := Spare;
         Sp25               : Spare_Type := Spare;
         Sp26               : Spare_Type := Spare;
         Sp27               : Spare_Type := Spare;
         Sp28               : Spare_Type := Spare;
         Word_Type          : Word := Intermediate;
         Parity             : Spare_Type := Spare;
      end record;
   for Tacan_Current_Inter_2_Type use
      record
         Sp0              at 0 range 0 .. 0;
         Sp1              at 0 range 1 .. 1;
         Sp2              at 0 range 2 .. 2;
         Sp3              at 0 range 3 .. 3;
         Sp4              at 0 range 4 .. 4;
         Sp5              at 0 range 5 .. 5;
         Sp6              at 0 range 6 .. 6;
         Sp7              at 0 range 7 .. 7;
         Channel_Y        at 0 range 8 .. 8;
         Sp9              at 0 range 9 .. 9;
         Sp10             at 0 range 10 .. 10;
         Sp11             at 0 range 11 .. 11;
         Ones_Channel     at 0 range 12 .. 15;
         Tens_Channel     at 0 range 16 .. 19;
         Hundreds_Channel at 0 range 20 .. 23;
         Sp24             at 0 range 24 .. 24;
         Sp25             at 0 range 25 .. 25;
         Sp26             at 0 range 26 .. 26;
         Sp27             at 0 range 27 .. 27;
         Sp28             at 0 range 28 .. 28;
         Word_Type        at 0 range 29 .. 30;
         Parity           at 0 range 31 .. 31;
      end record;
   for Tacan_Current_Inter_2_Type'Size use 32;
   Tacan_Current_Inter_2 : Tacan_Current_Inter_2_Type;

   --   2.3.4 Memory data words

   --   These words contain memory frequencies (or channels) for the
   --   radios that have memories.  The number of words to follow field
   --   in the initial word shall be used to indicate the number of
   --   memories that are used.  If no memories are used, an initial word,
   --   final word sequence with no intermediate words shall be sent.

   --   2.3.5 State, command, and diagnostic data words

   --   2.3.4.1 VHF COM memory data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     40    VHF COM memory data

   --     2.3.4.1.1 Intermediate word
   --     Bit No.       Function        Status
   --     0 -  7        Spare   0
   --     8 - 11        0.001 MHz
   --     12 - 15       0.01 MHz
   --     16 - 19       0.1 MHz
   --     20 - 23       1.0 MHz
   --     24 - 27       10.0 MHz
   --     28    Spare   0
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)

   --     Note: 100 Mhz digit is not transmitted and is always 1.
   type Vhf_Memory_Inter_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Mhzp001   : Int4_Type := 0;
         Mhzp01    : Int4_Type := 0;
         Mhzp1     : Int4_Type := 0;
         Mhz1      : Int4_Type := 0;
         Mhz10     : Int4_Type := 0;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := Intermediate;
         Parity    : Spare_Type := Spare;
      end record;
   for Vhf_Memory_Inter_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Mhzp001   at 0 range 8 .. 11;
         Mhzp01    at 0 range 12 .. 15;
         Mhzp1     at 0 range 16 .. 19;
         Mhz1      at 0 range 20 .. 23;
         Mhz10     at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Vhf_Memory_Inter_Type'Size use 32;
   type Vhf_Memory_Inter_Array is array (1 .. 20) of Vhf_Memory_Inter_Type;
   Vhf_Memory_Inter : Vhf_Memory_Inter_Array;

   --   2.3.4.2 UHF COM memory data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     41    UHF COM memory data

   --     2.3.4.2.1 Intermediate word
   --     Bit No.       Function        Status
   --     0 -  7        Spare   0
   --     8 -  9        0.025 MHz       9 8
   --                                   0 0        0.000 MHz
   --                                   0 1  0.025 MHz
   --                                   1 0  0.050 MHz
   --                                   1 1  0.075 MHz
   --     10 - 11       Spare   0
   --     12 - 15       0.1 MHz
   --     16 - 19       1.0 MHz
   --     20 - 23       10.0 MHz
   --     24 - 27       100.0 MHz
   --     28    Spare   0
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)
   type Uhf_Memory_Inter_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Mhzp025   : Int2_Type := 0;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Mhzp1     : Int4_Type := 0;
         Mhz1      : Int4_Type := 0;
         Mhz10     : Int4_Type := 0;
         Mhz100    : Int4_Type := 0;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := Intermediate;
         Parity    : Spare_Type := Spare;
      end record;
   for Uhf_Memory_Inter_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Mhzp025   at 0 range 8 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Mhzp1     at 0 range 12 .. 15;
         Mhz1      at 0 range 16 .. 19;
         Mhz10     at 0 range 20 .. 23;
         Mhz100    at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Uhf_Memory_Inter_Type'Size use 32;
   type Uhf_Memory_Inter_Array is array (1 .. 20) of Uhf_Memory_Inter_Type;
   Uhf_Memory_Inter : Uhf_Memory_Inter_Array;

   --   2.3.4.4 NAV memory data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     43    NAV memory data

   --     2.3.4.4.1 Intermediate word
   --     Bit No.       Function        Status
   --     0 - 11        Spare   0
   --     12 - 15       0.01 MHz
   --     16 - 19       0.1 MHz
   --     20 - 23       1.0 MHz
   --     24 - 27       10.0 MHz
   --     28    Spare   0
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)
   type Nav_Memory_Inter_Type is
      record
         Sp0       : Spare_Type := Spare;
         Sp1       : Spare_Type := Spare;
         Sp2       : Spare_Type := Spare;
         Sp3       : Spare_Type := Spare;
         Sp4       : Spare_Type := Spare;
         Sp5       : Spare_Type := Spare;
         Sp6       : Spare_Type := Spare;
         Sp7       : Spare_Type := Spare;
         Sp8       : Spare_Type := Spare;
         Sp9       : Spare_Type := Spare;
         Sp10      : Spare_Type := Spare;
         Sp11      : Spare_Type := Spare;
         Mhzp01    : Int4_Type := 0;
         Mhzp1     : Int4_Type := 0;
         Mhz1      : Int4_Type := 0;
         Mhz10     : Int4_Type := 0;
         Sp28      : Spare_Type := Spare;
         Word_Type : Word := Intermediate;
         Parity    : Spare_Type := Spare;
      end record;
   for Nav_Memory_Inter_Type use
      record
         Sp0       at 0 range 0 .. 0;
         Sp1       at 0 range 1 .. 1;
         Sp2       at 0 range 2 .. 2;
         Sp3       at 0 range 3 .. 3;
         Sp4       at 0 range 4 .. 4;
         Sp5       at 0 range 5 .. 5;
         Sp6       at 0 range 6 .. 6;
         Sp7       at 0 range 7 .. 7;
         Sp8       at 0 range 8 .. 8;
         Sp9       at 0 range 9 .. 9;
         Sp10      at 0 range 10 .. 10;
         Sp11      at 0 range 11 .. 11;
         Mhzp01    at 0 range 12 .. 15;
         Mhzp1     at 0 range 16 .. 19;
         Mhz1      at 0 range 20 .. 23;
         Mhz10     at 0 range 24 .. 27;
         Sp28      at 0 range 28 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Nav_Memory_Inter_Type'Size use 32;
   type Nav_Memory_Inter_Array is array (1 .. 10) of Nav_Memory_Inter_Type;
   Nav_Memory_Inter : Nav_Memory_Inter_Array;

   --   2.3.4.5 ADF memory data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     44    ADF memory data

   --     2.3.4.5.1 Intermediate word
   --     Bit No.       Function        Status
   --     0 -  7        Spare           0
   --     8     0.5 KHz 0 = 0.0 KHz, 1 = 0.5 KHz
   --     9 - 11        Spare           0
   --     12 - 15       1.0 KHz
   --     16 - 19       10.0 KHz
   --     20 - 23       100.0 KHz
   --     24 - 27       1.0 MHz
   --     28    Spare   0
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)
   --   2.3.4.6 TACAN memory data

   --     This definition applies to the following label(s):

   --     Label (hex)   Function
   --     45    TACAN memory data

   --     2.3.4.6.1 Intermediate word
   --     Bit No.       Function        Status
   --     0 -  7        Spare   0
   --     8     Channel identifier      0 = X, 1 = Y
   --     9 - 11        Spare   0
   --     12 - 15       Ones channel    BCD digit
   --     16 - 19       Tens channel    BCD digit
   --     20 - 23       Hundreds channel        BCD digit
   --     Channel range = 0 to 129
   --     24 - 28       Spare   0
   --     29 - 30       Word type       30 29
   --                                    0  1  Intermediate word
   --     31    Parity (Odd)

   --   2.3.5.1 RMU 556 state data

   --   This word contains state data from the RMU 556.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           60      RMU 556 state data

   --   2.3.5.1.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 - 23 Spare   0
   --   24      Edit configuration      0 = not editing, 1 = editing
   --   25      Internal PFT state      0 = completed, 1 = performing
   --   26      Diagnostic mode 0 = inactive, 1 = active
   --   27      Onside KDA 557 comm link status 0 = down, 1 = up
   --   28      Cross-side KDA 557 comm link status     0 = down, 1 = up
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Rmu_State_Data_Inter_1_Type is
      record
         Sp0                           : Spare_Type := Spare;
         Sp1                           : Spare_Type := Spare;
         Sp2                           : Spare_Type := Spare;
         Sp3                           : Spare_Type := Spare;
         Sp4                           : Spare_Type := Spare;
         Sp5                           : Spare_Type := Spare;
         Sp6                           : Spare_Type := Spare;
         Sp7                           : Spare_Type := Spare;
         Sp8                           : Spare_Type := Spare;
         Sp9                           : Spare_Type := Spare;
         Sp10                          : Spare_Type := Spare;
         Sp11                          : Spare_Type := Spare;
         Sp12                          : Spare_Type := Spare;
         Sp13                          : Spare_Type := Spare;
         Sp14                          : Spare_Type := Spare;
         Sp15                          : Spare_Type := Spare;
         Sp16                          : Spare_Type := Spare;
         Sp17                          : Spare_Type := Spare;
         Sp18                          : Spare_Type := Spare;
         Sp19                          : Spare_Type := Spare;
         Sp20                          : Spare_Type := Spare;
         Sp21                          : Spare_Type := Spare;
         Sp22                          : Spare_Type := Spare;
         Sp23                          : Spare_Type := Spare;
         Editing_Configuration         : Boolean := False;
         Performing_Test               : Boolean := False;
         Diagnostic_Mode_Active        : Boolean := False;
         Onside_Kda_Comm_Status_Up     : Boolean := False;
         Cross_Side_Kda_Comm_Status_Up : Boolean := False;
         Word_Type                     : Word := Intermediate;
         Parity                        : Spare_Type := Spare;
      end record;
   for Rmu_State_Data_Inter_1_Type use
      record
         Sp0                           at 0 range 0 .. 0;
         Sp1                           at 0 range 1 .. 1;
         Sp2                           at 0 range 2 .. 2;
         Sp3                           at 0 range 3 .. 3;
         Sp4                           at 0 range 4 .. 4;
         Sp5                           at 0 range 5 .. 5;
         Sp6                           at 0 range 6 .. 6;
         Sp7                           at 0 range 7 .. 7;
         Sp8                           at 0 range 8 .. 8;
         Sp9                           at 0 range 9 .. 9;
         Sp10                          at 0 range 10 .. 10;
         Sp11                          at 0 range 11 .. 11;
         Sp12                          at 0 range 12 .. 12;
         Sp13                          at 0 range 13 .. 13;
         Sp14                          at 0 range 14 .. 14;
         Sp15                          at 0 range 15 .. 15;
         Sp16                          at 0 range 16 .. 16;
         Sp17                          at 0 range 17 .. 17;
         Sp18                          at 0 range 18 .. 18;
         Sp19                          at 0 range 19 .. 19;
         Sp20                          at 0 range 20 .. 20;
         Sp21                          at 0 range 21 .. 21;
         Sp22                          at 0 range 22 .. 22;
         Sp23                          at 0 range 23 .. 23;
         Editing_Configuration         at 0 range 24 .. 24;
         Performing_Test               at 0 range 25 .. 25;
         Diagnostic_Mode_Active        at 0 range 26 .. 26;
         Onside_Kda_Comm_Status_Up     at 0 range 27 .. 27;
         Cross_Side_Kda_Comm_Status_Up at 0 range 28 .. 28;
         Word_Type                     at 0 range 29 .. 30;
         Parity                        at 0 range 31 .. 31;
      end record;
   for Rmu_State_Data_Inter_1_Type'Size use 32;
   Rmu_State_Data_Inter_1 : Rmu_State_Data_Inter_1_Type;

   --   2.3.5.2 RMU 556 command data

   --   This word contains commands from the RMU 556 to the KDA 557.
   --   These commands shall be acted upon if received as "1",
   --   ignored if received as "0".

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           61      RMU 556 command data

   --   2.3.5.2.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 - 21 Spare   0
   --   22 Transmit radio model data 0=ignore,1=transmit all radio model data
   --   23 Transmit initialization data 0 = ignore,
   --                   1 = transmit in the following order:
   --                     all active data
   --                     all current data
   --                     all memory data
   --   24 Copy configuration data
   --             from cross-side unit
   --             to memory and rack    0 = ignore, 1 = perform
   --   25      Copy configuration data
   --             from memory to rack   0 = ignore, 1 = perform
   --   26      Copy configuration data
   --             from rack to memory   0 = ignore, 1 = perform
   --   27      Copy memory data from cross-side
   --             KDA 557       0 = ignore, 1 = perform
   --   28      Clear diagnostic memory 0 = ignore, 1 = perform
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Rmu_Command_Data_Inter_1_Type is
      record
         Sp0                         : Spare_Type := Spare;
         Sp1                         : Spare_Type := Spare;
         Sp2                         : Spare_Type := Spare;
         Sp3                         : Spare_Type := Spare;
         Sp4                         : Spare_Type := Spare;
         Sp5                         : Spare_Type := Spare;
         Sp6                         : Spare_Type := Spare;
         Sp7                         : Spare_Type := Spare;
         Sp8                         : Spare_Type := Spare;
         Sp9                         : Spare_Type := Spare;
         Sp10                        : Spare_Type := Spare;
         Sp11                        : Spare_Type := Spare;
         Sp12                        : Spare_Type := Spare;
         Sp13                        : Spare_Type := Spare;
         Sp14                        : Spare_Type := Spare;
         Sp15                        : Spare_Type := Spare;
         Sp16                        : Spare_Type := Spare;
         Sp17                        : Spare_Type := Spare;
         Sp18                        : Spare_Type := Spare;
         Sp19                        : Spare_Type := Spare;
         Sp20                        : Spare_Type := Spare;
         Sp21                        : Spare_Type := Spare;
         Xmit_Radio_Model_Data       : Boolean := False;
         Xmit_Initialization_Data    : Boolean := False;
         Copy_From_Xside_To_Mem_Rack : Boolean := False;
         Copy_From_Mem_To_Rack       : Boolean := False;
         Copy_From_Rack_To_Mem       : Boolean := False;
         Copy_From_Xside_Kda         : Boolean := False;
         Clear_Diag_Memory           : Boolean := False;
         Word_Type                   : Word := initial;
         Parity                      : Spare_Type := Spare;
      end record;
   for Rmu_Command_Data_Inter_1_Type use
      record
         Sp0                         at 0 range 0 .. 0;
         Sp1                         at 0 range 1 .. 1;
         Sp2                         at 0 range 2 .. 2;
         Sp3                         at 0 range 3 .. 3;
         Sp4                         at 0 range 4 .. 4;
         Sp5                         at 0 range 5 .. 5;
         Sp6                         at 0 range 6 .. 6;
         Sp7                         at 0 range 7 .. 7;
         Sp8                         at 0 range 8 .. 8;
         Sp9                         at 0 range 9 .. 9;
         Sp10                        at 0 range 10 .. 10;
         Sp11                        at 0 range 11 .. 11;
         Sp12                        at 0 range 12 .. 12;
         Sp13                        at 0 range 13 .. 13;
         Sp14                        at 0 range 14 .. 14;
         Sp15                        at 0 range 15 .. 15;
         Sp16                        at 0 range 16 .. 16;
         Sp17                        at 0 range 17 .. 17;
         Sp18                        at 0 range 18 .. 18;
         Sp19                        at 0 range 19 .. 19;
         Sp20                        at 0 range 20 .. 20;
         Sp21                        at 0 range 21 .. 21;
         Xmit_Radio_Model_Data       at 0 range 22 .. 22;
         Xmit_Initialization_Data    at 0 range 23 .. 23;
         Copy_From_Xside_To_Mem_Rack at 0 range 24 .. 24;
         Copy_From_Mem_To_Rack       at 0 range 25 .. 25;
         Copy_From_Rack_To_Mem       at 0 range 26 .. 26;
         Copy_From_Xside_Kda         at 0 range 27 .. 27;
         Clear_Diag_Memory           at 0 range 28 .. 28;
         Word_Type                   at 0 range 29 .. 30;
         Parity                      at 0 range 31 .. 31;
      end record;
   for Rmu_Command_Data_Inter_1_Type'Size use 32;
   Rmu_Command_Data_Inter_1 : Rmu_Command_Data_Inter_1_Type;

   --   2.3.5.3 KDA 557 general state data

   --   This word contains general state data from the KDA 557 to the RMU 556.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           62      KDA 557 general state data

   --   2.3.5.3.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0      KDA 557 diagnostic state        0 = inactive, 1 = active
   --    1      KDA 557 removed from aircraft   0 = no, 1 = yes
   --    2      Emergency bus power     0 = off, 1 = on
   --    3      Avionics bus #1 power   0 = off, 1 = on
   --    4      Avionics bus #2 power   0 = off, 1 = on
   --    5      Cross-side KDA 557 power        0 = off, 1 = on
   --    6      Backup control head(s) group 1  0 = inactive, 1 = active
   --    7      Backup control head(s) group 2  0 = inactive, 1 = active
   --    8      KDA #1 fail     0 = inactive, 1 = active
   --    9      KDA #2 fail     0 = inactive, 1 = active
   --   10      Controlling all radio tuning    0 = no, 1 = yes
   --   11      Invalid clock data      0 = no, 1 = yes
   --   12 - 15 Spare   0
   --   16 - 18 RMU 556 configuring system      18 17 16
   --                    0  0  0  configuration inactive
   --                    0  0  1  RMU 556 #1
   --                    0  1  0  RMU 556 #2
   --                    0  1  1  RMU 556 #3
   --                    1  0  0  RMU 556 #4
   --   19      Configuration strap enable      0 = disabled, 1 = enabled
   --   20      Receiving from RMU 556 #1       0 = no, 1 = yes
   --   21      Receiving from RMU 556 #2       0 = no, 1 = yes
   --   22      Receiving from RMU 556 #3       0 = no, 1 = yes
   --   23      Receiving from RMU 556 #4       0 = no, 1 = yes
   --   24      Receiving from cross-side
   --             KDA 557       0 = no, 1 = yes
   --   25      KDA 557 background BIT error    0 = no, 1 = yes
   --   26      Diagnostic event memory 90% full        0 = no, 1 = yes
   --   27      Cross-side unit memory data
   --             mismatch      0 = no, 1 = yes
   --   28      Configuration error     0 = no, 1 = yes
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Configuring_System_Type is (Inactive,Rmu_1,Rmu_2,Rmu_3,Rmu_4);
   for Configuring_System_Type'Size use 3;

   type Kda_State_Data_Inter_1_Type is
      record
         Diagnostic_Active      : Boolean := False;
         Kda_Removed_From_Ac    : Boolean := False;
         Emergency_Bus_Power    : Boolean := False;
         Avionics_Bus_1_Pwr     : Boolean := False;
         Avionics_Bus_2_Pwr     : Boolean := False;
         Xside_Kda_Pwr          : Boolean := False;
         Backup_Control_Group_1 : Boolean := False;
         Backup_Control_Group_2 : Boolean := False;
         Kda_1_Fail             : Boolean := False;
         Kda_2_Fail             : Boolean := False;
         Control_All_Tuning     : Boolean := False;
         Invalid_Clock          : Boolean := False;
         Sp12                   : Spare_Type := Spare;
         Sp13                   : Spare_Type := Spare;
         Sp14                   : Spare_Type := Spare;
         Sp15                   : Spare_Type := Spare;
         Configuring_System     : Configuring_System_Type := Rmu_1;
         Strap_Enable           : Boolean := False;
         Receiving_Rmu_1        : Boolean := False;
         Receiving_Rmu_2        : Boolean := False;
         Receiving_Rmu_3        : Boolean := False;
         Receiving_Rmu_4        : Boolean := False;
         Receiving_Xside_Kda    : Boolean := False;
         Kda_Bit_Error          : Boolean := False;
         Diag_Memory_90_Full    : Boolean := False;
         Xside_Memory_Mismatch  : Boolean := False;
         Configuration_Error    : Boolean := False;
         Word_Type              : Word := initial;
         Parity                 : Spare_Type := Spare;
      end record;
   for Kda_State_Data_Inter_1_Type use
      record
         Diagnostic_Active      at 0 range 0 .. 0;
         Kda_Removed_From_Ac    at 0 range 1 .. 1;
         Emergency_Bus_Power    at 0 range 2 .. 2;
         Avionics_Bus_1_Pwr     at 0 range 3 .. 3;
         Avionics_Bus_2_Pwr     at 0 range 4 .. 4;
         Xside_Kda_Pwr          at 0 range 5 .. 5;
         Backup_Control_Group_1 at 0 range 6 .. 6;
         Backup_Control_Group_2 at 0 range 7 .. 7;
         Kda_1_Fail             at 0 range 8 .. 8;
         Kda_2_Fail             at 0 range 9 .. 9;
         Control_All_Tuning     at 0 range 10 .. 10;
         Invalid_Clock          at 0 range 11 .. 11;
         Sp12                   at 0 range 12 .. 12;
         Sp13                   at 0 range 13 .. 13;
         Sp14                   at 0 range 14 .. 14;
         Sp15                   at 0 range 15 .. 15;
         Configuring_System     at 0 range 16 .. 18;
         Strap_Enable           at 0 range 19 .. 19;
         Receiving_Rmu_1        at 0 range 20 .. 20;
         Receiving_Rmu_2        at 0 range 21 .. 21;
         Receiving_Rmu_3        at 0 range 22 .. 22;
         Receiving_Rmu_4        at 0 range 23 .. 23;
         Receiving_Xside_Kda    at 0 range 24 .. 24;
         Kda_Bit_Error          at 0 range 25 .. 25;
         Diag_Memory_90_Full    at 0 range 26 .. 26;
         Xside_Memory_Mismatch  at 0 range 27 .. 27;
         Configuration_Error    at 0 range 28 .. 28;
         Word_Type              at 0 range 29 .. 30;
         Parity                 at 0 range 31 .. 31;
      end record;
   for Kda_State_Data_Inter_1_Type'Size use 32;
   Kda_State_Data_Inter_1 : Kda_State_Data_Inter_1_Type;

   --   2.3.5.4 KDA 557 general command data

   --   This word contains general commands from the KDA 557 to the
   --   RMU 556 or the cross-side KDA 557.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           63      KDA 557 general command data

   --   2.3.5.4.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 - 26 Spare   0
   --   28      Perform PFT     0 = ignore, 1 = perform
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Kda_General_Command_Data_Inter_1_Type is
      record
         Sp0         : Spare_Type := Spare;
         Sp1         : Spare_Type := Spare;
         Sp2         : Spare_Type := Spare;
         Sp3         : Spare_Type := Spare;
         Sp4         : Spare_Type := Spare;
         Sp5         : Spare_Type := Spare;
         Sp6         : Spare_Type := Spare;
         Sp7         : Spare_Type := Spare;
         Sp8         : Spare_Type := Spare;
         Sp9         : Spare_Type := Spare;
         Sp10        : Spare_Type := Spare;
         Sp11        : Spare_Type := Spare;
         Sp12        : Spare_Type := Spare;
         Sp13        : Spare_Type := Spare;
         Sp14        : Spare_Type := Spare;
         Sp15        : Spare_Type := Spare;
         Sp16        : Spare_Type := Spare;
         Sp17        : Spare_Type := Spare;
         Sp18        : Spare_Type := Spare;
         Sp19        : Spare_Type := Spare;
         Sp20        : Spare_Type := Spare;
         Sp21        : Spare_Type := Spare;
         Sp22        : Spare_Type := Spare;
         Sp23        : Spare_Type := Spare;
         Sp24        : Spare_Type := Spare;
         Sp25        : Spare_Type := Spare;
         Sp26        : Spare_Type := Spare;
         Sp27        : Spare_Type := Spare;
         Perform_Pft : Boolean := False;
         Word_Type   : Word := initial;
         Parity      : Spare_Type := Spare;
      end record;
   for Kda_General_Command_Data_Inter_1_Type use
      record
         Sp0         at 0 range 0 .. 0;
         Sp1         at 0 range 1 .. 1;
         Sp2         at 0 range 2 .. 2;
         Sp3         at 0 range 3 .. 3;
         Sp4         at 0 range 4 .. 4;
         Sp5         at 0 range 5 .. 5;
         Sp6         at 0 range 6 .. 6;
         Sp7         at 0 range 7 .. 7;
         Sp8         at 0 range 8 .. 8;
         Sp9         at 0 range 9 .. 9;
         Sp10        at 0 range 10 .. 10;
         Sp11        at 0 range 11 .. 11;
         Sp12        at 0 range 12 .. 12;
         Sp13        at 0 range 13 .. 13;
         Sp14        at 0 range 14 .. 14;
         Sp15        at 0 range 15 .. 15;
         Sp16        at 0 range 16 .. 16;
         Sp17        at 0 range 17 .. 17;
         Sp18        at 0 range 18 .. 18;
         Sp19        at 0 range 19 .. 19;
         Sp20        at 0 range 20 .. 20;
         Sp21        at 0 range 21 .. 21;
         Sp22        at 0 range 22 .. 22;
         Sp23        at 0 range 23 .. 23;
         Sp24        at 0 range 24 .. 24;
         Sp25        at 0 range 25 .. 25;
         Sp26        at 0 range 26 .. 26;
         Sp27        at 0 range 27 .. 27;
         Perform_Pft at 0 range 28 .. 28;
         Word_Type   at 0 range 29 .. 30;
         Parity      at 0 range 31 .. 31;
      end record;
   for Kda_General_Command_Data_Inter_1_Type'Size use 32;
   Kda_General_Command_Data_Inter_1 : Kda_General_Command_Data_Inter_1_Type;

   --   2.3.5.5 RMU 556 test command data

   --   This is used by the RMU 556 to command the KDA 557 to
   --   perform specific tests.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           64      RMU 556 test command data

   --   2.3.5.5.1 Intermediate word #1
   --   This are used to command specific internal KDA 557 tests.

   --   Bit No. Function        Status
   --    0      Test RAM        0 = inactive, 1 = active
   --    1      Test EPROM      0 = inactive, 1 = active
   --    2      Test power supply       0 = inactive, 1 = active
   --    3      Test ARINC 429 #1 radio 0 = inactive, 1 = active
   --    4      Test ARINC 429 #2 radio 0 = inactive, 1 = active
   --    5      Test ARINC 429 RMU onside       0 = inactive, 1 = active
   --    6      Test ARINC 429 RMU xside        0 = inactive, 1 = active
   --    7      Test ARINC 429 TACAN bus        0 = inactive, 1 = active
   --    8      Test ARINC 429 status   0 = inactive, 1 = active
   --    9      Test ARINC 429 UHF      0 = inactive, 1 = active
   --   10      Test RAM battery        0 = inactive, 1 = active
   --   11      Test Aux Pwr #1         0 = inactive, 1 = active
   --   12      Test Aux Pwr #2         0 = inactive, 1 = active
   --   13 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)


   --   2.3.5.5.2 Intermediate word #2
   --   This is used to command specific external unit tests.

   --   Bit No. Function        Status
   --    0      Test VHF COM #1 0 = inactive, 1 = active
   --    1      Test VHF COM #2 0 = inactive, 1 = active
   --    2      Test VHF COM #3 0 = inactive, 1 = active
   --    3      Test UHF COM #1 0 = inactive, 1 = active
   --    4      Test UHF COM #2 0 = inactive, 1 = active
   --    5      Test HF COM #1  0 = inactive, 1 = active
   --    6      Test HF COM #2  0 = inactive, 1 = active
   --    7      Test NAV #1     0 = inactive, 1 = active
   --    8      Test NAV #2     0 = inactive, 1 = active
   --    9      Test DME #1     0 = inactive, 1 = active
   --   10      Test DME #2     0 = inactive, 1 = active
   --   11      Test ADF #1     0 = inactive, 1 = active
   --   12      Test ADF #2     0 = inactive, 1 = active
   --   13      Test Transponder #1     0 = inactive, 1 = active
   --   14      Test Transponder #2     0 = inactive, 1 = active
   --   15      Test MLS #1     0 = inactive, 1 = active
   --   16      Test MLS #2     0 = inactive, 1 = active
   --   17      Test TACAN #1   0 = inactive, 1 = active
   --   18      Test TACAN #2   0 = inactive, 1 = active
   --   19      Test NMS #1     0 = inactive, 1 = active
   --   20      Test NMS #2     0 = inactive, 1 = active
   --   21      Test FCS #1     0 = inactive, 1 = active
   --   22      Test FCS #2     0 = inactive, 1 = active
   --   23      Test EFIS #1    0 = inactive, 1 = active
   --   24      Test EFIS #2    0 = inactive, 1 = active
   --   25 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Rmu_Test_Command_Inter_1_Type is
      record
         Test_Ram_Active           : Boolean := False;
         Test_Eprom_Active         : Boolean := False;
         Test_Power_Supply         : Boolean := False;
         Test_Arinc_429_Radio_1    : Boolean := False;
         Test_Arinc_429_Radio_2    : Boolean := False;
         Test_Arinc_429_Rmu_Onside : Boolean := False;
         Test_Arinc_429_Rmu_Xside  : Boolean := False;
         Test_Arinc_429_Tacan_Bus  : Boolean := False;
         Test_Arinc_429_Status     : Boolean := False;
         Test_Arinc_429_Uhf        : Boolean := False;
         Test_Ram_Battery          : Boolean := False;
         Test_Aux_Pwr_1            : Boolean := False;
         Test_Aux_Pwr_2            : Boolean := False;
         Sp13                      : Spare_Type := Spare;
         Sp14                      : Spare_Type := Spare;
         Sp15                      : Spare_Type := Spare;
         Sp16                      : Spare_Type := Spare;
         Sp17                      : Spare_Type := Spare;
         Sp18                      : Spare_Type := Spare;
         Sp19                      : Spare_Type := Spare;
         Sp20                      : Spare_Type := Spare;
         Sp21                      : Spare_Type := Spare;
         Sp22                      : Spare_Type := Spare;
         Sp23                      : Spare_Type := Spare;
         Sp24                      : Spare_Type := Spare;
         Sp25                      : Spare_Type := Spare;
         Sp26                      : Spare_Type := Spare;
         Sp27                      : Spare_Type := Spare;
         Sp28                      : Spare_Type := Spare;
         Word_Type                 : Word := initial;
         Parity                    : Spare_Type := Spare;
      end record;
   for Rmu_Test_Command_Inter_1_Type use
      record
         Test_Ram_Active           at 0 range 0 .. 0;
         Test_Eprom_Active         at 0 range 1 .. 1;
         Test_Power_Supply         at 0 range 2 .. 2;
         Test_Arinc_429_Radio_1    at 0 range 3 .. 3;
         Test_Arinc_429_Radio_2    at 0 range 4 .. 4;
         Test_Arinc_429_Rmu_Onside at 0 range 5 .. 5;
         Test_Arinc_429_Rmu_Xside  at 0 range 6 .. 6;
         Test_Arinc_429_Tacan_Bus  at 0 range 7 .. 7;
         Test_Arinc_429_Status     at 0 range 8 .. 8;
         Test_Arinc_429_Uhf        at 0 range 9 .. 9;
         Test_Ram_Battery          at 0 range 10 .. 10;
         Test_Aux_Pwr_1            at 0 range 11 .. 11;
         Test_Aux_Pwr_2            at 0 range 12 .. 12;
         Sp13                      at 0 range 13 .. 13;
         Sp14                      at 0 range 14 .. 14;
         Sp15                      at 0 range 15 .. 15;
         Sp16                      at 0 range 16 .. 16;
         Sp17                      at 0 range 17 .. 17;
         Sp18                      at 0 range 18 .. 18;
         Sp19                      at 0 range 19 .. 19;
         Sp20                      at 0 range 20 .. 20;
         Sp21                      at 0 range 21 .. 21;
         Sp22                      at 0 range 22 .. 22;
         Sp23                      at 0 range 23 .. 23;
         Sp24                      at 0 range 24 .. 24;
         Sp25                      at 0 range 25 .. 25;
         Sp26                      at 0 range 26 .. 26;
         Sp27                      at 0 range 27 .. 27;
         Sp28                      at 0 range 28 .. 28;
         Word_Type                 at 0 range 29 .. 30;
         Parity                    at 0 range 31 .. 31;
      end record;
   for Rmu_Test_Command_Inter_1_Type'Size use 32;
   Rmu_Test_Command_Inter_1 : Rmu_Test_Command_Inter_1_Type;

   type Rmu_Test_Command_Inter_2_Type is
      record
         Test_Vhf_Com_1  : Boolean := False;
         Test_Vhf_Com_2  : Boolean := False;
         Test_Vhf_Com_3  : Boolean := False;
         Test_Uhf_Com_1  : Boolean := False;
         Test_Uhf_Com_2  : Boolean := False;
         Test_Hf_Com_1   : Boolean := False;
         Test_Hf_Com_2   : Boolean := False;
         Test_Nav_1      : Boolean := False;
         Test_Nav_2      : Boolean := False;
         Test_Dme_1      : Boolean := False;
         Test_Dme_2      : Boolean := False;
         Test_Adf_1      : Boolean := False;
         Test_Adf_2      : Boolean := False;
         Test_Xpdr_1     : Boolean := False;
         Test_Xpdr_2     : Boolean := False;
         Test_Mls_1      : Boolean := False;
         Test_Mls_2      : Boolean := False;
         Test_Tacan_1    : Boolean := False;
         Test_Tacan_2    : Boolean := False;
         Test_Nms_1      : Boolean := False;
         Test_Nms_2      : Boolean := False;
         Test_Fcs_1      : Boolean := False;
         Test_Fcs_2      : Boolean := False;
         Test_Efis_1     : Boolean := False;
         Test_Efis_2     : Boolean := False;
         Sp25            : Spare_Type := Spare;
         Sp26            : Spare_Type := Spare;
         Sp27            : Spare_Type := Spare;
         Sp28            : Spare_Type := Spare;
         Word_Type       : Word := initial;
         Parity          : Spare_Type := Spare;
      end record;

   for Rmu_Test_Command_Inter_2_Type use
      record
         Test_Vhf_Com_1  at 0 range 0 .. 0;
         Test_Vhf_Com_2  at 0 range 1 .. 1;
         Test_Vhf_Com_3  at 0 range 2 .. 2;
         Test_Uhf_Com_1  at 0 range 3 .. 3;
         Test_Uhf_Com_2  at 0 range 4 .. 4;
         Test_Hf_Com_1   at 0 range 5 .. 5;
         Test_Hf_Com_2   at 0 range 6 .. 6;
         Test_Nav_1      at 0 range 7 .. 7;
         Test_Nav_2      at 0 range 8 .. 8;
         Test_Dme_1      at 0 range 9 .. 9;
         Test_Dme_2      at 0 range 10 .. 10;
         Test_Adf_1      at 0 range 11 .. 11;
         Test_Adf_2      at 0 range 12 .. 12;
         Test_Xpdr_1     at 0 range 13 .. 13;
         Test_Xpdr_2     at 0 range 14 .. 14;
         Test_Mls_1      at 0 range 15 .. 15;
         Test_Mls_2      at 0 range 16 .. 16;
         Test_Tacan_1    at 0 range 17 .. 17;
         Test_Tacan_2    at 0 range 18 .. 18;
         Test_Nms_1      at 0 range 19 .. 19;
         Test_Nms_2      at 0 range 20 .. 20;
         Test_Fcs_1      at 0 range 21 .. 21;
         Test_Fcs_2      at 0 range 22 .. 22;
         Test_Efis_1     at 0 range 23 .. 23;
         Test_Efis_2     at 0 range 24 .. 24;
         Sp25            at 0 range 25 .. 25;
         Sp26            at 0 range 26 .. 26;
         Sp27            at 0 range 27 .. 27;
         Sp28            at 0 range 28 .. 28;
         Word_Type       at 0 range 29 .. 30;
         Parity          at 0 range 31 .. 31;
      end record;
   for Rmu_Test_Command_Inter_2_Type'Size use 32;
   Rmu_Test_Command_Inter_2 : Rmu_Test_Command_Inter_2_Type;

   --   2.3.5.6 KDA 557 test result data

   --   This is used by the KDA 557 to report result of tests to the RMU 556.

   --   Result matrix used in intermediate words 2 and 3 is:

   --       bit 1 bit 0
   --         0     0    Fail
   --         0     1    Pass
   --         1     0    Not available
   --         1     1    No power

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           65      KDA 557 test result data

   --   2.3.5.6.1 Intermediate word #1
   --   This are used to report results of internal KDA 557 tests.

   --   Bit No. Function        Status
   --    0      RAM     0 = fail, 1 = pass
   --    1      EPROM   0 = fail, 1 = pass
   --    2      power supply    0 = fail, 1 = pass
   --    3      ARINC 429 #1 radio      0 = fail, 1 = pass
   --    4      ARINC 429 #2 radio      0 = fail, 1 = pass
   --    5      ARINC 429 RMU onside    0 = fail, 1 = pass
   --    6      ARINC 429 RMU xside     0 = fail, 1 = pass
   --    7      ARINC 429 TACAN bus     0 = fail, 1 = pass
   --    8      ARINC 429 status        0 = fail, 1 = pass
   --    9      ARINC 429 UHF   0 = fail, 1 = pass
   --   10      RAM battery     0 = fail, 1 = pass
   --   11      Aux Pwr #1      0 = fail, 1 = pass
   --   12      Aux Pwr #2      0 = fail, 1 = pass
   --   13 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)


   --   2.3.5.6.2 Intermediate word #2
   --   Bit No. Function        Status
   --    0 -  1 VHF COM #1 test result  Result matrix
   --    2 -  3 VHF COM #2 test result  Result matrix
   --    4 -  5 VHF COM #3 test result  Result matrix
   --    6 -  7 UHF COM #1 test result  Result matrix
   --    8 -  9 UHF COM #2 test result  Result matrix
   --   10 - 11 HF COM #1 test result   Result matrix
   --   12 - 13 HF COM #2 test result   Result matrix
   --   14 - 15 NAV #1 test result      Result matrix
   --   16 - 17 NAV #2 test result      Result matrix
   --   18 - 19 DME #1 test result      Result matrix
   --   20 - 21 DME #2 test result      Result matrix
   --   22 - 23 ADF #1 test result      Result matrix
   --   24 - 25 ADF #2 test result      Result matrix
   --   26 - 27 Transponder #1 test result      Result matrix
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)


   --   2.3.5.6.3 Intermediate word #3
   --   Bit No. Function        Status
   --    0 -  1 Transponder #2 test result      Result matrix
   --    2 -  3 MLS #1 test result      Result matrix
   --    4 -  5 MLS #2 test result      Result matrix
   --    6 -  7 TACAN #1 test result    Result matrix
   --    8 -  9 TACAN #2 test result    Result matrix
   --   10      NMS #1 test result      0 = not reporting, 1 = reporting
   --   11      NMS #2 test result      0 = not reporting, 1 = reporting
   --   12      FCS #1 test result      0 = not reporting, 1 = reporting
   --   13      FCS #2 test result      0 = not reporting, 1 = reporting
   --   14      EFIS #1 test result     0 = not reporting, 1 = reporting
   --   15      EFIS #2 test result     0 = not reporting, 1 = reporting
   --   16 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Kda_Test_Result_Inter_1_Type is
      record
         Ram_Pass                  : Boolean := False;
         Eprom_Pass                : Boolean := False;
         Power_Supply_Pass         : Boolean := False;
         Arinc_429_Radio_1_Pass    : Boolean := False;
         Arinc_429_Radio_2_Pass    : Boolean := False;
         Arinc_429_Rmu_Onside_Pass : Boolean := False;
         Arinc_429_Rmu_Xside_Pass  : Boolean := False;
         Arinc_429_Tacan_Bus_Pass  : Boolean := False;
         Arinc_429_Status_Pass     : Boolean := False;
         Arinc_429_Uhf_Pass        : Boolean := False;
         Ram_Battery_Pass          : Boolean := False;
         Aux_Pwr_1_Pass            : Boolean := False;
         Aux_Pwr_2_Pass            : Boolean := False;
         Sp13                      : Spare_Type := Spare;
         Sp14                      : Spare_Type := Spare;
         Sp15                      : Spare_Type := Spare;
         Sp16                      : Spare_Type := Spare;
         Sp17                      : Spare_Type := Spare;
         Sp18                      : Spare_Type := Spare;
         Sp19                      : Spare_Type := Spare;
         Sp20                      : Spare_Type := Spare;
         Sp21                      : Spare_Type := Spare;
         Sp22                      : Spare_Type := Spare;
         Sp23                      : Spare_Type := Spare;
         Sp24                      : Spare_Type := Spare;
         Sp25                      : Spare_Type := Spare;
         Sp26                      : Spare_Type := Spare;
         Sp27                      : Spare_Type := Spare;
         Sp28                      : Spare_Type := Spare;
         Word_Type                 : Word := initial;
         Parity                    : Spare_Type := Spare;
      end record;
   for Kda_Test_Result_Inter_1_Type use
      record
         Ram_Pass                  at 0 range 0 .. 0;
         Eprom_Pass                at 0 range 1 .. 1;
         Power_Supply_Pass         at 0 range 2 .. 2;
         Arinc_429_Radio_1_Pass    at 0 range 3 .. 3;
         Arinc_429_Radio_2_Pass    at 0 range 4 .. 4;
         Arinc_429_Rmu_Onside_Pass at 0 range 5 .. 5;
         Arinc_429_Rmu_Xside_Pass  at 0 range 6 .. 6;
         Arinc_429_Tacan_Bus_Pass  at 0 range 7 .. 7;
         Arinc_429_Status_Pass     at 0 range 8 .. 8;
         Arinc_429_Uhf_Pass        at 0 range 9 .. 9;
         Ram_Battery_Pass          at 0 range 10 .. 10;
         Aux_Pwr_1_Pass            at 0 range 11 .. 11;
         Aux_Pwr_2_Pass            at 0 range 12 .. 12;
         Sp13                      at 0 range 13 .. 13;
         Sp14                      at 0 range 14 .. 14;
         Sp15                      at 0 range 15 .. 15;
         Sp16                      at 0 range 16 .. 16;
         Sp17                      at 0 range 17 .. 17;
         Sp18                      at 0 range 18 .. 18;
         Sp19                      at 0 range 19 .. 19;
         Sp20                      at 0 range 20 .. 20;
         Sp21                      at 0 range 21 .. 21;
         Sp22                      at 0 range 22 .. 22;
         Sp23                      at 0 range 23 .. 23;
         Sp24                      at 0 range 24 .. 24;
         Sp25                      at 0 range 25 .. 25;
         Sp26                      at 0 range 26 .. 26;
         Sp27                      at 0 range 27 .. 27;
         Sp28                      at 0 range 28 .. 28;
         Word_Type                 at 0 range 29 .. 30;
         Parity                    at 0 range 31 .. 31;
      end record;
   for Kda_Test_Result_Inter_1_Type'Size use 32;
   Kda_Test_Result_Inter_1 : Kda_Test_Result_Inter_1_Type;

   type Result_Matrix is (Fail,Pass,Not_Available,No_Power);
   for Result_Matrix'Size use 2;

   type Kda_Test_Result_Inter_2_Type is
      record
         Vhf_Com_1_Test_Result : Result_Matrix;
         Vhf_Com_2_Test_Result : Result_Matrix;
         Vhf_Com_3_Test_Result : Result_Matrix;
         Uhf_Com_1_Test_Result : Result_Matrix;
         Uhf_Com_2_Test_Result : Result_Matrix;
         Hf_Com_1_Test_Result  : Result_Matrix;
         Hf_Com_2_Test_Result  : Result_Matrix;
         Nav_1_Test_Result     : Result_Matrix;
         Nav_2_Test_Result     : Result_Matrix;
         Dme_1_Test_Result     : Result_Matrix;
         Dme_2_Test_Result     : Result_Matrix;
         Adf_1_Test_Result     : Result_Matrix;
         Adf_2_Test_Result     : Result_Matrix;
         Xpdr_1_Test_Result    : Result_Matrix;
         Sp28                  : Spare_Type := Spare;
         Word_Type             : Word := initial;
         Parity                : Spare_Type := Spare;
      end record;
   for Kda_Test_Result_Inter_2_Type use
      record
         Vhf_Com_1_Test_Result at 0 range 0 .. 1;
         Vhf_Com_2_Test_Result at 0 range 2 .. 3;
         Vhf_Com_3_Test_Result at 0 range 4 .. 5;
         Uhf_Com_1_Test_Result at 0 range 6 .. 7;
         Uhf_Com_2_Test_Result at 0 range 8 .. 9;
         Hf_Com_1_Test_Result  at 0 range 10 .. 11;
         Hf_Com_2_Test_Result  at 0 range 12 .. 13;
         Nav_1_Test_Result     at 0 range 14 .. 15;
         Nav_2_Test_Result     at 0 range 16 .. 17;
         Dme_1_Test_Result     at 0 range 18 .. 19;
         Dme_2_Test_Result     at 0 range 20 .. 21;
         Adf_1_Test_Result     at 0 range 22 .. 23;
         Adf_2_Test_Result     at 0 range 24 .. 25;
         Xpdr_1_Test_Result    at 0 range 26 .. 27;
         Sp28                  at 0 range 28 .. 28;
         Word_Type             at 0 range 29 .. 30;
         Parity                at 0 range 31 .. 31;
      end record;
   for Kda_Test_Result_Inter_2_Type'Size use 32;
   Kda_Test_Result_Inter_2 : Kda_Test_Result_Inter_2_Type;

   type Kda_Test_Result_Inter_3_Type is
      record
         Xpdr_2_Test_Result    : Result_Matrix;
         Mls_1_Test_Result     : Result_Matrix;
         Mls_2_Test_Result     : Result_Matrix;
         Tacan_1_Test_Result   : Result_Matrix;
         Tacan_2_Test_Result   : Result_Matrix;
         Nms_1_Test_Reporting  : Boolean := False;
         Nms_2_Test_Reporting  : Boolean := False;
         Fcs_1_Test_Reporting  : Boolean := False;
         Fcs_2_Test_Reporting  : Boolean := False;
         Efis_1_Test_Reporting : Boolean := False;
         Efis_2_Test_Reporting : Boolean := False;
         Sp16                  : Spare_Type := Spare;
         Sp17                  : Spare_Type := Spare;
         Sp18                  : Spare_Type := Spare;
         Sp19                  : Spare_Type := Spare;
         Sp20                  : Spare_Type := Spare;
         Sp21                  : Spare_Type := Spare;
         Sp22                  : Spare_Type := Spare;
         Sp23                  : Spare_Type := Spare;
         Sp24                  : Spare_Type := Spare;
         Sp25                  : Spare_Type := Spare;
         Sp26                  : Spare_Type := Spare;
         Sp27                  : Spare_Type := Spare;
         Sp28                  : Spare_Type := Spare;
         Word_Type             : Word := initial;
         Parity                : Spare_Type := Spare;
      end record;
   for Kda_Test_Result_Inter_3_Type use
      record
         Xpdr_2_Test_Result    at 0 range 0 .. 1;
         Mls_1_Test_Result     at 0 range 2 .. 3;
         Mls_2_Test_Result     at 0 range 4 .. 5;
         Tacan_1_Test_Result   at 0 range 6 .. 7;
         Tacan_2_Test_Result   at 0 range 8 .. 9;
         Nms_1_Test_Reporting  at 0 range 10 .. 10;
         Nms_2_Test_Reporting  at 0 range 11 .. 11;
         Fcs_1_Test_Reporting  at 0 range 12 .. 12;
         Fcs_2_Test_Reporting  at 0 range 13 .. 13;
         Efis_1_Test_Reporting at 0 range 14 .. 14;
         Efis_2_Test_Reporting at 0 range 15 .. 15;
         Sp16                  at 0 range 16 .. 16;
         Sp17                  at 0 range 17 .. 17;
         Sp18                  at 0 range 18 .. 18;
         Sp19                  at 0 range 19 .. 19;
         Sp20                  at 0 range 20 .. 20;
         Sp21                  at 0 range 21 .. 21;
         Sp22                  at 0 range 22 .. 22;
         Sp23                  at 0 range 23 .. 23;
         Sp24                  at 0 range 24 .. 24;
         Sp25                  at 0 range 25 .. 25;
         Sp26                  at 0 range 26 .. 26;
         Sp27                  at 0 range 27 .. 27;
         Sp28                  at 0 range 28 .. 28;
         Word_Type             at 0 range 29 .. 30;
         Parity                at 0 range 31 .. 31;
      end record;
   for Kda_Test_Result_Inter_3_Type'Size use 32;
   Kda_Test_Result_Inter_3 : Kda_Test_Result_Inter_3_Type;

   --   2.3.5.7 Time and date

   --   This shall be sent from the KDA 557 to the RMU 556
   --   when requested by a poll message.

   --   This shall be sent from the RMU 556 to the KDA 557 if the
   --   user chooses to set the time and date.  The KDA 557 shall
   --   set its real-time clock to the time and date received in this word.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           66      Time and data

   --   2.3.5.7.1 Intermediate word
   --   Bit No. Function        Status
   --    0 -  4 Day     Range = 1 to 31
   --    5 -  8 Month   Range = 1 to 12; 1 = jan, 12 = dec
   --    9 - 15 Year    Year = 1990 + value
   --   16 - 21 Minutes Range = 0 to 59
   --   22 - 23 Spare   0
   --   24 - 28 Hours   Range = 0 to 23
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Kda_Time_Date_Inter_Type is
      record
         Day       : Int5_Type;
         Month     : Int4_Type := 0;
         Year      : Int7_Type;
         Minutes   : Int6_Type;
         Sp22      : Spare_Type := Spare;
         Sp23      : Spare_Type := Spare;
         Hours     : Int5_Type;
         Word_Type : Word := initial;
         Parity    : Spare_Type := Spare;
      end record;
   for Kda_Time_Date_Inter_Type use
      record
         Day       at 0 range 0 .. 4;
         Month     at 0 range 5 .. 8;
         Year      at 0 range 9 .. 15;
         Minutes   at 0 range 16 .. 21;
         Sp22      at 0 range 22 .. 22;
         Sp23      at 0 range 23 .. 23;
         Hours     at 0 range 24 .. 28;
         Word_Type at 0 range 29 .. 30;
         Parity    at 0 range 31 .. 31;
      end record;
   for Kda_Time_Date_Inter_Type'Size use 32;
   Kda_Time_Date_Inter : Kda_Time_Date_Inter_Type;

   --   2.3.5.10 KDA 557 software revision

   --   This shall be the same 4 digit number that appears on
   --   the software ID tag on the outside of the unit.  This
   --   shall be sent by the KDA 557 to the RMU 556 when requested
   --   by a poll message.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           69      KDA 557 software revision

   --   2.3.5.10.1 Intermediate word #1
   --   Bit No. Function        Status
   --    0 -  7 KDA 557 software revision       Binary
   --                   Range = 00 to 0FFH
   --    8 - 15 KDA 557 software version        Binary
   --                   Range = 00 to 0FFH
   --   16 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Kda_Software_Revision_Inter_1_Type is
      record
         Kda_Software_Revision_1 : Int8_Type := 0;
         Kda_Software_Revision_2 : Int8_Type := 0;
         Sp16                    : Spare_Type := Spare;
         Sp17                    : Spare_Type := Spare;
         Sp18                    : Spare_Type := Spare;
         Sp19                    : Spare_Type := Spare;
         Sp20                    : Spare_Type := Spare;
         Sp21                    : Spare_Type := Spare;
         Sp22                    : Spare_Type := Spare;
         Sp23                    : Spare_Type := Spare;
         Sp24                    : Spare_Type := Spare;
         Sp25                    : Spare_Type := Spare;
         Sp26                    : Spare_Type := Spare;
         Sp27                    : Spare_Type := Spare;
         Sp28                    : Spare_Type := Spare;
         Word_Type               : Word := initial;
         Parity                  : Spare_Type := Spare;
      end record;
   for Kda_Software_Revision_Inter_1_Type use
      record
         Kda_Software_Revision_1 at 0 range 0 .. 7;
         Kda_Software_Revision_2 at 0 range 8 .. 15;
         Sp16                    at 0 range 16 .. 16;
         Sp17                    at 0 range 17 .. 17;
         Sp18                    at 0 range 18 .. 18;
         Sp19                    at 0 range 19 .. 19;
         Sp20                    at 0 range 20 .. 20;
         Sp21                    at 0 range 21 .. 21;
         Sp22                    at 0 range 22 .. 22;
         Sp23                    at 0 range 23 .. 23;
         Sp24                    at 0 range 24 .. 24;
         Sp25                    at 0 range 25 .. 25;
         Sp26                    at 0 range 26 .. 26;
         Sp27                    at 0 range 27 .. 27;
         Sp28                    at 0 range 28 .. 28;
         Word_Type               at 0 range 29 .. 30;
         Parity                  at 0 range 31 .. 31;
      end record;
   for Kda_Software_Revision_Inter_1_Type'Size use 32;
   Kda_Software_Revision_Inter_1 : Kda_Software_Revision_Inter_1_Type;

   --   2.3.5.11 End of Initialization data

   --   This word shall be sent at the end of initialization data
   --   to allow the RMU 556 to be able to determine that all
   --   intialization data has been transmitted.  There are no
   --   intermediate words defined for this label.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           6C      End of initialization data


   --   2.3.6 Configuration data

   --   This shall be sent from the KDA 557 to the RMU 556 when polled
   --   for by the RMU 556 or by the transmit configuration data bit
   --   in the RMU 556 command data message.

   --   This shall be sent from the RMU 556 to the KDA 557 whenever the
   --    user ACCEPTs a changed parameter while editing configuration.

   --   2.3.6.1 Configuration data memory map

   --   Byte No.        Function        Status
   --     0     Operational Revision Status     Binary
   --     1 -   2       KDA 557 #1 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --     3 -   4       KDA 557 #2 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --     5 -   6       RMU 556 #1 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --     7 -   8       RMU 556 #2 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --     9 -  10       RMU 556 #3 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --    11 -  12       RMU 556 #4 last 4 digits of part number Binary
   --                   Range = 0, 0101 to 9999
   --                   0 = not present
   --    13 -  14       System status   see note 6
   --    15     NMS type        see note 7
   --    16     FCS type        see note 7
   --    17     EFIS type       see note 7
   --    18     NAV output discretes    see note 16
   --    19     spare   0
   --    20     Discrete input #3       see note 1
   --    21     Discrete input #4       see note 1
   --    22     Discrete input #5       see note 1
   --    23     Discrete input #6       see note 1
   --    24     Discrete output #1      see note 2
   --    25     Discrete output #2      see note 2
   --    26     Discrete output #3      see note 2
   --    27     Discrete output #4      see note 2
   --    28     Discrete output #5      see note 2
   --    29 -  36       spare   0
   --    37 -  41       VHF COM #1      see note 3
   --    42 -  46       VHF COM #2      see note 3
   --    47 -  51       VHF COM #3      see note 3
   --    52 -  56       UHF COM #1      see note 4
   --    57 -  61       UHF COM #2      see note 4
   --    62 -  66       HF COM #1       0
   --    67 -  71       HF COM #2       0
   --    72 -  76       NAV #1  see note 14
   --    77 -  81       NAV #2  see note 14
   --    82 -  86       DME #1  see note 5
   --    87 -  91       DME #2  see note 5
   --    92 -  96       ADF #1  see note 5
   --    97 - 101       ADF #2  see note 5
   --   102 - 106       Transponder #1  see note 5
   --   107 - 111       Transponder #2  see note 5
   --   112 - 116       MLS #1  see note 5
   --   117 - 121       MLS #2  see note 5
   --   122 - 126       TACAN #1        see note 12
   --   127 - 131       TACAN #2        see note 12
   --   132 - 251       Spare   0


   --   Note 1: Discrete input structure:

   --   Bit no. Function        Status
   --   0       Discrete present        0 = not present, 1 = present
   --   1       Logic level     0 = normal, 1 = inverted


   --   Note 2: Discrete output structure:

   --   Bit no. Function        Status
   --   0       Discrete present        0 = not present, 1 = present
   --   1       Active level    0 = low, 1 = high
   --   2       Logic level     0 = normal, 1 = inverted


   --   Note 3: VHF COM:

   --   Byte no.        Function        Status
   --   0       Radio common    see note 8
   --   1       Radio model     0 = Bendix/King VC-401B
   --   2       System 1 display        see note 9
   --   3       System 2 display        see note 9
   --   4       VHF COM special see note 10


   --   Note 4: UHF COM:

   --   Byte no.        Function        Status
   --   0       Radio common    see note 8
   --   1       Radio model     0 = Magnavox RT-1504
   --                   1 = Magnavox RT-1145B
   --                       or Magnavox RT-1146B
   --                   2 = Bendix/King KTR-909
   --   2       System 1 display        see note 9
   --   3       System 2 display        see note 9
   --   4       UHF COM special see note 11


   --   Note 5: DME, ADF, MLS, Transponder radios:

   --   Byte no.        Function        Status
   --   0       Radio common    see note 8
   --   1       Radio model     DME
   --                   0 = Bendix/King DM-441B
   --                   1 = Bendix/King KDM 706A
   --                   ADF
   --                   0 = Bendix/King DF-431B
   --                   MLS
   --                   0 = Bendix/King ML-221B -1110
   --                   1 = MLS Marketing Demonstration
   --                   Transponder
   --                   0 = Bendix/King TRA-67A or MST-67A (TCAS II option)
   --                   1 = Bendix/King TRA-67A or MST-67A (TCAS I option)
   --                   2 = ATC Marketing Demonstration

   --   2       System 1 display        see note 9
   --   3       System 2 display        see note 9
   --   4       Spare   0


   --   note 6: System status:

   --   First byte:
   --   Bit no. Function        Status
   --   0       Memory security 0 = not secure, 1 = secure
   --   1       Display type    0 = monochrome CRT
   --   2       SYS button present      0 = not present, 1 = present
   --   3       AUX button present      0 = not present, 1 = present
   --   4       TCAS present    0 = not present, 1 = present
   --   5       DME identifier active   0 = inactive, 1 = active
   --   6       Tandem operation        0 = inactive, 1 = active
   --   7       TCAS range control      0 = not present, 1 = present

   --   Second byte:
   --   Bit no. Function        Status
   --   0       Zero crossbar   0 = no crossbar, 1 = crossbar
   --   1       Channel tuning  0 = normal memory tuning,
   --                   1 = channel tuning
   --   2       Empty memory timeout    0 = no timeout, 1 = timeout
   --   3 - 7   Spare   0


   --   note 7: EFIS, NMS, FCS type:

   --   Bit no. Function        Status
   --   0 - 3   Unit #1 type    EFIS
   --                   0  not present
   --                   1  Bendix/King EFIS 10
   --                   2  Bendix/King EFIS 40/50
   --                   NMS
   --                   0  not present
   --                   1  Bendix/King KNC 667
   --                   FCS
   --                   0  not present
   --                   1  Bendix/King KCP 420
   --   4 - 7   Unit #2 type    same as unit #1 type


   --   note 8: Radio common:

   --   Bit no. Function        Status
   --   0       Radio present   0 = not present, 1 = present
   --   1 - 2   KDA 557 connect 2 1
   --                   0 0  both KDA #1 and KDA #2
   --                   0 1  KDA #1
   --                   1 0  KDA #2
   --   3       Radio number display    0 = blank, 1 = radio number
   --   4 - 5   Power bus       5 4
   --                   0 0  emergency
   --                   0 1  avionics #1
   --                   1 0  avionics #2
   --   6 - 7   Backup control head     7 6
   --                   0 0  absent
   --                   0 1  group 1
   --                   1 0  group 2


   --   note 9: System display:

   --   Bit no. Function        Status
   --   0 - 3   Active page number      Binary
   --                   Range = 0 to 3
   --                   0 = not displayed
   --   4 - 7   Field number    Binary
   --                   Range = 1 to 5
   --                   ignored if not displayed


   --   note 10: VHF COM special:

   --   Bit no. Function        Status
   --   0       Display label   0 = COM, 1 = radio type
   --   1       VHF tuning range        0 = 118 to 136 MHz
   --                   1 = 118 to 151 MHz
   --   2 - 7   Spare   0


   --   note 11: UHF COM special:

   --   Bit no. Function        Status
   --   0       Display label   0 = COM, 1 = radio type
   --   1       ADF present     0 = absent, 1 = present
   --   2 - 7   Spare   0


   --   Note 12: TACAN:

   --   Byte no.        Function        Status
   --   0       Radio common    see note 8
   --   1       Radio model     0 = Bendix/King KRT-707
   --                           1 = Foster TCN-970
   --   2       System 1 display        see note 9
   --   3       System 2 display        see note 9
   --   4       TACAN special   see note 13


   --   note 13: TACAN special:

   --   Bit no. Function        Status
   --   0       Air to Air mode present 0 = absent, 1 = present
   --   1 - 7   Spare   0


   --   Note 14: NAV:

   --   Byte no.        Function        Status
   --   0       Radio common    see note 8
   --   1       Radio model     0 = Bendix/King VN-411B
   --   2       System 1 display        see note 9
   --   3       System 2 display        see note 9
   --   4       NAV special     see note 15


   --   note 15: NAV special:

   --   Bit no. Function        Status
   --   0       Display label   0 = NAV label, 1 = VOR/LOC label
   --   1 - 7   Spare   0


   --   note 16: NAV output discretes:

   --   Bit no. Function        Status
   --   1 - 3   NAV disc out 1 function (OUT6)  3 2 1 0
   --                   0 0 0 0  not used
   --                   0 0 0 1  DME Hold1
   --                   0 0 1 0  DME Hold2
   --                   0 0 1 1  NAV/TACAN control

   --   4 - 7   NAV disc out 2 function (UHFTONE)       7 6 5 4
   --                   0 0 0 0  UHF Tone (default)
   --                   0 0 0 1  DME Hold1
   --                   0 0 1 0  DME Hold2
   --                   0 0 1 1  NAV/TACAN control


   --   2.3.6.2 Configuration data intermediate word n

   --   All bytes from 0 to 251 shall be sent.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           80      Configuration data from memory
   --           81      Configuration data from rack

   --   Bit No. Function        Status
   --    0 -  7 Configuration data byte (n - 1) * 3     binary
   --    8 - 15 Configuration data byte ((n - 1) * 3 + 1        binary
   --   16 - 23 Configuration data byte ((n - 1) * 3 + 2        binary
   --   24 - 25 number of valid bytes in word   Range = 1 to 3
   --   26 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Configuration_Data_Inter_Type is
      record
         Byte_1                      : Int8_Type := 0;
         Byte_2                      : Int8_Type := 0;
         Byte_3                      : Int8_Type := 0;
         Number_Valid_Bytes_In_Word  : Int2_Type;
         Sp26                        : Spare_Type := Spare;
         Sp27                        : Spare_Type := Spare;
         Sp28                        : Spare_Type := Spare;
         Word_Type                   : Word := initial;
         Parity                      : Spare_Type := Spare;
      end record;
   for Configuration_Data_Inter_Type use
      record
         Byte_1                      at 0 range 0 .. 7;
         Byte_2                      at 0 range 8 .. 15;
         Byte_3                      at 0 range 16 .. 23;
         Number_Valid_Bytes_In_Word  at 0 range 24 .. 25;
         Sp26                        at 0 range 26 .. 26;
         Sp27                        at 0 range 27 .. 27;
         Sp28                        at 0 range 28 .. 28;
         Word_Type                   at 0 range 29 .. 30;
         Parity                      at 0 range 31 .. 31;
      end record;
   for Configuration_Data_Inter_Type'Size use 32;

   type Configuration_Data_Type is array (1 .. 84) of
     Configuration_Data_Inter_Type;

   Configuration_Data : constant Configuration_Data_Type :=
     (1   => (Byte_1                     => 2#00000000#, --config byte 0
              Byte_2                     => 2#00000000#, --config byte 1
              Byte_3                     => 2#01100101#, --config byte 2
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      2   => (Byte_1                     => 2#00000000#, --config byte 3
              Byte_2                     => 2#00000000#, --config byte 4
              Byte_3                     => 2#00000011#, --config byte 5
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      3   => (Byte_1                     => 2#11101001#, --config byte 6
              Byte_2                     => 2#00000000#, --config byte 7
              Byte_3                     => 2#00000000#, --config byte 8
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      4   => (Byte_1                     => 2#00000000#, --config byte 9
              Byte_2                     => 2#00000000#, --config byte 10
              Byte_3                     => 2#00000000#, --config byte 11
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      5   => (Byte_1                     => 2#00000000#, --config byte 12
              Byte_2                     => 2#00000000#, --config byte 13
              Byte_3                     => 2#00000100#, --config byte 14
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      6   => (Byte_1                     => 2#00000000#, --config byte 15
              Byte_2                     => 2#00000000#, --config byte 16
              Byte_3                     => 2#00000000#, --config byte 17
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      7   => (Byte_1                     => 2#00000000#, --config byte 18
              Byte_2                     => 2#00000000#, --config byte 19
              Byte_3                     => 2#00000000#, --config byte 20
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      8   => (Byte_1                     => 2#00000000#, --config byte 21
              Byte_2                     => 2#00000000#, --config byte 22
              Byte_3                     => 2#00000000#, --config byte 23
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      9   => (Byte_1                     => 2#00000000#, --config byte 24
              Byte_2                     => 2#00000000#, --config byte 25
              Byte_3                     => 2#00000000#, --config byte 26
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      10  => (Byte_1                     => 2#00000000#, --config byte 27
              Byte_2                     => 2#00000000#, --config byte 28
              Byte_3                     => 2#00000000#, --config byte 29
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      11  => (Byte_1                     => 2#00000000#, --config byte 30
              Byte_2                     => 2#00000000#, --config byte 31
              Byte_3                     => 2#00000000#, --config byte 32
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      12  => (Byte_1                     => 2#00000000#, --config byte 33
              Byte_2                     => 2#00000000#, --config byte 34
              Byte_3                     => 2#00000000#, --config byte 35
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      13  => (Byte_1                     => 2#00000000#, --config byte 36
              Byte_2                     => 2#00010011#, --config byte 37 Radio Common VHF 1
              Byte_3                     => 2#00000000#, --config byte 38 Radio Model
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      14  => (Byte_1                     => 2#00100001#, --config byte 39 System 1 Display
              Byte_2                     => 2#00000000#, --config byte 40 System 2 Display
              Byte_3                     => 2#00000011#, --config byte 41 VHF Com Special
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      15  => (Byte_1                     => 2#00000000#, --config byte 42 Radio Common VHF 2
              Byte_2                     => 2#00000000#, --config byte 43
              Byte_3                     => 2#00000000#, --config byte 44
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      16  => (Byte_1                     => 2#00000000#, --config byte 45
              Byte_2                     => 2#00000000#, --config byte 46
              Byte_3                     => 2#00000000#, --config byte 47 Radio Common VHF 3
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      17  => (Byte_1                     => 2#00000000#, --config byte 48
              Byte_2                     => 2#00000000#, --config byte 49
              Byte_3                     => 2#00000000#, --config byte 50
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      18  => (Byte_1                     => 2#00000000#, --config byte 51
              Byte_2                     => 2#01010011#, --config byte 52 Radio Common UHF 1
              Byte_3                     => 2#00000010#, --config byte 53 Radio Model
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      19  => (Byte_1                     => 2#00010001#, --config byte 54 System 1 Display
              Byte_2                     => 2#00000000#, --config byte 55 System 2 Display
              Byte_3                     => 2#00000001#, --config byte 56 UHF Com Special
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      20  => (Byte_1                     => 2#00000000#, --config byte 57 Radio Common UHF 2
              Byte_2                     => 2#00000000#, --config byte 58
              Byte_3                     => 2#00000000#, --config byte 59
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      21  => (Byte_1                     => 2#00000000#, --config byte 60 HF Com 1
              Byte_2                     => 2#00000000#, --config byte 61
              Byte_3                     => 2#00000000#, --config byte 62
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      22  => (Byte_1                     => 2#00000000#, --config byte 63
              Byte_2                     => 2#00000000#, --config byte 64
              Byte_3                     => 2#00000000#, --config byte 65
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      23  => (Byte_1                     => 2#00000000#, --config byte 66
              Byte_2                     => 2#00000000#, --config byte 67 HF Com 2
              Byte_3                     => 2#00000000#, --config byte 68
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      24  => (Byte_1                     => 2#00000000#, --config byte 69
              Byte_2                     => 2#00000000#, --config byte 70
              Byte_3                     => 2#00000000#, --config byte 71
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      25  => (Byte_1                     => 2#00010011#, --config byte 72 Radio Common NAV 1
              Byte_2                     => 2#00000000#, --config byte 73 Radio Model
              Byte_3                     => 2#01010001#, --config byte 74 System 1 Display
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      26  => (Byte_1                     => 2#00000000#, --config byte 75 System 2 Display
              Byte_2                     => 2#00000001#, --config byte 76 Nav Special
              Byte_3                     => 2#00000000#, --config byte 77 NAV 2
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      27  => (Byte_1                     => 2#00000000#, --config byte 78
              Byte_2                     => 2#00000000#, --config byte 79
              Byte_3                     => 2#00000000#, --config byte 80
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      28  => (Byte_1                     => 2#00000000#, --config byte 81
              Byte_2                     => 2#00010011#, --config byte 82 Radio Common DME 1
              Byte_3                     => 2#00000000#, --config byte 83 Radio Model
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      29  => (Byte_1                     => 2#01010001#, --config byte 84 System 1 Display
              Byte_2                     => 2#00000000#, --config byte 85 System 2 Display
              Byte_3                     => 2#00000000#, --config byte 86 Spare
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      30  => (Byte_1                     => 2#00000000#, --config byte 87 DME 2
              Byte_2                     => 2#00000000#, --config byte 88
              Byte_3                     => 2#00000000#, --config byte 89
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      31  => (Byte_1                     => 2#00000000#, --config byte 90
              Byte_2                     => 2#00000000#, --config byte 91
              Byte_3                     => 2#00000000#, --config byte 92 ADF 1
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      32  => (Byte_1                     => 2#00000000#, --config byte 93
              Byte_2                     => 2#00000000#, --config byte 94
              Byte_3                     => 2#00000000#, --config byte 95
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      33  => (Byte_1                     => 2#00000000#, --config byte 96
              Byte_2                     => 2#00000000#, --config byte 97 ADF 2
              Byte_3                     => 2#00000000#, --config byte 98
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      34  => (Byte_1                     => 2#00000000#, --config byte 99
              Byte_2                     => 2#00000000#, --config byte 100
              Byte_3                     => 2#00000000#, --config byte 101
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      35  => (Byte_1                     => 2#00010011#, --config byte 102 Radio Common Transponder 1
              Byte_2                     => 2#00000000#, --config byte 103 Radio Model
              Byte_3                     => 2#00110001#, --config byte 104 System 1 Display
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      36  => (Byte_1                     => 2#00000000#, --config byte 105 System 2 Display
              Byte_2                     => 2#00000000#, --config byte 106 Spare
              Byte_3                     => 2#00000000#, --config byte 107 Transponder 2
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      37  => (Byte_1                     => 2#00000000#, --config byte 108
              Byte_2                     => 2#00000000#, --config byte 109
              Byte_3                     => 2#00000000#, --config byte 110
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      38  => (Byte_1                     => 2#00000000#, --config byte 111
              Byte_2                     => 2#00000000#, --config byte 112
              Byte_3                     => 2#00000000#, --config byte 113
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      39  => (Byte_1                     => 2#00000000#, --config byte 114
              Byte_2                     => 2#00000000#, --config byte 115
              Byte_3                     => 2#00000000#, --config byte 116
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      40  => (Byte_1                     => 2#00000000#, --config byte 117
              Byte_2                     => 2#00000000#, --config byte 118
              Byte_3                     => 2#00000000#, --config byte 119
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      41  => (Byte_1                     => 2#00000000#, --config byte 120
              Byte_2                     => 2#00000000#, --config byte 121
              Byte_3                     => 2#00000000#, --config byte 122
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      42  => (Byte_1                     => 2#00000000#, --config byte 123
              Byte_2                     => 2#00000000#, --config byte 124
              Byte_3                     => 2#00000000#, --config byte 125
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      43  => (Byte_1                     => 2#00000000#, --config byte 126
              Byte_2                     => 2#00000000#, --config byte 127
              Byte_3                     => 2#00000000#, --config byte 128
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      44  => (Byte_1                     => 2#00000000#, --config byte 129
              Byte_2                     => 2#00000000#, --config byte 130
              Byte_3                     => 2#00000000#, --config byte 131
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      45  => (Byte_1                     => 2#00000000#, --config byte 132
              Byte_2                     => 2#00000000#, --config byte 133
              Byte_3                     => 2#00000000#, --config byte 134
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      46  => (Byte_1                     => 2#00000000#, --config byte 135
              Byte_2                     => 2#00000000#, --config byte 136
              Byte_3                     => 2#00000000#, --config byte 137
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      47  => (Byte_1                     => 2#00000000#, --config byte 138
              Byte_2                     => 2#00000000#, --config byte 139
              Byte_3                     => 2#00000000#, --config byte 140
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      48  => (Byte_1                     => 2#00000000#, --config byte 141
              Byte_2                     => 2#00000000#, --config byte 142
              Byte_3                     => 2#00000000#, --config byte 143
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      49  => (Byte_1                     => 2#00000000#, --config byte 144
              Byte_2                     => 2#00000000#, --config byte 145
              Byte_3                     => 2#00000000#, --config byte 146
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      50  => (Byte_1                     => 2#00000000#, --config byte 147
              Byte_2                     => 2#00000000#, --config byte 148
              Byte_3                     => 2#00000000#, --config byte 149
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      51  => (Byte_1                     => 2#00000000#, --config byte 150
              Byte_2                     => 2#00000000#, --config byte 151
              Byte_3                     => 2#00000000#, --config byte 152
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      52  => (Byte_1                     => 2#00000000#, --config byte 153
              Byte_2                     => 2#00000000#, --config byte 154
              Byte_3                     => 2#00000000#, --config byte 155
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      53  => (Byte_1                     => 2#00000000#, --config byte 156
              Byte_2                     => 2#00000000#, --config byte 157
              Byte_3                     => 2#00000000#, --config byte 158
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      54  => (Byte_1                     => 2#00000000#, --config byte 159
              Byte_2                     => 2#00000000#, --config byte 160
              Byte_3                     => 2#00000000#, --config byte 161
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      55  => (Byte_1                     => 2#00000000#, --config byte 162
              Byte_2                     => 2#00000000#, --config byte 163
              Byte_3                     => 2#00000000#, --config byte 164
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      56  => (Byte_1                     => 2#00000000#, --config byte 165
              Byte_2                     => 2#00000000#, --config byte 166
              Byte_3                     => 2#00000000#, --config byte 167
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      57  => (Byte_1                     => 2#00000000#, --config byte 168
              Byte_2                     => 2#00000000#, --config byte 169
              Byte_3                     => 2#00000000#, --config byte 170
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      58  => (Byte_1                     => 2#00000000#, --config byte 171
              Byte_2                     => 2#00000000#, --config byte 172
              Byte_3                     => 2#00000000#, --config byte 173
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      59  => (Byte_1                     => 2#00000000#, --config byte 174
              Byte_2                     => 2#00000000#, --config byte 175
              Byte_3                     => 2#00000000#, --config byte 176
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      60  => (Byte_1                     => 2#00000000#, --config byte 177
              Byte_2                     => 2#00000000#, --config byte 178
              Byte_3                     => 2#00000000#, --config byte 179
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      61  => (Byte_1                     => 2#00000000#, --config byte 180
              Byte_2                     => 2#00000000#, --config byte 181
              Byte_3                     => 2#00000000#, --config byte 182
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      62  => (Byte_1                     => 2#00000000#, --config byte 183
              Byte_2                     => 2#00000000#, --config byte 184
              Byte_3                     => 2#00000000#, --config byte 185
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      63  => (Byte_1                     => 2#00000000#, --config byte 186
              Byte_2                     => 2#00000000#, --config byte 187
              Byte_3                     => 2#00000000#, --config byte 188
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      64  => (Byte_1                     => 2#00000000#, --config byte 189
              Byte_2                     => 2#00000000#, --config byte 190
              Byte_3                     => 2#00000000#, --config byte 191
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      65  => (Byte_1                     => 2#00000000#, --config byte 192
              Byte_2                     => 2#00000000#, --config byte 193
              Byte_3                     => 2#00000000#, --config byte 194
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      66  => (Byte_1                     => 2#00000000#, --config byte 195
              Byte_2                     => 2#00000000#, --config byte 196
              Byte_3                     => 2#00000000#, --config byte 197
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      67  => (Byte_1                     => 2#00000000#, --config byte 198
              Byte_2                     => 2#00000000#, --config byte 199
              Byte_3                     => 2#00000000#, --config byte 200
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      68  => (Byte_1                     => 2#00000000#, --config byte 201
              Byte_2                     => 2#00000000#, --config byte 202
              Byte_3                     => 2#00000000#, --config byte 203
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      69  => (Byte_1                     => 2#00000000#, --config byte 204
              Byte_2                     => 2#00000000#, --config byte 205
              Byte_3                     => 2#00000000#, --config byte 206
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      70  => (Byte_1                     => 2#00000000#, --config byte 207
              Byte_2                     => 2#00000000#, --config byte 208
              Byte_3                     => 2#00000000#, --config byte 209
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      71  => (Byte_1                     => 2#00000000#, --config byte 210
              Byte_2                     => 2#00000000#, --config byte 211
              Byte_3                     => 2#00000000#, --config byte 212
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      72  => (Byte_1                     => 2#00000000#, --config byte 213
              Byte_2                     => 2#00000000#, --config byte 214
              Byte_3                     => 2#00000000#, --config byte 215
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      73  => (Byte_1                     => 2#00000000#, --config byte 216
              Byte_2                     => 2#00000000#, --config byte 217
              Byte_3                     => 2#00000000#, --config byte 218
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      74  => (Byte_1                     => 2#00000000#, --config byte 219
              Byte_2                     => 2#00000000#, --config byte 220
              Byte_3                     => 2#00000000#, --config byte 221
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      75  => (Byte_1                     => 2#00000000#, --config byte 222
              Byte_2                     => 2#00000000#, --config byte 223
              Byte_3                     => 2#00000000#, --config byte 224
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      76  => (Byte_1                     => 2#00000000#, --config byte 225
              Byte_2                     => 2#00000000#, --config byte 226
              Byte_3                     => 2#00000000#, --config byte 227
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      77  => (Byte_1                     => 2#00000000#, --config byte 228
              Byte_2                     => 2#00000000#, --config byte 229
              Byte_3                     => 2#00000000#, --config byte 230
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      78  => (Byte_1                     => 2#00000000#, --config byte 231
              Byte_2                     => 2#00000000#, --config byte 232
              Byte_3                     => 2#00000000#, --config byte 233
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      79  => (Byte_1                     => 2#00000000#, --config byte 234
              Byte_2                     => 2#00000000#, --config byte 235
              Byte_3                     => 2#00000000#, --config byte 236
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      80  => (Byte_1                     => 2#00000000#, --config byte 237
              Byte_2                     => 2#00000000#, --config byte 238
              Byte_3                     => 2#00000000#, --config byte 239
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      81  => (Byte_1                     => 2#00000000#, --config byte 240
              Byte_2                     => 2#00000000#, --config byte 241
              Byte_3                     => 2#00000000#, --config byte 242
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      82  => (Byte_1                     => 2#00000000#, --config byte 243
              Byte_2                     => 2#00000000#, --config byte 244
              Byte_3                     => 2#00000000#, --config byte 245
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      83  => (Byte_1                     => 2#00000000#, --config byte 246
              Byte_2                     => 2#00000000#, --config byte 247
              Byte_3                     => 2#00000000#, --config byte 248
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0),
      84  => (Byte_1                     => 2#00000000#, --config byte 249
              Byte_2                     => 2#00000000#, --config byte 250
              Byte_3                     => 2#00000000#, --config byte 251
              Number_Valid_Bytes_In_Word => 3,
              Sp26                       => 0,
              Sp27                       => 0,
              Sp28                       => 0,
              Word_Type                  => Intermediate,
              Parity                     => 0));

   --   2.3.6.3 Configuration data models intermediate words

   --   The configuration data models shall allow the KDA 557 to inform
   --   the RMU 556 of the models of units that the KDA 557 supports.  There
   --   shall be as many complete data messages for each label as is required
   --   to specify all models supported by the KDA 557 for that radio type.
   --   The first intermediate word of each data message shall contain the
   --   radio model code to be displayed by the RMU 556 corresponding to the
   --   radio model text that is contained within the message.  The remainder
   --   of the first intermediate word, and any subsequent intermediate words,
   --   shall contain the text to be displayed by the RMU 556.  This text
   --   shall be limited to numerals, uppercase letters, and the punctuation
   --   characters "- " and "/".  Each radio model text shall be a maximum of
   --   14 characters in length.

   --   This definition applies the the following labels:

   --           Label (hex)     Function
   --           90      VHF COM models
   --           91      UHF COM models
   --           92      HF COM models
   --           93      NAV models
   --           94      DME models
   --           95      ADF models
   --           96      Transpoder models
   --           97      MLS models
   --           98      TACAN models
   --           99      EFIS models
   --           9A      NMS models
   --           9B      FCS models


   --   2.3.6.3.1 Configuration data models intermediate word  #1
   --   Bit No. Function        Status
   --    0 -  7 Number of characters in radio model text        binary
   --                   Range = 1 to 14
   --    8 - 15 Radio model ASCII character #1  binary
   --   16 - 23 Radio model ASCII character #2  binary
   --   24 - 27 Radio model number      binary
   --                   Range 0 to 31
   --   28      Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Configuration_Models_Inter_1_Type is
      record
         Number_Of_Characters : Int8_Type := 0;
         Ascii_1              : Int8_Type := 0;
         Ascii_2              : Int8_Type := 0;
         Model_Number         : Int4_Type := 0;
         Sp28                 : Spare_Type := Spare;
         Word_Type            : Word := initial;
         Parity               : Spare_Type := Spare;
      end record;
   for Configuration_Models_Inter_1_Type use
      record
         Number_Of_Characters at 0 range 0 .. 7;
         Ascii_1              at 0 range 8 .. 15;
         Ascii_2              at 0 range 16 .. 23;
         Model_Number         at 0 range 24 .. 27;
         Sp28                 at 0 range 28 .. 28;
         Word_Type            at 0 range 29 .. 30;
         Parity               at 0 range 31 .. 31;
      end record;
   for Configuration_Models_Inter_1_Type'Size use 32;


   --   2.3.6.3.2 Configuration data models intermediate word #2  through n
   --   Bit No. Function        Status
   --    0 -  7 Next radio model ASCII character        binary
   --    8 - 15 Next radio model ASCII character        binary
   --   16 - 23 Next radio model ASCII character        binary
   --   24 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            0  1  Intermediate word
   --   31      Parity (Odd)
   type Configuration_Models_Inter_2_Type is
      record
         Next_Ascii_1 : Int8_Type := 0;
         Next_Ascii_2 : Int8_Type := 0;
         Next_Ascii_3 : Int8_Type := 0;
         Sp24         : Spare_Type := Spare;
         Sp25         : Spare_Type := Spare;
         Sp26         : Spare_Type := Spare;
         Sp27         : Spare_Type := Spare;
         Sp28         : Spare_Type := Spare;
         Word_Type    : Word := initial;
         Parity       : Spare_Type := Spare;
      end record;
   for Configuration_Models_Inter_2_Type use
      record
         Next_Ascii_1 at 0 range 0 .. 7;
         Next_Ascii_2 at 0 range 8 .. 15;
         Next_Ascii_3 at 0 range 16 .. 23;
         Sp24         at 0 range 24 .. 24;
         Sp25         at 0 range 25 .. 25;
         Sp26         at 0 range 26 .. 26;
         Sp27         at 0 range 27 .. 27;
         Sp28         at 0 range 28 .. 28;
         Word_Type    at 0 range 29 .. 30;
         Parity       at 0 range 31 .. 31;
      end record;
   for Configuration_Models_Inter_2_Type'Size use 32;

   --   2.3.8 Station Keeping

   --   This word shall be used for station keeping.

   --   This definition applies to the following label(s):

   --           Label (hex)     Function
   --           FF      Station keeping

   --   Bit No. Function        Status
   --    0 -  7 Label   0FFH
   --    8 - 15 Spare   0
   --   16      Destination is RMU 556 #1       0 = no, 1 = yes
   --   17      Destination is RMU 556 #2       0 = no, 1 = yes
   --   18      Destination is RMU 556 #3       0 = no, 1 = yes
   --   19      Destination is RMU 556 #4       0 = no, 1 = yes
   --   20      Destination is KDA 557 #1       0 = no, 1 = yes
   --   21      Destination is KDA 557 #2       0 = no, 1 = yes
   --   22 - 23 Spare
   --   24 - 26 Source  26 25 24
   --                    0  0  0  from undetermined RMU 556
   --                    0  0  1  from RMU 556 #1
   --                    0  1  0  from RMU 556 #2
   --                    0  1  1  from RMU 556 #3
   --                    1  0  0  from RMU 556 #4
   --                    1  0  1  from KDA 557 #1
   --                    1  1  0  from KDA 557 #2
   --   27 - 28 Spare   0
   --   29 - 30 Word type       30 29
   --                            1  1  Control message
   --   31      Parity (Odd)
   type Station_Keeping_Type is
      record
         Label      : Int8_Type := 0;
         Sp8        : Spare_Type := Spare;
         Sp9        : Spare_Type := Spare;
         Sp10       : Spare_Type := Spare;
         Sp11       : Spare_Type := Spare;
         Sp12       : Spare_Type := Spare;
         Sp13       : Spare_Type := Spare;
         Sp14       : Spare_Type := Spare;
         Sp15       : Spare_Type := Spare;
         Dest_Rmu_1 : Boolean := false;
         Dest_Rmu_2 : Boolean := false;
         Dest_Rmu_3 : Boolean := false;
         Dest_Rmu_4 : Boolean := false;
         Dest_Kda_1 : Boolean := false;
         Dest_Kda_2 : Boolean := false;
         Sp22       : Spare_Type := Spare;
         Sp23       : Spare_Type := Spare;
         Source     : Source_Type := Rmu_1;
         Sp27       : Spare_Type := Spare;
         Sp28       : Spare_Type := Spare;
         Word_type  : Word := initial;
         Parity     : Spare_Type := Spare;
      end record;
   for Station_Keeping_Type use
      record
         Label      at 0 range 0 .. 7;
         Sp8        at 0 range 8 .. 8;
         Sp9        at 0 range 9 .. 9;
         Sp10       at 0 range 10 .. 10;
         Sp11       at 0 range 11 .. 11;
         Sp12       at 0 range 12 .. 12;
         Sp13       at 0 range 13 .. 13;
         Sp14       at 0 range 14 .. 14;
         Sp15       at 0 range 15 .. 15;
         Dest_Rmu_1 at 0 range 16 .. 16;
         Dest_Rmu_2 at 0 range 17 .. 17;
         Dest_Rmu_3 at 0 range 18 .. 18;
         Dest_Rmu_4 at 0 range 19 .. 19;
         Dest_Kda_1 at 0 range 20 .. 20;
         Dest_Kda_2 at 0 range 21 .. 21;
         Sp22       at 0 range 22 .. 22;
         Sp23       at 0 range 23 .. 23;
         Source     at 0 range 24 .. 26;
         Sp27       at 0 range 27 .. 27;
         Sp28       at 0 range 28 .. 28;
         Word_type  at 0 range 29 .. 30;
         Parity     at 0 range 31 .. 31;
      end record;
   for Station_Keeping_Type'Size use 32;

   Station_Keeping : constant Station_Keeping_Type :=
     (Label      => 16#ff#, --FF for station keeping
      Sp8        => 0,
      Sp9        => 0,
      Sp10       => 0,
      Sp11       => 0,
      Sp12       => 0,
      Sp13       => 0,
      Sp14       => 0,
      Sp15       => 0,
      Dest_Rmu_1 => True,
      Dest_Rmu_2 => False,
      Dest_Rmu_3 => False,
      Dest_Rmu_4 => False,
      Dest_Kda_1 => False,
      Dest_Kda_2 => False,
      Sp22       => 0,
      Sp23       => 0,
      Source     => Kda_1,
      Sp27       => 0,
      Sp28       => 0,
      Word_type  => Control,
      Parity     => 0);

   type Unpack_Word_Type is
      record
         Label                : Int8_Type := 0;
         Sp8                  : Spare_Type := Spare;
         Sp9                  : Spare_Type := Spare;
         Sp10                 : Spare_Type := Spare;
         Sp11                 : Spare_Type := Spare;
         Sp12                 : Spare_Type := Spare;
         Sp13                 : Spare_Type := Spare;
         Sp14                 : Spare_Type := Spare;
         Sp15                 : Spare_Type := Spare;
         Sp16                 : Spare_Type := Spare;
         Sp17                 : Spare_Type := Spare;
         Sp18                 : Spare_Type := Spare;
         Sp19                 : Spare_Type := Spare;
         Sp20                 : Spare_Type := Spare;
         Sp21                 : Spare_Type := Spare;
         Sp22                 : Spare_Type := Spare;
         Sp23                 : Spare_Type := Spare;
         Sp24                 : Spare_Type := Spare;
         Sp25                 : Spare_Type := Spare;
         Sp26                 : Spare_Type := Spare;
         Control_Message_Type : Control_Message := poll;
         Sp28                 : Spare_Type := Spare;
         Word_Type            : Word := initial;
         Sp31                 : Spare_Type := Spare;
      end record;
   for Unpack_Word_Type use
      record
         Label                at 0 range 0 .. 7;
         Sp8                  at 0 range 8 .. 8;
         Sp9                  at 0 range 9 .. 9;
         Sp10                 at 0 range 10 .. 10;
         Sp11                 at 0 range 11 .. 11;
         Sp12                 at 0 range 12 .. 12;
         Sp13                 at 0 range 13 .. 13;
         Sp14                 at 0 range 14 .. 14;
         Sp15                 at 0 range 15 .. 15;
         Sp16                 at 0 range 16 .. 16;
         Sp17                 at 0 range 17 .. 17;
         Sp18                 at 0 range 18 .. 18;
         Sp19                 at 0 range 19 .. 19;
         Sp20                 at 0 range 20 .. 20;
         Sp21                 at 0 range 21 .. 21;
         Sp22                 at 0 range 22 .. 22;
         Sp23                 at 0 range 23 .. 23;
         Sp24                 at 0 range 24 .. 24;
         Sp25                 at 0 range 25 .. 25;
         Sp26                 at 0 range 26 .. 26;
         Control_Message_Type at 0 range 27 .. 27;
         Sp28                 at 0 range 28 .. 28;
         Word_Type            at 0 range 29 .. 30;
         Sp31                 at 0 range 31 .. 31;
      end record;
   for Unpack_Word_Type'Size use 32;

   type Discrete_Threat_377_Type is
      record
         Bcd_Digit_11       : Boolean := True;
         Bcd_Digit_12       : Boolean := False;
         Bcd_Digit_13       : Boolean := True;
         Bcd_Digit_14       : Boolean := False;
         Bcd_Digit_21       : Boolean := True;
         Bcd_Digit_22       : Boolean := True;
         Bcd_Digit_23       : Boolean := False;
         Bcd_Digit_24       : Boolean := False;
         Bcd_Digit_31       : Boolean := False;
         Bcd_Digit_32       : Boolean := False;
         Bcd_Digit_33       : Boolean := False;
         Bcd_Digit_34       : Boolean := False;
         Sp23               : Spare_Type := Spare;
         Sp24               : Spare_Type := Spare;
         Sp25               : Spare_Type := Spare;
         Sp26               : Spare_Type := Spare;
         Sp27               : Spare_Type := Spare;
         Sp28               : Spare_Type := Spare;
         Sp29               : Spare_Type := Spare;
      end record;
   for Discrete_Threat_377_Type use
      record
         Bcd_Digit_11       at 0 range 0 .. 0;
         Bcd_Digit_12       at 0 range 1 .. 1;
         Bcd_Digit_13       at 0 range 2 .. 2;
         Bcd_Digit_14       at 0 range 3 .. 3;
         Bcd_Digit_21       at 0 range 4 .. 4;
         Bcd_Digit_22       at 0 range 5 .. 5;
         Bcd_Digit_23       at 0 range 6 .. 6;
         Bcd_Digit_24       at 0 range 7 .. 7;
         Bcd_Digit_31       at 0 range 8 .. 8;
         Bcd_Digit_32       at 0 range 9 .. 9;
         Bcd_Digit_33       at 0 range 10 .. 10;
         Bcd_Digit_34       at 0 range 11 .. 11;
         Sp23               at 0 range 12 .. 12;
         Sp24               at 0 range 13 .. 13;
         Sp25               at 0 range 14 .. 14;
         Sp26               at 0 range 15 .. 15;
         Sp27               at 0 range 16 .. 16;
         Sp28               at 0 range 17 .. 17;
         Sp29               at 0 range 18 .. 18;
      end record;

   type Threat_Word_Count_Type is mod 2**8;
   for Threat_Word_Count_Type'Size use 8;

   type Threat_Intruder_Number_Type is mod 2**5;
   for Threat_Intruder_Number_Type'Size use 5;

   type Threat_RTS_Range_Type is mod 2**5;
   for Threat_RTS_Range_Type'Size use 5;

   type Discrete_Threat_Rts_357_Type is
      record
         Word_Count         : Threat_Word_Count_Type;
         Sp17               : Spare_Type := Spare;
         Sp18               : Spare_Type := Spare;
         All_Traffic        : Boolean := True;
         Display_Range      : Threat_RTS_Range_Type := 5;
         Iso_Char_1         : Boolean := False;
         Iso_Char_2         : Boolean := True;
         Iso_Char_3         : Boolean := False;
         Iso_Char_4         : Boolean := False;
         Iso_Char_5         : Boolean := True;
      end record;
   pragma Pack (Discrete_Threat_Rts_357_Type);
   for Discrete_Threat_Rts_357_Type'Size use 21;

   type Discrete_Threat_Eot_357_Type is
      record
         Word_Count         : Threat_Word_Count_Type;
         Sp17               : Spare_Type := Spare;
         Sp18               : Spare_Type := Spare;
         All_Traffic        : Boolean := True;
         Sp20               : Spare_Type := Spare;
         Sp21               : Spare_Type := Spare;
         Sp22               : Spare_Type := Spare;
         Sp23               : Spare_Type := Spare;
         Sp24               : Spare_Type := Spare;
         Iso_Char_1         : Boolean := True;
         Iso_Char_2         : Boolean := True;
         Iso_Char_3         : Boolean := False;
         Iso_Char_4         : Boolean := False;
         Iso_Char_5         : Boolean := False;
      end record;
   pragma Pack (Discrete_Threat_Eot_357_Type);
   for Discrete_Threat_Eot_357_Type'Size use 21;

   type Threat_Intruder_Range_Type is mod 2**11;
   for Threat_Intruder_Range_Type'Size use 11;

   type Discrete_Threat_130_Type is
      record
         Intruder_Number    : Threat_Intruder_Number_Type;
         Sp16               : Spare_Type := Spare;
         Sp17               : Spare_Type := Spare;
         Sp18               : Spare_Type := Spare;
         Intruder_Range     : Threat_Intruder_Range_Type;
      end record;
   for Discrete_Threat_130_Type use
      record
         Intruder_Number   at 0 range 0 .. 4;
         Sp16              at 0 range 5 .. 5;
         Sp17              at 0 range 6 .. 6;
         Sp18              at 0 range 7 .. 7;
         Intruder_Range    at 0 range 8 .. 18;
      end record;

   type Discrete_Threat_131_Type is
      record
         Intruder_Number    : Threat_Intruder_Number_Type;
         Sp16               : Spare_Type := Spare;
         Sp17               : Spare_Type := Spare;
         Sp18               : Spare_Type := Spare;
         Sp19               : Spare_Type := Spare;
         Vertical_Sense     : Jat.Vertical_Sense_Type;
      end record;
   for Discrete_Threat_131_Type use
      record
         Intruder_Number   at 0 range 0 .. 4;
         Sp16              at 0 range 5 .. 5;
         Sp17              at 0 range 6 .. 6;
         Sp18              at 0 range 7 .. 7;
         Sp19              at 0 range 8 .. 8;
         Vertical_Sense    at 0 range 9 .. 10;
      end record;

   type Discrete_Threat_132_Type is
      record
         Intruder_Number    : Threat_Intruder_Number_Type;
         Display_Matrix     : Jat.Display_Matrix_Type;
      end record;
   for Discrete_Threat_132_Type use
      record
         Intruder_Number   at 0 range 0 .. 4;
         Display_Matrix    at 0 range 5 .. 7;
      end record;

   type Xpdr_Range_Type is mod 2**8;
   for Xpdr_Range_Type'Size use 8;

   type Discrete_Xpdr_013_Type is
      record
         Intruder_Altitude         : Boolean := False;
         Altitude_Select           : Jat.Altitude_Range_Type;
         All_Traffic               : Boolean := False;
         Sp15                      : Spare_Type := Spare;
         Sp16                      : Spare_Type := Spare;
         Sp17                      : Spare_Type := Spare;
         Sp18                      : Spare_Type := Spare;
         Sp19                      : Spare_Type := Spare;
         Sp20                      : Spare_Type := Spare;
         Sp21                      : Spare_Type := Spare;
      end record;
   for Discrete_Xpdr_013_Type use
      record
          Intruder_Altitude      at 0 range 0 .. 0;
          Altitude_Select        at 0 range 1 .. 2;
          All_Traffic            at 0 range 3 .. 3;
          Sp15                   at 0 range 4 .. 4;
          Sp16                   at 0 range 5 .. 5;
          Sp17                   at 0 range 6 .. 6;
          Sp18                   at 0 range 7 .. 7;
          Sp19                   at 0 range 8 .. 8;
          Sp20                   at 0 range 9 .. 9;
          Sp21                   at 0 range 10 .. 10;
      end record;

   type Discrete_Xpdr_015_Type is
      record
          Altitude_Limit_A     : Jat.Altitude_Limit_Type;
          Altitude_Limit_B     : Jat.Altitude_Limit_Type;
          Sp25                 : Spare_Type := Spare;
          Sp26                 : Spare_Type := Spare;
          Sp27                 : Spare_Type := Spare;
          Sp28                 : Spare_Type := Spare;
          Sp29                 : Spare_Type := Spare;
      end record;
   for Discrete_Xpdr_015_Type use
      record
          Altitude_Limit_A     at 0 range 0 .. 6;
          Altitude_Limit_B     at 0 range 7 .. 13;
          Sp25                 at 0 range 14 .. 14;
          Sp26                 at 0 range 15 .. 15;
          Sp27                 at 0 range 16 .. 16;
          Sp28                 at 0 range 17 .. 17;
          Sp29                 at 0 range 18 .. 18;
      end record;

   type Xpdr_Display_Control_Type is mod 2**2;
   for Xpdr_Display_Control_Type'Size use 2;

   type Xpdr_Ident_Code_Type is mod 2**3;
   for Xpdr_Ident_Code_Type'Size use 3;

   type Discrete_Xpdr_016_Type is
      record
          Altitude_Reporting     : Boolean := False;                -- Not Currently Used
          Ident_On               : Boolean := False;                -- Not Currently Used
          Display_Control        : Xpdr_Display_Control_Type := 0;  -- Not Currently Used
          Sensitivity_Level      : Jat.Sensitivity_Level_Type;
          Ident_Code_D           : Xpdr_Ident_Code_Type := 0;       -- Not Currently Used
          Ident_Code_C           : Xpdr_Ident_Code_Type := 0;       -- Not Currently Used
          Ident_Code_B           : Xpdr_Ident_Code_Type := 0;       -- Not Currently Used
          Ident_Code_A           : Xpdr_Ident_Code_Type := 0;       -- Not Currently Used
      end record;
   for Discrete_Xpdr_016_Type use
      record
          Altitude_Reporting     at 0 range 0 .. 0;
          Ident_On               at 0 range 1 .. 1;
          Display_Control        at 0 range 2 .. 3;
          Sensitivity_Level      at 0 range 4 .. 6;
          Ident_Code_D           at 0 range 7 .. 9;
          Ident_Code_C           at 0 range 10 .. 12;
          Ident_Code_B           at 0 range 13 .. 15;
          Ident_Code_A           at 0 range 16 .. 18;
      end record;

   type Discrete_Tas_270_Type is
      record
          Sp9           : Spare_Type := Spare;
          Sp10          : Spare_Type := Spare;
          Sp11          : Spare_Type := Spare;
          Sp12          : Spare_Type := Spare;
          Sp13          : Spare_Type := Spare;
          Sp14          : Spare_Type := Spare;
          Sp15          : Spare_Type := Spare;
          Sp16          : Spare_Type := Spare;
          Sp17          : Spare_Type := Spare;
          Sp18          : Spare_Type := Spare;
          Sp19          : Spare_Type := Spare;
          Sp20          : Spare_Type := Spare;
          Sp21          : Spare_Type := Spare;
          Sp22          : Spare_Type := Spare;
          Sp23          : Spare_Type := Spare;
          Sp24          : Spare_Type := Spare;
          Sp25          : Spare_Type := Spare;
          Sp26          : Spare_Type := Spare;
          Sp27          : Spare_Type := Spare;
          Sp28          : Spare_Type := Spare;
          Sp29          : Spare_Type := Spare;
      end record;
   for Discrete_Tas_270_Type use
      record
          Sp9          at 0 range 0 .. 0;
          Sp10         at 0 range 1 .. 1;
          Sp11         at 0 range 2 .. 2;
          Sp12         at 0 range 3 .. 3;
          Sp13         at 0 range 4 .. 4;
          Sp14         at 0 range 5 .. 5;
          Sp15         at 0 range 6 .. 6;
          Sp16         at 0 range 7 .. 7;
          Sp17         at 0 range 8 .. 8;
          Sp18         at 0 range 9 .. 9;
          Sp19         at 0 range 10 .. 10;
          Sp20         at 0 range 11 .. 11;
          Sp21         at 0 range 12 .. 12;
          Sp22         at 0 range 13 .. 13;
          Sp23         at 0 range 14 .. 14;
          Sp24         at 0 range 15 .. 15;
          Sp25         at 0 range 16 .. 16;
          Sp26         at 0 range 17 .. 17;
          Sp27         at 0 range 18 .. 18;
          Sp28         at 0 range 19 .. 19;
          Sp29         at 0 range 20 .. 20;
      end record;

   type Tas_Reply_Information_Type is mod 2**4;
   for Tas_Reply_Information_Type'Size use 4;

   type Discrete_Tas_274_Type is
      record
          Sp9                  : Spare_Type := Spare;
          Sp10                 : Spare_Type := Spare;
          Sp11                 : Spare_Type := Spare;
          Sp12                 : Spare_Type := Spare;
          Sp13                 : Spare_Type := Spare;
          Sp14                 : Spare_Type := Spare;
          Sp15                 : Spare_Type := Spare;
          Sp16                 : Spare_Type := Spare;
          Sp17                 : Spare_Type := Spare;
          Sp18                 : Spare_Type := Spare;
          Sp19                 : Spare_Type := Spare;
          Sp20                 : Spare_Type := Spare;
          Sp21                 : Spare_Type := Spare;
          Sp22                 : Spare_Type := Spare;
          Actual_Sensitivity   : Jat.TAS_Sensitivity_Level_Type;
          Reply_Information    : Tas_Reply_Information_Type := 4;
      end record;
   for Discrete_Tas_274_Type use
      record
          Sp9          at 0 range 0 .. 0;
          Sp10         at 0 range 1 .. 1;
          Sp11         at 0 range 2 .. 2;
          Sp12         at 0 range 3 .. 3;
          Sp13         at 0 range 4 .. 4;
          Sp14         at 0 range 5 .. 5;
          Sp15         at 0 range 6 .. 6;
          Sp16         at 0 range 7 .. 7;
          Sp17         at 0 range 8 .. 8;
          Sp18         at 0 range 9 .. 9;
          Sp19         at 0 range 10 .. 10;
          Sp20         at 0 range 11 .. 11;
          Sp21         at 0 range 12 .. 12;
          Sp22         at 0 range 13 .. 13;
          Actual_Sensitivity   at 0 range 14 .. 16;
          Reply_Information    at 0 range 17 .. 20;
      end record;

   type Discrete_Tas_350_Type is
      record
          TCAS_CU_Fail          : Boolean := False;
          Upper_Antenna_Fail    : Boolean := False;
          Lower_Antenna_Fail    : Boolean := False;
          RA_Bus_1_Fail         : Boolean := False;
          RA_Bus_2_Fail         : Boolean := False;
          Xpdr_1_Fail           : Boolean := False;
          Xpdr_2_Fail           : Boolean := False;
          Attitude_Bus_Fail     : Boolean := False;
          Mag_Hdg_Bus_Fail      : Boolean := False;
          Tcas_Status_Fail      : Boolean := False;
          Sp21                  : Spare_Type := Spare;
          Sp22                  : Spare_Type := Spare;
          TA1_Display_Fail      : Boolean := False;
          TA2_Display_Fail      : Boolean := False;
          RA1_Display_Fail      : Boolean := False;
          RA2_Display_Fail      : Boolean := False;
          CFDIU_Bus_Fail        : Boolean := False;
          BITE_Inhibit          : Boolean := False;
          Command_Ack           : Boolean := False;
      end record;
   for Discrete_Tas_350_Type use
      record
          TCAS_CU_Fail          at 0 range 0 .. 0;
          Upper_Antenna_Fail    at 0 range 1 .. 1;
          Lower_Antenna_Fail    at 0 range 2 .. 2;
          RA_Bus_1_Fail         at 0 range 3 .. 3;
          RA_Bus_2_Fail         at 0 range 4 .. 4;
          Xpdr_1_Fail           at 0 range 5 .. 5;
          Xpdr_2_Fail           at 0 range 6 .. 6;
          Attitude_Bus_Fail     at 0 range 7 .. 7;
          Mag_Hdg_Bus_Fail      at 0 range 8 .. 8;
          Tcas_Status_Fail      at 0 range 9 .. 9;
          Sp21                  at 0 range 10 .. 10;
          Sp22                  at 0 range 11 .. 11;
          TA1_Display_Fail      at 0 range 12 .. 12;
          TA2_Display_Fail      at 0 range 13 .. 13;
          RA1_Display_Fail      at 0 range 14 .. 14;
          RA2_Display_Fail      at 0 range 15 .. 15;
          CFDIU_Bus_Fail        at 0 range 16 .. 16;
          BITE_Inhibit          at 0 range 17 .. 17;
          Command_Ack           at 0 range 18 .. 18;
      end record;

   type Discrete_Tas_351_Type is
      record
          ModeS_Xpdr_Unit_Fail     : Boolean := False;
          Upper_Antenna_Fail       : Boolean := False;
          Lower_Antenna_Fail       : Boolean := False;
          Sp14                     : Spare_Type := Spare;
          Sp15                     : Spare_Type := Spare;
          Sp16                     : Spare_Type := Spare;
          Sp17                     : Spare_Type := Spare;
          Sp18                     : Spare_Type := Spare;
          Sp19                     : Spare_Type := Spare;
          Sp20                     : Spare_Type := Spare;
          Sp21                     : Spare_Type := Spare;
          Tcas_Input_Fail          : Boolean := False;
          Control_Source_Select    : Boolean := False;
          Contol_Source_Fail       : Boolean := False;
          Altitude_Input_1_Fail    : Boolean := False;
          Altitude_Input_2_Fail    : Boolean := False;
          CFDIU_Input_Fail         : Boolean := False;
          BITE_Inhibit             : Boolean := False;
          Command_Ack              : Boolean := False;
      end record;
   for Discrete_Tas_351_Type use
      record
          ModeS_Xpdr_Unit_Fail     at 0 range 0 .. 0;
          Upper_Antenna_Fail       at 0 range 1 .. 1;
          Lower_Antenna_Fail       at 0 range 2 .. 2;
          Sp14                     at 0 range 3 .. 3;
          Sp15                     at 0 range 4 .. 4;
          Sp16                     at 0 range 5 .. 5;
          Sp17                     at 0 range 6 .. 6;
          Sp18                     at 0 range 7 .. 7;
          Sp19                     at 0 range 8 .. 8;
          Sp20                     at 0 range 9 .. 9;
          Sp21                     at 0 range 10 .. 10;
          Tcas_Input_Fail          at 0 range 11 .. 11;
          Control_Source_Select    at 0 range 12 .. 12;
          Contol_Source_Fail       at 0 range 13 .. 13;
          Altitude_Input_1_Fail    at 0 range 14 .. 14;
          Altitude_Input_2_Fail    at 0 range 15 .. 15;
          CFDIU_Input_Fail         at 0 range 16 .. 16;
          BITE_Inhibit             at 0 range 17 .. 17;
          Command_Ack              at 0 range 18 .. 18;
      end record;


end Jpats_Avionics.Arinc;

