-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Avionics_Types,
  Jpats_Avionics_Types,
  Coordinate_Types;

package GPS is

   package Jat renames Jpats_Avionics_Types;

   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_Body_Axis_Velocity
     (An_Instance        : in out Instance;
      Body_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Earth_Axis_Velocity
     (An_Instance         : in out Instance;
      Earth_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Jpats_Avionics_Types.Position_Type);

   procedure Set_Magnetic_Variation
     (An_Instance        : in out Instance;
      Magnetic_Variation : in     Jat.Bearing_Type);

   procedure Set_Horizontal_Position
     (An_Instance         : in out Instance;
      Horizontal_Position : in     Jat.Gps_Horizontal_Position_Type);

   procedure Set_Vertical_Position
     (An_Instance       : in out Instance;
      Vertical_Position : in     Jat.Gps_Vertical_Position_Type);

   procedure Set_Groundspeed_Track_Angle
     (An_Instance             : in out Instance;
      Groundspeed_Track_Angle : in     Jat.Gps_Groundspeed_Track_Angle_Type);

   procedure Set_Velocity
     (An_Instance : in out Instance;
      Velocity    : in     Jat.Gps_Velocity_Type);

   procedure Set_Date_Time
     (An_Instance : in out Instance;
      Date_Time   : in     Jat.Gps_Date_Time_Type);

   procedure Set_Frequency_Estimate
     (An_Instance        : in out Instance;
      Frequency_Estimate : in     Jat.Gps_Frequency_Esitmate_Type);

   procedure Set_Satellite_Status
     (An_Instance      : in out Instance;
      Satellite_Status : in     Jat.Gps_Satellite_Status_Type_Array);

   procedure Set_State
     (An_Instance : in out Instance;
      State       : in     Jat.Gps_State_Type);

   procedure Set_Subsytem_Software_Version
     (An_Instance               : in out Instance;
      Subsytem_Software_Version : in     Integer);

   procedure Set_Satellite_Azimuth
     (An_Instance        : in out Instance;
      Satellite_Azimuth  : in     Jat.Gps_Satellite_Azimuth_Type);

   procedure Set_Raim_Fail
     (An_Instance       : in out Instance;
      Raim_Fail         : in     Boolean);

   function Horizontal_Position
     (An_Instance : in Instance)
      return Jat.Gps_Horizontal_Position_Type;

   function Vertical_Position
     (An_Instance : in Instance)
      return Jat.Gps_Vertical_Position_Type;

   function Groundspeed_Track_Angle
     (An_Instance : in Instance)
      return Jat.Gps_Groundspeed_Track_Angle_Type;

   function Velocity
     (An_Instance : in Instance)
      return Jat.Gps_Velocity_Type;

   function Date_Time
     (An_Instance : in Instance)
      return Jat.Gps_Date_Time_Type;

   function Frequency_Estimate
     (An_Instance : in Instance)
      return Jat.Gps_Frequency_Esitmate_Type;

   function Satellite_Status
     (An_Instance : in Instance)
      return Jat.Gps_Satellite_Status_Type_Array;

   function State
     (An_Instance : in Instance)
      return Jat.Gps_State_Type;

   function Subsytem_Software_Version
     (An_Instance : in Instance)
      return Integer;

   function Satellite_Azimuth
     (An_Instance : in Instance)
      return Jat.Gps_Satellite_Azimuth_Type;

   function Raim_Fail
     (An_Instance : in Instance)
      return Boolean;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Iconst      : in     Float;
                    An_Instance : in out Instance);

private

   type Instance is record
      Power                     : Boolean;
      Body_Axis_Velocity        : Coordinate_Types.Cartesian;
      Earth_Axis_Velocity       : Coordinate_Types.Cartesian;
      Aircraft_Position         : Jpats_Avionics_Types.Position_Type;
      Magnetic_Variation        : Jat.Bearing_Type;
      Horizontal_Position       : Jat.Gps_Horizontal_Position_Type;
      Vertical_Position         : Jat.Gps_Vertical_Position_Type;
      Groundspeed_Track_Angle   : Jat.Gps_Groundspeed_Track_Angle_Type;
      Velocity                  : Jat.Gps_Velocity_Type;
      Date_Time                 : Jat.Gps_Date_Time_Type;
      Frequency_Estimate        : Jat.Gps_Frequency_Esitmate_Type;
      Satellite_Status          : Jat.Gps_Satellite_Status_Type_Array;
      State                     : Jat.Gps_State_Type;
      Subsytem_Software_Version : Integer;
      Satellite_Azimuth         : Jat.Gps_Satellite_Azimuth_Type;
      Raim_Fail                 : Boolean;
   end record;


end GPS;
