-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package Flight_Data_Recorder is

   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_Maintenance_Warn
     (An_Instance      : in out Instance;
      Maintenance_Warn : in     Boolean);

   procedure Set_Failure_Warn
     (An_Instance  : in out Instance;
      Failure_Warn : in     Boolean);

   -- Access DTM_Full
   function Power
     (An_Instance : in Instance)
      return Boolean;

   function Maintenance_Warn
     (An_Instance : in Instance)
      return Boolean;

   function Failure_Warn
     (An_Instance : in Instance)
      return Boolean;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);


private

   type Instance is record
      Power            : Boolean;
      Maintenance_Warn : Boolean;
      Failure_Warn     : Boolean;
   end record;


end Flight_Data_Recorder;
