-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Flight_Data_Recorder is

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean) is
   begin
      An_Instance.Power := Power;
   end Set_Power;

   procedure Set_Maintenance_Warn
     (An_Instance      : in out Instance;
      Maintenance_Warn : in     Boolean) is
   begin
      An_Instance.Maintenance_Warn := Maintenance_Warn;
   end Set_Maintenance_Warn;

   procedure Set_Failure_Warn
     (An_Instance  : in out Instance;
      Failure_Warn : in     Boolean) is
   begin
      An_Instance.Failure_Warn := Failure_Warn;
   end Set_Failure_Warn;

   function Power
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Power;
   end;

   function Maintenance_Warn
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Maintenance_Warn;
   end;

   function Failure_Warn
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Failure_Warn;
   end;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance) is
   begin

      An_Instance.Power            := False;
      An_Instance.Maintenance_Warn := False;
      An_Instance.Failure_Warn     := False;
   end Init;

   -- Method Update
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance) is

   begin

      An_Instance.Failure_Warn := not An_Instance.Power;

      --Primarily power logic and DTM full logic is simulated for
      --the flight data recorder.

   end Update;


end Flight_Data_Recorder;
