------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-----------------------------------------------------------------------------

with Jpats_Avionics_Types,
  Coordinate_Types;

use Jpats_Avionics_Types;

package AHRS is

   package Jat renames Jpats_Avionics_Types;

   type Instance is private;

   type Gyro_Mode_Type is (Free, Slave);

   type Slew_Direction_Type is (None, Cw, Ccw);

   procedure Set_Attitude_Fail
     (An_Instance   : in out Instance;
      Attitude_Fail : in     Boolean);

   procedure Set_Magnetic_Sensor_Fail
     (An_Instance          : in out Instance;
      Magnetic_Sensor_Fail : in     Boolean);

   procedure Set_Rate_Of_Turn_Fail
     (An_Instance       : in out Instance;
      Rate_Of_Turn_Fail : in     Boolean);

   procedure Set_Heading_Fail
     (An_Instance  : in out Instance;
      Heading_Fail : in     Boolean);

   procedure Set_Freeze_Selected
     (An_Instance     : in out Instance;
      Freeze_Selected : in     Boolean);

   procedure Set_Weight_On_Wheels
     (An_Instance      : in out Instance;
      Weight_On_Wheels : in     Boolean);

   procedure Set_Slew_Direction
     (An_Instance    : in out Instance;
      Slew_Direction : in     Slew_Direction_Type);

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_Magnetic_Heading
     (An_Instance      : in out Instance;
      Magnetic_Heading : in     Jat.Bearing_Type);

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Jat.Position_Type);

   procedure Set_Aircraft_Pitch
     (An_Instance    : in out Instance;
      Aircraft_Pitch : in     Float);

   procedure Set_Aircraft_Roll
     (An_Instance   : in out Instance;
      Aircraft_Roll : in     Float);

   procedure Set_Body_Axis_Velocity
     (An_Instance        : in out Instance;
      Body_Axis_Velocity : in     Coordinate_Types.Cartesian);

   procedure Set_Gyro_Mode
     (An_Instance : in out Instance;
      Gyro_Mode   : in     Gyro_Mode_Type);

   procedure Set_Attitude
     (An_Instance : in out Instance;
      Attitude    : in     Jat.Attitude_Type);

   procedure Set_Body_Axis_Attitude_Rate
     (An_Instance             : in out Instance;
      Body_Axis_Attitude_Rate : in     Jat.Attitude_Rate_Type);

   procedure Set_Ahrs_Discretes
     (An_Instance    : in out Instance;
      Ahrs_Discretes : in     Jat.Ahrs_Discretes_Type);

   -- Access Body_Axis_Velocity
   function Body_Axis_Velocity
     (An_Instance : in Instance)
      return Coordinate_Types.Cartesian;

   procedure Set_Rapid_Align
     (An_Instance : in out Instance;
      Rapid_Align : in     Boolean);

   -- Access Gyro_Mode
   function Gyro_Mode
     (An_Instance : in Instance)
      return Gyro_Mode_Type;

   -- Access Test
   function Test
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_Test
     (An_Instance : in out Instance;
      Test        : in     Boolean);

   -- Access Attitude
   function Attitude
     (An_Instance : in Instance)
      return Jat.Attitude_Type;

   -- Access Body_Axis_Attitude_Rate
   function Body_Axis_Attitude_Rate
     (An_Instance : in Instance)
      return Jat.Attitude_Rate_Type;

   -- Access ahrs discretes
   function Ahrs_Discretes
     (An_Instance : in Instance)
      return Jat.Ahrs_Discretes_Type;

   -- Method Init
   procedure Init
     (An_Instance : in out Instance);

   -- Method Update
   procedure Update(Iconst      : in     Float;
                    An_Instance : in out Instance);

private

   type Instance is record
      Power                     : Boolean;
      Align_Timer               : Float;
      Magnetic_Heading          : Jat.Bearing_Type;
      Aircraft_Position         : Jat.Position_Type;
      Aircraft_Pitch            : Float;
      Aircraft_Roll             : Float;
      Body_Axis_Velocity        : Coordinate_Types.Cartesian;
      Rapid_Align               : Boolean;
      Slew_Direction            : Slew_Direction_Type;
      Gyro_Mode                 : Gyro_Mode_Type;
      Test                      : Boolean;
      Attitude_Fail             : Boolean;
      Rate_Of_Turn_Fail         : Boolean;
      Magnetic_Sensor_Fail      : Boolean;
      Heading_Fail              : Boolean;
      Freeze_Selected           : Boolean;
      Weight_On_Wheels          : Boolean;

      Attitude                  : Jat.Attitude_Type;
      Body_Axis_Attitude_Rate   : Jat.Attitude_Rate_Type;
      Ahrs_Discretes            : Jat.Ahrs_Discretes_Type;
   end record;


end AHRS;
