with stethoscope;

separate (Ahrs)


procedure Scope is

   Variable_Registered : Boolean;
begin

   stethoscope.register_signal
     (Name              => "avionics/ahrs/First_Pass",
      Units             => "t-f",
      object_address => First_Pass'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Freeze_Timer",
      Units             => "seconds",
      object_address => Freeze_Timer'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Freeze_In_Progress",
      Units             => "t-f",
      object_address => Freeze_In_Progress'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Align_Timer",
      Units             => "seconds",
      object_address => Align_Timer'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Quick_Align_Timer",
      Units             => "seconds",
      object_address => Quick_Align_Timer'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Delta_Mag_Hdg",
      Units             => "degrees",
      object_address => Delta_Mag_Hdg'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Mag_Hdg_N1",
      Units             => "degrees",
      object_address => Mag_Hdg_N1'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Ahrs_Powered",
      Units             => "t-f",
      object_address => Ahrs_Powered'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Align_Time",
      Units             => "seconds",
      object_address => Align_Time'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Align_Low_Limit",
      Units             => "seconds",
      object_address => Align_Low_Limit'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Align_Slew_Rate",
      Units             => "degrees per ",
      object_address => Align_Slew_Rate'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Fast_Slave",
      Units             => "t-f",
      object_address => Fast_Slave'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Ac_Moving",
      Units             => "t-f",
      object_address => Ac_Moving'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Compass_Error",
      Units             => "degrees",
      object_address => Compass_Error'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Precession",
      Units             => "degrees/sec",
      object_address => Precession'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Slew_Rate",
      Units             => "degrees/sec",
      object_address => Slew_Rate'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Manual_Sync",
      Units             => "deg/sec",
      object_address => Manual_Sync'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Compass_Sync",
      Units             => "deg/sec",
      object_address => Compass_Sync'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Sync_Rate_1_Deg_Sec",
      Units             => "deg/sec",
      object_address => Sync_Rate_1_Deg_Sec'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Sync_Rate_15_Deg_Sec",
      Units             => "deg/sec",
      object_address => Sync_Rate_15_Deg_Sec'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Slew_Timer",
      Units             => "seconds",
      object_address => Slew_Timer'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Slave_N1",
      Units             => "t-f",
      object_address => Slave_N1'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Error_Timer",
      Units             => "seconds",
      object_address => Error_Timer'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Heading_Error",
      Units             => "degrees",
      object_address => Heading_Error'address,
      Value_Type        => "float",
      Scope_Index       => 0);
   stethoscope.register_signal
     (Name              => "avionics/ahrs/Sensor_Fail_N1",
      Units             => "t-f",
      object_address => Sensor_Fail_N1'address,
      Value_Type        => "uchar",
      Scope_Index       => 0);
end;
