! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_control
!    DESCRIPTION     : Autotest master controler
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!   This routine reads the TDF/POM/ACD files and creates
!   two files, histin.csv and testic.dat which are read by the host
! ****************************************************************************


	program getdata
    use dflib

	implicit none

!	Variables for autotest control
	integer*1		fatcomment(132)		!Test Comment for IOS
	integer*1		faticlab(2400)		!IC labels for IOS
	integer*1		fatname(40)			!Test name for IOS
	integer*1		fattitle(132)		!Test Title for IOS

	integer*4		fairdmd				!Demanded autotest airport
	integer*4		fatdaddr(40)		!Index of variable Xref to driver variable
	integer*4		fatddim(40)			!# of data pts per vari in atd
	integer*4		fatdnum				!Number of atd drivers
	integer*4		fatdxind(40)		!Index of x data for each drvr
	integer*4		fatdyind(40)		!Index of y data for each drvr
	integer*4		fatdptr     		!New open slot in fatddata array
	integer*4		fattask				!Dummy for flt_output
 	integer*4		fattest				!autotest test number
 	integer*4		fbetavar			!Y var index for peak analysis beta
 	integer*4		fcfdvar				!Y var index for CFD analysis
 	integer*4		fcpbctr	 /1/		!Dummy label
 	integer*4		fdampvar			!Y var index for damping analysis
	integer*4		ficinaddr(200)		!addresses to load icval into
 	integer*4		ficinnum			!number of ic's to input
 	integer*4		ficinop(200)			!I/O status if IC inputs
 	integer*4		ficord(200)			!Index for ic order
	integer*4		ficotaddr(200)		!address of IC output vars
 	integer*4		ficotnum			!Number of vars to output as ic
	integer*4		ficoutype(200)		!type of ic out vars
	integer*4		ficrecfl			!Status flag from fat_icrec
	integer*4		fictype(200)			!var type (real int log) of ics
	integer*4		fininrt				!init flag 1=read 2=ok
	integer*4		fnumgrid(36)		!Number of grids for each y
 	integer*4		fnxtar				!Number of x targets
 	integer*4		fnytar				!Number of y targets
 	integer*4		fphivar				!Y var index for peak analysis phi
 	integer*4		fplavar				!Y variable index for analysis PLA
 	integer*4		fpowervar			!Y variable index for analysis N1
 	integer*4		frecframe			!Number of frames written
 	integer*4		frecnumb			!Number of variables defined in plot
 	integer*4		frecval				!Status flag from fat_datarec
	integer*4		frundmd				!Demanded autotest runway
	integer*4		fsimnumb			!Number of recorded/plotted variables from HOST
 	integer*4		fsimruns /1/		!number of sim runs to plot
	integer*4		ft5addr(30)			!addr of vars to set in task 5
	integer*4		ft5con(30)			!type of task 5 conditionals
	integer*4		ft5conaddr(30)		!Address for task 5 conditions
	integer*4		ft5cond				!number of task 5 conditionals
	integer*4		ft5contype(30)		!Type for task 5 conditions
	integer*4		ft5type(30)			!var type (real int log) of t5
 	integer*4		fxtarm(10)			!desired slope of xtarget
 	integer*4		fxtarvar(10)		!X target plot index
 	integer*4		fxvarnum			!Number of x variables for plot
 	integer*4		fymaptox(36)		!For each Y which X to use
 	integer*4		fytarm(10)			!desired slope of ytarget
 	integer*4		fytarvar(10)		!Y target plot index
 	integer*4		fyvarnum			!Number of y variables plotted

	real*4			fatddata(100000)	!atd driver data storage array
	real*4			fatdxsng(2,40)		!Drivers X shift and gains
	real*4			faticac(200)		!A/C IC data fot IOS
	real*4			faticsim(200)		!Sim IC data for IOS
 	real*4			fbetast				!Start time for peak analysis beta
 	real*4			fcfdst				!Start time for CFD analysis
 	real*4			fdampst				!Start time for damping analysis
 	real*4			ficinval(200)		!values to load into ic address
 	real*4			fphist				!Start time for peak analysis phi
 	real*4			frecrate			!recording rate in hz
	real*4			frecstart			!recording start time
	real*4			ft5conval(30)		!Task 5 conditional values
	real*4			ft5val(30)			!Task 5 values to set t5addr to
 	real*4			ftola(36)			!Absolute tolerance value
 	real*4			ftolp(36)			!Percent tolerance value
 	real*4			fxplotshft			!IOS input x shift for plotting
 	real*4			fxscale(2,6)		!X axis scales (1) min (2) max
 	real*4			fxsng(2,2,42)		!acd & pom plot x shifts/gains
 	real*4			fxtarval(10)		!X target value for high lighting
 	real*4			fyscale(2,36)		!Y axis scales (1) min (2) max
 	real*4			fysng(2,2,42)		!acd & pom plot y shifts/gains
 	real*4			fytarval(10)		!Y target value for high lighting

 	logical*4		facdline  /.false./	!Put line w/ snapshot pts ACD/POM
 	logical*4		fatprint			!batch printer control flag
 	logical*4		fcpcopy	 /.false./	!Print multiple copies of plot
 	logical*4		fcpmess	 /.false./	!Display messages
 	logical*4		fcptolf /.false./	!ref fcp tolerance flag
 	logical*4		fhilite(36)			!Highlight these variables
 	logical*4		fmantxtfl  /.false./!Display test text at start of manual test
 	logical*4		fplotacd /.true./	! plot aircraft data flag
 	logical*4		fplotpom			!plot prrof-of-match data flag
 	logical*4		fplotsim /.true./	! plot simulator data flag
 	logical*4		fsimline			!Put line w/ snapshot pts SIM
 	logical*4		fsnapacd(36)		!Snap shot flag by variable ACD
 	logical*4		fsnaplot			!Whole plot Snap shot flag 
 	logical*4		fsnappom(36)		!Snap shot flag by variable POM
 	logical*4		ftgplot /.true./	!Force sim data to be read from .sim file
	logical*4		ft5ovrdt6(30)		!Allow setting in task 6
	logical*4		fylimit(36)			!Limits plots to Y axis
	logical*4		err					!Error flag

    character*4     testid

   call getarg(1,testid)
   
 !  test id is a character string - convert back to integer (fattest)
	read(testid,*) fattest
    call fat_readtest(fatcomment,faticlab, fatdaddr,            & 
		fatname,   fattitle,  fairdmd,   fatddim,   fatdnum,    & 
		fatdxind,  fatdyind,  fattest,   fbetavar,  fdampvar,   & 
		ficinaddr, ficinnum,  ficinop,   ficord,    ficotaddr,  & 
		ficotnum,  ficoutype, fictype,   fininrt,   fnumgrid,   & 
		fnxtar,    fnytar,    fphivar,   fplavar,   fpowervar,  & 
		frundmd,   ft5addr,   ft5con,    fcfdvar,   frecnumb,   & 
		ft5conaddr,ft5cond,   ft5contype,ft5type,   fxtarm,    fxtarvar,   & 
		fxvarnum,  fymaptox,  fytarm,    fytarvar,  fyvarnum,   & 
		fatddata,  fatdxsng,  faticac,   faticsim,  fbetast,    & 
		fdampst,   ficinval,  fphist,    fatdptr,				&
		ft5conval, ft5val,    ftola,     fcfdst,        & 
		ftolp,     fxscale,   fxsng,     fxtarval,  fyscale,    & 
		fysng,     fytarval,  fcpmess,   fhilite,   fsnapacd,   & 
		fsnaplot,  fsnappom,  ft5ovrdt6, fylimit)

	call fat_writefile(ficinval,fatdaddr,fatddata,fatdxsng,fatddim,fatdnum, &
		fatdxind,fatdyind,fatdptr,ficinaddr,ficinnum,err)

	end
