! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_utl
!    DESCRIPTION     : Utility routines used by all of autotest
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  
!          Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!

!--> REVISION BEGIN
! $Id: flt_utl.f,v 1.3 2000/03/13 22:23:33 saladinm Exp $
! $Log: flt_utl.f,v $
! Revision 1.3  2000/03/13 22:23:33  saladinm
! Added routine get_cpid to get process ID and add it to plot_plot.inc g
! globals.

! Revision 1.2  2000/02/14 16:21:11  saladinm
! DR/MACAR:     None
! Problem:      IC mapping not working correctly.
!               Need to output IC's to tdf files in correct order.
! Conclusion:   Use of capital letters in icmap.dat file not supported.
! Resolution:   Added lower casing of all inputs from icmap.dat file.
!               Added subroutines to aid in the mapping and sorting of
!               IC variables to aid in the output of these in the proper order.
! Dependencies: none
! Engineer:     Mike Saladin

! Revision 1.1  1999/03/02 20:53:05  saladinm
! Initial revision

! Revision 1.4  1999/02/24 19:33:16  saladinm
! Added routine read_icmap which reads the icmap.dat file.

! Revision 1.3  1999/02/18 14:14:34  saladinm
! Changed error return value from -9999. to -999999. so IC won;t be plotted.

! Revision 1.2  1999/02/08 17:10:26  saladinm
! Added revision control stuff.

!--> REVISION END
! ***************************************************************************
!  This dummy routine is here to fool mscan when compiling this module.

!  DO NOT REMOVE

      subroutine dummy_utl(iconst)

      real iconst

      return
      end


! ***************************************************************************


      subroutine gettypeval(var,cval,rval,itype,err)

! * Arguments
      character*64   var          ! Input variable
      character*20   cval         ! input character string of value
      real*4         rval         ! Output real of value
      integer*4      itype        ! See below
      logical*4      err          ! Error reading the cval into rval

! * Locals
      integer*4      it           !Index for true
      integer*4      ie           !Index for false
      integer*4      in           !Index for null
      integer*4      nl           !length of name
      integer*4      offset       !array index or 1 for non-arrays

      character*64   tname        !temp name without the (##)

! * External functions
      integer*4      lrbl         !returns index of first blank 
	  integer*4      rlan         !Returns lst non-blank on line
      integer*4      typelkup     !Returns type of variable
                                  !>=0 Error
                                  !1 void
                                  !2 character N/A for SMS variables
                                  !3 short integer N/A for this stuff
                                  !4 integer or logical does not matter
                                  !5 long integer
                                  !6 real
                                  !7 double precision
                                  !8+ other C types not needed
      integer*4  tmp

! * Remove () from potential arrays
      nl = lrbl(var)
      ibs = index(var(:nl),'(')
      ibe = index(var(:nl),')')
      tname = ' '

      if ( ibe .le. ibs ) then   ! No (#) in name assume not array
         tname = var(:nl)
      else                       ! there is potentially a (#) in name
         tname = var(:ibs-1)     !delete the () from the name
      endif

      err = .false.

!      itype = typelkup(tname)
!  For now for flt program will not do variable type checking
!  specify a default type that will make the system work
       itype = 3

! * See if its true or false

      it = index(cval,'true') + index(cval,' t ')  !All input is case lowered
      ie = index(cval,'false') + index(cval,' f ') !
      in = index(cval,'null') + index(cval,'output')

      if ( it .gt. 0 .or. ie .gt. 0 ) then
!         write(*,*) 'tname = ',tname,' type = ',itype
         if ( ( itype .gt. 2 .and. & 
               (itype .lt. 8 .or. itype .gt. 12) ) & 
              .or. itype .eq. -99 ) then 
            if ( it .gt. 0 ) then
               rval = 1         !True is equivalent to 1
            else
               rval = 0         !False is equivalent to 0
            endif
         else  !true or false specified but not a logical type 
            rval = -999999.
            err  = .true.
         endif
      elseif ( in .gt. 0 ) then !if null ignore
         rval = -999999.0
      else
         it = rlan(cval)
         i  = 1
         ie = 0
         do while ( i .le. it .and. ie .eq. 0 )
            if ( (ichar(cval(i:i)) .gt. 57) .and. (ichar(cval(i:i)) .ne. 101) ) ie = 1 !look for something other than a number
			i = i + 1
         enddo
         if ( ie .eq. 0 ) then  !No alpha found read number
!		     if (cval .eq. '0.        ') then
!			    rval = 0.0
!             else
             read(cval,*,IOSTAT=it) rval
            if ( it .ne. 0 ) then 
               rval= -999999.0
               err = .true.
            endif
!			end if
         else  !Characters found - probably an atd driver
            rval = -999999.0
            err = .true.
         endif

      endif

      return 

      end



      subroutine gettype(var,itype,err)

! * Arguments
      character*64   var         ! Input variable
      integer*4      itype       ! See below
      logical*4      err         ! Error reading the cval into rval

! * Locals
      integer*4      it          ! Index
      integer*4      ie          ! Index
      integer*4      nl           !length of name
      integer*4      offset       !array index or 1 for non-arrays

      character*64   tname        !temp name without the (##)

! * External functions
      integer*4      lrbl         !returns index of first blank 
      integer*4      typelkup     !Returns type of variable
                                  !>=0 Error
                                  !1 void
                                  !2 character N/A for SMS variables
                                  !3 short integer N/A for this stuff
                                  !4 integer or logical does not matter
                                  !5 long integer
                                  !6 real
                                  !7 double precision
                                  !8+ other C types not needed


! * Remove () from potential arrays
      nl = lrbl(var)
      ibs = index(var(:nl),'(')
      ibe = index(var(:nl),')')
      tname = ' '

      if ( ibe .le. ibs ) then   ! No (#) in name assume not array
         tname = var(:nl)
      else                       ! there is potentially a (#) in name
         tname = var(:ibs-1)     !delete the () from the name
      endif

      err = .false.

      if ( tname(:9) .eq. 'firstpass' ) tname = ' '
!!      itype = typelkup(tname)

      if ( itype .lt. 2 ) err = .true.

      return
      end




      subroutine get_date()

	USE DFPORT

      implicit none

! * Locals 

      integer*4    recdate(3)     !Integer form of date
      integer*4    rectime(3)     !Integer form of time

      character*256 message
      character*3   cmonth(12)  / & 
      'JAN','FEB','MAR','APR','MAY','JUN', & 
      'JUL','AUG','SEP','OCT','NOV','DEC'/

      include "flt_plot.inc"

      call idate(recdate)
      call itime(rectime)

      if((recdate(2).lt.1.or.recdate(2).gt.12) ) then
         write(message,'(A,I)') & 
              'Bad recdate(2) encountered:',recdate(2)
         call ftn_logmsg_err("get_date",message)
         recdate(2)=1
         recdate(1)=1
         recdate(3)=1111
      endif

      write (chdate,'(i2," ",a3," ",i4)')recdate(1), & 
           cmonth(recdate(2)),recdate(3)
      write (chtime,'(i2.2,":",i2.2,":",i2.2)')rectime(1), & 
           rectime(2),rectime(3)

      return
      end

!	subroutine ftn_logmsg_err(module,message)

!	implicit none

!	character*(*)   module     !Module Name
!	character*(*)   message    !Message text


!	write(*,*) 'Error in ',module,' : ',message

!	return

!	end

!	subroutine ftn_logmsg_info(module,message)

!	implicit none

!	character*(*)   module     !Module Name
!	character*(*)   message    !Message text

!	integer*4       rlan       !returns last non blank on line


!	write(*,*) 'Information from ',module,' : ',message(:rlan(message))

!	return

!	end




      subroutine get_process()

	  USE DFPORT

      implicit none
!     Locals
      integer*4  pid,is

!     Externals
      integer*4     lrbl           !Index-1 of first blank on line
      integer*4     lran           !Index-1 of first char on line


      include "flt_plot.inc"

      pid = getpid()
      write(cpid,'(I7)',IOSTAT=is) pid
      if ( is .ne. 0 ) cpid = '3445'

!     Save data to flt_plot.inc common block variables
      cpid = cpid(lran(cpid):)

      call getlog(username)

      return
      end


	  subroutine write_mess(message,line,nl,testfile)

      character*(*) message        ! Error specific message
      character*(*) line           ! Contents of line wherr error occurred
      character*(*) testfile       ! File where error occurred

      integer*4     nl             ! Line number where error occurred

      character*256 message1       ! Local message 

!>    External functions
      integer*4     rlan           ! Returns index of first char from right



!      write(*,12) 'Error reading file ',testfile
!      write(*,*) message(:rlan(message))
!      write(*,11) 'Error occured reading line ',nl
!      write(*,*) line(:rlan(line))


 11   format(A,I5,A,A)
 12   format(A,A)

      return
      end



      subroutine read_icmap(ic_set,ic_out,numic,err)
      implicit none 

! * Argument list
      character*64  ic_set(200) !Array of IC varibles that get set
      character*64  ic_out(200) !Array of IC varibles that get set

      integer*4     numic       !Number of valid ICs

      logical*4     err         !Error flag

! * Locals
      integer*4     i           !Loop counter
      integer*4     ist         !IOSTAT flag
      integer*4     lu42  /42/  !Unit for icmap.dat file

      character*256 message     !Output message
      character*132 filein      !Full name of icmap.dat file
      character*132 line        !Input data line

      logical*4     fexist      !File exists flag

! * External

      integer*4     lrbl        !returns first blank on line

      include "flt_plot.inc"

      call pathfile(filein,fpath,'icmap.dat')
      inquire(FILE=filein(:lrbl(filein)),EXIST=fexist)

      numic = 0

      if ( fexist ) then        !IC map file exists so read it
         open(UNIT=lu42,FILE=filein(:lrbl(filein)),IOSTAT=ist)
         if ( ist .ne. 0 ) then
            message= 'Error opening icmap.dat file'
            call ftn_logmsg_err("read_icmap",message)
            err = .true.
         else
            i   = 0
            ist = 0
            do while ( ist .eq. 0 )
               read(lu42,'(a)',IOSTAT=ist) line
               if ( ist .eq. 0 .and. line(1:1) .ne. '#' ) then
                  i = i + 1
                  read(line,*,IOSTAT=ist) ic_set(i),ic_out(i)
                  if ( ist .eq. 0 ) then
                     call lower(ic_set(i),64)
                     call lower(ic_out(i),64)
                  endif
               endif
            enddo
            close(lu42)
            numic = i
         endif
      else
         err = .true.
      endif

      return
      end






      subroutine get_labels(in_var,numvars,dimvar, & 
                            out_lab,out_index,dimout,flag,fcpmess,err)
      implicit none 

! * Argument list
      integer*4     dimvar          !dimension of in_vars array
      integer*4     dimout          !dimension of out_lab & out_index arrays
      integer*4     numvars         !Number of actives in in_vars
      integer*4     flag            !=1 get labels =2 get labs + order

      character*(*) in_var(dimvar)  !Array of variables to find in flt_symbols

      character*(*) out_lab(dimvar) !Array of labels

      integer*4     out_index(dimout) !Index array for out_lab

      logical*4     fcpmess         !Display informational messages
      logical*4     err             !Error flag

! * Locals
      integer*4     i           !Loop counter
	  integer*4     ij          !Loop counter  ! hl
      integer*4     ie          !Loop counter
      integer*4     is          !Temp index pointer
      integer*4     istatus     !IOSTAT flag
      integer*4     lu80  /80/  !Unit for flt_symbols.dat file
      integer*4     nonum       !Num of variables with no order number specified
      integer*4     nfound      !Num of labels found
      integer*4     nl          !Number of lines read
      integer*4     ordnum(200) !order number specified in flt_symbols.dat

      character*256 message     !Output message
      character*132 filename    !Full name of flt_symbols.dat file
      character*132 line        !Input data line
      character*132 lowline     !Input data line lower cased
      character*64  tvar        !temp variable for flt_symbols.dat read

      logical*4     cont        !continue flag
      logical*4     found(200)  !found array

! * External

      integer*4     lrbl        !returns first blank on line
      integer*4     rlan        !returns index of last  blank def 990
      integer*4     lran        !returns index of first nonblank 

      include "flt_plot.inc"


!>    Reset variable label found array
      do i=1,200
         found(i) = .false.
      enddo

      do i =1,dimout
         out_index(i) = i
      enddo

      nonum = 0
      nfound  = 0

      err = .false.

!>#   Read flt_symbols.dat to get axis labels and IC page labels and
!>#   order of output of IC variables on hardcopy

      call pathfile(filename,fpath,'flt_symbols.dat')
      open(lu80,FILE=filename,IOSTAT=istatus)
      if ( istatus .ne. 0 ) then
         write(message,*) 'UNABLE TO OPEN '//filename(:lrbl(filename))
         call ftn_logmsg_err("fat_readtest",message)
         err = .true.
      endif


      if ( istatus .eq. 0 ) read(lu80,'(a)',IOSTAT=istatus) line
      nl = 1 
      cont = .true.
      do while ( istatus .eq. 0 .and. cont )      
         is = index(line,'|')
         if ( line(1:1) .ne. '#' .and. is .gt. 0 ) then   ! exclude comments
            lowline = line
            call lower(lowline,132)          ! make input line lower case
            read(lowline(is+1:),*,IOSTAT=istatus) tvar
            if ( istatus .ne. 0 ) then
               err = .true.
               message='Unable to read sim variable (second column)'
               call write_mess(message,line,nl,filename)
            endif



!>          See if var is one of the ic output variables
            do ij=1,numvars
               if ( .not. found(ij) ) then
                  is = index(line,'|')
                  if ( tvar(:lrbl(tvar)) .eq. & 
                      in_var(ij)(:lrbl(in_var(ij)))) then ! Matches  vari
                     do ie=1,2
                        is = index(lowline(is+1:),'|') + is
                     enddo
                     ie = index(lowline(is+1:),'|') + is 
                     read(lowline(is+1:ie-1),*,IOSTAT=istatus) ordnum(ij) 
                     if ( istatus .ne. 0 .or. ordnum(ij) .eq. 0 ) then ! order doesn't exist 
                        ordnum(ij) = nonum + 100  ! set to end of list
                        nonum = nonum + 1
                     endif
                     read(line(ie+1:),'(a)',IOSTAT=istatus) out_lab(ij)
                     if ( istatus .ne. 0 .or. ficlab(ij) .eq. ' ') then ! Error reading this line
                        message='Unable to read Title for '//in_var(ij)
                        call write_mess(message,line,nl,filename)
                     else
                        nfound = nfound + 1
                        found(ij) = .true.
                        out_lab(ij) = out_lab(ij)(lran(out_lab(ij)):)
                     endif
                  endif
               endif
            enddo

         endif  ! Is a comment line

         read(lu80,'(a)',IOSTAT=istatus) line
         nl = nl + 1

         if ( nfound .ge. numvars ) then !Found all of the variable labels now end
            cont = .false.
         endif

      enddo

      close(lu80)  ! close flt_symbols.dat    


!>    Verify all labels found in flt_symbols.dat
      if ( nfound .lt. numvars ) then !Didn't find all labels for all variables
         do i=1,numvars
            if ( .not. found(i) ) then
               message='No label in flt_symbols.dat for: ' & 
                           //in_var(i)(:lrbl(in_var(i)))
                  out_lab(i) = in_var(i)(:lrbl(in_var(i)))
                  ordnum(i)  = nonum + 100  ! set to end of list
                  nonum = nonum + 1
               if (fcpmess) call ftn_logmsg_info("fat_readtest", & 
                            message(:rlan(message)))
            endif
         enddo
      endif

!     Create index array of the IC's in correct order based on value read in

      if ( flag .gt. 1 .and. .not. err) then
         out_index(1) = 1
         do i=2,numvars
            ie = 1
            cont = .false.
            do while ( ie .le. i-1 .and. .not. cont )
               if ( ordnum(i) .lt. ordnum(out_index(ie)) ) then !new min
                  do is = i,ie+1,-1
                     out_index(is) = out_index(is-1)
                  enddo
                  out_index(ie) = i
                  cont = .true. 
               endif
               ie = ie + 1
            enddo
            if ( .not. cont ) out_index(i) = i
         enddo

      endif !if flag > 1


      return 
      end


! This routine takes the compleate list of IC variables and attempts to
! create a matching list of IC output variables using data from the 
! icmap.dat file

      subroutine conv_ic(icvar,nic,outic,ic_set,ic_out,numic)
      implicit none

      character*64  icvar(200)           !List of ic variables
      character*64  ic_set(200)         !Array of IC varibles that get set
      character*64  ic_out(200)         !Array of matching output variables
      character*64  outic(200)           !Array of output names to match icvar

      integer*4     nic                 !Number of filled points in icvar
      integer*4     numic               !Number of filler points in ic_set/out

!     Locals
      integer*4     i,k                 !Loop counters

      logical*4     ch                  !Changed flag

!     Externals
      integer*4     lrbl        !returns first blank on line

      do i = 1,nic
         k = 1
         ch = .false.
         do while ( k .le. numic .and. .not. ch )
            if ( icvar(i)(:lrbl(icvar(i))) .eq. & 
                 ic_set(k)(:lrbl(ic_set(k)))) then
               ch = .true.
               outic(i) = ic_out(k)
            endif
            k = k + 1
         enddo
         if ( .not.  ch ) then  !IC in var not mapped to a different out var
            outic(i) = icvar(i) !add variable to output list
         endif
      enddo


      return 
      end


	subroutine pathfile(answer,path,file)

      character*(*) answer
      character*(*) path
      character*(*) file
      integer       lrbl

      answer = ' '
      answer = path(:lrbl(path))// '\' //file(:lrbl(file))

      return
      end



! Function "lrbl".  Left-Right stop at BLank.

      integer function lrbl(string)

      character*(*) string

      i = len(string)
      j = 1

      do while( string(j:j) .gt. ' ' .and. j .le. i)
         j=j+1
      enddo

      lrbl = j-1

      return
      end


! Function "lran".  Left-Right stop at Alph-Numeric.

      integer function lran(string)

      character*(*) string

      i = len(string)
      j = 1

      do while( string(j:j) .le. ' ' .and. j .le. i)
         j=j+1
      enddo

      lran = j

      return
      end


! Function "rlan".  Right-Left stop at Alph-Numeric.

      integer function rlan(string)

      character*(*) string

      i = len(string)
      j = i

      do while( string(j:j) .le. ' ' .and. j .ge. 1)
         j=j-1
      enddo

      rlan = j

      return
      end


      subroutine upper(string,numchars)
      character*(*) string
      integer numchars,i

      do i=1, numchars
         if(string(i:i) .ge. 'a' .and. string(i:i) .le. 'z') & 
              string(i:i) = char(ichar(string(i:i)) - 32)
      end do

      return
      end

      subroutine lower(string,numchars)
      character*(*) string
      integer numchars, i

      do i=1,numchars
         if(string(i:i) .ge. 'A' .and. string(i:i) .le. 'Z') & 
              string(i:i)  = char(ichar(string(i:i)) + 32)
      end do

      return
      end


	subroutine flt_window(istring)



	implicit none

	integer*4  istring     !Number of lines in window
	logical*4  result      !Return value

	!type(windowconfig) :: wc

	!result = getwindowconfig(wc)

	!if ( result ) then
	!	istring = int(wc%numtextrows)
	!else	
		istring = 40
	!endif

	return
	end

      subroutine ctoi(cin,iout)
      implicit none

      character*1 carray(10)/'0','1','2','3','4','5','6','7','8','9'/
      character*(*) cin
      integer*4 iout,nc,i,j,inarray(200),ilen
      logical*4 negative

      iout = 0
      nc = 0
      negative = .false.

      ilen = len(cin)
      do 100 j=1,ilen
         if (cin(j:j).eq.'-') then
            negative=.true.
            goto 100
         elseif (cin(j:j).eq.' ') then
            goto 100
         endif

         do i=1,10
            if (cin(j:j).eq.carray(i)) then
               nc=nc+1
               inarray(nc)=i-1
               goto 100
            endif
         enddo
         goto 150
 100  continue

 150  do j=1,nc
         iout=iout+inarray(j)*10**(nc-j)
      enddo

      if (negative) iout=-iout

      return
      end




	subroutine get_title(name,ttitle)

!	USE SIM_UTL

!** Argument list
	character*40  name             !Test name
	character*40  ttitle           !Test title

!** Locals variables 	
	character*132 file             !Full file name
	character*132 line             !Input line from file
	character*132 lowline          !Input line from file
	
	logical*4     fexist           !File exists flag	
	logical*4     fnd              !Title found in tdf file

	integer*4     lu26   /26/      !Unit for tdf file
	integer*4     ist              !IOSTAT flag
	integer*4     ii,ie            !Counter

!*** Externals
	integer*4     lrbl             !Returns first blank index from the left
	integer*4     rlan             !Returns first non-blank index from the right
	integer*4     lran             !Returns first non-blank index from the left

	include "flt_plot.inc"

!** Create file name
	call pathfile(file,fpath,name(:lrbl(name))//'.tdf')

	ttitle = 'Not Found'
	inquire(FILE=file,EXIST=fexist)
	if ( fexist ) then
		open (UNIT=lu26,FILE=file,IOSTAT=ist)
		if ( ist .eq. 0 ) then  !FIle open ok
			read(lu26,'(a)',IOSTAT=ist) line
			fnd = .false.
			do while ( ist .eq. 0 .and. .not. fnd)  
				ii = rlan(line)

				if ( line(1:1) .ne. '#' .and. ii .gt. 0) then   ! exclude comments
					lowline = line
					call lower(lowline,ii)
					ii = index(lowline,'title')
					ie = index(lowline,'=')
					if ( ii .gt. 0 .and. ie .gt. ii ) then 
						ttitle = line(ie+1:)
						ii = lran(ttitle)
						ttitle = ttitle(ii:)
						fnd = .true.
					endif 
				endif
				read(lu26,'(a)',IOSTAT=ist) line
			enddo
		endif
	endif

	close(lu26)
	return
	end


	subroutine flt_read_ic(ffile,num,vararr,icdata,mantest,err)

	implicit none

	character*132   ffile      !Data file
	character*64    vararr(200) !Variables to search for

	integer*4       num        !Number of variables to search for

	logical*4       mantest    !Manual test flag
	logical*4       err        !Err reading data flag

	real*4          icdata(200) !Value of data found

	include "flt_plot.inc"
!     Locals      

	logical*4       exist      !logical flag
	logical*4       start      !Look for start of ic data

	integer*4       i,j        !Counters
	integer*4       ist        !Status flag
	integer*4       lu40 /40/  !Logical Unit for data file
	integer*4       nl         !Number of lines read
	integer*4       nfnd       !Number of variables found

	character*132 message      !Output error message string
	character*132 line         !Output error message string
	character*64  vari         !temp variable name
	character*11  module  /'flt_read_ic'/

	real*4        val          !temp value

!>    external functions
	integer*4     lrbl         !returns loc of 1st blank from left in string
	integer*4     rlan         !returns loc of last character in string

	err = .false.

!>    Attempt to open file

	inquire(FILE=ffile,EXIST=exist)
	if ( .not. exist ) then
		message='flt_read_ic: Data file does not exist '//ffile(:lrbl(ffile))//''C
		call ftn_logmsg_err(module,message)
		err = .true.
		return
	endif

	open(lu40,FILE=ffile,IOSTAT=ist)
	if ( ist .ne. 0 ) then
		message= 'flt_read_ic: UNABLE TO OPEN '//ffile(:lrbl(ffile))//''C
		call ftn_logmsg_err(module,message)
		err = .true.
		return
	endif

!     Reset the data array - value of -999999. will not show on page
	do i=1,num
		icdata(i) = -999999.0
	enddo

	nl   = 0
	nfnd = 0
	start = .true.

	do while ( ist .eq. 0 )
		read(lu40,'(a)',IOSTAT=ist) line
		nl = nl + 1

		if ( line(1:1) .eq. '#' ) then
			if ( index(line,'DATE:') .gt. 0 ) then
				i = index(line,'DATE:')               
				read(line(i+6:),'(a)') chdate
			elseif ( index(line,'TIME:') .gt. 0 ) then
				i = index(line,'TIME:')
				read(line(i+6:),'(a)') chtime
			elseif( index(line,'Manual') .gt. 0 ) then
				mantest = .true.
			endif
		else
			call lower(line,132)

!>          Read until "start data" is found
			if ( start ) then
				i = index(line,'start')
				j = index(line,'ic')
				if ( i .gt. 0 .and. j .gt. i ) then
					start = .false.
				endif
				if( index(line,'manual') .gt. 0 ) then
					mantest = .true.
				endif
	
			else  !data is found
				i = index(line,'end ')
				j = index(line,'ic')

				if ( i .gt. 0 .and. j .gt. i ) then !if end of ic section return
					close(lu40)
					return
				endif

				read(line,*,IOSTAT=ist) vari,val
				if ( ist .eq. 0 ) then
					do i=1,num
						if ( vari(:lrbl(vari)) .eq.   &
							vararr(i)(:lrbl(vararr(i))) ) then
							icdata(i) = val
							nfnd = nfnd + 1 !increment number of found variables
						endif
					enddo
				endif

				if ( nfnd .eq. num ) then ! Return if all vairables found
					close(lu40)
					return
				endif

			endif ! If start
		endif ! if  comment
	enddo  ! while ist = 0

	close(lu40)
	return

	end

