! ******************************************************************************

! This file contains the variable declarations required by the file
! flt_read.inc

! The include file flt_plot.inc must be included before this file.

! Modified:   Mike Saladin   3/1/00  Added variable array dimensioning
! ************************************************************************


      integer*4     betavar             !Beta Variable for peak analysis
      integer*4     cfdvar              !Variable for CFD anaysis
      integer*4     conop(ndimcon)      !operator between 1st & 2nd cond 
      integer*4     dampvar             !Variable for damping analysis
      integer*4     ic                  !location of 'comment'
      integer*4     icorder(ndimic)     !Number for ic var from flt_symbols.dat
      integer*4     icout(ndimic)       !Output input IC var 1=yes 0=no
      integer*4     idnum               !index for ncnt
      integer*4     ie                  !location of 'end'
      integer*4     ieq                 !location of '='
      integer*4     ii,jj               !generic counter
      integer*4     is                  !location of 'start'
      integer*4     istatus             !IO STATUS flag 
      integer*4     it                  !location of 'title'
      integer*4     itest               !temp test number read from index file
      integer*4     ln                  !Length of name
      integer*4     lu19 /19/           !logical unit for test definition file
      integer*4     lu27 /27/           !logical unit for test index file
      integer*4     lu42  /42/          !Logical unit for icmap.dat file
      integer*4     lu80  /80/          !Logical unit for flt_symbols.dat file
      integer*4     lu81 /81/           !logical unit for tolerances.dat file
      integer*4     ncnt(4)             !# of shifts/gains specified   
                                        ! 1=acd 2=atd 3=pom 4=driver override
      integer*4     ncond               !Number of task5 conditions
      integer*4     nfound              !Counter
      integer*4     ngrid(maxgrid)      !Number of grids per y variable
      integer*4     nic                 !Number of input IC  variables
      integer*4     nl                  !Number of lines read 
      integer*4     nonum               !Number of ic vars w/o declared order
      integer*4     nplot               !Number of independent variables
      integer*4     ntask3              !# of drivers for task 3
      integer*4     ntask5(ndimcon)     !# of drivers per task 5 condition
      integer*4     ntol                !Number of tol read from tolerances.dat
      integer*4     numic               !Number of IC pairs in icmap.dat
      integer*4     nxt                 !Number of x targets
      integer*4     ny                  !Number of y variables
      integer*4     nyt                 !Number of y targets
      integer*4     phivar              !Bank Variable for peak analysis
      integer*4     plavar              !Accel analysis PLA parameter
      integer*4     powervar            !Accel analysis N1 parameter
      integer*4     totgrids            !Total Number of grids
      integer*4     xtarm(10)           !X target desired slope
      integer*4     xtarvar(10)         !X target plot variable 
      integer*4     ynplot(maxgrid)     !index of which independent for each y
      integer*4     ytarm(10)           !Y target desired slope
      integer*4     ytarvar(10)         !Y target plot variable 

      logical*4     acd                 !flag for reading acd information
      logical*4     atd                 !flag for reading atd information
      logical*4     defic               !flag for reading ic values information
      logical*4     drv                 !flag for reading driver only S & G's 
      logical*4     err                 !flag for file read errors
      logical*4     exist               !flag for test file exists
      logical*4     fexist              !File exist flag
      logical*4     fnd                 !Flag for found var in tol array
      logical*4     found(102)          !flag to verify var titles found
      logical*4     hilite(maxgrid)     !Flag for plot highlighting
      logical*4     istest              !Flag for read test info
      logical*4     istol               !Flag for read tolerances
      logical*4     plot                !flag for reading plot information
      logical*4     pom                 !flag for reading pom information
      logical*4     snapsim             !Sim data is snapshot
      logical*4     task3               !flag for reading tas k3 information
      logical*4     task5               !flag for reading task 5 information
      logical*4     text                !flag for reading text of no use here
      logical*4     ylimit(maxgrid)     !Flag for limiting plot data to yaxis

      character*256 message             !buffer for 'ftn_logmsg' output
      character*132 filename            !aero data directory path
      character*132 testfile            !name of test definition file w/path
      character*132 line                !input line read from file
      character*132 lowline             !input line forced to lower case
      character*132 blank   /' '/   !blank field
      character*256 message1            !perror buffer
      character*64  ic_set(200)         !Array of IC varibles that get set
      character*64  ic_out(200)         !Array of matching output variables
      character*64  var(4,maxgrid)      !variables names for shift/gains
      character*64  tolv(200)           !Variables for tol from tolerances.dat
      character*64  convar(2,ndimcon)   !Variable for compare in conditionals
      character*80  conval(2,ndimcon)   !value to compared coditional to
      character*64  icvar(ndimic)       !Variables for IC input
      character*64  templab(ndimic)     !Dummy holder for get_labels call
      character*64  tempic(ndimic)      !Temp holder of ic output labels to sort
      character*64  t5sync(ndimcon,ndimt5)!Variable for t5 sync 
      character*64  t5var(ndimcon,ndimt5) !Variable to be set in task 5
      character*80  t5val(ndimcon,ndimt5) !Value to set t5var to - raw ascii
      character*64  t3var(ndimcon)        !Variable to be set in task 3
      character*80  t3val(ndimcon)      !Value to set t3var to - raw ascii
      character*64  xvar(6)             !Independent plot variable by page 
      character*64  yvar(maxgrid)       !Dependent plot variables - order read 

      character*40  cname               !Temp test name as read from index file
      character*80  icval(ndimic)       !value of IC input variable
      character*8   t5source(ndimcon,ndimt5) !Source of atd data ie .acd .atd .sim
      character*8   type                !Type of plot output plot,table,snap
      character*8   snap(maxgrid)       !Snap shot data by variable
      character*2   to                  !Temp read input 
      character*2   con(2,ndimcon)      !Condition Operator as in file
      character*64  tname               !Temp variable name

      real*4        beta_st             !Start time for peak sideslip analysis
      real*4        cfd_st              !Start time for cfg analysis
      real*4        damp_st             !Start time for damping ratio analysis
      real*4        phi_st              !Start time for peak roll analysis
      real*4        recrate             !local recording rate
      real*4        t5bias(ndimcon,ndimt5)!Bias to apply to drivers
      real*4        tminx               !temp variable for determining rate
      real*4        tol_a(maxgrid)      !Absolute Tolerance per plot variable
      real*4        tol_p(maxgrid)      !Percent  Tolerance per plot variable
      real*4        tola(200)           !Absolute Tolerance from tolerances.dat
      real*4        tolp(200)           !Percent  Tolerance from tolerances.dat
      real*4        xgn(4,maxgrid)      !x gains for acd,atd,pom per y var
      real*4        xmax(6)             !X max scale by plot page
      real*4        xmin(6)             !X min scale by plot page
      real*4        xsh(4,maxgrid)      !x shifts for acd,atd,pom per y var
      real*4        xtarval(10)         !Target value for x target
      real*4        ygn(4,maxgrid)      !y gains for acd,atd,pom
      real*4        ymax(maxgrid)       !Y max scale by y variable
      real*4        ymin(maxgrid)       !Y min scale by y variable
      real*4        ysh(4,maxgrid)      !y shifts for acd,atd,pom
      real*4        ytarval(10)         !Target value for y target

!--> LOCAL END

!>    External functions
      integer*4     lrbl                !returns index of first blank def 990
      integer*4     rlan                !returns index of last  blank def 990
      integer*4     lran                !returns index of first nonblank 
      integer*4     atoi_c              !Returns integer from char string
