! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_control
!    DESCRIPTION     : Prints text file
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!--> REVISION BEGIN

!                            Revision History

! $Id: flt_print.f,v 1.4 2000/03/13 22:09:18 saladinm Exp $
! $Log: flt_print.f,v $
! Revision 1.4  2000/03/13 22:09:18  saladinm
! DR/MACAR:     None
! Problem:      Some problems existed with the printing of the second text
!               page.  Also no page size specification.
! Conclusion:   Same
! Resolution:   Added the test number to the top and the test name to the
!               title block.  Support the new page size specification and the
!               new tg_header.ps file name.  Cleaned up some time and date
!               stuff to be aligned with the cdate and ctime "globals".
! Dependencies: None
! Engineer:     Mike Saladin

! Revision 1.3  2000/02/14 17:04:01  saladinm
! Added close statement to input file so will print twice in a row.

! Revision 1.2  2000/02/14 16:15:17  saladinm
! DR/MACAR:     None
! Problem:      On site sometimes run out of 8.5X11 paper and have to use
!               A4 size paper.  This requires manually changing the tg_header.ps
!               file back and forth depending on paper size.
! Conclusion:   True
! Resolution:   Added a paper macro to tg_header.ps and an autotest_paper_size
!               specification to sim.cfg.  This module then queries sim.cg
!               and sets the proper paper size based on what is in there.
! Dependencies: sim.cfg,tg_header.ps, flt_output.f
! Engineer:     Mike Saladin

! Revision 1.1  1999/03/02 21:14:12  saladinm
! Initial revision

! Revision 1.4  1999/02/09 17:34:08  saladinm
! Fixed error with message to display via ghostview the & was being lost.

! Revision 1.3  1999/02/09 14:48:07  saladinm
! Removed a diagnostic write(*,*)

! Revision 1.2  1999/02/08 17:07:45  saladinm
! Modified to better integrate with the simulation.  Removed TOC generation
! which is now in flt_tgprint.

! Revision 1.1  1999/02/03 22:02:30  saladinm
! Initial revision

! Revision 1.1  1998/12/16 21:29:25  saladinm
! Initial revision


!--> REVISION END
! ***************************************************************************
!  This dummy routine is here to fool mscan when compiling this module.

!  DO NOT REMOVE

      subroutine dummy_print(iconst)

      real iconst

      return
      end


! ***************************************************************************
      subroutine flt_print (cfile,inum,batch,last,fctxtdisp,fctxtplot)
      implicit none

! * Argument list
      character*40  cfile             !testname

      logical*4     batch             !batch flag
      logical*4     last              !last print in batch
      logical*4     fctxtdisp         !display text file
      logical*4     fctxtplot         !print text file

      integer*4     inum              !Test number

! * Locals
      character     pm  /z'b1'/       !plus minus symbol
      character*256 cprint
      character*132 ctext
      character*132 temp1
      character*50  dots
      character*7   secpg             !doc page number - sec-page     
      character*40  ctnum             !test number in characters
      character*80  infile
      character*132  outfile
      character*40  name              !temp test name
      character*40  testname(1000)   !testnames
      character*9   module /'flt_print'/ 
      character*4   sec               !Character string of section number
      character*4   pg                !Character String of page number

      integer*4     ftpage(500,5)   !Page data 1=sec 2=test 3=# text 
                                     !          4=No pages 5=start
      integer*4     icnt            !Number of data points in ftpage
      integer*4     sect
      integer*4     date(3)              !date
      integer*4     et                   !test number end
      integer*4     i,i1,i2,i3,i4,i5,i6,i7,i8,i9,i0,iA !counters
      integer*4     ierr                 !iostat error
      integer*4     ist                  !IOSTAT flag
      integer*4     j,k,slot             !counter
      integer*4     nline                !line pointer
      integer*4     lu37  /37/           !ftinit.dat lu
      integer*4     lu4   /4/            !batch file lu
      integer*4     lu60  /60/           !text file lu
      integer*4     lu61  /61/           !front.txt file
      integer*4     lu62  /62/           !new front.txt file
      integer*4     lu65  /65/           !second printer lu
      integer*4     lu77  /77/           !tg_header.ps file unit
      integer*4     num                  !Found test number
      integer*4     numt                 !number of tests
      integer*4     testnum(1000)        !test numbers
      integer*4     itype                !Type of input
      integer*4     page  /1/            !page counter
      integer*4     paper_size  /0/      !Paper size 1=8.5x11 2=A4
      integer*4     pg_doc               !page number
      integer*4     sec_doc              !section number 
      integer*4     time(3)              !time
      integer*4     txt_doc              !# of text pages for this test
      integer*4     fininrt              !flag used by in read of tdf file
      integer*4     fattest              !Autotest number
      logical*4     end                  !end of file flag
      logical*4     first  /.true./      !first pass
      logical*4     lexist               !file exist flag
      logical*4     new                  !new part of front.txt
      logical*4     tgtext               !page is front or back of tg

! * Externals 
      integer*4     ftn_getcfg           !Get string value from sim.cfg

! * Include files

      include "flt_plot.inc"
      include "flt_read_vars.inc"

      if ( paper_size .eq. 0 ) then 
         paper_size = 1
!         i = ftn_getcfg('autotest_paper_size',message)
         if ( i .eq. 0 ) then
            call lower(message,80)
            i = index(message,'a4')
            if ( i .gt. 0 ) paper_size = 2
         endif
      endif


	  i = 0 
      jobcode = ' '
!      i = ftn_getcfg('autotest_job_number',message)
      if ( i .eq. 0 ) then
         i = lran(message)
         jobcode = message(i:i+15)
      endif

      j = 0
      k = 0
      tgtext = .false.

      j = index(cfile,'.txt')

      if (  j .gt. 0 ) then !print tg front or back
         ctnum  = cfile(:j-1)
         infile = cfile(:lrbl(cfile))
         tgtext = .true.
      else  !name should be test name
!         call itoc(inum,ctnum)
         continue
      endif

      et = lrbl(ctnum)

! * Setup filename for tdf file if needed
      if ( .not. tgtext ) then
         infile = cfile(:lrbl(cfile))//'.tdf'
      endif

      call pathfile(filename,fpath,infile)
      inquire (FILE=filename,EXIST=lexist,IOSTAT=ist)
      if (.not.lexist) then
         message='File not found: ' & 
              //filename(:lrbl(filename))
         call ftn_logmsg_info(module,message)
         return
      endif

      if ( (.not. batch) .or. first ) then

         page = 1
         if ( batch ) then
            ctext = 'txt_batch_'//cpid(:lrbl(cpid))//'.ps'
         else
            ctext = 'txt_' // ctnum(:et)// '.ps'
         endif

         call pathfile(outfile,fpath,ctext(:lrbl(ctext)))
         call new_file(outfile,ctnum(:et),ierr)
         if ( ierr .ne. 0 ) return

         if ( batch ) first = .false.

      endif

      if ( .not. batch .or. (batch .and. last) ) first = .true.  !reset first


      if ( paper_size .eq. 2  ) write(lu65,'(a)') 'set_paper_a4'
      if ( jobcode .ne. ' ') then
         write(lu65,'(A)')'/JOB ('//jobcode(:rlan(jobcode))//') def'
      endif
      write(lu65,15) '%%Page: Text ',page
      nline = 2
      if ( tgtext ) then
         write(lu65,10) '2 draw_border'
      else
         write(lu65,10) '1 draw_border'
      endif

! * Get title&comments from test definition file
      ftestname = cfile
      fattest   = inum

      if ( tgtext ) then
         write(lu65,10) ' do_sim '
      else
         include "flt_read.inc"
         ctext = title
         write(lu65,10) & 
              '/TITLE ('//ctext(:rlan(ctext))//') def do_title do_sim'
         write(lu65,12) & 
              'fnt2b ',nline,' ('//ctext(:rlan(ctext))//') shwtc'
         nline = nline + 1
         ctext = comment
         write(lu65,10) & 
              '/COMMENT ('//ctext(:rlan(ctext))//') def do_comment'
         write(lu65,12) & 
              'fnt2b ',nline,' ('//ctext(:rlan(ctext))//') shwtc'
         nline = nline +1
         write(lu65,12)  'fnt2b ',nline,' ('//ctnum(:et)//') shwtc'
         nline = nline + 2
         write(lu65,10) '/TESTNO ('//ctnum(:et)//'  '//ftestname// & 
      ') def do_testno'
         call get_pgno(inum,pg_doc,sec_doc,txt_doc)
         call doc_pg(pg_doc,sec_doc,secpg)
         write(lu65,10) '/PAGE    ('//secpg//') def do_page'
      endif


      call pathfile(filename,fpath,infile)
      open (lu60,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         message='Unable to open file '//filename(:lrbl(filename))
         call ftn_logmsg_info(module,message)
         return
      endif

      if ( .not. tgtext ) then
         ist = 0
         do while ( ist .eq. 0 ) 
            read(lu60,10,IOSTAT=ist) ctext
            call lower(ctext,rlan(ctext))
            i = index(ctext,'start')
            j = index(ctext,'text')
            if ( i .gt. 0 .and. j .gt. 0 .and. j .gt. i ) ist = 1
         enddo
      endif

      end=.false.
	  slot = 0


      read(lu60,10,IOSTAT=ierr) ctext  !read line from text file

      do while ( ierr .eq. 0 )

!        replace ~ with current test number

         i = index(ctext,'~') !search for ~ replace with testnum
         if ( i .gt. 0 ) ctext = ctext(:i-1)//ctnum(:et)//ctext(i+1:)
         i  = 1
         i1 = 1
         i2 = 1
         i3 = 0 
         i4 = 0
         do while ( i .gt. 0 )  !multiple times 
            i = index(ctext,'+/-') !search for +/- and replace with single char
            if (i .gt. 0) ctext = ctext(:i-1)//pm//ctext(i+3:)
         enddo

         do while ( i1 .gt. 0 ) 
            i1 = index(ctext(i3+1:),'(') !search for ( and add a back slash ps
            if (i1 .gt. 0) then
               ctext = ctext(:i1+i3-1)//'\'//ctext(i1+i3:)
               i3 = i1 + i3  + 1
            endif
         enddo

         do while ( i2 .gt. 0 )
            i2 = index(ctext(i4+1:),')') !search for ) and add a back slash ps
            if (i2 .gt. 0) then
               ctext = ctext(:i2+i4-1)//'\'//ctext(i2+i4:)
               i4 = i2 + i4 + 1
            endif
         enddo

         i1 = index(ctext,'TEST:')
         i2 = index(ctext,':')
         i3 = index(ctext,'Page:')
         i4 = index(ctext,'.pg')
         i5 = index(ctext,'@')     !12 pt Bold, Centered and underlined
         i6 = index(ctext,'^')     !10 pt Centered
         i7 = index(ctext,'?')     !12 pt Bold and Centered
         i8 = index(ctext,'`')     !10 pt Bold 
         i9 = index(ctext,'<')     !<> left and right justify
         i0 = index(ctext,'>')     ! "                  "
         iA = index(ctext,'JOBN')
         
         if ( i9 .ne. 0 .and. i9 + 1 .ne. i0 ) then
            if ( i2 + 1 .ne. i9 ) i9 = 0   !not <> or :< so reset i9 to zero
            i0 = 0   !not <> so reset i0 to zero
         endif
         
         if (iA .gt. 0 .and. jobcode.ne.' ') then
            ctext = ctext(:iA-1)//jobcode(:lrbl(jobcode))//ctext(iA+4:)
         endif

         if (i1 .gt. 0 .and. .not. tgtext) then 
            if ( slot .eq. 0 ) then !create a title
               ctext = ctext(i1+5:)
               title = ctext
               write(lu65,10) & 
               '/TITLE ('//ctext(:rlan(ctext))//') def do_title do_sim'
 12            format(A,I2,A)
            endif
            nline = nline - 1
         elseif (i5 .gt. 0) then
            ctext(i5:i5)=' '    ! replace the @
            write(lu65,12) & 
         'fnt3b ',nline,' ('//ctext(lran(ctext):rlan(ctext))//') shwtcu'
         elseif (i6 .gt. 0) then
            ctext(i6:i6)=' '    ! replace the ^
            write(lu65,12) & 
          'fnt1 ',nline,' ('//ctext(lran(ctext):rlan(ctext))//') shwtc'
         elseif (i7 .gt. 0) then
            ctext(i7:i7)=' '    ! replace the ?
            write(lu65,12) & 
          'fnt3b ',nline,' ('//ctext(lran(ctext):rlan(ctext))//') shwtc'
         elseif (i8 .gt. 0) then
            ctext(i8:i8)=' '    ! replace the `
            write(lu65,12) 'fnt1b ',nline,' ('//ctext//') shw'
         elseif (i9 .gt. 0 .and. i0 .gt. 0) then !left and right justified
            ctext(i9:i0)='  '    ! replace the <>
            write(lu65,12) & 
            'fnt1 ',nline,' ('//ctext(lran(ctext):rlan(ctext))//') wshw'
         elseif (i3 .gt. 0 ) then  ! page number no longer used
            nline = nline - 1
         elseif (i2 .gt. 0) then   ! bolded title
            if ( j .gt. i2 + 1 .or. tgtext .or. i9 .gt. 0) then
               if ( i9 .gt. 0 ) ctext(i9:i9) = ' '
               write(lu65,12) 'fnt1 ',nline,' ('//ctext//') shw'
            else
               write(lu65,12) & 
           'fnt3b ',nline,' ('//ctext(lran(ctext):rlan(ctext))//') shwt'
            endif
         elseif(i4 .gt. 0 ) then !New page handle below but don't print .pg
            nline = nline - 1 
         else
            write(lu65,12) & 
            'fnt1 ',nline,' ('//ctext(:rlan(ctext))//') shw'
         endif
         if (i4 .gt. 0 .or. nline .gt. numline) then   ! new page
            pg_doc = pg_doc + 1
            page   = page   + 1
            nline = 2 ! reset line number
            write(lu65,10) 'showpage'
            write(lu65,15) '%%Page: ',page,page

 15         format(A,I2,1X,I2)
            if ( tgtext ) then 
               write(lu65,10) '2 draw_border'
               write(lu65,10) 'do_sim'
            else
               write(lu65,10) '1 draw_border'
               ctext = title
               write(lu65,10) '/TITLE ('//ctext(:rlan(ctext))// & 
                             ') def do_title do_sim'
               write(lu65,12) & 
               'fnt2b ',nline,' ('//ctext(:rlan(ctext))//') shwtc'
               nline = nline + 1
               ctext = comment
               write(lu65,10) & 
               '/COMMENT ('//ctext(:rlan(ctext))//') def do_comment'
               write(lu65,12) & 
               'fnt2b ',nline,' ('//ctext(:rlan(ctext))//') shwtc'
               nline = nline +1
               write(lu65,12)  'fnt2b ',nline,' ('//ctnum(:et)//') shwtc'
               nline = nline + 2
               write(lu65,10) '/TESTNO ('//ctnum(:et)//'  '//ftestname// & 
                             ') def do_testno'
               if ( pg_doc .ne. 0 ) then
                  call doc_pg(pg_doc,sec_doc,secpg)
                  write(lu65,10) '/PAGE    ('//secpg//') def do_page'
               endif
            endif
         endif
         nline = nline + 1
         read(lu60,10,IOSTAT=ierr) ctext  !read line from text file
         if ( ierr .eq. 0 ) then
            temp1 = ctext
            call lower(temp1,132)
            i = index(temp1,'end')
            j = index(temp1,'text')
            if ( i .gt. 0 .and. j .gt. 0 .and. j .gt. i ) ierr=1
         endif


      enddo

      close(lu60)

      write(lu65,10) 'showpage'
      page  = page + 1

! print out finished.

!      call get_date()

!      if ( batch ) then
!         write(message,600) cfile(:lrbl(cfile)),chtime,chdate
!      else
!         write(message,600) outfile(:lrbl(outfile)),chtime,chdate
!      endif
!      call ftn_logmsg_info(module,message)


 600  format(' File: ',a,' finished at ',a,' ',a)

      if ( .not. batch .or. (batch .and. last)) then
         write(lu65,10) '%%EOF'
         close(lu65)
         if (fctxtdisp) then
			call start_ghostview(outfile)
         endif
         if (fctxtplot) then
		    call print_file(outfile)
         endif

         if ( batch ) then  !Delete batch file
		    call del_file(outfile)
         endif
         page = 1
      endif

      return
 10   format(A)
 11   format(A132)
 30   format(i4)
      end

      subroutine new_file(outfile,cfile,ierror)

      implicit none
      character*132 outfile      !ref print output filename
      character*40  cfile        !filename
      integer       ierror       !error code

      character*256 message
      character*132 filename
      character*132 ctext
      character*9   module /'flt_print'/
      integer       ierr
      integer       lu65   /65/  !logical unit for output file
      integer       lu77   /77/  !logical unit for for tgheader
      logical       lexist

!     external functions
      integer  rlan,lrbl         !end of line function defined in fplt

      include "flt_plot.inc" 
      ierror = 0


      call pathfile(filename,fpath,'tg_header_1.2.ps')
      
      inquire(FILE=filename,EXIST=lexist)

      if ( .not. lexist ) then  !post script header file doesn't exsit
         message ='The post script header file: '// & 
              filename(:lrbl(filename))
         call ftn_logmsg_info(module,message)
         message = 'could not be found.  No output will be produced.'
         call ftn_logmsg_info(module,message)
         ierror=1
         return
      endif

      open(lu77,FILE=filename,IOSTAT=ierr)
      if ( ierr .ne. 0) then
         message = 'The file: '//filename(:lrbl(filename))
         call ftn_logmsg_info(module,message)
         message = 'could not be opened. No output will be produced.'
         call ftn_logmsg_info(module,message)
         ierror=1              
         return
      endif

      inquire(FILE=outfile,EXIST=lexist)
      if (lexist) then
		 call del_file(outfile)
      endif

      open(lu65,FILE=outfile,STATUS='REPLACE',IOSTAT=ierr)
      if ( ierr .ne. 0) then
         message = 'The file: '//outfile(:lrbl(outfile))
         call ftn_logmsg_info(module,message)
         message = 'Could not be opened.'// & 
              '  No output will be produced.'
         call ftn_logmsg_info(module,message)
         ierror=1              
         return
      endif

      write(lu65,10) '%!PS-Adobe-3.0'
      write(lu65,10) '%%Creator: '//username(:lrbl(username))
      write(lu65,10) '%%Title: '//cfile
      write(lu65,10) '%%CreationDate:'//chdate//' '//chtime
      write(lu65,10) '%%Pages: 15 '

!     write the tg_header.ps file to the output file
      ierr = 0
      do while ( ierr .eq. 0)
         read(lu77,10,iostat=ierr) ctext !read to end of file
         if (ierr .eq. 0) write(lu65,10) ctext(:rlan(ctext))
      enddo

      close(lu77)               !close tg_header.ps

 10   format(A)         

      return
      end

