! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!    SIMULATOR       : Boeing 737-700 (7H4)
!    JOB             : 8420
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : FLT_PLOT.INC
!    DESCRIPTION     : Autotest Plot include file
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 12/09/91
!    ENGINEER        : N/A
!    SYSTEM          : Unix
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!    Copyright 1991 FlightSafety International
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
! ****************************************************************************
!--> REVISION BEGIN
!                            Revision History
! $Id: flt_plot.inc,v 1.5 2000/03/13 21:59:27 saladinm Exp $
! $Log: flt_plot.inc,v $
! Revision 1.5  2000/03/13 21:59:27  saladinm
! Added username,cpid and jobcode to common block.
! Created ndimcon and ndimt5 parameters.
! Revision 1.4  2000/02/14 16:26:12  saladinm
! DR/MACAR:     NOne
! Problem:      No real problem.
! Conclusion:   some variables never used.
! Resolution:   Removed unused variables.
!               Added some parameters to be used as array dimensions.
! Dependencies: flt_utl.f
! Engineer:     Mike Saladin
!
! Revision 1.3  1999/03/02 21:14:51  saladinm
! Updated for new autotest system.
!
! Revision 1.7  1999/02/18 14:12:52  saladinm
! Removed the variable ficinout.
!
! Revision 1.6  1999/02/08 17:06:39  saladinm
! Removed last of commented out lines and added nlic and numline parameters.
!
!--> REVISION END
! ****************************************************************************
!.mp  .TH FLT_PLOT.INC l FSI
!.mp  .SH NAME
!.mp  FLT_PLOT.INC \- Autotest Plotting include file
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp  none
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp   This module contains character strings which are shared between the 
!.mp   autotest software modules and between the host modules.
!.mp
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************

      CHARACTER*80  RCSID_flt_plot & 
      /"$Id: flt_plot.inc,v 1.5 2000/03/13 21:59:27 saladinm Exp $"/


      common /fplotc/ simname,chdate,chtime,username,cpid,		& 
            title,comment,ficoutvar,frecvar,jobcode,			& 
            fpath,ficlab,ficinvar,ftestname,fyname,				&
			fxname,freclab,jpats_vars,fsimvar,ficsimvar


	common /jpats/ jpats_nvar,jpats_indx
!
!	Parameter definitions

	integer*4		jpats_nvar		!Number of variables in jpats_vars
	integer*4		jpats_indx(200)	!Cross reference index

      integer*4 maxgrid           !max number of grids to plot = 6 pages
      parameter (maxgrid = 36)

      integer*4 numline           !Number of lines in a text file
      parameter(numline = 60)

      integer*4 nlic              !Number of ICs that make a page
      parameter(nlic = 50) 

      integer*4 ndimrec           !Dimension of recording variable arrays
      parameter(ndimrec = 200)

      integer*4 ndimic            !Dimension of IC arrays
      parameter(ndimic = 200)

      integer*4 ndimcon           !Dimension of Task 5 Conditionals
      parameter(ndimcon = 30)

      integer*4 ndimt5            !Dimension of Task 5 Statements
      parameter(ndimt5 = 15)
!
!*******************************************************************
!     Labels in the common block
!*******************************************************************
!
      character*32 simname        !simulator name (init in flt_initpath.f)
      character*12 jobcode        !Job code for plots from sim.cfg
      character*14 chdate         !test date:characters
      character*10 chtime         !test time:characters
      character*132 title         !test title
      character*132 comment       !test comment
      character*40 username       !user's login name
      character*7  cpid           !Current process id

!>#   
      character*64 frecvar(ndimrec) !Names of record variables inorder recorded
      character*64 fsimvar(ndimrec) !Names of variables recorded by host
      character*36 freclab(ndimrec) !Titles for recorded variables for hardcopy
      character*64 ficoutvar(ndimic)!Names of IC variables to Output
      character*64 ficsimvar(ndimic)!Names of IC variables from Host
      character*64 ficinvar(ndimic) !Names of IC variables input
      character*36 ficlab(ndimic)   !Titles for ic variables for hardcopy

      character*64 fpomvar(200)    !POM variable for shift and gains in .dat 
      character*64 facdvar(200)    !ACD variable for shift and gains in .dat 
      character*36 fxname(6)       !x variable name
      character*36 fyname(36)      !y variable name
      character*80 fpath           !Path name to data directory
 !     character*80 fpath /'d:\data'/           !Path name to data directory
      character*40 ftestname       !Testname
      character*40 jpats_vars(200) !JPATs specific variable interface array





