! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_output
!    DESCRIPTION     : Produces the hardcopy files - plot and IC
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! ****************************************************************************
!--> REVISION BEGIN

!                            Revision History

! $Id: flt_output.f,v 1.14 2000/03/13 21:55:59 saladinm Exp $
! $Log: flt_output.f,v $
! Revision 1.14  2000/03/13 21:55:59  saladinm
! DR/MACAR:     None
! Problem:      Had to manually change tgheader.ps for job code and for
!               page size adjustments.
!               On some hilights only stars being printed.  Some plots y data
!               would exceed the axis size.
! Conclusion:   For highlights, values trying to be printed were too large
!               for the print format.
! Resolution:   Added capability to set paper size and job code in sim.cfg.
!               Added ylimit plot option to limit data to yaxis values.
!               Modified hilight print statement to handle bigger numbers.
!               Added offset hilights so that they don't overlap.
! Dependencies: fat_readtest.f,flt_modplot.f,flt_read.fi,flt_init_plot.fi
! Engineer:     Mike Saladin

! Revision 1.13  2000/02/14 16:48:08  saladinm
! Modified argument list order and style.

! Revision 1.12  2000/02/09 20:55:50  saladinm
! Added capability to set the paper size to A4.  Requires autotest_paper_size
! to be set to A4 in sim.cfg

! Revision 1.11  2000/01/25 16:49:13  saladinm
! DR/MACAR:     None
! Problem:      Multi-config selection of autotest data directory being
!               corrupted by this file.
!               Unable for more than one person to access plots at the same time.
! Conclusion:   The inclusion of flt_select.fi in this module was overwriting
!               the previous selection of the config when in flt mode.
!               Temp files named the same for all users and would get
!               corrupted when more than one user trying to plot.
! Resolution:   Removed the reference to flt_select.fi from this module.
!               Made the temp files have the current process id in the name
!               so multiple users can plot at the same time.
! Dependencies: autotest.c, fat_initpath.f
! Engineer:     Mike Saladin

! Revision 1.10  1999/12/22 17:55:18  mattk
! flt_output.f Initial release from automated zeb process

! Revision 1.8  1999/10/01 16:54:39  mattk
! Latest update from 8427 10-1-99

! Revision 1.9  1999/09/29 21:57:18  flt
! No new code added.  Forgot to use .false. instead of false.

! Revision 1.8  1999/09/29 21:54:38  flt
! Added Mike Saladin's fix to print correct date on IC page.

! Revision 1.7  1999/08/18 16:29:51  saladinm
! Fixed error with target if one of the points was an exact match.

! Revision 1.6  1999/05/10 15:10:30  saladinm
! Added adjustment to kzet based on dt and fixed test of slope in damping calc.

! Revision 1.19  1999/03/17 18:08:59  saladinm
! Fixed accel/decel analysis for negative slopes.

! Revision 1.18  1999/03/16 18:19:26  saladinm
! Minor tweek to xp def.

! Revision 1.17  1999/03/15 13:23:47  saladinm
! Fixed problem if data file non-existant in IC section.

! Revision 1.16  1999/03/11 15:50:57  saladinm
! Fixed minor error.

! Revision 1.15  1999/03/08 16:04:06  saladinm
! Removed fcplotac, added fmantxtfl.
! Fixed display of rec rate for man test.
! Fixed x-y plot with type two data.

! Revision 1.14  1999/03/05 21:54:18  saladinm
! Fixed error for x y column data being output.

! Revision 1.13  1999/03/04 19:02:36  saladinm
! Fixed error that ic page data didn;t print if ficotnum=nlic.

! Revision 1.3  1999/03/04 16:59:16  saladinm
! Fixed error that ic page data didn;t print if ficotnum=nlic.

! Revision 1.2  1999/03/03 12:40:15  saladinm
! Fixed error for acd/pom data not seeing the xshift or xgain.

! Revision 1.12  1999/03/02 23:30:35  saladinm
! Modified/fix xshifts and gains for plotting acd/pom data.

! Revision 1.11  1999/03/01 12:15:30  saladinm
! Removed all of the fsimin stuff.

! Revision 1.10  1999/02/26 20:48:04  saladinm
! Added frecval=0 for error exit location.  Added delete of *temp.ps files.

! Revision 1.9  1999/02/24 19:28:07  saladinm
! Modified flt_read_ic to better work with the reduction routine requirements.
! It will now return all IC's in file if the flag getall is true.
! Fixed error in the printing of tolerances.

! Revision 1.8  1999/02/18 21:09:29  saladinm
! Modified spacing of markx for sim and a/c data.

! Revision 1.7  1999/02/18 14:03:59  saladinm
! Added manual test .man file code.  Handles new IC out specification.
! Fixed an error where pla_t0 did not have an index.

! Revision 1.6  1999/02/12 15:59:52  saladinm
! Fixed manual test display from sim.  Added replot capability, time shift
! through fxplotshft for replots.  Fixed display of symbols.

! Revision 1.5  1999/02/11 19:23:12  saladinm
! Added correct manual test and snap shot test for sim data logic and fixed
! error not writing last line of data to ps file.

! Revision 1.4  1999/02/11 15:31:16  saladinm
! Includes changes so that sim file is not re-read in real time and added
! slope direction for x and y targets.

! Revision 1.3  1999/02/08 17:04:58  saladinm
! Added display of test text file when a manual test is selected.

! Revision 1.2  1999/02/05 23:01:03  saladinm
! Fixed print finished test from IOS.

! Revision 1.1  1999/02/03 22:00:19  saladinm
! Initial revision

! Revision 1.5  1998/12/17 19:14:08  vdemeter
! Fixed error in tt tol calculation.

! Revision 1.4  1998/12/17 18:35:30  vdemeter
! Added engine accel/decel analysis

! Revision 1.0 1998/10/29 15:19:05  saladinm
! Initial release

!--> REVISION END
! ****************************************************************************
!.mp  .TH FLT_OUTPUT l FSI
!.mp  .SH NAME
!.mp  FLT_OUTPUT \- Test Guide output module
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp    flt_utl.a
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp    This module produces the output pages for the tests which are defined
!.mp    for the Approval Test Guide. 
!.mp
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************

       subroutine flt_output(iconst,     fattask,   fattest,    & 
        fbetavar,  fcfdvar,   fcpbctr,   fdampvar,  ficinnum,   & 
        ficinop,   ficord,    ficotnum,  fnumgrid,  fnxtar,     & 
        fnytar,    fphivar,   fplavar,   fpowervar, frecframe,  & 
        frecnumb,  frecval,   fsimruns,  fxtarm,    fxtarvar,   & 
        fxvarnum,  fymaptox,  fytarm,    fytarvar,  fyvarnum,   & 
        facdline,  fatbrun,   fatenabl,  fatman,    fatprint,   & 
        fcpcopy,   fcplot,    fcpmess,   fcprtplot, fcptolf,    & 
        fhilite,   fmantxtfl, fplotacd,  fplotman,  fplotpom,   & 
        fplotsim,  fsimline,  fsnapacd,  fsnaplot,  fsnappom,   & 
        ftgplot,   ftstover,  fylimit,   fbetast,   fcfdst,     & 
        fdampst,   ficinval,  fphist,    frecbuff,  frecrate,   & 
        ftola,     ftolp,     fxplotshft,fxscale,   fxsng,      & 
        fxtarval,  fyscale,   fysng,     fytarval)



      implicit none
      CHARACTER*80  RCSID & 
      /"$Id: flt_output.f,v 1.14 2000/03/13 21:55:59 saladinm Exp $"/


      integer*4  fattask          !ref 113 fat task controller
      integer*4  fattest          !ref fat test ip code number
      integer*4  fbetavar         !ref 113 Y index for peak analysis beta
      integer*4  fcfdvar          !ref 113 Which Y var to use for CFD ratio
      integer*4  fcpbctr          !ref 113 fat batch plot control ctr
      integer*4  fdampvar         !ref 113 Which Y var to use for damp ratio
      integer*4  ficinnum         !ref 113 Number of vars input as init's
      integer*4  ficinop(200)      !ref 113 I/O codes for IC input vars
      integer*4  ficord(200)       !ref 113 Numerical order of ic variables
      integer*4  ficotnum         !ref 113 Number of vars to output as ic
      integer*4  fnumgrid(36)     !ref 113 Number of grids to use for each y
      integer*4  fnxtar           !ref 113 Number of x targets
      integer*4  fnytar           !ref 113 Number of y targets
      integer*4  fphivar          !ref 113 Y index for peak analysis phi
      integer*4  fplavar          !ref 113 Y index for eng pla analysis
      integer*4  fpowervar        !ref 113 Y index for eng power analysis
      integer*4  frecframe        !ref rec number of frames recorded
      integer*4  frecnumb         !ref 113 Number of variables recorded
      integer*4  frecval          !ref rec program pointer
      integer*4  fsimruns         !ref 113 number of sim runs to plot
      integer*4  fxtarm(10)       !ref 113 Slope to find x target on
      integer*4  fxtarvar(10)     !ref 113 X target plot index
      integer*4  fxvarnum         !ref 113 Number of x variables for plots
      integer*4  fymaptox(36)     !ref 113 For each Y which X to use
      integer*4  fytarm(10)       !ref 113 Slope to find y target on
      integer*4  fytarvar(10)     !ref 113 Y target plot index
      integer*4  fyvarnum         !ref 113 Number of y variables plotted

      logical*4  facdline         !ref 113 Put line w/ snapshot pts ACD/POM
      logical*4  fatbrun          !ref crt batch tests running flag
      logical*4  fatenabl         !ref fat test ip enable
      logical*4  fatman           !ref 113 Manual test selected
      logical*4  fatprint         !ref 113 batch printer control flag
      logical*4  fcpcopy          !ref 113 copy output flag
      logical*4  fcplot           !ref display plots
      logical*4  fcpmess          !ref 113 6-grid message enable flag
      logical*4  fcprtplot        !ref crt print current plots
      logical*4  fcptolf          !ref fcp tolerance flag
      logical*4  fhilite(36)      !ref 113 Highlight these variables
      logical*4  fmantxtfl        !ref 113 display mantest text page when test run
      logical*4  fplotacd         !ref 113 plot aircraft data flag
      logical*4  fplotman         !ref 113 plot manual data from .man file
      logical*4  fplotpom         !ref 113 plot prrof-of-match data flag
      logical*4  fplotsim         !ref 113 plot simulator data flag
      logical*4  fsimline         !ref 113 Put line w/ snapshot pts SIM
      logical*4  fsnapacd(36)     !ref 113 Snap shot flag by variable ACD
      logical*4  fsnaplot         !ref 113 whole plot snap shot
      logical*4  fsnappom(36)     !ref 113 Snap shot flag by variable POM
      logical*4  ftgplot          !ref 113 tgplot active flag
      logical*4  ftstover         !ref 113 test over flag.
      logical*4  fylimit(36)      !ref 113 Limit plots to Y axis

      real*4     fbetast          !ref 113 Start time for peak analysis beta
      real*4     fcfdst           !ref 113 Start time for CFD analysis
      real*4     fdampst          !ref 113 Start time for damp ratio analysis
      real*4     ficinval(200)     !ref 113 Sim input ic data array
      real*4     fphist           !ref 113 Start time for peak analysis phi
      real*4     frecbuff(100000) !ref rec temp data storage arry
      real*4     frecrate         !ref rec actual autoteset recording rate
      real*4     ftola(36)        !ref 113 Absolute tolerance value
      real*4     ftolp(36)        !ref 113 Percent tolerance value
      real*4     fxplotshft       !ref 113 IOS input x shift for plotting
      real*4     fxscale(2,6)     !ref 113 X axis scales (1) min (2) max
      real*4     fxsng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fxtarval(10)     !ref 113 X target value for high lighting
      real*4     fyscale(2,36)    !ref 113 Y axis scales (1) min (2) max
      real*4     fysng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fytarval(10)     !ref 113 Y target value for high lighting


! ******************************************************************
! Eng acc/dec labels
! ******************************************************************

      logical*4 eng_accel       !eng acceletation

      real*4    pla_t0(2)       !time and value for pla
      real*4    n1_0            !initial N1
      real*4    n1_f            !final N1
      real*4    n1_10(3)        !N1 for ti (ti,value,tol)
      real*4    n1_90(3)        !N1 for tt (tt,value,tol)
      real*4    tt(2)           !time for 10% response
      real*4    ti(2)           !time for 90% response

! ******************************************************************
!>
!> AUTO-TEST OUTPUT DESIGN APPROACH:
!>
!> Auto-test outputs should serve to produce test results
!> on the screen and on paper to aid the design engineer and illustrate to
!> others the results of specific auto-tests.
!>
!> This module not only produces the results of auto-tests
!> but also produces initial conditions and damping ratio
!> analysis.  Each of these will be discussed.  
!>
!># AUTO-TEST PLOTS
!>
!> In general, plot output consists of six-grids of graphical
!> data.  Each grid represents a specific parameter necessary for
!> the verification and proof of the auto-test.  Each grid
!> displays both the aircraft and recorded simulator data.  The
!> aircraft data is obtained from the FSI data reduction programs
!> and yields a file with the extension of ACD.  This then becomes
!> the aircraft data used for the six-grid display.  Manufacturers
!> simulator data can also be plotted ( .pom files ).  Up to
!> two previous versions of simulator data can also be plotted.
!>
!>
!> As deemed by the engineer, data recorded during the test may
!> be presented in various forms.  The most common will be the
!> six-grid plot.  Data recorded can be tabulated.  Tabulated
!> output is displayed in seven columns thus representing the
!> first six parameters plus the x-axis.  If more than six
!> parameters are recorded a second set of six numbers will
!> be printed on additional pages.
!>
!> Another means of output is the snapshot.  This data is
!> plotted on a x y grid with individual points being plotted as symbols.
!>
!># INITIAL CONDITIONS
!>
!> This module is capable of producing initial condition sheets
!> along with the six-grid plots.  These sheets are used by the
!> engineers and other inspectors for verification of test setup.
!> The sheets list up to 60 parameters.  Three columns of data
!> can be shown.  The aircraft initial values, the simulator trim data
!> values and the values that the simulator was initialized to.
!> The aircraft data is derived from the flight test data.
!> Initial conditions can be printed through the
!> IOS interface after a test has been executed successfully.
!>
!>
!># DAMPING RATIO ANALYSIS
!>
!> Several auto-test are oscillatory in nature.  The best way
!> to quantify the characteristics of these tests is to analyze
!> the damping ratio and the period.  Tests such as the phugoid
!> and the dutch roll require damping ratio analysis.
!>
!> Once the desired parameter is flagged in the test definition file, 
!> this module begins to search through the aircraft and simulator
!> data and compute the damping ratio, period and time to half
!> amplitude.  
!>
!--> LOCAL BEGIN

      include "flt_plot.inc" 

! *******************************************************************
! *                  LOCAL VARIABLES & DATA
! *******************************************************************

! * Local variables

      real*4     iconst           !integration constant

      character*256 message             !buffer for 'ftn_logmsg' output
	  character*132 inline              !temp buffer
      character*132 psfile(10)          !temp postscript files
      character*132 dofile(6)           !temp data file names


      character*12  module/'flt_output'/    !module name
      character*80  filename            !test name
      character*80  plotfile            !plot PS file
      character*80  message1            !perror buffer

      character*3   cmonth(12)  / & 
      'JAN','FEB','MAR','APR','MAY','JUN', & 
      'JUL','AUG','SEP','OCT','NOV','DEC'/

!      integer       selection           !path selection

! ******************************************************************
! integer and real locals.
! ******************************************************************

      integer*4 acdnum(36)             !Number of ACD pts per variable
      integer*4 acdxptr(36)            !Point for x variables into acddata
      integer*4 acdyptr(36)            !Point for x variables into acddata
      integer*4 simnum(36)             !Number of SIM pts per variable
      integer*4 simxptr(36)            !Point for x variables into simdata
      integer*4 simyptr(36)            !Point for x variables into simdata
      integer*4 pg_doc                 !document page number
      integer*4 sec_doc                !document section number
      integer*4 i                      !i loop counter
      integer*4 istatus                !status of freeze
      integer*4 isnap                  !Sim snap shot flag for real time
      integer*4 j                      !j loop counter
      integer*4 k                      !k loop counter
      integer*4 l                      !l loop counter
	  integer*4 ip                     !Point where data found
      integer*4 lu95 /95/              !logical unit for kill_scr file
      integer*4 lu81 /81/              !logical unit for ftpages.dat  
      integer*4 lu83 /83/              !logical unit for plot output  
      integer*4 lu84 /84/              !logical unit for tg_header.ps
      integer*4 luid /69/              !LU for start of temp ps files =70
      real*4    tolv                   !min tolerance value


!  these are definitely used
      integer*4 npsfile                !Number of temp ps files
      integer*4 plt_offset             !offset for plot page files
      integer*4 grids                  !Temp number of grids per y
      integer*4 iend                   !Temp index to end of ic array
      integer*4 ig                     !Grid counter for plot plot loop
      integer*4 is                     !Status flag          
      integer*4 ist                    !temp index to start of ic array
      integer*4 line(2)                !Line numbers for IC pages
      integer*4 linest(2)              !IC page line start
      integer*4 ln                     !Length of variable name
      integer*4 locidx(40)             !Index array - not useful here
      integer*4 lp                     !Length of process id
      integer*4 lu                     !Variable logical unit
      integer*4 lx                     !temp last value of fymaptox
      integer*4 nfile                  !Number of time through master plot loop
      integer*4 ifile                  !Counter for master plot loop
      integer*4 npage                  !Number of plot pages
      integer*4 npts                   !Temp number of points for this y
      integer*4 numpts(40)             !Number of points per variable in data
      integer*4 pltpage(6,6)           !Per page, per grid variable index
      integer*4 ptr                    !Total number of data points in array
      integer*4 testnum                !Local test num fattest=0 by frecval=3
      integer*4 xidx                   !temp x index in fxname
      integer*4 xptr(40)               !Pointer to data array for x location
      integer*4 xp                     !Temp X Pointer to data array
      integer*4 yp                     !Temp Y Pointer to data array
      integer*4 yptr(40)               !Pointer to data array for y location
      integer*4 xmap(40)               !For frecnumb array = to fxvarnum arrays
      integer*4 ymap(40)               !For frecnumb array = to fyvarnum arrays
      integer*4 snap                   !Temp snap shot flag
      integer*4 lsnap                  !Location of fsnap in data array
      integer*4 idelx                  !Number of grid divisions along X axis
      integer*4 paper_size             !Resize paper to a4 size

      logical*4 err                    !Error flag
      logical*4 terr                   !Error flag
      logical*4 tfnd                   !Target found flag
      logical*4 fopen                  !File open flag
      logical*4 fexist                 !File exists flag
      logical*4 fpsopen(10)            !Flag for ps files open
      logical*4 mantest                !Manual test flag
      logical*4 snapline               !Show line with snapshot symbols
      logical*4 bpeak                  !done looking for roll peaks
      logical*4 rpeak                  !done looking for beta peaks
      logical*4 isman                  !Manual test flag in sim data only
      logical*4 dismantxt              !Display manual text 
      logical*4 simman                 !Local storage that sim test was manual
      logical*4 replot                 !Replot the data with xshift
      logical*4 ylim                   !Limit plotted data to Y axis limits

      real*4    acddata(100000)        !Acd data for analysis & tolerances
      real*4    simdata(100000)        !Sim data so don't re-read file in rt

      real*4    xtary(10)              !X val of y target
      real*4    ty                     !Y value of x target
      real*4    icindata(200)           !Sim Ic input data
      real*4    icdata(200)             !IC data read from file
      real*4    xmin                   !Temp x Min scale
      real*4    xmax                   !Temp x Max scale
      real*4    ymin                   !Temp y Min scale
      real*4    ymax                   !Temp y Max scale
      real*4    xsng(2,200)             !Temp X shift and gains
      real*4    ysng(2,200)             !Temp Y shift and gains
      real*4    tola                   !Temp absolute tolerance value
      real*4    tolp                   !Temp percent tolernace
      real*4    period(2)              !Period for damp ratio analysis
      real*4    zeta(2)                !Damping ration from analysis
      real*4    xd(2,2)                !X1 and X2 parameters from damp analysis
      real*4    zval(2,5)              !Peak values from damp analysis
      real*4    rval(2,5)              !Peak values from roll/beta analysis
      real*4    bval(2,5)              !Peak values from roll/beta analysis
      real*4    ztime(2,5)             !Time values of peaks from damp analysis
      real*4    rtime(2,5)             !Time values of peaks from roll/beta analysis
      real*4    btime(2,5)             !Time values of peaks from roll/beta analysis
      real*4    xshft                  !Xshift value
      real*4    xgain                  !Xgain value

      character*64 xvar                !Temp x variable name
      character*8 page_label            !page label
      integer*4   page_no               !total page number

!**Last pass plot values

	  integer*4 lig                     !Grid counter for plot plot loop
	  integer*4 lgrids                  !Temp number of grids per y
      real*4    lxmin                   !Temp x Min scale
      real*4    lxmax                   !Temp x Max scale
      real*4    lymin                   !Temp y Min scale
      real*4    lymax                   !Temp y Max scale
	  integer*4 lidelx                  !Number of grid divisions along X axis
	  integer*4 temp_numgrid


! * End of Local Variables

! * External functions
      integer*4     lrbl           !Index-1 of first blank on line
      integer*4     lran           !Index of first character from left 
      integer*4     rlan           !Index of first character from the right
      integer*4     ftn_getcfg     !Get something from sim.cfg
!>
!># PREPARATION AND INITIALIZATION FOR PLOT ACTIVITIES
!>
!>## PROGRAM MONITOR FOR RECORDED SIMULATOR DATA.
!>
!> As each auto-test begins, a monitor is flagged and records
!> the new test name and run number in a directory.  An
!> array is created as tests continue to engage and run.
!> This array is reference when the simulator recorded
!> data is required for plotting.  All simulator recorded
!> data is stored in a testname.sim file.
!>

! *******************************************************************
! ESTABLISH SIMULATOR NAME FOR GLOBAL USE AND PATH WAY
! *******************************************************************

!> # File layout and unit assignments
!>
!> The FSI autotest system uses several file units to access data
!> for plotting, recording and all other functions.
!> 
!> For consistency in software design, each file will have an assigned
!> unit which should be used throughout the real time and non-real time
!> software.
!> 
!> The assignments are as follows:
!> 
!> ------------------------------------------------------------------------
!> |File               |Unit     |Description                             |
!> ------------------------------------------------------------------------
!> |misc               |7        |misc batch file for lookplot & simplot  |
!> |misc               |8        |misc or scratch files                   |
!> |misc               |9        |misc or scratch files                   |
!> |                   |         |                                        |
!> |Data files         |40       |read data from files in fat_read        |
!> |                   |         |                                        |
!> |*.txt              |60       |txt files                               |
!> |front.txt          |61       |front section txt file                  |
!> |front.txt          |62       |new front section txt file              |
!> |txt_*.ps           |65       |txt files in post script                |
!> |                   |         |                                        |
!> |ic_page_1_temp.ps  |70       |test initial conditions in  postscript  |
!> |ic_page_2_temp.ps  |71       |test initial conditions in  postscript  |
!> |damp_page_temp.ps  |72       |damp ratio page
!> |peak_page_temp.ps  |73       |roll/bank analysis page
!> |plot_page_1_temp.ps|74       |test plot in postscript page 1          |
!> |plot_page_2_temp.ps|75       |test plot in postscript page 2          |
!> |plot_page_3_temp.ps|76       |test plot in postscript page 3          |
!> |plot_page_4_temp.ps|77       |test plot in postscript page 4          |
!> |plot_page_5_temp.ps|78       |test plot in postscript page 5          |
!> |plot_page_6_temp.ps|79       |test plot in postscript page 6          |
!>
!> |ftpages.dat        |81       |page reference index                    |
!> |                   |         |                                        |
!> |flt_symbols.dat    |80       |software label file                     |
!> |flt_batch.dat      |82       |data reduction batch file               |
!> |                   |         |                                        |
!> |flt_header.ps      |90       |flt header postscript file              |
!> |lookplot.ps        |91       |flt lookplot postscript file            |
!> |simplot.ps         |92       |flt simplot postscript file             |
!> |kill_scr           |95       |kill script file                        |
!> ------------------------------------------------------------------------
!> 
!> All pertinent files are opened in this module.  They are opened for 
!> both the real time and non-real time software environments.
!> 



! WHAT ABOUT SIM.CFG AND/OR OLIVE.CFG?

!     The subroutine "getdpath" (see bottom of module) will scan the cfg
!     file for the character strings listed in "in_array" (excerpt
!     follows).

!     character*23  in_array(6) /'autotest_data_directory',  !DEFAULT
!    >                           'autotest_data_director2',  !2nd path
!    >                           'autotest_data_director3',  !3rd path
!    >                           'autotest_data_director4',  !4th path
!    >                           'autotest_data_director5',  !5th path
!    >                           'autotest_data_director6'/  !6th path

!     Verify that your sim.cfg and/or olive.cfg contain at least the
!     "default" string listed. If you have more than one simulation
!     for your job, ensure that the other strings are listed EXACTLY
!     to that of the above.  Then verify that the associative paths
!     are correct.

! IF YOU HAVE ONE MODEL:
!        
!     The data path selection is automatic for both "flt" and "autotest".
!     You will not see any menus for path selection when you run "flt".

! IF YOU HAVE MULTIPLE MODELS:

!     The data path selection will occur as follows:
!          1) flt
!               a) getdpath will find the multiple strings in your
!                  sim.cfg and /or olive.cfg file and will automatically
!                  build a menu.
!               b) You will select the data path you want to use.
!          2) simulation
!               a) Simulation flags which indicate a specific model
!                  will be set (e.g., ZFL757 for the 757 model).
!               b) YOU MUST ADD the appropriate flags to code below and
!                  associate with the correct data path for that simulation.

! HOW DOES THE SOFTWARE KNOW THAT THE SIM IS RUNNING?

!     The software does not know when the simulation is running.  However,
!     it does know when "flt" is running when the flag "ftgplot" is set
!     to true.  Otherwise, it is set to false when the simulation is
!     active.

!     Get the desired paper size from sim.cfg file
         paper_size = 1
!         is = ftn_getcfg('autotest_paper_size',message1)
         if ( is .eq. 0 ) then
            call lower(message1,80)
            is = index(message1,'a4')
            if ( is .gt. 0 ) paper_size = 2
         endif

         jobcode = ' '
!         is = ftn_getcfg('autotest_job_code',message1)
!         if ( is .eq. 0 ) then
!            is = lran(message1)
!            jobcode = message1(is:is+15)
!         endif

!        Initialize sms labels
         fcptolf = .false.
         fatprint= .true.

         call get_process()
         lp=lrbl(cpid)
!        Create temporary file names for postscript generation
         call pathfile(psfile(1),fpath,'ic_1_'//cpid(:lp)//'.ps')
         call pathfile(psfile(2),fpath,'ic_2_'//cpid(:lp)//'.ps')
         call pathfile(psfile(3),fpath,'damp_1_'//cpid(:lp)//'.ps')
         call pathfile(psfile(4),fpath,'peak_1_'//cpid(:lp)//'.ps')
         call pathfile(psfile(5),fpath,'plot_1_'//cpid(:lp)//'.ps')
         call pathfile(psfile(6),fpath,'plot_2_'//cpid(:lp)//'.ps')
         call pathfile(psfile(7),fpath,'plot_3_'//cpid(:lp)//'.ps')
         call pathfile(psfile(8),fpath,'plot_4_'//cpid(:lp)//'.ps')
         call pathfile(psfile(9),fpath,'plot_5_'//cpid(:lp)//'.ps')
         call pathfile(psfile(10),fpath,'plot_6'//cpid(:lp)//'.ps')

         npsfile = 10
         plt_offset = 4
         dismantxt  = .true.
         simman = .false.
         fxplotshft = 0.

!        Set the local index array to standard order when calling flt_read_data
         do i=1,40
            locidx(i) = i
         enddo

!     Reset inputs from ios if running a test
      if ( .not. ftgplot .and. fattask .gt. 1 .and. .not. fatbrun) then
         fcplot     = .false. !don't try to display
         fcprtplot  = .false. !don't print plots
      endif


! * Allow for printing from IOS after test is finished running
      if ( fcprtplot .and. frecval .eq. 0 .and. ftstover ) then
         ln = lrbl(plotfile)
         if ( ln .gt. 8) then
		    call print_file(plotfile)
            fcprtplot = .false.
         endif
      endif

      if ( fcplot .and. frecval .eq. 0 .and. ftstover ) then
         replot = .true.
      else
         replot = .false.
      endif


      if ( frecval .eq. 1 .or. ftgplot ) testnum = fattest

      if ( fplotman ) then 
         simman = .true.
      elseif ( .not. fplotman .and. ftgplot ) then
         simman = .false.
      endif

! * Save whether test was manual or not fatman gets reset before frecval = 3
 !     if ( fattask .gt. 3 .and. fatman  ) then
  !       simman   = .true. 
   !      fplotman = .true.
    !     if (  dismantxt .and. fmantxtfl ) then
     !       dismantxt = .false.
!            call flt_print(ftestname,fattest,.false.,.true.,.true.,.false.)
      !   endif
 !     elseif ( fattask .eq. 5 ) then
  !       simman = .false.
   
   !   endif

! * If test not finished then return - redo plot if fxplotshft !=0 and plot
      if ( frecval .ne. 3 .and. .not. replot ) return


      dismantxt = .true.

      frecval = 5
!>
!>## MODULE BATCH MODE.
!>
!> This module, when synchronized with the auto-test controller
!> (113), will batch out or plot one test after another
!> automatically.  The batch mode simplifies the number of user
!> interactions with the AIOS and speeds up the output.  The
!> batch mode is activated by the 113 module when the flag
!> FATBRUN is set true starting the process.  The batch mode
!> will plot all available data, print initial conditions,
!> and damping ratio analysis.
!>

! *******************************************************************
! BATCH TESTS CONTROL INITIATED BY F113 THROUGH FCPBCTR
! *******************************************************************


      if (fatbrun) then                  !batch tests running
        if (fcpbctr.eq.1 ) then   !initialise set by f113
           if ( .not. ftgplot ) then    !if non real time
              fcplot = .false.    !don't try to display plots
              if ( fatprint ) then  
                 fcprtplot = .true. !print plots
              endif
           endif
           fcpbctr = 2
        endif
      endif
!>
!>## MODULE CONTROLLER TO DISTRIBUTE PLOT/PRINT COMMANDS.
!>
!> Commands sent from the AIOS or the batch software indicate
!> the specific output desired.  Logic is such that only one
!> process is handled at a time.  From here the module will
!> plot the six-grid data, print initial conditions or
!> the damping ratio analysis.
!>

      page_no   = 1             !reset number of plot pages done

!     Reset variable grid mapping
      do i=1,6
         do j=1,6
            pltpage(i,j) = 0
         enddo
      enddo


!     Double check file states and close all logical units used to build 
!     the post script files and delete all temp files
      do i=1,npsfile
         lu = luid + i 
         inquire(lu,OPENED=fopen,IOSTAT=is)
         if ( fopen ) close(lu,IOSTAT=is)
         fpsopen(i) = .false.

        inquire(FILE=psfile(i)(:lrbl(psfile(i))),EXIST=fexist)
         if ( fexist ) then
		    call del_file(psfile(i)(:lrbl(psfile(i))))
         endif
      enddo


      do i = 1,6           !reset input files 
         dofile(i) = ' '
      enddo

      ln = lrbl(ftestname)
      fpath = 'd:\data'
!     Put Required file paths together
      if ( fplotacd ) then
         call pathfile(dofile(1),fpath,ftestname(:ln)//'.acd')
      endif
      if ( fplotsim ) then
         call pathfile(dofile(2),fpath,ftestname(:ln)//'.sim')
      endif
      if ( fplotman ) then
         call pathfile(dofile(3),fpath,ftestname(:ln)//'.man')
      endif
!      if ( fplotpom ) then
         call pathfile(dofile(4),fpath,ftestname(:ln)//'.pom')
!      endif
      if ( fsimruns .ge. 2 ) then
         call pathfile(dofile(5),fpath,ftestname(:ln)//'.sim.1')
      endif
      if ( fsimruns .ge. 3 ) then
         call pathfile(dofile(6),fpath,ftestname(:ln)//'.sim.2')
      endif

!     Create name of output postscript file plot_testnum.ps
      call itoc(testnum,message)
      message = 'plot_'//message(:lrbl(message))//'.ps'
      call pathfile(plotfile,fpath,message(:lrbl(message)))
	  call del_file(plotfile(:lrbl(plotfile)))

!     get starting page no's
      call get_pgno(testnum,pg_doc,sec_doc,i)

      if ( pg_doc .gt. 0 .and. fcpmess .and. ftgplot) then
         message='Page number found '
         call ftn_logmsg_info(module,message)
      elseif ( pg_doc .eq. 0 .and. fcpmess .and. ftgplot) then
         message='Page number NOT found '
         call ftn_logmsg_info(module,message)
      endif
      if ( pg_doc .gt. 0 ) pg_doc = pg_doc + i - 1 !ic starts after text   

! **********************************************************************

!     Start of write IC pages

! **********************************************************************

!     Open temp ps files for IC pages as needed

      if ( (fplotsim .or. fplotacd) .and. ficotnum .gt. 0 ) then !open IC fil 

!        Read data file for run date for ic pages
         if (simman ) then
            k = 3               !Manual test data
         else
            k = 2               !Sim data
         endif

         if ( dofile(k)(1:1) .ne. ' ' ) then
            call flt_read_ic(dofile(k), ficotnum,ficoutvar, & 
                 icdata,mantest,terr)
         endif

         if ( ficotnum .gt. nlic ) then
            i = 2
            iend = nlic
         else
            i = 1
            iend = ficotnum
         endif
         ist = 1     !Start at the first point in IC arrays

         do j=1,i
            if ( j .eq. 2 ) then
               ist  = nlic+1
               iend = ficotnum
            endif

            open(luid+j,file=psfile(j),status='new',iostat=is) !ic page 1

            if ( is .ne. 0 ) then !error opening file
               message = 'Unable to open file: '//psfile(j)
               call ftn_logmsg_err(module,message(:rlan(message)))
               err = .true.
               fpsopen(j) = .false.
            else                ! write page header info
               fpsopen(j) = .true.
               page_label='IC'
               call ps_do_top(luid+j,line(j),page_label, & 
                    page_no,pg_doc,sec_doc,testnum,paper_size)
               call ps_man_rate(luid+j,0,0,simman) !Write manual test if true
               call ps_ic_head(luid+j,line(j),ficlab,ficord,ist, & 
                       iend)
               page_no = page_no + 1
               linest(j) = line(j)
            endif   

         enddo  !Do j=1,i

      endif  ! if fplotsim or fplotacd

! * Create Damping Ratio Page file if needed
      if ( fdampvar .gt. 0 ) then
         j = 3  !PS file index for damp ratio analysis
         open(luid+j,file=psfile(j),status='new',iostat=is) !Damp page

         if ( is .ne. 0 ) then  !error opening file
            message = 'Unable to open file: '//psfile(j)
            call ftn_logmsg_err(module,message(:rlan(message)))
            err = .true.
            fpsopen(j) = .false.
         else                   ! write page header info
            fpsopen(j) = .true.
            page_label='Ratio'
            call ps_do_top(luid+j,i,page_label, & 
                 page_no,pg_doc,sec_doc,testnum,paper_size)
            page_no = page_no + 1
         endif   
      endif

      if ( fphivar.gt.0.and.fbetavar.gt.0 ) then
         j = 4
         open(luid+j,file=psfile(j),status='new',iostat=is) !Peak page

         if ( is .ne. 0 ) then  !error opening file
            message = 'Unable to open file: '//psfile(j)
            call ftn_logmsg_err(module,message(:rlan(message)))
            err = .true.
            fpsopen(j) = .false.
         else                   ! write page header info
            fpsopen(j) = .true.
            page_label='Peak'
            call ps_do_top(luid+j,i,page_label, & 
                 page_no,pg_doc,sec_doc,testnum,paper_size)
            page_no = page_no + 1
         endif   
      endif


!     Master Write IC's loop

      npage = 0

!     First make sure proper files are opened 
      if ( fpsopen(1) .and. ( fpsopen(2) .or. ficotnum .le. nlic) ) then
         do i=1,2 
            if ( dofile(i)(1:1) .ne. ' ' ) then ! attempt to make ic
!           Read ic data from acd and sim (man) files and write to temp ps file
               if ( i .eq. 1) then
                  k = 1 !Acd data
               elseif ( i .eq. 2 .and. simman ) then
                  k = 3 !Manual test data
               else
                  k = 2 !Sim data
               endif
               call flt_read_ic(dofile(k),ficotnum,ficoutvar, & 
                                      icdata,mantest,terr)
               if ( .not. terr ) then
                  npage = npage + 1 !increment so sim init values written once
                  if ( ficotnum .gt. nlic ) then
                     k = 2       !Loop through writes twice - two pages req'd
                     iend = nlic !Only write one page worth first time
                  else
                     k = 1            !All data will fit on one page
                     iend = ficotnum  !Write all data 
                  endif
                  ist = 1       !Start at the first point in IC arrays

                  do j=1,k
                     if ( j .eq. 2 ) then !second time through adjust indices
                        ist  = nlic+1
                        iend = ficotnum
                     endif

                     if ( i .eq. 1 ) then
                        lx = 2       !set column for aircraft data
                     else
                        lx = 4       !set column for sim/man data
                     endif
                     call ps_write_ic(luid+j,icdata,ist,iend, & 
                                         lx,ficord,linest(j))

                  enddo         ! j=1,k

               endif            ! not error reading ic data
            endif               ! If dofile(i) != ' ' 
         enddo                  ! i=1,2 master IC loop 
      endif                     ! If fpsopen checks

!     Calculate total number of grids and load page array

      k  = 0
      lx = -1
      npage        = 0          ! Start with 1 page
      do j=1,fyvarnum
         if ( fymaptox(j) .eq. lx ) then !Same x variable
            if ( k + fnumgrid(j) .gt. 6 ) then ! page full 
               npage = npage + 1               
               pltpage(npage,1) = j
               k = fnumgrid(j)
            else
               pltpage(npage,k+1) = j
               k = k + fnumgrid(j)
            endif
         else                   ! New x means new page
            npage = npage + 1
            pltpage(npage,1) = j
            k = fnumgrid(j)
            lx = fymaptox(j)
         endif
         if ( fnumgrid(j) .gt. 1 ) then !Fill
            do i=k-fnumgrid(j)+2,k
               pltpage(npage,i) = 99
            enddo
         endif
      enddo
      isnap = 0
!     Map y & x variables to frecvar
      do i=1,frecnumb
         do j=1,fyvarnum
            if ( fyname(j)(:lrbl(fyname(j))) .eq. & 
                 frecvar(i)(:lrbl(frecvar(i))) ) then
               ymap(j) = i
            endif
         enddo
         do j=1,fxvarnum
            if ( fxname(j)(:lrbl(fxname(j))) .eq. & 
                 frecvar(i)(:lrbl(frecvar(i))) ) then
               xmap(j) = i
            endif
         enddo
         if ( frecvar(i)(:lrbl(frecvar(i))) .eq. 'fsnap' ) then
            isnap = i
         endif
      enddo

! * If real time save frecbuff into simdata to not re-read .sim file
      if ( .not. ftgplot .and. .not. replot)  then ! if real time save simdata
         k = 1
         do i=1,frecnumb
            do j=1,frecframe
               simdata(k) = frecbuff((j-1)*frecnumb + i)
               k = k + 1
            enddo
            simnum(i) = frecframe
            simyptr(i) = k - frecframe
            simxptr(i) = 1
         enddo
         if ( isnap .ne. 0 ) isnap = simyptr(isnap)
      endif


!     Open plot ps temp files one for each page of plots    
      k = plt_offset
      do j=1,npage
         open(luid+j+k,FILE=psfile(j+k),STATUS='NEW',IOSTAT=is) 

         if ( is .ne. 0 ) then  !error opening file
            message = 'Unable to open file: '//psfile(j+k)
            call ftn_logmsg_err(module,message(:rlan(message)))
            fpsopen(j+k) = .false.
         else                   ! write page header info
            fpsopen(j+k) = .true.
            call itoc(j,page_label)
            call ps_do_top(luid+j+k,i,page_label, & 
                 page_no,pg_doc,sec_doc,testnum,paper_size)
            page_no = page_no + 1
         endif   
      enddo

! * Setup snap shot flags



! ********************************************************************
!   This is the master loop for plotting data.

!   Pass 1 = acd data 
!   Pass 2 = sim data
!   Pass 3 = man data
!   Pass 4 = pom data
!   Pass 5 = sim.1 data
!   Pass 6 = sim.2 data

! *******************************************************************
      nfile = 0  !Number of files plotted on page
      rpeak = .false.
      bpeak = .false.
      do ifile=1,6
         if ( dofile(ifile)(1:1) .ne. ' ' ) then ! attempt to make plot
!           Get shifts/gains for acd & pom data as necessary
            if ( ifile .eq. 1 .or. ifile .eq. 4 ) then 
               k = 1
               if ( ifile .eq. 4 ) k = 2
               do j=1,frecnumb
                  xsng(1,j) = fxsng(k,1,j)   ! shift
                  xsng(2,j) = fxsng(k,2,j)   ! gain
                  ysng(1,j) = fysng(k,1,j)   ! shift
                  ysng(2,j) = fysng(k,2,j)   ! gain
               enddo
            else  ! no shift/gains for sim data
               do j=1,frecnumb
                  xsng(1,j) = 0.0  ! shift
                  xsng(2,j) = 1.0  ! gain
                  ysng(1,j) = 0.0  ! shift
                  ysng(2,j) = 1.0  ! gain
               enddo
            endif

!           Read desired data from file don't re-read sim data if real time
            ptr = 1 !reset data storage index

            if (  .not. ftgplot .and. & 
                 (( ifile .eq. 2 .and. .not. simman ) .or.  & 
                  ( ifile .eq. 3 .and. simman)        ) )then
               do i=1,frecnumb*frecframe
                  frecbuff(i) = simdata(i)
               enddo
               do i=1,frecnumb
                  numpts(i) = simnum(i)
                  xptr(i)   = simxptr(i)
                  yptr(i)   = simyptr(i)
               enddo
               if ( replot .and. fxplotshft .ne. 0 ) then !shift time data
                  do i=1,frecframe
                     frecbuff(i) = frecbuff(i) + fxplotshft
                  enddo
               endif

               lsnap = isnap
               if (simman) isman = .true.
               terr = .false.
            else
               call flt_read_data(dofile(ifile),frecvar,frecnumb,locidx, & 
               xsng,ysng,numpts,xptr,yptr,ptr,frecbuff,lsnap,isman,terr)
            endif

! *        Save acd data for potential line change for tolerances
            if ( ifile .eq. 1 .and. fcptolf ) then
               do i=1,ptr
                  acddata(i) = frecbuff(i)
               enddo

               do i=1,frecnumb
                  acdnum(i) = numpts(i)
                  acdxptr(i) = xptr(i)
                  acdyptr(i) = yptr(i)
               enddo
            endif
            if ( .not. terr ) then
               nfile = nfile + 1 ! Times through this loop
               do i=1,npage  ! Pages loop
                  xidx = fymaptox(pltpage(i,1)) !index into fxvarnum arrays
                  xvar = fxname(xidx)
                  xmin = fxscale(1,xidx)
                  xmax = fxscale(2,xidx)
                  ig = 1
                  do j=1,6   !Grids Loops
                     if ( pltpage(i,j) .ne. 0 .and. & 
                          pltpage(i,j) .ne. 99 ) then
                        npts  = numpts(ymap(pltpage(i,j)))
                        yp    = yptr(ymap(pltpage(i,j))) !start of y data
                        xp    = xptr(ymap(pltpage(i,j)))

! *   if the xptr for the yvar is 1 then the xvar is stored
! *   in the data array as a yvar in slot xmap()
                        if ( xvar(:lrbl(xvar)) .ne. 'ftsttime' & 
                             .and. xp .eq. 1) then
                           xp = yptr(xmap(xidx))
                           if ( xp .eq. 0 ) xp = 1
                        endif

                        ymin = fyscale(1,pltpage(i,j))
                        ymax = fyscale(2,pltpage(i,j))
                        grids = fnumgrid(pltpage(i,j))
                        xshft = xsng(1,ymap(pltpage(i,j)))
                        xgain = xsng(2,ymap(pltpage(i,j)))
                        ylim  = fylimit(pltpage(i,j))

! *   Do manual test and rate for sim data only
                        if ( j .eq. 1 .and.  & 
                            ((ifile .eq. 2 .and. .not. simman) .or. & 
                             (ifile .eq. 3 .and. simman) )) then
                           call ps_man_rate(luid+i+plt_offset, & 
                                frecbuff(5),frecbuff(6),simman)
                        endif
!     Set up snapping
                        snap = 0
                        snapline = .false.
                        if ( ifile .eq. 1 ) then !smap shot acd
                           if ( fsnapacd(pltpage(i,j)) ) snap = 1
                        elseif ( ifile .eq. 4 ) then !snap shot pom
                           if ( fsnappom(pltpage(i,j)) ) snap = 1
                        endif
                        if ( fsnaplot .and.  & !if plot snap shot set not sim data
                             ( ifile .eq. 1 .or. ifile .eq. 4 ) ) & 
                               snap = 1
                        if ( facdline .and. snap .eq. 1 & 
                             .and. ifile .eq. 1) snapline = .true. !connect snapshot points w/line

                        if ( lsnap .gt. 0 ) then
                           snap = lsnap
                           if ( fsimline ) snapline = .true.
                        endif
                        tola = 0.
                        tolp = 0.
! *   Write data to file one grid & one file at a time

						if( fnumgrid(pltpage(i,j)) .eq. -1 ) then
							ig = lig
							grids = lgrids
							ymin = lymin
							ymax = lymax
							xmin = lxmin
							xmax = lxmax
							idelx = lidelx
							if( nfile .ne. 1 ) then
								call flt_plot(luid+i+plt_offset,frecbuff,npts, & 
									xp,yp,ymap(pltpage(i,j)),8,nfile,ig, & 
									grids,ymin,ymax,xmin,xmax,idelx,snap, & 
									snapline, tola, tolp, xshft, xgain,ylim)
							endif
						else
							call flt_plot(luid+i+plt_offset,frecbuff,npts, & 
								xp,yp,ymap(pltpage(i,j)),ifile,nfile,ig, & 
								grids,ymin,ymax,xmin,xmax,idelx,snap, & 
								snapline, tola, tolp, xshft, xgain,ylim)
						endif

						lig = ig
						lgrids = grids
						lymin = ymin
						lymax = ymax
						lxmin = xmin
						lxmax = xmax
						lidelx = idelx

! *   Plot tolerances if != 0 and acd data and requested
                        if ( ifile .eq. 1 .and. fcptolf .and.  & 
                             ( ftola(pltpage(i,j)) .ne. 0. .or. & 
                             ftolp(pltpage(i,j)) .ne. 0. ) ) then
                           snap = 0 !turn snapping off for tolerances
                           tola = abs(ftola(pltpage(i,j)))
                           tolp = abs(ftolp(pltpage(i,j)))
                           call flt_plot(luid+i+plt_offset,frecbuff, & 
                                npts,xp,yp,ymap(pltpage(i,j)),7,nfile+1, & 
                                ig,grids,ymin,ymax,xmin,xmax,idelx,snap, & 
                                snapline,tola,tolp, xshft, xgain,ylim)
                           tola = -abs(ftola(pltpage(i,j)))
                           tolp = -abs(ftolp(pltpage(i,j)))
                           call flt_plot(luid+i+plt_offset,frecbuff, & 
                                npts,xp,yp,ymap(pltpage(i,j)),7,nfile+1, & 
                                ig,grids,ymin,ymax,xmin,xmax,idelx,snap, & 
                                snapline,tola,tolp, xshft, xgain,ylim)
                        endif
! *   Find targets if specified acd,sim,man,pom only
                        if (fytarvar(1) .gt. 0 .and. ifile .le. 4) then
                           do l=1,fnytar
                              if ( fytarvar(l) .eq. pltpage(i,j) ) then
                                 call anal_target(frecbuff,npts,xp,yp,      & 
                                  xtary(l),fytarval(l),1,fytarm(l),1,tfnd,ip,xshft,xgain,xmax,xmin)
                                 if ( tfnd ) then
                                    call ps_draw_x(luid+i+plt_offset,j, & 
                                         xtary(l),fytarval(l),ifile)
                                 endif
                              endif
                           enddo
                        endif
                        if (fxtarvar(1) .gt. 0 .and. ifile .le. 4) then
                           do l=1,fnxtar
                              if ( fxtarvar(l) .eq. pltpage(i,j) ) then
                                 call anal_target(frecbuff,npts,xp,yp,      & 
                                      fxtarval(l),ty,1,fxtarm(l),0,tfnd,ip,xshft,xgain,xmax,xmin)
                                 if ( tfnd ) then
                                    call ps_draw_x(luid+i+plt_offset,j, & 
                                         fxtarval(l),ty,ifile)
                                 endif
                              endif
                           enddo
                        endif
! *   Find highlight points                     
                        if (fhilite(pltpage(i,j)) .and. ifile.le.4) then
                           do l=1,fnxtar
                              call anal_target(frecbuff,npts,xp,yp,      & 
                                   fxtarval(l),ty,1,0,0,tfnd,ip,xshft,xgain,xmax,xmin)
                              if ( tfnd ) then
                                 call ps_draw_x(luid+i+plt_offset,j, & 
                                      fxtarval(l),ty,ifile)
                              endif
                           enddo
                           do l=1,fnytar
                              call anal_target(frecbuff,npts,xp,yp,      & 
                                   xtary(l),ty,1,0,0,tfnd,ip,xshft,xgain,xmax,xmin)
                              if ( tfnd ) then
                                 call ps_draw_x(luid+i+plt_offset,j, & 
                                      xtary(l),ty,ifile)
                              endif
                           enddo
                        endif

                        ig = ig + grids

                     endif      !if variable for grid
                  enddo         ! plot grids
!     Write X axis labels last but only once

                  call ps_do_xaxis(luid+i+plt_offset, & 
                       xmap(xidx),xmax,xmin,idelx,nfile,ifile)
               enddo            ! plot pages
            endif               !if terr

         endif                  ! if dofile != blank
      enddo                     ! master file loop

! * Restore sim data to original form if it was shifted
      if ( replot .and. fxplotshft .ne. 0 ) then !shift time data
         do i=1,frecframe
            frecbuff(i) = frecbuff(i) - fxplotshft
         enddo
      endif

      close ( lu81 ) !ftpages.dat 

      if ( err ) then
         do i=1,npsfile
            if ( fpsopen(i) )  close(luid+i)
            fpsopen(i) = .false.
         enddo
         frecval = 0  !Reset so next test will work
         return
      endif

! ****************************************************************************
!     Create final postscript file - plot_testnum.ps
! ****************************************************************************

!     Create comment header
      ln = lrbl(plotfile)

      open(lu83,FILE=plotfile,IOSTAT=is)
      if ( is .ne. 0 ) then !error opening plotfile
         fcplot = .false.
         fcprtplot = .false.
         message = module//': Unable to open plot file '//plotfile(:ln)//''C
		 write(*,*) message(:rlan(message))
      else
         write(lu83,'(A)') '%!PS-Adobe-3.0'
         write(lu83,'(A)') '%%Creator: '//username(:lrbl(username))
         write(lu83,'(A)') '%%Title: '//ftestname(:lrbl(ftestname))
         write(lu83,'(A)') '%%CreationDate: '//chdate//' '//chtime
         write(lu83,'(A)') '%%Pages: 10 '
         
         call pathfile(message,fpath,'tg_header_1.2.ps')
         open(UNIT=lu84,FILE=message,STATUS='OLD',IOSTAT=is)

         if ( is .ne. 0 ) then
            message=module//': Unable to open header file'//message(:lrbl(message))//''C
			write(*,*) message(:rlan(message))
            fcplot    = .false.
            fcprtplot = .false.
         else
            read(lu84,10,IOSTAT=is) inline
            do while ( is .eq. 0 )                 !Echo tg_header to output file
               write(lu83,10) inline(:rlan(inline))
               read(lu84,10,IOSTAT=is) inline
            enddo
            close(lu84) !tg_header.ps

            do i=1,npsfile	
!               if ( fpsopen(i) .and. (fcplot .or. fcprtplot) ) then
               if ( fpsopen(i) ) then
                  write(luid+i,*) 'showpage'
                  close(luid+i)
                  fpsopen(i) = .false.
                  
                  open(UNIT=lu84,FILE=psfile(i),IOSTAT=is)
                  if ( is .ne. 0 ) then
                     fcplot = .false.
                     fcprtplot = .false.
                     message='Unable to open temp plot file'//psfile(i)(:lrbl(psfile(i)))//''C
                  else
                     read(lu84,10,IOSTAT=is) inline
                     do while ( is .eq. 0 )                 !Echo psfile(i) to plot_####.ps
                        write(lu83,10) inline(:rlan(inline))
                        read(lu84,10,IOSTAT=is) inline
                     enddo
                     close(lu84) !psfile(i)
                     call del_file(psfile(i))
                  endif
               endif
            enddo
!        Put end of file character
            write(lu83,10) '%%EOF'
         endif  !is tg_header ok

		endif	
      close(lu83)


	  !     Move output postscript file plot_testnum.ps to in directory
	  call itoc(testnum,message)
      message = 'start /min D:\data\acro.bat plot_'//message(:lrbl(message))//' '
	  call system(message)
      
      

      !call start_ghostview(plotfile)

      fcplot = .false.
      frecval = 0   !reset the recording flag now done with cycle
      fcpbctr = 9   !Exit done with batch

      return

 10	format(a)      


      end

! *******************************************************************

