!  ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : Generic
!    JOB             : Generic
!    DEPARTMENT      : D61 Flight Dynamics
!    MODULE NAME     : flt_interface.f
!    DESCRIPTION     : System Interface utilities
!    PACKAGE         : flt
!    RATE            : N/A
!    ORIGINATOR      : Mike Saladin
!    DATE            : 03/2/00
!    ENGINEER        : N/A
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               Phone: (918) 259-4000
!               Fax:   (918) 251-5597
! 
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! ****************************************************************************
!

! This file contains a number of interface routines for the FLT utility.  These
! routines interface with the system to provide such functions as renamining 
! files or deleting files.
!
! Version:  DIGITAL FORTRAN 95 for the PC
! Date:     3/23/00
!


	subroutine rename_file(oldfile,newfile,error)

	!USE DFLIB
	USE DFPORT
	implicit none

	character*(*)    oldfile     !Old file name
	character*(*)    newfile     !New file name

	logical*4        error       !Error executine command
	integer*4        istat       !Status



!	error = renamefileqq(oldfile,newfile)
    istat = rename(oldfile,newfile)
 
 	if ( istat .eq. 0 ) then
		error = .false.
	else
		error = .true.
	endif

	return
	end


	subroutine del_file(file)

	USE DFLIB

	implicit none

	character*(*)    file        !file name

	logical*4        error       !Error executine command

	error = delfilesqq(file)


	return
	end


	subroutine print_file(file)

	implicit none

	character*(*)  file

	character*128  message

	integer*4      ln

	integer*4      lrbl           !Returns first space from the left


	ln = lrbl(file)

	message = 'start D:\temp\prfile32.exe /q /n:flt '//file(:ln)
	call system(message)

!   This is a kludge to keep the files queued to the printer in the right order
!   It may be a result of using the prfile program

	call sleep(1)


	return

	end


	subroutine start_ghostview(file)

	implicit none

	character*(*)  file

	character*128  message
 character*15	module /'flt_interface  '/ !Module name
	integer*4      ln

	integer*4      lrbl           !Returns first space from the left

        message = 'starting Ghostview'
        call ftn_logmsg_info(module,message)
	ln = lrbl(file)
	message = 'start C:\gstools\gsview\gsview32.exe /e '//file(:ln)

	call system(message)
    call ftn_logmsg_info(module,message)
	return

	end

	

	subroutine get_directories(dir,num)

	USE DFLIB

	implicit none


	character*132   dir(10)      !List of directories

	integer*4       num          !Number of found directories


!   Locals

	character*132   files        !Files to look for
	
	integer*4       handle       !Return handle from call
	integer*4       result       !Length of return

	type (FILE$INFO) info


	include "flt_plot.inc"

	handle = FILE$FIRST
	result = 1
	num    = 0

	call pathfile(files,fpath,'eqtg\*')

	do while ( result .gt. 0 .and. num .lt. 10 ) 
		result = GETFILEINFOQQ(files, info, handle)

		if ( result .gt. 0 .and. handle .ne. FILE$LAST) then
			if ((info.permit .AND. FILE$DIR) .NE. 0) then
				if ( result .gt. 2 .or. index(info.name,'.') .eq. 0 ) then
					num = num + 1
					dir(num) = info.name
				endif
			endif
		endif
	enddo

	return
	end


	subroutine make_dir(dir,result)

	USE DFLIB

	implicit none

	character*132  dir          !Directory to make

	logical*4      result       !Result of the make

	result = MAKEDIRQQ(dir)

	return
	end


	subroutine copy_file(infile,outfile,error)

	implicit none

	character*(*)   infile     !Input file name
	character*(*)   outfile    !Input file name

	logical*4       error      !Error flag

	character*256   line       !Read line

	integer*4       lu99 /99/  !Input file
	integer*4       lu98 /98/  !Output file

	logical*4       fexist     !File exists

	integer*4       ist        !Return status flag

!   Externals
	integer*4       rlan

	error = .false.

	inquire (FILE=infile,EXIST=fexist)
	if ( .not. fexist ) then
		error = .true.
		return
	endif


	line = 'copy  '//infile(:rlan(infile))//' '//outfile(:rlan(outfile))//' > C:\temp\null'
	call system(line)
!  	open(UNIT=lu99,FILE=infile,IOSTAT=ist) 
! 	if ( ist .ne. 0 ) then
! 		error = .true.
! 		return
! 	endif

! 	open(UNIT=lu98,FILE=outfile,IOSTAT=ist) 
! 	if ( ist .ne. 0 ) then
! 		error = .true.
! 		return
! 	endif


! 	do while ( ist .eq. 0 ) 
! 		read(lu99,10,IOSTAT=ist) line
! 		if ( ist .eq. 0 ) write(lu98,10) line(:rlan(line))
! 	enddo 

! 	close(lu99)
! 	close(lu98)

	return

10	format(A)
	end



	subroutine is_dir(dir,exist)

	USE DFLIB

	implicit none


	character*132   dir         !List of directories

	logical*4       exist       !Number of found directories


!   Locals


	integer*4       handle       !Return handle from call
	integer*4       result       !Length of return

	type (FILE$INFO) info


	exist = .false.
	handle = FILE$FIRST

	result = GETFILEINFOQQ(dir, info, handle)

	if ( result .gt. 0 ) then
		if ((info.permit .AND. FILE$DIR) .NE. 0) then
			exist = .true.
		endif
	endif

	return

	end
