! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : JPATS
!    JOB             : ALL
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : FAT_WRITEFILE
!    DESCRIPTION     : Writes test interface files for the host
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 5-Apr-00
!    ENGINEERS       : Mike Saladin
!    SYSTEM          : Windows

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 2000 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
!
! This module writes out the temp files for the interface to the host.
!
! The first file is the IC file which is two columns.  The first column is 
! the integer index representation of the variable.  The second is the value in
! real format.
!
! The second file is the driver data file.  The first line contains the total
! number of columns of data.  The second line contains the list if integer 
! indices for the variables in csv format.  The remaining lines contain the data
! in csv format.  Each line is a seperate frame of data.
!

	subroutine fat_writefile(ficinval,fatdaddr,fatddata,fatdxsng,fatddim,fatdnum, &
							fatdxind,fatdyind,fatdptr,ficinaddr,ficinnum,error)

	implicit none

!	Argument List

	real*4			ficinval(200)	! values to load into ic address
	real*4			fatddata(1000000)! atd driver data storage array
	real*4			fatdxsng(2,40)	! Drivers X shift and gains

	integer*4		fatdaddr(200)	! Variable xref index for variable to drive
	integer*4		fatddim(40)		! # of data pts per vari in atd
	integer*4		fatdnum			! Number of atd drivers
	integer*4		fatdxind(40)	! Index of x data for each drvr
	integer*4		fatdyind(40)	! Index of y data for each drvr
	integer*4		fatdptr     	! New open slot in fatddata array
	integer*4		ficinaddr(200)	! addresses to load icval into
	integer*4		ficinnum		! number of ic's to input

	logical*4		error			! Error flag

!	Locals	

	integer*4		i,j,k			!Loop counters
	integer*4		lu50  /50/		!Index for output file
	integer*4		lu60  /60/		!Index for output file
	integer*4		ist				!IOSTAT flag


	character*256	message			!Message line
	character*132	outfile			!Output file name
	character*13	module /'fat_writefile'/ !Module name
!	Externals

	integer*4		lrbl			!Returns first blank from left


	include "flt_plot.inc"

!  JPATS NFS problem therefore create host output files from ios here and
!  immediately close them to be reopened on host

	call pathfile(outfile,'d:\Host_Data','icout.dat')

	call del_file(outfile)

	open(UNIT=lu50,FILE=outfile,IOSTAT=ist)

	if ( ist .ne. 0 ) then
		error = .true.
		message = 'Unable to Open: '//outfile(:lrbl(outfile))
		call ftn_logmsg_err(module,message)
		message = 'While trying to run test '//ftestname(:lrbl(ftestname))
		call ftn_logmsg_err(module,message)
		return
	endif
	close(lu50)
	message = 'finished writing icout.dat '
    call ftn_logmsg_info('fat_writefile',message)

	call pathfile(outfile,'d:\Host_Data','histout.csv')
	message = 'called pathfile  histout'
    call ftn_logmsg_info('fat_writefile',message)


	call del_file(outfile)
		message = 'called del_file  histout'
    call ftn_logmsg_info('fat_writefile',message)


	open(UNIT=lu60,FILE=outfile,IOSTAT=ist)

	if ( ist .ne. 0 ) then
		error = .true.
		message = 'Unable to Open: '//outfile(:lrbl(outfile))
		call ftn_logmsg_err(module,message)
		message = 'While trying to run test '//ftestname(:lrbl(ftestname))
		call ftn_logmsg_err(module,message)
		return
	endif
	close(lu60)

    call pathfile(outfile,'d:\Host_Data','histin.csv')
	call del_file(outfile)
    
	if ( fatdnum .gt. 0 ) then

		j = fatdxind(1)

		open(UNIT=lu50,FILE=outfile,IOSTAT=ist)

		if ( ist .ne. 0 ) then
			error = .true.
			message = 'Unable to Open: '//outfile(:lrbl(outfile))
			call ftn_logmsg_err(module,message)
			message = 'While trying to run test '//ftestname(:lrbl(ftestname))
			call ftn_logmsg_err(module,message)
			return
		endif

	!	Write number of columns in file on first line
		write(lu50,20,IOSTAT=ist) fatdnum+1   ! num dependent + Independent
		message=' number of columns '
                  call ftn_logmsg_info(module,message)
		write(lu50,30,IOSTAT=ist) 1		!Independent is always 1
		do i=1, fatdnum - 1
			write(lu50,30,IOSTAT=ist) fatdaddr(i)
			message=' writing fatdnum '
                  call ftn_logmsg_info(module,message)
		enddo
		write(lu50,40,IOSTAT=ist) fatdaddr(fatdnum)		! write without comma for ADA
		do i=0,fatddim(1)-1
			write(lu50,70,IOSTAT=ist) fatddata(fatdxind(1)+i)
      		do j=1, fatdnum - 1
				  write(lu50,60,IOSTAT=ist) fatddata(fatdyind(j)+i)
			enddo
			write(lu50,80,IOSTAT=ist) fatddata(fatdyind(fatdnum)+i)   ! write without comma for ADA
         enddo
		close(lu50)
	endif
!
!	Write the IC file 		

	call pathfile(outfile,'d:\Host_Data','testic.dat')

	call del_file(outfile)

	open(UNIT=lu50,FILE=outfile,IOSTAT=ist)

	if ( ist .ne. 0 ) then
		error = .true.
		message = 'Unable to Open: '//outfile(:lrbl(outfile))
		call ftn_logmsg_err(module,message)
		message = 'While trying to run test '//ftestname(:lrbl(ftestname))
		call ftn_logmsg_err(module,message)
		return
	endif

	write(lu50,20,IOSTAT=ist) ficinnum
	do i=1,ficinnum
		write(lu50,20,IOSTAT=ist) ficinaddr(i)
		write(lu50,50,IOSTAT=ist) ficinval(i)
	enddo
	
	close(lu50)

	return

10	format(A)
20	format(I3)
30	format(i3,','\)
40	format(i3)
!50	format(g10.4)
50  format(e12.5)      ! was e 
60	format(e12.5,','\)  ! was e
70	format(e12.5,','\)   ! was g
80	format(e12.5)       ! was e
90	format(g12.5)     ! was g
	end


