! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_readtest
!    DESCRIPTION     : Reads the test definition file and loads globals variables
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! ****************************************************************************
!--> REVISION BEGIN
!                            Revision History

! $Id: fat_readtest.f,v 1.6 2000/03/13 21:13:25 saladinm Exp $
! $Log: fat_readtest.f,v $
! Revision 1.6  2000/03/13 21:13:25  saladinm
! DR/MACAR:     None
! Problem:      Needed a way to bias sync'd variables.
! Conclusion:   Normal shift and gains no use when used with a sync.
! Resolution:   Added a "bias = " term to the task 5/6 drivers section.
! Dependencies: fnk113.f, flt_read.inc
! Engineer:     Mike Saladin

! Revision 1.5  2000/02/14 15:59:54  saladinm
! DR/MACAR:     None
! Problem:      Confusion over setting labels for task 6 driving.
! Conclusion:   Had to specify fattask = 6.  This lead to define statements
!               of fattask = 5 or fattask = 6.
! Resolution:   Made it so that fattask > 5 or >= 5 to drive labels in rask
!               6.
! Dependencies: None
! Engineer:     Mike Saladin


! Revision 1.4  1999/11/15 08:13:45  saladinm
! DR/MACAR:     none
! Problem:      Extra labels on autotest page show previous values.
! Conclusion:   Arrays only being filled to point were new test has data.
! Resolution:   Fill all non-used slots with 0's.
! Dependencies: None
! Engineer:     Mike Saladin

! Revision 1.3  1999/10/05 22:24:50  saladinm
! Added labels and code to support new autotest IOS page.

! Revision 1.2  1999/08/25 13:32:56  saladinm
! Fixed for build

! Revision 1.1  1999/08/25 02:26:00  saladinm
! Initial revision

! Revision 1.8  1999/03/02 21:44:24  saladinm
! Fixed error with shift and gains for atd data.

! Revision 1.1  1999/03/02 21:29:20  saladinm
! Initial revision

! Revision 1.7  1999/02/18 13:50:18  saladinm
! Added check to verify all drivers found since flt_read_data will now not
! return an error for this case.

! Revision 1.6  1999/02/12 16:04:35  saladinm
! Index for idx loop too big.

! Revision 1.5  1999/02/10 16:37:03  saladinm
! Added slope option to x&y target analysis.

! Revision 1.4  1999/02/09 17:30:06  saladinm
! Added special handling of dirvers in task 6.

! Revision 1.3  1999/02/05 22:49:48  saladinm
! Added ability to set naptdmd and nrwydmd.

! Revision 1.2  1999/02/04 18:08:40  saladinm
! Properly handle case when test is not found.

! Revision 1.1  1999/02/03 21:54:41  saladinm
! Initial revision

! Revision 1.2  1999/01/05 17:17:07  saladinm
! Added fpowervar and fplavar and changed frecrate from def to ref.

! Revision 1.1  1998/12/16 21:29:19  saladinm
! Initial revision


! Revision 1.1  1992/09/02  20:58:13  saladinm
! Initial revision

!--> REVISION END
! ****************************************************************************

! ****************************************************************************
!.mp  .TH fat_readtest.f l FSI
!.mp  .SH NAME
!.mp    fat_readtest.f  This module reads the test definition files.
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp  FSI D61FLT Library autotest.a
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp  This module reads the autotest test definition file for a given test.
!.mp
!.mp  The main inputs for this test are the test name and file path.
!.mp
!.mp  The outputs would be the data read in from the test definition file.
!.mp  These would include:
!.mp      Driver information
!.mp      Plot definition information (parameters scales - plot setups)
!.mp      IC input variables and values.
!.mp      IC output variable list.
!.mp      ACD,POM,ATD shifts and gains 
!.mp
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************


	subroutine fat_readtest(fatcomment,faticlab, fatdaddr,              & 
				fatname,   fattitle,  fairdmd,   fatddim,   fatdnum,    & 
				fatdxind,  fatdyind,  fattest,   fbetavar,  fdampvar,   & 
				ficinaddr, ficinnum,  ficinop,   ficord,    ficotaddr,  & 
				ficotnum,  ficoutype, fictype,   fininrt,   fnumgrid,   & 
				fnxtar,    fnytar,    fphivar,   fplavar,   fpowervar,  & 
				frundmd,   ft5addr,   ft5con,    fcfdvar,   frecnumb,    & 
				ft5conaddr,ft5cond,   ft5contype,ft5type,   fxtarm,    fxtarvar,   & 
				fxvarnum,  fymaptox,  fytarm,    fytarvar,  fyvarnum,   & 
				fatddata,  fatdxsng,  faticac,   faticsim,  fbetast,    & 
				fdampst,   ficinval,  fphist,    fatdptr,				&
				ft5conval, ft5val,    ftola,     fcfdst,        & 
				ftolp,     fxscale,   fxsng,     fxtarval,  fyscale,    & 
				fysng,     fytarval,  fcpmess,   fhilite,   fsnapacd,   & 
				fsnaplot,  fsnappom,  ft5ovrdt6, fylimit)




	implicit none

!--> Argument List

	integer*1		fatcomment(132)	! Test Comment for IOS
	integer*1		faticlab(10000)	! IC labels for IOS
	integer*1		fatname(40)		! Test name for IOS
	integer*1		fattitle(132)	! Test Title for IOS

	integer*4		fairdmd			! Demanded autotest airport
	integer*4		fatdaddr(40)    ! Index of variable to drive 
	integer*4		fatddim(40)		! # of data pts per vari in atd
	integer*4		fatdnum			! Number of atd drivers
	integer*4		fatdxind(40)	! Index of x data for each drvr
	integer*4		fatdyind(40)	! Index of y data for each drvr
	integer*4		fatdptr     	! New open slot in fatddata array
	integer*4		fattest			! autotest test number
	integer*4		fbetavar		! Y var index for peak analysis beta
	integer*4		fcfdvar			! Y var index for CFD analysis
	integer*4		fdampvar		! Y var index for damping analysis
	integer*4		ficinaddr(200)	! addresses to load icval into
	integer*4		ficinnum		! number of ic's to input
	integer*4		ficinop(200)		! I/O status if IC inputs
	integer*4		ficord(200)		! Index for ic order
	integer*4		ficotaddr(200)	! address of IC output vars
	integer*4		ficotnum		! Number of vars to output as ic
	integer*4		ficoutype(200)	! type of ic out vars
	integer*4		fictype(200)		! var type (real int log) of ics
	integer*4		fininrt			! init flag 1=read 2=ok
	integer*4		fnumgrid(36)	! Number of grids for each y
	integer*4		fnxtar			! Number of x targets
	integer*4		fnytar			! Number of y targets
	integer*4		fphivar			! Y var index for peak analysis phi
	integer*4		fplavar			! Y variable index for analysis PLA
	integer*4		fpowervar		! Y variable index for analysis N1
	integer*4		frecnumb		! Number of recorded/plotted variables
	integer*4		frundmd			! Demanded autotest runway
	integer*4		ft5addr(30)		! addr of vars to set in task 5
	integer*4		ft5con(30)		! type of task 5 conditionals
	integer*4		ft5conaddr(30)	! Address for task 5 conditions
	integer*4		ft5cond			! number of task 5 conditionals
	integer*4		ft5contype(30)	! Type for task 5 conditions
	integer*4		ft5type(30)		! var type (real int log) of t5
	integer*4		fxtarm(10)		! desired slope of xtarget
	integer*4		fxtarvar(10)	! X target plot index
	integer*4		fxvarnum		! Number of x variables for plot
	integer*4		fymaptox(36)	! For each Y which X to use
	integer*4		fytarm(10)		! desired slope of ytarget
	integer*4		fytarvar(10)	! Y target plot index
	integer*4		fyvarnum		! Number of y variables plotted

	real*4			fatddata(100000)! atd driver data storage array
	real*4			fatdxsng(2,40)	! Drivers X shift and gains
	real*4			faticac(200)		! A/C IC data fot IOS
	real*4			faticsim(200)	! Sim IC data for IOS
	real*4			fbetast			! Start time for peak analysis beta
	real*4			fcfdst			! Start time for CFD analysis
	real*4			fdampst			! Start time for damping analysis
	real*4			ficinval(200)	! values to load into ic address
	real*4			fphist			! Start time for peak analysis phi
	real*4			frecrate		! recording rate in hz
	real*4			frecstart		! recording start time
	real*4			ft5conval(30)	! Task 5 conditional values
	real*4			ft5val(30)		! Task 5 values to set t5addr to
	real*4			ftola(36)		! Absolute tolerance value
	real*4			ftolp(36)		! Percent tolerance value
	real*4			fxscale(2,6)	! X axis scales (1) min (2) max
	real*4			fxsng(2,2,42)	! acd & pom plot x shifts/gains
	real*4			fxtarval(10)	! X target value for high lighting
	real*4			fyscale(2,36)	! Y axis scales (1) min (2) max
	real*4			fysng(2,2,42)	! acd & pom plot y shifts/gains
	real*4			fytarval(10)	! Y target value for high lighting

	logical*4		fcpmess			! Display messages
	logical*4		fhilite(36)		! Highlight these variables
	logical*4		fsnapacd(36)	! Snap shot flag by variable ACD
	logical*4		fsnaplot		! Whole plot Snap shot flag 
	logical*4		fsnappom(36)	! Snap shot flag by variable POM
	logical*4		ft5ovrdt6(30)	! Allow setting in task 6
	logical*4		fylimit(36)		! Limits plots to Y axis

!--> GLOBAL END

      include "flt_plot.inc"

!--> LOCAL BEGIN

      logical*4     terr                !temporary error flag
      logical*4     cont                !flag to signal all var titles found
      logical*4     fndit               !test found
      logical*4     ch                  !temp logical
      logical*4     firstpass /.true./  !First pass flag
      logical*4     mantest             !Dummy
      logical*4     false     /.false./ !False variable

      character*64  tatdvar(40)         !temp for atd driver variable name
      character*64  vararr(42)          !temp array of atd var names 
      character*40  ttitle              !temp title of run
      character*36  labl                !Temp labl for ios/autotest interface
      character*36  unit                !Units part of label
      character*8   tsource(40)         !temp suffix for atd driver files
      character*4   crun                !
      character*4   cair                !

      integer*4     i,j,k,l,ll          !Counters
      integer*4     idx(40)             !Indexing array for atd variables
      integer*4     locidx(40)          !Temp version of idx
      integer*4     pointer             !Start point in fatddata for new data
      integer*4     psnap               !Pointer of fsnap in file N/A Here
      integer*4     runway              !
      integer*4     airport             !

      equivalence(runway,crun)
      equivalence(airport,cair) 

      real*4        xsng(2,40)          !X Shifts and gains for drivers
      real*4        ysng(2,40)          !Y Shift and gains for drivers
      real*4        xshift(4)           !X axis default shifts
      real*4        xgain(4)            !X axis default gains
      real          icdata(100)          !temp for looking up ics
	  character*10  datapath /'d:\data\'/
      character*13	module /'fat_readtest '/ !Module name
! * Include the variables need by the flt_read.inc file
      include "flt_read_vars.inc"

    call load_jpats_var()
! * Convert test number to test name by reading test_index.dat file
      call pathfile(filename,datapath,'test_index.dat')
      inquire(FILE=filename,EXIST=exist)
      if ( .not. exist ) then
         message='Test index file does not exist '// & 
                  filename(:lrbl(filename))
         call ftn_logmsg_err("flt_readtest",message(:rlan(message)))
         fininrt = 3
         return
      endif

      open(lu27,FILE=filename,IOSTAT=istatus)
      if ( istatus .ne. 0 ) then
         message = 'UNABLE TO OPEN '//filename(:lrbl(filename))
         call ftn_logmsg_err("flt_readtest",message)
         call perror(message1)
         write(message,11) 'Status #',istatus,':',message1
         call ftn_logmsg_err("flt_readtest",message)
         fininrt = 3
         return
      endif

      istatus = 0
      fndit = .false.
      ftestname= ' '
      rewind(lu27)
       do while ( istatus .eq. 0 )
         read(lu27,*,IOSTAT=istatus) itest,cname
         if ( itest .eq. fattest ) then          !Found desired test number
            ftestname = cname(:lrbl(cname))
            istatus = 1
            fndit = .true.
         endif
      enddo
         message=' test index file read '
                  call ftn_logmsg_info(module,message)
      close(lu27) !Close test_index.dat file done reading for this test
message=' test index file closed '
                  call ftn_logmsg_info(module,message)
      if ( fattest .eq. 0 .or. ftestname .eq. ' ' .or. .not. fndit) then
         write(message,11) & 
              'Test Number: ',fattest,' not found in ','test_index.dat'
         call ftn_logmsg_err("flt_readtest",message)
         fininrt = 3
         return
      endif         

      frundmd = 0
      fairdmd = 0
! * This include file does all of the reading of the test definition file

 !     include "flt_read.inc"
!  begin flt_read.inc

! * Verify if test definition file exists and open it for reading


      filename = ""

      filename = ftestname(:lrbl(ftestname))//'.tdf'
      call pathfile(testfile,datapath,filename(:lrbl(filename)))

      inquire(FILE=testfile,EXIST=exist)
      if ( .not. exist ) then
         message='Test file does not exist '//testfile(:lrbl(testfile))
         call ftn_logmsg_err("flt_read.inc",message(:rlan(message)))
         fininrt = 3
         return
      endif

      open(lu19,FILE=testfile,IOSTAT=istatus)
      if ( istatus .ne. 0 ) then
         message = 'UNABLE TO OPEN '//testfile(:lrbl(testfile))
         call ftn_logmsg_err("flt_read.inc",message)
         call perror(message1)
         write(message,'(A,I5,A,A)') 'Status #',istatus,':',message1
         call ftn_logmsg_err("flt_read.inc",message)
         fininrt = 3
         return
      endif


! * Initialize the storage variables to the defaults allowing file read to 
!   overwrite everything.

      comment = blank
      title   = blank
      type    = 'plot'

      acd   = .false.
      atd   = .false.
      defic = .false.
      drv   = .false.
      err   = .false.
      plot  = .false.
      pom   = .false.
      task3 = .false.
      task5 = .false.
      text  = .false.

      plavar    = 0
      powervar  = 0
      betavar   = 0
      dampvar   = 0
      ncond     = 0
      nic       = 0
      nplot     = 0
      ntask3    = 0
      ny        = 0
      phivar    = 0
      recrate   = 200.
      nyt       = 0
      nxt       = 0
      beta_st   = 0.
      damp_st   = 0.
      phi_st    = 0.
      cfd_st    = 0.
      totgrids  = 0

      do ii=1,10
         ytarval(ii) = 0.
         ytarvar(ii) = 0
         ytarm(ii)   = 0  !No specified slope
         xtarval(ii) = 0.
         xtarvar(ii) = 0
         xtarm(ii)   = 0  !No specified slope
      enddo           


      do ii=1,4
         ncnt(ii) = 0
         do is=1,maxgrid
            var(ii,is)  = blank(:80)
            ysh(ii,is)  = 0.0         !Default
            ygn(ii,is)  = 1.0         !Default
            xsh(ii,is)  = 0.0         !Default
            xgn(ii,is)  = 1.0         !Default
            if ( ii .eq. 1 ) then
               yvar(is)   = blank(:80)
               snap(is)   = blank(:8)
               ynplot(is) = 1
               ngrid(is)  = 1           !Default
               ymin(is)   = 0.
               ymax(is)   = 100.
               hilite(is) = .false.
               tol_a(is)  = 0.0
               tol_p(is)  = 0.0
               ylimit(is) = .false.
            endif
         enddo
      enddo

      do ii=1,6
         xmin(ii) = 0
         xmax(ii) = 100
      enddo

      do ii=1,ndimt5
         do is=1,ndimcon
            t5var(is,ii)    = blank(:80)
            t5val(is,ii)    = blank(:80)
            t5source(is,ii) = 'acd'       !Default location of drivers
            t5sync(is,ii)   = blank(:80)
            t5bias(is,ii)   = 0.0
            if ( ii .le. 2 ) then
               convar(ii,is)        = blank(:80)
               con(ii,is)           = '  '
               icvar(is+(ii-1)*30)  = blank(:80)
               icval(is+(ii-1)*30)  = blank(:20)
               if ( ii .eq. 1 ) then
                  ntask5(is) = 0
                  t3var(is) = blank(:80)
                  t3val(is) = blank(:80)
               endif
            endif
         enddo
      enddo


! * Start reading test definition file one line at a time      

      read(lu19,'(a)',IOSTAT=istatus) line
      nl = 1 
      do while ( istatus .eq. 0 )  
         ii = rlan(line)
         if ( line(1:1) .ne. '#' .and. ii .gt. 0) then   ! exclude comments
            lowline = line
            call lower(lowline,132)          ! make input line lower case
            it  = index(lowline,'title')
            ic  = index(lowline,'comment')
            is  = index(lowline,'start')
            ie  = index(lowline,'end')
            ieq = index(lowline,'=')

!            write(*,*) 'line = ',line(:70)

! *        Read title
            if ( it .gt. 0  .and. ieq .gt. it+5 ) then
               read(line(ieq+1:),'(a)',IOSTAT=istatus) title
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read title'
                  call write_mess(message,line,nl,testfile)
               endif
               title = title(lran(title):) !Remove leading blanks

! *        Read comment
            elseif ( ic .gt. 0  .and. ieq .ge. ic ) then
               read(line(ieq+1:),'(a)',IOSTAT=istatus) comment
               comment = comment(lran(comment):) !remove leading blanks
!               write(*,*) 'comment = ',comment(:rlan(comment))
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read comment'
                  call write_mess(message,line,nl,testfile)
               endif

! *        End of a section reached easiest to just reset all
            elseif ( ie .gt. 0  .and. ie .lt. 5 ) then       
               task3 = .false.
               task5 = .false.
               plot  = .false.
               acd   = .false.
               atd   = .false.
               pom   = .false.
               drv   = .false.
               text  = .false.
               defic = .false.

! *        Read Shifts and Gains
            elseif ( acd .or. atd .or. pom .or. drv ) then  
               ncnt(idnum) = ncnt(idnum) + 1
               ii = ncnt(idnum)
               read(lowline,*,IOSTAT=istatus) var(idnum,ii), & 
                                ysh(idnum,ii),ygn(idnum,ii), & 
                                xsh(idnum,ii), xgn(idnum,ii)
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read shift and gain line'
                  call write_mess(message,line,nl,testfile)
               endif

! *        Read Plot Information
            elseif ( plot ) then !look for x or y variable definition
               is = index(lowline,'x')
               it = index(lowline,'y')

! *           Read X = variable line including scales, type & rate
               if ( is .gt. 0 .and. ieq .gt. is ) then  
                  nplot = nplot + 1           ! Increment to next page
                  read(lowline(ieq+1:),*,IOSTAT=istatus) xvar(nplot)
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to read X variable'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ln = lrbl(xvar(nplot))
                  ie = index(lowline,' '//xvar(nplot)(:ln)//' ') + ln

                  is = index(lowline(ie:),'scale') + ie
                  it = index(lowline(is+1:),'=') + is
                  read(lowline(it+1:),*,IOSTAT=istatus)  & 
                      xmin(nplot),to,xmax(nplot)
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to parse X scales'
                     call write_mess(message,line,nl,testfile)
                  endif

                  is = index(lowline(ie:),'type') 
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) type
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot type'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

                  is  = index(lowline(ie:),'rate')
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) recrate
!                     write(*,*) 'recrate = ',recrate
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot rate'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

! *           Find Y = variable line
               elseif( it  .gt. 0 .and. ieq .gt. it ) then !found Y = 
                  if ( ny + 1 .gt. maxgrid ) then
                     err = .true.
                     message='Too many plot variables defined'
                     call write_mess(message,line,nl,testfile)
                  else
                     ny = ny + 1
                  endif

                  ynplot(ny) = nplot
                  read(lowline(ieq+1:),*,IOSTAT=istatus) yvar(ny) ! read y variable
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to read Y variable'
                     call write_mess(message,line,nl,testfile)
                  endif

                  ln = lrbl(yvar(ny))
                  ie = index(lowline,' '//yvar(ny)(:ln)//' ') + ln

                  is = index(lowline(ie+1:),'scale') + ie
                  it = index(lowline(is:),'=') + is

                  read(lowline(it:),*,IOSTAT=istatus)  & 
                      ymin(ny),to,ymax(ny)       ! read scales
                  if ( istatus .ne. 0 ) then     ! Error reading this line
                     err = .true.
                     message='Unable to parse Y scales'
                     call write_mess(message,line,nl,testfile)
                  endif

                  is = index(lowline(ie:),'grid')
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) ngrid(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to parse grids'
                     endif
                  endif

                  totgrids = totgrids + ngrid(ny)

                  if ( totgrids .gt. maxgrid ) then
                     err = .true.
                     message='Too many plot variables/grids defined'
                     call write_mess(message,line,nl,testfile)
                  endif


                  is  = index(lowline(ie:),'snap') 
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) snap(ny)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot snap flag'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif


                  it  = ie
                  is  = index(lowline(it:),'ytarget')
                  do while ( is .gt. 0 .and. nyt .lt. 10 & 
                             .and. istatus .eq. 0)
                     ieq = index(lowline(is+it:),'=') + is + it
                     nyt = nyt + 1
                     read(lowline(ieq:),*,IOSTAT=istatus) ytarval(nyt)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse ytarget'
                        call write_mess(message,line,nl,testfile)
                     endif
                     ytarvar(nyt) = ny

                     it  = ieq    !start looking for next ytarget after '='
                     is  = index(lowline(it:),'slope')
                     ii  = index(lowline(it:),'ytarget')
                     if ( ( is .gt. 0 ) .and.  & 
                          ( ii .eq. 0 .or. is .lt. ii) ) then !slope fnd
                        ieq = index(lowline(it+is:),'=') + is + it
                        read(lowline(ieq:),*,IOSTAT=istatus) ytarm(nyt)
                        if ( istatus .ne. 0 .or.  ytarm(nyt) .lt. 0 & 
                             .or. ytarm(nyt) .gt. 2 ) then ! Error reading this line
                           err = .true.
                           if  ( istatus .eq. 0 ) then
                              message='Invalid slope specified'
                           else
                              message='Unable to parse ytarget slope'
                           endif
                           call write_mess(message,line,nl,testfile)
                        endif      
                     endif
                     is  = index(lowline(it:),'ytarget')
                  enddo

                  it  = ie
                  is  = index(lowline(it:),'xtarget')
                  do while ( is .gt. 0 .and. nxt .lt. 10 & 
                             .and. istatus .eq. 0 )
                     ieq = index(lowline(is+it:),'=') + is + it
                     nxt = nxt + 1
                     read(lowline(ieq:),*,IOSTAT=istatus) xtarval(nxt)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse xtarget'
                        call write_mess(message,line,nl,testfile)
                     endif
                     xtarvar(nxt) = ny

                     it  = ieq    !start looking for next xtarget after '='
                     is  = index(lowline(it:),'slope')
                     ii  = index(lowline(it:),'xtarget')
                     if ( ( is .gt. 0 ) .and.  & 
                          ( ii .eq. 0 .or. is .lt. ii) ) then !slope fnd
                        ieq = index(lowline(it+is:),'=') + is + it
                        read(lowline(ieq:),*,IOSTAT=istatus) xtarm(nxt)
                        if ( istatus .ne. 0 .or.  xtarm(nxt) .lt. 0 & 
                             .or. xtarm(nxt) .gt. 2 ) then ! Error reading this line
                           if ( istatus .eq. 0 ) then
                              message = 'Invalid slope specified'
                           else
                              message='Unable to parse xtarget slope'
                           endif
                           err = .true.
                           call write_mess(message,line,nl,testfile)
                        endif      
                     endif
                     is  = index(lowline(it:),'xtarget')

                  enddo

                  is  = index(lowline(ie:),'hili') !hilight or hilite
                  if  ( is .gt. 0 ) then
                     hilite(ny) = .true.
                  endif

                  is  = index(lowline(ie:),'ylimit') !Limit data to y axis
                  if  ( is .gt. 0 ) then
                     ylimit(ny) = .true.
                  endif

                  is  = index(lowline(ie:),'power') !Power parameter
                  if  ( is .gt. 0 ) then
                     powervar = ny
                  endif

                  is  = index(lowline(ie:),'pla') !Pla parameter
                  if  ( is .gt. 0 ) then
                     plavar = ny
                  endif

                  is  = index(lowline(ie:),'cfd_st') !CFD start anlysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) cfd_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read cfd_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     cfdvar = ny
                  endif

                  is  = index(lowline(ie:),'damp_st') !Damp ratio anlysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) damp_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read damp_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     dampvar = ny
                  endif

                  is  = index(lowline(ie:),'beta_st') !Beta analysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) beta_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read beta_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     betavar = ny
                  endif

                  is  = index(lowline(ie:),'phi_st') !Phi analysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) phi_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read phi_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     phivar = ny
                  endif

                  is  = index(lowline(ie:),'tol_a') !Absolute tolerance
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) tol_a(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read absolute tolerance'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

                  is  = index(lowline(ie:),'tol_p') !Percent tolernace
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) tol_p(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read percent tolerance'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif
               endif   ! If Y = variable line

!>          Read ICs in the form var = Number     1
            elseif ( defic ) then
               nic = nic + 1
               read(lowline(:ieq-1),*,IOSTAT=istatus) icvar(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read IC variable name for input'
                  call write_mess(message,line,nl,testfile)
               endif

               read(lowline(ieq+1:),'(a)',IOSTAT=istatus) icval(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read ic variable value'
                  call write_mess(message,line,nl,testfile)
               endif
               icval(nic) = icval(nic)(lran(icval(nic)):)
               icval(nic) = icval(nic)(:lrbl(icval(nic)))

               ii = rlan(lowline)  ! Find occurance of last non blank
               read(lowline(ii-2:),*,IOSTAT=istatus) icout(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read ic output flag'
                  call write_mess(message,line,nl,testfile)
               endif



!>          Read task 3 inputs               
            elseif ( task3 ) then
               ntask3 = ntask3 + 1
               read(lowline(:ieq-1),*,IOSTAT=istatus) t3var(ntask3)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read Task 3 variable'
                  call write_mess(message,line,nl,testfile)
               endif
               read(lowline(ieq+1:),'(a)',IOSTAT=istatus) t3val(ntask3)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read Task 3 value'
                  call write_mess(message,line,nl,testfile)
               endif

!>#
!>#         Read Task 5 information
!>#
            elseif ( task5 ) then
               is = index(lowline,'define')
               if ( is .gt. 0 ) then ! New conditional
                  ncond = ncond + 1
                  it = index(lowline(is:),' ') + is
                  is = lran(lowline(it:)) + it - 1
                  ie = lrbl(lowline(is:)) + is
                  read(lowline(is:ie),*,IOSTAT=istatus) convar(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional variable'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ie = lrbl(convar(1,ncond))
                  is = index(lowline,convar(1,ncond)(:ie)) + ie 
                  read(lowline(is:),*,IOSTAT=istatus) con(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional operator'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ie = lrbl(con(1,ncond))
                  is = index(lowline,con(1,ncond)(:ie)) + ie 
                  read(lowline(is:),'(A)',IOSTAT=istatus) conval(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional value'
                     call write_mess(message,line,nl,testfile)
                  else
                     conval(1,ncond)=conval(1,ncond) & 
                                           (lran(conval(1,ncond)):)
                     conval(1,ncond)=conval(1,ncond) & 
                                           (:lrbl(conval(1,ncond)))
                  endif

!>                Search for second conditional statement
                  ic = index(lowline(is:),' and ') 
                  it = index(lowline(is:),' or ') 
                  conop(ncond) = 0   ! Reset   

                  if ( ic .gt. 0 .or. it .gt. 0 ) then
                     if ( ic .gt. 0 ) then
                        ii = ic + is + 4   !Offset by ' and '
                     else
                        ii = it + is + 3   !Offset by ' or '
                     endif
                     lowline = lowline(ii:)
                     is = lran(lowline) 
                     ie = lrbl(lowline(is:)) + is
                     read(lowline(is:ie),*,IOSTAT=istatus) convar(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional variable'
                        call write_mess(message,line,nl,testfile)
                     endif

                     ie = lrbl(convar(2,ncond))
                     is = index(lowline,convar(2,ncond)(:ie)) + ie 
                     read(lowline(is:),*,IOSTAT=istatus) con(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional operator'
                        call write_mess(message,line,nl,testfile)
                     endif

                     ie = lrbl(con(2,ncond))
                     is = index(lowline,con(2,ncond)(:ie)) + ie 
                     read(lowline(is:),'(A)',IOSTAT=istatus) conval(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional value'
                        call write_mess(message,line,nl,testfile)
                     else
                        conval(2,ncond) = conval(2,ncond) & 
                                          (lran(conval(2,ncond)):)
                        conval(2,ncond) = conval(2,ncond) & 
                                          (:lrbl(conval(2,ncond)))
                     endif

                     if ( ic .gt. 0 ) then
                        conop(ncond) = 1     ! and
                     else
                        conop(ncond) = 2     ! or 
                     endif
                  endif

!>             Task 5 read variables and values for previously define condition
               else  ! not define assume set variable line
                  if ( ncond .lt. 1 ) then  ! Something wrong and out of order
                     message='Error trying to set values before define'
                     call write_mess(message,line,nl,testfile)
                     err = .true.
                  else
!                    if more variables than max for array then create a new 
!                    conditional statement the same as the one before it.
                     if ( ntask5(ncond) + 1 .gt. ndimt5 ) then
                        is    = ncond
                        ncond = ncond + 1
                        ntask5(ncond) = 1
                        do ii=1,2
                           convar(ii,ncond) = convar(ii,is)
                           con(ii,ncond)    = con(ii,is)
                           conval(ii,ncond) = conval(ii,is)
                        enddo
                        conop(ncond) = conop(is)
                     else
                        ntask5(ncond) = ntask5(ncond) + 1
                     endif

!>                   Read vairable to set if condition true
                     read(lowline(:ieq-1),*,IOSTAT=istatus)  & 
                          t5var(ncond,ntask5(ncond))
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read Task 5 variable'
                        call write_mess(message,line,nl,testfile)
                     else
                        t5var(ncond,ntask5(ncond)) = & 
                          t5var(ncond,ntask5(ncond)) & 
                          (:lrbl(t5var(ncond,ntask5(ncond))))
                     endif
!>                   Read value to set variable to if condition true
!>                   May be an atd variable name
                     read(lowline(ieq+1:),'(a)',IOSTAT=istatus)  & 
                          t5val(ncond,ntask5(ncond))

                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read Task 5 value'
                        call write_mess(message,line,nl,testfile)
                     else
                        t5val(ncond,ntask5(ncond)) = & 
                          t5val(ncond,ntask5(ncond)) & 
                          (lran(t5val(ncond,ntask5(ncond))):)
                        t5val(ncond,ntask5(ncond)) = & 
                          t5val(ncond,ntask5(ncond)) & 
                          (:lrbl(t5val(ncond,ntask5(ncond))))
                     endif

!>                   Read source value if it exists default=atd
                     is = index(lowline,'source')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5source(ncond,ntask5(ncond))

                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 source'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif

!>                   Read sync variable if it exists
                     is = index(lowline,'sync')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5sync(ncond,ntask5(ncond))
                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 sync'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif

!>                   Read bias value if it exists
                     is = index(lowline,'bias')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5bias(ncond,ntask5(ncond))
                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 bias'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif



                  endif ! if ncond > 0
               endif    ! if define line
            elseif ( text ) then
               is = 0  !Not important just prevent text from triggering others
!>          This line has a START key word in it
            elseif ( is .gt. 0 ) then ! Line has start in it 

               if ( index(lowline,'task')  .gt. 0 ) then    ! Start drivers
                  if ( index(lowline,'3') .gt. 0 ) then
                     task3 = .true.          ! task 3 specified
                  else
                     task5 = .true.          ! Assume if not 3 then task 5
                  endif 
               endif

               if ( index(lowline,'plot') .gt. 0 ) then
                  plot = .true.
               endif

               if ( index(lowline,'acd') .gt. 0 ) then
                  acd = .true.
                  idnum = 1
               endif

               if ( index(lowline,'atd') .gt. 0 ) then
                  atd = .true.
                  idnum = 2
               endif

               if ( index(lowline,'pom') .gt. 0 ) then
                  pom = .true.
                  idnum = 3
               endif

               if ( index(lowline,'driver') .gt. 0 ) then
                  drv = .true.
                  idnum = 4
               endif


               if ( index(lowline,'ic') .gt. 0 ) then
                  defic = .true.
               endif

               if ( index(lowline,'text') .gt. 0 ) then
                  text = .true.
               endif

               if ( .not. ( task3 .or. task5 .or. plot & 
                       .or. acd   .or. atd   .or. pom .or. drv & 
                       .or. defic .or. text  )) then

                  message = 'No key word to match START keyword'
                  err = .true.
                  call write_mess(message,line,nl,testfile)
               endif

            endif

            if ( err ) then
               close(lu19)
               fininrt = 3
               return
            endif



         endif
         read(lu19,'(a)',IOSTAT=istatus) line
         nl = nl + 1
      enddo

      close(lu19)


      nl = 0


! * Get tolernaces from tolerance.dat file
      call pathfile(filename,'d:\data','tolerance.dat')
      open(lu81,FILE=filename,IOSTAT=istatus)
      if ( istatus .gt. 0 ) then
         write(message,'(a,a)') 'UNABLE TO OPEN ',filename
         call ftn_logmsg_err("fat_readtest",message)
         write(message,'(A,I5)') 'Status #',istatus
         call ftn_logmsg_err("fat_readtest",message)
      else
         fnd = .false.
	   rewind(lu81)
         do while ( istatus .eq. 0 .and. .not. fnd ) 
            read(lu81,'(a)',IOSTAT=istatus) line
            if ( istatus .eq. 0 ) nl = nl + 1

            if ( line (1:1) .ne. '#' .and. istatus .eq. 0 ) then
               call lower(line,rlan(line))

               if ( index(line,'start') .gt. 0 ) then  !start of new section
                  if ( index(line,'tolerance')  .gt. 0 ) then
                     istol = .true.
                  elseif ( index(line,'tests')  .gt. 0 ) then
                     istest = .true.
                  endif

               elseif ( index(line,'end') .gt. 0 ) then !end of section
                  istol = .false.
                  istest = .false.

               elseif ( istol ) then
                  read(line,*,IOSTAT=istatus) ii,tolv(ii), & 
                                        tola(ii),tolp(ii)
                  if ( istatus .ne. 0 ) then
                     message= 'Unable to read tolerances from '// & 
                          ' tolerances.dat file'
                     call write_mess(message,line,nl,filename)
                  else
                     ntol = ii
!                     write(*,*) 'tolv(',ii,' = ',tolv(ii),'tola = ',tola(ii),
!     >                    'tolp = ',tolp(ii)
                  endif

               elseif ( istest ) then 
                  read(line,'(a)',IOSTAT=istatus) message
                  is = lran(message)
                  ie = lrbl(message(is:)) + is
                  read(message(is:ie),*,IOSTAT=it) ii
                  if ( istatus .ne. 0 .or. it .ne. 0 ) then
                     message= 'Unable to read test info from'// & 
                          'tolerances.dat file'
                     call write_mess(message,line,nl,filename)
                  elseif ( ii .eq. fattest ) then
                     fnd = .true.
                     message=message(ie+1:)
                  endif
               endif
            endif
         enddo
         close(lu81)

! * Find tolernaces for each plot variable don't overwrite those in test def
         if ( fnd ) then  !if test tolerances found
            line = message
!            write(*,*) 'line = ',line
            it  = 1
            istatus = 0
            do while( istatus .eq. 0 .and. it .lt. rlan(line) )
               ie = lran(line(it:)) + it - 1
               read(line(ie:),*,IOSTAT=istatus) jj
               fnd = .false.
!               write(*,*) 'jj = ',jj
               ii = 1
               do while ( ii .le. ny .and. .not. fnd )
!                  write(*,*) 'tolv(',jj,') = ',tolv(jj),
!     >                 'yvar(',ii,') =',yvar(ii)
                  if ( yvar(ii)(:lrbl(yvar(ii))) .eq. & 
                       tolv(jj)(:lrbl(tolv(jj)))) then
                     if ( tol_a(ii) .eq. 0. ) tol_a(ii) = tola(jj)
                     if ( tol_p(ii) .eq. 0. ) tol_p(ii) = tolp(jj)
                     fnd = .true.
                  endif
                  ii = ii + 1
               enddo
               write(cname,*) jj
               is = lran(cname)
               ii = rlan(cname)
               it =  ie + ii - is + 1
!               write(*,*) 'it = ',it,'cname = ',cname,'is = ',is
!               write(*,*) 'line = ',line
            enddo
         endif !if test found in tolerances.dat

      endif !If tolerances.dat opened

!  end flight_read
!>#   Data read in now convert to global variables and arrays
!>#   for use by the rest of the autotest system

!>##  Extract IC variables and values and
!>##  plot & recording variables and put into globals

      include "flt_init_plot.inc"

      if ( fininrt .eq. 3 ) return

! * Get SMS address for IC input variables
      do i=1,ficinnum
         call find_address(ficinvar(i),fictype(i),ficinaddr(i))  !get address
         if ( ficinaddr(i) .eq. 0 ) then ! Unable to find address
            err = .true.
            message='Unable to locate SMS address of IC input var: '// & 
                    icvar(i)
            call ftn_logmsg_err("fat_readtest",message)
         endif
      enddo

! * Get SMS addresses for IC output variables
      do i=1,ficotnum
         call find_address(ficoutvar(i),ficoutype(i),ficotaddr(i)) !get address
         if ( ficotaddr(i) .eq. 0 ) then ! Unable to find address
            message='Unable to find IC output var: '//ficoutvar(i)
            call ftn_logmsg_err("fat_readtest",message)
         endif
      enddo



!>#   Reset the task 5 globals
	fatdnum = 0
	!     do i=1,2
	do is=1,30
		ft5con(is)     = 0
		ft5conaddr(is) = 0
		ft5contype(is) = 0
		!                        if ( i .eq. 1 ) then
		!                        ft5ovrdt6(is) = .false.
		!                        do it=1,15
		ft5addr(is)    = 0
		!                        ft5bias(is,it)    = 0.
		ft5val(is)     = 0.
		!                        ft5synaddr(is,it) = 0
	enddo
	!           endif
!	enddo
	!     enddo
!         
!>#   Extract Task 5 driver data and transfer to globals

!	i = 0  !Index  hl
    i = 1
!write(*,*) 'ncond = ',ncond
	do j=1,ncond
!         ft5conop(i) = conop(i)
		i = i + 1
		is = 1
		call gettypeval(convar(is,j),conval(is,j), & 
						ft5conval(i),ft5contype(i),terr)
		if ( terr .or. ft5contype(i) .lt. 2 ) then
			err = .true.
			if ( terr ) then
				message='Unable to read task 5 value for: '//conval(is,j)
			else
				message='Unable to find type of task 5 variable'//convar(is,j)
			endif
			call ftn_logmsg_err("fat_readtest",message)
		endif
		
		call find_address(convar(is,j),ft5contype(i), & 
							ft5conaddr(i))

		if ( ft5conaddr(i) .eq. 0 ) then
			message='Variable not define in database for task5 cond'//convar(is,j)
			call ftn_logmsg_err("fat_readtest",message)
			err = .true.
		endif


		if ( con(is,j)(:lrbl(con(is,j))) .eq. '=' ) then
			ft5con(i) = 1
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '<' ) then
			ft5con(i) = 2
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '>' ) then
			ft5con(i) = 3
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '<=' ) then
			ft5con(i) = 4
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '=<' ) then
			ft5con(i) = 4
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '>=' ) then
			ft5con(i) = 5
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '=>' ) then
			ft5con(i) = 5
		elseif ( con(is,j)(:lrbl(con(is,j))) .eq. '<>' ) then
			ft5con(i) = 6
		else
			message='Unable to determine operator for Task 5 '//con(is,j)
			call ftn_logmsg_err("fat_readtest",message)
			err = .true.
		endif

		if ( convar(is,j)(:lrbl(convar(is,j))) .eq. 'fattask' .and. & 
			(	(ft5con(i) .eq. 1 .and. ft5conval(i) .eq. 6) .or. & 
				(ft5con(i) .eq. 3 .and. ft5conval(i) .ge. 5) .or. & 
				(ft5con(i) .eq. 5 .and. ft5conval(i) .ge. 5)) ) then

			ft5ovrdt6(i) = .true. !fattask = 6 conditional
		endif

!>#      Extract Task 5 data including atd information
         do is=1,ntask5(j)
!>          Extract value/atd driver for variable           
            call gettypeval(t5var(j,is),t5val(j,is),ft5val(i),it,terr)

            if ( terr .and. it .ge. 2 ) then  !val is not a # assume atddriver
               fatdnum = fatdnum + 1             !Increment # of drivers
               tsource(fatdnum) = t5source(j,is) !Temp storage of file suffix
               tatdvar(fatdnum) = t5val(j,is)(:lrbl(t5val(j,is))) !Temp storage
               read(t5val(j,is),*) tatdvar(fatdnum)
!               ft5type(i,is) = it  
				i = i - 1
	            call find_address(t5var(j,is),ft5type(i),fatdaddr(fatdnum))
				if ( fatdaddr(fatdnum) .eq. 0 ) then
				   message='Unable to located SMS address of task5 var' & 
							//t5var(j,is)
				   err = .true.
				   call ftn_logmsg_err("fat_readtest",message)
				endif

!write(*,*)' Found ATD driver ',tatdvar(fatdnum)
            elseif ( it .lt. 2 ) then
               err = .true.
               message='Unable to determine type of task 5 variable '// & 
                        t5var(j,is)
               call ftn_logmsg_err("fat_readtest",message)
            else
               !ft5type(i,is) = it
				if (is .ne. 1 ) then    !replicate conditional
					ft5con(i)     = ft5con(i-1)
					ft5conaddr(i) = ft5conaddr(i-1)
					ft5contype(i) = ft5contype(i-1)
				endif
!>          Get address of variable to set
				call find_address(t5var(j,is),ft5type(i),ft5addr(i))
				if ( ft5addr(i) .eq. 0 ) then
					message='Unable to find task5 var '//t5var(j,is)
					call ftn_logmsg_err("fat_readtest",message)
				endif
            endif



			i = i + 1	!Increment conditional counter		 
		enddo  !is = 1,ntask5
		
		if ( ft5addr(i) .eq. 0 ) then  !Nothing for this conditional delete it
			i = i - 1
		endif


      enddo  ! i = 1,ncond

      ft5cond = i !Number of conditionals

	  message=' task 5 setup complete '
                  call ftn_logmsg_info(module,message)


!>#   Find global shift and gains
      do is = 1,4
         xshift(is) = 0
         xgain(is)  = 1.
         do j=1,ncnt(is)        !For each S&G defined see if variable matches
            if ( var(is,j)(:lrbl(var(is,j))) .eq. 'ftsttime' ) then
               xshift(is) = ysh(is,j) + xsh(is,j) !For time x y is undefined
               xgain(is)  = ygn(is,j) * xgn(is,j) !Assume user set either x or y

            endif
         enddo
      enddo
      if ( xgain(4) .ne. 1. .or. xshift(4) .ne. 0. ) then
         do is = 1,3
            xshift(is) = xshift(4)
            xgain(is)  = xgain(4)
         enddo
      endif


!>    Read the x array from file chosen above specified
      if ( fatdnum .gt. 0 ) then

!>       reset the data pointer - index in fatddata for new data
         pointer = 1

!>#   Get the user defined shifts and gains and apply them to the data when
!>#   it is read in
         do i=1,fatdnum

            it = 0

            if ( tsource(i)(:3) .eq. 'acd' ) it = 1
            if ( tsource(i)(:3) .eq. 'atd' ) it = 2
            if ( tsource(i)(:3) .eq. 'pom' ) it = 3
            ysng(1,i) = 0.0     !Default Y shift 
            ysng(2,i) = 1.0     !Default Y gain

            xsng(1,i) = 0.0  !Default X shift
            xsng(2,i) = 1.0  !Default X gain

            fatdxsng(1,i) = xshift(it)  !Default X shift
            fatdxsng(2,i) = xgain(it)   !Default X shift

            if ( it .ne. 0 ) then
               do j=1,ncnt(it)  !For each S&G defined see if variable matches
                  if ( var(it,j)(:lrbl(var(it,j))) .eq. & 
                       tatdvar(i)(:lrbl(tatdvar(i))) ) then
                     ysng(1,i) = ysh(it,j)
                     ysng(2,i) = ygn(it,j)
                     fatdxsng(1,i) = xsh(it,j) + xshift(it)
                     fatdxsng(2,i) = xgn(it,j) * xgain(it)
                  endif
               enddo
            endif

            it = 4              !Override
            do j=1,ncnt(it)     !For each S&G defined see if variable matches
               if ( var(it,j)(:lrbl(var(it,j))) .eq. & 
                    tatdvar(i)(:lrbl(tatdvar(i))) ) then
                  ysng(1,i) = ysh(it,j)
                  ysng(2,i) = ygn(it,j)
                  fatdxsng(1,i) = xsh(it,j) + xshift(it)
                  fatdxsng(2,i) = xgn(it,j) * xgain(it)
               endif
            enddo
         enddo

!>    Sort the sources so ordered by file name to speed the file reads up
         do i=1,40              !Reset the index array
            idx(i) = i
         enddo

         do i=1,fatdnum-1
            do is=i+1,fatdnum
               if ( tsource(idx(i))(:lrbl(tsource(idx(i)))) .eq. & 
                    tsource(idx(is))(:lrbl(tsource(idx(is)))) ) then
                  it = idx(is)
                  do ie=1,is-i
                     idx(is-ie+1) = idx(is-ie)
                  enddo
                  idx(i+1)   = it
               endif
            enddo
         enddo

!>       Read the requested independent data from the requested files
!>       match up source file names so that it calls read only once per
!>       file

         i = 1

         do while (i .le. fatdnum )
            it = 1
            vararr(it) = tatdvar(idx(i))
            locidx(it) = idx(i)
            call pathfile(filename,'d:\data',ftestname(:lrbl(ftestname))// & 
                 '.'//tsource(idx(i))(:lrbl(tsource(idx(i)))))

            if ( i .lt. fatdnum ) then
               do while ( tsource(idx(i))(:lrbl(tsource(idx(i)))) .eq. & 
                    tsource(idx(i+1))(:lrbl(tsource(idx(i+1)))) .and. & 
                    i .lt. fatdnum )
                  i = i + 1
                  it = it + 1
                  vararr(it) = tatdvar(idx(i))
                  locidx(it) = idx(i)
               enddo
            endif

            call flt_read_data(filename,vararr,it,locidx,xsng,ysng, & 
                               fatddim,fatdxind,fatdyind,pointer, & 
                               fatddata,psnap,ch,err)

            if ( err ) then
               fininrt = 3
               message='Unable to set up test: '//ftestname
               call ftn_logmsg_err('fat_readtest',message(:rlan(message)))
               return
            endif

            i = i + 1
         enddo

         do i=1,fatdnum
            if ( fatddim(i) .lt. 1 ) then
               message='Unable to find '//tatdvar(i)(:lrbl(tatdvar(i))) & 
                    //' in driver file'
               call ftn_logmsg_err('fat_readtest',message(:rlan(message)))
               fininrt = 3
               return
            endif
         enddo

		fatdptr = pointer

      endif  !IF fatdnum > 0


! ****************************************************************************
!    IOS interface for autotest page


      k = rlan(title)
      if ( k .ge. 132 ) k = 131
      do i=1,k
         fattitle(i) = ichar(title(i:i))
      enddo
      fattitle(k+1) = 0

      k = rlan(comment)
      if ( k .ge. 132 ) k = 131
      do i=1,k
         fatcomment(i) = ichar(comment(i:i))
      enddo
      fatcomment(k+1) = 0

      k = lrbl(ftestname)
      do i=1,k
         fatname(i) = ichar(ftestname(i:i))
      enddo
      fatname(k+1) = 0


      do i=1,ficotnum
         j = index(ficlab(ficord(i)),'?')
         if ( j .gt. 0 ) then   !remove ? from label
            labl = ficlab(ficord(i))(1:j-1)
            labl(j:) = ficlab(ficord(i))(j+1:)
         else      
            labl = ficlab(ficord(i))
         endif
         j = index(labl,':')
         ll = rlan(labl)
         if ( j .gt. 0 ) then   ! Units found move to far right
            unit = labl(j+1:)
            unit = unit(lran(unit):) !remove leading spaces
            ll   = rlan(unit)
            labl = labl(:j-1)
            do k=j,36
               labl(k:k) = ' '  !pad space between label and unit
            enddo
            labl(36-ll:) = unit
         endif
         k=rlan(labl)
         ficlab(ficord(i)) = labl 
         if ( k .ge. 40 ) k = 39
         do j=1,k
            faticlab(j+(i-1)*40) = ichar(labl(j:j))
         enddo
         faticlab(k+1+(i-1)*40) = 0    !Null terminate the string
      enddo

      do i=ficotnum+1,100
         do j=1,40
            faticlab(j+(i-1)*40) = 0
         enddo
      enddo




      fininrt = 2
 11   format(A,I5,A,A)
 12   format(A,A)
      return
      end

 

      subroutine find_address(name,type,addr)
      implicit none

      character*64   name         !variable name
      integer        type         !variable type 1=log 2=int 3=real
      integer        addr         !address of variable

      integer        ibs,ibe      !counters
      integer        nl           !length of name
      integer*4      offset       !array index or 1 for non-arrays

      character*64   tname        !temp name without the (##)

!     External functions
      integer*4      lrbl         !returns index of first blank 
!      integer*4      atoi_c       !returns integer of char string

      nl = lrbl(name)
      ibs = index(name(:nl),'(')
      ibe = index(name(:nl),')')
      tname = ' '

      if ( ibe .le. ibs ) then   ! No (#) in name assume not array
         offset = 1
         tname = name(:nl)
      else                       ! there is potentially a (#) in name
!         offset=atoi_c(name(ibs+1:ibe-1))
         if ( offset .le. 0 ) offset = 1
         tname = name(:ibs-1)     !delete the () from the name
      endif

      call get_address(tname,type,offset,addr)

      return
      end




