! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : JPATS
!    JOB             : ALL
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : FAT_READFILE
!    DESCRIPTION     : Writes test interface files for the host
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 5-Apr-00
!    ENGINEERS       : Mike Saladin
!    SYSTEM          : Windows

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 2000 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
!
! This module reads the temp files for the interface from the host.
!
! The first file is the IC file which is two columns.  The first column is 
! the integer index representation of the variable.  The second is the value in
! real format.
!
! The second file is the recorded data file.  The first line contains the total
! number of columns of data.  The second line contains the list if integer 
! indices for the variables in csv format.  The remaining lines contain the data
! in csv format.  Each line is a seperate frame of data.
!

	subroutine fat_readfile(ficotnum,logdata,frecbuff,fsimnumb,frecframe,error)

	implicit none

	integer*4		frecframe		! Number of frames written
	integer*4		fsimnumb		! Number of recorded/plotted variables
	integer*4		ficotnum		! Number of vars to output as ic

	real*4			frecbuff(100000)! Data storage array use fatddata in fat_control
	real*4			logdata (200)	! Sim initialization data

!	Argument List

	logical*4		error			! Error flag

!	Locals	

	integer*4		i,j,k			!Loop counters
	integer*4		lu50  /50/		!Index for output file
	integer*4		ist				!IOSTAT flag
	integer*4		recind(200)		!Temp index of variables

	character*256	message			!Message line
	character*132	outfile			!Output file name
	character*132	filename		!Output file name
	character*13	module /'fat_readfile'/ !Module name

	real*4			x				!Temp real

	logical*4		fexist			!File Exists flag


!	Externals

	integer*4		lrbl			!Returns first blank from left


!	include "flt_plot.inc"
	

     CHARACTER*80  RCSID_flt_plot & 
      /"$Id: flt_plot.inc,v 1.5 2000/03/13 21:59:27 saladinm Exp $"/


      common /fplotc/ simname,chdate,chtime,username,cpid,		& 
            title,comment,ficoutvar,frecvar,jobcode,			& 
            fpath,ficlab,ficinvar,ftestname,fyname,				&
			fxname,freclab,jpats_vars,fsimvar,ficsimvar


	common /jpats/ jpats_nvar,jpats_indx
!
!	Parameter definitions

	integer*4		jpats_nvar		!Number of variables in jpats_vars
	integer*4		jpats_indx(200)	!Cross reference index

      integer*4 maxgrid           !max number of grids to plot = 6 pages
      parameter (maxgrid = 36)

      integer*4 numline           !Number of lines in a text file
      parameter(numline = 60)

      integer*4 nlic              !Number of ICs that make a page
      parameter(nlic = 50) 

      integer*4 ndimrec           !Dimension of recording variable arrays
      parameter(ndimrec = 200)

      integer*4 ndimic            !Dimension of IC arrays
      parameter(ndimic = 200)

      integer*4 ndimcon           !Dimension of Task 5 Conditionals
      parameter(ndimcon = 30)

      integer*4 ndimt5            !Dimension of Task 5 Statements
      parameter(ndimt5 = 15)
!
!*******************************************************************
!     Labels in the common block
!*******************************************************************
!
      character*32 simname        !simulator name (init in flt_initpath.f)
      character*12 jobcode        !Job code for plots from sim.cfg
      character*14 chdate         !test date:characters
      character*10 chtime         !test time:characters
      character*132 title         !test title
      character*132 comment       !test comment
      character*40 username       !user's login name
      character*7  cpid           !Current process id

!>#   
      character*64 frecvar(ndimrec) !Names of record variables inorder recorded
      character*64 fsimvar(ndimrec) !Names of variables recorded by host
      character*36 freclab(ndimrec) !Titles for recorded variables for hardcopy
      character*64 ficoutvar(ndimic)!Names of IC variables to Output
      character*64 ficsimvar(ndimic)!Names of IC variables from Host
      character*64 ficinvar(ndimic) !Names of IC variables input
      character*36 ficlab(ndimic)   !Titles for ic variables for hardcopy

      character*64 fpomvar(200)    !POM variable for shift and gains in .dat 
      character*64 facdvar(200)    !ACD variable for shift and gains in .dat 
      character*36 fxname(6)       !x variable name
      character*36 fyname(36)      !y variable name
      character*80 fpath           !Path name to data directory
 !     character*80 fpath /'d:\data'/           !Path name to data directory
      character*40 ftestname       !Testname
      character*40 jpats_vars(200) !JPATs specific variable interface array





!  end flt_plot.inc
	call pathfile(outfile,'d:\Host_Data','icout.dat')

	open(UNIT=lu50,FILE=outfile,IOSTAT=ist)

!	Read Ic data from HOST temp file and store into arrays used by fat_icrec.f90

	i = 0

	ist = 0

	do while ( ist .eq. 0 )
		read(lu50,*,IOSTAT=ist) j,x
		if ( ist .eq. 0 ) then
			i = i + 1
			logdata(i) = x
			call get_jpats_var(j,ficsimvar(i))
		endif
	enddo

	ficotnum = i

	close(lu50)
     message=' finished reading icout '
                  call ftn_logmsg_info('fat_readfile',message)	
!
!	Read sim data from HOST temp file and store into arrays used by fat_datarec.f90
	call pathfile(outfile,'d:\Host_Data','histout.csv')

	open(UNIT=lu50,FILE=outfile,IOSTAT=ist)
	if ( ist .ne. 0 ) then
         message = 'UNABLE TO OPEN '//filename(:lrbl(filename))
         call ftn_logmsg_err("fat_readfile",message)
         return
    endif
    		   message=' finished reading histout '
                  call ftn_logmsg_info('fat_readfile',message)	
!	Read number of columns on first line
	read(lu50,20,IOSTAT=ist) fsimnumb
	
	read(lu50,30,IOSTAT=ist) (recind(i),i=1,fsimnumb) !Independent is always 1

!	Get the ASCII recording variable names
	do i=1,fsimnumb
		call get_jpats_var(recind(i),fsimvar(i))
	enddo

	ist = 0
	frecframe = 0
	do while ( ist .eq. 0 .and. frecframe * fsimnumb .lt. 100000 ) 
		read(lu50,40,IOSTAT=ist) (frecbuff(i+frecframe*fsimnumb),i=1,fsimnumb)
		if ( ist .eq. 0 ) frecframe = frecframe + 1
	enddo

	close(lu50)
	
	return

10	format(I,g)
20	format(I)
30	format(40(I,','))
40	format(40(g10.4,','))
50	format(i3,1x,g10.4)
	end

