! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_readbatch
!    DESCRIPTION     : Reads batch files         
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! ****************************************************************************
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!--> REVISION BEGIN

!                            Revision History

! $Id: fat_readbatch.f,v 1.2 1999/02/26 22:05:37 saladinm Exp $
! $Log: fat_readbatch.f,v $
! Revision 1.2  1999/02/26 22:05:37  saladinm
! Changed batch file names.

! Revision 1.1  1999/02/03 21:53:41  saladinm
! Initial revision

! Revision 1.1  1998/12/16 21:29:18  saladinm
! Initial revision

! Revision 1.3  1998/04/22 20:04:12  scottc
! Initial Release for 8700

! Revision 1.2  1998/01/26 16:42:39  scottc
! fnj113nrt.f Initial release from automated d61master process

! Revision 1.6  1997/10/29 17:45:00  mattk
! move f113nrt flag to allow complete file read before setting

! Revision 1.5  1997/03/06 20:20:53  mattk
! changed id: to Id:

! Revision 1.4  1996/12/09 21:45:47  mattk
! removed quote

! Revision 1.3  1996/12/09 18:24:07  mattk
! fnj113nrt.f Initial release from automated zeb process

! Revision 1.1  1996/11/01 15:55:12  mattk
! Initial revision

! Revision 1.2  1996/02/01  23:06:57  mattk
! update man page

! Revision 1.1  1996/02/01  21:45:07  mattk
! Initial revision

! Revision 1.1  1996/02/01  21:03:49  mattk
! Initial revision

! Revision 1.2  1996/01/23  19:41:17  mattk
! fnj113nrt.f add FAX number from automated change process

! Revision 1.1  1996/01/19  22:13:11  mattk
! Initial revision

!--> REVISION END
! ****************************************************************************
!.mp  .TH FNJ113NRT l FSI
!.mp  .SH NAME
!.mp  FNJ113NRT \- Autotest Driver Time Input (FSI)
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp   none
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp  This module allows non-real time read of batch files for autotest.
!.mp  
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************
	subroutine fat_readbatch(fatbfile,fbarray,fmaxbatch,err)

	implicit none 

! * Global variables
	integer*4   fbarray(200)			!batch array
	integer*4   fmaxbatch				!total count
	integer*4   fatbfile				!Batch file index

	logical*4	err						!Error flag
! * Locals 
	character*256 message
	character*132 filename				!filename
	character*13  module /'fat_readbatch'/ !
	character*8   cbarray(200)			!batch array string


	integer*4     i                     !loop counter
	integer*4     lu8/8/                !tmp file
	integer*4     ist                   !IOSTAT flag

	logical       lexist                !file exist flag
	logical       firstpass /.true./    !firstpass flag

! * Externals
	integer*4     lrbl                  !Index of first blank from left


! * Include things like fpath
	include "flt_plot.inc"

	err = .false. 


! get the batch file name.
	if (fatbfile .eq. 1) then
		call pathfile(filename,fpath,'batch_q1.dat')
	elseif (fatbfile .eq. 2) then
		call pathfile(filename,fpath,'batch_q2.dat')
	elseif (fatbfile .eq. 3) then
		call pathfile(filename,fpath,'batch_q3.dat')
	elseif (fatbfile .eq. 4) then
		call pathfile(filename,fpath,'batch_q4.dat')
	elseif (fatbfile .eq. 5) then
		call pathfile(filename,fpath,'batch.dat')
	elseif (fatbfile .eq. 6) then
		call pathfile(filename,fpath,'batch_qtg.dat')
	else
		err = .true.
		return
	endif

! * Reset all batch file flags.
!	fatbfile = 0

	inquire (FILE=filename,EXIST=lexist,IOSTAT=ist)
	if (.not.lexist .or. ist .ne. 0 ) then
		message='Unable to find file :'//filename(:lrbl(filename))
		call ftn_logmsg_err(module,message)
		err = .true.
		return
	endif

	open (UNIT=lu8,FILE=filename,IOSTAT=ist)

	if ( ist .ne. 0 ) then 
		message='Unable to open file :'//filename(:lrbl(filename))
		call ftn_logmsg_err(module,message)
		err = .true.
		return
	endif

	i=0
	ist = 0
	fmaxbatch = 0
	do while (i .le. 200 .and. ist .eq. 0 )       !only 200
		i=i+1                                      !increment pointer
		read (lu8,10,IOSTAT=ist) cbarray(i)        !read data
		if (cbarray(i)(1:1).le.'/' .or. ist .ne. 0 ) then   !not valid/comment
			i=i-1
		else
			call ctoi(cbarray(i),fbarray(i))        !pass to global
			fmaxbatch = i
		endif
	enddo

	if ( fmaxbatch .lt. 1 ) then
		message='Unable to read tests in :'//filename(:lrbl(filename))
		call ftn_logmsg_err(module,message)
		err = .true.
	endif

	close (lu8)

	return
10	format(a)
	end
