! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_misc
!    DESCRIPTION     : Miscellaneous routines used by the autotest process
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! ****************************************************************************
!
!
!	This routine returns the index pointer for the requested variable
!
	subroutine get_address(name,type,offset,addr)

	implicit none

	character*(*)	name		!Variable name

	integer*4		type		!Variable type - not used here
	integer*4		offset		!Offset for arrays - not currently used
	integer*4		addr		!Index into master list

!	Locals

	character*11	module /'get_address'/ !

	integer*4		i			!Loop

!	Externals
	integer*4		lrbl		!Returns first non blank on line


	include "flt_plot.inc"

	addr = 0  !default or error
	type = 1

	i = 1
	do while ( i .le. jpats_nvar .and. addr .eq. 0 ) 
		if ( name(:lrbl(name)) .eq. jpats_vars(i)(:lrbl(jpats_vars(i))) ) then
			addr = jpats_indx(i)
		endif
		i = i + 1			
	enddo

	return

	end

	subroutine ftn_logmsg_err(module,line)

	character*(*)	line    !Input line
	character*(*)	module	!Input line

!	Locals

	character*132	logfile		!Log file
	integer*4		lu38 /38/	!logical unit

	logical*4		first /.true./

!	Externals
	integer*4		rlan		!Returns last non-blank on line
	integer*4		lrbl		!Returns first blank on line

	include	"flt_plot.inc"

	if ( first ) then
		call pathfile(logfile,fpath,'autotest_log.txt')

		call del_file(logfile)

		open(UNIT=lu38,FILE=logfile,IOSTAT=isok)
	
		first = .false.
	endif

	if ( isok .eq. 0 ) then
		write(lu38,10) 'ERROR in '//module(:lrbl(module))//'  : '//line(:rlan(line))
	endif

	return

10	format(A)

	end

	subroutine ftn_logmsg_info(module,line)

	character*(*)	line    !Input line
	character*(*)	module	!Input line

!	Locals

	character*132	logfile		!Log file
	integer*4		lu38 /38/	!logical unit

	logical*4		first /.true./

!	Externals
	integer*4		rlan		!Returns last non-blank on line
	integer*4		lrbl		!Returns first blank on line

	include	"flt_plot.inc"

	if ( first ) then
		call pathfile(logfile,fpath,'autotest_log.txt')

		call del_file(logfile)

		open(UNIT=lu38,FILE=logfile,IOSTAT=isok)
	
		first = .false.
	endif

	if ( isok .eq. 0 ) then
		write(lu38,10) 'INFO from '//module(:lrbl(module))//'  : '//line(:rlan(line))
	endif
!write(*,10) 'INFO from '//module(:lrbl(module))//'  : '//line(:rlan(line))

	return

10	format(A)

	end


	subroutine load_jpats_var()

	implicit none

!	Locals
	character*132	infile		!Variable index file
	character*132	line		!Text input line
	character*40	tvar		!Temp variable 
	character*14    module /'load_jpats_var'/
	
	integer*4		i			!Loop
	integer*4		ist			!IOSTAT ERROR
	integer*4		ist2		!IOSTAT ERROR
	integer*4		lu34 /34/	!Logical unit for variable_index.dat file

	logical*4		fexist		 !First pass label

!	Externals
	integer*4		lrbl		!Returns first non blank on line


	include "flt_plot.inc"

    fpath = 'd:\data'
	call pathfile(infile,fpath,'variable_index.dat')

	inquire(FILE=infile,EXIST=fexist)
	if ( .not. fexist ) then
		call ftn_logmsg_err(module,'Unable to find : '//infile(:lrbl(infile)))
		return
	endif

	open(UNIT=lu34,FILE=infile,IOSTAT=ist)
	if ( ist .ne. 0  ) then
		call ftn_logmsg_err(module,'Unable to open : '//infile(:lrbl(infile)))
		return
	endif
	jpats_nvar = 0
	do while ( ist .eq. 0 )
		read(lu34,10,IOSTAT=ist) line

		if ( index(line,'#') .lt. 1 .and. ist .eq. 0 ) then  !Not a comment
			read(line,*,IOSTAT=ist2) i,tvar
			if ( ist2 .eq. 0 ) then
				jpats_nvar             = jpats_nvar + 1
				jpats_vars(jpats_nvar) = tvar
				jpats_indx(jpats_nvar) = i
				if ( jpats_nvar .ge. 200 ) ist = 0  !Limit to defined array size
			endif
		endif
	enddo

	close(lu34)

	return

10	format(A)

	end

	subroutine get_jpats_var(ind,var)
	implicit none

	character*40	var			!Variable found in index

	integer*4		ind			!Index value

!	Locals

	integer*4		i			!Loop counter

!	Externals
	integer*4		lrbl		!Returns index of first blank of input

	include "flt_plot.inc"


	i   = 1
	var = ' '

	do while ( i .le. jpats_nvar .and. var .eq. ' ' ) 
		if ( jpats_indx(i) .eq. ind )  var = jpats_vars(i)
		i = i + 1			
	enddo


	return

	end
