! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_icrec
!    DESCRIPTION     : Initial Condition Recording
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/28/00
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1991 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
!--> REVISION BEGIN

!                            Revision History

! $Id: fat_icrec.f,v 1.2 1999/02/18 13:47:45 saladinm Exp $
! $Log: fat_icrec.f,v $
! Revision 1.2  1999/02/18 13:47:45  saladinm
! Changed logic of sim.2 file creation to be that it makes it only once.

! Revision 1.1  1999/02/03 21:52:31  saladinm
! Initial revision

! Revision 1.1  1998/12/16 21:29:18  saladinm
! Initial revision to support new autotest system.  Total re-write.


!--> REVISION END
! ****************************************************************************
!.mp  .TH FNJREC l FSI
!.mp  .SH NAME
!.mp  FNJREC \- Initial Condition Recording (FSI)
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp  FSI Flight Library d61flt.a
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp
!.mp  The function of this module is to write the initial conditions
!.mp  (ie. torque, airspeed, altitude etc.) specified in the test definition
!.mp  file to the .sim file.  The values written are used for
!.mp  comparison with the flight test initial conditions during test
!.mp  evaluation.
!.mp  
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************

      SUBROUTINE fat_icrec(ficrecfl    ,logdata, & 
           fatman, ficoutype, ficotnum, ficotaddr, & 
          frecval )

      IMPLICIT NONE 
      CHARACTER*80  RCSID & 
      /"$Id: fat_icrec.f,v 1.2 1999/02/18 13:47:45 saladinm Exp $"/

      logical*4  fatman                 !ref 113 man test

!      integer*4  fattask               !ref 113 fattask number
      integer*4  ficotnum               !ref 113 Number of output ic's
      integer*4  ficoutype(200)         !ref 113 Type of ic(1,2,3 log,int,real)
      integer*4  ficotaddr(200)         !ref 113 Address of IC's to output
      integer*4  ficrecfl               !ref nrt task code for ini
      integer*4  frecval                !ref 113 data recording flag
      integer*4  jjj
      real*4     logdata (200)           !ref 113 siminit initialisation data


! local labels
 !     include "flt_plot.inc" 
 ! begin flt_plot.inc
	       common /fplotc/ simname,chdate,chtime,username,cpid,		& 
            title,comment,ficoutvar,frecvar,jobcode,			& 
            fpath,ficlab,ficinvar,ftestname,fyname,				&
			fxname,freclab,jpats_vars,fsimvar,ficsimvar


	common /jpats/ jpats_nvar,jpats_indx
!
!	Parameter definitions

	integer*4		jpats_nvar		!Number of variables in jpats_vars
	integer*4		jpats_indx(200)	!Cross reference index

      integer*4 maxgrid           !max number of grids to plot = 6 pages
      parameter (maxgrid = 36)

      integer*4 numline           !Number of lines in a text file
      parameter(numline = 60)

      integer*4 nlic              !Number of ICs that make a page
      parameter(nlic = 50) 

      integer*4 ndimrec           !Dimension of recording variable arrays
      parameter(ndimrec = 200)

      integer*4 ndimic            !Dimension of IC arrays
      parameter(ndimic = 200)

      integer*4 ndimcon           !Dimension of Task 5 Conditionals
      parameter(ndimcon = 30)

      integer*4 ndimt5            !Dimension of Task 5 Statements
      parameter(ndimt5 = 15)
!
!*******************************************************************
!     Labels in the common block
!*******************************************************************
!
      character*32 simname        !simulator name (init in flt_initpath.f)
      character*12 jobcode        !Job code for plots from sim.cfg
      character*14 chdate         !test date:characters
      character*10 chtime         !test time:characters
      character*132 title         !test title
      character*132 comment       !test comment
      character*40 username       !user's login name
      character*7  cpid           !Current process id

!>#   
      character*64 frecvar(ndimrec) !Names of record variables inorder recorded
      character*64 fsimvar(ndimrec) !Names of variables recorded by host
      character*36 freclab(ndimrec) !Titles for recorded variables for hardcopy
      character*64 ficoutvar(ndimic)!Names of IC variables to Output
      character*64 ficsimvar(ndimic)!Names of IC variables from Host
      character*64 ficinvar(ndimic) !Names of IC variables input
      character*36 ficlab(ndimic)   !Titles for ic variables for hardcopy

      character*64 fpomvar(200)    !POM variable for shift and gains in .dat 
      character*64 facdvar(200)    !ACD variable for shift and gains in .dat 
      character*36 fxname(6)       !x variable name
      character*36 fyname(36)      !y variable name
      character*80 fpath           !Path name to data directory
 !     character*80 fpath /'d:\data'/           !Path name to data directory
      character*40 ftestname       !Testname
      character*40 jpats_vars(200) !JPATs specific variable interface array

! end flt_plot.inc

	logical*4		err					!Error flag
      logical       fexist              !file exists 
      logical       fexist1             !file exists 
      logical       fexist2             !file exists 
      logical       firstpass /.true./  !first pass var

      integer       i,j,l               !loop counters
      integer       lu8 /8/             !icdata logical unit
      integer       ierr                !error flag         


      real*4        x                   !temp IC value

      character*256  message

      character*80  filename            !.icp file name
      character*80  tempname            !temp char string


!>    External functions

      integer*4    lrbl     !Returns index of 1st blank from the left
      real*4       getval   !Returns real value of address

! BEGIN THE PROGRAM

!      if ( firstpass ) then
!         firstpass = .false.
!         return
!      endif

!>    Make sure .sim was properly closed by fat_datarec
!      if ( fattask .lt. 4 .and. frecval .eq. 0 ) then 
!         inquire(UNIT=lu8,OPENED=fexist)
!         if ( fexist ) close(lu8)
!      endif

!      if( ficrecfl .ne. 1 ) return                  !nothing to do

      fpath = 'd:\Data'
      tempname = ftestname(:lrbl(ftestname))//'.sim' !ftestname set in readtest
      call pathfile(filename,fpath,tempname(:lrbl(tempname)))

      l = lrbl(filename)
      inquire(FILE=filename,EXIST=fexist) 
      inquire(FILE=filename(:l)//'.1',EXIST=fexist1)
      inquire(FILE=filename(:l)//'.2',EXIST=fexist2)

!>    Copy old versions of sim data for this test from .1 to .2 and old to .1
      if ( fexist ) then
         if ( .not. fexist2 .and. fexist1 ) then
			call copy_file(filename(:l)//'.1 ',filename(:l)//'.2',err)
         elseif( .not. fexist2 ) then
			call copy_file(filename(:l)//' ',filename(:l)//'.2',err)
         endif
         if ( fexist1 ) then
			call del_file(filename(:l)//'.1')
         endif
         call rename_file(filename(:l),filename(:l)//'.1',err)
		 if ( err ) call del_file(filename)
      endif

!     get the current time to be used as the test time
      call get_date()

!      call getlog(tempname)

      open(UNIT=lu8,FILE=filename(:l),STATUS='NEW',IOSTAT=ierr)


      if ( ierr .ne. 0 ) then
         message = 'Unable to open '//filename(:l)
         call ftn_logmsg_err("fat_icrec",message)
         ficrecfl = 3   !error recording
      else
         write(lu8,10) '# Written by: '//username(:lrbl(username))
         write(lu8,10) '# DATE: '//chdate
         write(lu8,10) '# TIME: '//chtime
         write(lu8,10) '#'

!>       If manual test note so in data file
         if ( fatman ) write(lu8,10) 'Manual Test'

         write(lu8,10) '#'
         write(lu8,10) 'Start IC'

         do i =1,ficotnum
!  in my moving things around we seem to have lost track of which ic variables need to
!  be output.  Easier to refigure output here than to debug. 
		      do jjj = 1, 100  ! line added
			     if (ficsimvar(jjj)(1:30) .eq. ficoutvar(i)(1:30)) then  !line added
                    x = logdata(jjj)  ! jjj was i
                    write(lu8,'(A,F13.4)') ficsimvar(jjj)(:lrbl(ficsimvar(jjj))),x ! jjj was i
				 end if  ! added
			  enddo !added
         enddo

         write(lu8,10) 'End IC'
         write(lu8,10) '# '
         write(lu8,10) '# '

         ficrecfl = 2   !recording done and OK
      endif

10	format(A)
! 14   format('# ',A14,2x,A10,2x,I5)

      return
      end
