! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_datarec
!    DESCRIPTION     : non-real-time simulation data recorder.
!    PACKAGE         : autotest
!    RATE            : NRT
!    ORIGINATOR      : Flight Data Library
!    DATE            : 12/12/98
!    ENGINEER        : M Saladin
!    SYSTEM          : IOS Autotest

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1991 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
!--> REVISION BEGIN

!                            Revision History

! $Id: fat_datarec.f,v 1.2 1999/02/18 13:46:52 saladinm Exp $
! $Log: fat_datarec.f,v $
! Revision 1.2  1999/02/18 13:46:52  saladinm
! Added manual test .man file output.

! Revision 1.1  1999/02/03 21:51:51  saladinm
! Initial revision

! Revision 1.1  1998/12/16 21:29:18  saladinm
! Initial revision for new autotest system

! --> REVISION END
! ****************************************************************************
! ****************************************************************************
!.mp  .TH fat_datarec l fsi
!.mp  .SH NAME
!.mp  fat_datarec \- Non-real-time simulation data recording support. (fsi)
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp   none
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp  Several request for data are made during the autotest and snapshot
!.mp  phases of the simulation.  It is necessary to read or write this data
!.mp  in a non-real-time mode.  This module supports the recording of
!.mp  simulator data.
!.mp
!.mp
!.mp  Snapshot data is handled in the F__rec.f module where the variable
!.mp  fsnap is set to one indicating a snapshot point.  This variable is
!.mp  automatically added to the list of recorded variables.
!.mp
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************

!      subroutine fat_datarec(frecbuff, frecnumb, frecframe, & 
!        frecval,     fatman, zflapr, zflsyr,   zfltor, fplotman,fattask)
	subroutine fat_datarec(frecbuff, frecnumb, frecframe, & 
        frecval,     fatman,fplotman)

      implicit none
      character*80  rcsid & 
      /"$Id: fat_datarec.f,v 1.2 1999/02/18 13:46:52 saladinm Exp $"/

!      logical*4   zflapr            !ref sys toggled apr iaf reposition
!      logical*4   zflsyr            !ref sys system reset
!      logical*4   zfltor            !ref ios toggled t/o point reposition
      logical*4   fatman            !ref 113 Manual test flag
      logical*4   fplotman          !ref 113 Plot manual data (.man file)

!      integer*4   fattask           !ref 113 autotest task
      integer*4   frecval           !ref rec program pointer
      integer*4   frecnumb          !ref rec number variables to record
      integer*4   frecframe         !ref rec Number of frames written

      real*4      frecbuff(100000)  !ref data recording buffer


! ******************************************************************

!                  local variables & data

! ******************************************************************

      include "flt_plot.inc"

!      logical*4 firstpass /.true./ !Firstpass flag
      logical*4 fileopen           !Is .sim file open flag
      logical*4 simman  /.false./  !Is test a manual test - fatman gets reset
	  logical*4 err                !Error from rename_file calls

      integer*4 i,j,l              !temporary loop index
      integer*4 lu8    /8/         !Logical unit for .sim file
      integer*4 ist                !io status
      integer*4 istatot            !sum of multiple istatus

      character*256 message        !temp storage
      character*256 filename       !filename
      character*256 tempname       !Temp string used to build filename
      

!>    External functions
      integer*4   lrbl             !Returns index of first blank from left
      integer*4   itmp

!      if ( firstpass ) then
!         firstpass = .false.
!         simman    = .false.
!         return
!      endif


!> if system reset selected, cancel recording unless time time to write data.


!      if ( zflsyr .or. zfltor .or. zflapr ) then 
!         if (frecval .eq. 1) frecval=0
!      endif

! * Save manual test flag
!      if ( fattask .gt. 3 .and. fatman  ) then
!         simman = .true. 
!      elseif ( fattask .eq. 5 ) then
!         simman = .false.
!      endif

!      if ( frecval .ne. 2 ) return

!>    *.sim file opened in fat_icrec - verify that it's still open
      inquire(lu8,OPENED=fileopen)

      if ( .not. fileopen ) then
         message = 'Error in recording order. File *.sim not opened'
         call ftn_logmsg_err("fat_datarec",message)
         frecval = 0
         return
      endif
      istatot = 0


	simman = fatman

! * Flag as manual test
      if ( simman ) then 
         write(lu8,10) '#'
         write(lu8,10) 'Manual Test'
         write(lu8,10) '#'
      endif

!>#   Write time based data to .sim file
      write(lu8,10,IOSTAT=ist) 'Start Data'

      if ( ist .ne. 0 ) istatot = istatot + 1

      write(lu8,'(A,I5)',IOSTAT=ist) & 
                        fsimvar(1)(:lrbl(fsimvar(1))),frecframe

      do i=1,frecnumb
         write(lu8,'(6(G11.5,2x))',IOSTAT=ist) & 
                    (frecbuff((j-1)*frecnumb + i),j=1,frecframe)

         if ( ist .ne. 0 ) istatot = istatot + 1

         if ( i .lt. frecnumb ) then  !Write next variable name
            write(lu8,10,IOSTAT=ist) fsimvar(i+1)(:lrbl(fsimvar(i+1)))
            if ( ist .ne. 0 ) istatot = istatot + 1
         endif

      enddo

      write(lu8,10) 'End Data'

      close(lu8)

      if ( istatot .ne. 0 ) then !There was an error writing data
         frecval = 4
         message = 'Error writing data to .sim file'
         call ftn_logmsg_err("fat_datarec",message)
      else
! *  If manual test move .sim file to .man and move .sim.1 back to .sim        
         frecval = 3
		 fplotman = .false.
         if ( simman ) then
            tempname = ftestname(:lrbl(ftestname))
            call pathfile(filename,fpath,tempname(:lrbl(tempname)))
            l=lrbl(filename)
			call rename_file(filename(:l)//'.sim',filename(:l)//'.man',err)
			if ( err ) then
				message = 'Error renaming .sim file to .man file'
				call ftn_logmsg_err("fat_datarec",message)
			else
				call rename_file(filename(:l)//'.sim.1',filename(:l)//'.sim',err)
	            fplotman = .true.
			endif
         endif
      endif


      return
 10   format(a)
      end




