! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!
!    SIMULATOR       : JPATS
!    JOB             : all
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : fat_control
!    DESCRIPTION     : JPATS Autotest master controler
!    PACKAGE         : autotest
!    RATE            : 15 Hz - called by IOS
!    ORIGINATOR      : Flight Data Library
!    DATE            : 1/10/01
!    ENGINEER        : H Landmann
!    SYSTEM          : IOS Autotest
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!  This package monitors the IOS autotest input page and the autotest status
!  of the host.  When a test is requested via the IOS this routine activates
!  getdata.exe which finds the required test instruction files and formats them
!  for the host autotest.  It then activates the host autotest controller via
!  the testactive flag.  When the host completes running the test it sends back
!  a test complete signal (fatstat = 5) and writes two files containing the trim
!  summary data and the time history data.  This package then activates the 
!  Jpatsplot routine which reads the files returned by the host and formats the
!  data for postscript.
!
! ****************************************************************************

	subroutine fat_control()
! following line is a compiler directive; not a comment
!DEC$ ATTRIBUTES DLLEXPORT::fat_control

	implicit none
	
 	integer*4	fattest		    	!autotest test number
  	logical*4	fatman			!Manual test flag not used - left in just in case
	character*128	message			!Message line
!	IOS Interface variables
	Integer*4	fatbatch		!Number of test in batch - From IOS
	logical*4	fatbcancel		!Cancel batch running - From IOS
	logical*4	fatcancel		!Cancel running test - From IOS
	integer*4   fatrun			!Ios input test number
	integer*4	fatbfile		!IOS demanded batch file

!	HOST Interface variables
	logical*4	fatforce		!Force test past hung stabilization - TO HOST
	logical*4	testactive /.false./    !Test is active and running - TO HOST
	integer*4	fatstat			!Test Status - FROM HOST
   	logical*4   valid /.false./
	logical*4   exist /.false./

!	Locals
	logical*4	batchactive		!Batch is running
   	character*12    cname
	integer*4	i /0/			!Loop
   	integer*4	ii /0/			!Loop
	integer*4   j /0/           !loop
	integer*4   k /0/			!Loop
	integer*4   itest
	integer*4	fmaxbatch	    !Number of tests to run in batch mode
	real*4		temp			!Temp
	integer*4   c(4)
	character*4     testid
	character*24    filename
	integer*4   itemp
	integer*2   ires
	logical*4   batch
	integer*4   lu27 /27/           !logical unit for test index file
	integer*4   istatus
	integer*4   next_test(125)      ! array of tests in batch que
	real*4      next_test_time(125)
	real*4      batchtime /0.0/
	integer*4   batchfile(20,10) &  ! groups of tests for batch 
	     /101,    102,   103,   111,   112,   113,   114,   121,   122,   123,   124,   125,   131,   132,   133,   141,   142,   145,   146,   0, & ! 1
          221,    222,   241,   242,   243,  15*0, &   ! 2
          301,    302,   303,   304,   305,   306,   311,   312,   313,   321,   322,   323,   8*0, & ! 3
          401,    411,   412,   421,   422,   431,   432,   441,   442,   443,   451,   452,   461,   462,   463,   464,   465,   3*0, & ! 4
          471,    472,   473,   474,   481,   482,   483,   484,   491,   492,  10*0, &  !5
	      501,    502,   503,   504,   511,   521,   531,   532,   541,   542,   543,   544,   8*0, & !6
	      601,    602,   611,  17*0, & !7
	      911,    912,   913,   914,   915,   921,   922,   923,   924,   925,   926,   927,   928,  7*0, & !8
	     1001,   1002,  1003,  1004,  1005,  1006,  1007,  1008,  1009,  1010,  10*0, & !9
	     1011,   1012,  1013,  1014,  1015,  1016,  1017,  1018,  12*0 /!10
	real*4		batchtimefile(20,10) &  ! Estimated time
		/ 2.0,    2.0,   2.0,   2.5,   2.5,   2.5,   2.7,   6.0,  10.0,  10.0,  10.0,   9.0,   2.5,   2.7,   3.2,   2.5,   2.3,   3.7,   3.7,  0.0, & ! 1 
		 28.0,   25.0,   3.0,   3.0,   3.0,  15*0.0, &   ! 2
		  2.0,    2.0,   2.0,   2.0,   2.0,   2.0,   2.0,   2.0,   2.0,   2.0,   2.0,   2.0,  8*0.0, & ! 3
		  2.3,    2.5,   2.7,   2.5,   2.6,   2.5,   2.5,   2.2,   2.2,   2.2,   2.3,   2.2,  11.0,  11.0,   9.0,   2.0,   8.0,	3*0.0, & ! 4
		  9.0,    5.3,   4.0,   8.7,   3.3,   3.2,   2.7,   2.5,   6.3,   2.2,  10*0.0, &  !5
		  2.1,    2.1,   2.6,   2.1,   2.3,   2.2,   2.3,   2.5,   3.7,   3.5,   4.0,   3.5,  8*0.0, & !6	
		  2.5,    2.7,   2.7, 17*0.0, & !7
		  4.0,    2.5,   2.5,   2.5,   2.5,   6.0,   6.0,   4.0,   4.0,   4.0,   4.0,   4.0,   4.0, 7*0.0, & !8
		  3.7,    3.7,   2.7,   3.7,   3.0,   2.5,  27.0,  25.0,   2.2,   2.2, 10*0.0, & !9
		  2.2,    2.2,   2.2,   2.2,   2.2,   2.2,   2.7,   3.2, 12*0.0 /!10

   	integer*4	count  /0/  ! time delay counter
	integer*4   count1 /0/  ! time delay counter
	integer*4   delay_timer /30/ ! time delay counter before get_data.exe is executed
!	Externals
 	integer*4	gethostint	!Get an integer from the host
 	real*4		gethostreal	!Get a real value from the host

!   test status (phase) from the HOST
    fatstat    = gethostint('fatstat')
!	Inputs from the IOS
	fatrun     = gethostint('fatrun')    ! run this test
	fatcancel  = gethostint('fatcancel') ! abort test
	fatbcancel = gethostint('fatbcancel')! cancel batch mode
   	fatbfile   = gethostint('fatbfile')  ! batch file selected

!	Inputs from IOS but got to host
 	fatman     = gethostint('fatman')    ! run test in manual mode

!   check for valid input test number
    if (fatrun .ge. 99) then
	   if (.not. valid) then
	      rewind(lu27)
	      open(lu27,FILE='d:/data/test_index.dat',IOSTAT=istatus)
	      do while ( istatus .eq. 0 )
             read(lu27,*,IOSTAT=istatus) itest,cname
             if ( itest .eq. fatrun ) then      !Found desired test number
                istatus = 1
                valid = .true.	
    	        fatrun = 0
	            call sethostint('fatrun',fatrun)	
             endif
          enddo
	      if (.not. valid) then
	         fatrun = 0
	         itest = 0
          end if
   	   end if
   	   close(lu27)
    end if
	 
!   Test currently running
  
    if ( testactive ) then    ! a test is running
       if (valid) then        ! a test was entered via ios while runnung
          batch = .true.      ! add the test to the batch array
          ii = ii+1           ! increment number of test to run
		  if (ii .gt. 125) then
		    ii = 125
		  end if
          next_test(ii) = itest
		  next_test_time(ii) = 5.0
		  fatrun = ii
		  valid = .false.
		  fatbatch = ii
		  call sethostint('fatbatch',fatbatch)
		  batchtime = batchtime + next_test_time(ii)
		  call sethostreal('batchtime',batchtime)
       end if
       if ( fatstat .eq. 5 ) then  !Test finished Successfullly
! allow time for host to complete writing output files
		  count1 = count1 + 1
		  if (count1 .eq. 60) then
            fatman   = .false.
            fatforce = .false.
            call sethostint('fatman',fatman)
            call sethostint('fatforce',fatforce)
            fatrun = 0
            call sethostint('fatrun',fatrun)
            message = 'start /min jpatsplot.exe '// testid 
            call system(message)
            testactive = .false.
            call sethostint('testactive',testactive)
		    count1 = 0
			
		  end if
       end if
!No test is currently running (testactive = false)
    else  !  See if a test is pending either from IOS or batch
		if (batch) then 
			delay_timer = 90
		else
			delay_timer = 30
		end if
       if (valid .or. batch .or. ((count .ge. 1) .and. (count .le. delay_timer))) then
	      count = count + 1
          ! in batch mode we need a few seconds for jpatsplot to close some files
		  ! from the previous test
		  ! use same delay for input mode as well to simplify program logic
          if (count .eq. delay_timer) then
		    if (valid) then   ! test from IOS
               fattest = itest
			   fatrun = 0
			   valid = .false.	
            else                     ! new test is from batch que. wait a few seconds before starting next test
                fattest   = next_test(ii) ! to allow plot routines to complete  
				batchtime = batchtime - next_test_time(ii)    
				ii = ii-1               ! decrement batch counter
                
                if (ii .eq. 0) then     ! last batch test
                   	batch = .false.
			        fatbatch = ii
					batchtime = 0.0
                end if
				fatbatch = ii
		        call sethostint('fatbatch',fatbatch)
				call sethostreal('batchtime',batchtime)
            end if
			! fattest (test id) is an integer, convert to string
		    c(1) =fattest - 1000  ! isolate digits
            if (c(1) .le. 0) then  ! 3 digits
                c(1) = 0
                c(2) = fattest/100
                itemp = fattest - c(2) * 100
                c(3) = itemp/10
                c(4) = itemp - c(3) * 10
            else   ! four digits
                c(1) = fattest/1000
                itemp = fattest - c(1) * 1000
                c(2) = itemp/100
                itemp = itemp - c(2) * 100
				c(3) = itemp/10
				c(4) = itemp - c(3) * 10
            end if
            do i = 1,4    ! digits to character string
                ires = 48 + c(i)
                testid(i:i) = char(ires)
            end do

			!  start background routine to set up ic and time history files	
            message = 'start /min getdata.exe '// testid 
            call system(message)
			if (batch) then 
				delay_timer = 90
			else
				delay_timer = 30
			end if
	    	count = delay_timer + 1
		  end if   ! end if count = delay_timer
       end if   ! end valid, batch,   1> count > delay timer
	   if (count .ge. (delay_timer + 1)) then
			count = count + 1
			!  tell host to run test
			if (count .ge. (delay_timer + 30)) then	
               testactive = .true.  
               call sethostint('testactive',testactive) 
!               fatrun = ii
               fatforce = .false.
               call sethostint('fatforce',fatforce) ! reset trim bypass
               call sethostint('fatrun',fatrun)     ! IOS will display no remaining
               call sethostint('fattest',fattest)   ! IOS will display current test
               count = 0
			end if
       end if  ! count > delay_timer +1
    end if ! end if active

    if (fatbfile .gt. 0) then  ! load array of batch tests  
       batch = .true.
       k = 1
       do while (batchfile(k,fatbfile) .gt. 1)
          ii = ii+1
		  if (ii .gt. 125) then
		    ii = 125
		  end if
          next_test(ii)      = batchfile(k,fatbfile)
		  next_test_time(ii) = batchtimefile(k,fatbfile)
		  batchtime          = batchtime + batchtimefile(k,fatbfile)
          k = k + 1          
       end do
	   fatbatch = ii
	   call sethostint('fatbatch',fatbatch)
	   call sethostreal('batchtime',batchtime)
       fatbfile = 0  ! reset batch array
       call sethostint('fatbfile',fatbfile)! cancel ios input
    end if
	if (fatcancel) then  ! cancel test
          testactive = .false.
          call sethostint('testactive',testactive)
          fatcancel = .false.
          call sethostint('fatcancel',fatcancel)
          fatrun = 0
          call sethostint('fatrun',fatrun)
		  count = 0
    end if
    if (fatbcancel) then  ! cancel batch mode
      batch = .false.
      ii = 0
	  fatrun = ii
	  call sethostint('fatrun',fatrun)
	  fatbcancel = .false.
	  count = 0  ! protect against cancellation during test setup
      call sethostint('fatbcancel',fatbcancel)
	  fatbatch = ii
	  call sethostint('fatbatch',fatbatch)
	  batchtime = 0.0
	  call sethostreal('batchtime',batchtime)
	  testactive = .false.
      call sethostint('testactive',testactive)
      fatcancel = .false.
      call sethostint('fatcancel',fatcancel)
      fatrun = 0
      call sethostint('fatrun',fatrun)
    end if
	return
end

	  integer function lrbl(string)

      character*(*) string

      i = len(string)
      j = 1

      do while( string(j:j) .gt. ' ' .and. j .le. i)
         j=j+1
      enddo

      lrbl = j-1
      return
      end

	subroutine pathfile(answer,path,file)

      character*(*) answer
      character*(*) path
      character*(*) file
      integer       lrbl

      answer = ' '
      answer = path(:lrbl(path))// '\' //file(:lrbl(file))

      return
      end
	subroutine del_file(file)

	USE DFLIB

	implicit none

	character*(*)    file        !file name

	logical*4        error       !Error executine command

	error = delfilesqq(file)


	return
	end

    integer function rlan(string)

      character*(*) string

      i = len(string)
      j = i

      do while( string(j:j) .le. ' ' .and. j .ge. 1)
         j=j-1
      enddo

      rlan = j

      return
      end

