! **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :  STANDARD                                *
!      Department        :  61 - flight                             *
!      Module name       :  flt_write_ics                           *
!      Module description:  This module writes IC data to a file    *
!      Originator        :  M. Saladin                              *
!      Date              :   2/22/99                                *
!                                                                   *
!                                                                   *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of FlightSafety International Simulation        *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!            FlightSafety International                             *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012, U.S.A.                  *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **

      subroutine flt_write_ics(file,vararr,icdata,iciout,num,istdf, & 
                               error)
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_write_ics.f,v 1.3 2000/03/13 22:24:37 saladinm Exp $
! $Log: flt_write_ics.f,v $
! Revision 1.3  2000/03/13 22:24:37  saladinm
! Added write_ics_all routine.

! Revision 1.2  2000/02/14 16:23:51  saladinm
! DR/MACAR:     None
! Problem:      IC's not being written in same order that they appear on the
!               output page after using flt or data reduction.
! Conclusion:   Not implemented.
! Resolution:   Added code to map the IC input variables and then to sort
!               them so the output in the tdf file will match that on the
!               hardcopy page.
! Dependencies: flt_utl.f
! Engineer:     Mike Saladin

! Revision 1.1  1999/03/02 20:54:08  saladinm
! Initial revision

! Revision 1.1  1999/02/24 19:34:53  saladinm
! Initial revision


!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_write_ics.f,v 1.3 2000/03/13 22:24:37 saladinm Exp $"/

      include "flt_plot.inc"

! * Argument list
      character*132 file             !ACD file name
      character*80  icdata(ndimic)   !Character representation of ic data
      character*64  vararr(ndimic)   !Variables to search for

      integer*4     num              !Number of variables to search for
      integer*4     iciout(ndimic)   !IO output flag if istdf true

      logical*4     istdf            !Output file Is a tdf file
      logical*4     error            !Return error flag

! * Locals

      integer*4     i,j,k
      integer*4     lu18   /18/      !Unit for input file
      integer*4     lf               !Length of file name
      integer*4     imx              !Max length of variable name
      integer*4     ist              !IOSTAT flag

! * Define needed variables
      include "flt_read_vars.inc"

      error = .false.

      lf = lrbl(file)
 	  call rename_file(file(:lf),file(:lf)//'.old',error)
      open(lu19,FILE=file,STATUS='NEW',IOSTAT=ist)
      if ( ist .ne. 0 .or. error ) then
         write(*,*)  'UNABLE TO OPEN '// file(:lf)
         write(*,*) 'No changes made'
 	     call rename_file(file(:lf)//'.old',file(:lf),error)
         error = .true.
         return
      endif
	
	   

      open(lu18,FILE=file(:lf)//'.old',IOSTAT=i) 
      if ( i .ne. 0 ) then
         write(*,*) 'UNABLE TO OPEN '//file(:lf)//'.old'
         write(*,*) 'No changes made'
         error = .true.
         return
      endif


! * Find amx length of variables for nice looking output
      imx = 0
      do i=1,num               !update the max char length for output
         j = lrbl(vararr(i))
         if ( j .gt. imx ) imx = j
      enddo

! * Read Old data down to start ic and write to output file
      i = 0
      k = 0
      do while ( ( i .eq. 0 .or. k .eq. 0 ) & 
           .and. ist .eq. 0 ) 
         read(lu18,10,IOSTAT=ist) line
         lowline = line
         call lower(lowline,132)
         i = index(lowline,'start')
         k = index(lowline,'ic')
         write(lu19,10) line(:rlan(line)) !Echo data
      enddo

! *   Create index array so data is in proper order in file      
      call read_icmap(ic_set,ic_out,numic,err)
      call conv_ic(vararr,num,tempic,ic_set,ic_out,numic)
      call get_labels(tempic,num,ndimic,templab,icorder,ndimic,2, & 
           .false.,err)
! * Write new data to output file
      if ( istdf ) then
         do i=1,num              
            write(lu19,50) vararr(icorder(i))(:imx), & 
                 icdata(icorder(i))(:rlan(icdata(icorder(i)))), & 
                 iciout(icorder(i))
         enddo
      else
         do i=1,num              
            write(lu19,40) vararr(icorder(i))(:imx), & 
                 icdata(icorder(i))(:rlan(icdata(icorder(i))))
         enddo
      endif


! * Read Old IC data and discard
      i=0
      do while ( i .eq. 0 .and. ist .eq. 0 )
         read(lu18,10,IOSTAT=ist) line
         lowline = line
         call lower(lowline,132)
         i = index(lowline,'end') !read to end of ic
      enddo

      write(lu19,10) line(:rlan(line)) !Write ic end to file

! * Read rest of Old data and output to file      
      read(lu18,10,IOSTAT=ist) line
      do while ( ist .eq. 0 )
         write(lu19,10) line(:rlan(line)) !Echo data 
         read(lu18,10,IOSTAT=ist) line
      enddo



      close(lu19)               !close testdef.tdf
      close(lu18)               !close testdef.tdf.old


 10   format(a)
 40   format(3x,a,' ',a20,4x,i1)
 50   format(3x,a,' = ',a20,4x,i1)

      return
      end



! ************************************************************************
!   This subroutine writes the IC data section at the top of ACD files.
!   It is called by mod_ictime (flt_modfile).

! ************************************************************************

      subroutine write_ics_all(file,vararr,icdata,num,time,error)
      implicit none


! * Argument list
      character*132 file             !ACD file name
      character*64  vararr(200)      !Variables to search for

      real*4        icdata(200)      !IC data
      real*4        time             !Time for data

      integer*4     num              !Number of variables to search for

      logical*4     error            !Return error flag

! * Locals

      integer*4     i,j,k
      integer*4     lu18   /18/      !Unit for input file
      integer*4     lf               !Length of file name
      integer*4     imx              !Max length of variable name
      integer*4     ist              !IOSTAT flag

! * Define needed variables
      include "flt_plot.inc"
      include "flt_read_vars.inc"

      error = .false.

      lf = lrbl(file)
	  call rename_file(file(:lf),file(:lf)//'.old',error)
      open(lu19,FILE=file,IOSTAT=ist)
      if ( ist .ne. 0 .or. error ) then
         write(*,*)  'UNABLE TO OPEN '// file(:lf)
         write(*,*) 'No changes made'
         call rename_file(file(:lf)//'.old',file(:lf),error)
         error = .true.
         return
      endif

      open(lu18,FILE=file(:lf)//'.old',IOSTAT=i) 
      if ( i .ne. 0 ) then
         write(*,*) 'UNABLE TO OPEN '//file(:lf)//'.old'
         write(*,*) 'No changes made'
         error = .true.
         return
      endif


! * Find amx length of variables for nice looking output
      imx = 0
      do i=1,num               !update the max char length for output
         j = lrbl(vararr(i))
         if ( j .gt. imx ) imx = j
      enddo

! * Read Old data down to start ic and write to output file
      i = 0
      k = 0
      do while ( ( i .eq. 0 .or. k .eq. 0 ) & 
           .and. ist .eq. 0 ) 
         read(lu18,10,IOSTAT=ist) line
         lowline = line
         call lower(lowline,132)
         i = index(lowline,'start')
         k = index(lowline,'ic')
         if ( time .gt. 0 .and. k+i .gt. 1 ) then
            write(lu19,20,IOSTAT=ist) '# IC Time = ',time, & 
                 'Modified By: '//username// ' On: '//chdate//chtime
         endif
         write(lu19,10,IOSTAT=ist) line(:rlan(line)) !Echo start IC
         if ( ist .ne. 0 ) error = .true.
      enddo

      do i=1,num              
         write(lu19,40,IOSTAT=ist) vararr(i)(:imx),icdata(i)
         if ( ist .ne. 0 ) error = .true.
      enddo


! * Read Old IC data and discard
      i=0
      do while ( i .eq. 0 .and. ist .eq. 0 )
         read(lu18,10,IOSTAT=ist) line
         lowline = line
         call lower(lowline,132)
         i = index(lowline,'end') !read to end of ic
      enddo

      write(lu19,10) line(:rlan(line)) !Write ic end to file

! * Read rest of Old data and output to file      
      read(lu18,10,IOSTAT=ist) line
      do while ( ist .eq. 0 )
         write(lu19,10,IOSTAT=ist) line(:rlan(line)) !Echo data 
         if ( ist .ne. 0 ) error = .true.
         read(lu18,10,IOSTAT=ist) line
      enddo

      close(lu19)               !close testdef.tdf
      close(lu18)               !close testdef.tdf.old

      if ( error ) then
         write(*,*) 'Error writing data to: '//file(:lf)
         write(*,*) 'Restoring orginal version of file.'
         call rename_file(file(:lf)//'.old',file(:lf),error)
      endif



 10   format(a)
 20   format(a,g11.5,a)
 40   format(3x,a,' ',G11.5)
 50   format(3x,a,' = ',a20,4x,i1)

      return
      end



