      subroutine UTILITY
! ******************************************************************
!                                                                  *
!                  FLIGHT GROUP UTILITY PROGRAM                    *
!                                                                  *
!     THIS PROGRAM REPRESENTS A COLLECTION OF FREQUENTLY USED      *
!     CONVERSIONS. THE ROUTINES CONTAINED HERE ALSO APPEAR AS      *
!     PARTS OF LARGER PROGRAMS, BUT ARE SEPARATED OUT FOR          *
!     THEIR UTILITY VALUE.                                         *
!                                                                  *
!                                                                  *
!     WRITTEN BY: RAY WOODSON           DATE: 10-20-82             *
!     REVISED BY: MATHEW KNEISLER       DATE: 08-04-93             *
!                                                                  *
!                                                                  *
! ******************************************************************


!--> REVISION BEGIN

!                            Revision History

! $Id: flt_utility.f,v 1.3 1998/09/08 20:43:35 vdemeter Exp $
! $Log: flt_utility.f,v $
! Revision 1.3  1998/09/08 20:43:35  vdemeter
! Updated from 8420

! Revision 1.3  1998/01/27 17:44:38  vdemeter
! Updated from 7504

! Revision 1.1  1997/06/27 16:18:05  vdemeter
! Initial revision

! Revision 1.3  1997/05/21 12:37:08  vdemeter
! flt_utility.f Initial release from automated d61master process

! Revision 1.1  1996/01/19 22:13:43  mattk
! Initial revision

!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_utility.f,v 1.3 1998/09/08 20:43:35 vdemeter Exp $"/


      character*1 ans
      DIMENSION NOPT(4,2),LOPT(4,2)

      INTEGER*4 CLEAR,HOME,BEL
      DATA           CLEAR    /Z'1b5b324a'/
      DATA           HOME     /Z'0c1b5b48'/
      DATA           BEL      /Z'20202007'/

      REAL*8 ALT,VAL(4),STDTEMP,THETA,THETA1,DELTA,SIGMA,SIGMA1, & 
      T0(2),TABS(2),CONST(2),GAMMA, & 
      VSOUND,VSOUND1,TEMP,DELTISA,VKCAS,VKTAS,MACH,PROC,TROC,GRAD


      CHARACTER*30 OPT(4)
      CHARACTER*1 TTYPE(2)

      DATA TTYPE/'C','F'/
      DATA T0,TABS,CONST/288.16,518.69,273.16, & 
      459.69,38.96,29.04/,TROPO/36089./,A0/661.5/
      DATA OPT/'1) ALTITUDE','2) DELTA ISA OR TEMPERATURE', & 
      '3) MACH NO. OR AIRSPEED','4) RATE OF CLIMB OR GRADIENT'/
      DATA NOPT,LOPT/5*4,17,2*4,11,12,23,28,11,27,23,28/

      K=0
      IPRINT=1
      IFIRST=0
      ITEMP=0
      ISPEED=0
      ICLIMB=0
      LINE=0

    5 WRITE(*,1005)BEL
      WRITE(*,1005) CLEAR,HOME

      WRITE(*,1000)

! *************************
!     CHOOSE OPTION       *
! *************************

   10 WRITE(*,1001)
      READ(*,*)IOPT

   20 WRITE(*,1005)BEL
      WRITE(*,1005) CLEAR,HOME

      WRITE(*,1002) IOPT,(OPT(I),I=1,IOPT)
      IF(IFIRST)25,25,30

! ********************************************
!     CHOOSE TEMPERATURE DATA ( C OR F )     *
! ********************************************

   25 WRITE(*,1003)
      K=0
      READ(*,1020)ans
      call upper(ans,1)
      IF(ans.EQ.'F') K=2
      IF(ans.EQ.'C') K=1
      CONTINUE
      IF(K)25,25,30
   30 CONTINUE
      IF(IFIRST)35,35,40

! *******************************
!     CHOOSE PRINTER OUTPUT     *
! *******************************

   35 WRITE(*,1004)
      IPRINT=1
      READ(*,1020) ANS
      call upper(ans,1)
      IF(ANS.EQ.'N') IPRINT=0
      WRITE(*,1005)BEL
      WRITE(*,1005)CLEAR,HOME
   40 CONTINUE
      IF(IFIRST-1)50,45,50
   45 WRITE(*,1006)
   50 CONTINUE
      WRITE(*,1005) CLEAR,HOME
      DO 90 I=1,IOPT
      IF(IFIRST) 55,55,85
   55 IF(I-2)65,60,65

! ********************************************
!     CHOOSE ALTERNATIVE TEMPERATURE DATA    *
!                                            *
!           DELTA ISA OR TEMPERATURE         *
! ********************************************

   60 WRITE(*,1008)
      ITEMP=0
      READ(*,1020)ANS
      call upper(ans,1)
      IF(ANS.EQ.'T')ITEMP=1
   65 IF(I-3)75,70,75

! ******************************
!     CHOOSE AIRSPEED DATA     *
!                              *
!          CAS OR TAS          *
! ******************************

   70 WRITE(*,1009)
      ISPEED=0
      READ(*,1020)ANS
      call upper(ans,1)
      IF(ANS.EQ.'T')ISPEED=1
   75 IF(I-4)85,80,85

! ************************************************
!     CHOOSE RATE OF CLIMB ALTERNATIVE DATA      *
!                                                *
!             GEOMETRIC OR PRESSURE              *
! ************************************************

   80 WRITE(*,1010)
      ICLIMB=0
      READ(*,1020)ANS
      call upper(ans,1)
      IF(ANS.EQ.'P')ICLIMB=1
   85 WRITE(*,1007)OPT(I)(NOPT(I,ITEMP+1):LOPT(I,ITEMP+1))
      READ(*,'(f12.5)') val(i)
 90   continue
      WRITE(*,1005)BEL
      WRITE(*,1005)CLEAR,HOME

! **************************************
!     ALTITUDE DATA (OPTIONS 1-4)      *
! **************************************

      ALT=VAL(1)
      IF(ALT-TROPO)95,95,100

! ***********************
!     STRATOSPHERE      *
! ***********************

   95 THETA=1-6.875E-6*ALT
      DELTA=THETA**5.2561
      GOTO105

! ********************
!     TROPOPAUSE     *
! ********************

  100 THETA=.7519
      DELTA=.223359*EXP((TROPO-ALT)/20806.7)
  105 TISA=T0(K)*THETA
      SIGMA=DELTA/THETA
      STDTEMP=TISA-TABS(K)
      VSOUND=CONST(K)*SQRT(TISA)
      IF(IOPT-1)215,215,110

! *****************************************
!     TEMPERATURE DATA ( OPTIONS 2-4 )    *
! *****************************************

  110 IF(ITEMP)115,115,120
  115 DELTISA=VAL(2)
      TEMP=STDTEMP+DELTISA
      GOTO125
  120 TEMP=VAL(2)
      DELTISA=TEMP+TABS(K)-TISA
  125 VSOUND1=CONST(K)*SQRT(TEMP+TABS(K))
      THETA1=(TEMP+TABS(K))/T0(K)
      SIGMA1=DELTA/THETA1
      IF(IOPT-2)215,215,130

! **************************************
!     AIRSPEED DATA ( OPTIONS 3-4 )    *
! **************************************

  130 IF(VAL(3).LT.5.) GO TO 145
      IF(ISPEED.EQ.1) GO TO 140
      VKCAS=VAL(3)
      Q1=VKCAS/A0
      Q2=1./DELTA
      Q3=1.
      L=1
      GOTO160
  135 MACH=Q4
      VKTAS=VSOUND1*MACH
      GOTO165
  140 VKTAS=VAL(3)
      MACH=VKTAS/VSOUND1
      GOTO150
  145 MACH=VAL(3)
      VKTAS=VSOUND1*MACH
  150 Q1=MACH
      Q2=DELTA
      Q3=A0
      L=2
      GOTO160
  155 VKCAS=Q4
      GOTO165
  160 Q4=Q3*SQRT(5.*(((((1.+.2*Q1**2.)**3.5-1.)*Q2+1.)**.2857)-1.))
      GOTO(135,155),L
  165 Q=1481.*MACH**2.*DELTA
      IF(IOPT-3)215,215,170

! **********************************
!     CLIMB DATA ( OPTION 4 )      *
! **********************************

  170 IF(ABS(VAL(4)).LE.100.)GOTO195
  175 IF(ICLIMB)185,185,180
  180 PROC=VAL(4)
      TROC=PROC*(TEMP+TABS(K))/TISA
      GOTO190
  185 TROC=VAL(4)
      PROC=TROC*TISA/(TEMP+TABS(K))
  190 GRAD=TAN(ASIN(TROC/(101.28*VKTAS)))
      GOTO210
  195 GRAD=VAL(4)
      IF(ABS(GRAD)-1.)200,200,200
  200 GRAD=GRAD/100.
  205 TROC=101.28*VKTAS*SIN(ATAN(GRAD))
      PROC=TROC*TISA/(TEMP+TABS(K))
  210 GRAD=GRAD*100.
      GAMMA=57.3*ATAN(GRAD/100.)
!MFK  FACC=1+0.567*MACH*MACH
      FACC=1.-.014055*MACH+.656671*MACH*MACH-.214204*MACH*MACH*MACH
      CORTROC=TROC/FACC
      CORPROC=PROC/FACC
  215 GO TO(220,250,280,310),IOPT

! ******************************************************
!     OUTPUT SECTION FOR ALTITUDE DATA (OPTION 1)      *
! ******************************************************

  220 WRITE(*,1011)ALT,TTYPE(K),STDTEMP,THETA,DELTA,SIGMA,VSOUND
      IF(IPRINT)500,500,225
  225 IF(LINE) 230,230,235
  230 WRITE(7,1012) TTYPE(K)
  235 WRITE(7,1013)ALT,STDTEMP,THETA,DELTA,SIGMA,VSOUND
      LINE=LINE+1
      IF(LINE-50)245,245,240
  240 LINE=0
  245 GO TO 500

! ********************************************************
!     OUTPUT SECTION FOR TEMPERATURE DATA (OPTION 2)     *
! ********************************************************

  250 WRITE(*,1014) ALT,TTYPE(K),TEMP,TTYPE(K),DELTISA,THETA1,DELTA, & 
      SIGMA1,VSOUND1
      IF(IPRINT)500,500,255
  255 IF(LINE)260,260,265
  260 WRITE(7,1015)TTYPE(K),TTYPE(K)
  265 WRITE(7,1016)ALT,TEMP,DELTISA,THETA1,DELTA,SIGMA1,VSOUND1
      LINE=LINE+1
      IF(LINE-50)275,275,270
  270 LINE=0
  275 GO TO 500

! ****************************************************
!     OUTPUT SECTION FOR AIRSPEED DATA (OPTION 3)    *
! ****************************************************

  280 WRITE(*,1017)ALT,TTYPE(K),TEMP,TTYPE(K),DELTISA,VSOUND1,VKCAS, & 
      VKTAS,Q,MACH
      IF(IPRINT)500,500,285
  285 IF(LINE) 290,290,295
  290 WRITE(7,1018)TTYPE(K),TTYPE(K)
  295 WRITE(7,1019) ALT,TEMP,DELTISA,VSOUND1,VKCAS,VKTAS,Q,MACH
      LINE=LINE+1
      IF(LINE-50)305,305,300
  300 LINE=0
  305 GO TO 500

! **********************************************************
!     OUTPUT SECTION FOR RATE OF CLIMB DATA (OPTION 4)     *
! **********************************************************

  310 WRITE(*,1021)ALT,TTYPE(K),TEMP,TTYPE(K),DELTISA,VSOUND1,VKCAS, & 
      VKTAS,Q,MACH,PROC,TROC,CORPROC,CORTROC,GRAD,GAMMA
      IF(IPRINT)500,500,315
  315 IF(LINE)320,320,325
  320 WRITE(7,1022) TTYPE(K),TTYPE(K)
  325 WRITE(7,1023)ALT,TEMP,DELTISA,VSOUND1,VKCAS,VKTAS,Q,MACH,PROC, & 
      TROC,GRAD,GAMMA
      LINE=LINE+1
      IF(LINE-50)335,335,330
  330 LINE=0
  335 CONTINUE

! **********************************************************
!     SECTION FOR CHANGING OPTIONS OR INPUT DATA TYPE      *
! **********************************************************

  500 WRITE(*,1030)
      READ(*,1020)ANS
      call upper(ans,1)
      WRITE(*,1005)CLEAR,HOME
      IF(IFIRST)510,510,520
  510 WRITE(*,1024)
  520 WRITE(*,1025)
      READ(*,1020)ANS
      call upper(ans,1)
      IF(IFIRST.LT.2) IFIRST = IFIRST + 1
      IF(ANS.EQ.'E') GO TO 9000
      IF(ANS.EQ.' ') GO TO 50
      IF(ANS.EQ.'O') GO TO 600
      IF(ANS.EQ.'U') THEN
           K = 1 + IABS(K - 2)
           GOTO 90
      ELSE IF(ANS.EQ.'P') THEN
           IPRINT = IABS(IPRINT-1)
           GOTO 90
      ELSE IF(ANS.EQ.'S') THEN
           ISPEED = IABS(ISPEED - 1)
           GOTO 90
      ELSE IF(ANS.EQ.'C') THEN
           ICLIMB = IABS(ICLIMB - 1)
           GOTO 90
      ELSE IF(ANS.EQ.'T') THEN
           ITEMP = IABS(ITEMP - 1)
           GOTO 90
      ELSE
           GOTO 520
      END IF
  600 IFIRST = 0
      LINE = 0
      WRITE(*,1005)CLEAR,HOME
      WRITE(*,1050)
      READ(*,1020)ANS
      call upper(ans,1)
      IF(ANS.EQ.'Y')GO TO 5
      GO TO 10

! ******************
!     FORMATS      *
! ******************

 1000 FORMAT(5X,'THIS PROGRAM MAY BE USED TO PERFORM THE FOLLOWING:',//, & 
      5X,'1) CALCULATE ATMOSPHERIC PARAMETERS (THETA,DELTA,ISA,ETC.)',/, & 
      5X,'2) CONVERT    TEMPERATURE    <=>  DELTA ISA',/, & 
      5X,'3) CONVERT    MACH NUMBER    <=>  AIRSPEED ',/, & 
      5X,'4) CONVERT    RATE OF CLIMB  <=>  GRADIENT',//, & 
      5X,'THE USER SELECTS THE OPTION BY NUMBER,AND MAY CHANGE OPTION',/, & 
      5X,'AFTER ANY CALCULATION. INPUTS REQUIRED WILL INCLUDE THOSE',/, & 
      5X,'FOR PREVIOUS OPTION(S).[e.g. OPTION 3 WILL REQUIRE ALTITUDE',/, & 
      5X,'INPUT (OPTION 1) AND TEMPERATURE INPUT (OPTION 2).]',////)

 1001 FORMAT(5X,'WHICH OPTION DO YOU WISH TO USE? (1,2,3, OR 4)',/)


 1002 FORMAT(5X,'THE REQUIRED INPUTS FOR OPTION ',I1,' ARE',//, & 
      4(5X,a,/))

 1003 FORMAT(5X,'WHAT UNITS DO YOU WISH FOR TEMPERATURE I/O (C OR F)')

 1004 FORMAT(5X,'DO YOU WANT A PRINTOUT OF THE RESULTS?')

 1005 FORMAT(5X,2A4)

 1006 FORMAT(5X,'IN ORDER TO USE VALUES FROM PREVIOUS CALCULATIONS,',/ & 
      ,5X,'SIMPLY HIT "RETURN" WHEN INPUT IS REQUESTED')

 1007 FORMAT(5X,'WHAT IS THE ',a,' FOR CALCULATIONS',/)

 1008 FORMAT(5X,'INPUT TEMPERATURE DATA FOR OPTIONS 2,3 AND 4 ARE ',/ & 
      ,5X,'ASSUMED TO BE DELTA ISA. IF YOU WISH TO INPUT TEMPERATURE' & 
      ,/,5X,'INSTEAD, TYPE "T"  OTHERWISE "RETURN"',/)

 1009 FORMAT(5X,'INPUT AIRSPEEDS FOR OPTIONS 3 AND 4 ARE ASSUMED TO' & 
      ,/,5X,'BE CALIBRATED. IF YOU WISH TO INPUT TRUE AIRSPEED INSTEAD,' & 
      ,/,5X,'TYPE "T"  OTHERWISE "RETURN"',/)

 1010 FORMAT(5X,'INPUT RATES OF CLIMB FOR OPTION 4 ARE ASSUMED TO BE', & 
      /,5X,'GEOMETRIC. IF YOU WISH TO INPUT PRESSURE RATES OF CLIMB,', & 
      /,5X,'TYPE "P"  OTHERWISE "RETURN"',/)


 1011 FORMAT(5X,'ALTITUDE (FEET)          =',F10.0,/, & 
             5X,'TEMPERATURE (DEGREES ',a,')  =',F10.1,/, & 
             5X,'TEMPERATURE RATIO (THETA)=',F10.6,/, & 
             5X,'PRESSURE RATIO (DELTA)   =',F10.6,/, & 
             5X,'DENSITY RATIO (SIGMA)    =',F10.6,/, & 
             5X,'VELOCITY OF SOUND (KNOTS)=',F10.1,//)
 1012 FORMAT('1',3X,' ALTITUDE    TEMP       T/T0      P/P0    RHO/RHO0' & 
      ,'  V SOUND  ',/,4X,'  (FEET)   (DEG. ',A,')    (THETA)   (DELTA) & 
        (SIGMA)  (KNOTS)  ',//)
 1013 FORMAT(2X,F10.0,F10.1,2X,3F10.6,F8.1)


 1014 FORMAT(5X,'ALTITUDE (FEET)          =',F10.0,/, & 
             5X,'TEMPERATURE (DEGREES ',a,')  =',F10.1,/, & 
             5X,'DELTA ISA (DEGREES ',a,')    =',F10.0,/, & 
             5X,'TEMPERATURE RATIO (THETA)=',F10.6,/, & 
             5X,'PRESSURE RATIO (DELTA)   =',F10.6,/, & 
             5X,'DENSITY RATIO (SIGMA)    =',F10.6,/, & 
             5X,'VELOCITY OF SOUND (KNOTS)=',F10.1,//)
 1015 FORMAT('1',4X,'ALTITUDE    TEMP    DELTA ISA   T/T0      P/P0    ' & 
      ,'RHO/RHO0   V SOUND  ',/,4X,'  (FEET)   (DEG. ',a,')  ', & 
      '(DEG. ',a,')   (THETA)   (DELTA)   (SIGMA)   (KNOTS)  ',//)
 1016 FORMAT(2X,F10.0,F10.1,1X,F10.0,3F10.6,F9.1)


 1017 FORMAT(5X,'ALTITUDE (FEET)          =',F10.0,/, & 
             5X,'TEMPERATURE (DEGREES ',a,')  =',F10.1,/, & 
             5X,'DELTA ISA (DEGREES ',a,')    =',F10.0,/, & 
             5X,'VELOCITY OF SOUND (KNOTS)=',F10.1,/, & 
             5X,'AIRSPEED - ( KCAS )      =',F10.1,/, & 
             5X,'         - ( KTAS )      =',F10.1,/, & 
             5X,'DYNAMIC PRESSURE (PSF)   =',F10.1,/, & 
             5X,'MACH NUMBER              =',F10.4,//)
 1018 FORMAT('1',3X,' ALTITUDE    TEMP    DELTA ISA  V SOUND  ', & 
      '      AIRSPEED      DYN PRESS MACH NO. ',/, & 
      4X,'  (FEET)   (DEG. ', & 
      a,')   (DEG. ',a,')  (KNOTS)    (KCAS)    (KTAS)', & 
      '    (PSF)',/)
 1019 FORMAT(2X,F10.0,F10.1,F10.0,4F10.1,F10.4)


 1020 FORMAT(A1)


 1021 FORMAT(5X,'ALTITUDE (FEET)          =',F10.0,/, & 
             5X,'TEMPERATURE (DEGREES ',A,')  =',F10.1,/, & 
             5X,'DELTA ISA (DEGREES ',A,')    =',F10.0,/, & 
             5X,'VELOCITY OF SOUND (KNOTS)=',F10.1,/, & 
             5X,'AIRSPEED - ( KCAS )      =',F10.1,/, & 
             5X,'         - ( KTAS )      =',F10.1,/, & 
             5X,'DYNAMIC PRESSURE (PSF)   =',F10.1,/, & 
             5X,'MACH NUMBER              =',F10.4,/, & 
             5X,'UNACCEL ROC  -(PRESSURE) =',F10.0,/, & 
             5X,'   (FT/MIN)  -(GEOMETRIC)=',F10.0,/, & 
             5X,'ACCEL ROC    -(PRESSURE) =',F10.0,/, & 
             5X,'   (FT/MIN)  -(GEOMETRIC)=',F10.0,/, & 
             5X,'GRADIENT (FT/FT*100)     =',F10.2,/, & 
             5X,'CLIMB ANGLE (DEGREES)    =',F10.1,//)
 1022 FORMAT('1',3X,' ALTITUDE    TEMP    DELTA ISA  V SOUND ', & 
      '      AIRSPEED       DYN PRESS MACH NO.   ', & 
      'R/C (FT PER MIN) ','  GRADIENT','     GAMMA',/, & 
      4X,'  (FEET)   (DEG. ',A,')   (DEG. ',A,')  (KNOTS)   (KCAS)  ', & 
      '  (KTAS)     (PSF)              (PRESS)   (GEOM)  (FT/FT*100)', & 
      ' (DEGREES)', & 
      //)
 1023 FORMAT(2X,F10.0,F10.1,F10.0,4F10.1,F10.4,2F10.0,F10.2,F10.1)


 1024 FORMAT(5X,'FOLLOWING EACH CALCULATION, YOU WILL BE GIVEN ', & 
      'SEVERAL OPTIONS.',/, & 
      5X,'THEY ARE AS FOLLOWS:',//,5X, & 
      '1) END THE PROGRAM                              ([E]ND   )',/,5X, & 
      '2) DO ANOTHER CALCULATION USING SAME OPTION     ("RETURN")',/,5X, & 
      '3) CHANGE OPTIONS (AND ALL INPUT CHOICES)       ([O]PT   )',/,5X, & 
      '4) CHANGE TEMPERATURE UNITS ( C/F )             ([U]NITS )',/,5X, & 
      '5) CHANGE PRINT STATUS ( ON/OFF )               ([P]RINT )',/,5X, & 
      '6) CHANGE INPUT TEMP DATA TYPE (DELTA ISA/TEMP) ([T]EMP  )',/,5X, & 
      '7) CHANGE INPUT A/S DATA TYPE (CAS/TAS)         ([S]PEED )',/,5X, & 
      '8) CHANGE INPUT R/C DATA TYPE (GEOM/PRESS)      ([C]LIMB )',///, & 
      5X,'TYPE AS MANY AS YOU WISH OF OPTIONS 4-8, BUT TERMINATE',/, & 
      5X,'OR BEGIN NEW CASE BY USING OPTIONS 1-3',/)
 1025 FORMAT(5X,'WHICH OPTION?',/, & 
      5X,'[E]ND    "RETURN"  [O]PT     [U]NITS',/, & 
      5X,'[P]RINT   [T]EMP   [S]PEED   [C]LIMB',//)


 1030 FORMAT(5X,'HIT "RETURN" TO CONTINUE',/)
 1050 FORMAT(5X,'DO YOU WISH TO SEE THE LIST OF OPTIONS AGAIN ?',/)
 9000 return
      END
