! **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :  STANDARD                                *
!      Department        :  61 - flight                             *
!      Module name       :  flt_reduction                           *
!      Module description:  Reads flight test data in               *
!                           and creates IC data files from the      *
!                           data.                                   *
!      Originator        :  M. Saladin                              *
!      Date              :  12/21/98                                *
!                                                                   *
!                                                                   *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of FlightSafety International Simulation        *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!            FlightSafety International                             *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012, U.S.A.                  *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **

      subroutine flt_updateic_file(ftype,n_ic,ic_val,ic_var,itype)
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_updateic_acd.f,v 1.3 2000/03/13 22:22:15 saladinm Exp $
! $Log: flt_updateic_acd.f,v $
! Revision 1.3  2000/03/13 22:22:15  saladinm
! Slight changes to logic to support renaming of routine flt_read_ic
! ot flt_read_ic_all.

! Revision 1.2  1999/05/10 15:05:19  saladinm
! fixed something. with n_ic = 0.

! Revision 1.1  1999/02/24 19:32:54  saladinm
! Initial revision

!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_updateic_file.f,v 1.3 2000/03/13 22:22:15 saladinm Exp $"/



! * Arguments
      integer*4     n_ic                !Number of existing ICs
      integer*4     itype               !Type of output 1=update 2=overwrite

	character*4		ftype				!File suffix
      character*64  ic_var(100)          !Variables for IC input
      character*80  ic_val(100)          !value of IC input variable


! * Locals

      character*132 filename            !ACD file name
      character*64  locvar(100)          !Local version of ICs output names
      character*64  icall(200)          !Variables for IC input
      character*64  ic_set(100)         !ic set variable name
      character*64  ic_out(100)         !ic output variable name

      integer*4     i,j,k               !Loop counters
      integer*4     ist                 !IOSTAT flag
      integer*4     l1                  !Temp length of variable name
      integer*4     l2                  !Temp length of variable name
      integer*4     l3                  !Temp length of variable name
      integer*4     numap               !Number of variables in icmap.dat
      integer*4     ltype               !Local (settable) of itype

      logical*4     mantest             !Manual test flag
      logical*4     err                 !Err return flag
      logical*4     fnd                 !Variable found in icmap.dat

      real*4        icalldata(200)      !Real value of input variables IC data
      real*4        icindata(100)        !Real value of input variables IC data
      real*4        icoutdata(100)       !Real value of output variables IC data


! *   External functions

      integer*4      lrbl 
      integer*4      lran
      integer*4      rlan

! * Get things like fpath
      include "flt_plot.inc"


      ltype = itype
      call read_icmap(ic_set,ic_out,numap,err)

      if ( err ) return


! * Create full file name
      call pathfile(filename,fpath,ftestname(:lrbl(ftestname))//ftype)


! * If no existing ICs in tdf file then use all acd file ic's
      if ( n_ic .lt. 1 ) ltype = 2

      if ( ltype .eq. 1 ) then

         do i=1,n_ic
            fnd = .false.
            j = 1 
! *      Map ic set variables to ic output vars
            do while ( j .le. numap .and. .not. fnd)
               l1 = lrbl(ic_var(i))
               l2 = lrbl(ic_set(j))
               l3 = lrbl(ic_out(j))
               if ( ic_var(i)(:l1) .eq. ic_set(j)(:l2) & 
                    .and. l1 .eq. l2 ) then
                  fnd = .true.
                  if ( index(ic_out(j),'null') .gt. 0 ) then
                     locvar(i) = 'null'
                  else
                     locvar(i) = ic_out(j)
                  endif
               elseif( ic_var(i)(:l1) .eq. ic_out(j)(:l3) & 
                    .and. l1 .eq. l3 ) then
                  fnd = .true.
                  if ( index(ic_set(j),'null') .gt. 0 ) then
                     locvar(i) = 'null'
                  else
                     locvar(i) = ic_out(j)
                  endif
               endif
               j = j  + 1
            enddo
            if ( .not. fnd ) then !Variable not found in icmap.dat
               locvar(i) = ic_var(i)
            endif
         enddo
         call flt_read_ic(filename,n_ic,locvar,icindata, & 
              mantest,err)

         do i=1,n_ic
            if ( icindata(i) .ne. -999999. ) then
               write(ic_val(i),*,IOSTAT=ist) icindata(i)
            endif
         enddo
      else
!        get all ic's from ACD file
         n_ic = 0
         call flt_read_ic_all(filename,n_ic,icall,icalldata,err)

!         if ( n_ic .gt. 60 ) n_ic = 60
         if ( n_ic .gt. 100 ) n_ic = 100
         do i=1,n_ic
            write(ic_val(i),*,IOSTAT=ist) icalldata(i)
            ic_var(i) = icall(i)
         enddo

         do i=1,n_ic
            fnd = .false.
            j = 1 
! *      Map ic set variables to ic output vars
            do while ( j .le. numap .and. .not. fnd)
               l1 = lrbl(ic_var(i))
               l2 = lrbl(ic_out(j))
               if ( ic_var(i)(:l1) .eq. ic_out(j)(:l2) & 
                    .and. l1 .eq. l2 ) then
                  fnd = .true.
                  if ( index(ic_set(j),'null') .gt. 0 ) then
                     ic_val(i) = 'null'
                  else
                     ic_var(i) = ic_set(j)
                  endif
               endif
               j = j  + 1
            enddo
         enddo
      endif


      return
      end

